/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_ACCOUNTMANAGEMENTSERVICEACCESS_H_
#define OPENDRIM_ACCOUNTMANAGEMENTSERVICEACCESS_H_

#include "Simple_Identity_Management_Common.h"

#include "OpenDRIM_AccountManagementService.h"

int Simple_Identity_Management_OpenDRIM_AccountManagementService_load(const CMPIBroker* broker, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_unload(string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AccountManagementService>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AccountManagementService& instance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& newInstance, const OpenDRIM_AccountManagementService& oldInstance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, const OpenDRIM_AccountManagementService_RequestStateChange_In& in, OpenDRIM_AccountManagementService_RequestStateChange_Out& out, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_StartService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_StopService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_ChangeAffectedElementsAssignedSequence(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, const OpenDRIM_AccountManagementService_ChangeAffectedElementsAssignedSequence_In& in, OpenDRIM_AccountManagementService_ChangeAffectedElementsAssignedSequence_Out& out, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_CreateAccount(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, const OpenDRIM_AccountManagementService_CreateAccount_In& in, OpenDRIM_AccountManagementService_CreateAccount_Out& out, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementService_populate(OpenDRIM_AccountManagementService& instance, string& errorMessage);

#endif /*OPENDRIM_ACCOUNTMANAGEMENTSERVICEACCESS_H_*/
