#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Emmanuel Gil Peyrot <linkmauve@linkmauve.fr>
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Touhou 6
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220701.2

GAME_ID='touhou-6-demo'
GAME_NAME='Touhou Koumakyou ~ the Embodiment of Scarlet Devil (demo)'

ARCHIVE_BASE_0='kouma_tr013.lzh'
ARCHIVE_BASE_0_MD5='7ea4be414a7f256429a2c5e4666c9881'
ARCHIVE_BASE_0_TYPE='lha'
ARCHIVE_BASE_0_SIZE='4500'
ARCHIVE_BASE_0_VERSION='0.13-zun1'
ARCHIVE_BASE_0_URL='http://www16.big.or.jp/~zun/html/th06.html'

CONTENT_PATH_DEFAULT='東方紅魔郷　体験版'
ARCHIVE_DOC_DATA_FILES='
*.txt
マニュアル'
ARCHIVE_GAME_BIN_FILES='
*.exe'
ARCHIVE_GAME_DATA_FILES='
*.DAT'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='東方紅魔郷.exe'
APP_MAIN_ICON='東方紅魔郷.exe'

APP_CONFIG_ID="${GAME_ID}-config"
APP_CONFIG_NAME="$GAME_NAME - configuration"
APP_CONFIG_CAT='Settings'
APP_CONFIG_TYPE='wine'
APP_CONFIG_EXE='custom.exe'
APP_CONFIG_ICON='custom.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine libGL.so.1"
PKG_BIN_DEPS_DEB='fonts-wqy-microhei'
PKG_BIN_DEPS_ARCH='wqy-microhei'
PKG_BIN_DEPS_GENTOO='media-fonts/wqy-microhei'

# Set appropriate locale before running the game

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Set appropriate locale before running the game
export LANG=ja_JP.UTF-8'
APP_CONFIG_PRERUN="$APP_MAIN_PRERUN"

# Use persistent storage for user data

CONFIG_FILES='./東方紅魔郷.cfg'
DATA_FILES='./log.txt ./score.dat'
DATA_DIRS='./replay'

# convmv and iconv are used to convert files encoding

SCRIPT_DEPS="$SCRIPT_DEPS convmv iconv"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Convert the file names and text files to UTF-8 encoding

(
	cd "${PLAYIT_WORKDIR}/gamedata"
	convmv -f CP932 -t UTF-8 --notest -r . >/dev/null
	iconv_shell_command='contents=$(iconv --from-code CP932 --to-code UTF-8 "$1")'
	iconv_shell_command="$iconv_shell_command"'; printf "%s" "$contents" > "$1"'
	find . \( -name '*.txt' -o -name '*.html' \) -exec \
		sh -c "$iconv_shell_command" -- '{}' \;
)

# Include game data

prepare_package_layout

# Include game icons

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN' 'APP_CONFIG'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN' 'APP_CONFIG'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
