/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_nv_xve_h__
#define __lr10_dev_nv_xve_h__
/* This file is autogenerated.  Do not edit */
#define NV_PCFG                                         0x00088FFF:0x00088000 /* RW--D */
#define NV_XVE_ERROR_COUNTER1                                     0x00000854 /* R--4R */
#define NV_XVE_ERROR_COUNTER1_CORR_ERROR_COUNT_VALUE                    15:0 /* R-XVF */

#define NV_XVE_ERROR_COUNTER                                     0x000004AC /* R--4R */
#define NV_XVE_ERROR_COUNTER_RSVD_CORR_ERROR_COUNT_VALUE                7:0 /* C--VF */
#define NV_XVE_ERROR_COUNTER_RSVD_CORR_ERROR_COUNT_VALUE_INIT    0x00000000 /* C---V */
#define NV_XVE_ERROR_COUNTER_NON_FATAL_ERROR_COUNT_VALUE               15:8 /* R-XVF */
#define NV_XVE_ERROR_COUNTER_FATAL_ERROR_COUNT_VALUE                  23:16 /* R-XVF */
#define NV_XVE_ERROR_COUNTER_UNSUPP_REQ_COUNT_VALUE                   31:24 /* R-XVF */

#define NV_XVE_PRI_XVE_CG                          0x000004E8 /* RWI4R */
#define NV_XVE_PRI_XVE_CG_IDLE_CG_DLY_CNT                 5:0 /* RWIVF */
#define NV_XVE_PRI_XVE_CG_IDLE_CG_DLY_CNT_HWINIT   0x00000000 /* RWI-V */
#define NV_XVE_PRI_XVE_CG_IDLE_CG_DLY_CNT__PROD    0x00000004 /* RW--V */
#define NV_XVE_PRI_XVE_CG_IDLE_CG_EN                      6:6 /* RWIVF */
#define NV_XVE_PRI_XVE_CG_IDLE_CG_EN_ENABLED       0x00000001 /* RW--V */
#define NV_XVE_PRI_XVE_CG_IDLE_CG_EN_DISABLED      0x00000000 /* RWI-V */
#define NV_XVE_PRI_XVE_CG_IDLE_CG_EN__PROD         0x00000000 /* RW--V */
#define NV_XVE_PRI_XVE_CG_STATE_CG_EN                     7:7 /*       */
#define NV_XVE_PRI_XVE_CG_STATE_CG_EN_ENABLED      0x00000001 /*       */
#define NV_XVE_PRI_XVE_CG_STATE_CG_EN_DISABLED     0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_STATE_CG_EN__PROD        0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_STALL_CG_DLY_CNT               13:8 /*       */
#define NV_XVE_PRI_XVE_CG_STALL_CG_DLY_CNT_HWINIT  0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_STALL_CG_DLY_CNT__PROD   0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_STALL_CG_EN                   14:14 /* RWIVF */
#define NV_XVE_PRI_XVE_CG_STALL_CG_EN_ENABLED      0x00000001 /* RW--V */
#define NV_XVE_PRI_XVE_CG_STALL_CG_EN_DISABLED     0x00000000 /* RWI-V */
#define NV_XVE_PRI_XVE_CG_STALL_CG_EN__PROD        0x00000000 /* RW--V */
#define NV_XVE_PRI_XVE_CG_QUIESCENT_CG_EN               15:15 /*       */
#define NV_XVE_PRI_XVE_CG_QUIESCENT_CG_EN_ENABLED  0x00000001 /*       */
#define NV_XVE_PRI_XVE_CG_QUIESCENT_CG_EN_DISABLED 0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_QUIESCENT_CG_EN__PROD    0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_WAKEUP_DLY_CNT                19:16 /* RWIVF */
#define NV_XVE_PRI_XVE_CG_WAKEUP_DLY_CNT_HWINIT    0x00000000 /* RWI-V */
#define NV_XVE_PRI_XVE_CG_WAKEUP_DLY_CNT__PROD     0x00000000 /* RW--V */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_CNT                 23:20 /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_CNT_FULLSPEED  0x0000000f /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_CNT__PROD      0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_DI_DT_SKEW_VAL                27:24 /*       */
#define NV_XVE_PRI_XVE_CG_DI_DT_SKEW_VAL_HWINIT    0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_DI_DT_SKEW_VAL__PROD     0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_EN                  28:28 /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_EN_ENABLED     0x00000001 /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_EN_DISABLED    0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_EN__PROD       0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_SW_OVER             29:29 /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_SW_OVER_EN     0x00000001 /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_SW_OVER_DIS    0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_THROT_CLK_SW_OVER__PROD  0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_PAUSE_CG_EN                   30:30 /*       */
#define NV_XVE_PRI_XVE_CG_PAUSE_CG_EN_ENABLED      0x00000001 /*       */
#define NV_XVE_PRI_XVE_CG_PAUSE_CG_EN_DISABLED     0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_PAUSE_CG_EN__PROD        0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_HALT_CG_EN                    31:31 /*       */
#define NV_XVE_PRI_XVE_CG_HALT_CG_EN_ENABLED       0x00000001 /*       */
#define NV_XVE_PRI_XVE_CG_HALT_CG_EN_DISABLED      0x00000000 /*       */
#define NV_XVE_PRI_XVE_CG_HALT_CG_EN__PROD         0x00000000 /*       */

#define NV_XVE_PRI_XVE_CG1                               0x000004EC /* RWI4R */
#define NV_XVE_PRI_XVE_CG1_MONITOR_CG_EN                      0:0 /* RWIVF */
#define NV_XVE_PRI_XVE_CG1_MONITOR_CG_EN_ENABLED       0x00000001 /* RW--V */
#define NV_XVE_PRI_XVE_CG1_MONITOR_CG_EN_DISABLED      0x00000000 /* RWI-V */
#define NV_XVE_PRI_XVE_CG1_MONITOR_CG_EN__PROD         0x00000000 /* RW--V */
#define NV_XVE_PRI_XVE_CG1_SLCG                            17:1 /* RWIVF */
#define NV_XVE_PRI_XVE_CG1_SLCG_ENABLED                0x00000000 /* RW--V */
#define NV_XVE_PRI_XVE_CG1_SLCG_DISABLED               0x0001FFFF /* RWI-V */
#define NV_XVE_PRI_XVE_CG1_SLCG__PROD                  0x00000000 /* RW--V */

#define NV_XVE_CYA_2                                        0x00000704 /* RW-4R */
#define NV_XVE_CYA_2_RSVD                                         31:0 /* RWCVF */
#define NV_XVE_CYA_2_RSVD_INIT                              0x00000000 /* RWC-V */
#endif // __lr10_dev_nv_xve_h__
