#!/bin/sh

die()
{
	echo ERROR: "$*"
	exit 1
}

OS=${OS:="$(uname -s)"}

cd "$(dirname "$0")" || die
# Now in build/workspaces/ (where we assume this script resides)

# Parse command-line options:
premake_args=""

with_system_premake5=false

for i in "$@"; do
	case $i in
		--with-system-premake5) with_system_premake5=true ;;
		# Assume any other --options are for Premake
		--*) premake_args="${premake_args} $i" ;;
	esac
done

if [ "$OS" = "Darwin" ]; then
	# Set minimal SDK version
	: "${MIN_OSX_VERSION:=10.12}"
	: "${WX_CONFIG:=$(realpath ../../libraries/macos/wxwidgets/bin/wx-config)}"
	export MIN_OSX_VERSION WX_CONFIG
fi

# Now build Premake or use system's.

cd ../premake || die
premake_command="premake5"

if [ "$with_system_premake5" = "false" ]; then
	premake_command="../../libraries/source/premake-core/bin/premake5"
fi

echo

# Now run Premake to create the makefiles
echo "Premake args: ${premake_args}"
if [ "$OS" != "Darwin" ]; then
	# shellcheck disable=SC2086
	${premake_command} --file="premake5.lua" --outpath="../workspaces/gcc/" ${premake_args} gmake2 || die "Premake failed"
else
	# shellcheck disable=SC2086
	${premake_command} --file="premake5.lua" --outpath="../workspaces/gcc/" --macosx-version-min="${MIN_OSX_VERSION}" ${premake_args} gmake2 || die "Premake failed"
	# Also generate xcode workspaces if on OS X
	# shellcheck disable=SC2086
	${premake_command} --file="premake5.lua" --outpath="../workspaces/xcode4" --macosx-version-min="${MIN_OSX_VERSION}" ${premake_args} xcode4 || die "Premake failed"
fi

# test_root.cpp gets generated by cxxtestgen and passing different arguments to premake could require a regeneration of this file.
# It doesn't depend on anything in the makefiles, so make won't notice that the prebuild command for creating test_root.cpp needs to be triggered.
# We force this by deleting the file.
rm -f ../../source/test_root.cpp
