/* resultwin.c - window for displaying test results
 *
 * Copyright 2010 Petteri Hintsanen <petterih@iki.fi>
 *
 * This file is part of abx.
 *
 * abx is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * abx is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with abx.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "test.h"
#include "gtkui.h"

static GtkWidget *answers_box;
static GtkWidget *close_box;
static GtkWidget *guesses_box;
static GtkWidget *main_box;
static GtkWidget *ncorr_box;
static GtkWidget *pval_box;
static GtkWidget *window;
static GtkWidget *close_button;
static GtkWidget *answers;
static GtkWidget *guesses;

static gboolean
delete_event_handler(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    window = NULL;
    return FALSE;
}

static void
close_clicked(GtkWidget *button, gpointer data)
{
    gtk_widget_destroy(window);
    window = NULL;
}

/*
 * Create and show result window.
 */
void
show_result_window(void)
{
    GString *as;
    GString *gs;
    int i;
    int ncorr;

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "Test results");
    g_signal_connect(G_OBJECT(window), "delete_event",
                     G_CALLBACK(delete_event_handler), NULL);
    close_button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
    g_signal_connect(close_button, "clicked",
                     G_CALLBACK(close_clicked), NULL);

    /* build decision strings */
    if (get_answer(0) == get_guess(0)) ncorr = 1;
    else ncorr = 0;
    as = g_string_new(get_answer(0) == SAMPLE_A ? "<tt>A" : "<tt>B");
    gs = g_string_new(get_guess(0) == SAMPLE_A ? "<tt>A" : "<tt>B");
    for (i = 1; i < num_test_trials(); i++) {
        g_string_append(as, get_answer(i) == SAMPLE_A ? " A" : " B");
        g_string_append(gs, get_guess(i) == SAMPLE_A ? " A" : " B");
        if (get_answer(i) == get_guess(i)) ncorr++;
    }
    g_string_append(as, "</tt>");
    g_string_append(gs, "</tt>");

    answers = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL (answers), as->str);
    guesses = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL (guesses), gs->str);

    answers_box = gtk_hbox_new(FALSE, 5);
    guesses_box = gtk_hbox_new(FALSE, 5);
    ncorr_box = gtk_hbox_new(FALSE, 5);
    pval_box = gtk_hbox_new(FALSE, 5);
    close_box = gtk_hbox_new(FALSE, 5);

    gtk_box_pack_start(GTK_BOX(answers_box), 
                       gtk_label_new("Correct decisions:"), 
                       FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(answers_box), answers, FALSE, FALSE, 0);

    gtk_box_pack_start(GTK_BOX(guesses_box), 
                       gtk_label_new("Your decisions:"),
                       FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(guesses_box), guesses, FALSE, FALSE, 0);

    gtk_box_pack_start(GTK_BOX(ncorr_box),
                       gtk_label_new
                       (g_strdup_printf
                        ("Number of correct decisions: %d", ncorr)),
                       FALSE, FALSE, 0);

    gtk_box_pack_start(GTK_BOX(pval_box),
                       gtk_label_new
                       (g_strdup_printf
                        ("p-value: %f", calculate_p_value())),
                       FALSE, FALSE, 0);

    gtk_box_pack_start(GTK_BOX(close_box),
                       close_button, TRUE, FALSE, 0);

    main_box = gtk_vbox_new(FALSE, 5);
    gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
    gtk_box_pack_start(GTK_BOX(main_box), answers_box, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(main_box), guesses_box, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(main_box), ncorr_box, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(main_box), pval_box, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(main_box), close_box, TRUE, TRUE, 0);

    gtk_container_add(GTK_CONTAINER(window), main_box);
    gtk_widget_show_all(window);
}

/*
 * Hide and destroy result window.
 */
void
hide_result_window(void)
{
    if (window) {
        gtk_widget_destroy(window);
        window = NULL;
    }
}
