/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#ifndef io_H
#define io_H

#include <stdio.h>

#ifdef io_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

EXTERN void ClearWorkspace (Boolean redisplay);

EXTERN int ReadGeditFile (char *name);

EXTERN int ReadObject (FILE *f);

EXTERN int ReadMarker (FILE *f);

EXTERN int WriteGeditFile (char *name);

EXTERN void WriteObject (FILE *f, polygon_t *p);

EXTERN void WriteMarker (FILE *f, marker_t *p);

EXTERN int gedit_error (char *s);

#undef EXTERN
#endif
