// ---------------------------------------------------------------------------
// - TlsConnect.hpp                                                          -
// - afnix:tls service - tls connect class definition                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2015 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_TLSCONNECT_HPP
#define  AFNIX_TLSCONNECT_HPP

#ifndef  AFNIX_TLSPARAMS_HPP
#include "TlsParams.hpp"
#endif

#ifndef  AFNIX_TLSPROTO_HPP
#include "TlsProto.hpp"
#endif

#ifndef  AFNIX_TLSSHELLO_HPP
#include "TlsShello.hpp"
#endif

#ifndef  AFNIX_TLSCHELLO_HPP
#include "TlsChello.hpp"
#endif

namespace afnix {

  /// The TlsConnect class is the common connection class for the
  /// tls protocol. The class is designed to negotiate a tls connection
  /// which result in the generation of a tls state object. It is here
  /// the handshake is performed.
  /// @author amaury darsch

  class TlsConnect : public TlsInfos {
  protected:
    /// the server flag
    bool  d_sflg;
    /// the info plist
    Plist d_info;
    /// the tls parameters
    TlsParams d_prms;

  public:
    /// create a tls connect by server flag
    /// @param sflg the server flag
    TlsConnect (const bool sflg);

    /// @return the class name
    String repr (void) const;

    /// reset this connect object
    void reset (void);

    /// @return the info plist
    Plist getinfo (void) const;

    /// connect a tls socket by streams
    /// @param is the input stream
    /// @param os the output stream
    virtual TlsState* connect (InputStream* is, OutputStream* os);

  protected:
    /// @return the tls server state
    virtual TlsState* getss (InputStream* is, OutputStream* os);

  private:
    // make the copy constructor private
    TlsConnect (const TlsConnect&);
    // make the assignment operator private
    TlsConnect& operator = (const TlsConnect&);

  public:
    /// create a new object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);
    
    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;
    
    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
