/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 18:14:48 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JPasswordField;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleContext;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.gmod.schema.cv.CvTerm;
import org.gmod.schema.pub.PubDbXRef;
import org.gmod.schema.sequence.Feature;
import org.gmod.schema.sequence.FeatureCvTermPub;
import org.gmod.schema.sequence.FeatureLoc;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.chado.ChadoTransaction;
import uk.ac.sanger.artemis.chado.GmodDAO;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.j2ssh.SshLogin;
import uk.ac.sanger.artemis.util.ByteBuffer;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class DatabaseDocument_ESTest extends DatabaseDocument_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertNotNull(jPasswordField0);
      
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("Fy~*b[xxt=@m", jPasswordField0, "Runtime Problems...\n", "Runtime Problems...\n", false, inputStreamProgressListener0);
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.readable());
      assertEquals("Runtime Problems...\n", databaseDocument0.getSrcFeatureId());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertNotNull(jPasswordField0);
      
      ByteBuffer byteBuffer0 = new ByteBuffer();
      assertEquals(0, byteBuffer0.size());
      assertNotNull(byteBuffer0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("j1:.yP=\"!UQ.MmYoi", jPasswordField0, "j1:.yP=\"!UQ.MmYoi", "NULL", byteBuffer0, "NULL");
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertEquals(0, byteBuffer0.size());
      assertEquals("j1:.yP=\"!UQ.MmYoi", databaseDocument0.getSrcFeatureId());
      assertEquals("NULL", databaseDocument0.getName());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.readable());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      DatabaseDocument.LocationComarator databaseDocument_LocationComarator0 = databaseDocument0.new LocationComarator();
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertEquals(0, byteBuffer0.size());
      assertEquals("j1:.yP=\"!UQ.MmYoi", databaseDocument0.getSrcFeatureId());
      assertEquals("NULL", databaseDocument0.getName());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.readable());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument_LocationComarator0);
      
      FeatureLoc featureLoc0 = new FeatureLoc();
      assertNull(featureLoc0.getStrand());
      assertNull(featureLoc0.getResidueInfo());
      assertFalse(featureLoc0.isFminPartial());
      assertNull(featureLoc0.getFmax());
      assertEquals(0, featureLoc0.getRank());
      assertEquals(0, featureLoc0.getLocGroup());
      assertEquals(0, featureLoc0.getSrcFeatureId());
      assertEquals(0, featureLoc0.getFeatureLocId());
      assertNull(featureLoc0.getFmin());
      assertFalse(featureLoc0.isFmaxPartial());
      assertNull(featureLoc0.getPhase());
      assertNotNull(featureLoc0);
      
      // Undeclared exception!
      try { 
        databaseDocument_LocationComarator0.compare(featureLoc0, featureLoc0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument$LocationComarator", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      DatabaseDocument.initMDC((DatabaseDocument) null);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "AJGr+pN9", "8rn", false);
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("AJGr+pN9", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.readable());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      Vector<PubDbXRef> vector0 = new Vector<PubDbXRef>();
      assertEquals(0, vector0.size());
      assertEquals(10, vector0.capacity());
      assertTrue(vector0.isEmpty());
      assertEquals("[]", vector0.toString());
      assertNotNull(vector0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getFeaturePropByFeatureIds(vector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(0);
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertNotNull(jPasswordField0);
      
      ByteBuffer byteBuffer0 = new ByteBuffer();
      assertEquals(0, byteBuffer0.size());
      assertNotNull(byteBuffer0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("[VCFHeader:", jPasswordField0, "[VCFHeader:", "", byteBuffer0, "");
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertEquals(0, byteBuffer0.size());
      assertEquals("", databaseDocument0.getName());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertEquals("[VCFHeader:", databaseDocument0.getSrcFeatureId());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      Feature feature0 = new Feature();
      assertFalse(feature0.isAnalysis());
      assertNull(feature0.getMd5Checksum());
      assertEquals((-1), feature0.getSeqLen());
      assertNull(feature0.getUniqueName());
      assertNull(feature0.getDisplayName());
      assertFalse(feature0.isObsolete());
      assertNull(feature0.getName());
      assertEquals(0, feature0.getFeatureId());
      assertNotNull(feature0);
      
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument1 = new DatabaseDocument(databaseDocument0, "CC_", feature0, (Range) null, inputStreamProgressListener0);
      assertFalse(databaseDocument1.equals((Object)databaseDocument0));
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertEquals(0, byteBuffer0.size());
      assertEquals("", databaseDocument0.getName());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertEquals("[VCFHeader:", databaseDocument0.getSrcFeatureId());
      assertFalse(feature0.isAnalysis());
      assertNull(feature0.getMd5Checksum());
      assertEquals((-1), feature0.getSeqLen());
      assertNull(feature0.getUniqueName());
      assertNull(feature0.getDisplayName());
      assertFalse(feature0.isObsolete());
      assertNull(feature0.getName());
      assertEquals(0, feature0.getFeatureId());
      assertTrue(databaseDocument1.writable());
      assertTrue(databaseDocument1.readable());
      assertEquals("-1", databaseDocument1.getSrcFeatureId());
      assertTrue(databaseDocument1.isSingleSchema());
      assertTrue(databaseDocument1.isLazyFeatureLoad());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument1);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      String[] stringArray0 = new String[7];
      // Undeclared exception!
      try { 
        DatabaseDocument.main(stringArray0);
      
      } catch(Exception e) {
         fail("Caught exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getUpdateResiduesColumnTransactions((ChadoTransaction) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertNotNull(jPasswordField0);
      
      ByteBuffer byteBuffer0 = new ByteBuffer();
      assertEquals(0, byteBuffer0.size());
      assertNotNull(byteBuffer0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("5#KO|nfjvH(", jPasswordField0, "5#KO|nfjvH(", "r=^Mi4AcR(bhY?j", byteBuffer0, "~<raS)9%knKx@ra$H");
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertEquals(0, byteBuffer0.size());
      assertEquals("~<raS)9%knKx@ra$H", databaseDocument0.getName());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
 
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertNotNull(jPasswordField0);
      
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("{/", jPasswordField0, "", "{/", false, inputStreamProgressListener0);
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.readable());
      assertEquals("", databaseDocument0.getSrcFeatureId());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getPolypeptideFeatures("&0rQVbq`Jc)o%?uC");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("Em?9e|D'v*)\nDCt", (JPasswordField) null, "Em?9e|D'v*)\nDCt", "ID=");
      assertEquals("Em", databaseDocument0.getName());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.readable());
      assertEquals("Em?9e|D'v*)\nDCt", databaseDocument0.getSrcFeatureId());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getPartOfFeatures("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("%>!GgL>D\"eB]-=:XF#xX}KxS^nJvU");
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertNotNull(jPasswordField0);
      
      ByteBuffer byteBuffer0 = new ByteBuffer();
      assertEquals(0, byteBuffer0.size());
      assertNotNull(byteBuffer0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("%>!GgL>D\"eB]-=:XF#xX}KxS^nJvU", jPasswordField0, "%>!GgL>D\"eB]-=:XF#xX}KxS^nJvU", "%>!GgL>D\"eB]-=:XF#xX}KxS^nJvU", byteBuffer0, "");
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertEquals(0, byteBuffer0.size());
      assertEquals("%>!GgL>D\"eB]-=:XF#xX}KxS^nJvU", databaseDocument0.getSrcFeatureId());
      assertEquals("", databaseDocument0.getName());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      try { 
        databaseDocument0.getOutputStream();
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileOutputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("\nOverwite?");
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("\nOverwite?", jPasswordField0);
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.readable());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("\nOverwite", databaseDocument0.getName());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getGraphs();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", (JPasswordField) null);
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getGraphData(0, "");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("A RsEm", 0);
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("TRANSACTION COMPLETE", jPasswordField0);
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.readable());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getGffDocuments("Ro", "TRANSACTION COMPLETE", "TRANSACTION COMPLETE");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("", 0);
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertNotNull(jPasswordField0);
      
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("[EHv4Zv24->\"q", jPasswordField0, "org.biojava.bio.symbol.SingletonAlphabet", "Nb~N^C^pE;ahYiM", true, inputStreamProgressListener0);
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("org.biojava.bio.symbol.SingletonAlphabet", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getDatabaseNames();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getCvterms("mRNA", "9&\"8?X2ALSLN64,'", true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getCvtermID("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getCvtermFromGoId("a=K~S");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getCvTermByCvTermName("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getCvTermByCvPartAndCvTerm(".9DsoP6dg}~", "y]p");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getCvTermByCvAndCvTerm(":}'@A", "class=");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      assertNotNull(sshLogin0);
      
      JPasswordField jPasswordField0 = sshLogin0.getJPasswordField();
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertNotNull(jPasswordField0);
      
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("a vRz72Tycu^l{$po", jPasswordField0, "a vRz72Tycu^l{$po", "a vRz72Tycu^l{$po", true, inputStreamProgressListener0);
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertEquals("a vRz72Tycu^l{$po", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getChadoGeneByAnyCurrentName("/{t\"");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", (JPasswordField) null);
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.isSingleSchema());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.writable());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getCdsFeatureLocsByPeptideName("WjQnhM1H");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument((DatabaseDocument) null, (String) null, (String) null, false, inputStreamProgressListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("-1", 8806);
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument("-1", jPasswordField0, "-1", "-1", true, (InputStreamProgressListener) null);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(1563);
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertNotNull(jPasswordField0);
      
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument((String) null, jPasswordField0, (String) null, (String) null, false, inputStreamProgressListener0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      StyleContext styleContext0 = new StyleContext();
      assertNotNull(styleContext0);
      
      DefaultStyledDocument defaultStyledDocument0 = new DefaultStyledDocument(styleContext0);
      assertNotNull(defaultStyledDocument0);
      
      JPasswordField jPasswordField0 = new JPasswordField(defaultStyledDocument0, "x 1/10", 1595);
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument("org.biojava.bio.symbol.MergeLocation", jPasswordField0, "/RPnn95", "/RPnn95", true);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument((String) null, (JPasswordField) null, "", (String) null, false);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("Terminal Type is ");
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertNotNull(jPasswordField0);
      
      ByteBuffer byteBuffer0 = new ByteBuffer();
      assertEquals(0, byteBuffer0.size());
      assertNotNull(byteBuffer0);
      
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument("3lJK", jPasswordField0, "3lJK", "Terminal Type is ", byteBuffer0, "");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      StyleContext styleContext0 = StyleContext.getDefaultStyleContext();
      assertNotNull(styleContext0);
      
      DefaultStyledDocument defaultStyledDocument0 = new DefaultStyledDocument(styleContext0);
      assertNotNull(defaultStyledDocument0);
      
      JPasswordField jPasswordField0 = new JPasswordField(defaultStyledDocument0, (String) null, 1005);
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertNotNull(jPasswordField0);
      
      ByteBuffer byteBuffer0 = new ByteBuffer();
      assertEquals(0, byteBuffer0.size());
      assertNotNull(byteBuffer0);
      
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument((String) null, jPasswordField0, (String) null, "", byteBuffer0, (String) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument("org.apache.log4j.AppenderSkeleton", jPasswordField0, "j#kr1Vu5F", ".aw(njfF");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument((String) null, (JPasswordField) null, (String) null, "");
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("Zy+eJle7OCXNtbt?k", 0);
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument("Zy+eJle7OCXNtbt?k", jPasswordField0);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(1180);
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument((String) null, jPasswordField0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("OJ#tfLU*>0gUZ[*=", (JPasswordField) null);
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.readable());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.isSingleSchema());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getOutputStream();
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      ByteBuffer byteBuffer0 = new ByteBuffer();
      assertEquals(0, byteBuffer0.size());
      assertNotNull(byteBuffer0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("$8<8yQ([)0wrs,N@", (JPasswordField) null, "luIE{MiqBMb0", (String) null, byteBuffer0, "product=");
      assertEquals(0, byteBuffer0.size());
      assertEquals("luIE{MiqBMb0", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.readable());
      assertEquals("product=", databaseDocument0.getName());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      String string0 = databaseDocument0.getUserName();
      assertEquals("chado", string0);
      assertEquals(0, byteBuffer0.size());
      assertEquals("luIE{MiqBMb0", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.readable());
      assertEquals("product=", databaseDocument0.getName());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      PlainDocument plainDocument0 = new PlainDocument();
      assertNotNull(plainDocument0);
      
      JPasswordField jPasswordField0 = new JPasswordField(plainDocument0, "", 5696);
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertNotNull(jPasswordField0);
      
      ByteBuffer byteBuffer0 = new ByteBuffer();
      assertEquals(0, byteBuffer0.size());
      assertNotNull(byteBuffer0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "=", "", byteBuffer0, "");
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertEquals(0, byteBuffer0.size());
      assertTrue(databaseDocument0.writable());
      assertEquals("=", databaseDocument0.getSrcFeatureId());
      assertEquals("", databaseDocument0.getName());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getFeatureByUniquename("\r");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Stack<FeatureLoc> stack0 = new Stack<FeatureLoc>();
      assertTrue(stack0.isEmpty());
      assertEquals("[]", stack0.toString());
      assertEquals(10, stack0.capacity());
      assertTrue(stack0.empty());
      assertEquals(0, stack0.size());
      assertNotNull(stack0);
      
      FeatureLoc featureLoc0 = new FeatureLoc();
      assertFalse(featureLoc0.isFminPartial());
      assertEquals(0, featureLoc0.getFeatureLocId());
      assertNull(featureLoc0.getFmin());
      assertNull(featureLoc0.getStrand());
      assertEquals(0, featureLoc0.getLocGroup());
      assertNull(featureLoc0.getPhase());
      assertFalse(featureLoc0.isFmaxPartial());
      assertEquals(0, featureLoc0.getSrcFeatureId());
      assertNull(featureLoc0.getResidueInfo());
      assertEquals(0, featureLoc0.getRank());
      assertNull(featureLoc0.getFmax());
      assertNotNull(featureLoc0);
      
      boolean boolean0 = stack0.add(featureLoc0);
      assertTrue(boolean0);
      assertTrue(stack0.contains(featureLoc0));
      assertFalse(stack0.empty());
      assertEquals(10, stack0.capacity());
      assertEquals(1, stack0.size());
      assertFalse(stack0.isEmpty());
      assertFalse(featureLoc0.isFminPartial());
      assertEquals(0, featureLoc0.getFeatureLocId());
      assertNull(featureLoc0.getFmin());
      assertNull(featureLoc0.getStrand());
      assertEquals(0, featureLoc0.getLocGroup());
      assertNull(featureLoc0.getPhase());
      assertFalse(featureLoc0.isFmaxPartial());
      assertEquals(0, featureLoc0.getSrcFeatureId());
      assertNull(featureLoc0.getResidueInfo());
      assertEquals(0, featureLoc0.getRank());
      assertNull(featureLoc0.getFmax());
      
      // Undeclared exception!
      try { 
        DatabaseDocument.getFeatureLoc(stack0, 781);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      LinkedList<FeatureLoc> linkedList0 = new LinkedList<FeatureLoc>();
      assertEquals(0, linkedList0.size());
      assertNotNull(linkedList0);
      
      FeatureLoc featureLoc0 = DatabaseDocument.getFeatureLoc(linkedList0, (-401));
      assertEquals(0, linkedList0.size());
      assertNull(featureLoc0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("iAd2N", (JPasswordField) null, (String) null, "8tFlUKqC=Jwn<ZXta?m", false, inputStreamProgressListener0);
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("8tFlUKqC=Jwn<ZXta", databaseDocument0.getName());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertNull(databaseDocument0.getSrcFeatureId());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      Vector<ChadoTransaction> vector0 = new Vector<ChadoTransaction>();
      assertEquals(0, vector0.size());
      assertTrue(vector0.isEmpty());
      assertEquals(10, vector0.capacity());
      assertEquals("[]", vector0.toString());
      assertNotNull(vector0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.commit(vector0, false);

      } catch(HeadlessException e) {
    	  	fail("caught HeadlessException");
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("Build FeatureCvTerm for ", 187);
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("9&\"8?X2ALSLN64,'", jPasswordField0);
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("9&\"8", databaseDocument0.getName());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      OutputStream outputStream0 = databaseDocument0.getOutputStream();
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("9&\"8", databaseDocument0.getName());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.writable());
      assertTrue(databaseDocument0.isSingleSchema());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(outputStream0);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      boolean boolean0 = DatabaseDocument.isCvThreadAlive();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getSynonymTypeNames("EFtc zlN3F-Zcld/", (GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getCvControledCurationNames();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertNotNull(jPasswordField0);
      
      DatabaseDocument databaseDocument0 = new DatabaseDocument("*)07;Q6[nvH", jPasswordField0);
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      assertTrue(databaseDocument0.readable());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.isSingleSchema());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.writable());
      assertFalse(DatabaseDocument.CHADO_INFER_CDS);
      assertNotNull(databaseDocument0);
      
      // Undeclared exception!
      try { 
        databaseDocument0.getOrganismNames();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument(";`xTKBSr41-S", (JPasswordField) null);
      // Undeclared exception!
      try { 
        databaseDocument0.getCvTermsByCvName(";`xTKBSr41-S");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      // Undeclared exception!
      try { 
        DatabaseDocument.getCvTermByCvTermId(763, (uk.ac.sanger.artemis.io.Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("Q{(;(/1");
      ByteBuffer byteBuffer0 = new ByteBuffer();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("DjLaoDpWX_B`/v", jPasswordField0, "DjLaoDpWX_B`/v", "u>9aXl_g>_H7", byteBuffer0, "org.biojava.ontology.IntegerOntology$IntTerm");
      // Undeclared exception!
      try { 
        databaseDocument0.getInputStream();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("", 81);
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "{*Wzu{Pb7(t*YE*", "", false, inputStreamProgressListener0);
      // Undeclared exception!
      try { 
        databaseDocument0.getInputStream();
      
      } catch(Exception e) {
    	  	fail("Caught exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      JPasswordField jPasswordField0 = sshLogin0.getJPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("`O(1f", jPasswordField0, "`O(1f", "transcript");
      // Undeclared exception!
      try { 
        databaseDocument0.getName();
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      JPasswordField jPasswordField0 = sshLogin0.getJPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("a vRz72Tycu^l{$po", jPasswordField0, "a vRz72Tycu^l{$po", "transcript");
      databaseDocument0.reset();
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("a vRz72Tycu^l{$po", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.isSingleSchema());
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      PlainDocument plainDocument0 = new PlainDocument();
      JPasswordField jPasswordField0 = new JPasswordField(plainDocument0, "Setting featureId for:", 0);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("n}Sn=2Nk`^-`8_", jPasswordField0, "Setting featureId for:", "LFx*mHr3%Bg6K+r", true);
      DatabaseDocument databaseDocument1 = (DatabaseDocument)databaseDocument0.append("");
      assertEquals("Setting featureId for:", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument1.isSingleSchema());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument1.isLazyFeatureLoad());
      assertEquals("1", databaseDocument1.getSrcFeatureId());
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "", "");
      // Undeclared exception!
      try { 
        databaseDocument0.getChadoSequence("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("&aMDiu");
      DatabaseDocument databaseDocument0 = new DatabaseDocument("v4F>b$", jPasswordField0, "&aMDiu", "IzI5zBv*k");
      // Undeclared exception!
      try { 
        databaseDocument0.loadCvTerms();
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Error initializing DbSqlConfig class.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error occurred.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XML.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XPath '/sqlMapConfig/sqlMap'.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XML.  Cause: org.evosuite.runtime.TooManyResourcesException: Loop has been executed more times than the allowed 10000
         //
         verifyException("uk.ac.sanger.artemis.chado.DbSqlConfig", e);
      }
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "AJGr+pN9", "8rn", false);
      Vector<PubDbXRef> vector0 = new Vector<PubDbXRef>();
      // Undeclared exception!
      try { 
        databaseDocument0.getClustersByFeatureIds(vector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      ByteBuffer byteBuffer0 = new ByteBuffer();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("JbX?nW$r},mf", jPasswordField0, "JbX?nW$r},mf", "M=", byteBuffer0, "ve!j!dW*llvv'");
      // Undeclared exception!
      try { 
        databaseDocument0.getFeaturesByListOfIds((List) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(781);
      ByteBuffer byteBuffer0 = new ByteBuffer();
      DatabaseDocument databaseDocument0 = new DatabaseDocument(">{FPQSMXU", jPasswordField0, "xvd+68$b:,k;*3", "xvd+68$b:,k;*3", byteBuffer0, (String) null);
      databaseDocument0.getParent();
      assertEquals("xvd+68$b:,k;*3", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(" > end: ");
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("keyup", jPasswordField0, " > end: ", " > end: ", true, inputStreamProgressListener0);
      databaseDocument0.setName("keyup");
      assertEquals("keyup", databaseDocument0.getName());
      assertEquals(" > end: ", databaseDocument0.getSrcFeatureId());
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("Build FeatureCvTerm for ", 187);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("9&\"8?X2ALSLN64,'", jPasswordField0);
      DatabaseDocument databaseDocument1 = databaseDocument0.createDatabaseDocument();
      assertEquals("1", databaseDocument1.getSrcFeatureId());
      assertTrue(databaseDocument1.isLazyFeatureLoad());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument1.isSingleSchema());
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("##sequence-region ", (JPasswordField) null, "BUILD GENE GFF LINE", "C,7z");
      boolean boolean0 = databaseDocument0.isLazyFeatureLoad();
      assertTrue(boolean0);
      assertTrue(databaseDocument0.isSingleSchema());
      assertEquals("BUILD GENE GFF LINE", databaseDocument0.getSrcFeatureId());
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      JPasswordField jPasswordField0 = sshLogin0.getJPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("xp0<5vQ]wMZ", jPasswordField0, "", "z?_", true);
      // Undeclared exception!
      try { 
        databaseDocument0.getOrganismByCommonName("z?_");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test61()  throws Throwable  {
      String[][][] stringArray0 = DatabaseDocument.getTYPES();
      assertEquals(3, stringArray0.length);
  }

  @Test(timeout = 4000)
  public void test62()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(0);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("0`X,h", jPasswordField0, "", "0`X,h", true);
      // Undeclared exception!
      try { 
        databaseDocument0.getFeatureLocsByListOfIds((List) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test63()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("##sequence-region ", (JPasswordField) null, "BUILD GENE GFF LINE", "C,7z");
      boolean boolean0 = databaseDocument0.readable();
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(boolean0);
      assertEquals("BUILD GENE GFF LINE", databaseDocument0.getSrcFeatureId());
  }

  @Test(timeout = 4000)
  public void test64()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("Z^aNxQ]w{h6I", 0);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("bM`<5QvZk?'w7vu}", jPasswordField0);
      databaseDocument0.setReadChildren(true);
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.isSingleSchema());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
  }

  @Test(timeout = 4000)
  public void test65()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("K*@%tvdtc<>", jPasswordField0);
      // Undeclared exception!
      try { 
        databaseDocument0.showCvTermLookUp();
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Error initializing DbSqlConfig class.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error occurred.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XML.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XPath '/sqlMapConfig/sqlMap'.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XML.  Cause: org.evosuite.runtime.TooManyResourcesException: Loop has been executed more times than the allowed 10000
         //
         verifyException("uk.ac.sanger.artemis.chado.DbSqlConfig", e);
      }
  }

  @Test(timeout = 4000)
  public void test66()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("*)07;Q6[nvH", jPasswordField0);
      databaseDocument0.getIdFeatureStore();
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
  }

  @Test(timeout = 4000)
  public void test67()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("");
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, ">", ">", true, inputStreamProgressListener0);
      Range range0 = new Range((-1148));
      databaseDocument0.setRange(range0);
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.isSingleSchema());
      assertEquals(">", databaseDocument0.getSrcFeatureId());
  }

  @Test(timeout = 4000)
  public void test68()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("w<:", (JPasswordField) null, "##gff-version 3\n", "System");
      ArrayList<FeatureCvTermPub> arrayList0 = new ArrayList<FeatureCvTermPub>();
      // Undeclared exception!
      try { 
        databaseDocument0.getParentFeaturesByChildFeatureIds(arrayList0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test69()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("Build FeatureCvTerm for ", 187);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("9&\"8?X2ALSLN64,'", jPasswordField0);
      // Undeclared exception!
      try { 
        databaseDocument0.getOrganismsContainingSrcFeatures();
        
      
      } catch(Exception e) {
    	  	fail("caught exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test70()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("Build FeatureCvTerm for ", 187);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("9&\"8?X2ALSLN64,'", jPasswordField0);
      boolean boolean0 = databaseDocument0.isSingleSchema();
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test71()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("getCvTermsByCvName LOADING CVTERMS", (JPasswordField) null, "Unknown topology: ", "getCvTermsByCvName LOADING CVTERMS", false);
      // Undeclared exception!
      try { 
        databaseDocument0.getFeatureDbXRefsByFeatureId((List) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test72()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      JPasswordField jPasswordField0 = sshLogin0.getJPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("a vRz72Tycu^l{$po", jPasswordField0, "a vRz72Tycu^l{$po", "transcript");
      // Undeclared exception!
      try { 
        databaseDocument0.ping();
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Error initializing DbSqlConfig class.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error occurred.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XML.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XPath '/sqlMapConfig/sqlMap'.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XML.  Cause: org.evosuite.runtime.TooManyResourcesException: Loop has been executed more times than the allowed 10000
         //
         verifyException("uk.ac.sanger.artemis.chado.DbSqlConfig", e);
      }
  }

  @Test(timeout = 4000)
  public void test73()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("");
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "", "3", true);
      String string0 = databaseDocument0.getSrcFeatureId();
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test74()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(0);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("/|IA77&", jPasswordField0);
      boolean boolean0 = databaseDocument0.writable();
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(boolean0);
      assertTrue(databaseDocument0.isSingleSchema());
  }

  @Test(timeout = 4000)
  public void test75()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("##sequence-region ", (JPasswordField) null, "BUILD GENE GFF LINE", "C,7z");
      // Undeclared exception!
      try { 
        databaseDocument0.getCdsFeatureLocsByTranscriptName("##sequence-region ");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
       
      }
  }

  @Test(timeout = 4000)
  public void test76()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0);
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument1 = new DatabaseDocument(databaseDocument0, "RILEY", "", false, inputStreamProgressListener0);
      assertEquals("1", databaseDocument0.getSrcFeatureId());
      assertEquals("RILEY", databaseDocument1.getSrcFeatureId());
      assertTrue(databaseDocument0.isSingleSchema());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument1.isLazyFeatureLoad());
      assertTrue(databaseDocument1.isSingleSchema());
  }

  @Test(timeout = 4000)
  public void test77()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0);
      // Undeclared exception!
      try { 
        databaseDocument0.append("#fs");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test78()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", (JPasswordField) null, "", "");
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL;
      // Undeclared exception!
      try { 
        databaseDocument0.getResidueFeatures(integer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test79()  throws Throwable  {
      String[][][] stringArray0 = new String[0][7][3];
      DatabaseDocument.setTYPES(stringArray0);
      String[][][] stringArray1 = DatabaseDocument.getTYPES();
      assertSame(stringArray1, stringArray0);
  }

  @Test(timeout = 4000)
  public void test80()  throws Throwable  {
      DatabaseDocument databaseDocument0 = new DatabaseDocument("##sequence-region ", (JPasswordField) null, "BUILD GENE GFF LINE", "C,7z");
      databaseDocument0.setLazyFeatureLoad(true);
      assertEquals("BUILD GENE GFF LINE", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
      assertTrue(databaseDocument0.isSingleSchema());
  }

  @Test(timeout = 4000)
  public void test81()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(0);
      ByteBuffer byteBuffer0 = new ByteBuffer();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "GO_REF", "GO_REF", byteBuffer0, (String) null);
      // Undeclared exception!
      try { 
        databaseDocument0.insertCvTerm((CvTerm) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test82()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("", 15);
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("[EHv4Zv24->\"q", jPasswordField0, "org.biojava.bio.symbol.SingletonAlphabet", "[=", true, inputStreamProgressListener0);
      DatabaseDocument.CvTermThread databaseDocument_CvTermThread0 = databaseDocument0.new CvTermThread((GmodDAO) null);
      databaseDocument_CvTermThread0.run();
      assertTrue(databaseDocument0.isSingleSchema());
      assertEquals("org.biojava.bio.symbol.SingletonAlphabet", databaseDocument0.getSrcFeatureId());
      assertTrue(databaseDocument0.isLazyFeatureLoad());
  }
}
