<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Contact/Relationship.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:a5a833da9d5016f0aeb06ba7c1058b3c)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Contact_DAO_Relationship constructor.
 */
class CRM_Contact_DAO_Relationship extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_relationship';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Relationship ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * id of the first contact
   *
   * @var int unsigned
   */
  public $contact_id_a;
  /**
   * id of the second contact
   *
   * @var int unsigned
   */
  public $contact_id_b;
  /**
   * id of the relationship
   *
   * @var int unsigned
   */
  public $relationship_type_id;
  /**
   * date when the relationship started
   *
   * @var date
   */
  public $start_date;
  /**
   * date when the relationship ended
   *
   * @var date
   */
  public $end_date;
  /**
   * is the relationship active ?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Optional verbose description for the relationship.
   *
   * @var string
   */
  public $description;
  /**
   * is contact a has permission to view / edit contact and
   related data for contact b ?
   *
   * @var boolean
   */
  public $is_permission_a_b;
  /**
   * is contact b has permission to view / edit contact and
   related data for contact a ?
   *
   * @var boolean
   */
  public $is_permission_b_a;
  /**
   * FK to civicrm_case
   *
   * @var int unsigned
   */
  public $case_id;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_relationship';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id_a', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id_b', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'relationship_type_id', 'civicrm_relationship_type', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'case_id', 'civicrm_case', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Relationship ID') ,
          'description' => 'Relationship ID',
          'required' => true,
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
        ) ,
        'contact_id_a' => array(
          'name' => 'contact_id_a',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact A') ,
          'description' => 'id of the first contact',
          'required' => true,
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ) ,
        'contact_id_b' => array(
          'name' => 'contact_id_b',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact B') ,
          'description' => 'id of the second contact',
          'required' => true,
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => array(
            'type' => 'EntityRef',
          ) ,
        ) ,
        'relationship_type_id' => array(
          'name' => 'relationship_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Relationship Type') ,
          'description' => 'id of the relationship',
          'required' => true,
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_RelationshipType',
          'html' => array(
            'type' => 'Select',
          ) ,
        ) ,
        'start_date' => array(
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Relationship Start Date') ,
          'description' => 'date when the relationship started',
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'end_date' => array(
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Relationship End Date') ,
          'description' => 'date when the relationship ended',
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Relationship Is Active') ,
          'description' => 'is the relationship active ?',
          'default' => '1',
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Relationship Description') ,
          'description' => 'Optional verbose description for the relationship.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'is_permission_a_b' => array(
          'name' => 'is_permission_a_b',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Contact A has Permission Over Contact B') ,
          'description' => 'is contact a has permission to view / edit contact and
      related data for contact b ?
    ',
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'is_permission_b_a' => array(
          'name' => 'is_permission_b_a',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Contact B has Permission Over Contact A') ,
          'description' => 'is contact b has permission to view / edit contact and
      related data for contact a ?
    ',
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'case_id' => array(
          'name' => 'case_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Relationship Case') ,
          'description' => 'FK to civicrm_case',
          'default' => 'NULL',
          'table_name' => 'civicrm_relationship',
          'entity' => 'Relationship',
          'bao' => 'CRM_Contact_BAO_Relationship',
          'localizable' => 0,
          'FKClassName' => 'CRM_Case_DAO_Case',
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'relationship', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'relationship', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array();
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
