/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *         building on original work by Thomas Nowotny <tnowotny@ucsd.edu>
 *
 * License: GPL-2+
 *
 * Initial version: 2009-03-31
 *
 */


#ifndef LIBCN_HOSTED_ATTR_H
#define LIBCN_HOSTED_ATTR_H

#include <vector>

#include "config.h"

using namespace std;

namespace CNRun {

class C_HostedAttributes {

    friend class CIntegrateRK65;

    protected:
	C_HostedAttributes()
		{}

    friend class CModel;
      // variables for units in the model are catenated on a single
      // vector<double>, as an essential optimization measure; each
      // unit knows its own set of variables by this idx:
	size_t idx;
      // the containing model provides idx on registering our unit

    public:
	virtual void reset_vars() = 0;
	virtual double &var_value( size_t) = 0;

	virtual void derivative( vector<double>&, vector<double>&) = 0;
};

}

#endif

// EOF
