/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 *
 * Use is subject to the GNU General Public License, Version 2,
 * June 1991, which is contained in the read-me file named
 * "README_GNU_GPL." This program is free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your
 * option) any later version. This library is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include "lcd.h"
#include "lcdutils.h"


void timeout_handler(int sig) {
  exit(RET_TIMEOUT);
}


int main(int argc, char *argv[]) {
	void *lcd;
	int silent = 0;
	char line1[40], line2[40];
	int button, address;
	
	int ctr=0;
	int i, j;
	int yes_adr = 0;
	int no_adr = 0;
	int spots[10];
	int args = argc;
	char **vp = &argv[0];
	
	lcd_setlocale();
	
	while (--args > 0) {
		vp++;
		if ((**vp) != '-') break;
		switch (*((*vp)+1)) {
			case 'y':
				vp++; args--;
				sscanf(*vp,"%x",&yes_adr);
				break;
			
			case 'n':
				vp++; args--;
				sscanf(*vp,"%x",&no_adr);
				break;
			
			case '1':
				vp++; args--;
				strcpy(line1,*vp);
				break;
			
			case '2':
				vp++; args--;
				strcpy(line2,*vp);
				break;
			
			case 's':
				silent++;
				break;
			
			case 'h':
				printf(_("Usage: %s [-y <pos>] [-n <pos>] [-1 <line text>] [-2 <line text>]\n"),argv[0]);
				exit(0);
			
			default:
				printf(_("Unknown switch %s\n"),*vp);
				exit(0);
		}
	}
	
	if (!silent && (lcd_lock() < 0)) {
		printf(_("LCD in use... try again later\n"));
		exit(0);
	}
	
	strcpy(line1, _("Is this Correct?"));
	strcpy(line2, _("  [Y]ES  [N]O   "));
	
	if ((lcd = lcd_open(O_RDWR)) == NULL) {
		printf(_("LCD is not present\n"));
		exit(0);
	}
	
	memset(spots, 0, sizeof(spots));
	
	j = 0;
	for (i=0; i<14; i++) {
		if (line1[i] == '[' && line1[i+2] == ']') {
			spots[j++] = i + kDD_R00 + 1;
		}
	}
	for (i=0; i<14; i++) {
		if (line2[i] == '[' && line2[i+2] == ']') {
			spots[j++] = i + kDD_R10 + 1;
		}
	}
	if (yes_adr == 0) {
		if (spots[0] != 0) {
			yes_adr = spots[0];
		} else {
			yes_adr = CURSOR_YES;
		}
	}
	if (no_adr == 0) {
		if (spots[1] != 0) {
			no_adr = spots[1];
		} else {
			no_adr = CURSOR_NO;
		}
	}
	
	lcd_reset(lcd);
	ctr=0;
	
	lcd_write(lcd, line1, line2);
	lcd_set(lcd, LCD_Cursor_On);
	lcd_setcursorpos(lcd, no_adr);
	
	while( 1 ) {
		lcd_timeout_start(timeout_handler, MAX_IDLE_TIME);
		button = lcd_readbutton(lcd) & 0x00FF;
		if ( (button != BUTTON_NONE) && (button != BUTTON_NONE_B) ) {
			ctr++;
			
			if ( (ctr==lcd_button_debounce(lcd)) ) {
				lcd_timeout_stop();
				
				switch (button) {
					case BUTTON_Next:
					case BUTTON_Next_B:
					case BUTTON_Up:
					case BUTTON_Up_B:
					case BUTTON_Down:
					case BUTTON_Down_B:
					case BUTTON_Left:
					case BUTTON_Left_B:
					case BUTTON_Right:
					case BUTTON_Right_B:
						address = lcd_getcursorpos(lcd);
						lcd_setcursorpos(lcd, address == no_adr ? yes_adr : no_adr);
						break;
					
					case BUTTON_Enter:
					case BUTTON_Enter_B:
						address = lcd_getcursorpos(lcd);
						lcd_close(lcd);
						if (!silent)
							lcd_unlock();
						exit((address == yes_adr) ? RET_YES : RET_NO);
						break;
				}
			}
			if (ctr==lcd_button_sense(lcd)) {
				ctr=0;
			}
		} else {
			ctr=0;
		}
	}
}
