(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    204717,       4263]
NotebookOptionsPosition[    204086,       4241]
NotebookOutlinePosition[    204708,       4263]
CellTagsIndexPosition[    204665,       4260]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Routines", " ", "--"}], "--"}], 
                    "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "-", 
    RowBox[{"-", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
   "*)"}], "\[IndentingNewLine]", 
  StyleBox["\n", "Code"], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Routine", " ", "generating", " ", "the", " ", "remnant", " ", "sequence",
      " ", "for", " ", "a", " ", "given", " ", "element", " ", 
     RowBox[{"Q", ".", " ", "It"}], " ", "returns", " ", "also", " ", "the", 
     " ", "positions", " ", "of", " ", "the", " ", "element", " ", "in", " ", 
     "the", " ", "Q"}], "-", "list"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"sequenceneu", "[", "Qtemp_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "positionsliste", ",", " ", "tmpsequence"}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tmpsequence", " ", "=", " ", 
         RowBox[{"Array", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"0", "^", "#"}], "&"}], ",", 
           RowBox[{"maxcdegree", "-", "mincdegree", "+", "1"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"positionsliste", "=", 
         RowBox[{"Position", "[", 
          RowBox[{"fullQlist", ",", "Qtemp"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", "positionsliste", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tmpsequence", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"fullcdegreelist", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"positionsliste", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "-", 
              "mincdegree", "+", "1"}], "]"}], "]"}], "++"}]}], " ", 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"tmpsequence", ",", "positionsliste"}], "}"}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Routine", " ", "that", " ", "tests", " ", "wether", " ", "the", " ", 
     "given", " ", "complex", " ", "is", " ", "exact", " ", "or", " ", "not", 
     " ", "and", " ", "returns", " ", "true", " ", "or", " ", "false", " ", 
     "as", " ", "well", " ", "as", " ", "a", " ", "possible", " ", 
     "candidate", " ", "to", " ", "fix", " ", "the", " ", "complex"}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"isexact", "[", "complex_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "i", ",", "kern", ",", "exakt", ",", "n", ",", "fullcomplex"}], "}"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"fullcomplex", "=", "complex"}], ";", "\[IndentingNewLine]", 
        RowBox[{"n", "=", 
         RowBox[{"Length", "[", "fullcomplex", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"exakt", "=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"kern", "=", 
         RowBox[{"fullcomplex", "[", 
          RowBox[{"[", "n", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<", "n"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"kern", "=", 
            RowBox[{
             RowBox[{"fullcomplex", "[", 
              RowBox[{"[", 
               RowBox[{"n", "-", "i"}], "]"}], "]"}], "-", "kern"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"kern", "<", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Return", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Superscript", "[", 
                  RowBox[{"\"\<h\>\"", ",", 
                   RowBox[{
                   "n", "-", "i", "+", "1", "+", "mincdegree", "-", "1"}]}], 
                  "]"}], ",", 
                 RowBox[{"-", "kern"}], ",", "False"}], "}"}], "]"}], ";", 
              RowBox[{"kern", "=", "0"}], ";", 
              RowBox[{"exakt", "=", "0"}]}]}], " ", "\[IndentingNewLine]", 
            "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"exakt", "\[Equal]", "1"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<h\>\"", ",", "0", ",", "True"}], "}"}], "]"}]}], 
         "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Routine", " ", "that", " ", "returns", " ", "all", " ", "possible", " ",
       "cohomology", " ", "groups", " ", "to", " ", "a", " ", "given", " ", 
      "complex"}], ",", " ", 
     RowBox[{
     "taking", " ", "the", " ", "dimension", " ", "of", " ", "the", " ", 
      "variety", " ", "into", " ", "account"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CohomsOf", "[", 
      RowBox[{"sequence_", ",", "startdim_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "result", ",", "tempsequence"}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"result", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"altersum", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", "sequence", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"altersum", "=", 
            RowBox[{"altersum", " ", "+", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", "i"}], "*", 
              RowBox[{"sequence", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"altersum", "=", 
         RowBox[{"Abs", "[", "altersum", "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", 
           RowBox[{"1", "-", "startdim"}]}], ",", 
          RowBox[{"i", "\[LessEqual]", 
           RowBox[{"1", "-", "startdim", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Length", "[", "equivalencerelations", "]"}], "-", 
              RowBox[{"Length", "[", 
               RowBox[{"equivalencerelations", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ")"}]}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"sequence", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[GreaterEqual]", " ", 
              "altersum"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tempsequence", "=", "sequence"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"tempsequence", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "=", 
               RowBox[{
                RowBox[{"tempsequence", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "-", "altersum"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"isexact", "[", "tempsequence", "]"}], "[", 
                 RowBox[{"[", "3", "]"}], "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"AppendTo", "[", 
                  RowBox[{"result", ",", 
                   RowBox[{"{", 
                    RowBox[{"h", ",", 
                    RowBox[{"i", "-", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "startdim"}], ")"}]}], ",", 
                    "altersum"}], "}"}]}], "]"}], ";"}]}], 
               "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
            "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "result", "]"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Subroutine", " ", "the", " ", "converts", " ", "a", " ", "set", " ", 
       "of", " ", "coordinates", " ", "into", " ", "their", " ", "positions", 
       " ", "in", " ", "the", " ", "coordinate"}], "-", "list"}], ",", " ", 
     RowBox[{
      RowBox[{"e", ".", "g", ".", " ", 
       RowBox[{"{", 
        RowBox[{"u1", ",", "u2"}], "}"}]}], " ", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConvertDenominatiorElement", "[", "element_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "convertedelement"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"convertedelement", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", "element", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"convertedelement", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Position", "[", 
                RowBox[{"coordinates", ",", 
                 RowBox[{"element", "[", 
                  RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], " ", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "convertedelement", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Subroutine", ":", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Generates", " ", "the", " ", "expression", " ", "u1"}], 
         "\[GreaterEqual]", "0"}], " ", "&&", " ", 
        RowBox[{"u2", "\[GreaterEqual]", "0"}], " ", "&&", " ", 
        RowBox[{"u3", "\[GreaterEqual]", "0"}], " ", "&&"}], " ", "..."}], 
      " ", "from", " ", "a", " ", "given", " ", "set", " ", "of", " ", 
      "coordinates", " ", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3", ",", "..."}], "}"}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ListElementsLargerEqZero", "[", "list_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "temp"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"list", "\[NotEqual]", " ", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{"temp", "=", 
           RowBox[{
            RowBox[{"list", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", " ", "0"}]}], 
          ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "2"}], ",", 
          RowBox[{"i", "\[LessEqual]", 
           RowBox[{"Length", "[", "list", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{"temp", "=", 
           RowBox[{"temp", " ", "&&", " ", 
            RowBox[{
             RowBox[{"list", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "\[GreaterEqual]", " ", 
             "0"}]}]}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "temp", "]"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Main", " ", "counting", " ", 
      RowBox[{"routing", ":", " ", 
       RowBox[{
       "It", " ", "generates", " ", "the", " ", "matrix", " ", "m"}]}]}], ",",
      " ", 
     RowBox[{
      RowBox[{
      "the", " ", "constant", " ", "vector", " ", "b", " ", "and", " ", 
       "solves", " ", "the", " ", "linear", " ", "equations", " ", 
       RowBox[{"m", ".", "x"}]}], "=", 
      RowBox[{
      "b", " ", "for", " ", "non", " ", "negative", " ", "integers"}]}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RationomsOf", "[", "DenominatorElement_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "b", ",", "m", ",", "ConvertedElement"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ConvertedElement", "=", 
         RowBox[{
         "ConvertDenominatiorElement", "[", "DenominatorElement", "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"m", "=", "equrel"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", 
           RowBox[{"Length", "[", "equrel", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"j", "=", "1"}], ",", 
             RowBox[{"j", "\[LessEqual]", 
              RowBox[{"Length", "[", 
               RowBox[{"equrel", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
             RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"ConvertedElement", ",", "j"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "j", "]"}], "]"}], "=", 
                 RowBox[{"-", 
                  RowBox[{
                   RowBox[{"equrel", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                   RowBox[{"[", "j", "]"}], "]"}]}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"(*", "else", "*)"}], " ", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "j", "]"}], "]"}], "=", 
                 RowBox[{
                  RowBox[{"equrel", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "j", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
               "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"b", "=", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Sum", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"m", "[", 
                  RowBox[{"[", "#", "]"}], "]"}], "[", 
                 RowBox[{"[", "j", "]"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "ConvertedElement"}], "}"}]}], "]"}]}], 
             "&"}], ",", 
            RowBox[{"Length", "[", "Qcharges", "]"}]}], "]"}], "+", 
          "Qcharges"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{
            RowBox[{"Reduce", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"m", ".", "coordinates"}], "==", "b"}], "&&", 
               RowBox[{
               "ListElementsLargerEqZero", "[", "coordinates", "]"}]}], ",", 
              "coordinates", ",", "Integers"}], "]"}], "||", 
            RowBox[{"{", "\"\<dummy\>\"", "}"}]}], "]"}], "-", "1"}], 
         "]"}]}]}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Here", " ", "the", " ", "equation", " ", "is", " ", 
        RowBox[{"solved", ".", " ", "The"}], " ", "\"\<dummy\>\"", " ", "has",
         " ", "to", " ", "be", " ", "added", " ", "and", " ", "removed", " ", 
        "from", " ", "the", " ", "number", " ", "of", " ", "solutions", " ", 
        "in", " ", "order", " ", "to", " ", "avoid", " ", "that", " ", "only",
         " ", "one", " ", "solution", " ", "exists"}], "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Converts", " ", "a", " ", "list", " ", "into", " ", "a", " ", "string"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ListToString", "[", "listinput_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "i"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"a", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", 
           RowBox[{"Length", "[", "listinput", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{"a", "=", 
           RowBox[{"StringJoin", "[", 
            RowBox[{"a", ",", 
             RowBox[{"ToString", "[", 
              RowBox[{"listinput", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}]}], " ", "]"}]}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "a", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Main"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
     " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"routines", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Main"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
     " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"routines", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "*)"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Main"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
     " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"routines", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "*)"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Main"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
     " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"routines", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Main", " ", "routine", " ", "1"}], ":", " ", 
     RowBox[{
      RowBox[{
      "Generates", " ", "first", " ", "the", " ", "List", " ", "of", " ", 
       "all", " ", "possible", " ", 
       RowBox[{"Q", "'"}], "s", " ", "and", " ", "the", " ", "corresponding", 
       " ", "c"}], "-", 
      RowBox[{
      "degrees", " ", "and", " ", "afterwards", " ", "a", " ", "list", " ", 
       "of", " ", "all", " ", "secondary", " ", "sequences", " ", "that", " ",
        "may", " ", "appear"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GenerateSecondarySequences", "[", "varietyin_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "ii", ",", "kk"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"coordinates", "=", 
         RowBox[{"varietyin", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"SR", "=", 
         RowBox[{"varietyin", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"equivalencerelations", "=", 
         RowBox[{"varietyin", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dim", "=", 
         RowBox[{
          RowBox[{"Length", "[", "coordinates", "]"}], "-", 
          RowBox[{"Length", "[", 
           RowBox[{"equivalencerelations", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"numberofvertices", "=", 
         RowBox[{"Length", "[", "coordinates", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"equrel", "=", 
         RowBox[{"Transpose", "[", "equivalencerelations", "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Generate", " ", "the", " ", "lists", " ", "of", " ", 
           RowBox[{"Q", "'"}], "s", " ", "and", " ", "c"}], "-", "degrees"}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
          RowBox[{"DateList", "[", "]"}], ",", 
          "\"\< ---- Part 1: Creating Q and c-degree lists\>\""}], "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"d", "=", 
         RowBox[{"DateList", "[", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"fullQlist", "=", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Union", "[", 
               RowBox[{"Flatten", "[", "#", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"Length", "[", 
                RowBox[{"Union", "[", 
                 RowBox[{"Flatten", "[", "#", "]"}], "]"}], "]"}], "-", 
               RowBox[{"Length", "[", "#", "]"}]}]}], "}"}], "&"}], ",", 
           RowBox[{"Subsets", "[", "SR", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"fullcdegreelist", "=", 
         RowBox[{
          RowBox[{"Delete", "[", 
           RowBox[{"fullQlist", ",", 
            RowBox[{"{", "1", "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"fullQlist", "=", 
         RowBox[{
          RowBox[{"Delete", "[", 
           RowBox[{"fullQlist", ",", 
            RowBox[{"{", "1", "}"}]}], "]"}], " ", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "1", ",", "All"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"dneu", "=", 
         RowBox[{"DateList", "[", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Listing done within \>\"", ",", 
          RowBox[{
           RowBox[{"AbsoluteTime", "[", "dneu", "]"}], "-", 
           RowBox[{"AbsoluteTime", "[", "d", "]"}]}], ",", 
          "\"\< seconds\>\""}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"maxsequencesize", " ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Length", "[", "SR", "]"}], "-", "2"}], ")"}], "+", 
          RowBox[{"(", 
           RowBox[{"numberofvertices", "-", "1"}], ")"}], "+", "1"}]}], " ", 
        ";", "\[IndentingNewLine]", 
        RowBox[{"mincdegree", "=", 
         RowBox[{"2", "-", 
          RowBox[{"Length", "[", "SR", "]"}]}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"maxcdegree", "=", 
         RowBox[{"numberofvertices", "-", "1"}]}], ";", "\[IndentingNewLine]",
         "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "Generate", " ", "the", " ", "list", " ", "of", " ", "possible", 
           " ", "secondary", " ", "sequences", " ", "for", " ", "all", " ", 
           "various", " ", "elements", " ", "in", " ", "the", " ", "Q"}], "-",
           "list"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
          RowBox[{"DateList", "[", "]"}], ",", 
          "\"\< ---- Part 2: Generating remnant sequences\>\""}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"d", "=", 
         RowBox[{"DateList", "[", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"sortierttupel", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"report", "=", "19"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", " ", 
           RowBox[{"2", "^", 
            RowBox[{"Length", "[", "coordinates", "]"}]}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"fullQlist", "\[NotEqual]", 
              RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"report", "++"}], ";", "\[IndentingNewLine]", 
              RowBox[{"tempQ", "=", 
               RowBox[{"fullQlist", "[", 
                RowBox[{"[", 
                 RowBox[{"Length", "[", "fullQlist", "]"}], "]"}], "]"}]}], 
              ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"!", 
                 RowBox[{"MemberQ", "[", 
                  RowBox[{"sortierttupel", ",", "tempQ", ",", "3"}], "]"}]}], 
                ",", " ", 
                RowBox[{"(*", 
                 RowBox[{
                 "Tests", " ", "wether", " ", "the", " ", "element", " ", 
                  "is", " ", "not", " ", "yet", " ", "in", " ", "the", " ", 
                  "list"}], "*)"}], "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"tempsequence", "=", 
                  RowBox[{
                   RowBox[{"sequenceneu", "[", "tempQ", "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"tmppositionslist", "=", 
                  RowBox[{
                   RowBox[{"sequenceneu", "[", "tempQ", "]"}], "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"MemberQ", "[", 
                    RowBox[{"sortierttupel", ",", "tempsequence", ",", "2"}], 
                    "]"}], ",", " ", 
                   RowBox[{"(*", 
                    RowBox[{
                    "Tests", " ", "wether", " ", "the", " ", "sequence", " ", 
                    "already", " ", "appeared", " ", "earlier"}], " ", "*)"}],
                    "\[IndentingNewLine]", 
                   RowBox[{"AppendTo", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Position", "[", 
                    RowBox[{"sortierttupel", ",", "tempsequence"}], "]"}], 
                    "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "tempQ"}], "]"}], 
                   "\[IndentingNewLine]", 
                   RowBox[{"(*", "else", "*)"}], ",", 
                   RowBox[{"AppendTo", "[", 
                    RowBox[{"sortierttupel", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", "tempQ", "}"}], ",", "tempsequence"}], 
                    "}"}]}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"fullQlist", "=", 
                  RowBox[{"Delete", "[", 
                   RowBox[{"fullQlist", ",", "tmppositionslist"}], "]"}]}], 
                 ";", "\[IndentingNewLine]", 
                 RowBox[{"fullcdegreelist", "=", 
                  RowBox[{"Delete", "[", 
                   RowBox[{"fullcdegreelist", ",", "tmppositionslist"}], 
                   "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"report", "\[Equal]", "20"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"NotebookDelete", "[", "temp", "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"dneu", "=", 
                    RowBox[{"DateList", "[", "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"a", "=", 
                    RowBox[{"ListToString", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"2", "^", 
                    RowBox[{"Length", "[", "SR", "]"}]}], "-", 
                    RowBox[{"Length", "[", "fullQlist", "]"}], "-", "1"}], 
                    ",", "\"\< elements from Q-list done within \>\"", ",", 
                    RowBox[{
                    RowBox[{"AbsoluteTime", "[", "dneu", "]"}], "-", 
                    RowBox[{"AbsoluteTime", "[", "d", "]"}]}], ",", 
                    "\"\< seconds\>\""}], "}"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"report", "=", "0"}], ";", "\[IndentingNewLine]", 
                    
                    RowBox[{"temp", "=", 
                    RowBox[{"PrintTemporary", "[", "a", "]"}]}], ";"}]}], 
                  "\[IndentingNewLine]", "]"}], ";"}]}], 
               "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
            "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sortierttupelsave", "=", "sortierttupel"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"dneu", "=", 
         RowBox[{"DateList", "[", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Generating done within: \>\"", ",", 
          RowBox[{
           RowBox[{"AbsoluteTime", "[", "dneu", "]"}], "-", 
           RowBox[{"AbsoluteTime", "[", "d", "]"}]}], ",", 
          "\"\< seconds\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"End", " ", "of", " ", "routine"}], "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
       RowBox[{
       "Subroutine", " ", "of", " ", "main", " ", "routine", " ", "2"}], ":", 
       " ", 
       RowBox[{
       "Tests", " ", "which", " ", "secondary", " ", "sequences", " ", "and", 
        " ", "their", " ", "corresponding", " ", "cohomologies", " ", "are", 
        " ", "contributing", " ", "to", " ", "the", " ", "cohomology", " ", 
        "of", " ", "the", " ", "line", " ", "bundle", " ", "in", " ", 
        RowBox[{"question", ".", " ", "It"}], " ", "also", " ", "determines", 
        " ", "via", " ", "subroutines"}]}], ",", " ", 
      RowBox[{"how", " ", "many", " ", "rationom", " ", "contribute"}]}], " ",
      "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SubLinebundleCohomologyOf", "[", "Qchargesin_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "ii", ",", "kk"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Qcharges", "=", "Qchargesin"}], ";", "\[IndentingNewLine]", 
        RowBox[{"sortierttupel", "=", "sortierttupelsave"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"ii", "=", "1"}], ",", 
          RowBox[{"ii", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", "sortierttupel", "]"}]}], ",", 
          RowBox[{"ii", "++"}], ",", " ", 
          RowBox[{"(*", 
           RowBox[{
           "Sortierttupel", " ", "has", " ", "the", " ", "following", " ", 
            "list", " ", "structure", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Denominator", " ", "element"}], "}"}], ",", 
              RowBox[{"{", "sequence", "}"}]}], "}"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{
             RowBox[{"sortierttupel", "[", 
              RowBox[{"[", "ii", "]"}], "]"}], ",", 
             RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"AppendTo", "[", 
            RowBox[{
             RowBox[{"sortierttupel", "[", 
              RowBox[{"[", "ii", "]"}], "]"}], ",", "0"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"1", "\[Equal]", "2"}], "&&"}], "*)"}], 
            RowBox[{
             RowBox[{"!", 
              RowBox[{
               RowBox[{"isexact", "[", 
                RowBox[{"sortierttupel", "[", 
                 RowBox[{"[", 
                  RowBox[{"ii", ",", "2"}], "]"}], "]"}], "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"kk", "=", "1"}], ",", 
                RowBox[{"kk", "\[LessEqual]", 
                 RowBox[{"Length", "[", 
                  RowBox[{
                   RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
                RowBox[{"kk", "++"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"temprationomsOf", "=", 
                  RowBox[{"RationomsOf", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "kk", "]"}], "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"AppendTo", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", "temprationomsOf"}], 
                  "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "[", 
                   RowBox[{"[", "4", "]"}], "]"}], "=", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "[", 
                    RowBox[{"[", "4", "]"}], "]"}], "+", 
                   "temprationomsOf"}]}], ";"}]}], "\[IndentingNewLine]", 
               "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "]"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"End", " ", "of", " ", "routine"}], "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"Main", " ", "routine", " ", "2"}], ":", " ", 
      RowBox[{
      "Opens", " ", "the", " ", "subroutine", " ", "above", " ", "and", " ", 
       "puts", " ", "the", " ", "results", " ", "together"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"LinebundleCohomologyOf", "[", "Qchargesin_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "i", ",", "j", ",", "ii", ",", "kk", ",", "Resultlistofcohoms", ",", 
         "Resultlistofcohomsdual", ",", "PossibleResults", ",", 
         "PossibleResultsDual", ",", "resultvectors", ",", 
         "resultvectorsFromDual", ",", "output"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Qchargesstring", "=", "\"\<\>\""}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", "Qchargesin", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"i", "\[NotEqual]", " ", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Qchargesstring", "=", 
              RowBox[{"StringJoin", "[", 
               RowBox[{"Qchargesstring", ",", " ", "\"\<,\>\""}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Qchargesstring", "=", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"Qchargesstring", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"Qchargesin", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "]"}]}]}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"CanonicalDivisor", "=", 
         RowBox[{"-", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{"equivalencerelations", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", 
              RowBox[{"Length", "[", "equivalencerelations", "]"}]}], "}"}]}],
            "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Calculate", " ", "Cohomologies", " ", "of", " ", "the", " ", 
          "divisor"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"tmp", "=", 
         RowBox[{"PrintTemporary", "[", "\"\<.\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"SubLinebundleCohomologyOf", "[", "Qchargesin", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Collecting"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], " ", 
          "the", " ", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Results", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
          
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Resultlistofcohoms", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"-", " ", "The"}]}]}]}]}]}]}]}]}]}]}], " ", 
          "case", " ", "of", " ", "the", " ", "empty", " ", "set", " ", "in", 
          " ", "the", " ", "denominator", " ", "is", " ", "treated", " ", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"separately", " ", "--"}], "--"}], "--"}], "--"}], 
           "--"}], 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", "-"}]}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"leer", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"RationomsOf", "[", "leer", "]"}], "\[NotEqual]", "0"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"Resultlistofcohoms", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"h", ",", "0", ",", 
                RowBox[{"RationomsOf", "[", "leer", "]"}]}], "}"}], "}"}]}], 
            "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Case"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], " ", 
           "denominator"}], " ", "\[NotEqual]", " ", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"{", "}"}], " ", "--"}], "--"}], "--"}], "--"}], 
            "--"}], "-", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"-", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", "sortierttupel", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", 
          RowBox[{
           RowBox[{"e", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"sortierttupel", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "\[NotEqual]", "0"}], " ", "&&",
                " ", 
               RowBox[{"!", 
                RowBox[{
                 RowBox[{"isexact", "[", 
                  RowBox[{
                   RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "]"}], "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"cohomresult", "=", 
                RowBox[{"Map", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"h", ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ",", " ", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}], "&"}], ",", 
                  RowBox[{"CohomsOf", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "mincdegree"}], 
                   "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"AppendTo", "[", 
                RowBox[{"Resultlistofcohoms", ",", "cohomresult"}], "]"}]}]}],
              "\[IndentingNewLine]", "]"}]}], ";"}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"output", "=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"serredual", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"unique", "=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"resultvector", "=", 
         RowBox[{"Array", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"0", "*", "#"}], "&"}], ",", 
           RowBox[{"dim", "+", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Check", " ", "results", " ", "for", " ", "uniqueness", " ", "and", 
          " ", "print", " ", "them", " ", "in", " ", "case", " ", "that", " ",
           "they", " ", "unique"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", "Resultlistofcohoms", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", 
              RowBox[{"Resultlistofcohoms", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[NotEqual]", " ", 
             "1"}], ",", 
            RowBox[{"unique", "=", "0"}]}], "]"}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"unique", "==", "1"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"i", "=", "1"}], ",", 
             RowBox[{"i", "\[LessEqual]", " ", 
              RowBox[{"Length", "[", "Resultlistofcohoms", "]"}]}], ",", 
             RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"resultvector", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"Resultlistofcohoms", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}], "+", 
                 "1"}], "]"}], "]"}], "=", 
              RowBox[{
               RowBox[{"resultvector", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"Resultlistofcohoms", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}], "+", 
                  "1"}], "]"}], "]"}], "+", 
               RowBox[{"Resultlistofcohoms", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1", ",", "3"}], "]"}], "]"}]}]}]}], 
            "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{
             RowBox[{"Superscript", "[", 
              RowBox[{"\"\<h\>\"", ",", "\"\<*\>\""}], "]"}], ",", 
             "\"\<(O(\>\"", ",", "Qchargesstring", ",", "\"\<))  =  \>\"", 
             ",", "resultvector"}], "]"}], ";", " ", 
           RowBox[{"output", "=", "0"}]}], ",", " ", 
          RowBox[{"serredual", "=", "1"}]}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
          "more", " ", "fancy", " ", "output", " ", "for", " ", "the", " ", 
           "graphical", " ", "interface", " ", "of", " ", "mathematica"}], 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{
              RowBox[{"Superscript", "[", 
               RowBox[{"\"\<h\>\"", ",", "\"\<\[FilledSmallCircle]\>\""}], 
               "]"}], ",", "\"\<(\[ScriptCapitalO](\>\"", ",", 
              "Qchargesstring", ",", "\"\<))  =  \>\"", ",", "resultvector"}],
              "]"}], ";", " ", 
            RowBox[{"output", "=", "0"}]}], ",", " ", 
           RowBox[{"serredual", "=", "1"}]}], "*)"}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"unique", "=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Calculate", " ", "Cohomologies", " ", "of", " ", "the", " ", 
          "Serre", " ", "dual", " ", "divisor"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"serredual", " ", "==", "1"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"NotebookDelete", "[", "tmp", "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"tmp", "=", 
            RowBox[{"PrintTemporary", "[", "\"\<..\>\"", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"SubLinebundleCohomologyOf", "[", 
            RowBox[{"CanonicalDivisor", "-", "Qchargesin"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Printing"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
              " ", "the", " ", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"Results", " ", "--"}], "--"}], "--"}], "--"}], 
                  "--"}], "--"}], "--"}], "--"}]}], "-", 
             RowBox[{"--", 
              RowBox[{"-", 
               RowBox[{"-", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"Resultlistofcohomsdual", "=", 
            RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", " ", "The"}]}]}]}]}]}]}]}]}]}], " ", "case", 
              " ", "of", " ", "the", " ", "empty", " ", "set", " ", "in", " ",
               "the", " ", "denominator", " ", "is", " ", "treated", " ", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"separately", " ", "--"}], "--"}], "--"}], "--"}], 
                "--"}], "--"}]}], "-", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"-", 
                RowBox[{"--", 
                 RowBox[{"--", "-"}]}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
           RowBox[{"leer", "=", 
            RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"RationomsOf", "[", "leer", "]"}], "\[NotEqual]", "0"}],
              ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"AppendTo", "[", 
               RowBox[{"Resultlistofcohomsdual", ",", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"h", ",", "0", ",", 
                   RowBox[{"RationomsOf", "[", "leer", "]"}]}], "}"}], 
                 "}"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Case"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], " ", 
              "denominator"}], " ", "\[NotEqual]", " ", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"{", "}"}], " ", "--"}], "--"}], "--"}], "--"}], 
               "--"}], "-", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"i", "=", "1"}], ",", 
             RowBox[{"i", "\[LessEqual]", " ", 
              RowBox[{"Length", "[", "sortierttupel", "]"}]}], ",", 
             RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                   RowBox[{"[", "4", "]"}], "]"}], "\[NotEqual]", "0"}], " ", 
                 "&&", " ", 
                 RowBox[{"!", 
                  RowBox[{
                   RowBox[{"isexact", "[", 
                    RowBox[{
                    RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"cohomresult", "=", 
                  RowBox[{"Map", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"h", ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ",", " ", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}], "&"}], ",", 
                    RowBox[{"CohomsOf", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"sortierttupel", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "mincdegree"}], 
                    "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
                 RowBox[{"AppendTo", "[", 
                  RowBox[{"Resultlistofcohomsdual", ",", "cohomresult"}], 
                  "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
             "Check", " ", "the", " ", "Serre", " ", "dual", " ", "divisor", 
              " ", "for", " ", 
              RowBox[{"uniqueness", ".", " ", "If"}], " ", "it", " ", "is"}], 
             ",", " ", 
             RowBox[{
             "print", " ", "the", " ", "corresponding", " ", "data", " ", 
              "for", " ", "the", " ", "divisor", " ", "in", " ", "question", 
              " ", "by", " ", "using", " ", "Serre", " ", "duality"}]}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"i", "=", "1"}], ",", 
             RowBox[{"i", "\[LessEqual]", " ", 
              RowBox[{"Length", "[", "Resultlistofcohomsdual", "]"}]}], ",", 
             RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", 
                 RowBox[{"Resultlistofcohomsdual", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[NotEqual]", " ", 
                "1"}], ",", 
               RowBox[{"unique", "=", "0"}]}], "]"}]}], "\[IndentingNewLine]",
             "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"unique", "==", "1"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"i", "=", "1"}], ",", 
                RowBox[{"i", "\[LessEqual]", " ", 
                 RowBox[{"Length", "[", "Resultlistofcohomsdual", "]"}]}], 
                ",", 
                RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"resultvector", "[", 
                  RowBox[{"[", 
                   RowBox[{"dim", "-", " ", 
                    RowBox[{"Resultlistofcohomsdual", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}], "+", 
                    "1"}], "]"}], "]"}], "=", 
                 RowBox[{
                  RowBox[{"resultvector", "[", 
                   RowBox[{"[", 
                    RowBox[{"dim", "-", 
                    RowBox[{"Resultlistofcohomsdual", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}], "+", 
                    "1"}], "]"}], "]"}], "+", 
                  RowBox[{"Resultlistofcohomsdual", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "1", ",", "3"}], "]"}], "]"}]}]}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{
                RowBox[{"Superscript", "[", 
                 RowBox[{"\"\<h\>\"", ",", "\"\<*\>\""}], "]"}], ",", 
                "\"\<(O(\>\"", ",", "Qchargesstring", ",", "\"\<))  =  \>\"", 
                ",", "resultvector"}], "]"}], ";", " ", 
              RowBox[{"output", "=", "0"}]}]}], "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
             "more", " ", "fancy", " ", "output", " ", "for", " ", "the", " ",
               "graphical", " ", "interface", " ", "of", " ", "mathematica"}],
              "*)"}], "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{
                RowBox[{"Superscript", "[", 
                 RowBox[{"\"\<h\>\"", ",", "\"\<\[FilledSmallCircle]\>\""}], 
                 "]"}], ",", "\"\<(\[ScriptCapitalO](\>\"", ",", 
                "Qchargesstring", ",", "\"\<))  =  \>\"", ",", 
                "resultvector"}], "]"}], ";", " ", 
              RowBox[{"output", "=", "0"}]}], "*)"}], "\[IndentingNewLine]", 
            "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "If", " ", "also", " ", "the", " ", "Serre", " ", "dual", " ", "is", 
          " ", "not", " ", "trivially", " ", "unique", " ", "we", " ", "need",
           " ", "to", " ", "consider", " ", "all", " ", "possible", " ", 
          "combinations", " ", "and", " ", "cancel", " ", "them", " ", 
          "out"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "First", " ", "generate", " ", "a", " ", "list", " ", "of", " ", 
          "all", " ", "possible", " ", "resulting", " ", "vectors", " ", 
          RowBox[{"h", "^"}], "*", 
          RowBox[{"(", 
           RowBox[{"O", 
            RowBox[{"(", "D", ")"}]}], ")"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"resultvectors", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"resultvectorsFromDual", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"unique", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"NotebookDelete", "[", "tmp", "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"tmp", "=", 
            RowBox[{"PrintTemporary", "[", "\"\<...\>\"", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"PossibleResults", "=", 
            RowBox[{"Tuples", "[", "Resultlistofcohoms", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"PossibleResultsDual", "=", 
            RowBox[{"Tuples", "[", "Resultlistofcohomsdual", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"j", "=", "1"}], ",", 
             RowBox[{"j", "\[LessEqual]", " ", 
              RowBox[{"Length", "[", "PossibleResults", "]"}]}], ",", 
             RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tmpesultvector", "=", 
               RowBox[{"Array", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"0", "*", "#"}], "&"}], ",", 
                 RowBox[{"dim", "+", "1"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"i", "=", "1"}], ",", 
                RowBox[{"i", "\[LessEqual]", " ", 
                 RowBox[{"Length", "[", 
                  RowBox[{"PossibleResults", "[", 
                   RowBox[{"[", "j", "]"}], "]"}], "]"}]}], ",", 
                RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"tmpesultvector", "[", 
                  RowBox[{"[", " ", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"PossibleResults", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "+", "1"}], "]"}], 
                  "]"}], "=", 
                 RowBox[{
                  RowBox[{"tmpesultvector", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"PossibleResults", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "+", "1"}], "]"}], 
                   "]"}], "+", 
                  RowBox[{
                   RowBox[{"PossibleResults", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"resultvectors", ",", "tmpesultvector"}], "]"}], 
              ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"j", "=", "1"}], ",", 
             RowBox[{"j", "\[LessEqual]", " ", 
              RowBox[{"Length", "[", "PossibleResultsDual", "]"}]}], ",", 
             RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tmpesultvector", "=", 
               RowBox[{"Array", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"0", "*", "#"}], "&"}], ",", 
                 RowBox[{"dim", "+", "1"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"i", "=", "1"}], ",", 
                RowBox[{"i", "\[LessEqual]", " ", 
                 RowBox[{"Length", "[", 
                  RowBox[{"PossibleResultsDual", "[", 
                   RowBox[{"[", "j", "]"}], "]"}], "]"}]}], ",", 
                RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"tmpesultvector", "[", 
                  RowBox[{"[", 
                   RowBox[{"dim", "-", " ", 
                    RowBox[{
                    RowBox[{"PossibleResultsDual", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "+", "1"}], "]"}], 
                  "]"}], "=", 
                 RowBox[{
                  RowBox[{"tmpesultvector", "[", 
                   RowBox[{"[", 
                    RowBox[{"dim", "-", 
                    RowBox[{
                    RowBox[{"PossibleResultsDual", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "+", "1"}], "]"}], 
                   "]"}], "+", 
                  RowBox[{
                   RowBox[{"PossibleResultsDual", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"resultvectorsFromDual", ",", "tmpesultvector"}], 
               "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", 
               RowBox[{"Intersection", "[", 
                RowBox[{"resultvectors", ",", "resultvectorsFromDual"}], 
                "]"}], "]"}], "\[Equal]", " ", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{
                RowBox[{"Superscript", "[", 
                 RowBox[{"\"\<h\>\"", ",", "\"\<*\>\""}], "]"}], ",", 
                "\"\<(O(\>\"", ",", "Qchargesstring", ",", "\"\<))  =  \>\"", 
                ",", 
                RowBox[{"Flatten", "[", 
                 RowBox[{"Intersection", "[", 
                  RowBox[{"resultvectors", ",", "resultvectorsFromDual"}], 
                  "]"}], "]"}]}], "]"}], ";", " ", 
              RowBox[{"output", "=", "0"}]}]}], "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
             "more", " ", "fancy", " ", "output", " ", "for", " ", "the", " ",
               "graphical", " ", "interface", " ", "of", " ", "mathematica"}],
              "*)"}], "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{
                RowBox[{"Superscript", "[", 
                 RowBox[{"\"\<h\>\"", ",", "\"\<\[FilledSmallCircle]\>\""}], 
                 "]"}], ",", "\"\<(\[ScriptCapitalO](\>\"", ",", 
                "Qchargesstring", ",", "\"\<))  =  \>\"", ",", 
                RowBox[{"Flatten", "[", 
                 RowBox[{"Intersection", "[", 
                  RowBox[{"resultvectors", ",", "resultvectorsFromDual"}], 
                  "]"}], "]"}]}], "]"}], ";", " ", 
              RowBox[{"output", "=", "0"}]}], "*)"}], "\[IndentingNewLine]", 
            "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"output", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"-", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"-", " ", "Uniqueness"}]}]}]}]}]}]}], " ", "could", 
            " ", "not", " ", "be", " ", 
            RowBox[{"achieved", ":", " ", 
             RowBox[{
             "Printing", " ", "the", " ", "remaining", " ", "poossible", "  ", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"results", " ", "--"}], "--"}], "--"}], "--"}], 
                   "--"}], "--"}], "--"}], "--"}], "--"}], 
              RowBox[{"--", "--"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Print", "[", "Space", "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{
           "Print", "[", 
            "\"\<The algorithm does not return a unique solution. Possible \
solutions are:\>\"", "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Print", "[", " ", 
            RowBox[{
             RowBox[{"Superscript", "[", 
              RowBox[{"\"\<h\>\"", ",", "\"\<*\>\""}], "]"}], ",", 
             "\"\<(O(\>\"", ",", "Qchargesstring", ",", "\"\<)) = \>\"", ",", 
             " ", 
             RowBox[{"Intersection", "[", 
              RowBox[{"resultvectors", ",", "resultvectorsFromDual"}], 
              "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
          "more", " ", "fancy", " ", "output", " ", "for", " ", "the", " ", 
           "graphical", " ", "interface", " ", "of", " ", "mathematica"}], 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"Print", "[", " ", 
            RowBox[{
             RowBox[{"Superscript", "[", 
              RowBox[{"\"\<h\>\"", ",", "\"\<\[FilledSmallCircle]\>\""}], 
              "]"}], ",", "\"\<(\[ScriptCapitalO](\>\"", ",", 
             "Qchargesstring", ",", "\"\<)) = \>\"", ",", " ", 
             RowBox[{"Intersection", "[", 
              RowBox[{"resultvectors", ",", "resultvectorsFromDual"}], 
              "]"}]}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"NotebookDelete", "[", "tmp", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"End", " ", "of", " ", "routine"}], "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "-", " ", 
                    "END"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
       " ", "OF", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"PROGRAM", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
         "--"}], "--"}]}], "-", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"-", 
         RowBox[{"-", 
          RowBox[{"-", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"-", 
                  RowBox[{"-", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{
                    "--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
     "*)"}], "\[IndentingNewLine]"}]}]}]], "Input",
 CellChangeTimes->{{3.474278249207546*^9, 3.474278259359749*^9}, {
   3.474278331697122*^9, 3.474278457733211*^9}, {3.474278853511161*^9, 
   3.474278864414941*^9}, {3.474353651846471*^9, 3.474353728327644*^9}, {
   3.474353778994437*^9, 3.474353848721274*^9}, {3.474353965919147*^9, 
   3.474353974547001*^9}, {3.474354139383733*^9, 3.474354152010258*^9}, {
   3.474354211731895*^9, 3.474354382529528*^9}, {3.474354475260257*^9, 
   3.474354476219163*^9}, {3.474354514784996*^9, 3.474354716099728*^9}, {
   3.474354816313241*^9, 3.474354844003238*^9}, {3.474355269410373*^9, 
   3.474355357170537*^9}, {3.474355387557546*^9, 3.474355398349931*^9}, {
   3.47435553871939*^9, 3.474355789140013*^9}, {3.474373510764801*^9, 
   3.474373512062075*^9}, {3.474373604026966*^9, 3.47437385004167*^9}, {
   3.474373983619533*^9, 3.474374079374492*^9}, 3.474374347487621*^9, {
   3.474374444652424*^9, 3.474374468849834*^9}, 3.474374545455593*^9, {
   3.47437458334743*^9, 3.474374678787397*^9}, 3.474374718100312*^9, {
   3.47437476456015*^9, 3.474374820218823*^9}, {3.474374850797171*^9, 
   3.474374894146851*^9}, {3.474374934846012*^9, 3.474374966698854*^9}, {
   3.4746213016853447`*^9, 3.474621350518138*^9}, 3.474621420286128*^9, {
   3.4746215700536947`*^9, 3.47462160563973*^9}, {3.4746217355681615`*^9, 
   3.4746217412204847`*^9}, {3.4746218257083173`*^9, 
   3.4746218806124573`*^9}, {3.474621911932249*^9, 3.474621983911366*^9}, {
   3.4746220588166504`*^9, 3.474622260303175*^9}, {3.474622306853837*^9, 
   3.4746223254779024`*^9}, {3.4746223579267583`*^9, 
   3.4746223601978884`*^9}, {3.474622482391877*^9, 3.474622612816337*^9}, {
   3.4746226640232663`*^9, 3.4746227763266897`*^9}, {3.474622816163968*^9, 
   3.4746228396833134`*^9}, {3.4746229946801786`*^9, 3.474623096481001*^9}, {
   3.4746232309986954`*^9, 3.474623291454153*^9}, {3.4746235349440804`*^9, 
   3.474623596705612*^9}, {3.4746237056318426`*^9, 3.4746238095117846`*^9}, {
   3.4746241861973295`*^9, 3.474624187932429*^9}, {3.474624269670104*^9, 
   3.474624406230915*^9}, {3.4746247975612974`*^9, 3.474624804525696*^9}, {
   3.4746251762339563`*^9, 3.4746255999621925`*^9}, {3.474625750032776*^9, 
   3.4746257839607162`*^9}, {3.4746258427290773`*^9, 
   3.4746258444881783`*^9}, {3.474626359593641*^9, 3.4746263697552223`*^9}, {
   3.474626431152734*^9, 3.4746264627375402`*^9}, {3.4746266219486465`*^9, 
   3.4746266834001617`*^9}, {3.474626826983374*^9, 3.474626872228962*^9}, {
   3.474626918568612*^9, 3.474627094093652*^9}, {3.4746271404533033`*^9, 
   3.4746272344456797`*^9}, {3.4746272662845*^9, 3.4746275579801846`*^9}, {
   3.474627632117425*^9, 3.474627653701659*^9}, {3.474627740618631*^9, 
   3.4746278722601604`*^9}, {3.4746279626343293`*^9, 3.474627975657074*^9}, {
   3.474629791824953*^9, 3.4746298402397223`*^9}, {3.4746299015612297`*^9, 
   3.4746299185602016`*^9}, {3.474630013929657*^9, 3.4746301118872595`*^9}, {
   3.4746301707866287`*^9, 3.4746301909527817`*^9}, {3.474630341557396*^9, 
   3.4746303951154594`*^9}, 3.4746304285563717`*^9, {3.4746304684586544`*^9, 
   3.4746304729289103`*^9}, {3.474630505169754*^9, 3.4746305495672936`*^9}, {
   3.4746305911926746`*^9, 3.4746306018162823`*^9}, {3.4746307343278613`*^9, 
   3.474630772752059*^9}, 3.4746308208258085`*^9, {3.4746312962820034`*^9, 
   3.47463130356942*^9}, {3.4746316767827663`*^9, 3.474631683638159*^9}, {
   3.474631718499152*^9, 3.474631721402319*^9}, {3.474631808456298*^9, 
   3.4746318271183653`*^9}, {3.4746326730857515`*^9, 
   3.4746327038705125`*^9}, {3.4746329101383104`*^9, 
   3.4746329298444376`*^9}, {3.4746329883087816`*^9, 3.47463299265103*^9}, {
   3.4746331531262083`*^9, 3.474633157419454*^9}, {3.474633366347404*^9, 
   3.474633369340575*^9}, {3.4746334835201063`*^9, 3.4746335414414186`*^9}, {
   3.47463372066267*^9, 3.474633741788878*^9}, {3.4746339961754284`*^9, 
   3.474634000628683*^9}, {3.4746341283389874`*^9, 3.4746341531284056`*^9}, {
   3.474634606916361*^9, 3.474634618115001*^9}, {3.4746347436531816`*^9, 
   3.474634819437516*^9}, {3.474634875366715*^9, 3.4746349074215484`*^9}, {
   3.474634940681451*^9, 3.4746349496669645`*^9}, {3.474635009817405*^9, 
   3.474635026072335*^9}, {3.474635070234861*^9, 3.4746350709789033`*^9}, 
   3.474636230561228*^9, {3.4746362962959876`*^9, 3.474636339206442*^9}, {
   3.474636388079237*^9, 3.474636389071294*^9}, {3.474636460420375*^9, 
   3.4746364686128435`*^9}, {3.4746365085841293`*^9, 3.4746365299753532`*^9}, 
   3.4746366046696253`*^9, {3.4746366866553144`*^9, 3.474636913869311*^9}, {
   3.4746369460541515`*^9, 3.4746369842053337`*^9}, {3.4746371236503096`*^9, 
   3.4746372110653095`*^9}, {3.4746373477361264`*^9, 3.474637411001745*^9}, {
   3.4746374929204307`*^9, 3.474637589033928*^9}, {3.474637660140995*^9, 
   3.4746377470519657`*^9}, {3.474637778348756*^9, 3.474637786492222*^9}, {
   3.474637819628117*^9, 3.4746378329058766`*^9}, {3.4746378952164407`*^9, 
   3.474637896524515*^9}, {3.4746379998354244`*^9, 3.474638020466604*^9}, {
   3.474638250910785*^9, 3.474638269284836*^9}, {3.474638330094314*^9, 
   3.4746383656073456`*^9}, {3.4746384400636044`*^9, 3.47463844366181*^9}, {
   3.4746384876943283`*^9, 3.474638491941571*^9}, {3.474638523902399*^9, 
   3.474638567179875*^9}, {3.474638604919033*^9, 3.4746386050240393`*^9}, {
   3.474638661232254*^9, 3.474638662011299*^9}, {3.474638783358239*^9, 
   3.4746388255886545`*^9}, {3.474638922910221*^9, 3.47463893722804*^9}, 
   3.474638980327505*^9, {3.4746390146814704`*^9, 3.474639016987602*^9}, {
   3.474639076676016*^9, 3.4746391125590687`*^9}, {3.474639264101736*^9, 
   3.474639291455301*^9}, {3.4746393516077414`*^9, 3.474639447765241*^9}, {
   3.4746395825989532`*^9, 3.4746396241583304`*^9}, {3.4746397047939425`*^9, 
   3.4746397071420765`*^9}, {3.474639768181568*^9, 3.4746397932770033`*^9}, {
   3.474639902078226*^9, 3.474639906771495*^9}, {3.4746409705513396`*^9, 
   3.4746409741885476`*^9}, {3.4746417112877073`*^9, 
   3.4746417120827527`*^9}, {3.474641755428232*^9, 3.4746417914042897`*^9}, {
   3.4746877610276318`*^9, 3.474687767125226*^9}, {3.474687831528715*^9, 
   3.4746878328874855`*^9}, {3.474688220944222*^9, 3.4746882215767317`*^9}, {
   3.4746886659777145`*^9, 3.4746887294607186`*^9}, {3.47468899906171*^9, 
   3.4746890002542286`*^9}, {3.47468909452623*^9, 3.4746891306645374`*^9}, {
   3.4746892001023626`*^9, 3.4746892002448645`*^9}, {3.474689480614127*^9, 
   3.4746895101218333`*^9}, {3.4746898195343647`*^9, 3.474689820037623*^9}, {
   3.4746899715859604`*^9, 3.4746899870067005`*^9}, {3.474690058010046*^9, 
   3.474690059102314*^9}, {3.4746902472809935`*^9, 3.4746902598909407`*^9}, 
   3.4746903180698376`*^9, {3.4746903579419527`*^9, 3.4746903580769544`*^9}, {
   3.474690394757518*^9, 3.474690407411462*^9}, {3.474690772397932*^9, 
   3.4746908084880075`*^9}, {3.474691251610423*^9, 3.474691301624699*^9}, 
   3.474691695356295*^9, {3.4746957856274567`*^9, 3.474695856130151*^9}, {
   3.474695936905504*^9, 3.474696059157146*^9}, {3.474697786119225*^9, 
   3.474697825369584*^9}, {3.475303599339735*^9, 3.475303717113061*^9}, {
   3.47530379414478*^9, 3.475303823855494*^9}, {3.4753039208979945`*^9, 
   3.4753040565498533`*^9}, {3.4753041732914047`*^9, 
   3.4753042995121384`*^9}, {3.4753043343454304`*^9, 3.475304335109192*^9}, {
   3.475304484262991*^9, 3.475304503279287*^9}, {3.4753045787972064`*^9, 
   3.4753045865758286`*^9}, {3.475308220728512*^9, 3.475308222478539*^9}, {
   3.475315719999115*^9, 3.4753157214703875`*^9}, {3.475315980176861*^9, 
   3.4753159804568653`*^9}, {3.475316093268598*^9, 3.4753160976174145`*^9}, {
   3.475316242895896*^9, 3.475316246920958*^9}, {3.4753165328618546`*^9, 
   3.475316537060669*^9}, 3.475316677047819*^9, {3.475316710512083*^9, 
   3.475316782425688*^9}, {3.4753169412818775`*^9, 3.475317049106034*^9}, {
   3.475317128474753*^9, 3.4753171551589127`*^9}, {3.4753171960145407`*^9, 
   3.475317227500024*^9}, {3.475317303146186*^9, 3.4753173048224616`*^9}, {
   3.4753174897253017`*^9, 3.4753174920490875`*^9}, {3.475317522099549*^9, 
   3.475317523519571*^9}, {3.4753218463211975`*^9, 3.4753218932088795`*^9}, {
   3.475322113831498*^9, 3.475322114988564*^9}, {3.47532218852777*^9, 
   3.4753222119811115`*^9}, {3.475322348590925*^9, 3.4753223799897213`*^9}, {
   3.4753224355528994`*^9, 3.475322436057928*^9}, {3.475322515082448*^9, 
   3.475322516020502*^9}, 3.4753234028492255`*^9, 3.475325358241068*^9, 
   3.475325411645122*^9, {3.475325510122755*^9, 3.475325513080924*^9}, {
   3.4753258252627797`*^9, 3.4753258341052856`*^9}, 3.4753262299879284`*^9, 
   3.4753262990828805`*^9, {3.4753267513407483`*^9, 3.4753267585291595`*^9}, {
   3.4753269263027554`*^9, 3.4753269289929094`*^9}, {3.4753270634045973`*^9, 
   3.475327068097866*^9}, {3.475327249743255*^9, 3.475327291468642*^9}, {
   3.475327365976904*^9, 3.4753274536429176`*^9}, {3.4753274852437253`*^9, 
   3.475327624116668*^9}, 3.475328180853512*^9, {3.475329756466632*^9, 
   3.475329767187245*^9}, 3.4753304764508123`*^9, {3.475331061387269*^9, 
   3.475331067054593*^9}, {3.4753318131172657`*^9, 3.475331814057319*^9}, {
   3.475332307969569*^9, 3.4753323085786037`*^9}, {3.47534811325758*^9, 
   3.475348172384962*^9}, {3.4753482232498713`*^9, 3.4753482338414774`*^9}, {
   3.475348264868252*^9, 3.4753483689652057`*^9}, {3.475348723326474*^9, 
   3.4753487261026325`*^9}, {3.4753490379114676`*^9, 
   3.4753490418976955`*^9}, {3.4753492614982557`*^9, 
   3.4753492670175714`*^9}, {3.4753493364295416`*^9, 3.475349340682785*^9}, {
   3.4753498541361523`*^9, 3.475349927572353*^9}, {3.475349962274338*^9, 
   3.4753499913119984`*^9}, {3.4753500638181458`*^9, 
   3.4753500962750025`*^9}, {3.4753504022265015`*^9, 3.4753504058257074`*^9}, 
   3.475350777094943*^9, {3.4753508834570265`*^9, 3.4753509426664133`*^9}, {
   3.4753509840597806`*^9, 3.4753509856678724`*^9}, {3.4753510350416965`*^9, 
   3.47535109437009*^9}, {3.475351206460501*^9, 3.475351208932643*^9}, {
   3.4753522066107063`*^9, 3.475352239972615*^9}, {3.4753885513026876`*^9, 
   3.475388558140736*^9}, {3.4753888181256733`*^9, 3.475388821277956*^9}, {
   3.475390109046997*^9, 3.47539011382308*^9}, {3.475390412723572*^9, 
   3.4753904173305607`*^9}, {3.475403749148004*^9, 3.475404040075203*^9}, {
   3.475404082758999*^9, 3.4754041658724947`*^9}, {3.475404202492559*^9, 
   3.475404292078809*^9}, 3.475404418203703*^9, {3.475404456534955*^9, 
   3.475404509828174*^9}, {3.475404950764448*^9, 3.475404958801014*^9}, {
   3.475408967252244*^9, 3.475408968264162*^9}, {3.475409244197905*^9, 
   3.475409275602212*^9}, {3.475409334006578*^9, 3.4754093628161163`*^9}, {
   3.4754095032885113`*^9, 3.475409505602886*^9}, {3.475409555666094*^9, 
   3.475409560676549*^9}, {3.4754099407095633`*^9, 3.475409943813665*^9}, {
   3.4754102227958927`*^9, 3.475410225130625*^9}, {3.475414446478848*^9, 
   3.4754144480144653`*^9}, {3.475414606340951*^9, 3.475414609825547*^9}, {
   3.4754146909613333`*^9, 3.475414693327839*^9}, {3.475414853278083*^9, 
   3.475414866398796*^9}, {3.475414922235964*^9, 3.47541492455051*^9}, {
   3.475414985460115*^9, 3.475414987545969*^9}, {3.4754150665814734`*^9, 
   3.475415068117443*^9}, {3.475415315768806*^9, 3.4754153161521606`*^9}, {
   3.475415383625551*^9, 3.475415441294375*^9}, 3.475470816798625*^9, {
   3.4754708765340414`*^9, 3.4754710729692774`*^9}, {3.4754711203249855`*^9, 
   3.475471186577775*^9}, 3.4754712191696396`*^9, {3.4754715152225723`*^9, 
   3.4754715226569977`*^9}, {3.4754716596378326`*^9, 
   3.4754716871394053`*^9}, {3.475471901163647*^9, 3.4754720289509563`*^9}, {
   3.475473720561711*^9, 3.4754737345585117`*^9}, {3.4754742879301624`*^9, 
   3.4754743061022015`*^9}, {3.4754743499847116`*^9, 3.475474391472085*^9}, {
   3.4754744223738523`*^9, 3.4754744587339315`*^9}, {3.475474922928482*^9, 
   3.475474931515973*^9}, {3.475475415438652*^9, 3.4754754225930614`*^9}, {
   3.47547546418544*^9, 3.475475473418968*^9}, {3.475475530774249*^9, 
   3.4754755759088306`*^9}, {3.4754756437867126`*^9, 3.475475646390862*^9}, 
   3.475475752379924*^9, {3.475475823363984*^9, 3.4754758253440976`*^9}, {
   3.4754759176983795`*^9, 3.475476178171278*^9}, {3.475476233522444*^9, 
   3.475476250693426*^9}, {3.47547635636447*^9, 3.47547636440993*^9}, 
   3.475490916874284*^9, {3.4754911129985013`*^9, 3.475491115402639*^9}, {
   3.4754911938061233`*^9, 3.475491198948417*^9}, {3.4754913497010403`*^9, 
   3.475491379721757*^9}, {3.475491470780965*^9, 3.4754914782683935`*^9}, {
   3.4754915207238216`*^9, 3.47549155863499*^9}, {3.4754916698933535`*^9, 
   3.4754916971709137`*^9}, {3.4754918738450193`*^9, 
   3.4754918822965026`*^9}, {3.475492026876772*^9, 3.475492027308797*^9}, {
   3.475492141374321*^9, 3.475492180417554*^9}, {3.4754922569799333`*^9, 
   3.4754922867056336`*^9}, 3.4754923615079117`*^9, {3.475492407019515*^9, 
   3.475492421199326*^9}, {3.475492600612588*^9, 3.475492625003983*^9}, {
   3.4754929159916267`*^9, 3.47549292758829*^9}, {3.4754950120565147`*^9, 
   3.4754950192199244`*^9}, {3.475495139151784*^9, 3.475495145134126*^9}, 
   3.475495374619252*^9, {3.4754955626050043`*^9, 3.4754955659881973`*^9}, {
   3.4754956173181334`*^9, 3.4754956383583374`*^9}, {3.4754956860220633`*^9, 
   3.475495789961008*^9}, {3.475496016440962*^9, 3.4754960288916745`*^9}, {
   3.475496197796335*^9, 3.4754961989364004`*^9}, 3.475499826463883*^9, {
   3.4755789476572757`*^9, 3.4755789520595274`*^9}, {3.4755860670464816`*^9, 
   3.4755860872216353`*^9}, {3.4755863244972067`*^9, 
   3.4755863537178783`*^9}, {3.4755869453297167`*^9, 3.475586954115219*^9}, {
   3.4755870338637805`*^9, 3.4755870705468783`*^9}, {3.4755871140823684`*^9, 
   3.4755872095518293`*^9}, {3.475921981153463*^9, 3.475922037292405*^9}, {
   3.475922222313985*^9, 3.475922242414976*^9}, 3.475953253141113*^9, 
   3.475954526323593*^9, {3.476002566517227*^9, 3.4760025741364*^9}, {
   3.476009232009234*^9, 3.476009244773245*^9}, {3.476013662299056*^9, 
   3.476013711458976*^9}, 3.476013778589113*^9, {3.476016405749214*^9, 
   3.476016406328813*^9}, 3.476016469955467*^9, {3.47601655970398*^9, 
   3.476016565296101*^9}, {3.476017739511196*^9, 3.476017791268035*^9}, {
   3.476018652851854*^9, 3.476018718917829*^9}, {3.476018770012693*^9, 
   3.47601878192119*^9}, {3.47601902221005*^9, 3.476019030044341*^9}, {
   3.476019316204785*^9, 3.476019346025198*^9}, {3.476019384170541*^9, 
   3.476019625366779*^9}, {3.476019670023399*^9, 3.476019712907823*^9}, {
   3.476019940799604*^9, 3.47601994621392*^9}, {3.47601999673445*^9, 
   3.476020001791586*^9}, {3.476082972481433*^9, 3.476082976199692*^9}, {
   3.476083350431936*^9, 3.4760835314009*^9}, 3.476083656862569*^9, {
   3.476083687525591*^9, 3.476083700421309*^9}, {3.476083750608448*^9, 
   3.476083752968819*^9}, {3.47608405342889*^9, 3.476084056980381*^9}, {
   3.476084415732815*^9, 3.476084507391051*^9}, {3.476087312455848*^9, 
   3.476087428395015*^9}, {3.476087784853862*^9, 3.476087803620143*^9}, {
   3.476087856960446*^9, 3.476087876328697*^9}, {3.476097932394286*^9, 
   3.476097955385408*^9}, 3.476098008418305*^9, {3.476159856959346*^9, 
   3.476159989322988*^9}, {3.476160029609127*^9, 3.476160049497191*^9}, 
   3.476160120369263*^9, {3.476160179579409*^9, 3.476160261459574*^9}, {
   3.476160526827325*^9, 3.476160549410079*^9}, {3.476161738165229*^9, 
   3.476161751558328*^9}, 3.476162947059581*^9, {3.476163702596472*^9, 
   3.476163706410677*^9}, {3.476164110519022*^9, 3.476164161939367*^9}, {
   3.476167635629123*^9, 3.476167638328992*^9}, {3.476167779196579*^9, 
   3.47616783292864*^9}, 3.47616792523365*^9, {3.476169679690802*^9, 
   3.476169771950273*^9}, {3.476169804372656*^9, 3.476169822242765*^9}, {
   3.47616989530593*^9, 3.476170005250158*^9}, {3.476170204457426*^9, 
   3.476170218921116*^9}, {3.476171024370641*^9, 3.476171071620453*^9}, {
   3.476172081665038*^9, 3.476172101098775*^9}, {3.476172429864756*^9, 
   3.476172473805213*^9}, {3.476174804466599*^9, 3.47617483531279*^9}, 
   3.476174911060929*^9, {3.476174972469762*^9, 3.476174977582246*^9}, {
   3.476175040306745*^9, 3.476175079450493*^9}, {3.476175126627559*^9, 
   3.476175163772371*^9}, {3.476175308250844*^9, 3.476175387433815*^9}, {
   3.476175572763321*^9, 3.476175583291316*^9}, {3.476175867069773*^9, 
   3.476175875002991*^9}, {3.476176154962983*^9, 3.476176166072024*^9}, 
   3.476180225949961*^9, {3.476180976209728*^9, 3.476181041493694*^9}, {
   3.476181071549796*^9, 3.476181232291632*^9}, {3.476181265581556*^9, 
   3.47618138264631*^9}, {3.476181413367164*^9, 3.476181467592305*^9}, {
   3.476181510656567*^9, 3.476181587439923*^9}, {3.476181934488901*^9, 
   3.476181945508245*^9}, {3.476182008466044*^9, 3.476182186942114*^9}, {
   3.476182371126455*^9, 3.476182380585396*^9}, {3.476182419654653*^9, 
   3.4761824277382*^9}, {3.476182557348547*^9, 3.476182562772886*^9}, 
   3.47618263201087*^9, {3.476182779541994*^9, 3.476182800372935*^9}, {
   3.47618298499048*^9, 3.476183148241543*^9}, {3.476183189234314*^9, 
   3.476183189870524*^9}, {3.476183252353296*^9, 3.476183261891067*^9}, {
   3.476183359925251*^9, 3.47618336069074*^9}, {3.476183823095433*^9, 
   3.476183902592314*^9}, {3.476184708016151*^9, 3.476184722772965*^9}, {
   3.476186143823951*^9, 3.476186190310217*^9}, {3.476186357672914*^9, 
   3.476186378923767*^9}, {3.476188520738623*^9, 3.476188590922096*^9}, {
   3.476188705952827*^9, 3.476188793390267*^9}, 3.476189580119497*^9, {
   3.476190067851158*^9, 3.476190168559251*^9}, 3.476190245155806*^9, {
   3.476190325831693*^9, 3.476190341169098*^9}, {3.476190402804851*^9, 
   3.476190430907566*^9}, {3.476190502847074*^9, 3.476190542213303*^9}, {
   3.476193177737772*^9, 3.476193215293226*^9}, {3.476193512902257*^9, 
   3.47619358439433*^9}, {3.476193783969585*^9, 3.476193793967452*^9}, {
   3.476193885629789*^9, 3.476193895403318*^9}, {3.476194020934819*^9, 
   3.476194026991394*^9}, {3.476194138302454*^9, 3.476194161964713*^9}, {
   3.476194419378587*^9, 3.476194426749716*^9}, {3.476194526651515*^9, 
   3.47619453259214*^9}, {3.476194629585487*^9, 3.476194648910703*^9}, {
   3.476195437998797*^9, 3.47619546077404*^9}, {3.476195513185536*^9, 
   3.476195517746517*^9}, {3.476195610863059*^9, 3.476195615821759*^9}, {
   3.476195835424486*^9, 3.476195849728121*^9}, {3.476195971489773*^9, 
   3.476196018993579*^9}, {3.47625120671418*^9, 3.476251260482289*^9}, {
   3.476415644431429*^9, 3.476415731981581*^9}, {3.4764159269121037`*^9, 
   3.4764159408841286`*^9}, {3.4764181118073626`*^9, 3.47641811540137*^9}, {
   3.4764193594692945`*^9, 3.4764193718693175`*^9}, {3.476427143329978*^9, 
   3.47642715158445*^9}, {3.476427339234183*^9, 3.4764273667607574`*^9}, {
   3.476427583555157*^9, 3.4764276272496567`*^9}, {3.4764279057985888`*^9, 
   3.4764279156431513`*^9}, {3.4764294764424243`*^9, 
   3.4764294772484703`*^9}, {3.476429812857666*^9, 3.4764298310877085`*^9}, {
   3.476430082926113*^9, 3.476430085528262*^9}, {3.47643134378223*^9, 
   3.4764314010925083`*^9}, {3.476431515158032*^9, 3.476431516958135*^9}, {
   3.476431560102603*^9, 3.4764316235012293`*^9}, {3.4764316877679048`*^9, 
   3.4764316883179364`*^9}, {3.476432477708087*^9, 3.476432479546192*^9}, {
   3.4764477956782246`*^9, 3.4764478413478365`*^9}, {3.4764479489729924`*^9, 
   3.476447953731265*^9}, {3.476447995072629*^9, 3.4764480496247497`*^9}, {
   3.476448081070548*^9, 3.476448101678727*^9}, {3.476448307009471*^9, 
   3.476448335103078*^9}, {3.4764485066298885`*^9, 3.4764485125672283`*^9}, {
   3.4764486110138593`*^9, 3.4764486285278606`*^9}, {3.4764488217459126`*^9, 
   3.4764488235120134`*^9}, {3.4764491473465357`*^9, 3.476449166039605*^9}, {
   3.4764492347605352`*^9, 3.4764492471232424`*^9}, {3.476595535679648*^9, 
   3.4765955682433863`*^9}, {3.476597779159789*^9, 3.476597796332193*^9}, {
   3.476600590813574*^9, 3.476600597712675*^9}, {3.476641554658431*^9, 
   3.476641562898902*^9}, {3.4766440824790134`*^9, 3.4766443166294065`*^9}, 
   3.476644672408756*^9, {3.4766453932829876`*^9, 3.476645398873307*^9}, {
   3.4767154694507093`*^9, 3.4767155140832615`*^9}, {3.4773757938316817`*^9, 
   3.477375801086097*^9}, {3.4773771762597523`*^9, 3.477377177979851*^9}, {
   3.4773772288457603`*^9, 3.47737725489725*^9}, {3.4773790046573305`*^9, 
   3.4773790694320354`*^9}, {3.4773792319383307`*^9, 
   3.4773792375666523`*^9}, {3.477379369338189*^9, 3.4773793694961977`*^9}, {
   3.477719167853462*^9, 3.477719179033102*^9}, {3.4777218787745185`*^9, 
   3.4777218923312936`*^9}, {3.4777370368995132`*^9, 
   3.4777370954508624`*^9}, {3.4777378545022774`*^9, 3.477737855109312*^9}, {
   3.4777379990765467`*^9, 3.4777379992905593`*^9}, {3.477738940178375*^9, 
   3.477738944046596*^9}, {3.477738980862702*^9, 3.4777389879031043`*^9}, {
   3.477739022195066*^9, 3.477739048193553*^9}, {3.4777395184274487`*^9, 
   3.477739520907591*^9}, {3.477739584804245*^9, 3.47773961863418*^9}, {
   3.4777396585544634`*^9, 3.4777396599215417`*^9}, {3.47773984574317*^9, 
   3.477739903348465*^9}, {3.477739947391984*^9, 3.477739966782093*^9}, 
   3.4777411098504725`*^9, {3.477741333331255*^9, 3.4777413575116386`*^9}, {
   3.477741651073429*^9, 3.4777416746117754`*^9}, {3.477741828215561*^9, 
   3.4777418299876623`*^9}, 3.477745802828896*^9, {3.4777463875883427`*^9, 
   3.4777464704420815`*^9}, {3.477747067888253*^9, 3.477747091684614*^9}, {
   3.4777474205364237`*^9, 3.4777474483350134`*^9}, {3.4777475155288568`*^9, 
   3.477747539939253*^9}, {3.477974556020076*^9, 3.477974560390326*^9}, {
   3.4779748681959314`*^9, 3.4779749568190002`*^9}, {3.477974992513042*^9, 
   3.4779750941538553`*^9}, {3.4782617789559526`*^9, 3.478261783956027*^9}, {
   3.478262202473913*^9, 3.4782622061046133`*^9}, {3.478262791535624*^9, 
   3.4782627928037167`*^9}, {3.4782628455260363`*^9, 
   3.4782628490163593`*^9}, {3.47826326694486*^9, 3.478263279177456*^9}, {
   3.478263404456361*^9, 3.4782634202175827`*^9}, {3.4782634641262207`*^9, 
   3.4782634985286913`*^9}, {3.478263587053833*^9, 3.478263670581818*^9}, {
   3.4782637056319733`*^9, 3.478263763856925*^9}, {3.4782638144450903`*^9, 
   3.478263994872282*^9}, {3.478264062626512*^9, 3.478264069460198*^9}, {
   3.4782645991329412`*^9, 3.4782646408844347`*^9}, {3.478264690062752*^9, 
   3.478264701564413*^9}, {3.478264761086781*^9, 3.47826489577745*^9}, {
   3.478268640778201*^9, 3.478268685608891*^9}, {3.478268744855324*^9, 
   3.4782687545887938`*^9}, {3.478268921634857*^9, 3.4782689533452806`*^9}, {
   3.4782691605447617`*^9, 3.478269254506781*^9}, {3.478269286658362*^9, 
   3.478269440444278*^9}, {3.4782694735100203`*^9, 3.4782694816568832`*^9}, {
   3.4782695788458853`*^9, 3.478269584179043*^9}, {3.478269683596146*^9, 
   3.478269690288425*^9}, {3.478269756841338*^9, 3.478269787263475*^9}, {
   3.478269866192107*^9, 3.478269883568101*^9}, {3.478270089228022*^9, 
   3.4782700933768187`*^9}, {3.478270149670952*^9, 3.4782701720018053`*^9}, {
   3.478271887965088*^9, 3.4782718918273153`*^9}, {3.478272556739908*^9, 
   3.478272717272318*^9}, {3.47827278247998*^9, 3.478272835492526*^9}, {
   3.4782952297957044`*^9, 3.4782952330498905`*^9}, {3.4783210188407536`*^9, 
   3.4783210350016775`*^9}, {3.478333042048442*^9, 3.4783330621185894`*^9}, {
   3.478336733854601*^9, 3.4783367774680953`*^9}, {3.4783368084518676`*^9, 
   3.478336866821206*^9}, {3.4783369146519423`*^9, 3.4783369677799807`*^9}, {
   3.478337012981566*^9, 3.4783370591402063`*^9}, {3.478337244814826*^9, 
   3.4783372454918647`*^9}, {3.478338491128111*^9, 3.478338548731406*^9}, {
   3.4783387868660264`*^9, 3.478338811740449*^9}, {3.478340120834325*^9, 
   3.478340122792437*^9}, {3.478340252188838*^9, 3.478340339876854*^9}, {
   3.4783405307577715`*^9, 3.4783405339959564`*^9}, {3.47834194112644*^9, 
   3.478341976057438*^9}, {3.4783460368277006`*^9, 3.478346045406191*^9}, {
   3.4783460785720882`*^9, 3.4783460892396984`*^9}, {3.478346325834231*^9, 
   3.478346336973868*^9}, {3.478348175614032*^9, 3.478348185578602*^9}, {
   3.478348308188615*^9, 3.4783483093106794`*^9}, {3.4783489471311607`*^9, 
   3.4783489787959714`*^9}, {3.478349185651803*^9, 3.4783491973714733`*^9}, {
   3.478356177461712*^9, 3.4783561804028797`*^9}, {3.478356831419116*^9, 
   3.4783568387245336`*^9}, {3.478416622622202*^9, 3.478416642552342*^9}, {
   3.478416716052546*^9, 3.478416727248186*^9}, {3.4784176423975296`*^9, 
   3.4784176845859427`*^9}, {3.4784181412440624`*^9, 
   3.4784181555628815`*^9}, {3.4784182316552334`*^9, 3.478418234953422*^9}, {
   3.478503277109909*^9, 3.4785032791150236`*^9}, {3.478503511840335*^9, 
   3.4785035132994184`*^9}, {3.4785038430042763`*^9, 
   3.4785038507357187`*^9}, {3.478504003991484*^9, 3.478504210586301*^9}, {
   3.478504241607075*^9, 3.4785042840335016`*^9}, {3.4785043146012497`*^9, 
   3.478504391148628*^9}, {3.478504674808853*^9, 3.4785050372995863`*^9}, {
   3.4785052931372194`*^9, 3.478505309285143*^9}, {3.4785053598240337`*^9, 
   3.4785054098258934`*^9}, 3.4785054444618745`*^9, {3.4785054749856205`*^9, 
   3.478505525585514*^9}, {3.4785055986166916`*^9, 3.4785056292914457`*^9}, {
   3.478506009067168*^9, 3.4785060388918743`*^9}, {3.478506070951708*^9, 
   3.4785061742826176`*^9}, 3.478506391871063*^9, {3.4785064587718897`*^9, 
   3.478506804669674*^9}, {3.478506843310884*^9, 3.4785068737166233`*^9}, {
   3.4785072404525995`*^9, 3.4785072447278438`*^9}, {3.4785074373458605`*^9, 
   3.4785075679943333`*^9}, {3.4785076676440334`*^9, 
   3.4785076924354515`*^9}, {3.478507772260017*^9, 3.4785078252570477`*^9}, {
   3.478507892221878*^9, 3.4785078949940367`*^9}, {3.478508437664076*^9, 
   3.478508445309513*^9}, {3.478508491657164*^9, 3.478508590961844*^9}, {
   3.4785087504619665`*^9, 3.478508792196354*^9}, {3.478508832776675*^9, 
   3.4785088375219464`*^9}, 3.478508996652048*^9, {3.478509082298947*^9, 
   3.4785091116346245`*^9}, {3.478509448339883*^9, 3.4785095319336643`*^9}, {
   3.4785096588169217`*^9, 3.4785096699295573`*^9}, {3.4785097086587725`*^9, 
   3.478509719819411*^9}, 3.4785098349249945`*^9, {3.478509998502351*^9, 
   3.4785100535094967`*^9}, {3.4785100968919783`*^9, 3.478510109211683*^9}, {
   3.4785101835279336`*^9, 3.4785102066112537`*^9}, {3.4785104015514035`*^9, 
   3.478510453892398*^9}, {3.4785107326643424`*^9, 3.478510734582452*^9}, {
   3.478511236012132*^9, 3.4785112829238157`*^9}, {3.4785119063834753`*^9, 
   3.4785119093206434`*^9}, {3.4785121124342604`*^9, 
   3.4785121919818106`*^9}, {3.4785122783127484`*^9, 3.478512332648856*^9}, {
   3.478512372347127*^9, 3.4785123894551053`*^9}, {3.4785124299624224`*^9, 
   3.4785125420478334`*^9}, {3.478512598348053*^9, 3.478512685426034*^9}, {
   3.4785127182319107`*^9, 3.478512722145134*^9}, {3.47851275529603*^9, 
   3.4785127744231243`*^9}, {3.4785128980361943`*^9, 3.478512929323984*^9}, {
   3.478512963817957*^9, 3.4785129671161456`*^9}, {3.47851299935699*^9, 
   3.478513001831131*^9}, {3.4785130475137444`*^9, 3.4785130662288146`*^9}, {
   3.4785132409348073`*^9, 3.4785133856190825`*^9}, {3.4785135766820107`*^9, 
   3.4785136475710654`*^9}, {3.478513778989582*^9, 3.4785138088732915`*^9}, {
   3.4785138915200186`*^9, 3.4785139408888426`*^9}, {3.4785139713875866`*^9, 
   3.4785139724106455`*^9}, {3.4785140912354417`*^9, 
   3.4785140929165373`*^9}, {3.478514722700559*^9, 3.478514728102868*^9}, {
   3.478516823979746*^9, 3.4785168330772657`*^9}, {3.478518623843692*^9, 
   3.478518626113822*^9}, {3.4785186879933615`*^9, 3.478518734934046*^9}, {
   3.478518793280383*^9, 3.478518881768444*^9}, {3.4785189173834815`*^9, 
   3.478518957097753*^9}, {3.4785189873854856`*^9, 3.4785190819268928`*^9}, {
   3.478519122369206*^9, 3.4785191283765497`*^9}, {3.4785210543857107`*^9, 
   3.478521060471059*^9}, {3.478522140485832*^9, 3.478522238114416*^9}, {
   3.478522311523615*^9, 3.4785223379611273`*^9}, {3.4785223791484833`*^9, 
   3.4785223795625067`*^9}, {3.4785274067020426`*^9, 
   3.4785274204338284`*^9}, {3.4785274997753663`*^9, 3.478527548494153*^9}, {
   3.4785275799459515`*^9, 3.478527602894264*^9}, {3.4785276353441205`*^9, 
   3.4785276355441313`*^9}, {3.478527688542163*^9, 3.478527900056261*^9}, {
   3.4785279302429876`*^9, 3.4785280621955347`*^9}, {3.478528110556301*^9, 
   3.478528333506053*^9}, {3.4785283856220336`*^9, 3.4785287957444916`*^9}, {
   3.4785288515166817`*^9, 3.4785288551378884`*^9}, {3.478528910703067*^9, 
   3.478528928663094*^9}, {3.478528987412454*^9, 3.4785291522948847`*^9}, {
   3.4785291943362894`*^9, 3.478529493368393*^9}, {3.478529592059038*^9, 
   3.478529597238334*^9}, {3.478529649208307*^9, 3.47852965363756*^9}, {
   3.478530106727475*^9, 3.4785301130628376`*^9}, {3.4785301805846996`*^9, 
   3.4785302380319853`*^9}, {3.4785306504335737`*^9, 3.478530690127844*^9}, {
   3.4785307618889484`*^9, 3.4785307683113155`*^9}, {3.4785308399714146`*^9, 
   3.4785308419105253`*^9}, {3.478531017264555*^9, 3.478531020271727*^9}, {
   3.4785311297799907`*^9, 3.478531164000948*^9}, {3.478531249098815*^9, 
   3.478531272035127*^9}, {3.4785342275451727`*^9, 3.47853423571264*^9}, {
   3.478536188384326*^9, 3.478536196425786*^9}, {3.478541564554826*^9, 
   3.4785416920021152`*^9}, {3.4785418885803585`*^9, 
   3.4785421046897197`*^9}, {3.4785421493632746`*^9, 
   3.4785422232044983`*^9}, {3.4785423628304844`*^9, 3.478542696083545*^9}, {
   3.4785427543978806`*^9, 3.478542760994258*^9}, {3.47854279757135*^9, 
   3.478542834722475*^9}, {3.4785428724986353`*^9, 3.4785429556113896`*^9}, {
   3.478543025860408*^9, 3.478543026187426*^9}, 3.4785430900890813`*^9, {
   3.4785431366037416`*^9, 3.478543306250445*^9}, {3.4785433413554525`*^9, 
   3.4785435259270096`*^9}, {3.478543609544792*^9, 3.4785436399415307`*^9}, {
   3.478543680885873*^9, 3.4785437031851482`*^9}, {3.4785437462796135`*^9, 
   3.4785437645396576`*^9}, {3.4785438036698956`*^9, 3.478543806002029*^9}, {
   3.4785438533707385`*^9, 3.4785438677795625`*^9}, {3.47854390550172*^9, 
   3.478543983291169*^9}, {3.4785440311489067`*^9, 3.478544077345549*^9}, {
   3.4785442367576666`*^9, 3.478544270659606*^9}, {3.4785443252377276`*^9, 
   3.4785443461669245`*^9}, {3.478544382061978*^9, 3.47854439556575*^9}, {
   3.478544453469062*^9, 3.4785445258572025`*^9}, {3.4785450562715406`*^9, 
   3.4785450800749016`*^9}, {3.4785452379829335`*^9, 
   3.4785452402400627`*^9}, {3.478545395309932*^9, 3.4785454532802477`*^9}, {
   3.4785456049979258`*^9, 3.478545730901127*^9}, {3.47854577798282*^9, 
   3.478545797632944*^9}, 3.4785461534832973`*^9, {3.478546199928954*^9, 
   3.47854631683364*^9}, {3.478546347876416*^9, 3.478546372857845*^9}, 
   3.478546431822217*^9, {3.4785465011471825`*^9, 3.4785465434896045`*^9}, 
   3.4785465870440955`*^9, {3.4785466964203515`*^9, 3.47854675722983*^9}, {
   3.4785467971491127`*^9, 3.478546880334871*^9}, {3.478546911529655*^9, 
   3.47854694588562*^9}, {3.4785470943241105`*^9, 3.4785471014305167`*^9}, {
   3.4785472704131823`*^9, 3.478547284690999*^9}, {3.47854737020489*^9, 
   3.478547493796959*^9}, {3.47854757738974*^9, 3.478547580574922*^9}, {
   3.4785476365611243`*^9, 3.4785480991695843`*^9}, {3.478548165109356*^9, 
   3.478548268250255*^9}, 3.4785485388527327`*^9, 3.4785489712214627`*^9, {
   3.4785507954148006`*^9, 3.4785507956048117`*^9}, {3.478550847046754*^9, 
   3.4785508789665794`*^9}, {3.4785509619563265`*^9, 3.478550963875436*^9}, {
   3.478551109442762*^9, 3.4785511131929765`*^9}, {3.478588246682927*^9, 
   3.4785882468239346`*^9}, {3.4785883115756383`*^9, 3.478588328810624*^9}, {
   3.4785886255365963`*^9, 3.4785886281917477`*^9}, {3.4785886921144037`*^9, 
   3.478588852692589*^9}, {3.4785888898907166`*^9, 3.4785889731914806`*^9}, {
   3.478589012943754*^9, 3.478589121682974*^9}, {3.478589156509966*^9, 
   3.4785891717668386`*^9}, {3.478589321010375*^9, 3.4785893306049232`*^9}, {
   3.478589418982979*^9, 3.4785894405132103`*^9}, {3.4785895689755573`*^9, 
   3.4785895796201663`*^9}, {3.478589666718148*^9, 3.4785897041332884`*^9}, {
   3.4785900959977016`*^9, 3.478590102508074*^9}, {3.4785902200287957`*^9, 
   3.4785902473533587`*^9}, {3.478590294670065*^9, 3.478590375578693*^9}, {
   3.4785906033267193`*^9, 3.4785906431029944`*^9}, {3.4785908721280937`*^9, 
   3.47859087713238*^9}, {3.4785909908888865`*^9, 3.4785910067477937`*^9}, {
   3.4785911446036787`*^9, 3.478591194057507*^9}, 3.478591499122956*^9, {
   3.478591581422663*^9, 3.478591602160849*^9}, {3.4785916330066137`*^9, 
   3.4785916353967505`*^9}, {3.4785916765941067`*^9, 
   3.4785917520504227`*^9}, {3.4785918614926825`*^9, 
   3.4785918790446863`*^9}, {3.478591912828618*^9, 3.478591946491544*^9}, {
   3.4785920873866024`*^9, 3.478592090766796*^9}, {3.478592174285573*^9, 
   3.4785921979479265`*^9}, {3.4785922750393353`*^9, 3.478592298590683*^9}, {
   3.4785923708478155`*^9, 3.478592386366703*^9}, {3.4785936355941553`*^9, 
   3.4785936816387887`*^9}, {3.478594215727337*^9, 3.4785942682463408`*^9}, {
   3.478594327315719*^9, 3.478594409246405*^9}, {3.4785947530660706`*^9, 
   3.478594788352089*^9}, {3.4785948498546066`*^9, 3.478594865038475*^9}, {
   3.478595232489492*^9, 3.4785952736408463`*^9}, {3.4785959899968195`*^9, 
   3.4785960162123184`*^9}, {3.478597717247612*^9, 3.478597746143265*^9}, {
   3.4785979369821806`*^9, 3.478597953625132*^9}, {3.4785980927850914`*^9, 
   3.478598095588252*^9}, {3.4785983386181526`*^9, 3.4785983458885684`*^9}, {
   3.4785984634692936`*^9, 3.478598463965322*^9}, {3.4785985475431023`*^9, 
   3.4785985531994257`*^9}, {3.478598596438899*^9, 3.4785986372922354`*^9}, {
   3.478606696748166*^9, 3.4786068433826323`*^9}, {3.4786068991220355`*^9, 
   3.478606926504508*^9}, {3.4786069584051294`*^9, 3.4786069602359114`*^9}, {
   3.4786095607851706`*^9, 3.4786096126759677`*^9}, {3.478609686747105*^9, 
   3.4786096929447002`*^9}, {3.4786097781147585`*^9, 3.478609798923828*^9}, {
   3.4786099772753177`*^9, 3.4786099781603312`*^9}, {3.4786102235216*^9, 
   3.4786102588533926`*^9}, {3.4786104687719793`*^9, 3.478610472770791*^9}, {
   3.478612383035628*^9, 3.4786124745968647`*^9}, {3.478615927965005*^9, 
   3.478616036886935*^9}, {3.478616072769487*^9, 3.4786161366605225`*^9}, {
   3.4788348723927526`*^9, 3.4788348725607624`*^9}, {3.4788356924526577`*^9, 
   3.478835693231702*^9}, 3.47883582571728*^9, {3.4788361461836095`*^9, 
   3.478836171488057*^9}, {3.4788362087281866`*^9, 3.4788362777341337`*^9}, {
   3.478836317967435*^9, 3.478836344783969*^9}, {3.478836389997555*^9, 
   3.4788364110887613`*^9}, {3.478836447557847*^9, 3.4788364531851687`*^9}, {
   3.478836531095625*^9, 3.4788365605223083`*^9}, {3.4788365920091095`*^9, 
   3.4788366060169106`*^9}, {3.478836636739668*^9, 3.4788366579668818`*^9}, {
   3.4788367805768948`*^9, 3.4788367815749516`*^9}, {3.478838256303301*^9, 
   3.4788382629666824`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "USER"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]\
, " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"INPUT", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{
                    "--", " ", 
                    "USER"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]\
, " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"INPUT", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
       "--"}], "--"}]}], "-", 
    RowBox[{"-", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"-", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
   "*)"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{
                    "--", " ", 
                    "USER"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]\
, " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"INPUT", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
       "--"}], "--"}]}], "-", 
    RowBox[{"-", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"-", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
   "*)"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "USER"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]\
, " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"INPUT", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
       "--"}], "--"}]}], "-", 
    RowBox[{"-", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"-", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "-", " ", 
                    "Variety"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}\
], " ", "defining", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"data", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
        "--"}], "--"}], "--"}]}], "-", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"P1xP1", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", "Coordinates", "*)"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u1", ",", "u2", ",", "u3", ",", "u4"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Stanley", " ", "Reisner"}], "*)"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u1", ",", "u2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u3", ",", "u4"}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Equivalence", " ", "Relations"}], "*)"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dP1", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", "Coordinates", "*)"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u1", ",", "u2", ",", "u3", ",", "u4"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Stanley", " ", "Reisner"}], "*)"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u1", ",", "u2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u3", ",", "u4"}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Equivalence", " ", "Relations"}], "*)"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dP2", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", "Coordinates", "*)"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u1", ",", "u2", ",", "u3", ",", "u4", ",", "u5"}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Stanley", " ", "Reisner"}], "*)"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u1", ",", "u2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u1", ",", "u3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u2", ",", "u5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u3", ",", "u4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u4", ",", "u5"}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Equivalence", " ", "Relations"}], "*)"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
      "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dP3", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", "Coordinates", "*)"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u1", ",", "u2", ",", "u3", ",", "u4", ",", "u5", ",", "u6"}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Stanley", " ", "Reisner"}], "*)"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u1", ",", "u2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u1", ",", "u3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u1", ",", "u6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u2", ",", "u3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u2", ",", "u5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u3", ",", "u4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u4", ",", "u5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u4", ",", "u6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u5", ",", "u6"}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Equivalence", " ", "Relations"}], "*)"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
      "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "End"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
     " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"definitions", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
      "--"}], 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"-", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}],
     "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{
                    "--", " ", 
                    "Start"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}],
      " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"calculations", " ", "--"}], "--"}], "--"}], "--"}], 
         "--"}], "--"}], "--"}], "--"}], 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"-", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"-", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"-", 
                  RowBox[{"--", 
                   RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", " ", 
                    RowBox[{"!!", 
                    RowBox[{"!", " ", 
                    RowBox[{
                    RowBox[{"Start", " ", "this", " ", "routine", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"first", " ", "!!"}], "!"}], " ", "--"}], "--"}], 
                    "--"}], "--"}]}], "-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"-", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", 
                    RowBox[{"-", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]\
}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"-", 
         RowBox[{"--", 
          RowBox[{"-", 
           RowBox[{"--", "The"}]}]}]}]}]}], " ", 
      RowBox[{"routine", " ", "'"}], 
      RowBox[{"GenerateSecondarySequences", "'"}], " ", "needs", " ", "to", 
      " ", "be", " ", "started", " ", "for", " ", "each", " ", "new", " ", 
      "variety", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"once", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
       "--"}]}], "-", 
     RowBox[{"--", 
      RowBox[{"-", "-"}]}]}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", "  ", 
   RowBox[{
    RowBox[{"GenerateSecondarySequences", "[", "dP3", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4754712396638117`*^9, 3.475471241679927*^9}, {
   3.4754713597756815`*^9, 3.4754713629598637`*^9}, {3.4754713950246973`*^9, 
   3.4754714291996527`*^9}, {3.475471461697511*^9, 3.4754714643846645`*^9}, {
   3.4754721129767623`*^9, 3.4754721525450253`*^9}, {3.475472735889391*^9, 
   3.4754727707763863`*^9}, {3.4754731533602686`*^9, 3.475473157264492*^9}, {
   3.4754734171143546`*^9, 3.4754734448409405`*^9}, {3.4754736122975187`*^9, 
   3.475473625137253*^9}, {3.4754736704168425`*^9, 3.4754737081289997`*^9}, {
   3.475474160665883*^9, 3.475474275946477*^9}, {3.475474486522521*^9, 
   3.475474521498522*^9}, {3.4754746293306894`*^9, 3.4754746832157717`*^9}, {
   3.4754749484799433`*^9, 3.47547496624496*^9}, 3.4754751906917973`*^9, {
   3.475475229427013*^9, 3.4754752314191265`*^9}, {3.4754752770207353`*^9, 
   3.4754753110836835`*^9}, {3.4754753933473887`*^9, 
   3.4754754086602645`*^9}, {3.475475693579561*^9, 3.475475700610963*^9}, {
   3.4754762238268895`*^9, 3.4754762834893017`*^9}, {3.4754763386284556`*^9, 
   3.475476399699949*^9}, {3.4754910603574905`*^9, 3.475491063075646*^9}, {
   3.475491215138343*^9, 3.4754912414198465`*^9}, {3.475491413923713*^9, 
   3.4754914418193088`*^9}, {3.4754915019947505`*^9, 
   3.4754915037388506`*^9}, {3.475491627201912*^9, 3.475491637930526*^9}, {
   3.4754922923539567`*^9, 3.4754923227396946`*^9}, {3.4754926675324154`*^9, 
   3.4754927969238167`*^9}, {3.4754928271395445`*^9, 
   3.4754928577002926`*^9}, {3.4754930921557026`*^9, 
   3.4754930940278096`*^9}, {3.475493146415806*^9, 3.4754932132126265`*^9}, {
   3.47549523524228*^9, 3.4754952670951023`*^9}, {3.4754953029661536`*^9, 
   3.4754953668118057`*^9}, {3.475495443447189*^9, 3.475495476723092*^9}, {
   3.4754958334494953`*^9, 3.4754958461932244`*^9}, {3.4754959793838425`*^9, 
   3.475496155672926*^9}, {3.475496234612441*^9, 3.475496249795309*^9}, {
   3.47557728155598*^9, 3.475577309937604*^9}, {3.4755776045724554`*^9, 
   3.475577741502288*^9}, {3.4755778084421167`*^9, 3.475577924316744*^9}, {
   3.475577984513187*^9, 3.4755780225953655`*^9}, {3.47557805379315*^9, 
   3.475578076383442*^9}, {3.4755783713093104`*^9, 3.475578739137349*^9}, {
   3.4755789705165834`*^9, 3.4755789905717306`*^9}, {3.4755790838010626`*^9, 
   3.475579086565221*^9}, {3.475579226683235*^9, 3.475579228467337*^9}, {
   3.475579981917432*^9, 3.475579982358457*^9}, 3.4755800481542206`*^9, {
   3.475580301026684*^9, 3.475580329033286*^9}, {3.4755807981821194`*^9, 
   3.475580826052714*^9}, {3.475580928672583*^9, 3.475580959098324*^9}, {
   3.475580990764135*^9, 3.4755810937450247`*^9}, {3.475584745069869*^9, 
   3.4755847585586405`*^9}, {3.4755881206449404`*^9, 
   3.4755881217090015`*^9}, {3.475588334271159*^9, 3.475588344462742*^9}, {
   3.4755884326457863`*^9, 3.4755884343748846`*^9}, {3.4755884702299356`*^9, 
   3.47558847188603*^9}, {3.4755928836593695`*^9, 3.47559295674855*^9}, {
   3.475593268954407*^9, 3.475593289780598*^9}, {3.475824387384571*^9, 
   3.475824388975665*^9}, {3.475824564812435*^9, 3.475824599077831*^9}, {
   3.475824658915563*^9, 3.475824738669712*^9}, {3.475824775983107*^9, 
   3.475824788862617*^9}, {3.475825041309424*^9, 3.475825114387264*^9}, {
   3.475825156286184*^9, 3.475825163070629*^9}, {3.475825293135227*^9, 
   3.475825308327557*^9}, {3.475825388367079*^9, 3.475825389410461*^9}, {
   3.475828212903632*^9, 3.475828218804282*^9}, {3.475828353065887*^9, 
   3.475828367431664*^9}, {3.47583137417651*^9, 3.475831433140855*^9}, {
   3.475832201281927*^9, 3.475832271257032*^9}, 3.475832416656941*^9, {
   3.475832471153905*^9, 3.475832493277225*^9}, 3.475832575953631*^9, 
   3.475832616420779*^9, {3.475832673447809*^9, 3.475832742229484*^9}, {
   3.475833995193276*^9, 3.475833997914763*^9}, {3.475836324781135*^9, 
   3.475836337929808*^9}, {3.475836461028765*^9, 3.475836634974765*^9}, {
   3.475836797954895*^9, 3.475836814248972*^9}, {3.47584110643042*^9, 
   3.475841278072066*^9}, {3.475842419236806*^9, 3.475842586221347*^9}, {
   3.475842922391429*^9, 3.475842932519342*^9}, {3.475842996891157*^9, 
   3.475842999029693*^9}, {3.4759186479489117`*^9, 3.475918667410746*^9}, {
   3.475919515083209*^9, 3.475919535006506*^9}, {3.475919613391073*^9, 
   3.475919617469378*^9}, {3.475919845930201*^9, 3.47591984866238*^9}, {
   3.4759202158927727`*^9, 3.475920248255118*^9}, {3.4759202811579227`*^9, 
   3.475920324665441*^9}, {3.475920446864231*^9, 3.47592045393054*^9}, {
   3.475920677431959*^9, 3.4759206999015636`*^9}, {3.475920945063147*^9, 
   3.475920946904478*^9}, {3.475921015223071*^9, 3.475921022168972*^9}, {
   3.475921085578589*^9, 3.475921179249588*^9}, {3.475921838897417*^9, 
   3.4759219259098167`*^9}, {3.475922060196763*^9, 3.475922080536063*^9}, {
   3.4759221203893757`*^9, 3.47592212830608*^9}, {3.475929521168737*^9, 
   3.4759295464282293`*^9}, {3.475929737173584*^9, 3.475929737490212*^9}, {
   3.475930115562149*^9, 3.475930117577306*^9}, {3.475930531480497*^9, 
   3.475930585841468*^9}, {3.4759306367200108`*^9, 3.475930638420156*^9}, {
   3.475930959160925*^9, 3.475931000274953*^9}, 3.475934895917326*^9, {
   3.475935003509846*^9, 3.475935060159532*^9}, {3.475952744732659*^9, 
   3.475952766438072*^9}, {3.475952850977836*^9, 3.475952923844129*^9}, {
   3.475992236254241*^9, 3.475992244502715*^9}, {3.476019737045364*^9, 
   3.476019743876079*^9}, {3.476019842269404*^9, 3.476019878176867*^9}, {
   3.47603628155395*^9, 3.476036291871351*^9}, {3.476036365460675*^9, 
   3.476036384149256*^9}, {3.476083920753813*^9, 3.476084024972393*^9}, {
   3.476084802158477*^9, 3.476084849110994*^9}, {3.476085438241455*^9, 
   3.47608544079556*^9}, {3.476085514151503*^9, 3.476085553570556*^9}, {
   3.476088998987167*^9, 3.47608900387359*^9}, {3.476094909480675*^9, 
   3.476094915424165*^9}, {3.476097229946041*^9, 3.476097271493331*^9}, {
   3.47609732057186*^9, 3.476097326262605*^9}, {3.476097572395584*^9, 
   3.476097775572297*^9}, {3.476160066876089*^9, 3.476160075714471*^9}, {
   3.476160461192863*^9, 3.47616046638761*^9}, {3.476160578875965*^9, 
   3.476160599642337*^9}, {3.476163261050263*^9, 3.476163310278581*^9}, {
   3.476163595998904*^9, 3.476163600374386*^9}, {3.476163635088011*^9, 
   3.476163652565654*^9}, 3.47616376521214*^9, 3.476163889022647*^9, {
   3.476166253986754*^9, 3.476166337987202*^9}, {3.476166371261042*^9, 
   3.476166396319991*^9}, {3.476166456380632*^9, 3.476166461792948*^9}, {
   3.476171102950073*^9, 3.476171138281873*^9}, {3.476183643706678*^9, 
   3.476183672865727*^9}, 3.476184118126508*^9, {3.47618422477228*^9, 
   3.476184229106159*^9}, {3.4761930222808*^9, 3.476193029692188*^9}, 
   3.476194206850808*^9, {3.476201036205081*^9, 3.476201047002808*^9}, {
   3.476261261059411*^9, 3.47626129212399*^9}, {3.476415385645029*^9, 
   3.476415545653284*^9}, {3.476415864349884*^9, 3.476415887915927*^9}, {
   3.476418064025277*^9, 3.4764180692272854`*^9}, {3.47641962784124*^9, 
   3.476419635811251*^9}, {3.476419742283561*^9, 3.476419776197611*^9}, {
   3.4764198820238533`*^9, 3.4764198821138535`*^9}, 3.476421630128641*^9, {
   3.476424239197871*^9, 3.4764243086628437`*^9}, {3.476426666452702*^9, 
   3.4764266788224096`*^9}, {3.47642801125262*^9, 3.4764280119726615`*^9}, 
   3.4764280901361322`*^9, {3.476429124533296*^9, 3.476429145493495*^9}, {
   3.4764306052229867`*^9, 3.476430648589467*^9}, {3.476430730192135*^9, 
   3.4764309243622403`*^9}, {3.4764309716059427`*^9, 
   3.4764310048908463`*^9}, {3.4764321644841714`*^9, 
   3.4764321770728917`*^9}, {3.4764322659109726`*^9, 3.476432296477721*^9}, {
   3.476432524992791*^9, 3.476432525360812*^9}, {3.476432652474083*^9, 
   3.4764326681359787`*^9}, 3.4764327848816557`*^9, {3.4764344732372246`*^9, 
   3.476434651068396*^9}, {3.476434702982365*^9, 3.476434708052655*^9}, {
   3.4764347386564054`*^9, 3.4764347863141317`*^9}, {3.4764348423283353`*^9, 
   3.4764348472286158`*^9}, {3.476434964655332*^9, 3.476434988870717*^9}, {
   3.476435132850952*^9, 3.4764351904832487`*^9}, {3.4764355491667643`*^9, 
   3.4764355764783263`*^9}, {3.4764412012470446`*^9, 
   3.4764412620335217`*^9}, {3.4764414320972486`*^9, 3.476441447522131*^9}, {
   3.4764441783763266`*^9, 3.476444242505995*^9}, {3.4764442740748005`*^9, 
   3.476444340370592*^9}, {3.476446006574894*^9, 3.476446148741025*^9}, {
   3.4764462486597404`*^9, 3.4764462491697693`*^9}, {3.476448128494261*^9, 
   3.476448170981691*^9}, {3.476448646094866*^9, 3.4764486708692827`*^9}, {
   3.4764491243192186`*^9, 3.476449130133551*^9}, {3.4764494809096146`*^9, 
   3.4764494886070547`*^9}, 3.4764495685026245`*^9, {3.4764497006801844`*^9, 
   3.476449722488432*^9}, {3.476449756233362*^9, 3.4764497866140995`*^9}, {
   3.476449923479928*^9, 3.476449968343494*^9}, {3.476540475930149*^9, 
   3.4765407048184586`*^9}, {3.476540759873836*^9, 3.476540834340741*^9}, 
   3.4765408759188795`*^9, {3.4765409241006246`*^9, 3.4765411381809454`*^9}, {
   3.476541191437268*^9, 3.4765411989976363`*^9}, {3.476541778723277*^9, 
   3.4765419125678596`*^9}, {3.476543999141811*^9, 3.476544136458444*^9}, {
   3.476544351728434*^9, 3.4765443528612146`*^9}, {3.476544430612341*^9, 
   3.4765444754727874`*^9}, {3.476594318114738*^9, 3.4765943271682796`*^9}, {
   3.47659481442234*^9, 3.476594817368342*^9}, {3.476594852630322*^9, 
   3.4765949178556767`*^9}, {3.476595498423071*^9, 3.476595508749268*^9}, {
   3.476595713088649*^9, 3.476595758418211*^9}, {3.476596572334556*^9, 
   3.47659662971446*^9}, {3.476597013587328*^9, 3.476597039091316*^9}, 
   3.476597086547945*^9, {3.4765973853260098`*^9, 3.476597436513649*^9}, {
   3.4765975034342546`*^9, 3.476597526438991*^9}, {3.476624060472022*^9, 
   3.4766241413396473`*^9}, 3.4766413875798745`*^9, {3.476644406781563*^9, 
   3.476644473881401*^9}, {3.4766445978744926`*^9, 3.4766445990375595`*^9}, 
   3.476645070108503*^9, {3.476645117541216*^9, 3.4766451177092257`*^9}, {
   3.4766455091136127`*^9, 3.476645513642872*^9}, {3.476646900737209*^9, 
   3.4766470097914467`*^9}, {3.4766470398071632`*^9, 3.47664708643283*^9}, {
   3.476687758837244*^9, 3.476687764413863*^9}, {3.476688068152589*^9, 
   3.47668810514856*^9}, {3.4766885712953873`*^9, 3.476688593992877*^9}, {
   3.476712520992067*^9, 3.4767125250632997`*^9}, {3.4767155338693933`*^9, 
   3.476715722872204*^9}, {3.4767157560150995`*^9, 3.4767157565161285`*^9}, {
   3.4767159563365574`*^9, 3.47671596459803*^9}, {3.476716123041092*^9, 
   3.4767161683446836`*^9}, {3.476716437770094*^9, 3.4767164397582073`*^9}, {
   3.4767165273232155`*^9, 3.4767166068467646`*^9}, {3.4767240215443635`*^9, 
   3.476724046399785*^9}, {3.47672409823075*^9, 3.4767243735194955`*^9}, {
   3.4767248434223723`*^9, 3.476724866960719*^9}, {3.476728265410099*^9, 
   3.476728268112253*^9}, {3.4767283836438613`*^9, 3.476728448008543*^9}, {
   3.476728493393139*^9, 3.476728505026804*^9}, {3.4767321406137476`*^9, 
   3.4767321667462425`*^9}, {3.4767326898050723`*^9, 
   3.4767326960324287`*^9}, {3.4767327371017747`*^9, 3.476732757264923*^9}, {
   3.476733027803217*^9, 3.4767330936742287`*^9}, {3.476733147177551*^9, 
   3.476733153517648*^9}, {3.4767331981883345`*^9, 3.4767332208836827`*^9}, {
   3.4767335214419384`*^9, 3.4767335227369585`*^9}, {3.476734954270314*^9, 
   3.4767350514994326`*^9}, {3.47673510833568*^9, 3.4767351126087613`*^9}, 
   3.4767358401045523`*^9, {3.476736190052593*^9, 3.4767362348349333`*^9}, {
   3.4767742263261557`*^9, 3.476774227173669*^9}, {3.4767744109789925`*^9, 
   3.476774411408999*^9}, {3.4773755184619317`*^9, 3.4773755768242693`*^9}, {
   3.477375725300762*^9, 3.4773757515032606`*^9}, {3.477375827093584*^9, 
   3.477375842976493*^9}, {3.477376110848814*^9, 3.4773761194783077`*^9}, {
   3.4773768322080736`*^9, 3.477376918020982*^9}, {3.477376970002955*^9, 
   3.47737705715594*^9}, {3.4773770945960813`*^9, 3.4773771284460173`*^9}, {
   3.477377343342309*^9, 3.477377364747533*^9}, {3.477377435778596*^9, 
   3.4773774502484236`*^9}, {3.477377523015586*^9, 3.4773776939383616`*^9}, {
   3.477377767704581*^9, 3.4773777881537504`*^9}, {3.4773779026773005`*^9, 
   3.4773779153770275`*^9}, {3.4773790856289616`*^9, 3.477379118617849*^9}, {
   3.477379972304677*^9, 3.477380149431808*^9}, {3.4773802422791185`*^9, 
   3.4773803048096952`*^9}, 3.4773804198602753`*^9, {3.4773804687980747`*^9, 
   3.477380477780588*^9}, {3.4773806158404846`*^9, 3.477380620145731*^9}, {
   3.4773807318471203`*^9, 3.4773808024141564`*^9}, {3.4773809190088253`*^9, 
   3.4773809516066895`*^9}, {3.477380993610092*^9, 3.4773811148580275`*^9}, {
   3.47738118589109*^9, 3.4773813073780384`*^9}, {3.4773820567028975`*^9, 
   3.4773820576129494`*^9}, {3.477382122168642*^9, 3.4773821488781695`*^9}, {
   3.477382205267395*^9, 3.4773822529371214`*^9}, {3.4773823125185294`*^9, 
   3.477382316531759*^9}, 3.477382445546138*^9, {3.477382593016573*^9, 
   3.477382613616751*^9}, {3.477382668866911*^9, 3.477382684660815*^9}, {
   3.4773827323605433`*^9, 3.4773827334686065`*^9}, {3.4773830358058987`*^9, 
   3.4773831276771536`*^9}, {3.477383324703423*^9, 3.4773833270845594`*^9}, {
   3.4773833680129004`*^9, 3.477383399047675*^9}, {3.477387543493724*^9, 
   3.477387545913862*^9}, {3.4773903256558547`*^9, 3.4773903383605814`*^9}, {
   3.4773904537391806`*^9, 3.4773904660348835`*^9}, {3.477390522169094*^9, 
   3.477390655897743*^9}, 3.4773907979578686`*^9, {3.477390859058364*^9, 
   3.477390913704489*^9}, {3.4773910380155993`*^9, 3.477391042005828*^9}, {
   3.4773911106107516`*^9, 3.477391138614353*^9}, {3.4773914445188503`*^9, 
   3.4773914581656303`*^9}, {3.4773946525303373`*^9, 
   3.4773946527723513`*^9}, {3.4773963127502966`*^9, 3.477396375835905*^9}, {
   3.4773966115723886`*^9, 3.4773966552148848`*^9}, {3.4773967968979883`*^9, 
   3.477396856050372*^9}, {3.477397000010606*^9, 3.477397003956832*^9}, {
   3.477397340873102*^9, 3.4773973660775433`*^9}, {3.477397800324381*^9, 
   3.477397875116659*^9}, {3.477397919030171*^9, 3.477397931098861*^9}, {
   3.477398552396397*^9, 3.4773985527334166`*^9}, {3.477398729849547*^9, 
   3.4773987440723605`*^9}, {3.477400332736227*^9, 3.4774003899454994`*^9}, {
   3.4774006999522305`*^9, 3.4774007627428217`*^9}, 3.4774008564121795`*^9, {
   3.4774008865609035`*^9, 3.477400922349951*^9}, {3.477407750765514*^9, 
   3.4774078039635563`*^9}, {3.4776609828769703`*^9, 
   3.4776610988876057`*^9}, {3.4776611672595167`*^9, 3.477661174454928*^9}, {
   3.4776617484347577`*^9, 3.477661844686263*^9}, {3.477661899270385*^9, 
   3.4776619549425693`*^9}, {3.4776620088246512`*^9, 3.477662024974575*^9}, {
   3.4776620992378225`*^9, 3.477662147469581*^9}, 3.477662179054388*^9, {
   3.4776622411349387`*^9, 3.477662274971874*^9}, {3.477662503040919*^9, 
   3.4776625452613335`*^9}, {3.47766271443801*^9, 3.477662715050045*^9}, 
   3.477662836019964*^9, {3.4776641905904408`*^9, 3.4776642075184093`*^9}, {
   3.477718348019571*^9, 3.477718407769988*^9}, {3.477718460501004*^9, 
   3.4777185046405287`*^9}, {3.4777185677441382`*^9, 
   3.4777186247623997`*^9}, {3.477718673353179*^9, 3.47771871061331*^9}, {
   3.477718921498372*^9, 3.4777189357181854`*^9}, {3.477719068189762*^9, 
   3.477719087058841*^9}, {3.4777213612249165`*^9, 3.477721570763901*^9}, {
   3.4777216150934367`*^9, 3.477721634260533*^9}, {3.477721669631556*^9, 
   3.4777217011323576`*^9}, 3.477721753085329*^9, {3.4777218531800547`*^9, 
   3.477721857777317*^9}, {3.4777221750874662`*^9, 3.477722187787193*^9}, {
   3.477722271347972*^9, 3.477722273430091*^9}, {3.477722350313489*^9, 
   3.477722356422838*^9}, 3.4777224779387884`*^9, {3.4777238019875197`*^9, 
   3.477723960021559*^9}, {3.477725546269287*^9, 3.4777255630782485`*^9}, {
   3.477725747362789*^9, 3.4777258453993964`*^9}, {3.477729141951948*^9, 
   3.4777292540463595`*^9}, {3.47773671251896*^9, 3.4777367328941255`*^9}, {
   3.4777367823439536`*^9, 3.477736824098342*^9}, {3.4777368854958534`*^9, 
   3.4777369863486223`*^9}, {3.4777371139689217`*^9, 
   3.4777371874151225`*^9}, {3.477737248804634*^9, 3.4777372498166914`*^9}, {
   3.4777373629161606`*^9, 3.4777373981961784`*^9}, {3.47773803234645*^9, 
   3.4777380675204616`*^9}, {3.4777381161922455`*^9, 
   3.4777381172533064`*^9}, {3.4777385825939217`*^9, 3.477738595227645*^9}, {
   3.477738818394409*^9, 3.477738825794832*^9}, {3.4777388899265003`*^9, 
   3.4777389260785685`*^9}, 3.4777393277645435`*^9, 3.477739771734937*^9, {
   3.4777417004372525`*^9, 3.477741701375306*^9}, {3.4777449840540648`*^9, 
   3.477745026434489*^9}, {3.47774518206039*^9, 3.4777452430738797`*^9}, {
   3.47774558120822*^9, 3.477745631822115*^9}, {3.4777457332359157`*^9, 
   3.477745737025132*^9}, {3.4777457762593765`*^9, 3.4777457828427525`*^9}, 
   3.477745881830415*^9, {3.477746042891627*^9, 3.477746043071637*^9}, {
   3.4777461694738665`*^9, 3.4777462723707523`*^9}, {3.4777465577580757`*^9, 
   3.4777466237428493`*^9}, {3.4777466610179815`*^9, 3.477746721646449*^9}, {
   3.477747116389027*^9, 3.4777471172600775`*^9}, {3.4777471970626416`*^9, 
   3.4777472061731625`*^9}, 3.4777472419142065`*^9, 3.4777473549386716`*^9, {
   3.4777515070711603`*^9, 3.4777516505833683`*^9}, 3.4779747517602715`*^9, {
   3.4779748098765955`*^9, 3.4779748213302507`*^9}, {3.4779751219944477`*^9, 
   3.477975215723809*^9}, {3.4779782568537517`*^9, 3.477978308600711*^9}, {
   3.477978358442562*^9, 3.477978581589325*^9}, {3.4779786794279213`*^9, 
   3.4779787170280724`*^9}, {3.477978789352209*^9, 3.4779788425202494`*^9}, {
   3.4779788968303556`*^9, 3.477978901885645*^9}, {3.4779789481552916`*^9, 
   3.477978958475882*^9}, {3.477979010733871*^9, 3.477979012394966*^9}, {
   3.4779793279640155`*^9, 3.4779793322762623`*^9}, {3.477979772924466*^9, 
   3.4779797869472675`*^9}, 3.477980113771961*^9, {3.4779805064934235`*^9, 
   3.477980508572542*^9}, {3.4779841336548853`*^9, 3.4779841663187532`*^9}, {
   3.4779880069904275`*^9, 3.477988010270615*^9}, {3.4779881080372066`*^9, 
   3.477988122169015*^9}, {3.477988176073098*^9, 3.4779882395857315`*^9}, {
   3.4779884878629313`*^9, 3.4779885289302807`*^9}, 3.477988595863109*^9, 
   3.4779890978728223`*^9, {3.477990618184779*^9, 3.4779906272002945`*^9}, {
   3.4779920811054535`*^9, 3.477992083692601*^9}, {3.4779921161484575`*^9, 
   3.4779922002442675`*^9}, {3.4779956709707823`*^9, 3.477995702653594*^9}, {
   3.4779959853887653`*^9, 3.477996001182669*^9}, {3.4779962256705093`*^9, 
   3.477996231244828*^9}, {3.4779964190795717`*^9, 3.477996423901847*^9}, {
   3.477996511985885*^9, 3.477996522435483*^9}, {3.477996552903226*^9, 
   3.477996592095467*^9}, {3.4779971856574173`*^9, 3.477997189343628*^9}, {
   3.477997220865431*^9, 3.4779972466989083`*^9}, {3.4779972913034596`*^9, 
   3.4779972967347703`*^9}, {3.4779977770462427`*^9, 
   3.4779977783183155`*^9}, {3.478001803504543*^9, 3.4780018263418493`*^9}, {
   3.4780020724159236`*^9, 3.4780020736639953`*^9}, {3.478002291341446*^9, 
   3.4780023301676664`*^9}, 3.478002632160939*^9, {3.478002867736414*^9, 
   3.478002869230499*^9}, {3.47800432842696*^9, 3.4780043468640146`*^9}, {
   3.4780046673333445`*^9, 3.4780046722336245`*^9}, {3.478004754450327*^9, 
   3.4780047587035704`*^9}, {3.4780048252303753`*^9, 
   3.4780048258214097`*^9}, {3.4782578795741873`*^9, 3.478257894875759*^9}, {
   3.478257982481341*^9, 3.478258096291967*^9}, {3.478259770150591*^9, 
   3.478259826818099*^9}, 3.478259877335403*^9, {3.478261325232768*^9, 
   3.478261421489497*^9}, {3.478261466844434*^9, 3.478261592495919*^9}, {
   3.478261637748761*^9, 3.478261685329041*^9}, {3.478261724242852*^9, 
   3.4782617345414553`*^9}, {3.478261972055069*^9, 3.478261974795879*^9}, {
   3.478270485118943*^9, 3.478270489293089*^9}, {3.478270534461461*^9, 
   3.478270591275558*^9}, {3.478270653888956*^9, 3.478270670776176*^9}, {
   3.478270754052126*^9, 3.478270889461248*^9}, {3.4782721350161047`*^9, 
   3.4782721576048107`*^9}, 3.478272201477927*^9, {3.478289590026128*^9, 
   3.4782896260001855`*^9}, {3.4782896809623294`*^9, 3.47828976944139*^9}, {
   3.4782898115217967`*^9, 3.4782898657999015`*^9}, {3.4782899270254035`*^9, 
   3.4782899665326633`*^9}, {3.478289997194417*^9, 3.4782900079600325`*^9}, {
   3.478290045032153*^9, 3.478290096896119*^9}, {3.4782901982509165`*^9, 
   3.4782902265365343`*^9}, {3.478290598524811*^9, 3.478290618076929*^9}, 
   3.4782909995517483`*^9, {3.4782910839805775`*^9, 3.4782911214807224`*^9}, {
   3.478291154148591*^9, 3.478291193699853*^9}, {3.4782951975718613`*^9, 
   3.478295208840506*^9}, {3.47829536678654*^9, 3.4782954489052367`*^9}, {
   3.478334271339753*^9, 3.4783342764240437`*^9}, {3.478335378600085*^9, 
   3.4783353847664375`*^9}, {3.478335588359082*^9, 3.4783356034189434`*^9}, {
   3.4783356483685145`*^9, 3.478335671069813*^9}, 3.478335719513584*^9, 
   3.478335763839119*^9, {3.478335917656917*^9, 3.478336099733331*^9}, {
   3.4783362240334406`*^9, 3.4783362286437044`*^9}, {3.478336337593936*^9, 
   3.478336433494421*^9}, {3.4783365159191356`*^9, 3.4783365331001186`*^9}, {
   3.4783427882248907`*^9, 3.4783428122712665`*^9}, {3.478342846414219*^9, 
   3.478342872447708*^9}, {3.4783429216115203`*^9, 3.4783429495861206`*^9}, {
   3.4783437608225203`*^9, 3.4783437754933596`*^9}, {3.4783438290544233`*^9, 
   3.4783438316025686`*^9}, {3.478343868564683*^9, 3.4783439458881054`*^9}, {
   3.478344395146802*^9, 3.4783444006721177`*^9}, {3.4783469397553453`*^9, 
   3.4783469707011147`*^9}, {3.478347132452367*^9, 3.478347151014428*^9}, {
   3.4783477986694717`*^9, 3.4783478127522774`*^9}, {3.4783478921048164`*^9, 
   3.478347918832345*^9}, {3.4783486301730313`*^9, 3.4783486308040676`*^9}, {
   3.4783490818438654`*^9, 3.4783490973267508`*^9}, {3.478349129911615*^9, 
   3.4783491353469257`*^9}, {3.4783494805166683`*^9, 
   3.4783495142585983`*^9}, {3.4783500435978746`*^9, 
   3.4783500517753425`*^9}, {3.4783504678171387`*^9, 3.478350512473693*^9}, {
   3.4783505458156*^9, 3.4783505507438817`*^9}, 3.4783522735684214`*^9, {
   3.478352494395052*^9, 3.4783524952541013`*^9}, {3.478355616995655*^9, 
   3.478355623615033*^9}, {3.478356416034357*^9, 3.4783564246278486`*^9}, {
   3.4783672931854944`*^9, 3.478367376865281*^9}, {3.4783674093961415`*^9, 
   3.478367621947299*^9}, {3.478367721204976*^9, 3.4783677272863235`*^9}, {
   3.4783677619333057`*^9, 3.478367783801556*^9}, 3.478367816095403*^9, {
   3.4784162662808204`*^9, 3.47841632273905*^9}, {3.478416441149822*^9, 
   3.478416444672024*^9}, {3.478416931238854*^9, 3.478416965748828*^9}, {
   3.478416999018731*^9, 3.478417084933645*^9}, {3.4784171180725403`*^9, 
   3.478417120063654*^9}, {3.478417186146434*^9, 3.4784172201833806`*^9}, {
   3.4784173140877514`*^9, 3.478417398253566*^9}, {3.478417437471809*^9, 
   3.4784174449672375`*^9}, {3.478417713813615*^9, 3.4784177173968196`*^9}, {
   3.478417749893678*^9, 3.4784177623333898`*^9}, {3.4784179963657756`*^9, 
   3.478418004347232*^9}, {3.4784180678048615`*^9, 3.4784180930613065`*^9}, {
   3.478418265445166*^9, 3.4784182656391773`*^9}, {3.478418308629636*^9, 
   3.4784183101057205`*^9}, {3.4784183601425824`*^9, 3.478418364634839*^9}, {
   3.4785032876145096`*^9, 3.478503333670144*^9}, {3.478503442158349*^9, 
   3.4785034436864367`*^9}, {3.478503581807337*^9, 3.4785036110640097`*^9}, {
   3.4785037071435056`*^9, 3.47850379848673*^9}, {3.478505085730356*^9, 
   3.478505095095892*^9}, {3.478505574517313*^9, 3.478505574949338*^9}, {
   3.478505684736617*^9, 3.4785057637271357`*^9}, {3.478505804475466*^9, 
   3.4785059725100775`*^9}, {3.478506199467058*^9, 3.478506200271104*^9}, {
   3.4785062861560163`*^9, 3.4785062918503428`*^9}, {3.478506335818857*^9, 
   3.4785063682087097`*^9}, {3.478506890693594*^9, 3.4785071886956387`*^9}, {
   3.478507355805197*^9, 3.4785073913542304`*^9}, 3.4785076257636375`*^9, {
   3.4785077014469666`*^9, 3.478507728642522*^9}, {3.47850810380398*^9, 
   3.47850826009892*^9}, {3.4785082930748057`*^9, 3.4785083252476463`*^9}, {
   3.478508617411357*^9, 3.4785086435118494`*^9}, {3.4785087412224383`*^9, 
   3.4785087414134493`*^9}, {3.4785087749353666`*^9, 3.478508803269987*^9}, {
   3.4785088403071055`*^9, 3.478508865967573*^9}, {3.4785118578617*^9, 
   3.4785118635020227`*^9}, {3.478513500504654*^9, 3.4785135017767267`*^9}, {
   3.4785143494262094`*^9, 3.4785143523043737`*^9}, {3.4785164293091717`*^9, 
   3.478516441474868*^9}, {3.478516475716826*^9, 3.4785165477849483`*^9}, {
   3.478516596178716*^9, 3.4785166013590126`*^9}, {3.4785166366400304`*^9, 
   3.478516666103716*^9}, {3.478518363030774*^9, 3.47851836925313*^9}, 
   3.478518598495242*^9, {3.478520891007366*^9, 3.4785208939615355`*^9}, {
   3.4785210208397923`*^9, 3.478521030015317*^9}, 3.478522264068901*^9, {
   3.478527586300315*^9, 3.478527586783343*^9}, {3.4785294995977497`*^9, 
   3.478529538503975*^9}, {3.4785295788482823`*^9, 3.4785295825444937`*^9}, {
   3.4785296737627115`*^9, 3.4785296935288415`*^9}, {3.4785298241863146`*^9, 
   3.478529826231432*^9}, {3.4785299342776117`*^9, 3.4785299678265305`*^9}, {
   3.4785303215947647`*^9, 3.4785303220047884`*^9}, 3.4785308045603895`*^9, {
   3.4785417365186615`*^9, 3.4785417369796877`*^9}, 3.478546997799589*^9, {
   3.4785471170404096`*^9, 3.478547118687504*^9}, {3.4785484585461392`*^9, 
   3.4785484598162117`*^9}, {3.4785485080229692`*^9, 3.4785485085579996`*^9}, 
   3.4785499431750555`*^9, 3.478550897190622*^9, 3.478551531612909*^9, {
   3.4785891904909096`*^9, 3.4785891934160767`*^9}, {3.478590484996951*^9, 
   3.4785904863360276`*^9}, {3.4785907012583203`*^9, 
   3.4785907027284045`*^9}, {3.478590902776847*^9, 3.478590904472944*^9}, {
   3.4785915485237813`*^9, 3.4785915495768414`*^9}, {3.4785920053189087`*^9, 
   3.478592037547752*^9}, {3.478592401357561*^9, 3.4785924052007804`*^9}, {
   3.4785924797710457`*^9, 3.478592481009116*^9}, {3.478593369458933*^9, 
   3.4785934353267*^9}, {3.4785939116949472`*^9, 3.4785939128250113`*^9}, {
   3.4785944278654704`*^9, 3.478594428760522*^9}, {3.4785951656866713`*^9, 
   3.4785951667207303`*^9}, 3.478596154041202*^9, 3.4785966064890804`*^9, {
   3.4785981700605116`*^9, 3.4785981701795187`*^9}, {3.4785986586904593`*^9, 
   3.478598659466504*^9}, {3.4785987376109734`*^9, 3.4785987377059793`*^9}, {
   3.4786097052898903`*^9, 3.4786097082499356`*^9}, {3.4786098356106415`*^9, 
   3.4786098392419477`*^9}, {3.4786099343146577`*^9, 
   3.4786099362021866`*^9}, {3.4786102718485923`*^9, 3.478610272882358*^9}, {
   3.4786104528437295`*^9, 3.4786104532824864`*^9}, {3.47861049773393*^9, 
   3.478610510527877*^9}, {3.4786106362793217`*^9, 3.4786107816956635`*^9}, {
   3.478610813039895*^9, 3.478610829399647*^9}, 3.4786109535353823`*^9, 
   3.4786110303423233`*^9, 3.478611087314315*^9, 3.4786113368695917`*^9, {
   3.4786119782206693`*^9, 3.4786120463745675`*^9}, {3.478612080636527*^9, 
   3.4786121087831373`*^9}, {3.4786143774380884`*^9, 
   3.4786143783168516`*^9}, {3.4786161458044395`*^9, 
   3.4786162306604958`*^9}, {3.478616348502306*^9, 3.478616376264985*^9}, {
   3.478661914289115*^9, 3.4786619150541587`*^9}, 3.4786644421397*^9, 
   3.4786644745535536`*^9, {3.4788406696133347`*^9, 3.478840736230145*^9}, {
   3.4788408163067255`*^9, 3.478840823691148*^9}, {3.4788408595461984`*^9, 
   3.478840861010282*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"-", " ", "Now"}]}]}]}], " ", "one", " ", "can", " ", 
     "compute", " ", "the", " ", "cohomology", " ", "group", " ", 
     "dimensions", " ", "of", " ", "line", " ", "bundles", " ", "on", " ", 
     "the", " ", "variety", " ", "generated", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"above", " ", "--"}], "--"}], "--"}]}], "-"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", " ", "The"}]}], " ", "input", " ", "of", " ", 
    "LinbundleCohomologyOf", " ", "are", " ", "the", " ", "charges", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Q_", "1"}], ",", "...", ",", "Q_r"}], "}"}], " ", "of", " ", 
    "the", " ", "line", " ", "bundle", " ", "one", " ", "is", " ", 
    "interested", " ", 
    RowBox[{
     RowBox[{"in", " ", "--"}], "--"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"A", " ", "dP3", " ", "example"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"LinebundleCohomologyOf", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "120", ",", "3", ",", 
       RowBox[{"-", "33"}]}], "}"}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Some", " ", "more", " ", "dP3", " ", "examples"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"LinebundleCohomologyOf", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"LinebundleCohomologyOf", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"LinebundleCohomologyOf", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "9"}], ",", "3", ",", "6", ",", 
        RowBox[{"-", "7"}]}], "}"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"LinebundleCohomologyOf", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", 
        RowBox[{"-", "5"}], ",", 
        RowBox[{"-", "5"}], ",", 
        RowBox[{"-", "5"}]}], "}"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"LinebundleCohomologyOf", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "3", ",", "3"}], "}"}], "]"}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Output"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
      " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"results", " ", "--"}], "--"}], "--"}], "--"}], 
                    "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
             "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}]}], "-", 
     RowBox[{"-", 
      RowBox[{"-", 
       RowBox[{"-", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", "-"}]}]}]}]}]}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Output"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
      " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"results", " ", "--"}], "--"}], "--"}], "--"}], 
                    "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
             "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}]}], "-", 
     RowBox[{"-", 
      RowBox[{"-", 
       RowBox[{"-", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", "-"}]}]}]}]}]}]}]}]}], "*)"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Output"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
      " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"results", " ", "--"}], "--"}], "--"}], "--"}], 
                    "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
             "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}]}], "-", 
     RowBox[{"-", 
      RowBox[{"-", 
       RowBox[{"-", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", "-"}]}]}]}]}]}]}]}]}], "*)"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", " ", 
                    "Output"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
      " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"results", " ", "--"}], "--"}], "--"}], "--"}], 
                    "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
             "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}]}], "-", 
     RowBox[{"-", 
      RowBox[{"-", 
       RowBox[{"-", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", "-"}]}]}]}]}]}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4754712396638117`*^9, 3.475471241679927*^9}, {
   3.4754713597756815`*^9, 3.4754713629598637`*^9}, {3.4754713950246973`*^9, 
   3.4754714291996527`*^9}, {3.475471461697511*^9, 3.4754714643846645`*^9}, {
   3.4754721129767623`*^9, 3.4754721525450253`*^9}, {3.475472735889391*^9, 
   3.4754727707763863`*^9}, {3.4754731533602686`*^9, 3.475473157264492*^9}, {
   3.4754734171143546`*^9, 3.4754734448409405`*^9}, {3.4754736122975187`*^9, 
   3.475473625137253*^9}, {3.4754736704168425`*^9, 3.4754737081289997`*^9}, {
   3.475474160665883*^9, 3.475474275946477*^9}, {3.475474486522521*^9, 
   3.475474521498522*^9}, {3.4754746293306894`*^9, 3.4754746832157717`*^9}, {
   3.4754749484799433`*^9, 3.47547496624496*^9}, 3.4754751906917973`*^9, {
   3.475475229427013*^9, 3.4754752314191265`*^9}, {3.4754752770207353`*^9, 
   3.4754753110836835`*^9}, {3.4754753933473887`*^9, 
   3.4754754086602645`*^9}, {3.475475693579561*^9, 3.475475700610963*^9}, {
   3.4754762238268895`*^9, 3.4754762834893017`*^9}, {3.4754763386284556`*^9, 
   3.475476399699949*^9}, {3.4754910603574905`*^9, 3.475491063075646*^9}, {
   3.475491215138343*^9, 3.4754912414198465`*^9}, {3.475491413923713*^9, 
   3.4754914418193088`*^9}, {3.4754915019947505`*^9, 
   3.4754915037388506`*^9}, {3.475491627201912*^9, 3.475491637930526*^9}, {
   3.4754922923539567`*^9, 3.4754923227396946`*^9}, {3.4754926675324154`*^9, 
   3.4754927969238167`*^9}, {3.4754928271395445`*^9, 
   3.4754928577002926`*^9}, {3.4754930921557026`*^9, 
   3.4754930940278096`*^9}, {3.475493146415806*^9, 3.4754932132126265`*^9}, {
   3.47549523524228*^9, 3.4754952670951023`*^9}, {3.4754953029661536`*^9, 
   3.4754953668118057`*^9}, {3.475495443447189*^9, 3.475495476723092*^9}, {
   3.4754958334494953`*^9, 3.4754958461932244`*^9}, {3.4754959793838425`*^9, 
   3.475496155672926*^9}, {3.475496234612441*^9, 3.475496249795309*^9}, {
   3.47557728155598*^9, 3.475577309937604*^9}, {3.4755776045724554`*^9, 
   3.475577741502288*^9}, {3.4755778084421167`*^9, 3.475577924316744*^9}, {
   3.475577984513187*^9, 3.4755780225953655`*^9}, {3.47557805379315*^9, 
   3.475578076383442*^9}, {3.4755783713093104`*^9, 3.475578739137349*^9}, {
   3.4755789705165834`*^9, 3.4755789905717306`*^9}, {3.4755790838010626`*^9, 
   3.475579086565221*^9}, {3.475579226683235*^9, 3.475579228467337*^9}, {
   3.475579981917432*^9, 3.475579982358457*^9}, 3.4755800481542206`*^9, {
   3.475580301026684*^9, 3.475580329033286*^9}, {3.4755807981821194`*^9, 
   3.475580826052714*^9}, {3.475580928672583*^9, 3.475580959098324*^9}, {
   3.475580990764135*^9, 3.4755810937450247`*^9}, {3.475584745069869*^9, 
   3.4755847585586405`*^9}, {3.4755881206449404`*^9, 
   3.4755881217090015`*^9}, {3.475588334271159*^9, 3.475588344462742*^9}, {
   3.4755884326457863`*^9, 3.4755884343748846`*^9}, {3.4755884702299356`*^9, 
   3.47558847188603*^9}, {3.4755928836593695`*^9, 3.47559295674855*^9}, {
   3.475593268954407*^9, 3.475593289780598*^9}, {3.475824387384571*^9, 
   3.475824388975665*^9}, {3.475824564812435*^9, 3.475824599077831*^9}, {
   3.475824658915563*^9, 3.475824738669712*^9}, {3.475824775983107*^9, 
   3.475824788862617*^9}, {3.475825041309424*^9, 3.475825114387264*^9}, {
   3.475825156286184*^9, 3.475825163070629*^9}, {3.475825293135227*^9, 
   3.475825308327557*^9}, {3.475825388367079*^9, 3.475825389410461*^9}, {
   3.475828212903632*^9, 3.475828218804282*^9}, {3.475828353065887*^9, 
   3.475828367431664*^9}, {3.47583137417651*^9, 3.475831433140855*^9}, {
   3.475832201281927*^9, 3.475832271257032*^9}, 3.475832416656941*^9, {
   3.475832471153905*^9, 3.475832493277225*^9}, 3.475832575953631*^9, 
   3.475832616420779*^9, {3.475832673447809*^9, 3.475832742229484*^9}, {
   3.475833995193276*^9, 3.475833997914763*^9}, {3.475836324781135*^9, 
   3.475836337929808*^9}, {3.475836461028765*^9, 3.475836634974765*^9}, {
   3.475836797954895*^9, 3.475836814248972*^9}, {3.47584110643042*^9, 
   3.475841278072066*^9}, {3.475842419236806*^9, 3.475842586221347*^9}, {
   3.475842922391429*^9, 3.475842932519342*^9}, {3.475842996891157*^9, 
   3.475842999029693*^9}, {3.4759186479489117`*^9, 3.475918667410746*^9}, {
   3.475919515083209*^9, 3.475919535006506*^9}, {3.475919613391073*^9, 
   3.475919617469378*^9}, {3.475919845930201*^9, 3.47591984866238*^9}, {
   3.4759202158927727`*^9, 3.475920248255118*^9}, {3.4759202811579227`*^9, 
   3.475920324665441*^9}, {3.475920446864231*^9, 3.47592045393054*^9}, {
   3.475920677431959*^9, 3.4759206999015636`*^9}, {3.475920945063147*^9, 
   3.475920946904478*^9}, {3.475921015223071*^9, 3.475921022168972*^9}, {
   3.475921085578589*^9, 3.475921179249588*^9}, {3.475921838897417*^9, 
   3.4759219259098167`*^9}, {3.475922060196763*^9, 3.475922080536063*^9}, {
   3.4759221203893757`*^9, 3.47592212830608*^9}, {3.475929521168737*^9, 
   3.4759295464282293`*^9}, {3.475929737173584*^9, 3.475929737490212*^9}, {
   3.475930115562149*^9, 3.475930117577306*^9}, {3.475930531480497*^9, 
   3.475930585841468*^9}, {3.4759306367200108`*^9, 3.475930638420156*^9}, {
   3.475930959160925*^9, 3.475931000274953*^9}, 3.475934895917326*^9, {
   3.475935003509846*^9, 3.475935060159532*^9}, {3.475952744732659*^9, 
   3.475952766438072*^9}, {3.475952850977836*^9, 3.475952923844129*^9}, {
   3.475992236254241*^9, 3.475992244502715*^9}, {3.476019737045364*^9, 
   3.476019743876079*^9}, {3.476019842269404*^9, 3.476019878176867*^9}, {
   3.47603628155395*^9, 3.476036291871351*^9}, {3.476036365460675*^9, 
   3.476036384149256*^9}, {3.476083920753813*^9, 3.476084024972393*^9}, {
   3.476084802158477*^9, 3.476084849110994*^9}, {3.476085438241455*^9, 
   3.47608544079556*^9}, {3.476085514151503*^9, 3.476085553570556*^9}, {
   3.476088998987167*^9, 3.47608900387359*^9}, {3.476094909480675*^9, 
   3.476094915424165*^9}, {3.476097229946041*^9, 3.476097271493331*^9}, {
   3.47609732057186*^9, 3.476097326262605*^9}, {3.476097572395584*^9, 
   3.476097775572297*^9}, {3.476160066876089*^9, 3.476160075714471*^9}, {
   3.476160461192863*^9, 3.47616046638761*^9}, {3.476160578875965*^9, 
   3.476160599642337*^9}, {3.476163261050263*^9, 3.476163310278581*^9}, {
   3.476163595998904*^9, 3.476163600374386*^9}, {3.476163635088011*^9, 
   3.476163652565654*^9}, 3.47616376521214*^9, 3.476163889022647*^9, {
   3.476166253986754*^9, 3.476166337987202*^9}, {3.476166371261042*^9, 
   3.476166396319991*^9}, {3.476166456380632*^9, 3.476166461792948*^9}, {
   3.476171102950073*^9, 3.476171138281873*^9}, {3.476183643706678*^9, 
   3.476183672865727*^9}, 3.476184118126508*^9, {3.47618422477228*^9, 
   3.476184229106159*^9}, {3.4761930222808*^9, 3.476193029692188*^9}, 
   3.476194206850808*^9, {3.476201036205081*^9, 3.476201047002808*^9}, {
   3.476261261059411*^9, 3.47626129212399*^9}, {3.476415385645029*^9, 
   3.476415545653284*^9}, {3.476415864349884*^9, 3.476415887915927*^9}, {
   3.476418064025277*^9, 3.4764180692272854`*^9}, {3.47641962784124*^9, 
   3.476419635811251*^9}, {3.476419742283561*^9, 3.476419776197611*^9}, {
   3.4764198820238533`*^9, 3.4764198821138535`*^9}, 3.476421630128641*^9, {
   3.476424239197871*^9, 3.4764243086628437`*^9}, {3.476426666452702*^9, 
   3.4764266788224096`*^9}, {3.47642801125262*^9, 3.4764280119726615`*^9}, 
   3.4764280901361322`*^9, {3.476429124533296*^9, 3.476429145493495*^9}, {
   3.4764306052229867`*^9, 3.476430648589467*^9}, {3.476430730192135*^9, 
   3.4764309243622403`*^9}, {3.4764309716059427`*^9, 
   3.4764310048908463`*^9}, {3.4764321644841714`*^9, 
   3.4764321770728917`*^9}, {3.4764322659109726`*^9, 3.476432296477721*^9}, {
   3.476432524992791*^9, 3.476432525360812*^9}, {3.476432652474083*^9, 
   3.4764326681359787`*^9}, 3.4764327848816557`*^9, {3.4764344732372246`*^9, 
   3.476434651068396*^9}, {3.476434702982365*^9, 3.476434708052655*^9}, {
   3.4764347386564054`*^9, 3.4764347863141317`*^9}, {3.4764348423283353`*^9, 
   3.4764348472286158`*^9}, {3.476434964655332*^9, 3.476434988870717*^9}, {
   3.476435132850952*^9, 3.4764351904832487`*^9}, {3.4764355491667643`*^9, 
   3.4764355764783263`*^9}, {3.4764412012470446`*^9, 
   3.4764412620335217`*^9}, {3.4764414320972486`*^9, 3.476441447522131*^9}, {
   3.4764441783763266`*^9, 3.476444242505995*^9}, {3.4764442740748005`*^9, 
   3.476444340370592*^9}, {3.476446006574894*^9, 3.476446148741025*^9}, {
   3.4764462486597404`*^9, 3.4764462491697693`*^9}, {3.476448128494261*^9, 
   3.476448170981691*^9}, {3.476448646094866*^9, 3.4764486708692827`*^9}, {
   3.4764491243192186`*^9, 3.476449130133551*^9}, {3.4764494809096146`*^9, 
   3.4764494886070547`*^9}, 3.4764495685026245`*^9, {3.4764497006801844`*^9, 
   3.476449722488432*^9}, {3.476449756233362*^9, 3.4764497866140995`*^9}, {
   3.476449923479928*^9, 3.476449968343494*^9}, {3.476540475930149*^9, 
   3.4765407048184586`*^9}, {3.476540759873836*^9, 3.476540834340741*^9}, 
   3.4765408759188795`*^9, {3.4765409241006246`*^9, 3.4765411381809454`*^9}, {
   3.476541191437268*^9, 3.4765411989976363`*^9}, {3.476541778723277*^9, 
   3.4765419125678596`*^9}, {3.476543999141811*^9, 3.476544136458444*^9}, {
   3.476544351728434*^9, 3.4765443528612146`*^9}, {3.476544430612341*^9, 
   3.4765444754727874`*^9}, {3.476594318114738*^9, 3.4765943271682796`*^9}, {
   3.47659481442234*^9, 3.476594817368342*^9}, {3.476594852630322*^9, 
   3.4765949178556767`*^9}, {3.476595498423071*^9, 3.476595508749268*^9}, {
   3.476595713088649*^9, 3.476595758418211*^9}, {3.476596572334556*^9, 
   3.47659662971446*^9}, {3.476597013587328*^9, 3.476597039091316*^9}, 
   3.476597086547945*^9, {3.4765973853260098`*^9, 3.476597436513649*^9}, {
   3.4765975034342546`*^9, 3.476597526438991*^9}, {3.476624060472022*^9, 
   3.4766241413396473`*^9}, 3.4766413875798745`*^9, {3.476644406781563*^9, 
   3.476644473881401*^9}, {3.4766445978744926`*^9, 3.4766445990375595`*^9}, 
   3.476645070108503*^9, {3.476645117541216*^9, 3.4766451177092257`*^9}, {
   3.4766455091136127`*^9, 3.476645513642872*^9}, {3.476646900737209*^9, 
   3.4766470097914467`*^9}, {3.4766470398071632`*^9, 3.47664708643283*^9}, {
   3.476687758837244*^9, 3.476687764413863*^9}, {3.476688068152589*^9, 
   3.47668810514856*^9}, {3.4766885712953873`*^9, 3.476688593992877*^9}, {
   3.476712520992067*^9, 3.4767125250632997`*^9}, {3.4767155338693933`*^9, 
   3.476715722872204*^9}, {3.4767157560150995`*^9, 3.4767157565161285`*^9}, {
   3.4767159563365574`*^9, 3.47671596459803*^9}, {3.476716123041092*^9, 
   3.4767161683446836`*^9}, {3.476716437770094*^9, 3.4767164397582073`*^9}, {
   3.4767165273232155`*^9, 3.4767166068467646`*^9}, {3.4767240215443635`*^9, 
   3.476724046399785*^9}, {3.47672409823075*^9, 3.4767243735194955`*^9}, {
   3.4767248434223723`*^9, 3.476724866960719*^9}, {3.476728265410099*^9, 
   3.476728268112253*^9}, {3.4767283836438613`*^9, 3.476728448008543*^9}, {
   3.476728493393139*^9, 3.476728505026804*^9}, {3.4767321406137476`*^9, 
   3.4767321667462425`*^9}, {3.4767326898050723`*^9, 
   3.4767326960324287`*^9}, {3.4767327371017747`*^9, 3.476732757264923*^9}, {
   3.476733027803217*^9, 3.4767330936742287`*^9}, {3.476733147177551*^9, 
   3.476733153517648*^9}, {3.4767331981883345`*^9, 3.4767332208836827`*^9}, {
   3.4767335214419384`*^9, 3.4767335227369585`*^9}, {3.476734954270314*^9, 
   3.4767350514994326`*^9}, {3.47673510833568*^9, 3.4767351126087613`*^9}, 
   3.4767358401045523`*^9, {3.476736190052593*^9, 3.4767362348349333`*^9}, {
   3.4767742263261557`*^9, 3.476774227173669*^9}, {3.4767744109789925`*^9, 
   3.476774411408999*^9}, {3.4773755184619317`*^9, 3.4773755768242693`*^9}, {
   3.477375725300762*^9, 3.4773757515032606`*^9}, {3.477375827093584*^9, 
   3.477375842976493*^9}, {3.477376110848814*^9, 3.4773761194783077`*^9}, {
   3.4773768322080736`*^9, 3.477376918020982*^9}, {3.477376970002955*^9, 
   3.47737705715594*^9}, {3.4773770945960813`*^9, 3.4773771284460173`*^9}, {
   3.477377343342309*^9, 3.477377364747533*^9}, {3.477377435778596*^9, 
   3.4773774502484236`*^9}, {3.477377523015586*^9, 3.4773776939383616`*^9}, {
   3.477377767704581*^9, 3.4773777881537504`*^9}, {3.4773779026773005`*^9, 
   3.4773779153770275`*^9}, {3.4773790856289616`*^9, 3.477379118617849*^9}, {
   3.477379972304677*^9, 3.477380149431808*^9}, {3.4773802422791185`*^9, 
   3.4773803048096952`*^9}, 3.4773804198602753`*^9, {3.4773804687980747`*^9, 
   3.477380477780588*^9}, {3.4773806158404846`*^9, 3.477380620145731*^9}, {
   3.4773807318471203`*^9, 3.4773808024141564`*^9}, {3.4773809190088253`*^9, 
   3.4773809516066895`*^9}, {3.477380993610092*^9, 3.4773811148580275`*^9}, {
   3.47738118589109*^9, 3.4773813073780384`*^9}, {3.4773820567028975`*^9, 
   3.4773820576129494`*^9}, {3.477382122168642*^9, 3.4773821488781695`*^9}, {
   3.477382205267395*^9, 3.4773822529371214`*^9}, {3.4773823125185294`*^9, 
   3.477382316531759*^9}, 3.477382445546138*^9, {3.477382593016573*^9, 
   3.477382613616751*^9}, {3.477382668866911*^9, 3.477382684660815*^9}, {
   3.4773827323605433`*^9, 3.4773827334686065`*^9}, {3.4773830358058987`*^9, 
   3.4773831276771536`*^9}, {3.477383324703423*^9, 3.4773833270845594`*^9}, {
   3.4773833680129004`*^9, 3.477383399047675*^9}, {3.477387543493724*^9, 
   3.477387545913862*^9}, {3.4773903256558547`*^9, 3.4773903383605814`*^9}, {
   3.4773904537391806`*^9, 3.4773904660348835`*^9}, {3.477390522169094*^9, 
   3.477390655897743*^9}, 3.4773907979578686`*^9, {3.477390859058364*^9, 
   3.477390913704489*^9}, {3.4773910380155993`*^9, 3.477391042005828*^9}, {
   3.4773911106107516`*^9, 3.477391138614353*^9}, {3.4773914445188503`*^9, 
   3.4773914581656303`*^9}, {3.4773946525303373`*^9, 
   3.4773946527723513`*^9}, {3.4773963127502966`*^9, 3.477396375835905*^9}, {
   3.4773966115723886`*^9, 3.4773966552148848`*^9}, {3.4773967968979883`*^9, 
   3.477396856050372*^9}, {3.477397000010606*^9, 3.477397003956832*^9}, {
   3.477397340873102*^9, 3.4773973660775433`*^9}, {3.477397800324381*^9, 
   3.477397875116659*^9}, {3.477397919030171*^9, 3.477397931098861*^9}, {
   3.477398552396397*^9, 3.4773985527334166`*^9}, {3.477398729849547*^9, 
   3.4773987440723605`*^9}, {3.477400332736227*^9, 3.4774003899454994`*^9}, {
   3.4774006999522305`*^9, 3.4774007627428217`*^9}, 3.4774008564121795`*^9, {
   3.4774008865609035`*^9, 3.477400922349951*^9}, {3.477407750765514*^9, 
   3.4774078039635563`*^9}, {3.4776609828769703`*^9, 
   3.4776610988876057`*^9}, {3.4776611672595167`*^9, 3.477661174454928*^9}, {
   3.4776617484347577`*^9, 3.477661844686263*^9}, {3.477661899270385*^9, 
   3.4776619549425693`*^9}, {3.4776620088246512`*^9, 3.477662024974575*^9}, {
   3.4776620992378225`*^9, 3.477662147469581*^9}, 3.477662179054388*^9, {
   3.4776622411349387`*^9, 3.477662274971874*^9}, {3.477662503040919*^9, 
   3.4776625452613335`*^9}, {3.47766271443801*^9, 3.477662715050045*^9}, 
   3.477662836019964*^9, {3.4776641905904408`*^9, 3.4776642075184093`*^9}, {
   3.477718348019571*^9, 3.477718407769988*^9}, {3.477718460501004*^9, 
   3.4777185046405287`*^9}, {3.4777185677441382`*^9, 
   3.4777186247623997`*^9}, {3.477718673353179*^9, 3.47771871061331*^9}, {
   3.477718921498372*^9, 3.4777189357181854`*^9}, {3.477719068189762*^9, 
   3.477719087058841*^9}, {3.4777213612249165`*^9, 3.477721570763901*^9}, {
   3.4777216150934367`*^9, 3.477721634260533*^9}, {3.477721669631556*^9, 
   3.4777217011323576`*^9}, 3.477721753085329*^9, {3.4777218531800547`*^9, 
   3.477721857777317*^9}, {3.4777221750874662`*^9, 3.477722187787193*^9}, {
   3.477722271347972*^9, 3.477722273430091*^9}, {3.477722350313489*^9, 
   3.477722356422838*^9}, 3.4777224779387884`*^9, {3.4777238019875197`*^9, 
   3.477723960021559*^9}, {3.477725546269287*^9, 3.4777255630782485`*^9}, {
   3.477725747362789*^9, 3.4777258453993964`*^9}, {3.477729141951948*^9, 
   3.4777292540463595`*^9}, {3.47773671251896*^9, 3.4777367328941255`*^9}, {
   3.4777367823439536`*^9, 3.477736824098342*^9}, {3.4777368854958534`*^9, 
   3.4777369863486223`*^9}, {3.4777371139689217`*^9, 
   3.4777371874151225`*^9}, {3.477737248804634*^9, 3.4777372498166914`*^9}, {
   3.4777373629161606`*^9, 3.4777373981961784`*^9}, {3.47773803234645*^9, 
   3.4777380675204616`*^9}, {3.4777381161922455`*^9, 
   3.4777381172533064`*^9}, {3.4777385825939217`*^9, 3.477738595227645*^9}, {
   3.477738818394409*^9, 3.477738825794832*^9}, {3.4777388899265003`*^9, 
   3.4777389260785685`*^9}, 3.4777393277645435`*^9, 3.477739771734937*^9, {
   3.4777417004372525`*^9, 3.477741701375306*^9}, {3.4777449840540648`*^9, 
   3.477745026434489*^9}, {3.47774518206039*^9, 3.4777452430738797`*^9}, {
   3.47774558120822*^9, 3.477745631822115*^9}, {3.4777457332359157`*^9, 
   3.477745737025132*^9}, {3.4777457762593765`*^9, 3.4777457828427525`*^9}, 
   3.477745881830415*^9, {3.477746042891627*^9, 3.477746043071637*^9}, {
   3.4777461694738665`*^9, 3.4777462723707523`*^9}, {3.4777465577580757`*^9, 
   3.4777466237428493`*^9}, {3.4777466610179815`*^9, 3.477746721646449*^9}, {
   3.477747116389027*^9, 3.4777471172600775`*^9}, {3.4777471970626416`*^9, 
   3.4777472061731625`*^9}, 3.4777472419142065`*^9, 3.4777473549386716`*^9, {
   3.4777515070711603`*^9, 3.4777516505833683`*^9}, 3.4779747517602715`*^9, {
   3.4779748098765955`*^9, 3.4779748213302507`*^9}, {3.4779751219944477`*^9, 
   3.477975215723809*^9}, {3.4779782568537517`*^9, 3.477978308600711*^9}, {
   3.477978358442562*^9, 3.477978581589325*^9}, {3.4779786794279213`*^9, 
   3.4779787170280724`*^9}, {3.477978789352209*^9, 3.4779788425202494`*^9}, {
   3.4779788968303556`*^9, 3.477978901885645*^9}, {3.4779789481552916`*^9, 
   3.477978958475882*^9}, {3.477979010733871*^9, 3.477979012394966*^9}, {
   3.4779793279640155`*^9, 3.4779793322762623`*^9}, {3.477979772924466*^9, 
   3.4779797869472675`*^9}, 3.477980113771961*^9, {3.4779805064934235`*^9, 
   3.477980508572542*^9}, {3.4779841336548853`*^9, 3.4779841663187532`*^9}, {
   3.4779880069904275`*^9, 3.477988010270615*^9}, {3.4779881080372066`*^9, 
   3.477988122169015*^9}, {3.477988176073098*^9, 3.4779882395857315`*^9}, {
   3.4779884878629313`*^9, 3.4779885289302807`*^9}, 3.477988595863109*^9, 
   3.4779890978728223`*^9, {3.477990618184779*^9, 3.4779906272002945`*^9}, {
   3.4779920811054535`*^9, 3.477992083692601*^9}, {3.4779921161484575`*^9, 
   3.4779922002442675`*^9}, {3.4779956709707823`*^9, 3.477995702653594*^9}, {
   3.4779959853887653`*^9, 3.477996001182669*^9}, {3.4779962256705093`*^9, 
   3.477996231244828*^9}, {3.4779964190795717`*^9, 3.477996423901847*^9}, {
   3.477996511985885*^9, 3.477996522435483*^9}, {3.477996552903226*^9, 
   3.477996592095467*^9}, {3.4779971856574173`*^9, 3.477997189343628*^9}, {
   3.477997220865431*^9, 3.4779972466989083`*^9}, {3.4779972913034596`*^9, 
   3.4779972967347703`*^9}, {3.4779977770462427`*^9, 
   3.4779977783183155`*^9}, {3.478001803504543*^9, 3.4780018263418493`*^9}, {
   3.4780020724159236`*^9, 3.4780020736639953`*^9}, {3.478002291341446*^9, 
   3.4780023301676664`*^9}, 3.478002632160939*^9, {3.478002867736414*^9, 
   3.478002869230499*^9}, {3.47800432842696*^9, 3.4780043468640146`*^9}, {
   3.4780046673333445`*^9, 3.4780046722336245`*^9}, {3.478004754450327*^9, 
   3.4780047587035704`*^9}, {3.4780048252303753`*^9, 
   3.4780048258214097`*^9}, {3.4782578795741873`*^9, 3.478257894875759*^9}, {
   3.478257982481341*^9, 3.478258096291967*^9}, {3.478259770150591*^9, 
   3.478259826818099*^9}, 3.478259877335403*^9, {3.478261325232768*^9, 
   3.478261421489497*^9}, {3.478261466844434*^9, 3.478261592495919*^9}, {
   3.478261637748761*^9, 3.478261685329041*^9}, {3.478261724242852*^9, 
   3.4782617345414553`*^9}, {3.478261972055069*^9, 3.478261974795879*^9}, {
   3.478270485118943*^9, 3.478270489293089*^9}, {3.478270534461461*^9, 
   3.478270591275558*^9}, {3.478270653888956*^9, 3.478270670776176*^9}, {
   3.478270754052126*^9, 3.478270889461248*^9}, {3.4782721350161047`*^9, 
   3.4782721576048107`*^9}, 3.478272201477927*^9, {3.478289590026128*^9, 
   3.4782896260001855`*^9}, {3.4782896809623294`*^9, 3.47828976944139*^9}, {
   3.4782898115217967`*^9, 3.4782898657999015`*^9}, {3.4782899270254035`*^9, 
   3.4782899665326633`*^9}, {3.478289997194417*^9, 3.4782900079600325`*^9}, {
   3.478290045032153*^9, 3.478290096896119*^9}, {3.4782901982509165`*^9, 
   3.4782902265365343`*^9}, {3.478290598524811*^9, 3.478290618076929*^9}, 
   3.4782909995517483`*^9, {3.4782910839805775`*^9, 3.4782911214807224`*^9}, {
   3.478291154148591*^9, 3.478291193699853*^9}, {3.4782951975718613`*^9, 
   3.478295208840506*^9}, {3.47829536678654*^9, 3.4782954489052367`*^9}, {
   3.478334271339753*^9, 3.4783342764240437`*^9}, {3.478335378600085*^9, 
   3.4783353847664375`*^9}, {3.478335588359082*^9, 3.4783356034189434`*^9}, {
   3.4783356483685145`*^9, 3.478335671069813*^9}, 3.478335719513584*^9, 
   3.478335763839119*^9, {3.478335917656917*^9, 3.478336099733331*^9}, {
   3.4783362240334406`*^9, 3.4783362286437044`*^9}, {3.478336337593936*^9, 
   3.478336433494421*^9}, {3.4783365159191356`*^9, 3.4783365331001186`*^9}, {
   3.4783427882248907`*^9, 3.4783428122712665`*^9}, {3.478342846414219*^9, 
   3.478342872447708*^9}, {3.4783429216115203`*^9, 3.4783429495861206`*^9}, {
   3.4783437608225203`*^9, 3.4783437754933596`*^9}, {3.4783438290544233`*^9, 
   3.4783438316025686`*^9}, {3.478343868564683*^9, 3.4783439458881054`*^9}, {
   3.478344395146802*^9, 3.4783444006721177`*^9}, {3.4783469397553453`*^9, 
   3.4783469707011147`*^9}, {3.478347132452367*^9, 3.478347151014428*^9}, {
   3.4783477986694717`*^9, 3.4783478127522774`*^9}, {3.4783478921048164`*^9, 
   3.478347918832345*^9}, {3.4783486301730313`*^9, 3.4783486308040676`*^9}, {
   3.4783490818438654`*^9, 3.4783490973267508`*^9}, {3.478349129911615*^9, 
   3.4783491353469257`*^9}, {3.4783494805166683`*^9, 
   3.4783495142585983`*^9}, {3.4783500435978746`*^9, 
   3.4783500517753425`*^9}, {3.4783504678171387`*^9, 3.478350512473693*^9}, {
   3.4783505458156*^9, 3.4783505507438817`*^9}, 3.4783522735684214`*^9, {
   3.478352494395052*^9, 3.4783524952541013`*^9}, {3.478355616995655*^9, 
   3.478355623615033*^9}, {3.478356416034357*^9, 3.4783564246278486`*^9}, {
   3.4783672931854944`*^9, 3.478367376865281*^9}, {3.4783674093961415`*^9, 
   3.478367621947299*^9}, {3.478367721204976*^9, 3.4783677272863235`*^9}, {
   3.4783677619333057`*^9, 3.478367783801556*^9}, 3.478367816095403*^9, {
   3.4784162662808204`*^9, 3.47841632273905*^9}, {3.478416441149822*^9, 
   3.478416444672024*^9}, {3.478416931238854*^9, 3.478416965748828*^9}, {
   3.478416999018731*^9, 3.478417084933645*^9}, {3.4784171180725403`*^9, 
   3.478417120063654*^9}, {3.478417186146434*^9, 3.4784172201833806`*^9}, {
   3.4784173140877514`*^9, 3.478417398253566*^9}, {3.478417437471809*^9, 
   3.4784174449672375`*^9}, {3.478417713813615*^9, 3.4784177173968196`*^9}, {
   3.478417749893678*^9, 3.4784177623333898`*^9}, {3.4784179963657756`*^9, 
   3.478418004347232*^9}, {3.4784180678048615`*^9, 3.4784180930613065`*^9}, {
   3.478418265445166*^9, 3.4784182656391773`*^9}, {3.478418308629636*^9, 
   3.4784183101057205`*^9}, {3.4784183601425824`*^9, 3.478418364634839*^9}, {
   3.4785032876145096`*^9, 3.478503333670144*^9}, {3.478503442158349*^9, 
   3.4785034436864367`*^9}, {3.478503581807337*^9, 3.4785036110640097`*^9}, {
   3.4785037071435056`*^9, 3.47850379848673*^9}, {3.478505085730356*^9, 
   3.478505095095892*^9}, {3.478505574517313*^9, 3.478505574949338*^9}, {
   3.478505684736617*^9, 3.4785057637271357`*^9}, {3.478505804475466*^9, 
   3.4785059725100775`*^9}, {3.478506199467058*^9, 3.478506200271104*^9}, {
   3.4785062861560163`*^9, 3.4785062918503428`*^9}, {3.478506335818857*^9, 
   3.4785063682087097`*^9}, {3.478506890693594*^9, 3.4785071886956387`*^9}, {
   3.478507355805197*^9, 3.4785073913542304`*^9}, 3.4785076257636375`*^9, {
   3.4785077014469666`*^9, 3.4785077397441573`*^9}, {3.4785078498884573`*^9, 
   3.478507866355399*^9}, {3.478507946360975*^9, 3.478507960016756*^9}, {
   3.478508176097115*^9, 3.4785081823994756`*^9}, {3.4785083580965247`*^9, 
   3.4785084144077454`*^9}, {3.4785086671522017`*^9, 
   3.4785086681562595`*^9}, {3.478508719383189*^9, 3.478508722692378*^9}, {
   3.4785089375116653`*^9, 3.4785089496563597`*^9}, {3.478511337361929*^9, 
   3.4785113583141274`*^9}, 3.478511438300702*^9, 3.4785114907647033`*^9, {
   3.4785122056325912`*^9, 3.478512235898322*^9}, {3.478512568849366*^9, 
   3.478512573760647*^9}, {3.478513995414961*^9, 3.478514072336361*^9}, {
   3.4785167044579096`*^9, 3.4785167070330567`*^9}, {3.478516770296675*^9, 
   3.4785167781361237`*^9}, {3.4785173092074995`*^9, 
   3.4785173552511325`*^9}, {3.478517737187978*^9, 3.4785177484506226`*^9}, {
   3.4785181099242973`*^9, 3.478518114723572*^9}, {3.4785183844489994`*^9, 
   3.4785183885612345`*^9}, {3.478518423498233*^9, 3.478518424339281*^9}, {
   3.478518526355116*^9, 3.478518583962411*^9}, {3.478519244434188*^9, 
   3.478519264876357*^9}, {3.4785203954500217`*^9, 3.4785203960410557`*^9}, 
   3.47852071133809*^9, {3.4785212083315163`*^9, 3.478521213449809*^9}, {
   3.4785298907161202`*^9, 3.478529917580657*^9}, {3.4785303467232027`*^9, 
   3.4785303502204027`*^9}, {3.4785307317472243`*^9, 3.478530733867346*^9}, {
   3.478530783436181*^9, 3.478530796154908*^9}, {3.478532267014037*^9, 
   3.47853236166045*^9}, {3.4785324828593826`*^9, 3.478532496782179*^9}, {
   3.4785336657990427`*^9, 3.4785336691302333`*^9}, 3.4785337671498394`*^9, {
   3.4785338869096894`*^9, 3.478533892037983*^9}, {3.478534300198328*^9, 
   3.478534300509346*^9}, {3.47853607987912*^9, 3.478536081014185*^9}, {
   3.4785364605008907`*^9, 3.4785364606769004`*^9}, {3.4785417448761396`*^9, 
   3.4785417541496696`*^9}, {3.4785442220118237`*^9, 
   3.4785442294952517`*^9}, {3.478544615564333*^9, 3.478544620678626*^9}, {
   3.4785452723679004`*^9, 3.478545274351014*^9}, {3.478546966878821*^9, 
   3.47854697456326*^9}, {3.478547039755989*^9, 3.478547055835909*^9}, {
   3.4785484663095837`*^9, 3.478548502730666*^9}, 3.478549276106901*^9, {
   3.478549989534707*^9, 3.478549993940959*^9}, {3.4785509025709295`*^9, 
   3.4785509073022003`*^9}, {3.4785511482009788`*^9, 
   3.4785511491920357`*^9}, {3.478551537353237*^9, 3.478551545535705*^9}, {
   3.478552245572745*^9, 3.4785522511480637`*^9}, {3.4785523037720737`*^9, 
   3.4785524278981733`*^9}, {3.4785524940059547`*^9, 
   3.4785524941239614`*^9}, {3.4785525654760427`*^9, 
   3.4785525657770596`*^9}, {3.4785544974245434`*^9, 3.478554590738881*^9}, {
   3.4785892177364683`*^9, 3.478589255383621*^9}, {3.478589517124592*^9, 
   3.478589519260714*^9}, {3.478589933125386*^9, 3.4785899666913056`*^9}, {
   3.4785905533598614`*^9, 3.478590554647935*^9}, {3.4785907119629326`*^9, 
   3.478590718075282*^9}, 3.4785923127964954`*^9, {3.478592353647832*^9, 
   3.478592357788069*^9}, {3.478592408559973*^9, 3.4785924095400286`*^9}, {
   3.478593480756299*^9, 3.4785935407487297`*^9}, {3.4785938791290846`*^9, 
   3.4785938876785736`*^9}, {3.478593940136574*^9, 3.4785939604647365`*^9}, {
   3.4785960838361864`*^9, 3.478596084859245*^9}, {3.478599318908222*^9, 
   3.478599335819189*^9}, {3.4786000621723356`*^9, 3.4786000670014124`*^9}, {
   3.478609494152897*^9, 3.4786095060293293`*^9}, {3.4786098136578045`*^9, 
   3.47860981532408*^9}, {3.4786098851214023`*^9, 3.478609887016431*^9}, {
   3.4786101523942575`*^9, 3.478610153410523*^9}, {3.4786102007212496`*^9, 
   3.47861021313144*^9}, {3.478610409766565*^9, 3.4786104508849497`*^9}, {
   3.4786109779502687`*^9, 3.478611109136918*^9}, {3.4786113260939755`*^9, 
   3.478611332553345*^9}, {3.478611641278633*^9, 3.478611642878725*^9}, {
   3.4786120545740366`*^9, 3.478612066903742*^9}, {3.478614384629449*^9, 
   3.478614399765432*^9}, {3.4786153928051977`*^9, 3.4786154357248583`*^9}, {
   3.478616391102214*^9, 3.4786164038199096`*^9}, {3.478800390427497*^9, 
   3.4788003989829865`*^9}, {3.4788382472177815`*^9, 3.478838250657978*^9}, {
   3.4788408393030405`*^9, 3.4788408783062716`*^9}}]
},
WindowSize->{1246, 883},
WindowMargins->{{-4, Automatic}, {Automatic, 4}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{594.3000000000001, 840.51},
"PostScriptOutputFile"->"/home/pcl342/rahn/octictransition.pdf"},
Magnification->1.2000000476837158`,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 118037, 2506, 6675, "Input"],
Cell[118585, 2528, 48149, 1035, 935, "Input"],
Cell[166737, 3565, 37345, 674, 515, "Input"]
}
]
*)

(* End of internal cache information *)
