#include "dispatcher"

bool Dispatcher::check_acl() {
    if (config.nallow()) {
	bool allowed = false;
	for (unsigned n = 0; n < config.nallow(); n++)
	    if (ipmatch(clientfd().clientaddr().sin_addr, config.allow(n))) {
		allowed = true;
		break;
	    }
	if (!allowed) {
	    msg("Not serving client IP " <<
		inet2string(clientfd().clientaddr().sin_addr) <<
		": no match in allow list\n");
	    return false;
	}
    }
    if (config.ndeny()) {
	for (unsigned n = 0; n < config.ndeny(); n++)
	    if (ipmatch(clientfd().clientaddr().sin_addr, config.deny(n))) {
		msg("Not serving client IP " <<
		    inet2string(clientfd().clientaddr().sin_addr) <<
		    ": match in deny list\n");
		return false;
	    }
    }
    return true;
}
