/** @file nc_values_dialog.cpp */

// Copyright (C) 2018-2022 Sanford Rockowitz <rockowitz@minsoft.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#include "nc_values_dialog.h"

#include <assert.h>
#include <QtCore/QDebug>

#include "base/core.h"
#include "help/help_dialog.h"
#include "help/help_browser.h"

#include "ui_nc_values_dialog.h"    // generated by UIC


void NcValuesDialog::setUiSource(NcValuesSource source)
{
   bool debugFunc = false;
   TRACEMF(debugFunc, "Executing. source=%d=%s", source, ncValuesSourceName(source) );
   switch(source) {
   case NcValuesFromCapabilities:
       ui->capabilitiesNcValuesButton->setChecked(true);
       break;
   case NcValuesFromMccs:
       ui->mccsNcValuesButton->setChecked(true);
       break;
   case NcValuesFromBoth:
      ui->bothNcValuesButton->setChecked(true);
      break;
   }
}

// void OtherOptionsDialog::setUseLatestNcValueNames(bool newval) {
//    ui->latestNcValueNamesCheckbox->setChecked(newval);
// }


NcValuesDialog::NcValuesDialog(NcValuesState * state, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::NcValuesDialog),
    _cls( strdup(metaObject()->className()) ),
    _state(state)
{
    ui->setupUi(this);
    // this->setContextMenuPolicy(Qt::PreventContextMenu);
    setWindowFlag(Qt::WindowContextHelpButtonHint, false);
    setWindowTitle("ddcui - NC Feature Values");
    setUiSource(state->_ncValuesSource);
    // setUseLatestNcValueNames(state->_useLatestNcValues);
}


NcValuesDialog::~NcValuesDialog()
{
    delete ui;
    free((void*) _cls);
}


void NcValuesDialog::on_buttonBox_accepted()
{
    // NcValuesSource oldsrc = _state->_ncValuesSource;
    // bool           oldUseLatestNames = _state->_useLatestNcValueNames;

#ifdef UNUSED
    NcValuesSource newsrc;

    if (ui->capabilitiesNcValuesButton->isChecked() )
       newsrc = NcValuesFromCapabilities;
    else if (ui->bothNcValuesButton->isChecked() )
        newsrc = NcValuesFromBoth;
    else {
       assert(  ui->mccsNcValuesButton->isChecked() );
       newsrc = NcValuesFromMccs;
    }
#endif

    // _state->changeNcValuesSource(newsrc, ui->latestNcValueNamesCheckbox->isChecked());
}


void NcValuesDialog::on_buttonBox_helpRequested()
{
   // TRACEC("Starting");
   // viewHelp(QString("nc_values.html"), QString("ddcui Help -X Other Options"), this);
   // HelpBrowser::showPage("qrc:docs/help_nc_values.html", false);

   HelpDialog* hd = new HelpDialog(this);
   hd->setSource("qrc:docs/help_nc_values.html");
   hd->exec();
}


// Reset
void NcValuesDialog::on_buttonBox_clicked(QAbstractButton* button)
{
   if(button== (QAbstractButton*) ui->buttonBox->button(QDialogButtonBox::Reset) ){
      // TRACE("Reset");
      setUiSource(NcValuesState::DefaultNcValuesSource);
      // setUseLatestNcValueNames(OtherOptionsState::DefaultUseMaximalMccsNcValues);
   }
}
