/*
// $Id: //open/dev/farrago/src/net/sf/farrago/db/FarragoDbSavepoint.java#11 $
// Farrago is an extensible data management system.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2005-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package net.sf.farrago.db;

import net.sf.farrago.fem.fennel.*;
import net.sf.farrago.fennel.*;
import net.sf.farrago.session.*;


/**
 * FarragoDbSavepoint implements the {@link
 * net.sf.farrago.session.FarragoSessionSavepoint} interface in terms of a
 * {@link FarragoDbSession}.
 *
 * @author John V. Sichi
 * @version $Id: //open/dev/farrago/src/net/sf/farrago/db/FarragoDbSavepoint.java#11 $
 */
class FarragoDbSavepoint
    implements FarragoSessionSavepoint
{
    //~ Instance fields --------------------------------------------------------

    /**
     * Session which created this savepoint.
     */
    FarragoDbSession session;

    /**
     * ID generated by session (unique within session scope).
     */
    private int id;

    /**
     * Name assigned by user, or null if unnamed.
     */
    private String name;

    /**
     * Handle to underlying Fennel savepoint.
     */
    private FennelSvptHandle fennelSvptHandle;

    //~ Constructors -----------------------------------------------------------

    FarragoDbSavepoint(
        int id,
        String name,
        FennelSvptHandle fennelSvptHandle,
        FarragoDbSession session)
    {
        this.id = id;
        this.name = name;
        this.fennelSvptHandle = fennelSvptHandle;
        this.session = session;
    }

    //~ Methods ----------------------------------------------------------------

    // implement FarragoSessionSavepoint
    public int getId()
    {
        return id;
    }

    // implement FarragoSessionSavepoint
    public String getName()
    {
        return name;
    }

    // implement Object
    public boolean equals(Object obj)
    {
        if (!(obj instanceof FarragoDbSavepoint)) {
            return false;
        }
        FarragoDbSavepoint other = (FarragoDbSavepoint) obj;
        return (id == other.id) && (session == other.session);
    }

    // implement Object
    public int hashCode()
    {
        return id;
    }

    FennelSvptHandle getFennelSvptHandle()
    {
        return fennelSvptHandle;
    }
}

// End FarragoDbSavepoint.java
