-- $Id: port_unused.vhdl 4326 2009-01-27 14:37:19Z potyra $ 

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

ENTITY forwarder IS
	PORT (
		x_out : OUT integer;
		x_unused : OUT integer; -- @ERROR@ Unused signal
		x_in : IN integer
	);
END ENTITY forwarder;

ARCHITECTURE forwarder_impl of forwarder IS
BEGIN
	forward : process (x_in)
	BEGIN
		x_out <= x_in;
	END PROCESS;
END ARCHITECTURE forwarder_impl;

ENTITY forwarder2 IS
	PORT (
		x_out : OUT integer;
		x_in : IN integer
	);
END ENTITY forwarder2;

ARCHITECTURE forwarder2_impl of forwarder2 IS
BEGIN
	f : forwarder 
	PORT MAP (
		x_in => x_in,
		x_out => x_out
	);
END ARCHITECTURE;

ENTITY test_bench IS
END ENTITY test_bench;

ARCHITECTURE test_bench_impl of test_bench IS
	SIGNAL x, y : integer;
BEGIN
	f : forwarder2 port map (x_in => x, x_out => y);

	p : process
	begin
		x <= 1;
		wait on y;
		assert(y = 1) report "y != 1" severity failure;
		x <= 2;
		wait on y;
		assert(y = 2) report "y != 2" severity failure;
		assert false report "simulation finished." severity note;
		wait;
	end process;
END ARCHITECTURE;
		
