/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

typedef enum { readlock, writelock }	LOCKTYPE;

typedef struct {
  globus_mutex_t	mtx;
  globus_cond_t		cond;
  int			readers;
  int			writer;
} LOCK;

extern int	rls_lock_init(LOCK *lock);
extern void	rls_lock_destroy(LOCK *lock);
extern void	rls_lock_get(LOCK *lock, LOCKTYPE type);
extern void	rls_lock_release(LOCK *lock, LOCKTYPE type);
