#ifndef __GM_SUPPORT_H__
#define __GM_SUPPORT_H__

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs.h>
#undef _
#include <glib/gi18n.h>
#include "gm-color-table.h"

/*
 * Standard gettext macros.
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#ifndef _
#  define _(String) (String)
#endif
#  define N_(String) (String)
#endif
*/

#define CALC_COLOR_RANGE(x) (int)((-(1/((x * 0.5)+1))+1)*255)

/** \defgroup support */

/** \ingroup support 
 *  \brief Widget container for tabs
 *
 *  Contains all widgets that could be useful to be modified.
 *  Stored here because it makes it easier to look them up.
 *  
 */
typedef struct _GmLabelInfo GmLabelInfo;
struct _GmLabelInfo {
  /** \brief GtkButton widget
    *
    * GtkButton widget, reference to the tabs exit button
    */
  GtkWidget *button_exit;

    /** \brief GtkImage widget
    *
    * GtkImage widget, reference to the tabs exit button image
    */
  GtkWidget *image_exit;
  
  /** \brief GtkLabel widget
    *
    * GtkLabel widget, reference to the tabs label
    */
  GtkWidget *label_name;
  
  /** \brief GtkImage widget
    *
    * GtkImage widget, reference to the tabs icon
    */
  GtkWidget *image_icon;
};

/** \ingroup support
 *  \brief Key/value pair struct
 *
 *  Contains two fields. Used to create hash tables
 *  
 */
typedef struct _GmKeyValuePair {
	gchar *key; /**< the key */
	gchar *value; /**< the value */
} GmKeyValuePair;

typedef struct _GmFetchHandle GmFetchHandle;
struct _GmFetchHandle {
	GnomeVFSAsyncHandle *handle;

	GFunc cb;
	gpointer user_data;

	GList *source_uri;
	GList *dest_uri;
	  
	GnomeVFSXferPhase cur_phase;
	GnomeVFSXferPhase prev_phase;
	GnomeVFSXferProgressStatus prev_status;
	GnomeVFSXferProgressStatus status;

	GnomeVFSFileSize bytes_total;
	GnomeVFSFileSize file_size;
	GnomeVFSFileSize bytes_copied;
	GnomeVFSFileSize total_bytes_copied;

	gulong files_total;  
	gulong cur_file;
	gulong prev_file;
	gchar *cur_file_name;

	gboolean aborted;
	gboolean done;
};

gchar *gm_fix_decimal_point(gchar *line, int len);
gchar *gm_fix_decimal_point_rev(gchar *line, int len);
gchar *gm_ansi_strip(gchar * s);
int garray_length(gchar **s);
void gm_g_list_free_simple(GList *s);
gchar *gm_g_list_find_simple(GList *s, gchar *f);

gint gm_error_dialog(gchar * message, GtkWindow * parent);
gint gm_warning_dialog(gchar * message, GtkWindow * parent);
gint gm_info_dialog(gchar * message, GtkWindow * parent);
gint gm_question_dialog(gchar * message, GtkWindow * parent);

void gm_do_events();

void gm_directory_remove_all(const gchar * path, gboolean remove_self);

gint gm_url_regex_match(const gchar *msg, int len, GArray *start,  GArray *end);
void gm_open_url(const gchar *url);

GmFetchHandle * gm_fetch(const GList *source, const GList *dest, 
                                   GFunc cb, gpointer user_data);
void gm_fetch_handle_free(GmFetchHandle *g);

gboolean gm_is_end_scrolled(GtkScrolledWindow *wnd, guint charHeight);
void gm_scroll_end(GtkTextView *view, gboolean needs);

typedef gboolean (*ReadProgressFunc) (long, long, gchar *, gpointer);

gchar *gm_read_file(gchar const *fname);
GtkWidget *gm_create_tab_label(const gchar *icon, const gchar *caption, 
                                     gboolean has_exit, GmLabelInfo *info);
void gm_widget_destroy_data(GtkWidget *caller, GtkWidget *destroyer);
const gchar *gm_default_charset();
void gm_notebook_focus_from_label(GtkNotebook *note, gchar *caption);

GtkWidget *gm_find_parent(GtkWidget *widget, GType parent_type);
GtkWidget *gm_find_child(GtkWidget *widget, GType parent_type);

gchar *gm_from_utf8_with_fallback(gchar const *text, gssize len, 
		gchar const *to, gchar const *fallback);
gchar *gm_to_utf8_with_fallback(gchar const *text, gssize len, 
		gchar const *from, gchar const *fallback);

GtkWidget *gm_container_item(GtkContainer *cnt, GType type);

typedef enum _GmSchemedFlags {
	GM_SCHEMED_COLORS = 1 << 0,
	GM_SCHEMED_FONT = 1 << 1
} GmSchemedFlags;

void gm_register_schemed(GtkWidget *widget, GmColorTable *Table,
		GmSchemedFlags flags);

#endif /* __GM_SUPPORT_H__ */
