/***************************************************************************
 *            main.c
 *
 *  Tue Mar 13 13:40:25 2007
 *  Copyright  2007  Étienne Bersac <bersace03@laposte.net>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib/gprintf.h>
#include <glib/gi18n.h>
#include <gnome-scan-init.h>
#include <gnome-scan-dialog.h>
#include <gnome-scan-job.h>
#include <gnome-scan-sink.h>
#include "flegita-sink.h"

void
flegita_about(GtkButton *about,
			  GtkWindow *parent)
{
	const gchar *authors[] = {
		"Étienne Bersac <bersace03@laposte.net>",
		"Ross Burton <ross@burtonini.com>",
		NULL
	};
	
	gtk_show_about_dialog(parent,
						  "modal", TRUE,
						  "authors", authors,
						  "comments", g_strdup_printf("%s\n"
													  "\n"
													  "In Memoriam †Mark Finlay",
													  _("Simply scan images")),
						  "copyright", "Copyright © 2006-2008 Étienne Bersac",
						  "license", "This program is free software; you can "
						  "redistribute it and/or modify it under the terms of "
						  "the GNU General Public License as published by "
						  "the Free Software Foundation; either version 3 of "
						  "the License, or (at your option) any later version."
						  "\n\n"
						  " This program is distributed in the hope that it "
						  "will be useful, but WITHOUT ANY WARRANTY; without "
						  "even the implied warranty of MERCHANTABILITY or "
						  "FITNESS FOR A PARTICULAR PURPOSE. See the GNU "
						  "General Public License for more details."
						  "\n\n"
						  "You should have received a copy of the GNU General "
						  "Public License along with this program; if not, "
						  "write to the Free Software Foundation, Inc., 51 "
						  "Franklin Street, Fifth Floor Boston, MA 02110-1301, "
						  "USA\n\n",
						  "logo-icon-name", "flegita",
						  /* Translators: Add your names here with one name per
						   line, like
						     "John Smith <email1@example.com>\n
						      Robert Foo <email2@example.com>" */
						  "translator-credits", _("translator-credit"),
						  "version", PACKAGE_VERSION,
						  "website", "http://www.gnome.org/project/gnome-scan/index",
						  "website-label", _("Gnome Scan website"),
						  "wrap-license", TRUE,
						  NULL);
}

gint
main (gint argc, gchar **argv)
{
	GnomeScanJob *job;
	GtkWidget *dialog;
	GnomeScanSink *sink;
	GtkWidget *about;
	
	textdomain (GETTEXT_PACKAGE);

	gtk_init (&argc, &argv);
	gnome_scan_init (&argc, &argv);

	gtk_window_set_default_icon_name ("flegita");
	g_set_application_name (_("Scanner Utility"));
	
	/* build */
	sink = flegita_sink_new();
	job = gnome_scan_job_new(NULL, sink);
	dialog = gnome_scan_dialog_new (NULL, job);
	
	/* ABOUT */
	about = gtk_button_new_from_stock (GTK_STOCK_ABOUT);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->action_area), about,
						FALSE, FALSE, 0);
	gtk_button_box_set_child_secondary (GTK_BUTTON_BOX(GTK_DIALOG(dialog)->action_area),
										about, TRUE);
	g_signal_connect(about, "clicked", G_CALLBACK(flegita_about), dialog);
	gtk_widget_show(about);
	
	/* run */
	gnome_scan_dialog_run (GNOME_SCAN_DIALOG (dialog));
	
	/* free */
	gtk_widget_destroy (dialog);
	g_object_unref(job);
	
	gnome_scan_exit ();
	
	return (0);
}
