// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/osconfig/v1/patch_jobs.proto

package osconfig

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Enumeration of the various states a patch job passes through as it
// executes.
type PatchJob_State int32

const (
	// State must be specified.
	PatchJob_STATE_UNSPECIFIED PatchJob_State = 0
	// The patch job was successfully initiated.
	PatchJob_STARTED PatchJob_State = 1
	// The patch job is looking up instances to run the patch on.
	PatchJob_INSTANCE_LOOKUP PatchJob_State = 2
	// Instances are being patched.
	PatchJob_PATCHING PatchJob_State = 3
	// Patch job completed successfully.
	PatchJob_SUCCEEDED PatchJob_State = 4
	// Patch job completed but there were errors.
	PatchJob_COMPLETED_WITH_ERRORS PatchJob_State = 5
	// The patch job was canceled.
	PatchJob_CANCELED PatchJob_State = 6
	// The patch job timed out.
	PatchJob_TIMED_OUT PatchJob_State = 7
)

var PatchJob_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "STARTED",
	2: "INSTANCE_LOOKUP",
	3: "PATCHING",
	4: "SUCCEEDED",
	5: "COMPLETED_WITH_ERRORS",
	6: "CANCELED",
	7: "TIMED_OUT",
}

var PatchJob_State_value = map[string]int32{
	"STATE_UNSPECIFIED":     0,
	"STARTED":               1,
	"INSTANCE_LOOKUP":       2,
	"PATCHING":              3,
	"SUCCEEDED":             4,
	"COMPLETED_WITH_ERRORS": 5,
	"CANCELED":              6,
	"TIMED_OUT":             7,
}

func (x PatchJob_State) String() string {
	return proto.EnumName(PatchJob_State_name, int32(x))
}

func (PatchJob_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{7, 0}
}

// Post-patch reboot settings.
type PatchConfig_RebootConfig int32

const (
	// The default behavior is DEFAULT.
	PatchConfig_REBOOT_CONFIG_UNSPECIFIED PatchConfig_RebootConfig = 0
	// The agent decides if a reboot is necessary by checking signals such as
	// registry keys on Windows or `/var/run/reboot-required` on APT based
	// systems. On RPM based systems, a set of core system package install times
	// are compared with system boot time.
	PatchConfig_DEFAULT PatchConfig_RebootConfig = 1
	// Always reboot the machine after the update completes.
	PatchConfig_ALWAYS PatchConfig_RebootConfig = 2
	// Never reboot the machine after the update completes.
	PatchConfig_NEVER PatchConfig_RebootConfig = 3
)

var PatchConfig_RebootConfig_name = map[int32]string{
	0: "REBOOT_CONFIG_UNSPECIFIED",
	1: "DEFAULT",
	2: "ALWAYS",
	3: "NEVER",
}

var PatchConfig_RebootConfig_value = map[string]int32{
	"REBOOT_CONFIG_UNSPECIFIED": 0,
	"DEFAULT":                   1,
	"ALWAYS":                    2,
	"NEVER":                     3,
}

func (x PatchConfig_RebootConfig) String() string {
	return proto.EnumName(PatchConfig_RebootConfig_name, int32(x))
}

func (PatchConfig_RebootConfig) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{8, 0}
}

// Patch state of an instance.
type Instance_PatchState int32

const (
	// Unspecified.
	Instance_PATCH_STATE_UNSPECIFIED Instance_PatchState = 0
	// The instance is not yet notified.
	Instance_PENDING Instance_PatchState = 1
	// Instance is inactive and cannot be patched.
	Instance_INACTIVE Instance_PatchState = 2
	// The instance is notified that it should be patched.
	Instance_NOTIFIED Instance_PatchState = 3
	// The instance has started the patching process.
	Instance_STARTED Instance_PatchState = 4
	// The instance is downloading patches.
	Instance_DOWNLOADING_PATCHES Instance_PatchState = 5
	// The instance is applying patches.
	Instance_APPLYING_PATCHES Instance_PatchState = 6
	// The instance is rebooting.
	Instance_REBOOTING Instance_PatchState = 7
	// The instance has completed applying patches.
	Instance_SUCCEEDED Instance_PatchState = 8
	// The instance has completed applying patches but a reboot is required.
	Instance_SUCCEEDED_REBOOT_REQUIRED Instance_PatchState = 9
	// The instance has failed to apply the patch.
	Instance_FAILED Instance_PatchState = 10
	// The instance acked the notification and will start shortly.
	Instance_ACKED Instance_PatchState = 11
	// The instance exceeded the time out while applying the patch.
	Instance_TIMED_OUT Instance_PatchState = 12
	// The instance is running the pre-patch step.
	Instance_RUNNING_PRE_PATCH_STEP Instance_PatchState = 13
	// The instance is running the post-patch step.
	Instance_RUNNING_POST_PATCH_STEP Instance_PatchState = 14
	// The service could not detect the presence of the agent. Check to ensure
	// that the agent is installed, running, and able to communicate with the
	// service.
	Instance_NO_AGENT_DETECTED Instance_PatchState = 15
)

var Instance_PatchState_name = map[int32]string{
	0:  "PATCH_STATE_UNSPECIFIED",
	1:  "PENDING",
	2:  "INACTIVE",
	3:  "NOTIFIED",
	4:  "STARTED",
	5:  "DOWNLOADING_PATCHES",
	6:  "APPLYING_PATCHES",
	7:  "REBOOTING",
	8:  "SUCCEEDED",
	9:  "SUCCEEDED_REBOOT_REQUIRED",
	10: "FAILED",
	11: "ACKED",
	12: "TIMED_OUT",
	13: "RUNNING_PRE_PATCH_STEP",
	14: "RUNNING_POST_PATCH_STEP",
	15: "NO_AGENT_DETECTED",
}

var Instance_PatchState_value = map[string]int32{
	"PATCH_STATE_UNSPECIFIED":   0,
	"PENDING":                   1,
	"INACTIVE":                  2,
	"NOTIFIED":                  3,
	"STARTED":                   4,
	"DOWNLOADING_PATCHES":       5,
	"APPLYING_PATCHES":          6,
	"REBOOTING":                 7,
	"SUCCEEDED":                 8,
	"SUCCEEDED_REBOOT_REQUIRED": 9,
	"FAILED":                    10,
	"ACKED":                     11,
	"TIMED_OUT":                 12,
	"RUNNING_PRE_PATCH_STEP":    13,
	"RUNNING_POST_PATCH_STEP":   14,
	"NO_AGENT_DETECTED":         15,
}

func (x Instance_PatchState) String() string {
	return proto.EnumName(Instance_PatchState_name, int32(x))
}

func (Instance_PatchState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{9, 0}
}

// Apt patch type.
type AptSettings_Type int32

const (
	// By default, upgrade will be performed.
	AptSettings_TYPE_UNSPECIFIED AptSettings_Type = 0
	// Runs `apt-get dist-upgrade`.
	AptSettings_DIST AptSettings_Type = 1
	// Runs `apt-get upgrade`.
	AptSettings_UPGRADE AptSettings_Type = 2
)

var AptSettings_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "DIST",
	2: "UPGRADE",
}

var AptSettings_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"DIST":             1,
	"UPGRADE":          2,
}

func (x AptSettings_Type) String() string {
	return proto.EnumName(AptSettings_Type_name, int32(x))
}

func (AptSettings_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{11, 0}
}

// Microsoft Windows update classifications as defined in
// [1]
// https://support.microsoft.com/en-us/help/824684/description-of-the-standard-terminology-that-is-used-to-describe-micro
type WindowsUpdateSettings_Classification int32

const (
	// Invalid. If classifications are included, they must be specified.
	WindowsUpdateSettings_CLASSIFICATION_UNSPECIFIED WindowsUpdateSettings_Classification = 0
	// "A widely released fix for a specific problem that addresses a critical,
	// non-security-related bug." [1]
	WindowsUpdateSettings_CRITICAL WindowsUpdateSettings_Classification = 1
	// "A widely released fix for a product-specific, security-related
	// vulnerability. Security vulnerabilities are rated by their severity. The
	// severity rating is indicated in the Microsoft security bulletin as
	// critical, important, moderate, or low." [1]
	WindowsUpdateSettings_SECURITY WindowsUpdateSettings_Classification = 2
	// "A widely released and frequent software update that contains additions
	// to a product's definition database. Definition databases are often used
	// to detect objects that have specific attributes, such as malicious code,
	// phishing websites, or junk mail." [1]
	WindowsUpdateSettings_DEFINITION WindowsUpdateSettings_Classification = 3
	// "Software that controls the input and output of a device." [1]
	WindowsUpdateSettings_DRIVER WindowsUpdateSettings_Classification = 4
	// "New product functionality that is first distributed outside the context
	// of a product release and that is typically included in the next full
	// product release." [1]
	WindowsUpdateSettings_FEATURE_PACK WindowsUpdateSettings_Classification = 5
	// "A tested, cumulative set of all hotfixes, security updates, critical
	// updates, and updates. Additionally, service packs may contain additional
	// fixes for problems that are found internally since the release of the
	// product. Service packs my also contain a limited number of
	// customer-requested design changes or features." [1]
	WindowsUpdateSettings_SERVICE_PACK WindowsUpdateSettings_Classification = 6
	// "A utility or feature that helps complete a task or set of tasks." [1]
	WindowsUpdateSettings_TOOL WindowsUpdateSettings_Classification = 7
	// "A tested, cumulative set of hotfixes, security updates, critical
	// updates, and updates that are packaged together for easy deployment. A
	// rollup generally targets a specific area, such as security, or a
	// component of a product, such as Internet Information Services (IIS)." [1]
	WindowsUpdateSettings_UPDATE_ROLLUP WindowsUpdateSettings_Classification = 8
	// "A widely released fix for a specific problem. An update addresses a
	// noncritical, non-security-related bug." [1]
	WindowsUpdateSettings_UPDATE WindowsUpdateSettings_Classification = 9
)

var WindowsUpdateSettings_Classification_name = map[int32]string{
	0: "CLASSIFICATION_UNSPECIFIED",
	1: "CRITICAL",
	2: "SECURITY",
	3: "DEFINITION",
	4: "DRIVER",
	5: "FEATURE_PACK",
	6: "SERVICE_PACK",
	7: "TOOL",
	8: "UPDATE_ROLLUP",
	9: "UPDATE",
}

var WindowsUpdateSettings_Classification_value = map[string]int32{
	"CLASSIFICATION_UNSPECIFIED": 0,
	"CRITICAL":                   1,
	"SECURITY":                   2,
	"DEFINITION":                 3,
	"DRIVER":                     4,
	"FEATURE_PACK":               5,
	"SERVICE_PACK":               6,
	"TOOL":                       7,
	"UPDATE_ROLLUP":              8,
	"UPDATE":                     9,
}

func (x WindowsUpdateSettings_Classification) String() string {
	return proto.EnumName(WindowsUpdateSettings_Classification_name, int32(x))
}

func (WindowsUpdateSettings_Classification) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{15, 0}
}

// The interpreter used to execute the a file.
type ExecStepConfig_Interpreter int32

const (
	// Invalid for a Windows ExecStepConfig. For a Linux ExecStepConfig, the
	// interpreter will be parsed from the shebang line of the script if
	// unspecified.
	ExecStepConfig_INTERPRETER_UNSPECIFIED ExecStepConfig_Interpreter = 0
	// Indicates that the script is run with `/bin/sh` on Linux and `cmd`
	// on Windows.
	ExecStepConfig_SHELL ExecStepConfig_Interpreter = 1
	// Indicates that the file is run with PowerShell flags
	// `-NonInteractive`, `-NoProfile`, and `-ExecutionPolicy Bypass`.
	ExecStepConfig_POWERSHELL ExecStepConfig_Interpreter = 2
)

var ExecStepConfig_Interpreter_name = map[int32]string{
	0: "INTERPRETER_UNSPECIFIED",
	1: "SHELL",
	2: "POWERSHELL",
}

var ExecStepConfig_Interpreter_value = map[string]int32{
	"INTERPRETER_UNSPECIFIED": 0,
	"SHELL":                   1,
	"POWERSHELL":              2,
}

func (x ExecStepConfig_Interpreter) String() string {
	return proto.EnumName(ExecStepConfig_Interpreter_name, int32(x))
}

func (ExecStepConfig_Interpreter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{17, 0}
}

// A request message to initiate patching across Google Compute Engine
// instances.
type ExecutePatchJobRequest struct {
	// Required. The project in which to run this patch in the form `projects/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Description of the patch job. Length of the description is limited
	// to 1024 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Instances to patch, either explicitly or filtered by some criteria such
	// as zone or labels.
	InstanceFilter *PatchInstanceFilter `protobuf:"bytes,7,opt,name=instance_filter,json=instanceFilter,proto3" json:"instance_filter,omitempty"`
	// Patch configuration being applied. If omitted, instances are
	// patched using the default configurations.
	PatchConfig *PatchConfig `protobuf:"bytes,4,opt,name=patch_config,json=patchConfig,proto3" json:"patch_config,omitempty"`
	// Duration of the patch job. After the duration ends, the patch job
	// times out.
	Duration *duration.Duration `protobuf:"bytes,5,opt,name=duration,proto3" json:"duration,omitempty"`
	// If this patch is a dry-run only, instances are contacted but
	// will do nothing.
	DryRun bool `protobuf:"varint,6,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Display name for this patch job. This does not have to be unique.
	DisplayName          string   `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecutePatchJobRequest) Reset()         { *m = ExecutePatchJobRequest{} }
func (m *ExecutePatchJobRequest) String() string { return proto.CompactTextString(m) }
func (*ExecutePatchJobRequest) ProtoMessage()    {}
func (*ExecutePatchJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{0}
}

func (m *ExecutePatchJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutePatchJobRequest.Unmarshal(m, b)
}
func (m *ExecutePatchJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutePatchJobRequest.Marshal(b, m, deterministic)
}
func (m *ExecutePatchJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutePatchJobRequest.Merge(m, src)
}
func (m *ExecutePatchJobRequest) XXX_Size() int {
	return xxx_messageInfo_ExecutePatchJobRequest.Size(m)
}
func (m *ExecutePatchJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutePatchJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutePatchJobRequest proto.InternalMessageInfo

func (m *ExecutePatchJobRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ExecutePatchJobRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ExecutePatchJobRequest) GetInstanceFilter() *PatchInstanceFilter {
	if m != nil {
		return m.InstanceFilter
	}
	return nil
}

func (m *ExecutePatchJobRequest) GetPatchConfig() *PatchConfig {
	if m != nil {
		return m.PatchConfig
	}
	return nil
}

func (m *ExecutePatchJobRequest) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *ExecutePatchJobRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *ExecutePatchJobRequest) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// Request to get an active or completed patch job.
type GetPatchJobRequest struct {
	// Required. Name of the patch in the form `projects/*/patchJobs/*`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetPatchJobRequest) Reset()         { *m = GetPatchJobRequest{} }
func (m *GetPatchJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetPatchJobRequest) ProtoMessage()    {}
func (*GetPatchJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{1}
}

func (m *GetPatchJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPatchJobRequest.Unmarshal(m, b)
}
func (m *GetPatchJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPatchJobRequest.Marshal(b, m, deterministic)
}
func (m *GetPatchJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPatchJobRequest.Merge(m, src)
}
func (m *GetPatchJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetPatchJobRequest.Size(m)
}
func (m *GetPatchJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPatchJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPatchJobRequest proto.InternalMessageInfo

func (m *GetPatchJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list details for all instances that are part of a patch job.
type ListPatchJobInstanceDetailsRequest struct {
	// Required. The parent for the instances are in the form of `projects/*/patchJobs/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of instance details records to return.  Default is 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call
	// that indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters results listed in the response. This
	// field supports filtering results by instance zone, name, state, or
	// `failure_reason`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPatchJobInstanceDetailsRequest) Reset()         { *m = ListPatchJobInstanceDetailsRequest{} }
func (m *ListPatchJobInstanceDetailsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPatchJobInstanceDetailsRequest) ProtoMessage()    {}
func (*ListPatchJobInstanceDetailsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{2}
}

func (m *ListPatchJobInstanceDetailsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPatchJobInstanceDetailsRequest.Unmarshal(m, b)
}
func (m *ListPatchJobInstanceDetailsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPatchJobInstanceDetailsRequest.Marshal(b, m, deterministic)
}
func (m *ListPatchJobInstanceDetailsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPatchJobInstanceDetailsRequest.Merge(m, src)
}
func (m *ListPatchJobInstanceDetailsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPatchJobInstanceDetailsRequest.Size(m)
}
func (m *ListPatchJobInstanceDetailsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPatchJobInstanceDetailsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPatchJobInstanceDetailsRequest proto.InternalMessageInfo

func (m *ListPatchJobInstanceDetailsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListPatchJobInstanceDetailsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListPatchJobInstanceDetailsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListPatchJobInstanceDetailsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// A response message for listing the instances details for a patch job.
type ListPatchJobInstanceDetailsResponse struct {
	// A list of instance status.
	PatchJobInstanceDetails []*PatchJobInstanceDetails `protobuf:"bytes,1,rep,name=patch_job_instance_details,json=patchJobInstanceDetails,proto3" json:"patch_job_instance_details,omitempty"`
	// A pagination token that can be used to get the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPatchJobInstanceDetailsResponse) Reset()         { *m = ListPatchJobInstanceDetailsResponse{} }
func (m *ListPatchJobInstanceDetailsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPatchJobInstanceDetailsResponse) ProtoMessage()    {}
func (*ListPatchJobInstanceDetailsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{3}
}

func (m *ListPatchJobInstanceDetailsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPatchJobInstanceDetailsResponse.Unmarshal(m, b)
}
func (m *ListPatchJobInstanceDetailsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPatchJobInstanceDetailsResponse.Marshal(b, m, deterministic)
}
func (m *ListPatchJobInstanceDetailsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPatchJobInstanceDetailsResponse.Merge(m, src)
}
func (m *ListPatchJobInstanceDetailsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPatchJobInstanceDetailsResponse.Size(m)
}
func (m *ListPatchJobInstanceDetailsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPatchJobInstanceDetailsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPatchJobInstanceDetailsResponse proto.InternalMessageInfo

func (m *ListPatchJobInstanceDetailsResponse) GetPatchJobInstanceDetails() []*PatchJobInstanceDetails {
	if m != nil {
		return m.PatchJobInstanceDetails
	}
	return nil
}

func (m *ListPatchJobInstanceDetailsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Patch details for a VM instance. For more information about reviewing VM
// instance details, see
// [Listing all VM instance details for a specific patch
// job](/compute/docs/os-patch-management/manage-patch-jobs#list-instance-details).
type PatchJobInstanceDetails struct {
	// The instance name in the form `projects/*/zones/*/instances/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique identifier for the instance. This identifier is
	// defined by the server.
	InstanceSystemId string `protobuf:"bytes,2,opt,name=instance_system_id,json=instanceSystemId,proto3" json:"instance_system_id,omitempty"`
	// Current state of instance patch.
	State Instance_PatchState `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.osconfig.v1.Instance_PatchState" json:"state,omitempty"`
	// If the patch fails, this field provides the reason.
	FailureReason string `protobuf:"bytes,4,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	// The number of times the agent that the agent attempts to apply the patch.
	AttemptCount         int64    `protobuf:"varint,5,opt,name=attempt_count,json=attemptCount,proto3" json:"attempt_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PatchJobInstanceDetails) Reset()         { *m = PatchJobInstanceDetails{} }
func (m *PatchJobInstanceDetails) String() string { return proto.CompactTextString(m) }
func (*PatchJobInstanceDetails) ProtoMessage()    {}
func (*PatchJobInstanceDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{4}
}

func (m *PatchJobInstanceDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchJobInstanceDetails.Unmarshal(m, b)
}
func (m *PatchJobInstanceDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchJobInstanceDetails.Marshal(b, m, deterministic)
}
func (m *PatchJobInstanceDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchJobInstanceDetails.Merge(m, src)
}
func (m *PatchJobInstanceDetails) XXX_Size() int {
	return xxx_messageInfo_PatchJobInstanceDetails.Size(m)
}
func (m *PatchJobInstanceDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchJobInstanceDetails.DiscardUnknown(m)
}

var xxx_messageInfo_PatchJobInstanceDetails proto.InternalMessageInfo

func (m *PatchJobInstanceDetails) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PatchJobInstanceDetails) GetInstanceSystemId() string {
	if m != nil {
		return m.InstanceSystemId
	}
	return ""
}

func (m *PatchJobInstanceDetails) GetState() Instance_PatchState {
	if m != nil {
		return m.State
	}
	return Instance_PATCH_STATE_UNSPECIFIED
}

func (m *PatchJobInstanceDetails) GetFailureReason() string {
	if m != nil {
		return m.FailureReason
	}
	return ""
}

func (m *PatchJobInstanceDetails) GetAttemptCount() int64 {
	if m != nil {
		return m.AttemptCount
	}
	return 0
}

// A request message for listing patch jobs.
type ListPatchJobsRequest struct {
	// Required. In the form of `projects/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of instance status to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call
	// that indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// If provided, this field specifies the criteria that must be met by patch
	// jobs to be included in the response.
	// Currently, filtering is only available on the patch_deployment field.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPatchJobsRequest) Reset()         { *m = ListPatchJobsRequest{} }
func (m *ListPatchJobsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPatchJobsRequest) ProtoMessage()    {}
func (*ListPatchJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{5}
}

func (m *ListPatchJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPatchJobsRequest.Unmarshal(m, b)
}
func (m *ListPatchJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPatchJobsRequest.Marshal(b, m, deterministic)
}
func (m *ListPatchJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPatchJobsRequest.Merge(m, src)
}
func (m *ListPatchJobsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPatchJobsRequest.Size(m)
}
func (m *ListPatchJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPatchJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPatchJobsRequest proto.InternalMessageInfo

func (m *ListPatchJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListPatchJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListPatchJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListPatchJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// A response message for listing patch jobs.
type ListPatchJobsResponse struct {
	// The list of patch jobs.
	PatchJobs []*PatchJob `protobuf:"bytes,1,rep,name=patch_jobs,json=patchJobs,proto3" json:"patch_jobs,omitempty"`
	// A pagination token that can be used to get the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPatchJobsResponse) Reset()         { *m = ListPatchJobsResponse{} }
func (m *ListPatchJobsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPatchJobsResponse) ProtoMessage()    {}
func (*ListPatchJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{6}
}

func (m *ListPatchJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPatchJobsResponse.Unmarshal(m, b)
}
func (m *ListPatchJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPatchJobsResponse.Marshal(b, m, deterministic)
}
func (m *ListPatchJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPatchJobsResponse.Merge(m, src)
}
func (m *ListPatchJobsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPatchJobsResponse.Size(m)
}
func (m *ListPatchJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPatchJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPatchJobsResponse proto.InternalMessageInfo

func (m *ListPatchJobsResponse) GetPatchJobs() []*PatchJob {
	if m != nil {
		return m.PatchJobs
	}
	return nil
}

func (m *ListPatchJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A high level representation of a patch job that is either in progress
// or has completed.
//
// Instances details are not included in the job. To paginate through instance
// details, use ListPatchJobInstanceDetails.
//
// For more information about patch jobs, see
// [Creating patch jobs](/compute/docs/os-patch-management/create-patch-job).
type PatchJob struct {
	// Unique identifier for this patch job in the form
	// `projects/*/patchJobs/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name for this patch job. This is not a unique identifier.
	DisplayName string `protobuf:"bytes,14,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of the patch job. Length of the description is limited
	// to 1024 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Time this patch job was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Last time this patch job was updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The current state of the PatchJob .
	State PatchJob_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.osconfig.v1.PatchJob_State" json:"state,omitempty"`
	// Instances to patch.
	InstanceFilter *PatchInstanceFilter `protobuf:"bytes,13,opt,name=instance_filter,json=instanceFilter,proto3" json:"instance_filter,omitempty"`
	// Patch configuration being applied.
	PatchConfig *PatchConfig `protobuf:"bytes,7,opt,name=patch_config,json=patchConfig,proto3" json:"patch_config,omitempty"`
	// Duration of the patch job. After the duration ends, the
	// patch job times out.
	Duration *duration.Duration `protobuf:"bytes,8,opt,name=duration,proto3" json:"duration,omitempty"`
	// Summary of instance details.
	InstanceDetailsSummary *PatchJob_InstanceDetailsSummary `protobuf:"bytes,9,opt,name=instance_details_summary,json=instanceDetailsSummary,proto3" json:"instance_details_summary,omitempty"`
	// If this patch job is a dry run, the agent reports that it has
	// finished without running any updates on the VM instance.
	DryRun bool `protobuf:"varint,10,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// If this patch job failed, this message provides information about the
	// failure.
	ErrorMessage string `protobuf:"bytes,11,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Reflects the overall progress of the patch job in the range of
	// 0.0 being no progress to 100.0 being complete.
	PercentComplete float64 `protobuf:"fixed64,12,opt,name=percent_complete,json=percentComplete,proto3" json:"percent_complete,omitempty"`
	// Output only. Name of the patch deployment that created this patch job.
	PatchDeployment      string   `protobuf:"bytes,15,opt,name=patch_deployment,json=patchDeployment,proto3" json:"patch_deployment,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PatchJob) Reset()         { *m = PatchJob{} }
func (m *PatchJob) String() string { return proto.CompactTextString(m) }
func (*PatchJob) ProtoMessage()    {}
func (*PatchJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{7}
}

func (m *PatchJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchJob.Unmarshal(m, b)
}
func (m *PatchJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchJob.Marshal(b, m, deterministic)
}
func (m *PatchJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchJob.Merge(m, src)
}
func (m *PatchJob) XXX_Size() int {
	return xxx_messageInfo_PatchJob.Size(m)
}
func (m *PatchJob) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchJob.DiscardUnknown(m)
}

var xxx_messageInfo_PatchJob proto.InternalMessageInfo

func (m *PatchJob) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PatchJob) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *PatchJob) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PatchJob) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *PatchJob) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *PatchJob) GetState() PatchJob_State {
	if m != nil {
		return m.State
	}
	return PatchJob_STATE_UNSPECIFIED
}

func (m *PatchJob) GetInstanceFilter() *PatchInstanceFilter {
	if m != nil {
		return m.InstanceFilter
	}
	return nil
}

func (m *PatchJob) GetPatchConfig() *PatchConfig {
	if m != nil {
		return m.PatchConfig
	}
	return nil
}

func (m *PatchJob) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *PatchJob) GetInstanceDetailsSummary() *PatchJob_InstanceDetailsSummary {
	if m != nil {
		return m.InstanceDetailsSummary
	}
	return nil
}

func (m *PatchJob) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *PatchJob) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

func (m *PatchJob) GetPercentComplete() float64 {
	if m != nil {
		return m.PercentComplete
	}
	return 0
}

func (m *PatchJob) GetPatchDeployment() string {
	if m != nil {
		return m.PatchDeployment
	}
	return ""
}

// A summary of the current patch state across all instances that this patch
// job affects. Contains counts of instances in different states. These states
// map to `InstancePatchState`. List patch job instance details to see the
// specific states of each instance.
type PatchJob_InstanceDetailsSummary struct {
	// Number of instances pending patch job.
	PendingInstanceCount int64 `protobuf:"varint,1,opt,name=pending_instance_count,json=pendingInstanceCount,proto3" json:"pending_instance_count,omitempty"`
	// Number of instances that are inactive.
	InactiveInstanceCount int64 `protobuf:"varint,2,opt,name=inactive_instance_count,json=inactiveInstanceCount,proto3" json:"inactive_instance_count,omitempty"`
	// Number of instances notified about patch job.
	NotifiedInstanceCount int64 `protobuf:"varint,3,opt,name=notified_instance_count,json=notifiedInstanceCount,proto3" json:"notified_instance_count,omitempty"`
	// Number of instances that have started.
	StartedInstanceCount int64 `protobuf:"varint,4,opt,name=started_instance_count,json=startedInstanceCount,proto3" json:"started_instance_count,omitempty"`
	// Number of instances that are downloading patches.
	DownloadingPatchesInstanceCount int64 `protobuf:"varint,5,opt,name=downloading_patches_instance_count,json=downloadingPatchesInstanceCount,proto3" json:"downloading_patches_instance_count,omitempty"`
	// Number of instances that are applying patches.
	ApplyingPatchesInstanceCount int64 `protobuf:"varint,6,opt,name=applying_patches_instance_count,json=applyingPatchesInstanceCount,proto3" json:"applying_patches_instance_count,omitempty"`
	// Number of instances rebooting.
	RebootingInstanceCount int64 `protobuf:"varint,7,opt,name=rebooting_instance_count,json=rebootingInstanceCount,proto3" json:"rebooting_instance_count,omitempty"`
	// Number of instances that have completed successfully.
	SucceededInstanceCount int64 `protobuf:"varint,8,opt,name=succeeded_instance_count,json=succeededInstanceCount,proto3" json:"succeeded_instance_count,omitempty"`
	// Number of instances that require reboot.
	SucceededRebootRequiredInstanceCount int64 `protobuf:"varint,9,opt,name=succeeded_reboot_required_instance_count,json=succeededRebootRequiredInstanceCount,proto3" json:"succeeded_reboot_required_instance_count,omitempty"`
	// Number of instances that failed.
	FailedInstanceCount int64 `protobuf:"varint,10,opt,name=failed_instance_count,json=failedInstanceCount,proto3" json:"failed_instance_count,omitempty"`
	// Number of instances that have acked and will start shortly.
	AckedInstanceCount int64 `protobuf:"varint,11,opt,name=acked_instance_count,json=ackedInstanceCount,proto3" json:"acked_instance_count,omitempty"`
	// Number of instances that exceeded the time out while applying the patch.
	TimedOutInstanceCount int64 `protobuf:"varint,12,opt,name=timed_out_instance_count,json=timedOutInstanceCount,proto3" json:"timed_out_instance_count,omitempty"`
	// Number of instances that are running the pre-patch step.
	PrePatchStepInstanceCount int64 `protobuf:"varint,13,opt,name=pre_patch_step_instance_count,json=prePatchStepInstanceCount,proto3" json:"pre_patch_step_instance_count,omitempty"`
	// Number of instances that are running the post-patch step.
	PostPatchStepInstanceCount int64 `protobuf:"varint,14,opt,name=post_patch_step_instance_count,json=postPatchStepInstanceCount,proto3" json:"post_patch_step_instance_count,omitempty"`
	// Number of instances that do not appear to be running the agent. Check to
	// ensure that the agent is installed, running, and able to communicate with
	// the service.
	NoAgentDetectedInstanceCount int64    `protobuf:"varint,15,opt,name=no_agent_detected_instance_count,json=noAgentDetectedInstanceCount,proto3" json:"no_agent_detected_instance_count,omitempty"`
	XXX_NoUnkeyedLiteral         struct{} `json:"-"`
	XXX_unrecognized             []byte   `json:"-"`
	XXX_sizecache                int32    `json:"-"`
}

func (m *PatchJob_InstanceDetailsSummary) Reset()         { *m = PatchJob_InstanceDetailsSummary{} }
func (m *PatchJob_InstanceDetailsSummary) String() string { return proto.CompactTextString(m) }
func (*PatchJob_InstanceDetailsSummary) ProtoMessage()    {}
func (*PatchJob_InstanceDetailsSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{7, 0}
}

func (m *PatchJob_InstanceDetailsSummary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchJob_InstanceDetailsSummary.Unmarshal(m, b)
}
func (m *PatchJob_InstanceDetailsSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchJob_InstanceDetailsSummary.Marshal(b, m, deterministic)
}
func (m *PatchJob_InstanceDetailsSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchJob_InstanceDetailsSummary.Merge(m, src)
}
func (m *PatchJob_InstanceDetailsSummary) XXX_Size() int {
	return xxx_messageInfo_PatchJob_InstanceDetailsSummary.Size(m)
}
func (m *PatchJob_InstanceDetailsSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchJob_InstanceDetailsSummary.DiscardUnknown(m)
}

var xxx_messageInfo_PatchJob_InstanceDetailsSummary proto.InternalMessageInfo

func (m *PatchJob_InstanceDetailsSummary) GetPendingInstanceCount() int64 {
	if m != nil {
		return m.PendingInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetInactiveInstanceCount() int64 {
	if m != nil {
		return m.InactiveInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetNotifiedInstanceCount() int64 {
	if m != nil {
		return m.NotifiedInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetStartedInstanceCount() int64 {
	if m != nil {
		return m.StartedInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetDownloadingPatchesInstanceCount() int64 {
	if m != nil {
		return m.DownloadingPatchesInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetApplyingPatchesInstanceCount() int64 {
	if m != nil {
		return m.ApplyingPatchesInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetRebootingInstanceCount() int64 {
	if m != nil {
		return m.RebootingInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetSucceededInstanceCount() int64 {
	if m != nil {
		return m.SucceededInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetSucceededRebootRequiredInstanceCount() int64 {
	if m != nil {
		return m.SucceededRebootRequiredInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetFailedInstanceCount() int64 {
	if m != nil {
		return m.FailedInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetAckedInstanceCount() int64 {
	if m != nil {
		return m.AckedInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetTimedOutInstanceCount() int64 {
	if m != nil {
		return m.TimedOutInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetPrePatchStepInstanceCount() int64 {
	if m != nil {
		return m.PrePatchStepInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetPostPatchStepInstanceCount() int64 {
	if m != nil {
		return m.PostPatchStepInstanceCount
	}
	return 0
}

func (m *PatchJob_InstanceDetailsSummary) GetNoAgentDetectedInstanceCount() int64 {
	if m != nil {
		return m.NoAgentDetectedInstanceCount
	}
	return 0
}

// Patch configuration specifications. Contains details on how to apply the
// patch(es) to a VM instance.
type PatchConfig struct {
	// Post-patch reboot settings.
	RebootConfig PatchConfig_RebootConfig `protobuf:"varint,1,opt,name=reboot_config,json=rebootConfig,proto3,enum=google.cloud.osconfig.v1.PatchConfig_RebootConfig" json:"reboot_config,omitempty"`
	// Apt update settings. Use this setting to override the default `apt` patch
	// rules.
	Apt *AptSettings `protobuf:"bytes,3,opt,name=apt,proto3" json:"apt,omitempty"`
	// Yum update settings. Use this setting to override the default `yum` patch
	// rules.
	Yum *YumSettings `protobuf:"bytes,4,opt,name=yum,proto3" json:"yum,omitempty"`
	// Goo update settings. Use this setting to override the default `goo` patch
	// rules.
	Goo *GooSettings `protobuf:"bytes,5,opt,name=goo,proto3" json:"goo,omitempty"`
	// Zypper update settings. Use this setting to override the default `zypper`
	// patch rules.
	Zypper *ZypperSettings `protobuf:"bytes,6,opt,name=zypper,proto3" json:"zypper,omitempty"`
	// Windows update settings. Use this override the default windows patch rules.
	WindowsUpdate *WindowsUpdateSettings `protobuf:"bytes,7,opt,name=windows_update,json=windowsUpdate,proto3" json:"windows_update,omitempty"`
	// The `ExecStep` to run before the patch update.
	PreStep *ExecStep `protobuf:"bytes,8,opt,name=pre_step,json=preStep,proto3" json:"pre_step,omitempty"`
	// The `ExecStep` to run after the patch update.
	PostStep             *ExecStep `protobuf:"bytes,9,opt,name=post_step,json=postStep,proto3" json:"post_step,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *PatchConfig) Reset()         { *m = PatchConfig{} }
func (m *PatchConfig) String() string { return proto.CompactTextString(m) }
func (*PatchConfig) ProtoMessage()    {}
func (*PatchConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{8}
}

func (m *PatchConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchConfig.Unmarshal(m, b)
}
func (m *PatchConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchConfig.Marshal(b, m, deterministic)
}
func (m *PatchConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchConfig.Merge(m, src)
}
func (m *PatchConfig) XXX_Size() int {
	return xxx_messageInfo_PatchConfig.Size(m)
}
func (m *PatchConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PatchConfig proto.InternalMessageInfo

func (m *PatchConfig) GetRebootConfig() PatchConfig_RebootConfig {
	if m != nil {
		return m.RebootConfig
	}
	return PatchConfig_REBOOT_CONFIG_UNSPECIFIED
}

func (m *PatchConfig) GetApt() *AptSettings {
	if m != nil {
		return m.Apt
	}
	return nil
}

func (m *PatchConfig) GetYum() *YumSettings {
	if m != nil {
		return m.Yum
	}
	return nil
}

func (m *PatchConfig) GetGoo() *GooSettings {
	if m != nil {
		return m.Goo
	}
	return nil
}

func (m *PatchConfig) GetZypper() *ZypperSettings {
	if m != nil {
		return m.Zypper
	}
	return nil
}

func (m *PatchConfig) GetWindowsUpdate() *WindowsUpdateSettings {
	if m != nil {
		return m.WindowsUpdate
	}
	return nil
}

func (m *PatchConfig) GetPreStep() *ExecStep {
	if m != nil {
		return m.PreStep
	}
	return nil
}

func (m *PatchConfig) GetPostStep() *ExecStep {
	if m != nil {
		return m.PostStep
	}
	return nil
}

// Namespace for instance state enums.
type Instance struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{9}
}

func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (m *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(m, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

// Message for canceling a patch job.
type CancelPatchJobRequest struct {
	// Required. Name of the patch in the form `projects/*/patchJobs/*`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelPatchJobRequest) Reset()         { *m = CancelPatchJobRequest{} }
func (m *CancelPatchJobRequest) String() string { return proto.CompactTextString(m) }
func (*CancelPatchJobRequest) ProtoMessage()    {}
func (*CancelPatchJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{10}
}

func (m *CancelPatchJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelPatchJobRequest.Unmarshal(m, b)
}
func (m *CancelPatchJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelPatchJobRequest.Marshal(b, m, deterministic)
}
func (m *CancelPatchJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelPatchJobRequest.Merge(m, src)
}
func (m *CancelPatchJobRequest) XXX_Size() int {
	return xxx_messageInfo_CancelPatchJobRequest.Size(m)
}
func (m *CancelPatchJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelPatchJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelPatchJobRequest proto.InternalMessageInfo

func (m *CancelPatchJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Apt patching is completed by executing `apt-get update && apt-get
// upgrade`. Additional options can be set to control how this is executed.
type AptSettings struct {
	// By changing the type to DIST, the patching is performed
	// using `apt-get dist-upgrade` instead.
	Type AptSettings_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.osconfig.v1.AptSettings_Type" json:"type,omitempty"`
	// List of packages to exclude from update. These packages will be excluded
	Excludes []string `protobuf:"bytes,2,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of packages to be updated. These are the only packages
	// that will be updated. If these packages are not installed, they will be
	// ignored. This field cannot be specified with any other patch configuration
	// fields.
	ExclusivePackages    []string `protobuf:"bytes,3,rep,name=exclusive_packages,json=exclusivePackages,proto3" json:"exclusive_packages,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AptSettings) Reset()         { *m = AptSettings{} }
func (m *AptSettings) String() string { return proto.CompactTextString(m) }
func (*AptSettings) ProtoMessage()    {}
func (*AptSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{11}
}

func (m *AptSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AptSettings.Unmarshal(m, b)
}
func (m *AptSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AptSettings.Marshal(b, m, deterministic)
}
func (m *AptSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AptSettings.Merge(m, src)
}
func (m *AptSettings) XXX_Size() int {
	return xxx_messageInfo_AptSettings.Size(m)
}
func (m *AptSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_AptSettings.DiscardUnknown(m)
}

var xxx_messageInfo_AptSettings proto.InternalMessageInfo

func (m *AptSettings) GetType() AptSettings_Type {
	if m != nil {
		return m.Type
	}
	return AptSettings_TYPE_UNSPECIFIED
}

func (m *AptSettings) GetExcludes() []string {
	if m != nil {
		return m.Excludes
	}
	return nil
}

func (m *AptSettings) GetExclusivePackages() []string {
	if m != nil {
		return m.ExclusivePackages
	}
	return nil
}

// Yum patching is performed by executing `yum update`. Additional options
// can be set to control how this is executed.
//
// Note that not all settings are supported on all platforms.
type YumSettings struct {
	// Adds the `--security` flag to `yum update`. Not supported on
	// all platforms.
	Security bool `protobuf:"varint,1,opt,name=security,proto3" json:"security,omitempty"`
	// Will cause patch to run `yum update-minimal` instead.
	Minimal bool `protobuf:"varint,2,opt,name=minimal,proto3" json:"minimal,omitempty"`
	// List of packages to exclude from update. These packages are excluded by
	// using the yum `--exclude` flag.
	Excludes []string `protobuf:"bytes,3,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of packages to be updated. These are the only packages
	// that will be updated. If these packages are not installed, they will be
	// ignored. This field must not be specified with any other patch
	// configuration fields.
	ExclusivePackages    []string `protobuf:"bytes,4,rep,name=exclusive_packages,json=exclusivePackages,proto3" json:"exclusive_packages,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *YumSettings) Reset()         { *m = YumSettings{} }
func (m *YumSettings) String() string { return proto.CompactTextString(m) }
func (*YumSettings) ProtoMessage()    {}
func (*YumSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{12}
}

func (m *YumSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_YumSettings.Unmarshal(m, b)
}
func (m *YumSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_YumSettings.Marshal(b, m, deterministic)
}
func (m *YumSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_YumSettings.Merge(m, src)
}
func (m *YumSettings) XXX_Size() int {
	return xxx_messageInfo_YumSettings.Size(m)
}
func (m *YumSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_YumSettings.DiscardUnknown(m)
}

var xxx_messageInfo_YumSettings proto.InternalMessageInfo

func (m *YumSettings) GetSecurity() bool {
	if m != nil {
		return m.Security
	}
	return false
}

func (m *YumSettings) GetMinimal() bool {
	if m != nil {
		return m.Minimal
	}
	return false
}

func (m *YumSettings) GetExcludes() []string {
	if m != nil {
		return m.Excludes
	}
	return nil
}

func (m *YumSettings) GetExclusivePackages() []string {
	if m != nil {
		return m.ExclusivePackages
	}
	return nil
}

// Googet patching is performed by running `googet update`.
type GooSettings struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GooSettings) Reset()         { *m = GooSettings{} }
func (m *GooSettings) String() string { return proto.CompactTextString(m) }
func (*GooSettings) ProtoMessage()    {}
func (*GooSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{13}
}

func (m *GooSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GooSettings.Unmarshal(m, b)
}
func (m *GooSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GooSettings.Marshal(b, m, deterministic)
}
func (m *GooSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GooSettings.Merge(m, src)
}
func (m *GooSettings) XXX_Size() int {
	return xxx_messageInfo_GooSettings.Size(m)
}
func (m *GooSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_GooSettings.DiscardUnknown(m)
}

var xxx_messageInfo_GooSettings proto.InternalMessageInfo

// Zypper patching is performed by running `zypper patch`.
// See also https://en.opensuse.org/SDB:Zypper_manual.
type ZypperSettings struct {
	// Adds the `--with-optional` flag to `zypper patch`.
	WithOptional bool `protobuf:"varint,1,opt,name=with_optional,json=withOptional,proto3" json:"with_optional,omitempty"`
	// Adds the `--with-update` flag, to `zypper patch`.
	WithUpdate bool `protobuf:"varint,2,opt,name=with_update,json=withUpdate,proto3" json:"with_update,omitempty"`
	// Install only patches with these categories.
	// Common categories include security, recommended, and feature.
	Categories []string `protobuf:"bytes,3,rep,name=categories,proto3" json:"categories,omitempty"`
	// Install only patches with these severities.
	// Common severities include critical, important, moderate, and low.
	Severities []string `protobuf:"bytes,4,rep,name=severities,proto3" json:"severities,omitempty"`
	// List of patches to exclude from update.
	Excludes []string `protobuf:"bytes,5,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of patches to be updated. These are the only patches
	// that will be installed using 'zypper patch patch:<patch_name>' command.
	// This field must not be used with any other patch configuration fields.
	ExclusivePatches     []string `protobuf:"bytes,6,rep,name=exclusive_patches,json=exclusivePatches,proto3" json:"exclusive_patches,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZypperSettings) Reset()         { *m = ZypperSettings{} }
func (m *ZypperSettings) String() string { return proto.CompactTextString(m) }
func (*ZypperSettings) ProtoMessage()    {}
func (*ZypperSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{14}
}

func (m *ZypperSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZypperSettings.Unmarshal(m, b)
}
func (m *ZypperSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZypperSettings.Marshal(b, m, deterministic)
}
func (m *ZypperSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZypperSettings.Merge(m, src)
}
func (m *ZypperSettings) XXX_Size() int {
	return xxx_messageInfo_ZypperSettings.Size(m)
}
func (m *ZypperSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_ZypperSettings.DiscardUnknown(m)
}

var xxx_messageInfo_ZypperSettings proto.InternalMessageInfo

func (m *ZypperSettings) GetWithOptional() bool {
	if m != nil {
		return m.WithOptional
	}
	return false
}

func (m *ZypperSettings) GetWithUpdate() bool {
	if m != nil {
		return m.WithUpdate
	}
	return false
}

func (m *ZypperSettings) GetCategories() []string {
	if m != nil {
		return m.Categories
	}
	return nil
}

func (m *ZypperSettings) GetSeverities() []string {
	if m != nil {
		return m.Severities
	}
	return nil
}

func (m *ZypperSettings) GetExcludes() []string {
	if m != nil {
		return m.Excludes
	}
	return nil
}

func (m *ZypperSettings) GetExclusivePatches() []string {
	if m != nil {
		return m.ExclusivePatches
	}
	return nil
}

// Windows patching is performed using the Windows Update Agent.
type WindowsUpdateSettings struct {
	// Only apply updates of these windows update classifications. If empty, all
	// updates are applied.
	Classifications []WindowsUpdateSettings_Classification `protobuf:"varint,1,rep,packed,name=classifications,proto3,enum=google.cloud.osconfig.v1.WindowsUpdateSettings_Classification" json:"classifications,omitempty"`
	// List of KBs to exclude from update.
	Excludes []string `protobuf:"bytes,2,rep,name=excludes,proto3" json:"excludes,omitempty"`
	// An exclusive list of kbs to be updated. These are the only patches
	// that will be updated. This field must not be used with other
	// patch configurations.
	ExclusivePatches     []string `protobuf:"bytes,3,rep,name=exclusive_patches,json=exclusivePatches,proto3" json:"exclusive_patches,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowsUpdateSettings) Reset()         { *m = WindowsUpdateSettings{} }
func (m *WindowsUpdateSettings) String() string { return proto.CompactTextString(m) }
func (*WindowsUpdateSettings) ProtoMessage()    {}
func (*WindowsUpdateSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{15}
}

func (m *WindowsUpdateSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowsUpdateSettings.Unmarshal(m, b)
}
func (m *WindowsUpdateSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowsUpdateSettings.Marshal(b, m, deterministic)
}
func (m *WindowsUpdateSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsUpdateSettings.Merge(m, src)
}
func (m *WindowsUpdateSettings) XXX_Size() int {
	return xxx_messageInfo_WindowsUpdateSettings.Size(m)
}
func (m *WindowsUpdateSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsUpdateSettings.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsUpdateSettings proto.InternalMessageInfo

func (m *WindowsUpdateSettings) GetClassifications() []WindowsUpdateSettings_Classification {
	if m != nil {
		return m.Classifications
	}
	return nil
}

func (m *WindowsUpdateSettings) GetExcludes() []string {
	if m != nil {
		return m.Excludes
	}
	return nil
}

func (m *WindowsUpdateSettings) GetExclusivePatches() []string {
	if m != nil {
		return m.ExclusivePatches
	}
	return nil
}

// A step that runs an executable for a PatchJob.
type ExecStep struct {
	// The ExecStepConfig for all Linux VMs targeted by the PatchJob.
	LinuxExecStepConfig *ExecStepConfig `protobuf:"bytes,1,opt,name=linux_exec_step_config,json=linuxExecStepConfig,proto3" json:"linux_exec_step_config,omitempty"`
	// The ExecStepConfig for all Windows VMs targeted by the PatchJob.
	WindowsExecStepConfig *ExecStepConfig `protobuf:"bytes,2,opt,name=windows_exec_step_config,json=windowsExecStepConfig,proto3" json:"windows_exec_step_config,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}        `json:"-"`
	XXX_unrecognized      []byte          `json:"-"`
	XXX_sizecache         int32           `json:"-"`
}

func (m *ExecStep) Reset()         { *m = ExecStep{} }
func (m *ExecStep) String() string { return proto.CompactTextString(m) }
func (*ExecStep) ProtoMessage()    {}
func (*ExecStep) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{16}
}

func (m *ExecStep) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecStep.Unmarshal(m, b)
}
func (m *ExecStep) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecStep.Marshal(b, m, deterministic)
}
func (m *ExecStep) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecStep.Merge(m, src)
}
func (m *ExecStep) XXX_Size() int {
	return xxx_messageInfo_ExecStep.Size(m)
}
func (m *ExecStep) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecStep.DiscardUnknown(m)
}

var xxx_messageInfo_ExecStep proto.InternalMessageInfo

func (m *ExecStep) GetLinuxExecStepConfig() *ExecStepConfig {
	if m != nil {
		return m.LinuxExecStepConfig
	}
	return nil
}

func (m *ExecStep) GetWindowsExecStepConfig() *ExecStepConfig {
	if m != nil {
		return m.WindowsExecStepConfig
	}
	return nil
}

// Common configurations for an ExecStep.
type ExecStepConfig struct {
	// Location of the executable.
	//
	// Types that are valid to be assigned to Executable:
	//	*ExecStepConfig_LocalPath
	//	*ExecStepConfig_GcsObject
	Executable isExecStepConfig_Executable `protobuf_oneof:"executable"`
	// Defaults to [0]. A list of possible return values that the
	// execution can return to indicate a success.
	AllowedSuccessCodes []int32 `protobuf:"varint,3,rep,packed,name=allowed_success_codes,json=allowedSuccessCodes,proto3" json:"allowed_success_codes,omitempty"`
	// The script interpreter to use to run the script. If no interpreter is
	// specified the script will be executed directly, which will likely
	// only succeed for scripts with [shebang lines]
	// (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
	Interpreter          ExecStepConfig_Interpreter `protobuf:"varint,4,opt,name=interpreter,proto3,enum=google.cloud.osconfig.v1.ExecStepConfig_Interpreter" json:"interpreter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ExecStepConfig) Reset()         { *m = ExecStepConfig{} }
func (m *ExecStepConfig) String() string { return proto.CompactTextString(m) }
func (*ExecStepConfig) ProtoMessage()    {}
func (*ExecStepConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{17}
}

func (m *ExecStepConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecStepConfig.Unmarshal(m, b)
}
func (m *ExecStepConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecStepConfig.Marshal(b, m, deterministic)
}
func (m *ExecStepConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecStepConfig.Merge(m, src)
}
func (m *ExecStepConfig) XXX_Size() int {
	return xxx_messageInfo_ExecStepConfig.Size(m)
}
func (m *ExecStepConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecStepConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExecStepConfig proto.InternalMessageInfo

type isExecStepConfig_Executable interface {
	isExecStepConfig_Executable()
}

type ExecStepConfig_LocalPath struct {
	LocalPath string `protobuf:"bytes,1,opt,name=local_path,json=localPath,proto3,oneof"`
}

type ExecStepConfig_GcsObject struct {
	GcsObject *GcsObject `protobuf:"bytes,2,opt,name=gcs_object,json=gcsObject,proto3,oneof"`
}

func (*ExecStepConfig_LocalPath) isExecStepConfig_Executable() {}

func (*ExecStepConfig_GcsObject) isExecStepConfig_Executable() {}

func (m *ExecStepConfig) GetExecutable() isExecStepConfig_Executable {
	if m != nil {
		return m.Executable
	}
	return nil
}

func (m *ExecStepConfig) GetLocalPath() string {
	if x, ok := m.GetExecutable().(*ExecStepConfig_LocalPath); ok {
		return x.LocalPath
	}
	return ""
}

func (m *ExecStepConfig) GetGcsObject() *GcsObject {
	if x, ok := m.GetExecutable().(*ExecStepConfig_GcsObject); ok {
		return x.GcsObject
	}
	return nil
}

func (m *ExecStepConfig) GetAllowedSuccessCodes() []int32 {
	if m != nil {
		return m.AllowedSuccessCodes
	}
	return nil
}

func (m *ExecStepConfig) GetInterpreter() ExecStepConfig_Interpreter {
	if m != nil {
		return m.Interpreter
	}
	return ExecStepConfig_INTERPRETER_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExecStepConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExecStepConfig_LocalPath)(nil),
		(*ExecStepConfig_GcsObject)(nil),
	}
}

// Google Cloud Storage object representation.
type GcsObject struct {
	// Required. Bucket of the Google Cloud Storage object.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the Google Cloud Storage object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Required. Generation number of the Google Cloud Storage object. This is used to
	// ensure that the ExecStep specified by this PatchJob does not change.
	GenerationNumber     int64    `protobuf:"varint,3,opt,name=generation_number,json=generationNumber,proto3" json:"generation_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsObject) Reset()         { *m = GcsObject{} }
func (m *GcsObject) String() string { return proto.CompactTextString(m) }
func (*GcsObject) ProtoMessage()    {}
func (*GcsObject) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{18}
}

func (m *GcsObject) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsObject.Unmarshal(m, b)
}
func (m *GcsObject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsObject.Marshal(b, m, deterministic)
}
func (m *GcsObject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsObject.Merge(m, src)
}
func (m *GcsObject) XXX_Size() int {
	return xxx_messageInfo_GcsObject.Size(m)
}
func (m *GcsObject) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsObject.DiscardUnknown(m)
}

var xxx_messageInfo_GcsObject proto.InternalMessageInfo

func (m *GcsObject) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GcsObject) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *GcsObject) GetGenerationNumber() int64 {
	if m != nil {
		return m.GenerationNumber
	}
	return 0
}

// A filter to target VM instances for patching. The targeted
// VMs must meet all criteria specified. So if both labels and zones are
// specified, the patch job targets only VMs with those labels and in those
// zones.
type PatchInstanceFilter struct {
	// Target all VM instances in the project. If true, no other criteria is
	// permitted.
	All bool `protobuf:"varint,1,opt,name=all,proto3" json:"all,omitempty"`
	// Targets VM instances matching at least one of these label sets. This allows
	// targeting of disparate groups, for example "env=prod or env=staging".
	GroupLabels []*PatchInstanceFilter_GroupLabel `protobuf:"bytes,2,rep,name=group_labels,json=groupLabels,proto3" json:"group_labels,omitempty"`
	// Targets VM instances in ANY of these zones. Leave empty to target VM
	// instances in any zone.
	Zones []string `protobuf:"bytes,3,rep,name=zones,proto3" json:"zones,omitempty"`
	// Targets any of the VM instances specified. Instances are specified by their
	// URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME],
	// `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or
	// `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
	Instances []string `protobuf:"bytes,4,rep,name=instances,proto3" json:"instances,omitempty"`
	// Targets VMs whose name starts with one of these prefixes. Similar to
	// labels, this is another way to group VMs when targeting configs, for
	// example prefix="prod-".
	InstanceNamePrefixes []string `protobuf:"bytes,5,rep,name=instance_name_prefixes,json=instanceNamePrefixes,proto3" json:"instance_name_prefixes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PatchInstanceFilter) Reset()         { *m = PatchInstanceFilter{} }
func (m *PatchInstanceFilter) String() string { return proto.CompactTextString(m) }
func (*PatchInstanceFilter) ProtoMessage()    {}
func (*PatchInstanceFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{19}
}

func (m *PatchInstanceFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchInstanceFilter.Unmarshal(m, b)
}
func (m *PatchInstanceFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchInstanceFilter.Marshal(b, m, deterministic)
}
func (m *PatchInstanceFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchInstanceFilter.Merge(m, src)
}
func (m *PatchInstanceFilter) XXX_Size() int {
	return xxx_messageInfo_PatchInstanceFilter.Size(m)
}
func (m *PatchInstanceFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchInstanceFilter.DiscardUnknown(m)
}

var xxx_messageInfo_PatchInstanceFilter proto.InternalMessageInfo

func (m *PatchInstanceFilter) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

func (m *PatchInstanceFilter) GetGroupLabels() []*PatchInstanceFilter_GroupLabel {
	if m != nil {
		return m.GroupLabels
	}
	return nil
}

func (m *PatchInstanceFilter) GetZones() []string {
	if m != nil {
		return m.Zones
	}
	return nil
}

func (m *PatchInstanceFilter) GetInstances() []string {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *PatchInstanceFilter) GetInstanceNamePrefixes() []string {
	if m != nil {
		return m.InstanceNamePrefixes
	}
	return nil
}

// Represents a group of VMs that can be identified as having all these
// labels, for example "env=prod and app=web".
type PatchInstanceFilter_GroupLabel struct {
	// Google Compute Engine instance labels that must be present for a VM
	// instance to be targeted by this filter.
	Labels               map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PatchInstanceFilter_GroupLabel) Reset()         { *m = PatchInstanceFilter_GroupLabel{} }
func (m *PatchInstanceFilter_GroupLabel) String() string { return proto.CompactTextString(m) }
func (*PatchInstanceFilter_GroupLabel) ProtoMessage()    {}
func (*PatchInstanceFilter_GroupLabel) Descriptor() ([]byte, []int) {
	return fileDescriptor_17f359040d82dc99, []int{19, 0}
}

func (m *PatchInstanceFilter_GroupLabel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchInstanceFilter_GroupLabel.Unmarshal(m, b)
}
func (m *PatchInstanceFilter_GroupLabel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchInstanceFilter_GroupLabel.Marshal(b, m, deterministic)
}
func (m *PatchInstanceFilter_GroupLabel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchInstanceFilter_GroupLabel.Merge(m, src)
}
func (m *PatchInstanceFilter_GroupLabel) XXX_Size() int {
	return xxx_messageInfo_PatchInstanceFilter_GroupLabel.Size(m)
}
func (m *PatchInstanceFilter_GroupLabel) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchInstanceFilter_GroupLabel.DiscardUnknown(m)
}

var xxx_messageInfo_PatchInstanceFilter_GroupLabel proto.InternalMessageInfo

func (m *PatchInstanceFilter_GroupLabel) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.osconfig.v1.PatchJob_State", PatchJob_State_name, PatchJob_State_value)
	proto.RegisterEnum("google.cloud.osconfig.v1.PatchConfig_RebootConfig", PatchConfig_RebootConfig_name, PatchConfig_RebootConfig_value)
	proto.RegisterEnum("google.cloud.osconfig.v1.Instance_PatchState", Instance_PatchState_name, Instance_PatchState_value)
	proto.RegisterEnum("google.cloud.osconfig.v1.AptSettings_Type", AptSettings_Type_name, AptSettings_Type_value)
	proto.RegisterEnum("google.cloud.osconfig.v1.WindowsUpdateSettings_Classification", WindowsUpdateSettings_Classification_name, WindowsUpdateSettings_Classification_value)
	proto.RegisterEnum("google.cloud.osconfig.v1.ExecStepConfig_Interpreter", ExecStepConfig_Interpreter_name, ExecStepConfig_Interpreter_value)
	proto.RegisterType((*ExecutePatchJobRequest)(nil), "google.cloud.osconfig.v1.ExecutePatchJobRequest")
	proto.RegisterType((*GetPatchJobRequest)(nil), "google.cloud.osconfig.v1.GetPatchJobRequest")
	proto.RegisterType((*ListPatchJobInstanceDetailsRequest)(nil), "google.cloud.osconfig.v1.ListPatchJobInstanceDetailsRequest")
	proto.RegisterType((*ListPatchJobInstanceDetailsResponse)(nil), "google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse")
	proto.RegisterType((*PatchJobInstanceDetails)(nil), "google.cloud.osconfig.v1.PatchJobInstanceDetails")
	proto.RegisterType((*ListPatchJobsRequest)(nil), "google.cloud.osconfig.v1.ListPatchJobsRequest")
	proto.RegisterType((*ListPatchJobsResponse)(nil), "google.cloud.osconfig.v1.ListPatchJobsResponse")
	proto.RegisterType((*PatchJob)(nil), "google.cloud.osconfig.v1.PatchJob")
	proto.RegisterType((*PatchJob_InstanceDetailsSummary)(nil), "google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary")
	proto.RegisterType((*PatchConfig)(nil), "google.cloud.osconfig.v1.PatchConfig")
	proto.RegisterType((*Instance)(nil), "google.cloud.osconfig.v1.Instance")
	proto.RegisterType((*CancelPatchJobRequest)(nil), "google.cloud.osconfig.v1.CancelPatchJobRequest")
	proto.RegisterType((*AptSettings)(nil), "google.cloud.osconfig.v1.AptSettings")
	proto.RegisterType((*YumSettings)(nil), "google.cloud.osconfig.v1.YumSettings")
	proto.RegisterType((*GooSettings)(nil), "google.cloud.osconfig.v1.GooSettings")
	proto.RegisterType((*ZypperSettings)(nil), "google.cloud.osconfig.v1.ZypperSettings")
	proto.RegisterType((*WindowsUpdateSettings)(nil), "google.cloud.osconfig.v1.WindowsUpdateSettings")
	proto.RegisterType((*ExecStep)(nil), "google.cloud.osconfig.v1.ExecStep")
	proto.RegisterType((*ExecStepConfig)(nil), "google.cloud.osconfig.v1.ExecStepConfig")
	proto.RegisterType((*GcsObject)(nil), "google.cloud.osconfig.v1.GcsObject")
	proto.RegisterType((*PatchInstanceFilter)(nil), "google.cloud.osconfig.v1.PatchInstanceFilter")
	proto.RegisterType((*PatchInstanceFilter_GroupLabel)(nil), "google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel.LabelsEntry")
}

func init() {
	proto.RegisterFile("google/cloud/osconfig/v1/patch_jobs.proto", fileDescriptor_17f359040d82dc99)
}

var fileDescriptor_17f359040d82dc99 = []byte{
	// 2633 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0xcd, 0x73, 0xdb, 0xc6,
	0x15, 0x0f, 0x3f, 0x24, 0x91, 0x8f, 0x14, 0x05, 0xaf, 0x2d, 0x99, 0x96, 0x13, 0x5b, 0xa1, 0x93,
	0x56, 0x69, 0x1a, 0x32, 0x56, 0xd2, 0xc6, 0x51, 0xda, 0x34, 0x10, 0x09, 0xc9, 0xa8, 0x19, 0x92,
	0x59, 0x82, 0xf2, 0x38, 0x71, 0x07, 0x03, 0x81, 0x2b, 0x1a, 0x31, 0x08, 0x20, 0xf8, 0xb0, 0x4c,
	0x67, 0x72, 0xc9, 0x1f, 0xd0, 0x43, 0x67, 0xda, 0x7b, 0x0f, 0xbd, 0xf4, 0xde, 0xe9, 0x4c, 0x67,
	0x3a, 0x9d, 0x5c, 0x3b, 0x6d, 0xcf, 0xbd, 0x74, 0x9a, 0x73, 0xfe, 0x84, 0x1c, 0x3a, 0x9d, 0xfd,
	0x00, 0x04, 0x92, 0xfa, 0x4a, 0x26, 0xb9, 0x71, 0xdf, 0x7b, 0xbf, 0x1f, 0xf6, 0xed, 0xbe, 0x8f,
	0xdd, 0x25, 0xbc, 0x32, 0x72, 0xdd, 0x91, 0x4d, 0x1a, 0xa6, 0xed, 0x46, 0xc3, 0x86, 0x1b, 0x98,
	0xae, 0x73, 0x68, 0x8d, 0x1a, 0x4f, 0x6e, 0x37, 0x3c, 0x23, 0x34, 0x1f, 0xe9, 0x1f, 0xbb, 0x07,
	0x41, 0xdd, 0xf3, 0xdd, 0xd0, 0x45, 0x55, 0x6e, 0x5a, 0x67, 0xa6, 0xf5, 0xd8, 0xb4, 0xfe, 0xe4,
	0xf6, 0xfa, 0x4d, 0x41, 0x62, 0x78, 0x56, 0xe3, 0xd0, 0x22, 0xf6, 0x50, 0x3f, 0x20, 0x8f, 0x8c,
	0x27, 0x96, 0xeb, 0x73, 0xe8, 0xfa, 0xb5, 0x94, 0x81, 0x4f, 0x02, 0x37, 0xf2, 0x4d, 0x22, 0x54,
	0x37, 0x84, 0x8a, 0x8d, 0x0e, 0xa2, 0xc3, 0xc6, 0x30, 0xf2, 0x8d, 0xd0, 0x72, 0x1d, 0xa1, 0xbf,
	0x39, 0xab, 0x0f, 0xad, 0x31, 0x09, 0x42, 0x63, 0xec, 0x71, 0x83, 0xda, 0xef, 0x73, 0xb0, 0xa6,
	0x3c, 0x25, 0x66, 0x14, 0x92, 0x1e, 0x9d, 0xf2, 0x2f, 0xdd, 0x03, 0x4c, 0x3e, 0x89, 0x48, 0x10,
	0xa2, 0x7b, 0xb0, 0xe8, 0x19, 0x3e, 0x71, 0xc2, 0x6a, 0x66, 0x23, 0xb3, 0x59, 0xdc, 0x79, 0xe3,
	0x4b, 0x39, 0xfb, 0xb5, 0xfc, 0x1a, 0xbc, 0xca, 0x5c, 0x88, 0x27, 0x32, 0x36, 0x1c, 0x63, 0x44,
	0xfc, 0x3a, 0xff, 0x90, 0xe1, 0x59, 0x41, 0xdd, 0x74, 0xc7, 0x8d, 0x9e, 0xef, 0x7e, 0x4c, 0xcc,
	0x10, 0x0b, 0x0a, 0xb4, 0x01, 0xa5, 0x21, 0x09, 0x4c, 0xdf, 0xf2, 0xe8, 0xec, 0xaa, 0x59, 0xca,
	0x88, 0xd3, 0x22, 0xf4, 0x11, 0xac, 0x58, 0x4e, 0x10, 0x1a, 0x8e, 0x49, 0xf4, 0x43, 0xcb, 0x0e,
	0x89, 0x5f, 0x5d, 0xda, 0xc8, 0x6c, 0x96, 0xb6, 0x5e, 0xab, 0x9f, 0xb6, 0x74, 0x75, 0x36, 0x65,
	0x55, 0xa0, 0x76, 0x19, 0x68, 0x27, 0xf7, 0xa5, 0x9c, 0xc5, 0x15, 0x6b, 0x4a, 0x88, 0xee, 0x42,
	0x99, 0xef, 0x08, 0xc7, 0x56, 0xf3, 0x8c, 0xf9, 0xe5, 0x73, 0x98, 0x9b, 0x6c, 0x88, 0x4b, 0xde,
	0xf1, 0x00, 0xfd, 0x04, 0x0a, 0xf1, 0x1a, 0x57, 0x17, 0x18, 0xcb, 0xb5, 0x98, 0x25, 0x5e, 0xe4,
	0x7a, 0x4b, 0x18, 0xe0, 0xc4, 0x14, 0x5d, 0x85, 0xa5, 0xa1, 0x3f, 0xd1, 0xfd, 0xc8, 0xa9, 0x2e,
	0x6e, 0x64, 0x36, 0x0b, 0x78, 0x71, 0xe8, 0x4f, 0x70, 0xe4, 0xa0, 0x17, 0xa1, 0x3c, 0xb4, 0x02,
	0xcf, 0x36, 0x26, 0xba, 0x63, 0x8c, 0x49, 0xb5, 0x20, 0x56, 0x86, 0xcb, 0x3a, 0xc6, 0x98, 0xd4,
	0x30, 0xa0, 0x3d, 0x12, 0xce, 0x6e, 0xcf, 0xcf, 0x20, 0xcf, 0x00, 0x7c, 0x73, 0x36, 0xd9, 0xe6,
	0xd4, 0x60, 0x23, 0x71, 0x62, 0x76, 0x43, 0x62, 0x38, 0x43, 0xd5, 0xfe, 0x92, 0x81, 0x5a, 0xdb,
	0x0a, 0x12, 0xd6, 0x78, 0x11, 0x5b, 0x24, 0x34, 0x2c, 0x3b, 0x88, 0x3f, 0xf2, 0xde, 0x4c, 0x0c,
	0x5c, 0xfc, 0x33, 0xf1, 0xc6, 0x5f, 0x87, 0xa2, 0x67, 0x8c, 0x88, 0x1e, 0x58, 0xcf, 0x08, 0xdb,
	0xf6, 0x05, 0x5c, 0xa0, 0x82, 0xbe, 0xf5, 0x8c, 0xa0, 0x17, 0x00, 0x98, 0x32, 0x74, 0x1f, 0x13,
	0xa7, 0x9a, 0x63, 0xae, 0x33, 0x73, 0x8d, 0x0a, 0xd0, 0x1a, 0x2c, 0x8a, 0x48, 0xc8, 0x33, 0x95,
	0x18, 0xd5, 0xfe, 0x9a, 0x81, 0x5b, 0x67, 0x4e, 0x3e, 0xf0, 0x5c, 0x27, 0x20, 0xc8, 0x81, 0xf5,
	0x24, 0x0f, 0xf5, 0x24, 0xb8, 0x86, 0xdc, 0xaa, 0x9a, 0xd9, 0xc8, 0x6d, 0x96, 0xb6, 0x6e, 0x9f,
	0x13, 0x03, 0x27, 0xd0, 0x5f, 0xf5, 0x4e, 0x56, 0xa0, 0x1f, 0xc0, 0x8a, 0x43, 0x9e, 0x86, 0x7a,
	0xca, 0x27, 0x1e, 0xe8, 0xcb, 0x54, 0xdc, 0x8b, 0xfd, 0xaa, 0xfd, 0x26, 0x0b, 0x57, 0x4f, 0x21,
	0x47, 0x77, 0xa6, 0xb6, 0xf5, 0xa5, 0xaf, 0xe5, 0x17, 0xe1, 0xa6, 0xe9, 0x8e, 0xbd, 0x28, 0x24,
	0xb3, 0x6b, 0x1d, 0x43, 0xf9, 0x96, 0xa2, 0x1f, 0x03, 0x4a, 0x7c, 0x0c, 0x26, 0x41, 0x48, 0xc6,
	0xba, 0x35, 0x14, 0x13, 0x90, 0x62, 0x4d, 0x9f, 0x29, 0xd4, 0x21, 0x6a, 0xc2, 0x42, 0x10, 0x1a,
	0x21, 0x61, 0xab, 0x5e, 0x39, 0x2b, 0xc9, 0xe2, 0xcf, 0xf0, 0xf5, 0xe8, 0x53, 0x10, 0xe6, 0x58,
	0xf4, 0x32, 0x54, 0x0e, 0x0d, 0xcb, 0x8e, 0x7c, 0xa2, 0xfb, 0xc4, 0x08, 0x5c, 0x47, 0x6c, 0xd4,
	0xb2, 0x90, 0x62, 0x26, 0x44, 0xb7, 0x60, 0xd9, 0x08, 0x43, 0x32, 0xf6, 0x42, 0xdd, 0x74, 0x23,
	0x27, 0x64, 0x89, 0x93, 0xc3, 0x65, 0x21, 0x6c, 0x52, 0x59, 0xed, 0xcf, 0x19, 0xb8, 0x92, 0xde,
	0xd4, 0xe0, 0x7b, 0xa9, 0x43, 0xdf, 0x47, 0x38, 0x7e, 0x9e, 0x81, 0xd5, 0x99, 0x99, 0x8b, 0x00,
	0x94, 0x29, 0x61, 0xdc, 0x08, 0x44, 0xc0, 0xd5, 0xce, 0x0f, 0x38, 0xfa, 0x51, 0x41, 0x75, 0xe1,
	0x98, 0xfa, 0xcf, 0x0a, 0x14, 0x62, 0x3c, 0x42, 0xe9, 0x20, 0x12, 0xe1, 0x31, 0x5b, 0x68, 0x2a,
	0x73, 0x85, 0xe6, 0x02, 0x45, 0xfa, 0x1d, 0x28, 0x99, 0x3e, 0x31, 0x42, 0xa2, 0xd3, 0x46, 0xc2,
	0x96, 0xa8, 0xb4, 0xb5, 0x3e, 0x57, 0x00, 0xb5, 0xb8, 0xcb, 0x60, 0xe0, 0xe6, 0x54, 0x40, 0xc1,
	0x91, 0x37, 0x4c, 0xc0, 0xf9, 0xf3, 0xc1, 0xdc, 0x9c, 0x81, 0xdf, 0x8d, 0xe3, 0x75, 0x81, 0xc5,
	0xeb, 0xe6, 0xf9, 0xab, 0x58, 0x9f, 0x0a, 0xd5, 0xfd, 0xf9, 0xf6, 0xb2, 0xfc, 0x2d, 0xda, 0xcb,
	0xb9, 0x9d, 0x65, 0xe9, 0x3b, 0xe9, 0x2c, 0x85, 0x8b, 0x77, 0x96, 0x00, 0xaa, 0xb3, 0xa5, 0x4d,
	0x0f, 0xa2, 0xf1, 0xd8, 0xf0, 0x27, 0xd5, 0x22, 0xa3, 0x79, 0xfb, 0x02, 0x6b, 0x35, 0x53, 0x86,
	0xfa, 0x9c, 0x00, 0xaf, 0x59, 0x27, 0xca, 0xd3, 0xed, 0x0c, 0xa6, 0xda, 0xd9, 0x2d, 0x58, 0x26,
	0xbe, 0xef, 0xfa, 0xfa, 0x98, 0x04, 0x81, 0x31, 0x22, 0xd5, 0x12, 0x0b, 0xa2, 0x32, 0x13, 0xbe,
	0xcf, 0x65, 0xe8, 0x15, 0x90, 0x3c, 0xe2, 0x9b, 0xc4, 0xa1, 0xf5, 0x60, 0xec, 0xd9, 0x24, 0x24,
	0xd5, 0xf2, 0x46, 0x66, 0x33, 0x83, 0x57, 0x84, 0xbc, 0x29, 0xc4, 0xe8, 0x43, 0x90, 0xf8, 0xf2,
	0x0e, 0x89, 0x67, 0xbb, 0x93, 0x31, 0x2d, 0x03, 0x2b, 0xac, 0x0c, 0x34, 0xbe, 0x94, 0x73, 0x5f,
	0xcb, 0xaf, 0xc0, 0x0f, 0xcf, 0x6c, 0x45, 0xad, 0x04, 0x86, 0x57, 0xbc, 0x69, 0xc1, 0xfa, 0x17,
	0x4b, 0xb0, 0x76, 0xb2, 0xdf, 0xe8, 0x4d, 0x58, 0xf3, 0x88, 0x33, 0xb4, 0x9c, 0xd1, 0x71, 0xdf,
	0xe0, 0xa5, 0x2b, 0xc3, 0x4a, 0xd7, 0x15, 0xa1, 0x8d, 0xe1, 0xac, 0x84, 0xa1, 0x9f, 0xc2, 0x55,
	0xcb, 0x31, 0xcc, 0xd0, 0x7a, 0x42, 0x66, 0x61, 0x59, 0x06, 0x5b, 0x8d, 0xd5, 0x73, 0x38, 0xc7,
	0x0d, 0xad, 0x43, 0x8b, 0x0c, 0x67, 0x71, 0x39, 0x8e, 0x8b, 0xd5, 0xd3, 0xb8, 0x37, 0x61, 0x2d,
	0x08, 0x0d, 0x3f, 0x9c, 0x87, 0xe5, 0xf9, 0x2c, 0x85, 0x76, 0x1a, 0x75, 0x0f, 0x6a, 0x43, 0xf7,
	0xc8, 0xb1, 0x5d, 0x83, 0xf9, 0xc7, 0x56, 0x85, 0x04, 0xb3, 0x0c, 0xbc, 0x44, 0xdf, 0x4c, 0x59,
	0xf6, 0xb8, 0xe1, 0x34, 0x99, 0x02, 0x37, 0x0d, 0xcf, 0xb3, 0x27, 0x67, 0x30, 0x2d, 0x32, 0xa6,
	0xe7, 0x63, 0xb3, 0x13, 0x69, 0xee, 0x40, 0xd5, 0x27, 0x07, 0xae, 0x1b, 0x9e, 0xb0, 0xe2, 0x4b,
	0x0c, 0xbf, 0x96, 0xe8, 0xe7, 0x90, 0x41, 0x64, 0x9a, 0x84, 0x0c, 0xe7, 0x57, 0xa1, 0xc0, 0x91,
	0x89, 0x7e, 0x1a, 0xb9, 0x0f, 0x9b, 0xc7, 0x48, 0xce, 0xae, 0xfb, 0xe4, 0x93, 0xc8, 0xf2, 0xe7,
	0x99, 0x8a, 0x8c, 0xe9, 0xa5, 0xc4, 0x1e, 0x33, 0x73, 0x2c, 0xac, 0xa7, 0x79, 0xb7, 0x60, 0x95,
	0xb6, 0xbf, 0x79, 0x12, 0x60, 0x24, 0x97, 0xb9, 0x72, 0x1a, 0xf3, 0x3a, 0x5c, 0x31, 0xcc, 0xc7,
	0xf3, 0x90, 0x12, 0x83, 0x20, 0xa6, 0x9b, 0x46, 0xbc, 0x05, 0x55, 0x5a, 0x45, 0x87, 0xba, 0x1b,
	0x85, 0xb3, 0xa8, 0x32, 0x0f, 0x1a, 0xa6, 0xef, 0x46, 0xe1, 0x34, 0xf0, 0x3d, 0x78, 0xc1, 0xf3,
	0x09, 0xdf, 0x2c, 0x3d, 0x08, 0x89, 0x37, 0x8b, 0x5e, 0x66, 0xe8, 0x6b, 0x9e, 0x4f, 0x44, 0xc3,
	0x27, 0xde, 0x34, 0xc3, 0x0e, 0xdc, 0xf0, 0xdc, 0x20, 0x3c, 0x83, 0xa2, 0xc2, 0x28, 0xd6, 0xa9,
	0xd5, 0x29, 0x1c, 0xbb, 0xb0, 0xe1, 0xb8, 0xba, 0x31, 0xa2, 0x35, 0x60, 0x48, 0x42, 0x62, 0x9e,
	0x10, 0xc4, 0x2b, 0x3c, 0x70, 0x1c, 0x57, 0xa6, 0x66, 0x2d, 0x61, 0x35, 0xc5, 0x53, 0xfb, 0x6d,
	0x06, 0x16, 0x58, 0x9d, 0x47, 0xab, 0x70, 0xa9, 0xaf, 0xc9, 0x9a, 0xa2, 0x0f, 0x3a, 0xfd, 0x9e,
	0xd2, 0x54, 0x77, 0x55, 0xa5, 0x25, 0x3d, 0x87, 0x4a, 0xb0, 0xd4, 0xd7, 0x64, 0xac, 0x29, 0x2d,
	0x29, 0x83, 0x2e, 0xc3, 0x8a, 0xda, 0xe9, 0x6b, 0x72, 0xa7, 0xa9, 0xe8, 0xed, 0x6e, 0xf7, 0xde,
	0xa0, 0x27, 0x65, 0x51, 0x19, 0x0a, 0x3d, 0x59, 0x6b, 0xde, 0x55, 0x3b, 0x7b, 0x52, 0x0e, 0x2d,
	0x43, 0xb1, 0x3f, 0x68, 0x36, 0x15, 0xa5, 0xa5, 0xb4, 0xa4, 0x3c, 0xba, 0x06, 0xab, 0xcd, 0xee,
	0xfb, 0xbd, 0xb6, 0xa2, 0x29, 0x2d, 0xfd, 0xbe, 0xaa, 0xdd, 0xd5, 0x15, 0x8c, 0xbb, 0xb8, 0x2f,
	0x2d, 0x50, 0x5c, 0x93, 0x32, 0xb5, 0x95, 0x96, 0xb4, 0x48, 0x71, 0x9a, 0xfa, 0xbe, 0xd2, 0xd2,
	0xbb, 0x03, 0x4d, 0x5a, 0xda, 0xee, 0x7e, 0x25, 0xb7, 0xcf, 0x3f, 0x25, 0xa3, 0x4d, 0x8f, 0x9f,
	0x4f, 0x82, 0xc6, 0xa7, 0xe2, 0xd7, 0x67, 0x8d, 0xa4, 0xf7, 0x37, 0x3e, 0x4d, 0x0e, 0x0f, 0x9f,
	0xd5, 0xfe, 0x97, 0x87, 0x52, 0xaa, 0x75, 0xa0, 0xfb, 0xb0, 0x2c, 0x62, 0x56, 0x34, 0x9e, 0x0c,
	0xeb, 0x8b, 0x5b, 0x17, 0x6a, 0x3c, 0x75, 0x1e, 0xbf, 0xa2, 0x0b, 0x95, 0xfd, 0xd4, 0x08, 0xbd,
	0x05, 0x39, 0xc3, 0x0b, 0x45, 0x6b, 0x3f, 0xa3, 0x8f, 0xc9, 0x5e, 0xd8, 0x27, 0x21, 0x4d, 0xc8,
	0x00, 0x53, 0x04, 0x05, 0x4e, 0xa2, 0xf1, 0xf9, 0x57, 0xab, 0x07, 0xd1, 0xf8, 0x18, 0x38, 0x89,
	0xc6, 0x14, 0x38, 0x72, 0x5d, 0x71, 0x9b, 0x3a, 0x03, 0xb8, 0xe7, 0xba, 0xc7, 0xc0, 0x91, 0xeb,
	0xd2, 0xdb, 0xc9, 0xb3, 0x89, 0xe7, 0x11, 0x9f, 0xd5, 0x98, 0xd2, 0x59, 0x87, 0x82, 0x0f, 0x99,
	0x5d, 0x02, 0x17, 0x38, 0xb4, 0x0f, 0x95, 0x23, 0xcb, 0x19, 0xba, 0x47, 0x81, 0xce, 0xcf, 0x1a,
	0xa2, 0x7f, 0x37, 0x4e, 0x67, 0xba, 0xcf, 0xed, 0x07, 0xcc, 0x3c, 0x21, 0x5c, 0x3e, 0x4a, 0x8b,
	0xd1, 0xcf, 0xa1, 0x40, 0x93, 0x8c, 0xe6, 0x86, 0xe8, 0xe5, 0x67, 0x1c, 0xfb, 0xe8, 0xfd, 0x9b,
	0x66, 0x08, 0x5e, 0xf2, 0x7c, 0x42, 0x7f, 0xa0, 0x5f, 0x40, 0x91, 0x65, 0x18, 0xc3, 0x17, 0x2f,
	0x8c, 0x2f, 0x50, 0x10, 0xfd, 0x55, 0xfb, 0x00, 0xca, 0xe9, 0x2d, 0x46, 0x2f, 0xc0, 0x35, 0xac,
	0xec, 0x74, 0xbb, 0x9a, 0xde, 0xec, 0x76, 0x76, 0xd5, 0xbd, 0xf9, 0x24, 0x69, 0x29, 0xbb, 0xf2,
	0xa0, 0xad, 0x49, 0x19, 0x04, 0xb0, 0x28, 0xb7, 0xef, 0xcb, 0x0f, 0xfa, 0x52, 0x16, 0x15, 0x61,
	0xa1, 0xa3, 0xec, 0x2b, 0x58, 0xca, 0xd5, 0xfe, 0x95, 0x85, 0x42, 0x9c, 0x7b, 0xb5, 0x2f, 0xb2,
	0x00, 0xc7, 0xd7, 0x01, 0x74, 0x1d, 0xae, 0xb2, 0x14, 0xd2, 0x4f, 0xc9, 0xc0, 0x9e, 0xd2, 0x69,
	0xd1, 0xf4, 0xca, 0xd0, 0xa4, 0x51, 0x3b, 0x72, 0x53, 0x53, 0xf7, 0x15, 0x9e, 0x7a, 0x9d, 0xae,
	0xc6, 0x0d, 0x73, 0xe9, 0x54, 0xcd, 0xa3, 0xab, 0x70, 0xb9, 0xd5, 0xbd, 0xdf, 0x69, 0x77, 0x65,
	0x8a, 0xd4, 0x19, 0xbd, 0x42, 0xd3, 0xee, 0x0a, 0x48, 0x72, 0xaf, 0xd7, 0x7e, 0x90, 0x96, 0xb2,
	0xf4, 0xe3, 0x0e, 0xd2, 0xcf, 0x2c, 0x4d, 0x67, 0x71, 0x81, 0xba, 0x9f, 0x0c, 0x75, 0xb1, 0x10,
	0x58, 0xf9, 0x60, 0xa0, 0x62, 0xa5, 0x25, 0x15, 0xa9, 0xc7, 0xbb, 0xb2, 0x4a, 0xf3, 0x18, 0xa8,
	0xc7, 0x72, 0xf3, 0x9e, 0xd2, 0x92, 0x4a, 0xd3, 0x29, 0x5d, 0x46, 0xeb, 0xb0, 0x86, 0x07, 0x9d,
	0x0e, 0xfb, 0x2e, 0x56, 0xf4, 0xd8, 0x61, 0xa5, 0x27, 0x2d, 0xd3, 0x05, 0x48, 0x74, 0xdd, 0xbe,
	0x96, 0x56, 0x56, 0x68, 0x65, 0xea, 0x74, 0x75, 0x79, 0x4f, 0xe9, 0x68, 0x7a, 0x4b, 0xd1, 0x94,
	0x26, 0xf5, 0x70, 0xa5, 0x36, 0x80, 0xd5, 0x26, 0x5d, 0x4c, 0xfb, 0xbb, 0xbd, 0xd9, 0xff, 0x33,
	0x03, 0xa5, 0x54, 0x6e, 0xa2, 0x77, 0x21, 0x1f, 0x4e, 0x3c, 0x22, 0xea, 0xc3, 0x8f, 0x2e, 0x94,
	0xd0, 0x75, 0x6d, 0xe2, 0x11, 0xcc, 0x70, 0x68, 0x1d, 0x0a, 0xe4, 0xa9, 0x69, 0x47, 0x43, 0x12,
	0x54, 0xb3, 0x1b, 0xb9, 0xcd, 0x22, 0x4e, 0xc6, 0xe8, 0x35, 0x40, 0xec, 0x77, 0x40, 0x4f, 0x3c,
	0x9e, 0x61, 0x3e, 0x36, 0x46, 0x24, 0xa8, 0xe6, 0x98, 0xd5, 0xa5, 0x44, 0xd3, 0x13, 0x8a, 0xda,
	0x1b, 0x90, 0xa7, 0xc4, 0x74, 0x0b, 0xb5, 0x07, 0xbd, 0xd9, 0x38, 0x29, 0x40, 0xbe, 0xa5, 0xf6,
	0x69, 0x04, 0x96, 0x60, 0x69, 0xd0, 0xdb, 0xc3, 0x72, 0x4b, 0x91, 0xb2, 0xb5, 0x5f, 0x67, 0xa0,
	0x94, 0x2a, 0x19, 0x74, 0x3e, 0x01, 0x31, 0x23, 0xdf, 0x0a, 0x27, 0xcc, 0xa7, 0x02, 0x4e, 0xc6,
	0xa8, 0x0a, 0x4b, 0x63, 0xcb, 0xb1, 0xc6, 0x86, 0xcd, 0x0e, 0x5c, 0x05, 0x1c, 0x0f, 0xa7, 0xbc,
	0xc8, 0x5d, 0xc8, 0x8b, 0xfc, 0x69, 0x5e, 0x2c, 0x43, 0x29, 0x55, 0x89, 0x6a, 0xff, 0xcd, 0x40,
	0x65, 0xba, 0xba, 0xd0, 0x43, 0xf0, 0x91, 0x15, 0x3e, 0xd2, 0x5d, 0x76, 0x69, 0x32, 0x6c, 0x31,
	0xcf, 0x32, 0x15, 0x76, 0x85, 0x0c, 0xdd, 0x84, 0x12, 0x33, 0x12, 0x75, 0x87, 0xcf, 0x17, 0xa8,
	0x48, 0xd4, 0x90, 0x1b, 0x00, 0xa6, 0x11, 0x92, 0x91, 0xeb, 0x5b, 0xc9, 0xa4, 0x53, 0x12, 0xaa,
	0x0f, 0xc8, 0x13, 0xe2, 0x5b, 0xa1, 0x95, 0x4c, 0x37, 0x25, 0x99, 0x72, 0x79, 0x61, 0xc6, 0xe5,
	0x57, 0xe1, 0x52, 0xda, 0x65, 0x76, 0x22, 0xab, 0x2e, 0x32, 0x23, 0x29, 0xe5, 0x31, 0x93, 0xd7,
	0x3e, 0xcf, 0xc1, 0xea, 0x89, 0x55, 0x0f, 0x3d, 0x82, 0x15, 0xd3, 0x36, 0x82, 0xc0, 0x3a, 0xb4,
	0x4c, 0x76, 0x1b, 0xe1, 0x97, 0xdc, 0xca, 0xd6, 0xbb, 0xdf, 0xb0, 0x7e, 0xd6, 0x9b, 0x53, 0x34,
	0x78, 0x96, 0xf6, 0xcc, 0x28, 0x3c, 0xd1, 0x99, 0xdc, 0x29, 0xce, 0xfc, 0x29, 0x03, 0x95, 0xe9,
	0x8f, 0xa1, 0x1b, 0xb0, 0xde, 0x6c, 0xcb, 0xfd, 0xbe, 0xba, 0xab, 0x36, 0x65, 0x4d, 0xed, 0x76,
	0x66, 0x02, 0x93, 0x36, 0x7a, 0xac, 0x6a, 0x6a, 0x53, 0x6e, 0xf3, 0x0a, 0xd6, 0x57, 0x9a, 0x03,
	0xac, 0x6a, 0x0f, 0xa4, 0x2c, 0xaa, 0x00, 0xb4, 0x94, 0x5d, 0xb5, 0xa3, 0x52, 0x9c, 0x94, 0xa3,
	0xa5, 0xa4, 0x85, 0x55, 0x5a, 0x31, 0xf3, 0x48, 0x82, 0xf2, 0xae, 0x22, 0x6b, 0x03, 0x56, 0x2c,
	0x9a, 0xf7, 0xa4, 0x05, 0x2a, 0xe9, 0x2b, 0x78, 0x5f, 0x6d, 0x0a, 0xc9, 0x22, 0x0d, 0x7a, 0xad,
	0xdb, 0x6d, 0x4b, 0x4b, 0xe8, 0x12, 0x2c, 0x0f, 0x7a, 0x2d, 0x5a, 0x3e, 0x71, 0xb7, 0xdd, 0x1e,
	0xf4, 0xa4, 0x02, 0x25, 0xe3, 0x22, 0xa9, 0x58, 0xfb, 0x47, 0x06, 0x0a, 0x71, 0xa1, 0x47, 0xbf,
	0x82, 0x35, 0xdb, 0x72, 0xa2, 0xa7, 0x3a, 0x79, 0x4a, 0x4c, 0x7e, 0x02, 0x4b, 0x9d, 0x02, 0xce,
	0x6c, 0x84, 0x31, 0x87, 0xe8, 0xfd, 0x97, 0x19, 0xcf, 0xb4, 0x10, 0x19, 0x50, 0x8d, 0xbb, 0xe2,
	0xdc, 0x07, 0xb2, 0xdf, 0xf0, 0x03, 0xab, 0x82, 0x69, 0x5a, 0x5c, 0xfb, 0x77, 0x16, 0x2a, 0x33,
	0x5f, 0xbd, 0x09, 0x60, 0xbb, 0xa6, 0x61, 0xd3, 0x2d, 0x7c, 0xc4, 0x8b, 0xdf, 0xdd, 0xe7, 0x70,
	0x91, 0xc9, 0x7a, 0x46, 0xf8, 0x08, 0xb5, 0x00, 0x46, 0x66, 0xa0, 0xbb, 0x07, 0xf4, 0x9c, 0x24,
	0x26, 0x72, 0xeb, 0x8c, 0xe3, 0x82, 0x19, 0x74, 0x99, 0x29, 0x65, 0x19, 0xc5, 0x03, 0x7a, 0x3c,
	0x37, 0x6c, 0xdb, 0x3d, 0x22, 0x43, 0x9d, 0x1d, 0xe7, 0x83, 0x40, 0x37, 0xdd, 0xb8, 0x2c, 0x2c,
	0xe0, 0xcb, 0x42, 0xd9, 0xe7, 0xba, 0x26, 0x55, 0xa1, 0x7d, 0x28, 0x59, 0x4e, 0x48, 0x7c, 0xcf,
	0x27, 0xf1, 0xf3, 0x4f, 0x65, 0xeb, 0xcd, 0x8b, 0xae, 0x41, 0x5d, 0x3d, 0xc6, 0xe2, 0x34, 0x51,
	0x4d, 0x81, 0x52, 0x4a, 0x47, 0xbb, 0x88, 0xda, 0xd1, 0x14, 0xdc, 0xc3, 0x8a, 0xa6, 0xe0, 0x99,
	0x28, 0x2c, 0xc2, 0x42, 0xff, 0xae, 0xd2, 0xa6, 0x21, 0x58, 0x01, 0xe8, 0x75, 0xef, 0x2b, 0x98,
	0x8f, 0xb3, 0x3b, 0x65, 0x00, 0xc2, 0xde, 0xf0, 0x8d, 0x03, 0x9b, 0xd4, 0x8e, 0xa0, 0x98, 0xb8,
	0x8e, 0xae, 0xc3, 0xe2, 0x41, 0x64, 0x3e, 0x26, 0xf1, 0xe3, 0x19, 0x7b, 0x1d, 0x17, 0x22, 0xaa,
	0x4c, 0x2d, 0x66, 0xac, 0xe4, 0x22, 0xf4, 0x3a, 0x5c, 0x1a, 0x11, 0x87, 0xf0, 0x57, 0x06, 0xdd,
	0x89, 0xc6, 0x07, 0xc4, 0xe7, 0xd7, 0x51, 0x6e, 0x27, 0x1d, 0x6b, 0x3b, 0x4c, 0x59, 0xfb, 0x5d,
	0x0e, 0x2e, 0x9f, 0xf0, 0x64, 0x82, 0x24, 0xc8, 0x19, 0x76, 0x5c, 0x04, 0xe9, 0x4f, 0xf4, 0x11,
	0x94, 0x47, 0xbe, 0x1b, 0x79, 0xba, 0x6d, 0x1c, 0x10, 0x9b, 0x67, 0x74, 0x69, 0xeb, 0xce, 0x37,
	0x7a, 0x89, 0xa9, 0xef, 0x51, 0x86, 0x36, 0x25, 0xc0, 0xa5, 0x51, 0xf2, 0x3b, 0x40, 0x57, 0x60,
	0xe1, 0x99, 0xeb, 0x24, 0x25, 0x80, 0x0f, 0xd0, 0xf3, 0x50, 0x8c, 0xaf, 0x17, 0x71, 0xb1, 0x3c,
	0x16, 0xd0, 0x9b, 0x74, 0x72, 0xf9, 0xa0, 0x5d, 0x54, 0xf7, 0x7c, 0x72, 0x68, 0x3d, 0x4d, 0x2a,
	0xe7, 0x95, 0x58, 0xdb, 0x31, 0xc6, 0xa4, 0x27, 0x74, 0xeb, 0x7f, 0xc8, 0x00, 0x1c, 0xcf, 0x02,
	0x3d, 0x84, 0x45, 0xe1, 0x0f, 0x7f, 0xe9, 0x6b, 0x7d, 0x5b, 0x7f, 0xea, 0xdc, 0x13, 0xc5, 0x09,
	0xfd, 0x09, 0x16, 0x9c, 0xeb, 0x6f, 0x43, 0x29, 0x25, 0xa6, 0x8b, 0xfa, 0x98, 0x4c, 0xc4, 0x0b,
	0x1f, 0xfd, 0x49, 0xfd, 0x7e, 0x62, 0xd8, 0x11, 0x11, 0xef, 0x76, 0x7c, 0xb0, 0x9d, 0xbd, 0x93,
	0xd9, 0xf9, 0x5b, 0x06, 0x9e, 0x37, 0xdd, 0xf1, 0xa9, 0xd3, 0xd9, 0x29, 0x26, 0x4f, 0x97, 0x1f,
	0xbe, 0x27, 0x8c, 0x46, 0xae, 0x6d, 0x38, 0xa3, 0xba, 0xeb, 0x8f, 0x1a, 0x23, 0xe2, 0xb0, 0x07,
	0xa8, 0xc6, 0xf1, 0xc1, 0x63, 0xfe, 0x1f, 0xaf, 0x77, 0xe2, 0xdf, 0x7f, 0xcc, 0x56, 0xf7, 0x38,
	0x45, 0x93, 0x7d, 0xa7, 0x1b, 0x88, 0x2c, 0xd8, 0xbf, 0xfd, 0xf7, 0x58, 0xf5, 0x90, 0xa9, 0x1e,
	0xc6, 0xaa, 0x87, 0xfb, 0xb7, 0xbf, 0xca, 0x5e, 0xe7, 0xaa, 0xed, 0x6d, 0xa6, 0xdb, 0xde, 0x8e,
	0x95, 0xdb, 0xdb, 0xfb, 0xb7, 0x0f, 0x16, 0xd9, 0x04, 0xde, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x23, 0x20, 0x7e, 0xa1, 0x71, 0x1b, 0x00, 0x00,
}
