/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.controls.pccbase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.ControlsMode;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestAccessResult;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AntPlusBaseRemoteControlPcc
extends AntPlusCommonPcc {
    private static final String TAG = AntPlusBaseRemoteControlPcc.class.getSimpleName();
    IControlDeviceAvailabilityReceiver mControlDeviceAvailabilityReceiver;

    protected static <T extends AntPlusBaseRemoteControlPcc> RemoteControlAsyncScanController<T> requestAccessRemoteControl_Helper(EnumSet<ControlsMode> requestModes, Context bindingContext, int searchProximityThreshold, T retPccObject, IRemoteControlAsyncScanResultReceiver scanResultReceiver) {
        RemoteControlAsyncScanController<T> scanner = new RemoteControlAsyncScanController<T>(scanResultReceiver, retPccObject);
        Bundle b = new Bundle();
        b.putLong("long_ControlsModes", ControlsMode.getLongFromControlsModes(requestModes));
        AntPlusBaseRemoteControlPcc.requestAsyncScan_Helper_SubMain(bindingContext, searchProximityThreshold, b, retPccObject, scanner);
        return scanner;
    }

    protected static <T extends AntPlusBaseRemoteControlPcc> PccReleaseHandle<T> requestAccessRemoteControl_Helper(EnumSet<ControlsMode> requestModes, Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<T> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, T potentialRetObj) {
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", 3);
        b.putInt("int_AntDeviceID", antDeviceNumber);
        b.putInt("int_ProximityBin", searchProximityThreshold);
        b.putLong("long_ControlsModes", ControlsMode.getLongFromControlsModes(requestModes));
        return AntPlusBaseRemoteControlPcc.requestAccess_Helper_Main(bindToContext, b, potentialRetObj, new RequestAccessResultHandlerAsyncSearchRemoteControl(), resultReceiver, stateReceiver);
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.controls.RemoteControlService"));
        return it;
    }

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 30001;
    }

    public void subscribeControlDeviceAvailabilityEvent(IControlDeviceAvailabilityReceiver ControlDeviceAvailabilityReceiver) {
        this.mControlDeviceAvailabilityReceiver = ControlDeviceAvailabilityReceiver;
        if (ControlDeviceAvailabilityReceiver != null) {
            this.subscribeToEvent(233);
        } else {
            this.unsubscribeFromEvent(233);
        }
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 233: {
                if (this.mControlDeviceAvailabilityReceiver == null) break;
                Bundle b = eventMsg.getData();
                b.setClassLoader(this.getClass().getClassLoader());
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                ControlDeviceCapabilities controlDeviceAvailabilities = (ControlDeviceCapabilities)b.getParcelable("parcelable_ControlDeviceAvailabilities");
                this.mControlDeviceAvailabilityReceiver.onNewControlDeviceAvailability(estTimestamp, eventFlags, controlDeviceAvailabilities);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestAccessResultHandlerAsyncSearchRemoteControl<T extends AntPlusBaseRemoteControlPcc>
    extends AntPluginPcc.RequestAccessResultHandler_AsyncSearchByDevNumber<T> {
        private RequestAccessResultHandlerAsyncSearchRemoteControl() {
        }

        @Override
        public boolean handleRequestAccessResult(Message msg) {
            return super.handleRequestAccessResult(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoteControlAsyncScanController<T extends AntPlusBaseRemoteControlPcc>
    extends AsyncScanController<T> {
        IRemoteControlAsyncScanResultReceiver remoteResultReceiver;

        public RemoteControlAsyncScanController(IRemoteControlAsyncScanResultReceiver remoteResultReceiver, T pccObject) {
            super(pccObject);
            this.remoteResultReceiver = remoteResultReceiver;
        }

        @Override
        protected void sendFailureToReceiver(RequestAccessResult requestAccessResult) {
            this.remoteResultReceiver.onSearchStopped(requestAccessResult);
        }

        @Override
        protected void sendResultToReceiver(Bundle result) {
            AsyncScanController.AsyncScanResultDeviceInfo newResult = (AsyncScanController.AsyncScanResultDeviceInfo)result.getParcelable("parcelable_AsyncScanResultDeviceInfo");
            ControlDeviceCapabilities capabilities = (ControlDeviceCapabilities)result.getParcelable("parcelable_ControlDeviceAvailabilities");
            this.remoteResultReceiver.onSearchResult(new RemoteControlAsyncScanResultDeviceInfo(newResult, capabilities));
        }
    }

    public static interface IRemoteControlAsyncScanResultReceiver {
        public void onSearchStopped(RequestAccessResult var1);

        public void onSearchResult(RemoteControlAsyncScanResultDeviceInfo var1);
    }

    public static class RemoteControlAsyncScanResultDeviceInfo {
        public static final String MSG_BIKESPDCAD_ASYNCSCANRESULTINFO_controlDeviceCapabilities = "controlDeviceCapabilities_Capabilities";
        public final AsyncScanController.AsyncScanResultDeviceInfo resultInfo;
        public final ControlDeviceCapabilities capabilities;

        public RemoteControlAsyncScanResultDeviceInfo(AsyncScanController.AsyncScanResultDeviceInfo resultInfo, ControlDeviceCapabilities capabilities) {
            this.resultInfo = resultInfo;
            this.capabilities = capabilities;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IControlDeviceAvailabilityReceiver {
        public void onNewControlDeviceAvailability(long var1, EnumSet<EventFlag> var3, ControlDeviceCapabilities var4);
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_CONTROLSPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String MSG_REQACC_PARAM_MODE_longCONTROLSMODES = "long_ControlsModes";
        public static final String PATH_ANTPLUS_REMOTECONTROLPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.controls.RemoteControlService";
        public static final int MSG_EVENT_REMOTECONTROL_whatCONTROLDEVICEAVAILABILITY = 233;
    }

    public static class ControlDeviceCapabilities
    implements Parcelable {
        private final int ipcVersionNumber;
        public static final String KEY_DEFAULT_CONTROLDEVICEAVAILABILITIESKEY = "parcelable_ControlDeviceAvailabilities";
        private boolean isMaximumNumberRemotesConnected;
        private boolean isAudioControlSupported;
        private boolean isGenericControlSupported;
        private boolean isVideoControlSupported;
        private boolean isBurstCommandSupported;
        public static final Parcelable.Creator<ControlDeviceCapabilities> CREATOR = new Parcelable.Creator<ControlDeviceCapabilities>(){

            public ControlDeviceCapabilities createFromParcel(Parcel in) {
                return new ControlDeviceCapabilities(in);
            }

            public ControlDeviceCapabilities[] newArray(int size) {
                return new ControlDeviceCapabilities[size];
            }
        };

        public ControlDeviceCapabilities() {
            this.ipcVersionNumber = 1;
            this.isMaximumNumberRemotesConnected = false;
            this.isAudioControlSupported = false;
            this.isGenericControlSupported = false;
            this.isVideoControlSupported = false;
            this.isBurstCommandSupported = false;
        }

        public ControlDeviceCapabilities(boolean isMaximumNumberRemotesConnected, boolean isAudioControlSupported, boolean isGenericControlSupported, boolean isVideoControlSupported, boolean isBurstCommandSupported) {
            this.ipcVersionNumber = 1;
            this.isMaximumNumberRemotesConnected = isMaximumNumberRemotesConnected;
            this.isAudioControlSupported = isAudioControlSupported;
            this.isGenericControlSupported = isGenericControlSupported;
            this.isVideoControlSupported = isVideoControlSupported;
            this.isBurstCommandSupported = isBurstCommandSupported;
        }

        public ControlDeviceCapabilities(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " CrankParameters parcel with version 1 parser.");
            }
            this.isMaximumNumberRemotesConnected = in.readByte() != 0;
            this.isAudioControlSupported = in.readByte() != 0;
            this.isGenericControlSupported = in.readByte() != 0;
            this.isVideoControlSupported = in.readByte() != 0;
            this.isBurstCommandSupported = in.readByte() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.ipcVersionNumber);
            out.writeByte((byte)(this.isMaximumNumberRemotesConnected ? 1 : 0));
            out.writeByte((byte)(this.isAudioControlSupported ? 1 : 0));
            out.writeByte((byte)(this.isGenericControlSupported ? 1 : 0));
            out.writeByte((byte)(this.isVideoControlSupported ? 1 : 0));
            out.writeByte((byte)(this.isBurstCommandSupported ? 1 : 0));
        }

        public int describeContents() {
            return 0;
        }

        public boolean getMaximumNumberRemotesConnected() {
            return this.isMaximumNumberRemotesConnected;
        }

        public boolean getAudioControlSupported() {
            return this.isAudioControlSupported;
        }

        public boolean getGenericControlSupported() {
            return this.isGenericControlSupported;
        }

        public boolean getVideoControlSupported() {
            return this.isVideoControlSupported;
        }

        public boolean getBurstCommandSupported() {
            return this.isBurstCommandSupported;
        }

        public void setMaximumNumberRemotesConnected(boolean isMaximumNumberRemotesConnected) {
            this.isMaximumNumberRemotesConnected = isMaximumNumberRemotesConnected;
        }

        public void setAudioControlSupported(boolean isAudioControlSupported) {
            this.isAudioControlSupported = isAudioControlSupported;
        }

        public void setGenericControlSupported(boolean isGenericControlSupported) {
            this.isGenericControlSupported = isGenericControlSupported;
        }

        public void setVideoControlSupported(boolean isVideoControlSupported) {
            this.isVideoControlSupported = isVideoControlSupported;
        }

        public void setBurstCommandSupported(boolean isBurstCommandSupported) {
            this.isBurstCommandSupported = isBurstCommandSupported;
        }
    }
}

