/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pccbase;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import com.dsi.ant.plugins.antplus.pcc.defines.DeviceState;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestAccessResult;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.internal.pluginsipc.AntPluginDeviceDbProvider;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Exchanger;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AntPluginPcc {
    private static final String TAG = AntPluginPcc.class.getSimpleName();
    public static final String PATH_ANTPLUS_PLUGINS_PKG = "com.dsi.ant.plugins.antplus";
    static volatile String lastMissingDependencyPkgName = "";
    static volatile String lastMissingDependencyName = "";
    ServiceConnection serviceBindConn;
    HandlerThread mPluginMsgHandlerThread = new HandlerThread("PluginPCCMsgHandler");
    Handler.Callback mPluginMsgHandler = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            LogAnt.v(TAG, "Plugin Msg Handler received: " + msg.what + ", " + msg.arg1);
            if (AntPluginPcc.this.mPluginCommLock.tryLock()) {
                try {
                    AntPluginPcc.this.handleNonCmdPluginMessage(msg);
                }
                finally {
                    AntPluginPcc.this.mPluginCommLock.unlock();
                }
            }
            try {
                AntPluginPcc.this.mPluginCommMsgExch.exchange(msg);
                AntPluginPcc.this.mPluginCommProcessingBarrier.await();
            }
            catch (BrokenBarrierException e) {
                AntPluginPcc.this.handleConnectionBroke("BrokenBarrierException in mPluginMsgHandler trying to fwd message " + msg.what);
                return true;
            }
            catch (InterruptedException e) {
                AntPluginPcc.this.handleConnectionBroke("InterruptedException in mPluginMsgHandler trying to fwd message " + msg.what);
                Thread.currentThread().interrupt();
                return true;
            }
            return true;
        }
    };
    HandlerThread mPluginEventHandlerThread = new HandlerThread("PluginPCCEventHandler");
    volatile Handler mPluginEventHandler;
    Handler.Callback mPluginEventHandlerCb = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            PccReleaseHandle<?> temp = AntPluginPcc.this.mReleaseHandle;
            if (temp == null) {
                return true;
            }
            try {
                AntPluginPcc.this.deviceInitializedLatch.await();
                Object object = temp.stateLock;
                synchronized (object) {
                    if (!temp.isActive()) {
                        return true;
                    }
                    switch (msg.what) {
                        case 1: {
                            AntPluginPcc.this.handlePluginEvent(msg);
                            break;
                        }
                        case 3: {
                            int newState = msg.arg1;
                            AntPluginPcc.this.mCachedState = newState;
                            LogAnt.v(TAG, "State event: " + newState);
                            if (newState == -100) {
                                AntPluginPcc.this.handleConnectionBroke("Device dead");
                                break;
                            }
                            AntPluginPcc.this.mStateChangeReceiver.onDeviceStateChange(DeviceState.getValueFromInt(newState));
                            break;
                        }
                        default: {
                            LogAnt.w(TAG, "Unrecognized plugin event received: " + msg.arg1);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                LogAnt.i(TAG, "Plugin event thread interrupted while waiting for initialization to complete.");
                Thread.currentThread().interrupt();
            }
            return true;
        }
    };
    UUID mAccessToken;
    Messenger mPluginMsgr;
    private final ReentrantLock mPluginCommLock = new ReentrantLock();
    Exchanger<Message> mPluginCommMsgExch = new Exchanger();
    CyclicBarrier mPluginCommProcessingBarrier = new CyclicBarrier(2);
    boolean isInitialized = false;
    CountDownLatch deviceInitializedLatch = new CountDownLatch(1);
    Context mOwnerContext;
    AntPluginDeviceDbProvider.DeviceDbDeviceInfo deviceInfo;
    Integer mCachedState = null;
    private Thread mCurrentCmdThread;
    protected int reportedServiceVersion;
    IDeviceStateChangeReceiver mStateChangeReceiver;
    volatile PccReleaseHandle<?> mReleaseHandle;
    private volatile boolean isReleased = false;
    private boolean mIsPluginServiceBound = false;
    private Object mPluginServiceBindChange_LOCK = new Object();

    protected abstract Intent getServiceBindIntent();

    protected abstract int getRequiredServiceVersionForBind();

    protected abstract void handlePluginEvent(Message var1);

    protected abstract String getPluginPrintableName();

    public static int getInstalledPluginsVersionNumber(Context currentContext) {
        PackageManager pm = currentContext.getPackageManager();
        List packages = pm.getInstalledPackages(0);
        for (PackageInfo packageInfo : packages) {
            if (!packageInfo.packageName.equals(PATH_ANTPLUS_PLUGINS_PKG)) continue;
            if (!packageInfo.applicationInfo.enabled) {
                return -2;
            }
            return packageInfo.versionCode;
        }
        return -1;
    }

    public static String getInstalledPluginsVersionString(Context currentContext) {
        PackageManager pm = currentContext.getPackageManager();
        List packages = pm.getInstalledPackages(0);
        for (PackageInfo packageInfo : packages) {
            if (!packageInfo.packageName.equals(PATH_ANTPLUS_PLUGINS_PKG)) continue;
            return packageInfo.versionName;
        }
        return null;
    }

    public static boolean startPluginManagerActivity(Activity activity) {
        if (AntPluginPcc.getInstalledPluginsVersionNumber((Context)activity) > 0) {
            Intent it = new Intent();
            it.setClassName(PATH_ANTPLUS_PLUGINS_PKG, "com.dsi.ant.plugins.antplus.utility.db.Activity_PluginMgrDashboard");
            activity.startActivity(it);
            return true;
        }
        return false;
    }

    public static String getMissingDependencyPackageName() {
        return lastMissingDependencyPkgName;
    }

    public static String getMissingDependencyName() {
        return lastMissingDependencyName;
    }

    protected static <T extends AntPluginPcc> PccReleaseHandle<T> requestAccess_Helper_SearchActivity(Activity foregroundActivity, Context bindingContext, boolean skipPreferredSearch, int searchProximityThreshold, T retPccObject, IPluginAccessResultReceiver<T> resultReceiver, IDeviceStateChangeReceiver stateReceiver) {
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", 1);
        b.putBoolean("b_ForceManualSelect", skipPreferredSearch);
        b.putInt("int_ProximityBin", searchProximityThreshold);
        return AntPluginPcc.requestAccess_Helper_Main(bindingContext, b, retPccObject, new RequestAccessResultHandler_UI(foregroundActivity), resultReceiver, stateReceiver);
    }

    protected static <T extends AntPluginPcc> PccReleaseHandle<T> requestAccess_Helper_AsyncSearchByDevNumber(Context bindingContext, int antDeviceNumber, int searchProximityThreshold, T retPccObject, IPluginAccessResultReceiver<T> resultReceiver, IDeviceStateChangeReceiver stateReceiver) {
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", 3);
        b.putInt("int_AntDeviceID", antDeviceNumber);
        b.putInt("int_ProximityBin", searchProximityThreshold);
        return AntPluginPcc.requestAccess_Helper_Main(bindingContext, b, retPccObject, new RequestAccessResultHandler_AsyncSearchByDevNumber(), resultReceiver, stateReceiver);
    }

    protected static <T extends AntPluginPcc> AsyncScanController<T> requestAccess_Helper_AsyncScanController(Context bindingContext, int searchProximityThreshold, T retPccObject, AsyncScanController.IAsyncScanResultReceiver scanResultReceiver) {
        AsyncScanController<T> controller = new AsyncScanController<T>(scanResultReceiver, retPccObject);
        return AntPluginPcc.requestAsyncScan_Helper_SubMain(bindingContext, searchProximityThreshold, new Bundle(), retPccObject, controller);
    }

    <T extends AntPluginPcc> void connectToAsyncResult(AsyncScanController.AsyncScanResultDeviceInfo deviceToConnectTo, Messenger resultMessenger, IDeviceStateChangeReceiver stateReceiver) {
        this.mStateChangeReceiver = stateReceiver;
        Bundle connectData = new Bundle();
        connectData.putParcelable("parcelable_AsyncScanResultDeviceInfo", (Parcelable)deviceToConnectTo);
        connectData.putParcelable("msgr_ReqAccResultReceiver", (Parcelable)resultMessenger);
        Message ret = this.sendPluginCommand(10100, connectData);
        if (ret == null) {
            LogAnt.e(TAG, "connectToAsyncResult died in sendPluginCommand()");
            Message failMsg = Message.obtain();
            failMsg.what = -4;
            try {
                resultMessenger.send(failMsg);
            }
            catch (RemoteException e1) {
                this.handleConnectionBroke("Remote exception sending async connect failure msg to client");
            }
        } else {
            if (ret.arg1 != 0) {
                throw new RuntimeException("Request to connectToAsync Result cmd failed with code " + ret.arg1);
            }
            ret.recycle();
        }
    }

    protected static <T extends AntPluginPcc> PccReleaseHandle<T> requestAccess_Helper_Main(Context bindingContext, Bundle reqParams, T retPccObject, RequestAccessResultHandler<T> reqAccessResultHandler, IPluginAccessResultReceiver<T> resultReceiver, IDeviceStateChangeReceiver stateReceiver) {
        if (resultReceiver == null || stateReceiver == null) {
            throw new IllegalArgumentException("Invalid argument: " + (resultReceiver == null ? "resultReceiver " : "stateReceiver ") + " is null ");
        }
        T t = retPccObject;
        t.getClass();
        StandardReleaseHandle ret = t.new StandardReleaseHandle(resultReceiver, stateReceiver);
        retPccObject.mReleaseHandle = ret;
        retPccObject.mStateChangeReceiver = ret.stateSink;
        reqAccessResultHandler.setReturnInfo(retPccObject, ret.resultSink);
        AntPluginPcc.requestAccess_Helper_SubMain(bindingContext, reqParams, retPccObject, reqAccessResultHandler);
        return ret;
    }

    protected static <T extends AntPluginPcc> AsyncScanController<T> requestAsyncScan_Helper_SubMain(Context bindingContext, int searchProximityThreshold, Bundle reqParams, T retPccObject, AsyncScanController<T> controller) {
        if (AntPluginPcc.getInstalledPluginsVersionNumber(bindingContext) < 10800) {
            LogAnt.e(TAG, "Binding to plugin failed, version requirement not met for async scan controller mode");
            Intent it = retPccObject.getServiceBindIntent();
            lastMissingDependencyPkgName = it.getComponent().getPackageName();
            lastMissingDependencyName = retPccObject.getPluginPrintableName() + " minimum v.10800";
            controller.scanResultReceiver.onSearchStopped(RequestAccessResult.DEPENDENCY_NOT_INSTALLED);
            return null;
        }
        reqParams.putInt("int_RequestAccessMode", 2);
        reqParams.putInt("int_ProximityBin", searchProximityThreshold);
        AntPluginPcc.requestAccess_Helper_SubMain(bindingContext, reqParams, retPccObject, controller.getScanResultHandler());
        return controller;
    }

    protected static <T extends AntPluginPcc> void requestAccess_Helper_SubMain(Context bindingContext, Bundle reqParams, T retPccObject, Handler resultHandler) {
        if (resultHandler == null) {
            throw new IllegalArgumentException("resultHandler passed from client was null");
        }
        String appNamePkg = bindingContext.getPackageName();
        ApplicationInfo ai = bindingContext.getApplicationInfo();
        String appNameLabel = bindingContext.getPackageManager().getApplicationLabel(ai).toString();
        reqParams.putString("str_ApplicationNamePackage", appNamePkg);
        reqParams.putString("str_ApplicationNameTitle", appNameLabel);
        retPccObject.bindAndRequest(bindingContext, reqParams, resultHandler);
    }

    protected void bindAndRequest(Context bindingContext, final Bundle b, Handler resultHandler) {
        Messenger resultMsgr;
        this.mOwnerContext = bindingContext;
        Messenger commChannel = new Messenger(resultHandler);
        b.putParcelable("msgr_PluginMsgHandler", (Parcelable)this.getPluginMsgReceiver());
        b.putParcelable("msgr_ReqAccResultReceiver", (Parcelable)commChannel);
        LogAnt.setVersion("BBD30100");
        try {
            Context pluginContext = this.mOwnerContext.createPackageContext(PATH_ANTPLUS_PLUGINS_PKG, 4);
            LogAnt.getDebugLevel(pluginContext);
        }
        catch (PackageManager.NameNotFoundException e) {
            LogAnt.e(TAG, "Unable to configure logging, plugins package not found: " + (Object)((Object)e));
        }
        b.putInt("int_PluginLibVersion", 30100);
        b.putString("string_PluginLibVersion", "3.1.0");
        b.putInt("more", 0);
        Intent it = this.getServiceBindIntent();
        PackageInfo targetService = null;
        PackageManager pm = this.mOwnerContext.getPackageManager();
        List packages = pm.getInstalledPackages(0);
        for (PackageInfo packageInfo : packages) {
            if (!packageInfo.packageName.equals(it.getComponent().getPackageName())) continue;
            targetService = packageInfo;
            break;
        }
        if (targetService == null) {
            LogAnt.e(TAG, "Binding to plugin failed, not installed");
            resultMsgr = (Messenger)b.getParcelable("msgr_ReqAccResultReceiver");
            this.sendDependencyNotInstalledMessage(resultMsgr, it.getComponent().getPackageName(), "ANT+ Plugins Service");
            return;
        }
        if (targetService.versionCode < this.getRequiredServiceVersionForBind()) {
            LogAnt.e(TAG, "Binding to plugin failed, version requirement not met");
            resultMsgr = (Messenger)b.getParcelable("msgr_ReqAccResultReceiver");
            this.sendDependencyNotInstalledMessage(resultMsgr, it.getComponent().getPackageName(), "ANT+ Plugins Service minimum v." + this.getRequiredServiceVersionForBind());
            return;
        }
        this.serviceBindConn = new ServiceConnection(){

            public void onServiceConnected(ComponentName arg0, IBinder arg1) {
                Messenger reqMsgr = new Messenger(arg1);
                Message msg = Message.obtain();
                msg.what = 0;
                msg.setData(b);
                try {
                    reqMsgr.send(msg);
                }
                catch (RemoteException e) {
                    AntPluginPcc.this.notifyBindAndRequestFailed(b);
                }
            }

            public void onServiceDisconnected(ComponentName arg0) {
                if (!AntPluginPcc.this.isInitialized) {
                    AntPluginPcc.this.notifyBindAndRequestFailed(b);
                } else {
                    AntPluginPcc.this.handleConnectionBroke("OnServiceDisconnected fired");
                }
            }
        };
        this.bindPluginService(it, b);
    }

    private void sendDependencyNotInstalledMessage(Messenger resultMsgr, String dpndcyPkgName, String dpndcyDisplayName) {
        Message msgErr = Message.obtain();
        msgErr.what = -5;
        Bundle s = new Bundle();
        s.putString("string_DependencyPackageName", dpndcyPkgName);
        s.putString("string_DependencyName", dpndcyDisplayName);
        msgErr.setData(s);
        try {
            resultMsgr.send(msgErr);
        }
        catch (RemoteException e1) {
            this.handleConnectionBroke("Remote exception sending plugin 'dependency not installed' msg to client");
        }
    }

    private Messenger getPluginMsgReceiver() {
        this.mPluginEventHandlerThread.start();
        this.mPluginEventHandler = new Handler(this.mPluginEventHandlerThread.getLooper(), this.mPluginEventHandlerCb);
        this.mPluginMsgHandlerThread.start();
        return new Messenger(new Handler(this.mPluginMsgHandlerThread.getLooper(), this.mPluginMsgHandler));
    }

    protected void handleNonCmdPluginMessage(Message msg) {
        Handler h = this.mPluginEventHandler;
        if (h != null) {
            Message m = h.obtainMessage(msg.what, msg.arg1, msg.arg2, msg.obj);
            m.setData(msg.getData());
            m.replyTo = msg.replyTo;
            h.sendMessage(m);
        }
    }

    void init(AntPluginDeviceDbProvider.DeviceDbDeviceInfo devInfo, UUID accessToken, Messenger pluginMsgr, int initialDeviceState, int reportedServiceVersion) {
        this.deviceInfo = devInfo;
        this.mAccessToken = accessToken;
        this.mPluginMsgr = pluginMsgr;
        this.reportedServiceVersion = reportedServiceVersion;
        if (this.mCachedState == null) {
            this.mCachedState = initialDeviceState;
        }
        this.isInitialized = true;
    }

    public String getDeviceName() {
        return this.deviceInfo.visibleName;
    }

    public int getAntDeviceNumber() {
        return this.deviceInfo.antDeviceNumber;
    }

    public boolean isUserRecognizedDevice() {
        return this.deviceInfo.device_dbId != null;
    }

    public boolean isUserPreferredDeviceForPlugin() {
        return this.deviceInfo.isPreferredDevice == true;
    }

    public DeviceState getCurrentDeviceState() {
        return DeviceState.getValueFromInt(this.mCachedState);
    }

    protected Message createCmdMsg(int cmdCode, Bundle msgData) {
        Message cmdMsg = Message.obtain();
        cmdMsg.what = cmdCode;
        if (msgData == null) {
            msgData = new Bundle();
        }
        msgData.putSerializable("uuid_AccessToken", (Serializable)this.mAccessToken);
        cmdMsg.setData(msgData);
        return cmdMsg;
    }

    protected Message sendPluginCommand(int cmdCode, Bundle msgData) {
        return this.sendPluginCommandInternal(this.createCmdMsg(cmdCode, msgData));
    }

    protected Message sendPluginCommand(Message cmdMsg) {
        Bundle msgData = cmdMsg.getData();
        if (msgData == null) {
            msgData = new Bundle();
            cmdMsg.setData(msgData);
        }
        msgData.putSerializable("uuid_AccessToken", (Serializable)this.mAccessToken);
        return this.sendPluginCommandInternal(cmdMsg);
    }

    /*
     * Exception decompiling
     */
    private Message sendPluginCommandInternal(Message cmdMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 49[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean subscribeToEvent(int eventCode) {
        Message subCmdMsg = this.createCmdMsg(10000, null);
        subCmdMsg.arg1 = eventCode;
        Message ret = this.sendPluginCommand(subCmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "subscribeToEvent died in sendPluginCommand()");
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Subscribing to event " + eventCode + " failed with code " + ret.arg1);
            ret.recycle();
            return false;
        }
        ret.recycle();
        return true;
    }

    protected void unsubscribeFromEvent(int eventCode) {
        Message unsubCmdMsg = this.createCmdMsg(10001, null);
        unsubCmdMsg.arg1 = eventCode;
        Message ret = this.sendPluginCommand(unsubCmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "unsubscribeFromEvent died in sendPluginCommand()");
            return;
        }
        if (ret.arg1 != 0) {
            throw new RuntimeException("Unsubscribing to event " + eventCode + " failed with code " + unsubCmdMsg.arg1);
        }
        ret.recycle();
    }

    public void releaseAccess() {
        this.mReleaseHandle.close();
    }

    private void notifyBindAndRequestFailed(Bundle requestAccessParams) {
        this.closePluginConnection();
        Messenger resultMsgr = (Messenger)requestAccessParams.getParcelable("msgr_ReqAccResultReceiver");
        Message msgErr = Message.obtain();
        msgErr.what = -4;
        try {
            resultMsgr.send(msgErr);
        }
        catch (RemoteException e1) {
            LogAnt.e(TAG, "Remote exception sending failure msg to client");
        }
    }

    void handleConnectionBroke(String errorMessage) {
        LogAnt.w(TAG, "ConnectionDied: " + errorMessage);
        if (this.mReleaseHandle == null || this.mReleaseHandle.isClosed) {
            return;
        }
        this.releaseToken();
        this.mStateChangeReceiver.onDeviceStateChange(DeviceState.DEAD);
    }

    void stopAsyncScan() {
        this.sendReleaseCommand(10101);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseToken() {
        ReentrantLock reentrantLock = this.mPluginCommLock;
        synchronized (reentrantLock) {
            this.mCachedState = -100;
            try {
                this.sendReleaseCommand(10002);
            }
            finally {
                this.closePluginConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReleaseCommand(int releaseCode) {
        ReentrantLock reentrantLock = this.mPluginCommLock;
        synchronized (reentrantLock) {
            try {
                if (this.mPluginMsgr != null) {
                    this.mPluginMsgr.send(this.createCmdMsg(releaseCode, null));
                }
            }
            catch (RemoteException e) {
                LogAnt.e(TAG, "RemoteException, unable to cleanly release (cmd " + releaseCode + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closePluginConnection() {
        if (this.isReleased) {
            return;
        }
        this.isReleased = true;
        this.mPluginMsgHandlerThread.quit();
        try {
            this.mPluginMsgHandlerThread.join(1000L);
        }
        catch (InterruptedException e) {
            LogAnt.e(TAG, "Plugin Msg Handler thread failed to shut down cleanly, InterruptedException");
            Thread.currentThread().interrupt();
        }
        this.mPluginEventHandler = null;
        this.mPluginEventHandlerThread.quit();
        try {
            this.mPluginEventHandlerThread.join(1000L);
        }
        catch (InterruptedException e) {
            LogAnt.e(TAG, "Plugin Event Handler thread failed to shut down cleanly, InterruptedException");
            Thread.currentThread().interrupt();
        }
        this.unbindPluginService();
        if (this.mPluginCommLock.tryLock()) {
            this.mPluginCommLock.unlock();
        } else {
            this.mCurrentCmdThread.interrupt();
        }
        ReentrantLock reentrantLock = this.mPluginCommLock;
        synchronized (reentrantLock) {
            this.mPluginMsgr = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindPluginService(Intent it, Bundle b) {
        Object object = this.mPluginServiceBindChange_LOCK;
        synchronized (object) {
            if (!this.mIsPluginServiceBound) {
                this.mIsPluginServiceBound = true;
                if (!this.mOwnerContext.bindService(it, this.serviceBindConn, 1)) {
                    LogAnt.e(TAG, "Binding to plugin failed");
                    this.notifyBindAndRequestFailed(b);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindPluginService() {
        Object object = this.mPluginServiceBindChange_LOCK;
        synchronized (object) {
            if (this.mIsPluginServiceBound) {
                try {
                    this.mOwnerContext.unbindService(this.serviceBindConn);
                }
                catch (IllegalArgumentException e) {
                    LogAnt.e(TAG, "Unexpected error unbinding service, " + e);
                }
                this.mIsPluginServiceBound = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RequestAccessResultHandler_AsyncSearchByDevNumber<T extends AntPluginPcc>
    extends RequestAccessResultHandler<T> {
        protected RequestAccessResultHandler_AsyncSearchByDevNumber() {
        }

        @Override
        public boolean handleRequestAccessResult(Message msg) {
            if (msg.what == -7) {
                this.handleRequestAccessFailed("Search for device timed out.", RequestAccessResult.SEARCH_TIMEOUT);
                return true;
            }
            return super.handleRequestAccessResult(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RequestAccessResultHandler_UI<T extends AntPluginPcc>
    extends RequestAccessResultHandler<T> {
        private Activity foregroundActivity;

        public RequestAccessResultHandler_UI(Activity foregroundActivity) {
            this.foregroundActivity = foregroundActivity;
        }

        @Override
        public boolean handleRequestAccessResult(Message msg) {
            if (msg.what == 1) {
                Bundle b = msg.getData();
                Intent i = (Intent)b.getParcelable("intent_ActivityToLaunch");
                if (!this.retPccObject.mReleaseHandle.isClosed) {
                    this.foregroundActivity.startActivity(i);
                }
                return true;
            }
            return super.handleRequestAccessResult(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RequestAccessResultHandler<T extends AntPluginPcc>
    extends Handler {
        protected T retPccObject;
        protected IPluginAccessResultReceiver<T> resultReceiver;

        void setReturnInfo(T retPccObject, IPluginAccessResultReceiver<T> resultReceiver) {
            this.retPccObject = retPccObject;
            this.resultReceiver = resultReceiver;
        }

        public void handleMessage(Message msg) {
            LogAnt.v(TAG, "ReqAcc Handler received: " + msg.what);
            msg.getData().setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            if (!this.handleRequestAccessResult(msg)) {
                RequestAccessResult code = RequestAccessResult.getValueFromInt(msg.what);
                if (code == RequestAccessResult.UNRECOGNIZED) {
                    this.handleRequestAccessFailed("Unrecognized return code (need app lib upgrade): " + msg.what + "!!!", code);
                } else {
                    this.handleRequestAccessFailed(code.toString(), code);
                }
            }
        }

        public boolean handleRequestAccessResult(Message msg) {
            int resultCode = msg.what;
            switch (resultCode) {
                case 0: {
                    Bundle b = msg.getData();
                    int serviceVersion = b.getInt("int_ServiceVersion", 0);
                    Messenger pluginComm = (Messenger)b.getParcelable("msgr_PluginComm");
                    UUID accessToken = (UUID)b.get("uuid_AccessToken");
                    int initialStateCode = b.getInt("int_InitialDeviceStateCode");
                    AntPluginDeviceDbProvider.DeviceDbDeviceInfo deviceInfo = (AntPluginDeviceDbProvider.DeviceDbDeviceInfo)b.getParcelable("parcelable_DeviceDbInfo");
                    if (deviceInfo == null) {
                        deviceInfo = new AntPluginDeviceDbProvider.DeviceDbDeviceInfo(0);
                        deviceInfo.antDeviceNumber = b.getInt("int_AntDeviceID", -1);
                        deviceInfo.visibleName = b.getString("str_DeviceName");
                        deviceInfo.isPreferredDevice = false;
                    }
                    ((AntPluginPcc)this.retPccObject).init(deviceInfo, accessToken, pluginComm, initialStateCode, serviceVersion);
                    this.resultReceiver.onResultReceived(this.retPccObject, RequestAccessResult.getValueFromInt(resultCode), DeviceState.getValueFromInt(initialStateCode));
                    ((AntPluginPcc)this.retPccObject).deviceInitializedLatch.countDown();
                    return true;
                }
                case -5: {
                    Bundle b = msg.getData();
                    lastMissingDependencyPkgName = b.getString("string_DependencyPackageName");
                    lastMissingDependencyName = b.getString("string_DependencyName");
                    this.handleRequestAccessFailed("Missing Dependency: " + lastMissingDependencyPkgName + " not installed.", RequestAccessResult.DEPENDENCY_NOT_INSTALLED);
                    return true;
                }
            }
            return false;
        }

        public void handleRequestAccessFailed(String errorMessage, RequestAccessResult result) {
            LogAnt.w(TAG, "RequestAccess failed: " + errorMessage);
            ((AntPluginPcc)this.retPccObject).releaseToken();
            this.resultReceiver.onResultReceived(null, result, DeviceState.DEAD);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class StandardReleaseHandle<T extends AntPluginPcc>
    extends PccReleaseHandle<T> {
        protected StandardReleaseHandle(IPluginAccessResultReceiver<T> resultReceiver, IDeviceStateChangeReceiver stateReceiver) {
            super(resultReceiver, stateReceiver);
        }

        @Override
        protected void requestCancelled() {
            AntPluginPcc.this.closePluginConnection();
        }
    }

    public static interface IDeviceStateChangeReceiver {
        public void onDeviceStateChange(DeviceState var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IPluginAccessResultReceiver<T extends AntPluginPcc> {
        public void onResultReceived(T var1, RequestAccessResult var2, DeviceState var3);
    }
}

