import numpy as np
from gpaw.bztools import get_reduced_bz

# This script tries to calculate the IBZ
# of some crystal
cell = np.array([[3.944303659438116, 4.885073777474223e-18, 0.0],
                 [-1.9721518297143041, 3.415867169311081, 0.0],
                 [1.0879762163625086e-15, 1.884430084164765e-15, 17.768]])
op_scc = np.array(
    [[[1, 1, 0],
      [0, -1, 0],
      [0, 0, 1]],

     [[1, 0, 0],
      [0, 1, 0],
      [0, 0, 1]],

     [[0, 1, 0],
      [-1, -1, 0],
      [0, 0, 1]],

     [[0, -1, 0],
      [-1, 0, 0],
      [0, 0, 1]],

     [[-1, 0, 0],
      [1, 1, 0],
      [0, 0, 1]],

     [[-1, -1, 0],
      [1, 0, 0],
      [0, 0, 1]],

     [[1, 1, 0],
      [-1, 0, 0],
      [0, 0, -1]],

     [[1, 0, 0],
      [-1, -1, 0],
      [0, 0, -1]],

     [[0, 1, 0],
      [1, 0, 0],
      [0, 0, -1]],

     [[0, -1, 0],
      [1, 1, 0],
      [0, 0, -1]],

     [[-1, 0, 0],
      [0, -1, 0],
      [0, 0, -1]],

     [[-1, -1, 0],
      [0, 1, 0],
      [0, 0, -1]]])

get_reduced_bz(cell, op_scc, True,
               pbc_c=np.array([True, True, False]),
               tolerance=0.1)
