/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ball.h"
#include "tube.h"

void 
LeftTube::MoveBall(Ball* ball)
{
   switch (ball->GetDirection()) {
   case Ball::MovingLeft:
      ball->SetDirection(Ball::MovingUp);
      _start->PutBall(ball);
      break;
   case Ball::MovingUp:
      ball->SetDirection(Ball::MovingLeft);
      _start->PutBall(ball);
      break;
   case Ball::MovingRight:
      ball->SetDirection(Ball::MovingDown);
      _end->PutBall(ball);
      break;
   case Ball::MovingDown:
      ball->SetDirection(Ball::MovingRight);
      _end->PutBall(ball);
      break;
   default:
      break;
   }
}

void 
RightTube::MoveBall(Ball* ball)
{
   switch (ball->GetDirection()) {
   case Ball::MovingLeft:
      ball->SetDirection(Ball::MovingDown);
      _start->PutBall(ball);
      break;
   case Ball::MovingUp:
      ball->SetDirection(Ball::MovingRight);
      _end->PutBall(ball);
      break;
   case Ball::MovingRight:
      ball->SetDirection(Ball::MovingUp);
      _end->PutBall(ball);
      break;
   case Ball::MovingDown:
      ball->SetDirection(Ball::MovingLeft);
      _start->PutBall(ball);
      break;
   default:
      break;
   }
}



