
// input12au7_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  1.500000
 // --table_div  7.844688
 // --table_op  0.250000

struct tableinput12au7 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tableinput12au7_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tableinput12au7&() const { return *(tableinput12au7*)this; }
};

 static tableinput12au7_imp<2048> input12au7_table __rt_data = {
	0,-0.833333,341.167,2048, {
	0.000000000000,-0.000617085606,-0.001233896646,-0.001850433245,-0.002466695530,
	-0.003082683628,-0.003698397665,-0.004313837768,-0.004929004064,-0.005543896679,
	-0.006158515739,-0.006772861371,-0.007386933701,-0.008000732855,-0.008614258960,
	-0.009227512142,-0.009840492526,-0.010453200240,-0.011065635408,-0.011677798156,
	-0.012289688611,-0.012901306899,-0.013512653144,-0.014123727474,-0.014734530012,
	-0.015345060885,-0.015955320219,-0.016565308139,-0.017175024769,-0.017784470237,
	-0.018393644666,-0.019002548182,-0.019611180910,-0.020219542975,-0.020827634503,
	-0.021435455618,-0.022043006445,-0.022650287108,-0.023257297734,-0.023864038446,
	-0.024470509370,-0.025076710629,-0.025682642349,-0.026288304654,-0.026893697668,
	-0.027498821516,-0.028103676322,-0.028708262210,-0.029312579306,-0.029916627731,
	-0.030520407612,-0.031123919072,-0.031727162235,-0.032330137224,-0.032932844165,
	-0.033535283180,-0.034137454393,-0.034739357929,-0.035340993910,-0.035942362460,
	-0.036543463704,-0.037144297763,-0.037744864763,-0.038345164825,-0.038945198074,
	-0.039544964633,-0.040144464624,-0.040743698171,-0.041342665398,-0.041941366427,
	-0.042539801380,-0.043137970382,-0.043735873554,-0.044333511021,-0.044930882903,
	-0.045527989324,-0.046124830408,-0.046721406275,-0.047317717049,-0.047913762852,
	-0.048509543807,-0.049105060036,-0.049700311661,-0.050295298805,-0.050890021589,
	-0.051484480135,-0.052078674567,-0.052672605005,-0.053266271572,-0.053859674390,
	-0.054452813580,-0.055045689264,-0.055638301564,-0.056230650602,-0.056822736499,
	-0.057414559377,-0.058006119357,-0.058597416560,-0.059188451109,-0.059779223124,
	-0.060369732727,-0.060959980038,-0.061549965180,-0.062139688273,-0.062729149437,
	-0.063318348795,-0.063907286467,-0.064495962574,-0.065084377237,-0.065672530576,
	-0.066260422713,-0.066848053767,-0.067435423860,-0.068022533112,-0.068609381644,
	-0.069195969575,-0.069782297027,-0.070368364119,-0.070954170972,-0.071539717706,
	-0.072125004442,-0.072710031298,-0.073294798396,-0.073879305856,-0.074463553797,
	-0.075047542339,-0.075631271601,-0.076214741705,-0.076797952769,-0.077380904913,
	-0.077963598257,-0.078546032920,-0.079128209021,-0.079710126681,-0.080291786018,
	-0.080873187152,-0.081454330202,-0.082035215288,-0.082615842528,-0.083196212041,
	-0.083776323947,-0.084356178364,-0.084935775412,-0.085515115209,-0.086094197875,
	-0.086673023527,-0.087251592285,-0.087829904267,-0.088407959593,-0.088985758379,
	-0.089563300746,-0.090140586811,-0.090717616692,-0.091294390509,-0.091870908379,
	-0.092447170421,-0.093023176752,-0.093598927492,-0.094174422757,-0.094749662666,
	-0.095324647337,-0.095899376887,-0.096473851435,-0.097048071099,-0.097622035995,
	-0.098195746242,-0.098769201958,-0.099342403259,-0.099915350264,-0.100488043090,
	-0.101060481854,-0.101632666673,-0.102204597665,-0.102776274948,-0.103347698638,
	-0.103918868852,-0.104489785707,-0.105060449322,-0.105630859811,-0.106201017293,
	-0.106770921884,-0.107340573702,-0.107909972862,-0.108479119481,-0.109048013677,
	-0.109616655565,-0.110185045262,-0.110753182886,-0.111321068551,-0.111888702375,
	-0.112456084473,-0.113023214963,-0.113590093960,-0.114156721580,-0.114723097940,
	-0.115289223155,-0.115855097342,-0.116420720616,-0.116986093094,-0.117551214891,
	-0.118116086123,-0.118680706906,-0.119245077355,-0.119809197586,-0.120373067714,
	-0.120936687856,-0.121500058126,-0.122063178640,-0.122626049513,-0.123188670860,
	-0.123751042798,-0.124313165440,-0.124875038903,-0.125436663301,-0.125998038749,
	-0.126559165362,-0.127120043255,-0.127680672543,-0.128241053341,-0.128801185764,
	-0.129361069926,-0.129920705941,-0.130480093925,-0.131039233993,-0.131598126257,
	-0.132156770834,-0.132715167837,-0.133273317381,-0.133831219580,-0.134388874548,
	-0.134946282400,-0.135503443249,-0.136060357209,-0.136617024396,-0.137173444921,
	-0.137729618901,-0.138285546447,-0.138841227675,-0.139396662698,-0.139951851629,
	-0.140506794583,-0.141061491672,-0.141615943011,-0.142170148713,-0.142724108891,
	-0.143277823659,-0.143831293130,-0.144384517417,-0.144937496634,-0.145490230893,
	-0.146042720309,-0.146594964993,-0.147146965059,-0.147698720620,-0.148250231789,
	-0.148801498679,-0.149352521402,-0.149903300071,-0.150453834799,-0.151004125699,
	-0.151554172883,-0.152103976464,-0.152653536554,-0.153202853266,-0.153751926712,
	-0.154300757004,-0.154849344255,-0.155397688577,-0.155945790082,-0.156493648882,
	-0.157041265089,-0.157588638816,-0.158135770175,-0.158682659276,-0.159229306233,
	-0.159775711156,-0.160321874158,-0.160867795351,-0.161413474846,-0.161958912754,
	-0.162504109188,-0.163049064258,-0.163593778077,-0.164138250755,-0.164682482405,
	-0.165226473136,-0.165770223061,-0.166313732291,-0.166857000937,-0.167400029110,
	-0.167942816920,-0.168485364480,-0.169027671900,-0.169569739290,-0.170111566762,
	-0.170653154427,-0.171194502394,-0.171735610776,-0.172276479682,-0.172817109224,
	-0.173357499510,-0.173897650653,-0.174437562763,-0.174977235949,-0.175516670323,
	-0.176055865994,-0.176594823073,-0.177133541669,-0.177672021894,-0.178210263857,
	-0.178748267668,-0.179286033437,-0.179823561274,-0.180360851289,-0.180897903591,
	-0.181434718291,-0.181971295498,-0.182507635322,-0.183043737872,-0.183579603258,
	-0.184115231590,-0.184650622977,-0.185185777528,-0.185720695352,-0.186255376560,
	-0.186789821260,-0.187324029561,-0.187858001573,-0.188391737405,-0.188925237166,
	-0.189458500964,-0.189991528909,-0.190524321110,-0.191056877675,-0.191589198713,
	-0.192121284334,-0.192653134645,-0.193184749755,-0.193716129774,-0.194247274809,
	-0.194778184969,-0.195308860362,-0.195839301098,-0.196369507283,-0.196899479028,
	-0.197429216438,-0.197958719624,-0.198487988693,-0.199017023753,-0.199545824913,
	-0.200074392279,-0.200602725961,-0.201130826066,-0.201658692702,-0.202186325976,
	-0.202713725997,-0.203240892872,-0.203767826709,-0.204294527615,-0.204820995698,
	-0.205347231066,-0.205873233825,-0.206399004084,-0.206924541949,-0.207449847529,
	-0.207974920929,-0.208499762258,-0.209024371622,-0.209548749129,-0.210072894886,
	-0.210596808999,-0.211120491576,-0.211643942723,-0.212167162548,-0.212690151156,
	-0.213212908656,-0.213735435153,-0.214257730755,-0.214779795567,-0.215301629697,
	-0.215823233250,-0.216344606334,-0.216865749055,-0.217386661519,-0.217907343832,
	-0.218427796101,-0.218948018432,-0.219468010931,-0.219987773703,-0.220507306857,
	-0.221026610496,-0.221545684727,-0.222064529657,-0.222583145390,-0.223101532033,
	-0.223619689692,-0.224137618472,-0.224655318479,-0.225172789818,-0.225690032596,
	-0.226207046917,-0.226723832887,-0.227240390611,-0.227756720196,-0.228272821745,
	-0.228788695365,-0.229304341161,-0.229819759237,-0.230334949700,-0.230849912653,
	-0.231364648203,-0.231879156453,-0.232393437510,-0.232907491477,-0.233421318461,
	-0.233934918564,-0.234448291893,-0.234961438552,-0.235474358646,-0.235987052278,
	-0.236499519555,-0.237011760579,-0.237523775456,-0.238035564290,-0.238547127186,
	-0.239058464247,-0.239569575578,-0.240080461283,-0.240591121467,-0.241101556233,
	-0.241611765685,-0.242121749928,-0.242631509065,-0.243141043201,-0.243650352439,
	-0.244159436883,-0.244668296637,-0.245176931804,-0.245685342488,-0.246193528794,
	-0.246701490823,-0.247209228681,-0.247716742470,-0.248224032293,-0.248731098255,
	-0.249237940459,-0.249744559007,-0.250250954004,-0.250757125552,-0.251263073754,
	-0.251768798713,-0.252274300534,-0.252779579318,-0.253284635168,-0.253789468188,
	-0.254294078480,-0.254798466147,-0.255302631292,-0.255806574018,-0.256310294426,
	-0.256813792621,-0.257317068704,-0.257820122778,-0.258322954946,-0.258825565309,
	-0.259327953971,-0.259830121033,-0.260332066598,-0.260833790768,-0.261335293645,
	-0.261836575332,-0.262337635931,-0.262838475543,-0.263339094270,-0.263839492215,
	-0.264339669480,-0.264839626166,-0.265339362374,-0.265838878208,-0.266338173769,
	-0.266837249157,-0.267336104476,-0.267834739826,-0.268333155309,-0.268831351026,
	-0.269329327080,-0.269827083570,-0.270324620600,-0.270821938269,-0.271319036679,
	-0.271815915932,-0.272312576128,-0.272809017369,-0.273305239756,-0.273801243389,
	-0.274297028370,-0.274792594800,-0.275287942779,-0.275783072408,-0.276277983789,
	-0.276772677021,-0.277267152206,-0.277761409443,-0.278255448835,-0.278749270481,
	-0.279242874481,-0.279736260937,-0.280229429948,-0.280722381615,-0.281215116038,
	-0.281707633318,-0.282199933555,-0.282692016848,-0.283183883299,-0.283675533007,
	-0.284166966072,-0.284658182594,-0.285149182673,-0.285639966409,-0.286130533901,
	-0.286620885251,-0.287111020556,-0.287600939918,-0.288090643436,-0.288580131209,
	-0.289069403336,-0.289558459918,-0.290047301054,-0.290535926844,-0.291024337386,
	-0.291512532780,-0.292000513125,-0.292488278521,-0.292975829067,-0.293463164861,
	-0.293950286004,-0.294437192594,-0.294923884730,-0.295410362511,-0.295896626036,
	-0.296382675403,-0.296868510713,-0.297354132063,-0.297839539552,-0.298324733279,
	-0.298809713342,-0.299294479841,-0.299779032874,-0.300263372538,-0.300747498934,
	-0.301231412158,-0.301715112310,-0.302198599487,-0.302681873789,-0.303164935313,
	-0.303647784158,-0.304130420421,-0.304612844201,-0.305095055596,-0.305577054703,
	-0.306058841621,-0.306540416448,-0.307021779282,-0.307502930219,-0.307983869359,
	-0.308464596799,-0.308945112637,-0.309425416969,-0.309905509895,-0.310385391510,
	-0.310865061914,-0.311344521203,-0.311823769474,-0.312302806826,-0.312781633355,
	-0.313260249159,-0.313738654335,-0.314216848980,-0.314694833191,-0.315172607066,
	-0.315650170701,-0.316127524194,-0.316604667641,-0.317081601139,-0.317558324785,
	-0.318034838677,-0.318511142910,-0.318987237582,-0.319463122789,-0.319938798628,
	-0.320414265196,-0.320889522588,-0.321364570902,-0.321839410234,-0.322314040681,
	-0.322788462338,-0.323262675303,-0.323736679671,-0.324210475539,-0.324684063003,
	-0.325157442159,-0.325630613103,-0.326103575931,-0.326576330740,-0.327048877625,
	-0.327521216682,-0.327993348007,-0.328465271696,-0.328936987844,-0.329408496548,
	-0.329879797904,-0.330350892006,-0.330821778951,-0.331292458833,-0.331762931750,
	-0.332233197795,-0.332703257065,-0.333173109655,-0.333642755660,-0.334112195175,
	-0.334581428297,-0.335050455119,-0.335519275738,-0.335987890248,-0.336456298745,
	-0.336924501323,-0.337392498077,-0.337860289103,-0.338327874496,-0.338795254349,
	-0.339262428759,-0.339729397820,-0.340196161626,-0.340662720272,-0.341129073853,
	-0.341595222464,-0.342061166199,-0.342526905153,-0.342992439419,-0.343457769093,
	-0.343922894269,-0.344387815041,-0.344852531504,-0.345317043752,-0.345781351878,
	-0.346245455978,-0.346709356144,-0.347173052473,-0.347636545056,-0.348099833989,
	-0.348562919365,-0.349025801279,-0.349488479823,-0.349950955093,-0.350413227181,
	-0.350875296181,-0.351337162188,-0.351798825294,-0.352260285593,-0.352721543180,
	-0.353182598147,-0.353643450587,-0.354104100595,-0.354564548263,-0.355024793686,
	-0.355484836956,-0.355944678166,-0.356404317410,-0.356863754781,-0.357322990372,
	-0.357782024276,-0.358240856586,-0.358699487395,-0.359157916796,-0.359616144882,
	-0.360074171746,-0.360531997481,-0.360989622179,-0.361447045933,-0.361904268836,
	-0.362361290980,-0.362818112459,-0.363274733364,-0.363731153788,-0.364187373824,
	-0.364643393563,-0.365099213100,-0.365554832525,-0.366010251931,-0.366465471410,
	-0.366920491055,-0.367375310958,-0.367829931210,-0.368284351905,-0.368738573133,
	-0.369192594988,-0.369646417560,-0.370100040942,-0.370553465226,-0.371006690503,
	-0.371459716865,-0.371912544405,-0.372365173214,-0.372817603382,-0.373269835003,
	-0.373721868168,-0.374173702967,-0.374625339494,-0.375076777838,-0.375528018092,
	-0.375979060346,-0.376429904693,-0.376880551223,-0.377331000028,-0.377781251198,
	-0.378231304826,-0.378681161002,-0.379130819816,-0.379580281361,-0.380029545728,
	-0.380478613006,-0.380927483287,-0.381376156662,-0.381824633222,-0.382272913057,
	-0.382720996258,-0.383168882916,-0.383616573122,-0.384064066965,-0.384511364537,
	-0.384958465928,-0.385405371229,-0.385852080530,-0.386298593921,-0.386744911493,
	-0.387191033336,-0.387636959540,-0.388082690196,-0.388528225394,-0.388973565223,
	-0.389418709774,-0.389863659138,-0.390308413403,-0.390752972660,-0.391197336999,
	-0.391641506510,-0.392085481282,-0.392529261406,-0.392972846971,-0.393416238067,
	-0.393859434783,-0.394302437210,-0.394745245436,-0.395187859552,-0.395630279646,
	-0.396072505809,-0.396514538129,-0.396956376697,-0.397398021601,-0.397839472931,
	-0.398280730776,-0.398721795224,-0.399162666367,-0.399603344292,-0.400043829088,
	-0.400484120845,-0.400924219652,-0.401364125597,-0.401803838770,-0.402243359260,
	-0.402682687154,-0.403121822543,-0.403560765515,-0.403999516158,-0.404438074561,
	-0.404876440814,-0.405314615003,-0.405752597219,-0.406190387549,-0.406627986083,
	-0.407065392907,-0.407502608112,-0.407939631785,-0.408376464014,-0.408813104888,
	-0.409249554495,-0.409685812923,-0.410121880260,-0.410557756595,-0.410993442015,
	-0.411428936609,-0.411864240464,-0.412299353669,-0.412734276311,-0.413169008478,
	-0.413603550257,-0.414037901738,-0.414472063007,-0.414906034152,-0.415339815261,
	-0.415773406422,-0.416206807721,-0.416640019247,-0.417073041087,-0.417505873328,
	-0.417938516059,-0.418370969365,-0.418803233335,-0.419235308056,-0.419667193615,
	-0.420098890099,-0.420530397595,-0.420961716191,-0.421392845974,-0.421823787030,
	-0.422254539447,-0.422685103312,-0.423115478711,-0.423545665732,-0.423975664460,
	-0.424405474984,-0.424835097390,-0.425264531764,-0.425693778194,-0.426122836765,
	-0.426551707565,-0.426980390680,-0.427408886196,-0.427837194200,-0.428265314779,
	-0.428693248018,-0.429120994005,-0.429548552825,-0.429975924564,-0.430403109310,
	-0.430830107148,-0.431256918164,-0.431683542445,-0.432109980076,-0.432536231144,
	-0.432962295734,-0.433388173933,-0.433813865826,-0.434239371499,-0.434664691039,
	-0.435089824530,-0.435514772059,-0.435939533712,-0.436364109573,-0.436788499729,
	-0.437212704265,-0.437636723267,-0.438060556821,-0.438484205011,-0.438907667923,
	-0.439330945643,-0.439754038256,-0.440176945847,-0.440599668502,-0.441022206306,
	-0.441444559343,-0.441866727700,-0.442288711461,-0.442710510711,-0.443132125535,
	-0.443553556019,-0.443974802247,-0.444395864305,-0.444816742276,-0.445237436247,
	-0.445657946301,-0.446078272523,-0.446498414999,-0.446918373813,-0.447338149049,
	-0.447757740792,-0.448177149127,-0.448596374139,-0.449015415911,-0.449434274528,
	-0.449852950074,-0.450271442635,-0.450689752293,-0.451107879134,-0.451525823242,
	-0.451943584701,-0.452361163595,-0.452778560008,-0.453195774025,-0.453612805729,
	-0.454029655204,-0.454446322535,-0.454862807805,-0.455279111098,-0.455695232499,
	-0.456111172090,-0.456526929955,-0.456942506180,-0.457357900846,-0.457773114038,
	-0.458188145839,-0.458602996333,-0.459017665604,-0.459432153734,-0.459846460808,
	-0.460260586909,-0.460674532121,-0.461088296525,-0.461501880207,-0.461915283249,
	-0.462328505734,-0.462741547746,-0.463154409367,-0.463567090682,-0.463979591772,
	-0.464391912721,-0.464804053613,-0.465216014529,-0.465627795553,-0.466039396768,
	-0.466450818256,-0.466862060101,-0.467273122384,-0.467684005190,-0.468094708600,
	-0.468505232698,-0.468915577565,-0.469325743284,-0.469735729939,-0.470145537611,
	-0.470555166383,-0.470964616337,-0.471373887556,-0.471782980121,-0.472191894116,
	-0.472600629623,-0.473009186723,-0.473417565500,-0.473825766034,-0.474233788409,
	-0.474641632706,-0.475049299008,-0.475456787396,-0.475864097952,-0.476271230758,
	-0.476678185897,-0.477084963449,-0.477491563498,-0.477897986123,-0.478304231408,
	-0.478710299434,-0.479116190283,-0.479521904036,-0.479927440774,-0.480332800580,
	-0.480737983535,-0.481142989720,-0.481547819217,-0.481952472107,-0.482356948471,
	-0.482761248391,-0.483165371949,-0.483569319224,-0.483973090299,-0.484376685254,
	-0.484780104172,-0.485183347132,-0.485586414216,-0.485989305505,-0.486392021079,
	-0.486794561021,-0.487196925410,-0.487599114328,-0.488001127855,-0.488402966072,
	-0.488804629060,-0.489206116900,-0.489607429672,-0.490008567457,-0.490409530335,
	-0.490810318387,-0.491210931694,-0.491611370336,-0.492011634393,-0.492411723947,
	-0.492811639076,-0.493211379862,-0.493610946385,-0.494010338725,-0.494409556962,
	-0.494808601177,-0.495207471450,-0.495606167860,-0.496004690488,-0.496403039414,
	-0.496801214717,-0.497199216479,-0.497597044778,-0.497994699695,-0.498392181309,
	-0.498789489701,-0.499186624949,-0.499583587135,-0.499980376336,-0.500376992634,
	-0.500773436108,-0.501169706837,-0.501565804900,-0.501961730378,-0.502357483350,
	-0.502753063895,-0.503148472093,-0.503543708023,-0.503938771764,-0.504333663396,
	-0.504728382997,-0.505122930648,-0.505517306427,-0.505911510413,-0.506305542686,
	-0.506699403324,-0.507093092407,-0.507486610014,-0.507879956223,-0.508273131113,
	-0.508666134764,-0.509058967254,-0.509451628662,-0.509844119067,-0.510236438547,
	-0.510628587181,-0.511020565048,-0.511412372227,-0.511804008795,-0.512195474832,
	-0.512586770416,-0.512977895626,-0.513368850540,-0.513759635236,-0.514150249793,
	-0.514540694289,-0.514930968803,-0.515321073412,-0.515711008195,-0.516100773229,
	-0.516490368595,-0.516879794368,-0.517269050628,-0.517658137452,-0.518047054919,
	-0.518435803105,-0.518824382091,-0.519212791952,-0.519601032767,-0.519989104615,
	-0.520377007572,-0.520764741716,-0.521152307125,-0.521539703877,-0.521926932050,
	-0.522313991720,-0.522700882966,-0.523087605865,-0.523474160495,-0.523860546933,
	-0.524246765256,-0.524632815542,-0.525018697868,-0.525404412312,-0.525789958950,
	-0.526175337860,-0.526560549120,-0.526945592806,-0.527330468995,-0.527715177765,
	-0.528099719192,-0.528484093355,-0.528868300328,-0.529252340191,-0.529636213019,
	-0.530019918889,-0.530403457879,-0.530786830064,-0.531170035522,-0.531553074330,
	-0.531935946564,-0.532318652301,-0.532701191618,-0.533083564590,-0.533465771295,
	-0.533847811810,-0.534229686210,-0.534611394572,-0.534992936972,-0.535374313488,
	-0.535755524195,-0.536136569169,-0.536517448487,-0.536898162225,-0.537278710459,
	-0.537659093266,-0.538039310721,-0.538419362901,-0.538799249881,-0.539178971738,
	-0.539558528548,-0.539937920386,-0.540317147329,-0.540696209452,-0.541075106832,
	-0.541453839543,-0.541832407663,-0.542210811265,-0.542589050427,-0.542967125224,
	-0.543345035732,-0.543722782026,-0.544100364181,-0.544477782273,-0.544855036379,
	-0.545232126572,-0.545609052929,-0.545985815525,-0.546362414435,-0.546738849735,
	-0.547115121499,-0.547491229804,-0.547867174724,-0.548242956335,-0.548618574711,
	-0.548994029928,-0.549369322060,-0.549744451184,-0.550119417373,-0.550494220703,
	-0.550868861249,-0.551243339085,-0.551617654287,-0.551991806929,-0.552365797086,
	-0.552739624833,-0.553113290244,-0.553486793394,-0.553860134359,-0.554233313211,
	-0.554606330027,-0.554979184880,-0.555351877846,-0.555724408997,-0.556096778410,
	-0.556468986158,-0.556841032316,-0.557212916958,-0.557584640158,-0.557956201991,
	-0.558327602530,-0.558698841851,-0.559069920027,-0.559440837132,-0.559811593240,
	-0.560182188426,-0.560552622763,-0.560922896326,-0.561293009188,-0.561662961424,
	-0.562032753106,-0.562402384310,-0.562771855108,-0.563141165575,-0.563510315785,
	-0.563879305810,-0.564248135725,-0.564616805603,-0.564985315519,-0.565353665545,
	-0.565721855755,-0.566089886222,-0.566457757021,-0.566825468224,-0.567193019905,
	-0.567560412137,-0.567927644993,-0.568294718548,-0.568661632873,-0.569028388043,
	-0.569394984130,-0.569761421208,-0.570127699350,-0.570493818628,-0.570859779117,
	-0.571225580888,-0.571591224015,-0.571956708572,-0.572322034630,-0.572687202262,
	-0.573052211542,-0.573417062543,-0.573781755336,-0.574146289996,-0.574510666594,
	-0.574874885203,-0.575238945896,-0.575602848746,-0.575966593824,-0.576330181204,
	-0.576693610959,-0.577056883160,-0.577419997880,-0.577782955191,-0.578145755166,
	-0.578508397878,-0.578870883398,-0.579233211798,-0.579595383152,-0.579957397530,
	-0.580319255006,-0.580680955651,-0.581042499538,-0.581403886739,-0.581765117325,
	-0.582126191369,-0.582487108942,-0.582847870117,-0.583208474966,-0.583568923560,
	-0.583929215971,-0.584289352270,-0.584649332531,-0.585009156824,-0.585368825221,
	-0.585728337794,-0.586087694614,-0.586446895754,-0.586805941284,-0.587164831276,
	-0.587523565801,-0.587882144932,-0.588240568739,-0.588598837294,-0.588956950668,
	-0.589314908933,-0.589672712160,-0.590030360420,-0.590387853784,-0.590745192323,
	-0.591102376110,-0.591459405214,-0.591816279707,-0.592172999660,-0.592529565144,
	-0.592885976230,-0.593242232989,-0.593598335492,-0.593954283810,-0.594310078014,
	-0.594665718173,-0.595021204360,-0.595376536646,-0.595731715099,-0.596086739793,
	-0.596441610796,-0.596796328180,-0.597150892016,-0.597505302373,-0.597859559323,
	-0.598213662936,-0.598567613282,-0.598921410432,-0.599275054456,-0.599628545424,
	-0.599981883408,-0.600335068477,-0.600688100701,-0.601040980151,-0.601393706896,
	-0.601746281008,-0.602098702556,-0.602450971610,-0.602803088241,-0.603155052518,
	-0.603506864511,-0.603858524291,-0.604210031927,-0.604561387489,-0.604912591047,
	-0.605263642672,-0.605614542431,-0.605965290397,-0.606315886637,-0.606666331223,
	-0.607016624223,-0.607366765707,-0.607716755745,-0.608066594407,-0.608416281761,
	-0.608765817878,-0.609115202827,-0.609464436677,-0.609813519498,-0.610162451359,
	-0.610511232330,-0.610859862480,-0.611208341877,-0.611556670592,-0.611904848694,
	-0.612252876252,-0.612600753334,-0.612948480010,-0.613296056350,-0.613643482422,
	-0.613990758294,-0.614337884038,-0.614684859720,-0.615031685410,-0.615378361177,
	-0.615724887091,-0.616071263218,-0.616417489630,-0.616763566393,-0.617109493577,
	-0.617455271252,-0.617800899484,-0.618146378343,-0.618491707898,-0.618836888217,
	-0.619181919369,-0.619526801421,-0.619871534444,-0.620216118504,-0.620560553671,
	-0.620904840013,-0.621248977598,-0.621592966494,-0.621936806771,-0.622280498495,
	-0.622624041736,-0.622967436561,-0.623310683038,-0.623653781237,-0.623996731224,
	-0.624339533068,-0.624682186837,-0.625024692599,-0.625367050421,-0.625709260373,
	-0.626051322521,-0.626393236933,-0.626735003678,-0.627076622823,-0.627418094436,
	-0.627759418585,-0.628100595337,-0.628441624760,-0.628782506922,-0.629123241890,
	-0.629463829732,-0.629804270515,-0.630144564307,-0.630484711176,-0.630824711189,
	-0.631164564413,-0.631504270915,-0.631843830764,-0.632183244025,-0.632522510768,
	-0.632861631058,-0.633200604964,-0.633539432552,-0.633878113889,-0.634216649043,
	-0.634555038081,-0.634893281070,-0.635231378076,-0.635569329167,-0.635907134410,
	-0.636244793872,-0.636582307620,-0.636919675720,-0.637256898240,-0.637593975245,
	-0.637930906804,-0.638267692983,-0.638604333848,-0.638940829466,-0.639277179905,
	-0.639613385229,-0.639949445507,-0.640285360805,-0.640621131188,-0.640956756725,
	-0.641292237481,-0.641627573522,-0.641962764915,-0.642297811727,-0.642632714023,
	-0.642967471871,-0.643302085336,-0.643636554485,-0.643970879383,-0.644305060098,
	-0.644639096694,-0.644972989240,-0.645306737799,-0.645640342439,-0.645973803226,
	-0.646307120225,-0.646640293503,-0.646973323125,-0.647306209158,-0.647638951667,
	-0.647971550718,-0.648304006377,-0.648636318710,-0.648968487782,-0.649300513660,
	-0.649632396408,-0.649964136093,-0.650295732780,-0.650627186536,-0.650958497424,
	-0.651289665512,-0.651620690864,-0.651951573546,-0.652282313623,-0.652612911161,
	-0.652943366226,-0.653273678882,-0.653603849194,-0.653933877229,-0.654263763052,
	-0.654593506727,-0.654923108320,-0.655252567896,-0.655581885521,-0.655911061258,
	-0.656240095174,-0.656568987334,-0.656897737802,-0.657226346644,-0.657554813924,
	-0.657883139707,-0.658211324058,-0.658539367043,-0.658867268726,-0.659195029171,
	-0.659522648444,-0.659850126609,-0.660177463731,-0.660504659875,-0.660831715105,
	-0.661158629487,-0.661485403083,-0.661812035960,-0.662138528182,-0.662464879812,
	-0.662791090917,-0.663117161559,-0.663443091804,-0.663768881715,-0.664094531358,
	-0.664420040797,-0.664745410095,-0.665070639317,-0.665395728528,-0.665720677791,
	-0.666045487171,-0.666370156731,-0.666694686537,-0.667019076651,-0.667343327139,
	-0.667667438063,-0.667991409489,-0.668315241479,-0.668638934099,-0.668962487411,
	-0.669285901480,-0.669609176370,-0.669932312144,-0.670255308866,-0.670578166600,
	-0.670900885409,-0.671223465358,-0.671545906509,-0.671868208927,-0.672190372676,
	-0.672512397818,-0.672834284417,-0.673156032537,-0.673477642241,-0.673799113593,
	-0.674120446656,-0.674441641493,-0.674762698168,-0.675083616745,-0.675404397286,
	-0.675725039854,-0.676045544514,-0.676365911327,-0.676686140358,-0.677006231670,
	-0.677326185325,-0.677646001387,-0.677965679918,-0.678285220982,-0.678604624643,
	-0.678923890961,-0.679243020002,-0.679562011827,-0.679880866500,-0.680199584083,
	-0.680518164639,-0.680836608231,-0.681154914922,-0.681473084774,-0.681791117850,
	-0.682109014213,-0.682426773926,-0.682744397050,-0.683061883650,-0.683379233786,
	-0.683696447523,-0.684013524921,-0.684330466044,-0.684647270955,-0.684963939714,
	-0.685280472386,-0.685596869032,-0.685913129715,-0.686229254496,-0.686545243439,
	-0.686861096605,-0.687176814057,-0.687492395856,-0.687807842065,-0.688123152746,
	-0.688438327962,-0.688753367773,-0.689068272242,-0.689383041432,-0.689697675404,
	-0.690012174220,-0.690326537942,-0.690640766632,-0.690954860351,-0.691268819162,
	-0.691582643126,-0.691896332306,-0.692209886762,-0.692523306556,-0.692836591751,
	-0.693149742408,-0.693462758588,-0.693775640353,-0.694088387765,-0.694401000885,
	-0.694713479774,-0.695025824495,-0.695338035108,-0.695650111675,-0.695962054258,
	-0.696273862917,-0.696585537714,-0.696897078711,-0.697208485968,-0.697519759547,
	-0.697830899509,-0.698141905915,-0.698452778826,-0.698763518304,-0.699074124410,
	-0.699384597204,-0.699694936748,-0.700005143103,-0.700315216329,-0.700625156488,
	-0.700934963641,-0.701244637848,-0.701554179170,-0.701863587668,-0.702172863404,
	-0.702482006437,-0.702791016829,-0.703099894639,-0.703408639930,-0.703717252761,
	-0.704025733194,-0.704334081288,-0.704642297105,-0.704950380705,-0.705258332148,
	-0.705566151495,-0.705873838806,-0.706181394142,-0.706488817564,-0.706796109131,
	-0.707103268904,-0.707410296943,-0.707717193309,-0.708023958062,-0.708330591262,
	-0.708637092969,-0.708943463243,-0.709249702146,-0.709555809735,-0.709861786073,
	-0.710167631219,-0.710473345232,-0.710778928174,-0.711084380103,-0.711389701081,
	-0.711694891166,-0.711999950418,-0.712304878899,-0.712609676666,-0.712914343781,
	-0.713218880303,-0.713523286292,-0.713827561807,-0.714131706908,-0.714435721655,
	-0.714739606107,-0.715043360325,-0.715346984367,-0.715650478293,-0.715953842163,
	-0.716257076036,-0.716560179972,-0.716863154030,-0.717165998270,-0.717468712750,
	-0.717771297531,-0.718073752672,-0.718376078231,-0.718678274268,-0.718980340843,
	-0.719282278015,-0.719584085843,-0.719885764385,-0.720187313702,-0.720488733852,
	-0.720790024894,-0.721091186888,-0.721392219892,-0.721693123965,-0.721993899167,
	-0.722294545556,-0.722595063191,-0.722895452131,-0.723195712435,-0.723495844162,
	-0.723795847371,-0.724095722120,-0.724395468468,-0.724695086474,-0.724994576196,
	-0.725293937693,-0.725593171024,-0.725892276248,-0.726191253422,-0.726490102606,
	-0.726788823858,-0.727087417237,-0.727385882800,-0.727684220607,-0.727982430715,
	-0.728280513184,-0.728578468072,-0.728876295436,-0.729173995335,-0.729471567828,
	-0.729769012973,-0.730066330827,-0.730363521450,-0.730660584899,-0.730957521232,
	-0.731254330508,-0.731551012784,-0.731847568119,-0.732143996571,-0.732440298197,
	-0.732736473056,-0.733032521205,-0.733328442703,-0.733624237607,-0.733919905976,
	-0.734215447866,-0.734510863336,-0.734806152444,-0.735101315248,-0.735396351804,
	-0.735691262171,-0.735986046407,-0.736280704568,-0.736575236714,-0.736869642901,
	-0.737163923186,-0.737458077628,-0.737752106284,-0.738046009211,-0.738339786467,
	-0.738633438109,-0.738926964195,-0.739220364782,-0.739513639927,-0.739806789687,
	-0.740099814121,-0.740392713285,-0.740685487236,-0.740978136032,-0.741270659729,
	-0.741563058386,-0.741855332059,-0.742147480804,-0.742439504680,-0.742731403744,
	-0.743023178051,-0.743314827660,-0.743606352627,-0.743897753009,-0.744189028863,
	-0.744480180246,-0.744771207215,-0.745062109827,-0.745352888138,-0.745643542205,
	-0.745934072085,-0.746224477834,-0.746514759510,-0.746804917169,-0.747094950868,
	-0.747384860663,-0.747674646610,-0.747964308768,-0.748253847191,-0.748543261936,
	-0.748832553060,-0.749121720620,-0.749410764671,-0.749699685270,-0.749988482474,
	-0.750277156339,-0.750565706921,-0.750854134277,-0.751142438462,-0.751430619533,
	-0.751718677546,-0.752006612558,-0.752294424624,-0.752582113801,-0.752869680144,
	-0.753157123710,-0.753444444555,-0.753731642735,-0.754018718306,-0.754305671324,
	-0.754592501844,-0.754879209923,-0.755165795617,-0.755452258981,-0.755738600071,
	-0.756024818943,-0.756310915654,-0.756596890257,-0.756882742810,-0.757168473369,
	-0.757454081987,-0.757739568723,-0.758024933630,-0.758310176765,-0.758595298182,
	-0.758880297939,-0.759165176090,-0.759449932690,-0.759734567796,-0.760019081462,
	-0.760303473745,-0.760587744698,-0.760871894379,-0.761155922841,-0.761439830141,
	-0.761723616334,-0.762007281474,-0.762290825618,-0.762574248820,-0.762857551135,
	-0.763140732619,-0.763423793327,-0.763706733314,-0.763989552635,-0.764272251345,
	-0.764554829499,-0.764837287152,-0.765119624359,-0.765401841174,-0.765683937654,
	-0.765965913852,-0.766247769824,-0.766529505624,-0.766811121308,-0.767092616930,
	-0.767373992544,-0.767655248206,-0.767936383970,-0.768217399890,-0.768498296023,
	-0.768779072421,-0.769059729141,-0.769340266235,-0.769620683760,-0.769900981768,
	-0.770181160316,-0.770461219457,-0.770741159246,-0.771020979737,-0.771300680985,
	-0.771580263044,-0.771859725968,-0.772139069811,-0.772418294629,-0.772697400475,
	-0.772976387403,-0.773255255468,-0.773534004723,-0.773812635224,-0.774091147024,
	-0.774369540176,-0.774647814737,-0.774925970758,-0.775204008295,-0.775481927402,
	-0.775759728131,-0.776037410539,-0.776314974677,-0.776592420600,-0.776869748363,
	-0.777146958018,-0.777424049620,-0.777701023223,-0.777977878880,-0.778254616645,
	-0.778531236572,-0.778807738714,-0.779084123125,-0.779360389859,-0.779636538970,
	-0.779912570510,-0.780188484534,-0.780464281095,-0.780739960247,-0.781015522042,
	-0.781290966536,-0.781566293780,-0.781841503829,-0.782116596736,-0.782391572553,
	-0.782666431336,-0.782941173136,-0.783215798007,-0.783490306003,-0.783764697176,
	-0.784038971580,-0.784313129268,-0.784587170294,-0.784861094710,-0.785134902569,
	-0.785408593924,-0.785682168830,-0.785955627337,-0.786228969501,-0.786502195373,
	-0.786775305007,-0.787048298455,-0.787321175771,-0.787593937007,-0.787866582216,
	-0.788139111451,-0.788411524765,-0.788683822210,-0.788956003840,-0.789228069707,
	-0.789500019863,-0.789771854362,-0.790043573257,-0.790315176598,-0.790586664441,
	-0.790858036836,-0.791129293837,-0.791400435496,-0.791671461865,-0.791942372997,
	-0.792213168945,-0.792483849761,-0.792754415497,-0.793024866205,-0.793295201939,
	-0.793565422750,-0.793835528691,-0.794105519813,-0.794375396170,-0.794645157814,
	-0.794914804796,-0.795184337169,-0.795453754984,-0.795723058295,-0.795992247154,
	-0.796261321611,-0.796530281720,-0.796799127532,-0.797067859100,-0.797336476475,
	-0.797604979709,-0.797873368855,-0.798141643963,-0.798409805087,-0.798677852278,
	-0.798945785588,-0.799213605068,-0.799481310770,-0.799748902747,-0.800016381049,
	-0.800283745729,-0.800550996838,-0.800818134428,-0.801085158551,-0.801352069257,
	-0.801618866600,-0.801885550630,-0.802152121398,-0.802418578957,-0.802684923357,
	-0.802951154651,-0.803217272890,-0.803483278125,-0.803749170407,-0.804014949788,
	-0.804280616320,-0.804546170053,-0.804811611038,-0.805076939328,-0.805342154973,
	-0.805607258025,-0.805872248535,-0.806137126553,-0.806401892132,-0.806666545321,
	-0.806931086173,-0.807195514738,-0.807459831068,-0.807724035213,-0.807988127224,
	-0.808252107153,-0.808515975050,-0.808779730966,-0.809043374953,-0.809306907060,
	-0.809570327340,-0.809833635842,-0.810096832617,-0.810359917717,-0.810622891192,
	-0.810885753092,-0.811148503469,-0.811411142374,-0.811673669856,-0.811936085966,
	-0.812198390755,-0.812460584274,-0.812722666574,-0.812984637703,-0.813246497715,
	-0.813508246657,-0.813769884582,-0.814031411540,-0.814292827581,-0.814554132755,
	-0.814815327112,-0.815076410704,-0.815337383581,-0.815598245792,-0.815858997388,
	-0.816119638419,-0.816380168936,-0.816640588988,-0.816900898626,-0.817161097900,
	-0.817421186860,-0.817681165557,-0.817941034040,-0.818200792359,-0.818460440564,
	-0.818719978706,-0.818979406834,-0.819238724998,-0.819497933249,-0.819757031636,
	-0.820016020208,-0.820274899017,-0.820533668111,-0.820792327541,-0.821050877356,
	-0.821309317607,-0.821567648342,-0.821825869612,-0.822083981465,-0.822341983953,
	-0.822599877124,-0.822857661029,-0.823115335716,-0.823372901236,-0.823630357637,
	-0.823887704970,-0.824144943284,-0.824402072628,-0.824659093052,-0.824916004606,
	-0.825172807338,-0.825429501298,-0.825686086536,-0.825942563100,-0.826198931040,
	-0.826455190406,-0.826711341247,-0.826967383611,-0.827223317549,-0.827479143108,
	-0.827734860340,-0.827990469292,-0.828245970013,-0.828501362554,-0.828756646962,
	-0.829011823287,-0.829266891579,-0.829521851885,-0.829776704255,-0.830031448739,
	-0.830286085384,-0.830540614240,-0.830795035355,-0.831049348780,-0.831303554561,
	-0.831557652749,-0.831811643392,-0.832065526538,-0.832319302237,-0.832572970538,
	-0.832826531488,-0.833079985137,-0.833333331533
	}
};

double always_inline input12au7clip(double x) {
    double f = fabs(x);
    f = f * input12au7_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = input12au7_table.data[0];
    } else if (i >= input12au7_table.size-1) {
        f = input12au7_table.data[input12au7_table.size-1];
    } else {
    f -= i;
    f = input12au7_table.data[i]*(1-f) + input12au7_table.data[i+1]*f;
    }
    return copysign(f, x);
}

