package CParse::Op::Unary;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;
use CParse::Op::Unary::AddressOf;
use CParse::Op::Unary::Deref;
use CParse::Op::Unary::Positive;
use CParse::Op::Unary::Negative;
use CParse::Op::Unary::BitNot;
use CParse::Op::Unary::BoolNot;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $arg = shift;
    my $op = shift;

    return CParse::Op::Unary::AddressOf->new($arg) if $op eq '&';
    return CParse::Op::Unary::Deref->new($arg) if $op eq '*';
    return CParse::Op::Unary::Positive->new($arg) if $op eq '+';
    return CParse::Op::Unary::Negative->new($arg) if $op eq '-';
    return CParse::Op::Unary::BitNot->new($arg) if $op eq '~';
    return CParse::Op::Unary::BoolNot->new($arg) if $op eq '!';
    die;
  }

1;
