package CParse::Parser::Token::Float;

use 5.6.0;
use strict;
use warnings;

use Math::BigFloat;
use CParse::Float;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $str = shift;
    my $line = shift;
    my $pos = shift;

    my $number;

    if ($str =~ /^0x/)
      {
        die "Hexadeximal floats are not supported";
      }
    else
      {
        $number = Math::BigFloat->new($str);
      }

    my $self = {value => $number,
                line => $line,
                pos => $pos,
               };
    bless $self, $class;
    return $self;
  }

sub line
  {
    my $self = shift;
    return $self->{line};
  }

sub pos
  {
    my $self = shift;
    return $self->{pos};
  }

sub dump_c
  {
    my $self = shift;

    return $self->{value};
  }

sub process
  {
    my $self = shift;

    return new CParse::Float $self->{value};
  }

1;
