/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.slicer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

/**
 * This interface is used to convert SliceUsage from one language to another for the purpose of building multi-language dataflow graphs. <br/>
 * Transformation is applied depending on the language of SliceUsage PSI element
 */
public interface SliceUsageTransformer {
  /**
   * The method returns list of SliceUsage which should replace original one and are specific to the transformer language
   * @param usage SliceUsage generated by the slicer corresponding to the language of the parent node
   * @return List of SliceUsage specific to the language of this transformer, or null if transformation is not needed/possible
   */
  @Nullable
  Collection<SliceUsage> transform(@NotNull SliceUsage usage);
}