/*************************************************************************
* Copyright (C) 2019 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#include <internal/common/ifma_math.h>

#ifdef __GNUC__
#define ASM(a) __asm__(a);
#else
#define ASM(a)
#endif

void AMS52x30_diagonal_mb8(int64u *out_mb, const int64u *inpA_mb,
                           const int64u *inpM_mb, const int64u *k0_mb) {

  __ALIGN64 U64 res[60];
  __ALIGN64 U64 u[30];
  U64 k;
  U64 *a = (U64 *)inpA_mb;
  U64 *m = (U64 *)inpM_mb;
  U64 *r = (U64 *)out_mb;

  k = loadu64((U64 *)k0_mb);
  int i;
  for (i = 0; i < 60; ++i)
    res[i] = get_zero64();

  res[1] = fma52lo(res[1], a[0], a[1]);     // Sum(1)
  res[2] = fma52hi(res[2], a[0], a[1]);     // Sum(1)
  res[2] = fma52lo(res[2], a[0], a[2]);     // Sum(2)
  res[3] = fma52hi(res[3], a[0], a[2]);     // Sum(2)
  res[3] = fma52lo(res[3], a[1], a[2]);     // Sum(3)
  res[4] = fma52hi(res[4], a[1], a[2]);     // Sum(3)
  res[3] = fma52lo(res[3], a[0], a[3]);     // Sum(3)
  res[4] = fma52hi(res[4], a[0], a[3]);     // Sum(3)
  res[4] = fma52lo(res[4], a[1], a[3]);     // Sum(4)
  res[5] = fma52hi(res[5], a[1], a[3]);     // Sum(4)
  res[5] = fma52lo(res[5], a[2], a[3]);     // Sum(5)
  res[6] = fma52hi(res[6], a[2], a[3]);     // Sum(5)
  res[4] = fma52lo(res[4], a[0], a[4]);     // Sum(4)
  res[5] = fma52hi(res[5], a[0], a[4]);     // Sum(4)
  res[5] = fma52lo(res[5], a[1], a[4]);     // Sum(5)
  res[6] = fma52hi(res[6], a[1], a[4]);     // Sum(5)
  res[6] = fma52lo(res[6], a[2], a[4]);     // Sum(6)
  res[7] = fma52hi(res[7], a[2], a[4]);     // Sum(6)
  res[7] = fma52lo(res[7], a[3], a[4]);     // Sum(7)
  res[8] = fma52hi(res[8], a[3], a[4]);     // Sum(7)
  res[5] = fma52lo(res[5], a[0], a[5]);     // Sum(5)
  res[6] = fma52hi(res[6], a[0], a[5]);     // Sum(5)
  res[6] = fma52lo(res[6], a[1], a[5]);     // Sum(6)
  res[7] = fma52hi(res[7], a[1], a[5]);     // Sum(6)
  res[7] = fma52lo(res[7], a[2], a[5]);     // Sum(7)
  res[8] = fma52hi(res[8], a[2], a[5]);     // Sum(7)
  res[8] = fma52lo(res[8], a[3], a[5]);     // Sum(8)
  res[9] = fma52hi(res[9], a[3], a[5]);     // Sum(8)
  res[9] = fma52lo(res[9], a[4], a[5]);     // Sum(9)
  res[10] = fma52hi(res[10], a[4], a[5]);   // Sum(9)
  res[6] = fma52lo(res[6], a[0], a[6]);     // Sum(6)
  res[7] = fma52hi(res[7], a[0], a[6]);     // Sum(6)
  res[7] = fma52lo(res[7], a[1], a[6]);     // Sum(7)
  res[8] = fma52hi(res[8], a[1], a[6]);     // Sum(7)
  res[8] = fma52lo(res[8], a[2], a[6]);     // Sum(8)
  res[9] = fma52hi(res[9], a[2], a[6]);     // Sum(8)
  res[9] = fma52lo(res[9], a[3], a[6]);     // Sum(9)
  res[10] = fma52hi(res[10], a[3], a[6]);   // Sum(9)
  res[10] = fma52lo(res[10], a[4], a[6]);   // Sum(10)
  res[11] = fma52hi(res[11], a[4], a[6]);   // Sum(10)
  res[11] = fma52lo(res[11], a[5], a[6]);   // Sum(11)
  res[12] = fma52hi(res[12], a[5], a[6]);   // Sum(11)
  res[7] = fma52lo(res[7], a[0], a[7]);     // Sum(7)
  res[8] = fma52hi(res[8], a[0], a[7]);     // Sum(7)
  res[8] = fma52lo(res[8], a[1], a[7]);     // Sum(8)
  res[9] = fma52hi(res[9], a[1], a[7]);     // Sum(8)
  res[9] = fma52lo(res[9], a[2], a[7]);     // Sum(9)
  res[10] = fma52hi(res[10], a[2], a[7]);   // Sum(9)
  res[10] = fma52lo(res[10], a[3], a[7]);   // Sum(10)
  res[11] = fma52hi(res[11], a[3], a[7]);   // Sum(10)
  res[11] = fma52lo(res[11], a[4], a[7]);   // Sum(11)
  res[12] = fma52hi(res[12], a[4], a[7]);   // Sum(11)
  res[8] = fma52lo(res[8], a[0], a[8]);     // Sum(8)
  res[9] = fma52hi(res[9], a[0], a[8]);     // Sum(8)
  res[9] = fma52lo(res[9], a[1], a[8]);     // Sum(9)
  res[10] = fma52hi(res[10], a[1], a[8]);   // Sum(9)
  res[10] = fma52lo(res[10], a[2], a[8]);   // Sum(10)
  res[11] = fma52hi(res[11], a[2], a[8]);   // Sum(10)
  res[11] = fma52lo(res[11], a[3], a[8]);   // Sum(11)
  res[12] = fma52hi(res[12], a[3], a[8]);   // Sum(11)
  res[9] = fma52lo(res[9], a[0], a[9]);     // Sum(9)
  res[10] = fma52hi(res[10], a[0], a[9]);   // Sum(9)
  res[10] = fma52lo(res[10], a[1], a[9]);   // Sum(10)
  res[11] = fma52hi(res[11], a[1], a[9]);   // Sum(10)
  res[11] = fma52lo(res[11], a[2], a[9]);   // Sum(11)
  res[12] = fma52hi(res[12], a[2], a[9]);   // Sum(11)
  res[10] = fma52lo(res[10], a[0], a[10]);  // Sum(10)
  res[11] = fma52hi(res[11], a[0], a[10]);  // Sum(10)
  res[11] = fma52lo(res[11], a[1], a[10]);  // Sum(11)
  res[12] = fma52hi(res[12], a[1], a[10]);  // Sum(11)
  res[11] = fma52lo(res[11], a[0], a[11]);  // Sum(11)
  res[12] = fma52hi(res[12], a[0], a[11]);  // Sum(11)
  res[0] = add64(res[0], res[0]);           // Double(0)
  res[1] = add64(res[1], res[1]);           // Double(1)
  res[2] = add64(res[2], res[2]);           // Double(2)
  res[3] = add64(res[3], res[3]);           // Double(3)
  res[4] = add64(res[4], res[4]);           // Double(4)
  res[5] = add64(res[5], res[5]);           // Double(5)
  res[6] = add64(res[6], res[6]);           // Double(6)
  res[7] = add64(res[7], res[7]);           // Double(7)
  res[8] = add64(res[8], res[8]);           // Double(8)
  res[9] = add64(res[9], res[9]);           // Double(9)
  res[10] = add64(res[10], res[10]);        // Double(10)
  res[11] = add64(res[11], res[11]);        // Double(11)
  res[0] = fma52lo(res[0], a[0], a[0]);     // Add sqr(0)
  res[1] = fma52hi(res[1], a[0], a[0]);     // Add sqr(0)
  res[2] = fma52lo(res[2], a[1], a[1]);     // Add sqr(2)
  res[3] = fma52hi(res[3], a[1], a[1]);     // Add sqr(2)
  res[4] = fma52lo(res[4], a[2], a[2]);     // Add sqr(4)
  res[5] = fma52hi(res[5], a[2], a[2]);     // Add sqr(4)
  res[6] = fma52lo(res[6], a[3], a[3]);     // Add sqr(6)
  res[7] = fma52hi(res[7], a[3], a[3]);     // Add sqr(6)
  res[8] = fma52lo(res[8], a[4], a[4]);     // Add sqr(8)
  res[9] = fma52hi(res[9], a[4], a[4]);     // Add sqr(8)
  res[10] = fma52lo(res[10], a[5], a[5]);   // Add sqr(10)
  res[11] = fma52hi(res[11], a[5], a[5]);   // Add sqr(10)
  res[12] = fma52lo(res[12], a[5], a[7]);   // Sum(12)
  res[13] = fma52hi(res[13], a[5], a[7]);   // Sum(12)
  res[13] = fma52lo(res[13], a[6], a[7]);   // Sum(13)
  res[14] = fma52hi(res[14], a[6], a[7]);   // Sum(13)
  res[12] = fma52lo(res[12], a[4], a[8]);   // Sum(12)
  res[13] = fma52hi(res[13], a[4], a[8]);   // Sum(12)
  res[13] = fma52lo(res[13], a[5], a[8]);   // Sum(13)
  res[14] = fma52hi(res[14], a[5], a[8]);   // Sum(13)
  res[14] = fma52lo(res[14], a[6], a[8]);   // Sum(14)
  res[15] = fma52hi(res[15], a[6], a[8]);   // Sum(14)
  res[15] = fma52lo(res[15], a[7], a[8]);   // Sum(15)
  res[16] = fma52hi(res[16], a[7], a[8]);   // Sum(15)
  res[12] = fma52lo(res[12], a[3], a[9]);   // Sum(12)
  res[13] = fma52hi(res[13], a[3], a[9]);   // Sum(12)
  res[13] = fma52lo(res[13], a[4], a[9]);   // Sum(13)
  res[14] = fma52hi(res[14], a[4], a[9]);   // Sum(13)
  res[14] = fma52lo(res[14], a[5], a[9]);   // Sum(14)
  res[15] = fma52hi(res[15], a[5], a[9]);   // Sum(14)
  res[15] = fma52lo(res[15], a[6], a[9]);   // Sum(15)
  res[16] = fma52hi(res[16], a[6], a[9]);   // Sum(15)
  res[16] = fma52lo(res[16], a[7], a[9]);   // Sum(16)
  res[17] = fma52hi(res[17], a[7], a[9]);   // Sum(16)
  res[17] = fma52lo(res[17], a[8], a[9]);   // Sum(17)
  res[18] = fma52hi(res[18], a[8], a[9]);   // Sum(17)
  res[12] = fma52lo(res[12], a[2], a[10]);  // Sum(12)
  res[13] = fma52hi(res[13], a[2], a[10]);  // Sum(12)
  res[13] = fma52lo(res[13], a[3], a[10]);  // Sum(13)
  res[14] = fma52hi(res[14], a[3], a[10]);  // Sum(13)
  res[14] = fma52lo(res[14], a[4], a[10]);  // Sum(14)
  res[15] = fma52hi(res[15], a[4], a[10]);  // Sum(14)
  res[15] = fma52lo(res[15], a[5], a[10]);  // Sum(15)
  res[16] = fma52hi(res[16], a[5], a[10]);  // Sum(15)
  res[16] = fma52lo(res[16], a[6], a[10]);  // Sum(16)
  res[17] = fma52hi(res[17], a[6], a[10]);  // Sum(16)
  res[17] = fma52lo(res[17], a[7], a[10]);  // Sum(17)
  res[18] = fma52hi(res[18], a[7], a[10]);  // Sum(17)
  res[18] = fma52lo(res[18], a[8], a[10]);  // Sum(18)
  res[19] = fma52hi(res[19], a[8], a[10]);  // Sum(18)
  res[19] = fma52lo(res[19], a[9], a[10]);  // Sum(19)
  res[20] = fma52hi(res[20], a[9], a[10]);  // Sum(19)
  res[12] = fma52lo(res[12], a[1], a[11]);  // Sum(12)
  res[13] = fma52hi(res[13], a[1], a[11]);  // Sum(12)
  res[13] = fma52lo(res[13], a[2], a[11]);  // Sum(13)
  res[14] = fma52hi(res[14], a[2], a[11]);  // Sum(13)
  res[14] = fma52lo(res[14], a[3], a[11]);  // Sum(14)
  res[15] = fma52hi(res[15], a[3], a[11]);  // Sum(14)
  res[15] = fma52lo(res[15], a[4], a[11]);  // Sum(15)
  res[16] = fma52hi(res[16], a[4], a[11]);  // Sum(15)
  res[16] = fma52lo(res[16], a[5], a[11]);  // Sum(16)
  res[17] = fma52hi(res[17], a[5], a[11]);  // Sum(16)
  res[17] = fma52lo(res[17], a[6], a[11]);  // Sum(17)
  res[18] = fma52hi(res[18], a[6], a[11]);  // Sum(17)
  res[18] = fma52lo(res[18], a[7], a[11]);  // Sum(18)
  res[19] = fma52hi(res[19], a[7], a[11]);  // Sum(18)
  res[19] = fma52lo(res[19], a[8], a[11]);  // Sum(19)
  res[20] = fma52hi(res[20], a[8], a[11]);  // Sum(19)
  res[20] = fma52lo(res[20], a[9], a[11]);  // Sum(20)
  res[21] = fma52hi(res[21], a[9], a[11]);  // Sum(20)
  res[21] = fma52lo(res[21], a[10], a[11]); // Sum(21)
  res[22] = fma52hi(res[22], a[10], a[11]); // Sum(21)
  res[12] = fma52lo(res[12], a[0], a[12]);  // Sum(12)
  res[13] = fma52hi(res[13], a[0], a[12]);  // Sum(12)
  res[13] = fma52lo(res[13], a[1], a[12]);  // Sum(13)
  res[14] = fma52hi(res[14], a[1], a[12]);  // Sum(13)
  res[14] = fma52lo(res[14], a[2], a[12]);  // Sum(14)
  res[15] = fma52hi(res[15], a[2], a[12]);  // Sum(14)
  res[15] = fma52lo(res[15], a[3], a[12]);  // Sum(15)
  res[16] = fma52hi(res[16], a[3], a[12]);  // Sum(15)
  res[16] = fma52lo(res[16], a[4], a[12]);  // Sum(16)
  res[17] = fma52hi(res[17], a[4], a[12]);  // Sum(16)
  res[17] = fma52lo(res[17], a[5], a[12]);  // Sum(17)
  res[18] = fma52hi(res[18], a[5], a[12]);  // Sum(17)
  res[18] = fma52lo(res[18], a[6], a[12]);  // Sum(18)
  res[19] = fma52hi(res[19], a[6], a[12]);  // Sum(18)
  res[19] = fma52lo(res[19], a[7], a[12]);  // Sum(19)
  res[20] = fma52hi(res[20], a[7], a[12]);  // Sum(19)
  res[20] = fma52lo(res[20], a[8], a[12]);  // Sum(20)
  res[21] = fma52hi(res[21], a[8], a[12]);  // Sum(20)
  res[21] = fma52lo(res[21], a[9], a[12]);  // Sum(21)
  res[22] = fma52hi(res[22], a[9], a[12]);  // Sum(21)
  res[22] = fma52lo(res[22], a[10], a[12]); // Sum(22)
  res[23] = fma52hi(res[23], a[10], a[12]); // Sum(22)
  res[23] = fma52lo(res[23], a[11], a[12]); // Sum(23)
  res[24] = fma52hi(res[24], a[11], a[12]); // Sum(23)
  res[13] = fma52lo(res[13], a[0], a[13]);  // Sum(13)
  res[14] = fma52hi(res[14], a[0], a[13]);  // Sum(13)
  res[14] = fma52lo(res[14], a[1], a[13]);  // Sum(14)
  res[15] = fma52hi(res[15], a[1], a[13]);  // Sum(14)
  res[15] = fma52lo(res[15], a[2], a[13]);  // Sum(15)
  res[16] = fma52hi(res[16], a[2], a[13]);  // Sum(15)
  res[16] = fma52lo(res[16], a[3], a[13]);  // Sum(16)
  res[17] = fma52hi(res[17], a[3], a[13]);  // Sum(16)
  res[17] = fma52lo(res[17], a[4], a[13]);  // Sum(17)
  res[18] = fma52hi(res[18], a[4], a[13]);  // Sum(17)
  res[18] = fma52lo(res[18], a[5], a[13]);  // Sum(18)
  res[19] = fma52hi(res[19], a[5], a[13]);  // Sum(18)
  res[19] = fma52lo(res[19], a[6], a[13]);  // Sum(19)
  res[20] = fma52hi(res[20], a[6], a[13]);  // Sum(19)
  res[20] = fma52lo(res[20], a[7], a[13]);  // Sum(20)
  res[21] = fma52hi(res[21], a[7], a[13]);  // Sum(20)
  res[21] = fma52lo(res[21], a[8], a[13]);  // Sum(21)
  res[22] = fma52hi(res[22], a[8], a[13]);  // Sum(21)
  res[22] = fma52lo(res[22], a[9], a[13]);  // Sum(22)
  res[23] = fma52hi(res[23], a[9], a[13]);  // Sum(22)
  res[23] = fma52lo(res[23], a[10], a[13]); // Sum(23)
  res[24] = fma52hi(res[24], a[10], a[13]); // Sum(23)
  res[14] = fma52lo(res[14], a[0], a[14]);  // Sum(14)
  res[15] = fma52hi(res[15], a[0], a[14]);  // Sum(14)
  res[15] = fma52lo(res[15], a[1], a[14]);  // Sum(15)
  res[16] = fma52hi(res[16], a[1], a[14]);  // Sum(15)
  res[16] = fma52lo(res[16], a[2], a[14]);  // Sum(16)
  res[17] = fma52hi(res[17], a[2], a[14]);  // Sum(16)
  res[17] = fma52lo(res[17], a[3], a[14]);  // Sum(17)
  res[18] = fma52hi(res[18], a[3], a[14]);  // Sum(17)
  res[18] = fma52lo(res[18], a[4], a[14]);  // Sum(18)
  res[19] = fma52hi(res[19], a[4], a[14]);  // Sum(18)
  res[19] = fma52lo(res[19], a[5], a[14]);  // Sum(19)
  res[20] = fma52hi(res[20], a[5], a[14]);  // Sum(19)
  res[20] = fma52lo(res[20], a[6], a[14]);  // Sum(20)
  res[21] = fma52hi(res[21], a[6], a[14]);  // Sum(20)
  res[21] = fma52lo(res[21], a[7], a[14]);  // Sum(21)
  res[22] = fma52hi(res[22], a[7], a[14]);  // Sum(21)
  res[22] = fma52lo(res[22], a[8], a[14]);  // Sum(22)
  res[23] = fma52hi(res[23], a[8], a[14]);  // Sum(22)
  res[23] = fma52lo(res[23], a[9], a[14]);  // Sum(23)
  res[24] = fma52hi(res[24], a[9], a[14]);  // Sum(23)
  res[15] = fma52lo(res[15], a[0], a[15]);  // Sum(15)
  res[16] = fma52hi(res[16], a[0], a[15]);  // Sum(15)
  res[16] = fma52lo(res[16], a[1], a[15]);  // Sum(16)
  res[17] = fma52hi(res[17], a[1], a[15]);  // Sum(16)
  res[17] = fma52lo(res[17], a[2], a[15]);  // Sum(17)
  res[18] = fma52hi(res[18], a[2], a[15]);  // Sum(17)
  res[18] = fma52lo(res[18], a[3], a[15]);  // Sum(18)
  res[19] = fma52hi(res[19], a[3], a[15]);  // Sum(18)
  res[19] = fma52lo(res[19], a[4], a[15]);  // Sum(19)
  res[20] = fma52hi(res[20], a[4], a[15]);  // Sum(19)
  res[20] = fma52lo(res[20], a[5], a[15]);  // Sum(20)
  res[21] = fma52hi(res[21], a[5], a[15]);  // Sum(20)
  res[21] = fma52lo(res[21], a[6], a[15]);  // Sum(21)
  res[22] = fma52hi(res[22], a[6], a[15]);  // Sum(21)
  res[22] = fma52lo(res[22], a[7], a[15]);  // Sum(22)
  res[23] = fma52hi(res[23], a[7], a[15]);  // Sum(22)
  res[23] = fma52lo(res[23], a[8], a[15]);  // Sum(23)
  res[24] = fma52hi(res[24], a[8], a[15]);  // Sum(23)
  res[16] = fma52lo(res[16], a[0], a[16]);  // Sum(16)
  res[17] = fma52hi(res[17], a[0], a[16]);  // Sum(16)
  res[17] = fma52lo(res[17], a[1], a[16]);  // Sum(17)
  res[18] = fma52hi(res[18], a[1], a[16]);  // Sum(17)
  res[18] = fma52lo(res[18], a[2], a[16]);  // Sum(18)
  res[19] = fma52hi(res[19], a[2], a[16]);  // Sum(18)
  res[19] = fma52lo(res[19], a[3], a[16]);  // Sum(19)
  res[20] = fma52hi(res[20], a[3], a[16]);  // Sum(19)
  res[20] = fma52lo(res[20], a[4], a[16]);  // Sum(20)
  res[21] = fma52hi(res[21], a[4], a[16]);  // Sum(20)
  res[21] = fma52lo(res[21], a[5], a[16]);  // Sum(21)
  res[22] = fma52hi(res[22], a[5], a[16]);  // Sum(21)
  res[22] = fma52lo(res[22], a[6], a[16]);  // Sum(22)
  res[23] = fma52hi(res[23], a[6], a[16]);  // Sum(22)
  res[23] = fma52lo(res[23], a[7], a[16]);  // Sum(23)
  res[24] = fma52hi(res[24], a[7], a[16]);  // Sum(23)
  res[17] = fma52lo(res[17], a[0], a[17]);  // Sum(17)
  res[18] = fma52hi(res[18], a[0], a[17]);  // Sum(17)
  res[18] = fma52lo(res[18], a[1], a[17]);  // Sum(18)
  res[19] = fma52hi(res[19], a[1], a[17]);  // Sum(18)
  res[19] = fma52lo(res[19], a[2], a[17]);  // Sum(19)
  res[20] = fma52hi(res[20], a[2], a[17]);  // Sum(19)
  res[20] = fma52lo(res[20], a[3], a[17]);  // Sum(20)
  res[21] = fma52hi(res[21], a[3], a[17]);  // Sum(20)
  res[21] = fma52lo(res[21], a[4], a[17]);  // Sum(21)
  res[22] = fma52hi(res[22], a[4], a[17]);  // Sum(21)
  res[22] = fma52lo(res[22], a[5], a[17]);  // Sum(22)
  res[23] = fma52hi(res[23], a[5], a[17]);  // Sum(22)
  res[23] = fma52lo(res[23], a[6], a[17]);  // Sum(23)
  res[24] = fma52hi(res[24], a[6], a[17]);  // Sum(23)
  res[18] = fma52lo(res[18], a[0], a[18]);  // Sum(18)
  res[19] = fma52hi(res[19], a[0], a[18]);  // Sum(18)
  res[19] = fma52lo(res[19], a[1], a[18]);  // Sum(19)
  res[20] = fma52hi(res[20], a[1], a[18]);  // Sum(19)
  res[20] = fma52lo(res[20], a[2], a[18]);  // Sum(20)
  res[21] = fma52hi(res[21], a[2], a[18]);  // Sum(20)
  res[21] = fma52lo(res[21], a[3], a[18]);  // Sum(21)
  res[22] = fma52hi(res[22], a[3], a[18]);  // Sum(21)
  res[22] = fma52lo(res[22], a[4], a[18]);  // Sum(22)
  res[23] = fma52hi(res[23], a[4], a[18]);  // Sum(22)
  res[23] = fma52lo(res[23], a[5], a[18]);  // Sum(23)
  res[24] = fma52hi(res[24], a[5], a[18]);  // Sum(23)
  res[19] = fma52lo(res[19], a[0], a[19]);  // Sum(19)
  res[20] = fma52hi(res[20], a[0], a[19]);  // Sum(19)
  res[20] = fma52lo(res[20], a[1], a[19]);  // Sum(20)
  res[21] = fma52hi(res[21], a[1], a[19]);  // Sum(20)
  res[21] = fma52lo(res[21], a[2], a[19]);  // Sum(21)
  res[22] = fma52hi(res[22], a[2], a[19]);  // Sum(21)
  res[22] = fma52lo(res[22], a[3], a[19]);  // Sum(22)
  res[23] = fma52hi(res[23], a[3], a[19]);  // Sum(22)
  res[23] = fma52lo(res[23], a[4], a[19]);  // Sum(23)
  res[24] = fma52hi(res[24], a[4], a[19]);  // Sum(23)
  res[20] = fma52lo(res[20], a[0], a[20]);  // Sum(20)
  res[21] = fma52hi(res[21], a[0], a[20]);  // Sum(20)
  res[21] = fma52lo(res[21], a[1], a[20]);  // Sum(21)
  res[22] = fma52hi(res[22], a[1], a[20]);  // Sum(21)
  res[22] = fma52lo(res[22], a[2], a[20]);  // Sum(22)
  res[23] = fma52hi(res[23], a[2], a[20]);  // Sum(22)
  res[23] = fma52lo(res[23], a[3], a[20]);  // Sum(23)
  res[24] = fma52hi(res[24], a[3], a[20]);  // Sum(23)
  res[21] = fma52lo(res[21], a[0], a[21]);  // Sum(21)
  res[22] = fma52hi(res[22], a[0], a[21]);  // Sum(21)
  res[22] = fma52lo(res[22], a[1], a[21]);  // Sum(22)
  res[23] = fma52hi(res[23], a[1], a[21]);  // Sum(22)
  res[23] = fma52lo(res[23], a[2], a[21]);  // Sum(23)
  res[24] = fma52hi(res[24], a[2], a[21]);  // Sum(23)
  res[22] = fma52lo(res[22], a[0], a[22]);  // Sum(22)
  res[23] = fma52hi(res[23], a[0], a[22]);  // Sum(22)
  res[23] = fma52lo(res[23], a[1], a[22]);  // Sum(23)
  res[24] = fma52hi(res[24], a[1], a[22]);  // Sum(23)
  res[23] = fma52lo(res[23], a[0], a[23]);  // Sum(23)
  res[24] = fma52hi(res[24], a[0], a[23]);  // Sum(23)
  res[12] = add64(res[12], res[12]);        // Double(12)
  res[13] = add64(res[13], res[13]);        // Double(13)
  res[14] = add64(res[14], res[14]);        // Double(14)
  res[15] = add64(res[15], res[15]);        // Double(15)
  res[16] = add64(res[16], res[16]);        // Double(16)
  res[17] = add64(res[17], res[17]);        // Double(17)
  res[18] = add64(res[18], res[18]);        // Double(18)
  res[19] = add64(res[19], res[19]);        // Double(19)
  res[20] = add64(res[20], res[20]);        // Double(20)
  res[21] = add64(res[21], res[21]);        // Double(21)
  res[22] = add64(res[22], res[22]);        // Double(22)
  res[23] = add64(res[23], res[23]);        // Double(23)
  res[12] = fma52lo(res[12], a[6], a[6]);   // Add sqr(12)
  res[13] = fma52hi(res[13], a[6], a[6]);   // Add sqr(12)
  res[14] = fma52lo(res[14], a[7], a[7]);   // Add sqr(14)
  res[15] = fma52hi(res[15], a[7], a[7]);   // Add sqr(14)
  res[16] = fma52lo(res[16], a[8], a[8]);   // Add sqr(16)
  res[17] = fma52hi(res[17], a[8], a[8]);   // Add sqr(16)
  res[18] = fma52lo(res[18], a[9], a[9]);   // Add sqr(18)
  res[19] = fma52hi(res[19], a[9], a[9]);   // Add sqr(18)
  res[20] = fma52lo(res[20], a[10], a[10]); // Add sqr(20)
  res[21] = fma52hi(res[21], a[10], a[10]); // Add sqr(20)
  res[22] = fma52lo(res[22], a[11], a[11]); // Add sqr(22)
  res[23] = fma52hi(res[23], a[11], a[11]); // Add sqr(22)
  res[24] = fma52lo(res[24], a[11], a[13]); // Sum(24)
  res[25] = fma52hi(res[25], a[11], a[13]); // Sum(24)
  res[25] = fma52lo(res[25], a[12], a[13]); // Sum(25)
  res[26] = fma52hi(res[26], a[12], a[13]); // Sum(25)
  res[24] = fma52lo(res[24], a[10], a[14]); // Sum(24)
  res[25] = fma52hi(res[25], a[10], a[14]); // Sum(24)
  res[25] = fma52lo(res[25], a[11], a[14]); // Sum(25)
  res[26] = fma52hi(res[26], a[11], a[14]); // Sum(25)
  res[26] = fma52lo(res[26], a[12], a[14]); // Sum(26)
  res[27] = fma52hi(res[27], a[12], a[14]); // Sum(26)
  res[27] = fma52lo(res[27], a[13], a[14]); // Sum(27)
  res[28] = fma52hi(res[28], a[13], a[14]); // Sum(27)
  res[24] = fma52lo(res[24], a[9], a[15]);  // Sum(24)
  res[25] = fma52hi(res[25], a[9], a[15]);  // Sum(24)
  res[25] = fma52lo(res[25], a[10], a[15]); // Sum(25)
  res[26] = fma52hi(res[26], a[10], a[15]); // Sum(25)
  res[26] = fma52lo(res[26], a[11], a[15]); // Sum(26)
  res[27] = fma52hi(res[27], a[11], a[15]); // Sum(26)
  res[27] = fma52lo(res[27], a[12], a[15]); // Sum(27)
  res[28] = fma52hi(res[28], a[12], a[15]); // Sum(27)
  res[28] = fma52lo(res[28], a[13], a[15]); // Sum(28)
  res[29] = fma52hi(res[29], a[13], a[15]); // Sum(28)
  res[29] = fma52lo(res[29], a[14], a[15]); // Sum(29)
  res[30] = fma52hi(res[30], a[14], a[15]); // Sum(29)
  res[24] = fma52lo(res[24], a[8], a[16]);  // Sum(24)
  res[25] = fma52hi(res[25], a[8], a[16]);  // Sum(24)
  res[25] = fma52lo(res[25], a[9], a[16]);  // Sum(25)
  res[26] = fma52hi(res[26], a[9], a[16]);  // Sum(25)
  res[26] = fma52lo(res[26], a[10], a[16]); // Sum(26)
  res[27] = fma52hi(res[27], a[10], a[16]); // Sum(26)
  res[27] = fma52lo(res[27], a[11], a[16]); // Sum(27)
  res[28] = fma52hi(res[28], a[11], a[16]); // Sum(27)
  res[28] = fma52lo(res[28], a[12], a[16]); // Sum(28)
  res[29] = fma52hi(res[29], a[12], a[16]); // Sum(28)
  res[29] = fma52lo(res[29], a[13], a[16]); // Sum(29)
  res[30] = fma52hi(res[30], a[13], a[16]); // Sum(29)
  res[30] = fma52lo(res[30], a[14], a[16]); // Sum(30)
  res[31] = fma52hi(res[31], a[14], a[16]); // Sum(30)
  res[31] = fma52lo(res[31], a[15], a[16]); // Sum(31)
  res[32] = fma52hi(res[32], a[15], a[16]); // Sum(31)
  res[24] = fma52lo(res[24], a[7], a[17]);  // Sum(24)
  res[25] = fma52hi(res[25], a[7], a[17]);  // Sum(24)
  res[25] = fma52lo(res[25], a[8], a[17]);  // Sum(25)
  res[26] = fma52hi(res[26], a[8], a[17]);  // Sum(25)
  res[26] = fma52lo(res[26], a[9], a[17]);  // Sum(26)
  res[27] = fma52hi(res[27], a[9], a[17]);  // Sum(26)
  res[27] = fma52lo(res[27], a[10], a[17]); // Sum(27)
  res[28] = fma52hi(res[28], a[10], a[17]); // Sum(27)
  res[28] = fma52lo(res[28], a[11], a[17]); // Sum(28)
  res[29] = fma52hi(res[29], a[11], a[17]); // Sum(28)
  res[29] = fma52lo(res[29], a[12], a[17]); // Sum(29)
  res[30] = fma52hi(res[30], a[12], a[17]); // Sum(29)
  res[30] = fma52lo(res[30], a[13], a[17]); // Sum(30)
  res[31] = fma52hi(res[31], a[13], a[17]); // Sum(30)
  res[31] = fma52lo(res[31], a[14], a[17]); // Sum(31)
  res[32] = fma52hi(res[32], a[14], a[17]); // Sum(31)
  res[32] = fma52lo(res[32], a[15], a[17]); // Sum(32)
  res[33] = fma52hi(res[33], a[15], a[17]); // Sum(32)
  res[33] = fma52lo(res[33], a[16], a[17]); // Sum(33)
  res[34] = fma52hi(res[34], a[16], a[17]); // Sum(33)
  res[24] = fma52lo(res[24], a[6], a[18]);  // Sum(24)
  res[25] = fma52hi(res[25], a[6], a[18]);  // Sum(24)
  res[25] = fma52lo(res[25], a[7], a[18]);  // Sum(25)
  res[26] = fma52hi(res[26], a[7], a[18]);  // Sum(25)
  res[26] = fma52lo(res[26], a[8], a[18]);  // Sum(26)
  res[27] = fma52hi(res[27], a[8], a[18]);  // Sum(26)
  res[27] = fma52lo(res[27], a[9], a[18]);  // Sum(27)
  res[28] = fma52hi(res[28], a[9], a[18]);  // Sum(27)
  res[28] = fma52lo(res[28], a[10], a[18]); // Sum(28)
  res[29] = fma52hi(res[29], a[10], a[18]); // Sum(28)
  res[29] = fma52lo(res[29], a[11], a[18]); // Sum(29)
  res[30] = fma52hi(res[30], a[11], a[18]); // Sum(29)
  res[30] = fma52lo(res[30], a[12], a[18]); // Sum(30)
  res[31] = fma52hi(res[31], a[12], a[18]); // Sum(30)
  res[31] = fma52lo(res[31], a[13], a[18]); // Sum(31)
  res[32] = fma52hi(res[32], a[13], a[18]); // Sum(31)
  res[32] = fma52lo(res[32], a[14], a[18]); // Sum(32)
  res[33] = fma52hi(res[33], a[14], a[18]); // Sum(32)
  res[33] = fma52lo(res[33], a[15], a[18]); // Sum(33)
  res[34] = fma52hi(res[34], a[15], a[18]); // Sum(33)
  res[34] = fma52lo(res[34], a[16], a[18]); // Sum(34)
  res[35] = fma52hi(res[35], a[16], a[18]); // Sum(34)
  res[35] = fma52lo(res[35], a[17], a[18]); // Sum(35)
  res[36] = fma52hi(res[36], a[17], a[18]); // Sum(35)
  res[24] = fma52lo(res[24], a[5], a[19]);  // Sum(24)
  res[25] = fma52hi(res[25], a[5], a[19]);  // Sum(24)
  res[25] = fma52lo(res[25], a[6], a[19]);  // Sum(25)
  res[26] = fma52hi(res[26], a[6], a[19]);  // Sum(25)
  res[26] = fma52lo(res[26], a[7], a[19]);  // Sum(26)
  res[27] = fma52hi(res[27], a[7], a[19]);  // Sum(26)
  res[27] = fma52lo(res[27], a[8], a[19]);  // Sum(27)
  res[28] = fma52hi(res[28], a[8], a[19]);  // Sum(27)
  res[28] = fma52lo(res[28], a[9], a[19]);  // Sum(28)
  res[29] = fma52hi(res[29], a[9], a[19]);  // Sum(28)
  res[29] = fma52lo(res[29], a[10], a[19]); // Sum(29)
  res[30] = fma52hi(res[30], a[10], a[19]); // Sum(29)
  res[30] = fma52lo(res[30], a[11], a[19]); // Sum(30)
  res[31] = fma52hi(res[31], a[11], a[19]); // Sum(30)
  res[31] = fma52lo(res[31], a[12], a[19]); // Sum(31)
  res[32] = fma52hi(res[32], a[12], a[19]); // Sum(31)
  res[32] = fma52lo(res[32], a[13], a[19]); // Sum(32)
  res[33] = fma52hi(res[33], a[13], a[19]); // Sum(32)
  res[33] = fma52lo(res[33], a[14], a[19]); // Sum(33)
  res[34] = fma52hi(res[34], a[14], a[19]); // Sum(33)
  res[34] = fma52lo(res[34], a[15], a[19]); // Sum(34)
  res[35] = fma52hi(res[35], a[15], a[19]); // Sum(34)
  res[35] = fma52lo(res[35], a[16], a[19]); // Sum(35)
  res[36] = fma52hi(res[36], a[16], a[19]); // Sum(35)
  res[24] = fma52lo(res[24], a[4], a[20]);  // Sum(24)
  res[25] = fma52hi(res[25], a[4], a[20]);  // Sum(24)
  res[25] = fma52lo(res[25], a[5], a[20]);  // Sum(25)
  res[26] = fma52hi(res[26], a[5], a[20]);  // Sum(25)
  res[26] = fma52lo(res[26], a[6], a[20]);  // Sum(26)
  res[27] = fma52hi(res[27], a[6], a[20]);  // Sum(26)
  res[27] = fma52lo(res[27], a[7], a[20]);  // Sum(27)
  res[28] = fma52hi(res[28], a[7], a[20]);  // Sum(27)
  res[28] = fma52lo(res[28], a[8], a[20]);  // Sum(28)
  res[29] = fma52hi(res[29], a[8], a[20]);  // Sum(28)
  res[29] = fma52lo(res[29], a[9], a[20]);  // Sum(29)
  res[30] = fma52hi(res[30], a[9], a[20]);  // Sum(29)
  res[30] = fma52lo(res[30], a[10], a[20]); // Sum(30)
  res[31] = fma52hi(res[31], a[10], a[20]); // Sum(30)
  res[31] = fma52lo(res[31], a[11], a[20]); // Sum(31)
  res[32] = fma52hi(res[32], a[11], a[20]); // Sum(31)
  res[32] = fma52lo(res[32], a[12], a[20]); // Sum(32)
  res[33] = fma52hi(res[33], a[12], a[20]); // Sum(32)
  res[33] = fma52lo(res[33], a[13], a[20]); // Sum(33)
  res[34] = fma52hi(res[34], a[13], a[20]); // Sum(33)
  res[34] = fma52lo(res[34], a[14], a[20]); // Sum(34)
  res[35] = fma52hi(res[35], a[14], a[20]); // Sum(34)
  res[35] = fma52lo(res[35], a[15], a[20]); // Sum(35)
  res[36] = fma52hi(res[36], a[15], a[20]); // Sum(35)
  res[24] = fma52lo(res[24], a[3], a[21]);  // Sum(24)
  res[25] = fma52hi(res[25], a[3], a[21]);  // Sum(24)
  res[25] = fma52lo(res[25], a[4], a[21]);  // Sum(25)
  res[26] = fma52hi(res[26], a[4], a[21]);  // Sum(25)
  res[26] = fma52lo(res[26], a[5], a[21]);  // Sum(26)
  res[27] = fma52hi(res[27], a[5], a[21]);  // Sum(26)
  res[27] = fma52lo(res[27], a[6], a[21]);  // Sum(27)
  res[28] = fma52hi(res[28], a[6], a[21]);  // Sum(27)
  res[28] = fma52lo(res[28], a[7], a[21]);  // Sum(28)
  res[29] = fma52hi(res[29], a[7], a[21]);  // Sum(28)
  res[29] = fma52lo(res[29], a[8], a[21]);  // Sum(29)
  res[30] = fma52hi(res[30], a[8], a[21]);  // Sum(29)
  res[30] = fma52lo(res[30], a[9], a[21]);  // Sum(30)
  res[31] = fma52hi(res[31], a[9], a[21]);  // Sum(30)
  res[31] = fma52lo(res[31], a[10], a[21]); // Sum(31)
  res[32] = fma52hi(res[32], a[10], a[21]); // Sum(31)
  res[32] = fma52lo(res[32], a[11], a[21]); // Sum(32)
  res[33] = fma52hi(res[33], a[11], a[21]); // Sum(32)
  res[33] = fma52lo(res[33], a[12], a[21]); // Sum(33)
  res[34] = fma52hi(res[34], a[12], a[21]); // Sum(33)
  res[34] = fma52lo(res[34], a[13], a[21]); // Sum(34)
  res[35] = fma52hi(res[35], a[13], a[21]); // Sum(34)
  res[35] = fma52lo(res[35], a[14], a[21]); // Sum(35)
  res[36] = fma52hi(res[36], a[14], a[21]); // Sum(35)
  res[24] = fma52lo(res[24], a[2], a[22]);  // Sum(24)
  res[25] = fma52hi(res[25], a[2], a[22]);  // Sum(24)
  res[25] = fma52lo(res[25], a[3], a[22]);  // Sum(25)
  res[26] = fma52hi(res[26], a[3], a[22]);  // Sum(25)
  res[26] = fma52lo(res[26], a[4], a[22]);  // Sum(26)
  res[27] = fma52hi(res[27], a[4], a[22]);  // Sum(26)
  res[27] = fma52lo(res[27], a[5], a[22]);  // Sum(27)
  res[28] = fma52hi(res[28], a[5], a[22]);  // Sum(27)
  res[28] = fma52lo(res[28], a[6], a[22]);  // Sum(28)
  res[29] = fma52hi(res[29], a[6], a[22]);  // Sum(28)
  res[29] = fma52lo(res[29], a[7], a[22]);  // Sum(29)
  res[30] = fma52hi(res[30], a[7], a[22]);  // Sum(29)
  res[30] = fma52lo(res[30], a[8], a[22]);  // Sum(30)
  res[31] = fma52hi(res[31], a[8], a[22]);  // Sum(30)
  res[31] = fma52lo(res[31], a[9], a[22]);  // Sum(31)
  res[32] = fma52hi(res[32], a[9], a[22]);  // Sum(31)
  res[32] = fma52lo(res[32], a[10], a[22]); // Sum(32)
  res[33] = fma52hi(res[33], a[10], a[22]); // Sum(32)
  res[33] = fma52lo(res[33], a[11], a[22]); // Sum(33)
  res[34] = fma52hi(res[34], a[11], a[22]); // Sum(33)
  res[34] = fma52lo(res[34], a[12], a[22]); // Sum(34)
  res[35] = fma52hi(res[35], a[12], a[22]); // Sum(34)
  res[35] = fma52lo(res[35], a[13], a[22]); // Sum(35)
  res[36] = fma52hi(res[36], a[13], a[22]); // Sum(35)
  res[24] = fma52lo(res[24], a[1], a[23]);  // Sum(24)
  res[25] = fma52hi(res[25], a[1], a[23]);  // Sum(24)
  res[25] = fma52lo(res[25], a[2], a[23]);  // Sum(25)
  res[26] = fma52hi(res[26], a[2], a[23]);  // Sum(25)
  res[26] = fma52lo(res[26], a[3], a[23]);  // Sum(26)
  res[27] = fma52hi(res[27], a[3], a[23]);  // Sum(26)
  res[27] = fma52lo(res[27], a[4], a[23]);  // Sum(27)
  res[28] = fma52hi(res[28], a[4], a[23]);  // Sum(27)
  res[28] = fma52lo(res[28], a[5], a[23]);  // Sum(28)
  res[29] = fma52hi(res[29], a[5], a[23]);  // Sum(28)
  res[29] = fma52lo(res[29], a[6], a[23]);  // Sum(29)
  res[30] = fma52hi(res[30], a[6], a[23]);  // Sum(29)
  res[30] = fma52lo(res[30], a[7], a[23]);  // Sum(30)
  res[31] = fma52hi(res[31], a[7], a[23]);  // Sum(30)
  res[31] = fma52lo(res[31], a[8], a[23]);  // Sum(31)
  res[32] = fma52hi(res[32], a[8], a[23]);  // Sum(31)
  res[32] = fma52lo(res[32], a[9], a[23]);  // Sum(32)
  res[33] = fma52hi(res[33], a[9], a[23]);  // Sum(32)
  res[33] = fma52lo(res[33], a[10], a[23]); // Sum(33)
  res[34] = fma52hi(res[34], a[10], a[23]); // Sum(33)
  res[34] = fma52lo(res[34], a[11], a[23]); // Sum(34)
  res[35] = fma52hi(res[35], a[11], a[23]); // Sum(34)
  res[35] = fma52lo(res[35], a[12], a[23]); // Sum(35)
  res[36] = fma52hi(res[36], a[12], a[23]); // Sum(35)
  res[24] = fma52lo(res[24], a[0], a[24]);  // Sum(24)
  res[25] = fma52hi(res[25], a[0], a[24]);  // Sum(24)
  res[25] = fma52lo(res[25], a[1], a[24]);  // Sum(25)
  res[26] = fma52hi(res[26], a[1], a[24]);  // Sum(25)
  res[26] = fma52lo(res[26], a[2], a[24]);  // Sum(26)
  res[27] = fma52hi(res[27], a[2], a[24]);  // Sum(26)
  res[27] = fma52lo(res[27], a[3], a[24]);  // Sum(27)
  res[28] = fma52hi(res[28], a[3], a[24]);  // Sum(27)
  res[28] = fma52lo(res[28], a[4], a[24]);  // Sum(28)
  res[29] = fma52hi(res[29], a[4], a[24]);  // Sum(28)
  res[29] = fma52lo(res[29], a[5], a[24]);  // Sum(29)
  res[30] = fma52hi(res[30], a[5], a[24]);  // Sum(29)
  res[30] = fma52lo(res[30], a[6], a[24]);  // Sum(30)
  res[31] = fma52hi(res[31], a[6], a[24]);  // Sum(30)
  res[31] = fma52lo(res[31], a[7], a[24]);  // Sum(31)
  res[32] = fma52hi(res[32], a[7], a[24]);  // Sum(31)
  res[32] = fma52lo(res[32], a[8], a[24]);  // Sum(32)
  res[33] = fma52hi(res[33], a[8], a[24]);  // Sum(32)
  res[33] = fma52lo(res[33], a[9], a[24]);  // Sum(33)
  res[34] = fma52hi(res[34], a[9], a[24]);  // Sum(33)
  res[34] = fma52lo(res[34], a[10], a[24]); // Sum(34)
  res[35] = fma52hi(res[35], a[10], a[24]); // Sum(34)
  res[35] = fma52lo(res[35], a[11], a[24]); // Sum(35)
  res[36] = fma52hi(res[36], a[11], a[24]); // Sum(35)
  res[25] = fma52lo(res[25], a[0], a[25]);  // Sum(25)
  res[26] = fma52hi(res[26], a[0], a[25]);  // Sum(25)
  res[26] = fma52lo(res[26], a[1], a[25]);  // Sum(26)
  res[27] = fma52hi(res[27], a[1], a[25]);  // Sum(26)
  res[27] = fma52lo(res[27], a[2], a[25]);  // Sum(27)
  res[28] = fma52hi(res[28], a[2], a[25]);  // Sum(27)
  res[28] = fma52lo(res[28], a[3], a[25]);  // Sum(28)
  res[29] = fma52hi(res[29], a[3], a[25]);  // Sum(28)
  res[29] = fma52lo(res[29], a[4], a[25]);  // Sum(29)
  res[30] = fma52hi(res[30], a[4], a[25]);  // Sum(29)
  res[30] = fma52lo(res[30], a[5], a[25]);  // Sum(30)
  res[31] = fma52hi(res[31], a[5], a[25]);  // Sum(30)
  res[31] = fma52lo(res[31], a[6], a[25]);  // Sum(31)
  res[32] = fma52hi(res[32], a[6], a[25]);  // Sum(31)
  res[32] = fma52lo(res[32], a[7], a[25]);  // Sum(32)
  res[33] = fma52hi(res[33], a[7], a[25]);  // Sum(32)
  res[33] = fma52lo(res[33], a[8], a[25]);  // Sum(33)
  res[34] = fma52hi(res[34], a[8], a[25]);  // Sum(33)
  res[34] = fma52lo(res[34], a[9], a[25]);  // Sum(34)
  res[35] = fma52hi(res[35], a[9], a[25]);  // Sum(34)
  res[35] = fma52lo(res[35], a[10], a[25]); // Sum(35)
  res[36] = fma52hi(res[36], a[10], a[25]); // Sum(35)
  res[26] = fma52lo(res[26], a[0], a[26]);  // Sum(26)
  res[27] = fma52hi(res[27], a[0], a[26]);  // Sum(26)
  res[27] = fma52lo(res[27], a[1], a[26]);  // Sum(27)
  res[28] = fma52hi(res[28], a[1], a[26]);  // Sum(27)
  res[28] = fma52lo(res[28], a[2], a[26]);  // Sum(28)
  res[29] = fma52hi(res[29], a[2], a[26]);  // Sum(28)
  res[29] = fma52lo(res[29], a[3], a[26]);  // Sum(29)
  res[30] = fma52hi(res[30], a[3], a[26]);  // Sum(29)
  res[30] = fma52lo(res[30], a[4], a[26]);  // Sum(30)
  res[31] = fma52hi(res[31], a[4], a[26]);  // Sum(30)
  res[31] = fma52lo(res[31], a[5], a[26]);  // Sum(31)
  res[32] = fma52hi(res[32], a[5], a[26]);  // Sum(31)
  res[32] = fma52lo(res[32], a[6], a[26]);  // Sum(32)
  res[33] = fma52hi(res[33], a[6], a[26]);  // Sum(32)
  res[33] = fma52lo(res[33], a[7], a[26]);  // Sum(33)
  res[34] = fma52hi(res[34], a[7], a[26]);  // Sum(33)
  res[34] = fma52lo(res[34], a[8], a[26]);  // Sum(34)
  res[35] = fma52hi(res[35], a[8], a[26]);  // Sum(34)
  res[35] = fma52lo(res[35], a[9], a[26]);  // Sum(35)
  res[36] = fma52hi(res[36], a[9], a[26]);  // Sum(35)
  res[27] = fma52lo(res[27], a[0], a[27]);  // Sum(27)
  res[28] = fma52hi(res[28], a[0], a[27]);  // Sum(27)
  res[28] = fma52lo(res[28], a[1], a[27]);  // Sum(28)
  res[29] = fma52hi(res[29], a[1], a[27]);  // Sum(28)
  res[29] = fma52lo(res[29], a[2], a[27]);  // Sum(29)
  res[30] = fma52hi(res[30], a[2], a[27]);  // Sum(29)
  res[30] = fma52lo(res[30], a[3], a[27]);  // Sum(30)
  res[31] = fma52hi(res[31], a[3], a[27]);  // Sum(30)
  res[31] = fma52lo(res[31], a[4], a[27]);  // Sum(31)
  res[32] = fma52hi(res[32], a[4], a[27]);  // Sum(31)
  res[32] = fma52lo(res[32], a[5], a[27]);  // Sum(32)
  res[33] = fma52hi(res[33], a[5], a[27]);  // Sum(32)
  res[33] = fma52lo(res[33], a[6], a[27]);  // Sum(33)
  res[34] = fma52hi(res[34], a[6], a[27]);  // Sum(33)
  res[34] = fma52lo(res[34], a[7], a[27]);  // Sum(34)
  res[35] = fma52hi(res[35], a[7], a[27]);  // Sum(34)
  res[35] = fma52lo(res[35], a[8], a[27]);  // Sum(35)
  res[36] = fma52hi(res[36], a[8], a[27]);  // Sum(35)
  res[28] = fma52lo(res[28], a[0], a[28]);  // Sum(28)
  res[29] = fma52hi(res[29], a[0], a[28]);  // Sum(28)
  res[29] = fma52lo(res[29], a[1], a[28]);  // Sum(29)
  res[30] = fma52hi(res[30], a[1], a[28]);  // Sum(29)
  res[30] = fma52lo(res[30], a[2], a[28]);  // Sum(30)
  res[31] = fma52hi(res[31], a[2], a[28]);  // Sum(30)
  res[31] = fma52lo(res[31], a[3], a[28]);  // Sum(31)
  res[32] = fma52hi(res[32], a[3], a[28]);  // Sum(31)
  res[32] = fma52lo(res[32], a[4], a[28]);  // Sum(32)
  res[33] = fma52hi(res[33], a[4], a[28]);  // Sum(32)
  res[33] = fma52lo(res[33], a[5], a[28]);  // Sum(33)
  res[34] = fma52hi(res[34], a[5], a[28]);  // Sum(33)
  res[34] = fma52lo(res[34], a[6], a[28]);  // Sum(34)
  res[35] = fma52hi(res[35], a[6], a[28]);  // Sum(34)
  res[35] = fma52lo(res[35], a[7], a[28]);  // Sum(35)
  res[36] = fma52hi(res[36], a[7], a[28]);  // Sum(35)
  res[29] = fma52lo(res[29], a[0], a[29]);  // Sum(29)
  res[30] = fma52hi(res[30], a[0], a[29]);  // Sum(29)
  res[30] = fma52lo(res[30], a[1], a[29]);  // Sum(30)
  res[31] = fma52hi(res[31], a[1], a[29]);  // Sum(30)
  res[31] = fma52lo(res[31], a[2], a[29]);  // Sum(31)
  res[32] = fma52hi(res[32], a[2], a[29]);  // Sum(31)
  res[32] = fma52lo(res[32], a[3], a[29]);  // Sum(32)
  res[33] = fma52hi(res[33], a[3], a[29]);  // Sum(32)
  res[33] = fma52lo(res[33], a[4], a[29]);  // Sum(33)
  res[34] = fma52hi(res[34], a[4], a[29]);  // Sum(33)
  res[34] = fma52lo(res[34], a[5], a[29]);  // Sum(34)
  res[35] = fma52hi(res[35], a[5], a[29]);  // Sum(34)
  res[35] = fma52lo(res[35], a[6], a[29]);  // Sum(35)
  res[36] = fma52hi(res[36], a[6], a[29]);  // Sum(35)
  res[24] = add64(res[24], res[24]);        // Double(24)
  res[25] = add64(res[25], res[25]);        // Double(25)
  res[26] = add64(res[26], res[26]);        // Double(26)
  res[27] = add64(res[27], res[27]);        // Double(27)
  res[28] = add64(res[28], res[28]);        // Double(28)
  res[29] = add64(res[29], res[29]);        // Double(29)
  res[30] = add64(res[30], res[30]);        // Double(30)
  res[31] = add64(res[31], res[31]);        // Double(31)
  res[32] = add64(res[32], res[32]);        // Double(32)
  res[33] = add64(res[33], res[33]);        // Double(33)
  res[34] = add64(res[34], res[34]);        // Double(34)
  res[35] = add64(res[35], res[35]);        // Double(35)
  res[24] = fma52lo(res[24], a[12], a[12]); // Add sqr(24)
  res[25] = fma52hi(res[25], a[12], a[12]); // Add sqr(24)
  res[26] = fma52lo(res[26], a[13], a[13]); // Add sqr(26)
  res[27] = fma52hi(res[27], a[13], a[13]); // Add sqr(26)
  res[28] = fma52lo(res[28], a[14], a[14]); // Add sqr(28)
  res[29] = fma52hi(res[29], a[14], a[14]); // Add sqr(28)
  res[30] = fma52lo(res[30], a[15], a[15]); // Add sqr(30)
  res[31] = fma52hi(res[31], a[15], a[15]); // Add sqr(30)
  res[32] = fma52lo(res[32], a[16], a[16]); // Add sqr(32)
  res[33] = fma52hi(res[33], a[16], a[16]); // Add sqr(32)
  res[34] = fma52lo(res[34], a[17], a[17]); // Add sqr(34)
  res[35] = fma52hi(res[35], a[17], a[17]); // Add sqr(34)
  res[36] = fma52lo(res[36], a[17], a[19]); // Sum(36)
  res[37] = fma52hi(res[37], a[17], a[19]); // Sum(36)
  res[37] = fma52lo(res[37], a[18], a[19]); // Sum(37)
  res[38] = fma52hi(res[38], a[18], a[19]); // Sum(37)
  res[36] = fma52lo(res[36], a[16], a[20]); // Sum(36)
  res[37] = fma52hi(res[37], a[16], a[20]); // Sum(36)
  res[37] = fma52lo(res[37], a[17], a[20]); // Sum(37)
  res[38] = fma52hi(res[38], a[17], a[20]); // Sum(37)
  res[38] = fma52lo(res[38], a[18], a[20]); // Sum(38)
  res[39] = fma52hi(res[39], a[18], a[20]); // Sum(38)
  res[39] = fma52lo(res[39], a[19], a[20]); // Sum(39)
  res[40] = fma52hi(res[40], a[19], a[20]); // Sum(39)
  res[36] = fma52lo(res[36], a[15], a[21]); // Sum(36)
  res[37] = fma52hi(res[37], a[15], a[21]); // Sum(36)
  res[37] = fma52lo(res[37], a[16], a[21]); // Sum(37)
  res[38] = fma52hi(res[38], a[16], a[21]); // Sum(37)
  res[38] = fma52lo(res[38], a[17], a[21]); // Sum(38)
  res[39] = fma52hi(res[39], a[17], a[21]); // Sum(38)
  res[39] = fma52lo(res[39], a[18], a[21]); // Sum(39)
  res[40] = fma52hi(res[40], a[18], a[21]); // Sum(39)
  res[40] = fma52lo(res[40], a[19], a[21]); // Sum(40)
  res[41] = fma52hi(res[41], a[19], a[21]); // Sum(40)
  res[41] = fma52lo(res[41], a[20], a[21]); // Sum(41)
  res[42] = fma52hi(res[42], a[20], a[21]); // Sum(41)
  res[36] = fma52lo(res[36], a[14], a[22]); // Sum(36)
  res[37] = fma52hi(res[37], a[14], a[22]); // Sum(36)
  res[37] = fma52lo(res[37], a[15], a[22]); // Sum(37)
  res[38] = fma52hi(res[38], a[15], a[22]); // Sum(37)
  res[38] = fma52lo(res[38], a[16], a[22]); // Sum(38)
  res[39] = fma52hi(res[39], a[16], a[22]); // Sum(38)
  res[39] = fma52lo(res[39], a[17], a[22]); // Sum(39)
  res[40] = fma52hi(res[40], a[17], a[22]); // Sum(39)
  res[40] = fma52lo(res[40], a[18], a[22]); // Sum(40)
  res[41] = fma52hi(res[41], a[18], a[22]); // Sum(40)
  res[41] = fma52lo(res[41], a[19], a[22]); // Sum(41)
  res[42] = fma52hi(res[42], a[19], a[22]); // Sum(41)
  res[42] = fma52lo(res[42], a[20], a[22]); // Sum(42)
  res[43] = fma52hi(res[43], a[20], a[22]); // Sum(42)
  res[43] = fma52lo(res[43], a[21], a[22]); // Sum(43)
  res[44] = fma52hi(res[44], a[21], a[22]); // Sum(43)
  res[36] = fma52lo(res[36], a[13], a[23]); // Sum(36)
  res[37] = fma52hi(res[37], a[13], a[23]); // Sum(36)
  res[37] = fma52lo(res[37], a[14], a[23]); // Sum(37)
  res[38] = fma52hi(res[38], a[14], a[23]); // Sum(37)
  res[38] = fma52lo(res[38], a[15], a[23]); // Sum(38)
  res[39] = fma52hi(res[39], a[15], a[23]); // Sum(38)
  res[39] = fma52lo(res[39], a[16], a[23]); // Sum(39)
  res[40] = fma52hi(res[40], a[16], a[23]); // Sum(39)
  res[40] = fma52lo(res[40], a[17], a[23]); // Sum(40)
  res[41] = fma52hi(res[41], a[17], a[23]); // Sum(40)
  res[41] = fma52lo(res[41], a[18], a[23]); // Sum(41)
  res[42] = fma52hi(res[42], a[18], a[23]); // Sum(41)
  res[42] = fma52lo(res[42], a[19], a[23]); // Sum(42)
  res[43] = fma52hi(res[43], a[19], a[23]); // Sum(42)
  res[43] = fma52lo(res[43], a[20], a[23]); // Sum(43)
  res[44] = fma52hi(res[44], a[20], a[23]); // Sum(43)
  res[44] = fma52lo(res[44], a[21], a[23]); // Sum(44)
  res[45] = fma52hi(res[45], a[21], a[23]); // Sum(44)
  res[45] = fma52lo(res[45], a[22], a[23]); // Sum(45)
  res[46] = fma52hi(res[46], a[22], a[23]); // Sum(45)
  res[36] = fma52lo(res[36], a[12], a[24]); // Sum(36)
  res[37] = fma52hi(res[37], a[12], a[24]); // Sum(36)
  res[37] = fma52lo(res[37], a[13], a[24]); // Sum(37)
  res[38] = fma52hi(res[38], a[13], a[24]); // Sum(37)
  res[38] = fma52lo(res[38], a[14], a[24]); // Sum(38)
  res[39] = fma52hi(res[39], a[14], a[24]); // Sum(38)
  res[39] = fma52lo(res[39], a[15], a[24]); // Sum(39)
  res[40] = fma52hi(res[40], a[15], a[24]); // Sum(39)
  res[40] = fma52lo(res[40], a[16], a[24]); // Sum(40)
  res[41] = fma52hi(res[41], a[16], a[24]); // Sum(40)
  res[41] = fma52lo(res[41], a[17], a[24]); // Sum(41)
  res[42] = fma52hi(res[42], a[17], a[24]); // Sum(41)
  res[42] = fma52lo(res[42], a[18], a[24]); // Sum(42)
  res[43] = fma52hi(res[43], a[18], a[24]); // Sum(42)
  res[43] = fma52lo(res[43], a[19], a[24]); // Sum(43)
  res[44] = fma52hi(res[44], a[19], a[24]); // Sum(43)
  res[44] = fma52lo(res[44], a[20], a[24]); // Sum(44)
  res[45] = fma52hi(res[45], a[20], a[24]); // Sum(44)
  res[45] = fma52lo(res[45], a[21], a[24]); // Sum(45)
  res[46] = fma52hi(res[46], a[21], a[24]); // Sum(45)
  res[46] = fma52lo(res[46], a[22], a[24]); // Sum(46)
  res[47] = fma52hi(res[47], a[22], a[24]); // Sum(46)
  res[47] = fma52lo(res[47], a[23], a[24]); // Sum(47)
  res[48] = fma52hi(res[48], a[23], a[24]); // Sum(47)
  res[36] = fma52lo(res[36], a[11], a[25]); // Sum(36)
  res[37] = fma52hi(res[37], a[11], a[25]); // Sum(36)
  res[37] = fma52lo(res[37], a[12], a[25]); // Sum(37)
  res[38] = fma52hi(res[38], a[12], a[25]); // Sum(37)
  res[38] = fma52lo(res[38], a[13], a[25]); // Sum(38)
  res[39] = fma52hi(res[39], a[13], a[25]); // Sum(38)
  res[39] = fma52lo(res[39], a[14], a[25]); // Sum(39)
  res[40] = fma52hi(res[40], a[14], a[25]); // Sum(39)
  res[40] = fma52lo(res[40], a[15], a[25]); // Sum(40)
  res[41] = fma52hi(res[41], a[15], a[25]); // Sum(40)
  res[41] = fma52lo(res[41], a[16], a[25]); // Sum(41)
  res[42] = fma52hi(res[42], a[16], a[25]); // Sum(41)
  res[42] = fma52lo(res[42], a[17], a[25]); // Sum(42)
  res[43] = fma52hi(res[43], a[17], a[25]); // Sum(42)
  res[43] = fma52lo(res[43], a[18], a[25]); // Sum(43)
  res[44] = fma52hi(res[44], a[18], a[25]); // Sum(43)
  res[44] = fma52lo(res[44], a[19], a[25]); // Sum(44)
  res[45] = fma52hi(res[45], a[19], a[25]); // Sum(44)
  res[45] = fma52lo(res[45], a[20], a[25]); // Sum(45)
  res[46] = fma52hi(res[46], a[20], a[25]); // Sum(45)
  res[46] = fma52lo(res[46], a[21], a[25]); // Sum(46)
  res[47] = fma52hi(res[47], a[21], a[25]); // Sum(46)
  res[47] = fma52lo(res[47], a[22], a[25]); // Sum(47)
  res[48] = fma52hi(res[48], a[22], a[25]); // Sum(47)
  res[36] = fma52lo(res[36], a[10], a[26]); // Sum(36)
  res[37] = fma52hi(res[37], a[10], a[26]); // Sum(36)
  res[37] = fma52lo(res[37], a[11], a[26]); // Sum(37)
  res[38] = fma52hi(res[38], a[11], a[26]); // Sum(37)
  res[38] = fma52lo(res[38], a[12], a[26]); // Sum(38)
  res[39] = fma52hi(res[39], a[12], a[26]); // Sum(38)
  res[39] = fma52lo(res[39], a[13], a[26]); // Sum(39)
  res[40] = fma52hi(res[40], a[13], a[26]); // Sum(39)
  res[40] = fma52lo(res[40], a[14], a[26]); // Sum(40)
  res[41] = fma52hi(res[41], a[14], a[26]); // Sum(40)
  res[41] = fma52lo(res[41], a[15], a[26]); // Sum(41)
  res[42] = fma52hi(res[42], a[15], a[26]); // Sum(41)
  res[42] = fma52lo(res[42], a[16], a[26]); // Sum(42)
  res[43] = fma52hi(res[43], a[16], a[26]); // Sum(42)
  res[43] = fma52lo(res[43], a[17], a[26]); // Sum(43)
  res[44] = fma52hi(res[44], a[17], a[26]); // Sum(43)
  res[44] = fma52lo(res[44], a[18], a[26]); // Sum(44)
  res[45] = fma52hi(res[45], a[18], a[26]); // Sum(44)
  res[45] = fma52lo(res[45], a[19], a[26]); // Sum(45)
  res[46] = fma52hi(res[46], a[19], a[26]); // Sum(45)
  res[46] = fma52lo(res[46], a[20], a[26]); // Sum(46)
  res[47] = fma52hi(res[47], a[20], a[26]); // Sum(46)
  res[47] = fma52lo(res[47], a[21], a[26]); // Sum(47)
  res[48] = fma52hi(res[48], a[21], a[26]); // Sum(47)
  res[36] = fma52lo(res[36], a[9], a[27]);  // Sum(36)
  res[37] = fma52hi(res[37], a[9], a[27]);  // Sum(36)
  res[37] = fma52lo(res[37], a[10], a[27]); // Sum(37)
  res[38] = fma52hi(res[38], a[10], a[27]); // Sum(37)
  res[38] = fma52lo(res[38], a[11], a[27]); // Sum(38)
  res[39] = fma52hi(res[39], a[11], a[27]); // Sum(38)
  res[39] = fma52lo(res[39], a[12], a[27]); // Sum(39)
  res[40] = fma52hi(res[40], a[12], a[27]); // Sum(39)
  res[40] = fma52lo(res[40], a[13], a[27]); // Sum(40)
  res[41] = fma52hi(res[41], a[13], a[27]); // Sum(40)
  res[41] = fma52lo(res[41], a[14], a[27]); // Sum(41)
  res[42] = fma52hi(res[42], a[14], a[27]); // Sum(41)
  res[42] = fma52lo(res[42], a[15], a[27]); // Sum(42)
  res[43] = fma52hi(res[43], a[15], a[27]); // Sum(42)
  res[43] = fma52lo(res[43], a[16], a[27]); // Sum(43)
  res[44] = fma52hi(res[44], a[16], a[27]); // Sum(43)
  res[44] = fma52lo(res[44], a[17], a[27]); // Sum(44)
  res[45] = fma52hi(res[45], a[17], a[27]); // Sum(44)
  res[45] = fma52lo(res[45], a[18], a[27]); // Sum(45)
  res[46] = fma52hi(res[46], a[18], a[27]); // Sum(45)
  res[46] = fma52lo(res[46], a[19], a[27]); // Sum(46)
  res[47] = fma52hi(res[47], a[19], a[27]); // Sum(46)
  res[47] = fma52lo(res[47], a[20], a[27]); // Sum(47)
  res[48] = fma52hi(res[48], a[20], a[27]); // Sum(47)
  res[36] = fma52lo(res[36], a[8], a[28]);  // Sum(36)
  res[37] = fma52hi(res[37], a[8], a[28]);  // Sum(36)
  res[37] = fma52lo(res[37], a[9], a[28]);  // Sum(37)
  res[38] = fma52hi(res[38], a[9], a[28]);  // Sum(37)
  res[38] = fma52lo(res[38], a[10], a[28]); // Sum(38)
  res[39] = fma52hi(res[39], a[10], a[28]); // Sum(38)
  res[39] = fma52lo(res[39], a[11], a[28]); // Sum(39)
  res[40] = fma52hi(res[40], a[11], a[28]); // Sum(39)
  res[40] = fma52lo(res[40], a[12], a[28]); // Sum(40)
  res[41] = fma52hi(res[41], a[12], a[28]); // Sum(40)
  res[41] = fma52lo(res[41], a[13], a[28]); // Sum(41)
  res[42] = fma52hi(res[42], a[13], a[28]); // Sum(41)
  res[42] = fma52lo(res[42], a[14], a[28]); // Sum(42)
  res[43] = fma52hi(res[43], a[14], a[28]); // Sum(42)
  res[43] = fma52lo(res[43], a[15], a[28]); // Sum(43)
  res[44] = fma52hi(res[44], a[15], a[28]); // Sum(43)
  res[44] = fma52lo(res[44], a[16], a[28]); // Sum(44)
  res[45] = fma52hi(res[45], a[16], a[28]); // Sum(44)
  res[45] = fma52lo(res[45], a[17], a[28]); // Sum(45)
  res[46] = fma52hi(res[46], a[17], a[28]); // Sum(45)
  res[46] = fma52lo(res[46], a[18], a[28]); // Sum(46)
  res[47] = fma52hi(res[47], a[18], a[28]); // Sum(46)
  res[47] = fma52lo(res[47], a[19], a[28]); // Sum(47)
  res[48] = fma52hi(res[48], a[19], a[28]); // Sum(47)
  res[36] = fma52lo(res[36], a[7], a[29]);  // Sum(36)
  res[37] = fma52hi(res[37], a[7], a[29]);  // Sum(36)
  res[37] = fma52lo(res[37], a[8], a[29]);  // Sum(37)
  res[38] = fma52hi(res[38], a[8], a[29]);  // Sum(37)
  res[38] = fma52lo(res[38], a[9], a[29]);  // Sum(38)
  res[39] = fma52hi(res[39], a[9], a[29]);  // Sum(38)
  res[39] = fma52lo(res[39], a[10], a[29]); // Sum(39)
  res[40] = fma52hi(res[40], a[10], a[29]); // Sum(39)
  res[40] = fma52lo(res[40], a[11], a[29]); // Sum(40)
  res[41] = fma52hi(res[41], a[11], a[29]); // Sum(40)
  res[41] = fma52lo(res[41], a[12], a[29]); // Sum(41)
  res[42] = fma52hi(res[42], a[12], a[29]); // Sum(41)
  res[42] = fma52lo(res[42], a[13], a[29]); // Sum(42)
  res[43] = fma52hi(res[43], a[13], a[29]); // Sum(42)
  res[43] = fma52lo(res[43], a[14], a[29]); // Sum(43)
  res[44] = fma52hi(res[44], a[14], a[29]); // Sum(43)
  res[44] = fma52lo(res[44], a[15], a[29]); // Sum(44)
  res[45] = fma52hi(res[45], a[15], a[29]); // Sum(44)
  res[45] = fma52lo(res[45], a[16], a[29]); // Sum(45)
  res[46] = fma52hi(res[46], a[16], a[29]); // Sum(45)
  res[46] = fma52lo(res[46], a[17], a[29]); // Sum(46)
  res[47] = fma52hi(res[47], a[17], a[29]); // Sum(46)
  res[47] = fma52lo(res[47], a[18], a[29]); // Sum(47)
  res[48] = fma52hi(res[48], a[18], a[29]); // Sum(47)
  res[36] = add64(res[36], res[36]);        // Double(36)
  res[37] = add64(res[37], res[37]);        // Double(37)
  res[38] = add64(res[38], res[38]);        // Double(38)
  res[39] = add64(res[39], res[39]);        // Double(39)
  res[40] = add64(res[40], res[40]);        // Double(40)
  res[41] = add64(res[41], res[41]);        // Double(41)
  res[42] = add64(res[42], res[42]);        // Double(42)
  res[43] = add64(res[43], res[43]);        // Double(43)
  res[44] = add64(res[44], res[44]);        // Double(44)
  res[45] = add64(res[45], res[45]);        // Double(45)
  res[46] = add64(res[46], res[46]);        // Double(46)
  res[47] = add64(res[47], res[47]);        // Double(47)
  res[36] = fma52lo(res[36], a[18], a[18]); // Add sqr(36)
  res[37] = fma52hi(res[37], a[18], a[18]); // Add sqr(36)
  res[38] = fma52lo(res[38], a[19], a[19]); // Add sqr(38)
  res[39] = fma52hi(res[39], a[19], a[19]); // Add sqr(38)
  res[40] = fma52lo(res[40], a[20], a[20]); // Add sqr(40)
  res[41] = fma52hi(res[41], a[20], a[20]); // Add sqr(40)
  res[42] = fma52lo(res[42], a[21], a[21]); // Add sqr(42)
  res[43] = fma52hi(res[43], a[21], a[21]); // Add sqr(42)
  res[44] = fma52lo(res[44], a[22], a[22]); // Add sqr(44)
  res[45] = fma52hi(res[45], a[22], a[22]); // Add sqr(44)
  res[46] = fma52lo(res[46], a[23], a[23]); // Add sqr(46)
  res[47] = fma52hi(res[47], a[23], a[23]); // Add sqr(46)
  res[48] = fma52lo(res[48], a[23], a[25]); // Sum(48)
  res[49] = fma52hi(res[49], a[23], a[25]); // Sum(48)
  res[49] = fma52lo(res[49], a[24], a[25]); // Sum(49)
  res[50] = fma52hi(res[50], a[24], a[25]); // Sum(49)
  res[48] = fma52lo(res[48], a[22], a[26]); // Sum(48)
  res[49] = fma52hi(res[49], a[22], a[26]); // Sum(48)
  res[49] = fma52lo(res[49], a[23], a[26]); // Sum(49)
  res[50] = fma52hi(res[50], a[23], a[26]); // Sum(49)
  res[50] = fma52lo(res[50], a[24], a[26]); // Sum(50)
  res[51] = fma52hi(res[51], a[24], a[26]); // Sum(50)
  res[51] = fma52lo(res[51], a[25], a[26]); // Sum(51)
  res[52] = fma52hi(res[52], a[25], a[26]); // Sum(51)
  res[48] = fma52lo(res[48], a[21], a[27]); // Sum(48)
  res[49] = fma52hi(res[49], a[21], a[27]); // Sum(48)
  res[49] = fma52lo(res[49], a[22], a[27]); // Sum(49)
  res[50] = fma52hi(res[50], a[22], a[27]); // Sum(49)
  res[50] = fma52lo(res[50], a[23], a[27]); // Sum(50)
  res[51] = fma52hi(res[51], a[23], a[27]); // Sum(50)
  res[51] = fma52lo(res[51], a[24], a[27]); // Sum(51)
  res[52] = fma52hi(res[52], a[24], a[27]); // Sum(51)
  res[52] = fma52lo(res[52], a[25], a[27]); // Sum(52)
  res[53] = fma52hi(res[53], a[25], a[27]); // Sum(52)
  res[53] = fma52lo(res[53], a[26], a[27]); // Sum(53)
  res[54] = fma52hi(res[54], a[26], a[27]); // Sum(53)
  res[48] = fma52lo(res[48], a[20], a[28]); // Sum(48)
  res[49] = fma52hi(res[49], a[20], a[28]); // Sum(48)
  res[49] = fma52lo(res[49], a[21], a[28]); // Sum(49)
  res[50] = fma52hi(res[50], a[21], a[28]); // Sum(49)
  res[50] = fma52lo(res[50], a[22], a[28]); // Sum(50)
  res[51] = fma52hi(res[51], a[22], a[28]); // Sum(50)
  res[51] = fma52lo(res[51], a[23], a[28]); // Sum(51)
  res[52] = fma52hi(res[52], a[23], a[28]); // Sum(51)
  res[52] = fma52lo(res[52], a[24], a[28]); // Sum(52)
  res[53] = fma52hi(res[53], a[24], a[28]); // Sum(52)
  res[53] = fma52lo(res[53], a[25], a[28]); // Sum(53)
  res[54] = fma52hi(res[54], a[25], a[28]); // Sum(53)
  res[54] = fma52lo(res[54], a[26], a[28]); // Sum(54)
  res[55] = fma52hi(res[55], a[26], a[28]); // Sum(54)
  res[55] = fma52lo(res[55], a[27], a[28]); // Sum(55)
  res[56] = fma52hi(res[56], a[27], a[28]); // Sum(55)
  res[48] = fma52lo(res[48], a[19], a[29]); // Sum(48)
  res[49] = fma52hi(res[49], a[19], a[29]); // Sum(48)
  res[49] = fma52lo(res[49], a[20], a[29]); // Sum(49)
  res[50] = fma52hi(res[50], a[20], a[29]); // Sum(49)
  res[50] = fma52lo(res[50], a[21], a[29]); // Sum(50)
  res[51] = fma52hi(res[51], a[21], a[29]); // Sum(50)
  res[51] = fma52lo(res[51], a[22], a[29]); // Sum(51)
  res[52] = fma52hi(res[52], a[22], a[29]); // Sum(51)
  res[52] = fma52lo(res[52], a[23], a[29]); // Sum(52)
  res[53] = fma52hi(res[53], a[23], a[29]); // Sum(52)
  res[53] = fma52lo(res[53], a[24], a[29]); // Sum(53)
  res[54] = fma52hi(res[54], a[24], a[29]); // Sum(53)
  res[54] = fma52lo(res[54], a[25], a[29]); // Sum(54)
  res[55] = fma52hi(res[55], a[25], a[29]); // Sum(54)
  res[55] = fma52lo(res[55], a[26], a[29]); // Sum(55)
  res[56] = fma52hi(res[56], a[26], a[29]); // Sum(55)
  res[56] = fma52lo(res[56], a[27], a[29]); // Sum(56)
  res[57] = fma52hi(res[57], a[27], a[29]); // Sum(56)
  res[57] = fma52lo(res[57], a[28], a[29]); // Sum(57)
  res[58] = fma52hi(res[58], a[28], a[29]); // Sum(57)
  res[48] = add64(res[48], res[48]);        // Double(48)
  res[49] = add64(res[49], res[49]);        // Double(49)
  res[50] = add64(res[50], res[50]);        // Double(50)
  res[51] = add64(res[51], res[51]);        // Double(51)
  res[52] = add64(res[52], res[52]);        // Double(52)
  res[53] = add64(res[53], res[53]);        // Double(53)
  res[54] = add64(res[54], res[54]);        // Double(54)
  res[55] = add64(res[55], res[55]);        // Double(55)
  res[56] = add64(res[56], res[56]);        // Double(56)
  res[57] = add64(res[57], res[57]);        // Double(57)
  res[58] = add64(res[58], res[58]);        // Double(58)
  res[48] = fma52lo(res[48], a[24], a[24]); // Add sqr(48)
  res[49] = fma52hi(res[49], a[24], a[24]); // Add sqr(48)
  res[50] = fma52lo(res[50], a[25], a[25]); // Add sqr(50)
  res[51] = fma52hi(res[51], a[25], a[25]); // Add sqr(50)
  res[52] = fma52lo(res[52], a[26], a[26]); // Add sqr(52)
  res[53] = fma52hi(res[53], a[26], a[26]); // Add sqr(52)
  res[54] = fma52lo(res[54], a[27], a[27]); // Add sqr(54)
  res[55] = fma52hi(res[55], a[27], a[27]); // Add sqr(54)
  res[56] = fma52lo(res[56], a[28], a[28]); // Add sqr(56)
  res[57] = fma52hi(res[57], a[28], a[28]); // Add sqr(56)
  res[58] = fma52lo(res[58], a[29], a[29]); // Add sqr(58)
  res[59] = fma52hi(res[59], a[29], a[29]); // Add sqr(58)

  // Montgomery Reduction
  int it;
  for (it = 0; it < 30; it += 10) { // Reduction step
    int jt = 0;
    if ((it + 0) > 0)
      res[it + 0] = add64(res[it + 0], srli64(res[it + -1], DIGIT_SIZE));
    u[it + 0] = mul52lo(res[it + 0], k);
    res[it + jt + 0] = fma52lo(res[it + jt + 0], u[it + 0], m[jt + 0]);
    res[it + jt + 1] = fma52hi(res[it + jt + 1], u[it + 0], m[jt + 0]);
    res[it + jt + 1] = fma52lo(res[it + jt + 1], u[it + 0], m[jt + 1]);
    res[it + jt + 2] = fma52hi(res[it + jt + 2], u[it + 0], m[jt + 1]);
    res[it + jt + 2] = fma52lo(res[it + jt + 2], u[it + 0], m[jt + 2]);
    res[it + jt + 3] = fma52hi(res[it + jt + 3], u[it + 0], m[jt + 2]);
    res[it + jt + 3] = fma52lo(res[it + jt + 3], u[it + 0], m[jt + 3]);
    res[it + jt + 4] = fma52hi(res[it + jt + 4], u[it + 0], m[jt + 3]);
    res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 0], m[jt + 4]);
    res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 0], m[jt + 4]);
    res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 0], m[jt + 5]);
    res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 0], m[jt + 5]);
    res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 0], m[jt + 6]);
    res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 0], m[jt + 6]);
    res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 0], m[jt + 7]);
    res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 0], m[jt + 7]);
    res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 0], m[jt + 8]);
    res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 0], m[jt + 8]);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 0], m[jt + 9]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 0], m[jt + 9]);
    res[it + 1] = add64(res[it + 1], srli64(res[it + 0], DIGIT_SIZE));
    u[it + 1] = mul52lo(res[it + 1], k);
    res[it + jt + 1] = fma52lo(res[it + jt + 1], u[it + 1], m[jt + 0]);
    res[it + jt + 2] = fma52hi(res[it + jt + 2], u[it + 1], m[jt + 0]);
    res[it + jt + 2] = fma52lo(res[it + jt + 2], u[it + 1], m[jt + 1]);
    res[it + jt + 3] = fma52hi(res[it + jt + 3], u[it + 1], m[jt + 1]);
    res[it + jt + 3] = fma52lo(res[it + jt + 3], u[it + 1], m[jt + 2]);
    res[it + jt + 4] = fma52hi(res[it + jt + 4], u[it + 1], m[jt + 2]);
    res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 1], m[jt + 3]);
    res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 1], m[jt + 3]);
    res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 1], m[jt + 4]);
    res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 1], m[jt + 4]);
    res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 1], m[jt + 5]);
    res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 1], m[jt + 5]);
    res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 1], m[jt + 6]);
    res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 1], m[jt + 6]);
    res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 1], m[jt + 7]);
    res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 1], m[jt + 7]);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 1], m[jt + 8]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 1], m[jt + 8]);
    res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 1], m[jt + 9]);
    res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 1], m[jt + 9]);
    res[it + 2] = add64(res[it + 2], srli64(res[it + 1], DIGIT_SIZE));
    u[it + 2] = mul52lo(res[it + 2], k);
    res[it + jt + 2] = fma52lo(res[it + jt + 2], u[it + 2], m[jt + 0]);
    res[it + jt + 3] = fma52hi(res[it + jt + 3], u[it + 2], m[jt + 0]);
    res[it + jt + 3] = fma52lo(res[it + jt + 3], u[it + 2], m[jt + 1]);
    res[it + jt + 4] = fma52hi(res[it + jt + 4], u[it + 2], m[jt + 1]);
    res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 2], m[jt + 2]);
    res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 2], m[jt + 2]);
    res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 2], m[jt + 3]);
    res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 2], m[jt + 3]);
    res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 2], m[jt + 4]);
    res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 2], m[jt + 4]);
    res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 2], m[jt + 5]);
    res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 2], m[jt + 5]);
    res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 2], m[jt + 6]);
    res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 2], m[jt + 6]);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 2], m[jt + 7]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 2], m[jt + 7]);
    res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 2], m[jt + 8]);
    res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 2], m[jt + 8]);
    res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 2], m[jt + 9]);
    res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 2], m[jt + 9]);
    res[it + 3] = add64(res[it + 3], srli64(res[it + 2], DIGIT_SIZE));
    u[it + 3] = mul52lo(res[it + 3], k);
    res[it + jt + 3] = fma52lo(res[it + jt + 3], u[it + 3], m[jt + 0]);
    res[it + jt + 4] = fma52hi(res[it + jt + 4], u[it + 3], m[jt + 0]);
    res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 3], m[jt + 1]);
    res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 3], m[jt + 1]);
    res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 3], m[jt + 2]);
    res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 3], m[jt + 2]);
    res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 3], m[jt + 3]);
    res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 3], m[jt + 3]);
    res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 3], m[jt + 4]);
    res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 3], m[jt + 4]);
    res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 3], m[jt + 5]);
    res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 3], m[jt + 5]);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 3], m[jt + 6]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 3], m[jt + 6]);
    res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 3], m[jt + 7]);
    res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 3], m[jt + 7]);
    res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 3], m[jt + 8]);
    res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 3], m[jt + 8]);
    res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 3], m[jt + 9]);
    res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 3], m[jt + 9]);
    res[it + 4] = add64(res[it + 4], srli64(res[it + 3], DIGIT_SIZE));
    u[it + 4] = mul52lo(res[it + 4], k);
    res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 4], m[jt + 0]);
    res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 4], m[jt + 0]);
    res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 4], m[jt + 1]);
    res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 4], m[jt + 1]);
    res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 4], m[jt + 2]);
    res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 4], m[jt + 2]);
    res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 4], m[jt + 3]);
    res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 4], m[jt + 3]);
    res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 4], m[jt + 4]);
    res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 4], m[jt + 4]);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 4], m[jt + 5]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 4], m[jt + 5]);
    res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 4], m[jt + 6]);
    res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 4], m[jt + 6]);
    res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 4], m[jt + 7]);
    res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 4], m[jt + 7]);
    res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 4], m[jt + 8]);
    res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 4], m[jt + 8]);
    res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 4], m[jt + 9]);
    res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 4], m[jt + 9]);
    res[it + 5] = add64(res[it + 5], srli64(res[it + 4], DIGIT_SIZE));
    u[it + 5] = mul52lo(res[it + 5], k);
    res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 5], m[jt + 0]);
    res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 5], m[jt + 0]);
    res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 5], m[jt + 1]);
    res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 5], m[jt + 1]);
    res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 5], m[jt + 2]);
    res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 5], m[jt + 2]);
    res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 5], m[jt + 3]);
    res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 5], m[jt + 3]);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 5], m[jt + 4]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 5], m[jt + 4]);
    res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 5], m[jt + 5]);
    res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 5], m[jt + 5]);
    res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 5], m[jt + 6]);
    res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 5], m[jt + 6]);
    res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 5], m[jt + 7]);
    res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 5], m[jt + 7]);
    res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 5], m[jt + 8]);
    res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 5], m[jt + 8]);
    res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 5], m[jt + 9]);
    res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 5], m[jt + 9]);
    res[it + 6] = add64(res[it + 6], srli64(res[it + 5], DIGIT_SIZE));
    u[it + 6] = mul52lo(res[it + 6], k);
    res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 6], m[jt + 0]);
    res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 6], m[jt + 0]);
    res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 6], m[jt + 1]);
    res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 6], m[jt + 1]);
    res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 6], m[jt + 2]);
    res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 6], m[jt + 2]);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 6], m[jt + 3]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 6], m[jt + 3]);
    res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 6], m[jt + 4]);
    res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 6], m[jt + 4]);
    res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 6], m[jt + 5]);
    res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 6], m[jt + 5]);
    res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 6], m[jt + 6]);
    res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 6], m[jt + 6]);
    res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 6], m[jt + 7]);
    res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 6], m[jt + 7]);
    res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 6], m[jt + 8]);
    res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 6], m[jt + 8]);
    res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 6], m[jt + 9]);
    res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 6], m[jt + 9]);
    res[it + 7] = add64(res[it + 7], srli64(res[it + 6], DIGIT_SIZE));
    u[it + 7] = mul52lo(res[it + 7], k);
    res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 7], m[jt + 0]);
    res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 7], m[jt + 0]);
    res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 7], m[jt + 1]);
    res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 7], m[jt + 1]);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 7], m[jt + 2]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 7], m[jt + 2]);
    res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 7], m[jt + 3]);
    res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 7], m[jt + 3]);
    res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 7], m[jt + 4]);
    res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 7], m[jt + 4]);
    res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 7], m[jt + 5]);
    res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 7], m[jt + 5]);
    res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 7], m[jt + 6]);
    res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 7], m[jt + 6]);
    res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 7], m[jt + 7]);
    res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 7], m[jt + 7]);
    res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 7], m[jt + 8]);
    res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 7], m[jt + 8]);
    res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 7], m[jt + 9]);
    res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 7], m[jt + 9]);
    res[it + 8] = add64(res[it + 8], srli64(res[it + 7], DIGIT_SIZE));
    u[it + 8] = mul52lo(res[it + 8], k);
    res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 8], m[jt + 0]);
    res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 8], m[jt + 0]);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 8], m[jt + 1]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 8], m[jt + 1]);
    res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 8], m[jt + 2]);
    res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 8], m[jt + 2]);
    res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 8], m[jt + 3]);
    res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 8], m[jt + 3]);
    res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 8], m[jt + 4]);
    res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 8], m[jt + 4]);
    res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 8], m[jt + 5]);
    res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 8], m[jt + 5]);
    res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 8], m[jt + 6]);
    res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 8], m[jt + 6]);
    res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 8], m[jt + 7]);
    res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 8], m[jt + 7]);
    res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 8], m[jt + 8]);
    res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 8], m[jt + 8]);
    res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 8], m[jt + 9]);
    res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 8], m[jt + 9]);
    res[it + 9] = add64(res[it + 9], srli64(res[it + 8], DIGIT_SIZE));
    u[it + 9] = mul52lo(res[it + 9], k);
    res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 9], m[jt + 0]);
    res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 9], m[jt + 0]);
    res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 9], m[jt + 1]);
    res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 9], m[jt + 1]);
    res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 9], m[jt + 2]);
    res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 9], m[jt + 2]);
    res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 9], m[jt + 3]);
    res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 9], m[jt + 3]);
    res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 9], m[jt + 4]);
    res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 9], m[jt + 4]);
    res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 9], m[jt + 5]);
    res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 9], m[jt + 5]);
    res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 9], m[jt + 6]);
    res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 9], m[jt + 6]);
    res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 9], m[jt + 7]);
    res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 9], m[jt + 7]);
    res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 9], m[jt + 8]);
    res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 9], m[jt + 8]);
    res[it + jt + 18] = fma52lo(res[it + jt + 18], u[it + 9], m[jt + 9]);
    res[it + jt + 19] = fma52hi(res[it + jt + 19], u[it + 9], m[jt + 9]);

    for (jt = 10; jt < 30; jt += 10) { // Poly tile
      res[it + jt + 0] = fma52lo(res[it + jt + 0], u[it + 0], m[jt + 0]);
      res[it + jt + 1] = fma52hi(res[it + jt + 1], u[it + 0], m[jt + 0]);
      res[it + jt + 1] = fma52lo(res[it + jt + 1], u[it + 0], m[jt + 1]);
      res[it + jt + 2] = fma52hi(res[it + jt + 2], u[it + 0], m[jt + 1]);
      res[it + jt + 2] = fma52lo(res[it + jt + 2], u[it + 0], m[jt + 2]);
      res[it + jt + 3] = fma52hi(res[it + jt + 3], u[it + 0], m[jt + 2]);
      res[it + jt + 3] = fma52lo(res[it + jt + 3], u[it + 0], m[jt + 3]);
      res[it + jt + 4] = fma52hi(res[it + jt + 4], u[it + 0], m[jt + 3]);
      res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 0], m[jt + 4]);
      res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 0], m[jt + 4]);
      res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 0], m[jt + 5]);
      res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 0], m[jt + 5]);
      res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 0], m[jt + 6]);
      res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 0], m[jt + 6]);
      res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 0], m[jt + 7]);
      res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 0], m[jt + 7]);
      res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 0], m[jt + 8]);
      res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 0], m[jt + 8]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 0], m[jt + 9]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 0], m[jt + 9]);
      res[it + jt + 1] = fma52lo(res[it + jt + 1], u[it + 1], m[jt + 0]);
      res[it + jt + 2] = fma52hi(res[it + jt + 2], u[it + 1], m[jt + 0]);
      res[it + jt + 2] = fma52lo(res[it + jt + 2], u[it + 1], m[jt + 1]);
      res[it + jt + 3] = fma52hi(res[it + jt + 3], u[it + 1], m[jt + 1]);
      res[it + jt + 3] = fma52lo(res[it + jt + 3], u[it + 1], m[jt + 2]);
      res[it + jt + 4] = fma52hi(res[it + jt + 4], u[it + 1], m[jt + 2]);
      res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 1], m[jt + 3]);
      res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 1], m[jt + 3]);
      res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 1], m[jt + 4]);
      res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 1], m[jt + 4]);
      res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 1], m[jt + 5]);
      res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 1], m[jt + 5]);
      res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 1], m[jt + 6]);
      res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 1], m[jt + 6]);
      res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 1], m[jt + 7]);
      res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 1], m[jt + 7]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 1], m[jt + 8]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 1], m[jt + 8]);
      res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 1], m[jt + 9]);
      res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 1], m[jt + 9]);
      res[it + jt + 2] = fma52lo(res[it + jt + 2], u[it + 2], m[jt + 0]);
      res[it + jt + 3] = fma52hi(res[it + jt + 3], u[it + 2], m[jt + 0]);
      res[it + jt + 3] = fma52lo(res[it + jt + 3], u[it + 2], m[jt + 1]);
      res[it + jt + 4] = fma52hi(res[it + jt + 4], u[it + 2], m[jt + 1]);
      res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 2], m[jt + 2]);
      res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 2], m[jt + 2]);
      res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 2], m[jt + 3]);
      res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 2], m[jt + 3]);
      res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 2], m[jt + 4]);
      res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 2], m[jt + 4]);
      res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 2], m[jt + 5]);
      res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 2], m[jt + 5]);
      res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 2], m[jt + 6]);
      res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 2], m[jt + 6]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 2], m[jt + 7]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 2], m[jt + 7]);
      res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 2], m[jt + 8]);
      res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 2], m[jt + 8]);
      res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 2], m[jt + 9]);
      res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 2], m[jt + 9]);
      res[it + jt + 3] = fma52lo(res[it + jt + 3], u[it + 3], m[jt + 0]);
      res[it + jt + 4] = fma52hi(res[it + jt + 4], u[it + 3], m[jt + 0]);
      res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 3], m[jt + 1]);
      res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 3], m[jt + 1]);
      res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 3], m[jt + 2]);
      res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 3], m[jt + 2]);
      res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 3], m[jt + 3]);
      res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 3], m[jt + 3]);
      res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 3], m[jt + 4]);
      res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 3], m[jt + 4]);
      res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 3], m[jt + 5]);
      res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 3], m[jt + 5]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 3], m[jt + 6]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 3], m[jt + 6]);
      res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 3], m[jt + 7]);
      res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 3], m[jt + 7]);
      res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 3], m[jt + 8]);
      res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 3], m[jt + 8]);
      res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 3], m[jt + 9]);
      res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 3], m[jt + 9]);
      res[it + jt + 4] = fma52lo(res[it + jt + 4], u[it + 4], m[jt + 0]);
      res[it + jt + 5] = fma52hi(res[it + jt + 5], u[it + 4], m[jt + 0]);
      res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 4], m[jt + 1]);
      res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 4], m[jt + 1]);
      res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 4], m[jt + 2]);
      res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 4], m[jt + 2]);
      res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 4], m[jt + 3]);
      res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 4], m[jt + 3]);
      res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 4], m[jt + 4]);
      res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 4], m[jt + 4]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 4], m[jt + 5]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 4], m[jt + 5]);
      res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 4], m[jt + 6]);
      res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 4], m[jt + 6]);
      res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 4], m[jt + 7]);
      res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 4], m[jt + 7]);
      res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 4], m[jt + 8]);
      res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 4], m[jt + 8]);
      res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 4], m[jt + 9]);
      res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 4], m[jt + 9]);
      res[it + jt + 5] = fma52lo(res[it + jt + 5], u[it + 5], m[jt + 0]);
      res[it + jt + 6] = fma52hi(res[it + jt + 6], u[it + 5], m[jt + 0]);
      res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 5], m[jt + 1]);
      res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 5], m[jt + 1]);
      res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 5], m[jt + 2]);
      res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 5], m[jt + 2]);
      res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 5], m[jt + 3]);
      res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 5], m[jt + 3]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 5], m[jt + 4]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 5], m[jt + 4]);
      res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 5], m[jt + 5]);
      res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 5], m[jt + 5]);
      res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 5], m[jt + 6]);
      res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 5], m[jt + 6]);
      res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 5], m[jt + 7]);
      res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 5], m[jt + 7]);
      res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 5], m[jt + 8]);
      res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 5], m[jt + 8]);
      res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 5], m[jt + 9]);
      res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 5], m[jt + 9]);
      res[it + jt + 6] = fma52lo(res[it + jt + 6], u[it + 6], m[jt + 0]);
      res[it + jt + 7] = fma52hi(res[it + jt + 7], u[it + 6], m[jt + 0]);
      res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 6], m[jt + 1]);
      res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 6], m[jt + 1]);
      res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 6], m[jt + 2]);
      res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 6], m[jt + 2]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 6], m[jt + 3]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 6], m[jt + 3]);
      res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 6], m[jt + 4]);
      res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 6], m[jt + 4]);
      res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 6], m[jt + 5]);
      res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 6], m[jt + 5]);
      res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 6], m[jt + 6]);
      res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 6], m[jt + 6]);
      res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 6], m[jt + 7]);
      res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 6], m[jt + 7]);
      res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 6], m[jt + 8]);
      res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 6], m[jt + 8]);
      res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 6], m[jt + 9]);
      res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 6], m[jt + 9]);
      res[it + jt + 7] = fma52lo(res[it + jt + 7], u[it + 7], m[jt + 0]);
      res[it + jt + 8] = fma52hi(res[it + jt + 8], u[it + 7], m[jt + 0]);
      res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 7], m[jt + 1]);
      res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 7], m[jt + 1]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 7], m[jt + 2]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 7], m[jt + 2]);
      res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 7], m[jt + 3]);
      res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 7], m[jt + 3]);
      res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 7], m[jt + 4]);
      res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 7], m[jt + 4]);
      res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 7], m[jt + 5]);
      res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 7], m[jt + 5]);
      res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 7], m[jt + 6]);
      res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 7], m[jt + 6]);
      res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 7], m[jt + 7]);
      res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 7], m[jt + 7]);
      res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 7], m[jt + 8]);
      res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 7], m[jt + 8]);
      res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 7], m[jt + 9]);
      res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 7], m[jt + 9]);
      res[it + jt + 8] = fma52lo(res[it + jt + 8], u[it + 8], m[jt + 0]);
      res[it + jt + 9] = fma52hi(res[it + jt + 9], u[it + 8], m[jt + 0]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 8], m[jt + 1]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 8], m[jt + 1]);
      res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 8], m[jt + 2]);
      res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 8], m[jt + 2]);
      res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 8], m[jt + 3]);
      res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 8], m[jt + 3]);
      res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 8], m[jt + 4]);
      res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 8], m[jt + 4]);
      res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 8], m[jt + 5]);
      res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 8], m[jt + 5]);
      res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 8], m[jt + 6]);
      res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 8], m[jt + 6]);
      res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 8], m[jt + 7]);
      res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 8], m[jt + 7]);
      res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 8], m[jt + 8]);
      res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 8], m[jt + 8]);
      res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 8], m[jt + 9]);
      res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 8], m[jt + 9]);
      res[it + jt + 9] = fma52lo(res[it + jt + 9], u[it + 9], m[jt + 0]);
      res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 9], m[jt + 0]);
      res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 9], m[jt + 1]);
      res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 9], m[jt + 1]);
      res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 9], m[jt + 2]);
      res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 9], m[jt + 2]);
      res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 9], m[jt + 3]);
      res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 9], m[jt + 3]);
      res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 9], m[jt + 4]);
      res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 9], m[jt + 4]);
      res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 9], m[jt + 5]);
      res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 9], m[jt + 5]);
      res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 9], m[jt + 6]);
      res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 9], m[jt + 6]);
      res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 9], m[jt + 7]);
      res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 9], m[jt + 7]);
      res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 9], m[jt + 8]);
      res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 9], m[jt + 8]);
      res[it + jt + 18] = fma52lo(res[it + jt + 18], u[it + 9], m[jt + 9]);
      res[it + jt + 19] = fma52hi(res[it + jt + 19], u[it + 9], m[jt + 9]);
    }
  }

  // Normalization
  res[30] = add64(res[30], srli64(res[29], DIGIT_SIZE));
  r[0] = and64_const(res[30], DIGIT_MASK);
  res[31] = add64(res[31], srli64(res[30], DIGIT_SIZE));
  r[1] = and64_const(res[31], DIGIT_MASK);
  res[32] = add64(res[32], srli64(res[31], DIGIT_SIZE));
  r[2] = and64_const(res[32], DIGIT_MASK);
  res[33] = add64(res[33], srli64(res[32], DIGIT_SIZE));
  r[3] = and64_const(res[33], DIGIT_MASK);
  res[34] = add64(res[34], srli64(res[33], DIGIT_SIZE));
  r[4] = and64_const(res[34], DIGIT_MASK);
  res[35] = add64(res[35], srli64(res[34], DIGIT_SIZE));
  r[5] = and64_const(res[35], DIGIT_MASK);
  res[36] = add64(res[36], srli64(res[35], DIGIT_SIZE));
  r[6] = and64_const(res[36], DIGIT_MASK);
  res[37] = add64(res[37], srli64(res[36], DIGIT_SIZE));
  r[7] = and64_const(res[37], DIGIT_MASK);
  res[38] = add64(res[38], srli64(res[37], DIGIT_SIZE));
  r[8] = and64_const(res[38], DIGIT_MASK);
  res[39] = add64(res[39], srli64(res[38], DIGIT_SIZE));
  r[9] = and64_const(res[39], DIGIT_MASK);
  res[40] = add64(res[40], srli64(res[39], DIGIT_SIZE));
  r[10] = and64_const(res[40], DIGIT_MASK);
  res[41] = add64(res[41], srli64(res[40], DIGIT_SIZE));
  r[11] = and64_const(res[41], DIGIT_MASK);
  res[42] = add64(res[42], srli64(res[41], DIGIT_SIZE));
  r[12] = and64_const(res[42], DIGIT_MASK);
  res[43] = add64(res[43], srli64(res[42], DIGIT_SIZE));
  r[13] = and64_const(res[43], DIGIT_MASK);
  res[44] = add64(res[44], srli64(res[43], DIGIT_SIZE));
  r[14] = and64_const(res[44], DIGIT_MASK);
  res[45] = add64(res[45], srli64(res[44], DIGIT_SIZE));
  r[15] = and64_const(res[45], DIGIT_MASK);
  res[46] = add64(res[46], srli64(res[45], DIGIT_SIZE));
  r[16] = and64_const(res[46], DIGIT_MASK);
  res[47] = add64(res[47], srli64(res[46], DIGIT_SIZE));
  r[17] = and64_const(res[47], DIGIT_MASK);
  res[48] = add64(res[48], srli64(res[47], DIGIT_SIZE));
  r[18] = and64_const(res[48], DIGIT_MASK);
  res[49] = add64(res[49], srli64(res[48], DIGIT_SIZE));
  r[19] = and64_const(res[49], DIGIT_MASK);
  res[50] = add64(res[50], srli64(res[49], DIGIT_SIZE));
  r[20] = and64_const(res[50], DIGIT_MASK);
  res[51] = add64(res[51], srli64(res[50], DIGIT_SIZE));
  r[21] = and64_const(res[51], DIGIT_MASK);
  res[52] = add64(res[52], srli64(res[51], DIGIT_SIZE));
  r[22] = and64_const(res[52], DIGIT_MASK);
  res[53] = add64(res[53], srli64(res[52], DIGIT_SIZE));
  r[23] = and64_const(res[53], DIGIT_MASK);
  res[54] = add64(res[54], srli64(res[53], DIGIT_SIZE));
  r[24] = and64_const(res[54], DIGIT_MASK);
  res[55] = add64(res[55], srli64(res[54], DIGIT_SIZE));
  r[25] = and64_const(res[55], DIGIT_MASK);
  res[56] = add64(res[56], srli64(res[55], DIGIT_SIZE));
  r[26] = and64_const(res[56], DIGIT_MASK);
  res[57] = add64(res[57], srli64(res[56], DIGIT_SIZE));
  r[27] = and64_const(res[57], DIGIT_MASK);
  res[58] = add64(res[58], srli64(res[57], DIGIT_SIZE));
  r[28] = and64_const(res[58], DIGIT_MASK);
  res[59] = add64(res[59], srli64(res[58], DIGIT_SIZE));
  r[29] = and64_const(res[59], DIGIT_MASK);
}
