/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyTree;

public class DocumentNodeTest
extends NodeTest {
    private NodeTest elementTest;

    public DocumentNodeTest(NodeTest elementTest) {
        this.elementTest = elementTest;
    }

    public boolean matches(int nodeKind, int fingerprint, int annotation) {
        throw new UnsupportedOperationException("DocumentNodeTest doesn't support this method");
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        if (tree.getNodeKind(nodeNr) != 9) {
            return false;
        }
        return this.matches(tree.getNode(nodeNr));
    }

    public boolean matches(NodeInfo node) {
        if (node.getNodeKind() != 9) {
            return false;
        }
        AxisIterator iter = node.iterateAxis((byte)3);
        boolean found = false;
        while (true) {
            NodeInfo n;
            if ((n = (NodeInfo)iter.next()) == null) {
                return found;
            }
            int kind = n.getNodeKind();
            if (kind == 3) {
                return false;
            }
            if (kind != 1) continue;
            if (found) {
                return false;
            }
            if (!this.elementTest.matches(n)) break;
            found = true;
        }
        return false;
    }

    public final double getDefaultPriority() {
        return this.elementTest.getDefaultPriority();
    }

    public int getPrimitiveType() {
        return 9;
    }

    public int getNodeKindMask() {
        return 512;
    }

    public NodeTest getElementTest() {
        return this.elementTest;
    }

    public String toString(NamePool pool) {
        return "document-node(" + this.elementTest.toString(pool) + ')';
    }

    public String toString() {
        return "document-node(" + this.elementTest.toString() + ')';
    }

    public int hashCode() {
        return this.elementTest.hashCode() ^ 0x3039;
    }

    public boolean equals(Object other) {
        return other instanceof DocumentNodeTest && ((DocumentNodeTest)other).elementTest.equals(this.elementTest);
    }
}

