/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionUtil;
import org.apache.tools.ant.taskdefs.optional.extension.LibFileSet;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;

public class ExtensionSet
extends DataType {
    private final ArrayList extensions = new ArrayList();
    private final ArrayList extensionsFilesets = new ArrayList();

    public void addExtension(ExtensionAdapter extensionAdapter) {
        this.extensions.add(extensionAdapter);
    }

    public void addLibfileset(LibFileSet fileSet) {
        this.extensionsFilesets.add(fileSet);
    }

    public void addFileset(FileSet fileSet) {
        this.extensionsFilesets.add(fileSet);
    }

    public Extension[] toExtensions(Project proj) throws BuildException {
        ArrayList extensionsList = ExtensionUtil.toExtensions(this.extensions);
        ExtensionUtil.extractExtensions(proj, extensionsList, this.extensionsFilesets);
        return extensionsList.toArray(new Extension[extensionsList.size()]);
    }

    public void setRefid(Reference reference) throws BuildException {
        if (!this.extensions.isEmpty() || !this.extensionsFilesets.isEmpty()) {
            throw this.tooManyAttributes();
        }
        Object object = reference.getReferencedObject(this.getProject());
        if (!(object instanceof ExtensionSet)) {
            String message = reference.getRefId() + " doesn't refer to a ExtensionSet";
            throw new BuildException(message);
        }
        ExtensionSet other = (ExtensionSet)((Object)object);
        this.extensions.addAll(other.extensions);
        this.extensionsFilesets.addAll(other.extensionsFilesets);
        super.setRefid(reference);
    }

    public String toString() {
        return "ExtensionSet" + Arrays.asList(this.toExtensions(this.getProject()));
    }
}

