/* $Id: we_colors.c 1143 2011-02-13 16:13:58Z ekalin $ */

/*
 * Copyright (C) 2004-2011 Eduardo M Kalinowski <eduardo@kalinowski.com.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <libintl.h>
#include <gtk/gtk.h>

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/
/* XML UI signals */
G_MODULE_EXPORT void color_changed_cb(GtkColorButton *btn, gpointer data);
G_MODULE_EXPORT void set_default_colors_cb(GtkButton *btn, gpointer data);



GObject *
get_we_colors_tab(World *world, GtkBuilder *ui_builder)
{
  GObject  *panel;
  GtkTable *table;
  GObject  *colorBtnAnsi;
  GObject  *colorBtnDeffore;
  GObject  *colorBtnDefbold;
  GObject  *colorBtnDefback;
  GObject  *colorBtnDefboldback;
  gchar     btnname[18]; /* 18 is enough to hold the button names */
  int       i;

  panel = gtk_builder_get_object(ui_builder, "we_panel_colors");

  /* Ansi colors category */
  table = GTK_TABLE(gtk_builder_get_object(ui_builder, "table_ansi_colors"));
  gtk_table_set_col_spacing(table, 2, 32);

  for (i = 0; i < 16; ++i) {
    sprintf(btnname, "colorBtnAnsi[%d]", i);
    colorBtnAnsi = gtk_builder_get_object(ui_builder, btnname);
    gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnAnsi),
                               &world->ansicolors[i]);
    g_object_set_data(colorBtnAnsi, "colorptr", &world->ansicolors[i]);
  }

  /* Default colors category */
  table = GTK_TABLE(gtk_builder_get_object(ui_builder, "table_default_colors"));
  gtk_table_set_col_spacing(table, 2, 32);

  colorBtnDeffore = gtk_builder_get_object(ui_builder, "colorBtnDeffore");
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDeffore),
                             world->deffore);
  g_object_set_data(colorBtnDeffore, "colorptr", world->deffore);

  colorBtnDefbold = gtk_builder_get_object(ui_builder, "colorBtnDefbold");
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDefbold),
                             world->defbold);
  g_object_set_data(colorBtnDefbold, "colorptr", world->defbold);

  colorBtnDefback = gtk_builder_get_object(ui_builder, "colorBtnDefback");
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDefback),
                             world->defback);
  g_object_set_data(colorBtnDefback, "colorptr", world->defback);

  colorBtnDefboldback = gtk_builder_get_object(ui_builder,
                                               "colorBtnDefboldback");
  gtk_color_button_set_color(GTK_COLOR_BUTTON(colorBtnDefboldback),
                             world->defboldback);
  g_object_set_data(colorBtnDefboldback, "colorptr", world->defboldback);

  return panel;
}


void
color_changed_cb(GtkColorButton *btn, gpointer data)
{
  World    *world = (World *) data;
  WorldGUI *gui   = world->gui;
  GdkColor *color = (GdkColor *) g_object_get_data(G_OBJECT(btn),
                                                   "colorptr");

  gtk_color_button_get_color(btn, color);
  if (gui) {
    ansitextview_update_color_tags(gui, gui->world);
  }
}


void
set_default_colors_cb(GtkButton *btn, gpointer data)
{
  World          *world = (World *) data;
  WorldGUI       *gui   = world->gui;
  GtkBuilder     *ui_builder;
  GtkColorButton *colorBtnAnsi;
  GtkColorButton *colorBtnDeffore;
  GtkColorButton *colorBtnDefbold;
  GtkColorButton *colorBtnDefback;
  GtkColorButton *colorBtnDefboldback;
  gchar           btnname[18]; /* 18 is enough to hold the button names */
  int             i;

  ui_builder = world->ui_builder;

  colorBtnDeffore
    = GTK_COLOR_BUTTON(gtk_builder_get_object(ui_builder, "colorBtnDeffore"));
  colorBtnDefbold
    = GTK_COLOR_BUTTON(gtk_builder_get_object(ui_builder, "colorBtnDefbold"));
  colorBtnDefback
    = GTK_COLOR_BUTTON(gtk_builder_get_object(ui_builder, "colorBtnDefback"));
  colorBtnDefboldback
    = GTK_COLOR_BUTTON(gtk_builder_get_object(ui_builder, "colorBtnDefboldback"));

  memcpy(world->deffore, &deffore, sizeof(GdkColor));
  gtk_color_button_set_color(colorBtnDeffore, world->deffore);

  memcpy(world->defbold, &defbold, sizeof(GdkColor));
  gtk_color_button_set_color(colorBtnDefbold, world->defbold);

  memcpy(world->defback, &defback, sizeof(GdkColor));
  gtk_color_button_set_color(colorBtnDefback, world->defback);

  memcpy(world->defboldback, &defboldback, sizeof(GdkColor));
  gtk_color_button_set_color(colorBtnDefboldback, world->defboldback);

  memcpy(world->ansicolors, &defansi, 16*sizeof(GdkColor));
  for (i = 0; i < 16; ++i) {
    sprintf(btnname, "colorBtnAnsi[%d]", i);
    colorBtnAnsi = GTK_COLOR_BUTTON(gtk_builder_get_object(ui_builder,
                                                           btnname));
    gtk_color_button_set_color(colorBtnAnsi, &world->ansicolors[i]);
  }

  if (gui) {
    ansitextview_update_color_tags(gui, gui->world);
  }
}
