#include "bio++.H"

int
main(int argc, char **argv) {

  const char *s1 = "gattcatggctgaaatcgtgtttgaccagctatgtgtgtctctcaatccgatcaagtagatgtctaaaattaaccgtcagaatatttatgcctgattcatggctgaaattgtgtttgaccagctatgtgtgtctcttaatccactcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcacgtttgaccagctatgtgtgtctcttaatccagtcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcgtgtttgaccagctatgtgtgtctctcaatccgatcaagtagatgtctgaaattaaccatcagaatatttatgcctgattcatggctgaaatttcaggatgaaagctatgaaatctctatttgtgtttgtgtatctattaatgtatgttatgtatatgtgatattttcttaactccagagagcattgcaaaattcatttatgaaaacctctaaaagtgctctattctaacttggcttggaaaaaaataagcatttataaataaatattcaccaaactcctagaaatataggaactgatcaaatgtttcttaagttaacatgatttggataaaacttagttaaataagattaatatagtatttttggtgtaataaaacaactatatcttcaaaattatcattattgaatataaaacaagcataaattcctattctgcttgagttctagtcaaataagctaatattatacttactagaaacgtaaaatcttaaagcttatagatttgattctaattaagttgtcattcttatgaaaaacattattttttttatgctgaaaagatacacatatatttagagttagccagctggactcagtttaggtgatcccaattttgttacaacatcgaaagcatcataatcaggagcaagtcgaacatatgccttctctttatcaggacaaatcagggtggtgaccttggccacatcactgtcatagagcttcttcacagcctgtctgatctggtgcttgttggctttaacatccacagtgaacacaagcgtgttgttttcttctatcttcttcacggccgactcagtggtcagcggaaacttgatgatagcatagtggccaagcttgtttctcctgggggtgctcttccgaggatatctgggctgcctccggagtcgcagtgtcttgggccgcctgaaggtgagtgacatgcggatcttcttttttgcgtgtggctgcggacacctttcaacactgccttcttggcctttaaggccttcgctttggcttcggctttaggaggagcaggagcttccttcgctttcggtgccgtcttgtgaaaagcgaaaaacattatttcaaaaataatttgtttacagtaaatctgcctaagaatagtttccaaagtacttttggtaatttttaaccttaaagttaagctaagtaaaagatttgcattaaatatctagaccatttataaataagatacaatactaaaacattaattactgaacataaataattcaagtttatatacttttggcttcctgtttttacagagagactaaagatattttggcccgttaataaacatgtttttttctgccacactgaggaattgtattatgagaaaacacatccctctagatgttgggagatggtatattcatacattttctaacctactatagaatgctaatatatgacagtttataaccgtctacttcctagttttctctggaaaataaaagattactaagtattaaaattataatcaatatatgtaaataaaactactagaaataatagaataactagaaacaactctatgcaaagcatgcaagaaaagtagggcatgtttcgcaagtaaagtaggttgcattttttataaggaaaaccatacagaagatacaaataaaaagagatacctaaccttccctgtgttatatttgtatgggtaaaatgttatgttttcagaaattatataaaattcctggaagtttgtcaatgtcctccttatccatgctatgtgccactatagagtaatgagtcataattccaattattactttaaatgttgtgccaggcacagtggctcatgcctataatcccagcactttaggaggctgaggcgggtggatcacaaggtcaggagatccagaccatcctggttaactcggtgaatctccatctctattaaaaatataaaaaattagccgggcgtgatggaaggcacctgtagtcccagctactcgggaggctgaggcaggagaatggcgtgaacccaggagacagagcttgcagtgagccgagatcgcactgctgcactccagcctgggcgacagagcaagactctgtctctaaataaataaataaataaatgttgtctgccacagaaaaaatcgaatat";
  const char *s2 = "gattcatggctgaaatcatgtttgaccagctatgtgtgtctcttaatccagtcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcgtgtttgaccagctatgtgtgtctcttactccactcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcatgtttgaccagctatgtgtgtctcttaatccagtcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcgtgtttgaccagctatgtgtgtctctcaatccgatcaagtagatgtctgaaattaaccatcagaatatttatgcctgattcatggctgaaatttcaggatgacagctatgaaatctctatttgtgtttgtatatctattaatgtatgttatgtatatgtgatattttcttaactccagagagcattgcaaaattcatttatgaaatcctctaaaagtgctctattctaacttggcttggaaaaaaataagcatttataaataaatattcaccaaactcctagaaatataggaactgatcaaatgtttcttaagttaacatgatttggataaaacttagttaaataagattaatatagtatttttggtgtaataaaacaactatatcttcaaaattatcattattgaatataaaacaagcataaattcctattctgcttgagttctagtcaaataagctaatattatacttactagaaacgtaaaatcttaaagcttatagatttgattctaattaagttgtcattcttatgaaaaacattatttttttatgctgaaaagatacacatatatttagagttagccagctggactcagtttaggtgatcccaattttgttacaacatcgaaagcatcataatcaggagcaagtcgaacatatgccttgttctctttatcaggacaaatcagggtggtgaccttggccacatcactgtcatagagcttcttcacagcctgtctgatctggtgcttgttggctttaacatccacagtgaacacaagcgtgttgttttcttctatcttcttcacggccgactcagtggtcagcggaaacttgatgatagcatagtggccaagcttgtttctcctgggggtgctcttccgaggatatctgggctgcctccggagtcgcagtgtcttgggccgcctgaaggtgagtgacatgcggatcttcttttttgcgtgtggctgcggacacctttcaacactgccttcttggcctttaaagccttcgctttggcttcggctttaggaggagcaggagcttccttcgctttcggtgccatcttgtgaaaagcgaaaaacattatttcaaaaataatttgtttacagtaaatctgcctatgaatagtttccaaagtacttttggtaatttttaaccttaaagttaagctaagtaaaagatttgcattaaatatctagaccatttataaataagatacaatactaaaacattaattactgaacataaataattcaagtttatatacttttggctcctatttttacagagagactaaagatattttggcccgttaataaacatgtttttttctgccacactgaggaattgtattatgaggaaacacatccctctagatgttgggagatggtatattcatacattttctaacctactatagaatgctaatatatgacagtttataactgtctacttcctagttttctctggaaaataaaagattactaagtattaaaattataatcaatatatgtaaataaaactactagaaataatagaataactagaaacaactctatgcaaagcatgcaagaaaagtagggcatgtttcgcaagtaaagtaggttgcattttttataaggaaaaccatacagaagatacaaataaaaagagatacctaaccttccctgtgttatatttgtatgggtaaaatgttatgttttcagaaattatataaaattcctggaagtttgtcaatgtcctccttatccatgctatgtgccactatagagtaatgagtcataattccaattattactttaaatgttgtgccaggcacagtggctcatgcctataatcccagcactttaggaggctgaggcgggtggatcacaaggtcaggagatccagaccatcctggctaacccggtgaatctccatctctattaaaaatataaaaaattagccgggcgtgatggcaggcacctgtagtcccagctactcgggaggctgaggcaggagaatggcgtgaacccaggagacagagcttgcagtgagccgagatcgcaccgctgcactccagcctgggcgacagagcaagactctgtctctaaataaataaataaataaatgttgtctgccacagaaaaaatcgaatat";

  s1 =             "gATTCATGGCTgaaatcgtgtttgaccagctatgtgtgtctctcaatccgatcaagtagatgtctaaaattaaccgtcaGAATATTTATGCCTGATTCATGGCTgaaattgtgtttgaccagctatgtgtgtctcttaatccactcaagtagatgtctaaaattaaccatcaGAATATTTATGCCTGATTCATGGCTgaaatcacgtttgaccagctatgtgtgtctcttaatccagtcaagtagatgtctaaaattaaccatcaGAATATTTATGCCTGATTCATGGCTgaaatcgtgtttgaccagctatgtgtgtctctcaatccgatcaagtagatgtctgaaattaaccatcaGAAtatttatgcctgattcatggctgaaatttcaggatgaaagctatgaaatctctatttgtgtttgtgtatctattaatgtatgttatgtatatgtgatattttcttaactccagagagcattgcaaaattcatttatgaaaacctctaaaagtgctctattctaacttggcttggaaaaaaataagcatttataaataaatattcaccaaactcctagaaatataggaactgatcaaatgtttcttaagttaacatgatttggataaaacttagttaaataagattaatatagtatttttggtgtaataaaacaactatatcttcaaaattatcattattgaatataaaacaagcataaattcctattctgcttgagttctagtcaaataagctaatattatacttactagaaacgtaaaatcttaaagcttatagatttgattctaaTTAAGTTGTCATTCTTATGAAAAACATTATTTTTTTTATGCTGAAAAGATACACATATATTTAGAGTTAGCCAGCTGGACTCAGTTTAGGTGATCCCAATTTTGTTACAACATCGAAAGCATCATAATCAGGAGCAAGTCGAACATATGCCTTCTCTTTATCAGGACAAATCAGGGTGGTGACCTTGGCCACATCACTGTCATAGAGCTTCTTCACAGCCTGTCTGATCTGGTGCTTGTTGGCTTTAACATCCACAGTGAACACAAGCGTGTTGTTTTCTTCTATCTTCTTCACGGCCGACTCAGTGGTCAGCGGAAACTTGATGATAGCATAGTGGCCAAGCTTGTTTCTCCTGGGGGTGCTCTTCCGAGGATATCTGGGCTGCCTCCGGAGTCGCAGTGTCTTGGGCCGCCTGAAGGTGAGTGACATGCGGATCTTCTTTTTTGCGTGTGGCTGCGGACACCTTTCAACACTGCCTTCTTGGCCTTTAAGGCCTTCGCTTTGGCTTCGGCTTTAGGAGGAGCAGGAGCTTCCTTCGCTTTCGGTGCCGTCTTGTGAAAAGCGAAAAACATTATTTCAAAAATAATTTGTTTACAGTAAATCTgcctaagaatagtttccaaagtacttttggtaatttttaaccttaaagttaagctaagtaaaagatttgcattaaatatctagaccatttataaataagatacaatactaaaacattaattactgaacataaataattcaagtttatatacttttggcttcctgtttttacagagagactaaagatattttggcccgttaataaacatgtttttttctgccacactgaggaattgtattatgagaaaacacatccctctagatgttgggagatggtatattcatacattttctaacctactatagaatgctaatatatgacagtttataaccgtctacttcctagttttctctggaaaataaaagattactaagtattaaaattataatcaatatatgtaaataaaactactagaaataatagaataactagaaacaactctatgcaaagcatgcaagaaaagtagggcatgtttcgcaagtaaagtaggttgcattttttataaggaaaaCCATACAGAAGATAcaaataaaaagagatacctaaccttccctgtgttatatttgtatgggtaaaatgttatgttttcagaaattatataaaattcctggaagtttgtcaatgtcctccttatccatgctatgtgccactatagagtaatgagtcataattccaattattactttaaatgttgtgccaggcacagtggctcatgcctataatcccagcactttaggaggctgaggcgggtggatcacaaggtcaggagatccagaccatcctggttaactcggtgaatctccatctctattaaaaatataaaaaattagccgggcgtgatggaaggcacctgtagtcccagctactcgggaggctgaggcaggagaatggcgtgaacccaggagacagagcttgcagtgagccgagatcgcactgctgcactccagcctgggcgacagagcaagactctgtctctaaataaataaataaataaatgttgtctgccacagaaaaaatcgaatAT";
  s2 =             "gATTCATGGCTGAAATCATGTTTGACCAGCTATGTGTGTCTCTTAATCCAGTCAAGTAGATGTCTAAAATTAACCATCAGAATATTTATGCCTGATTCATGGCTGAAATCGTGTTTGACCAGCTATGTGTGTCTCTTACTCCACTCAAGTAGATGTCTAAAATTAACCATCAGAATATTTATGCCTGATTCATGGCTGAAATCATGTTTGACCAGCTATGTGTGTCTCTTAATCCAGTCAAGTAGATGTCTAAAATTAACCATCAGAATATTTATGCCTGATTCATGGCTGAAATCGTGTTTGACCAGCTATGTGTGTCTCTCAATCCGATCAAGTAGATGTCTGAAATTAACCATCAGAATATTTATGCCTGATTCATGGCTGAAATTTCAGGATGACAGCTATGAAATCTCTATTTGTGTTTGTATATCTATTAATGTATGTTATGTATATGTGATATTTTCTTAACTCCAGAGAGCATTGCAAAATTCATTTATGAAATCCTCTAAAAGTGCTCTATTCTAACTTGGCTTGGAAAAAAATAAGCATTTATAAATAAATATTCACCAAACTCCTAGAAATATAGGAACTGATCAAATGTTTCTTAAGTTAACATGATTTGGATAAAACTTAGTTAAATAAGATTAATATAGTATTTTTGGTGTAATAAAACAACTATATCTTCAAAATTATCATTATTGAATATAAAACAAGCATAAATTCCTATTCTGCTTGAGTTCTAGTCAAATAAGCTAATATTATACTTACTAGAAACGTAAAATCTTAAAGCTTATAGATTTGATTCTAATTAAGTTGTCATTCTTATGAAAAACATTATTTTTTTATGCTGAAAAGATACACATATATTTAGAGTTAGCCAGCTGGACTCAGTTTAGGTGATCCCAATTTTGTTACAACATCGAAAGCATCATAATCAGGAGCAAGTCGAACATATGCCTTGTTCTCTTTATCAGGACAAATCAGGGTGGTGACCTTGGCCACATCACTGTCATAGAGCTTCTTCACAGCCTGTCTGATCTGGTGCTTGTTGGCTTTAACATCCACAGTGAACACAAGCGTGTTGTTTTCTTCTATCTTCTTCACGGCCGACTCAGTGGTCAGCGGAAACTTGATGATAGCATAGTGGCCAAGCTTGTTTCTCCTGGGGGTGCTCTTCCGAGGATATCTGGGCTGCCTCCGGAGTCGCAGTGTCTTGGGCCGCCTGAAGGTGAGTGACATGCGGATCTTCTTTTTTGCGTGTGGCTGCGGACACCTTTCAACACTGCCTTCTTGGCCTTTAAAGCCTTCGCTTTGGCTTCGGCTTTAGGAGGAGCAGGAGCTTCCTTCGCTTTCGGTGCCATCTTGTGAAAAGCGAAAAACATTATTTCAAAAATAATTTGTTTACAGTAAATCTGCCTATGAATAGTTTCCAAAGTACTTTTGGTAATTTTTAACCTTAAAGTTAAGCTAAGTAAAAGATTTGCATTAAATATCTAGACCATTTATAAATAAGATACAATACTAAAACATTAATTACTGAACATAAATAATTCAAGTTTATATACTTTTGGCTCCTATTTTTACAGAGAGACTAAAGATATTTTGGCCCGTTAATAAACATGTTTTTTTCTGCCACACTGAGGAATTGTATTATGAGGAAACACATCCCTCTAGATGTTGGGAGATGGTATATTCATACATTTTCTAACCTACTATAGAATGCTAATATATGACAGTTTATAACTGTCTACTTCCTAGTTTTCTCTGGAAAATAAAAGATTACTAAGTATTAAAATTATAATCAATATATGTAAATAAAACTACTAGAAATAATAGAATAACTAGAAACAACTCTATGCAAAGCATGCAAGAAAAGTAGGGCATGTTTCGCAAGTAAAGTAGGTTGCATTTTTTATAAGGAAAACCATACAGAAGATACAAATAAAAAGAGATACCTAACCTTCCCTGTGTTATATTTGTATGGGTAAAATGTTATGTTTTCAGAAATTATATAAAATTCCTGGAAGTTTGTCAATGTCCTCCTTATCCATGCTATGTGCCACTATAGAGTAATGAGTCATAATTCCAATTATTACTTTAAATGTTGTGCCAGGCACAGTGGCTCATGCCTATAATCCCAGCACTTTAGGAGGCTGAGGCGGGTGGATCACAAGGTCAGGAGATCCAGACCATCCTGGCTAACCCGGTGAATCTCCATCTCTATTAAAAATATAAAAAATTAGCCGGGCGTGATGGCAGGCACCTGTAGTCCCAGCTACTCGGGAGGCTGAGGCAGGAGAATGGCGTGAACCCAGGAGACAGAGCTTGCAGTGAGCCGAGATCGCACCGCTGCACTCCAGCCTGGGCGACAGAGCAAGACTCTGTCTCTAAATAAATAAATAAATAAATGTTGTCTGCCACAGAAAAAATCGAATAT";

  s1 =             "gattcatggctgaaatcgtgtttgaccagctatgtgtgtctctcaatccgatcaagtagatgtctaaaattaaccgtcagaatatttatgcctgattcatggctgaaattgtgtttgaccagctatgtgtgtctcttaatccactcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcacgtttgaccagctatgtgtgtctcttaatccagtcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcgtgtttgaccagctatgtgtgtctctcaatccgatcaagtagatgtctgaaattaaccatcagaatatttatgcctgattcatggctgaaatttcaggatgaaagctatgaaatctctatttgtgtttgtgtatctattaatgtatgttatgtatatgtgatattttcttaactccagagagcattgcaaaattcatttatgaaaacctctaaaagtgctctattctaacttggcttggaaaaaaataagcatttataaataaatattcaccaaactcctagaaatataggaactgatcaaatgtttcttaagttaacatgatttggataaaacttagttaaataagattaatatagtatttttggtgtaataaaacaactatatcttcaaaattatcattattgaatataaaacaagcataaattcctattctgcttgagttctagtcaaataagctaatattatacttactagaaacgtaaaatcttaaagcttatagatttgattctaattaagttgtcattcttatgaaaaacattattttttttatgctgaaaagatacacatatatttagagttagccagctggactcagtttaggtgatcccaattttgttacaacatcgaaagcatcataatcaggagcaagtcgaacatatgccttctctttatcaggacaaatcagggtggtgaccttggccacatcactgtcatagagcttcttcacagcctgtctgatctggtgcttgttggctttaacatccacagtgaacacaagcgtgttgttttcttctatcttcttcacggccgactcagtggtcagcggaaacttgatgatagcatagtggccaagcttgtttctcctgggggtgctcttccgaggatatctgggctgcctccggagtcgcagtgtcttgggccgcctgaaggtgagtgacatgcggatcttcttttttgcgtgtggctgcggacacctttcaacactgccttcttggcctttaaggccttcgctttggcttcggctttaggaggagcaggagcttccttcgctttcggtgccgtcttgtgaaaagcgaaaaacattatttcaaaaataatttgtttacagtaaatctgcctaagaatagtttccaaagtacttttggtaatttttaaccttaaagttaagctaagtaaaagatttgcattaaatatctagaccatttataaataagatacaatactaaaacattaattactgaacataaataattcaagtttatatacttttggcttcctgtttttacagagagactaaagatattttggcccgttaataaacatgtttttttctgccacactgaggaattgtattatgagaaaacacatccctctagatgttgggagatggtatattcatacattttctaacctactatagaatgctaatatatgacagtttataaccgtctacttcctagttttctctggaaaataaaagattactaagtattaaaattataatcaatatatgtaaataaaactactagaaataatagaataactagaaacaactctatgcaaagcatgcaagaaaagtagggcatgtttcgcaagtaaagtaggttgcattttttataaggaaaaccatacagaagatacaaataaaaagagatacctaaccttccctgtgttatatttgtatgggtaaaatgttatgttttcagaaattatataaaattcctggaagtttgtcaatgtcctccttatccatgctatgtgccactatagagtaatgagtcataattccaattattactttaaatgttgtgccaggcacagtggctcatgcctataatcccagcactttaggaggctgaggcgggtggatcacaaggtcaggagatccagaccatcctggttaactcggtgaatctccatctctattaaaaatataaaaaattagccgggcgtgatggaaggcacctgtagtcccagctactcgggaggctgaggcaggagaatggcgtgaacccaggagacagagcttgcagtgagccgagatcgcactgctgcactccagcctgggcgacagagcaagactctgtctctaaataaataaataaataaatgttgtctgccacagaaaaaatcgaatat";
  s2 =             "gattcatggctgaaatcatgtttgaccagctatgtgtgtctcttaatccagtcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcgtgtttgaccagctatgtgtgtctcttactccactcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcatgtttgaccagctatgtgtgtctcttaatccagtcaagtagatgtctaaaattaaccatcagaatatttatgcctgattcatggctgaaatcgtgtttgaccagctatgtgtgtctctcaatccgatcaagtagatgtctgaaattaaccatcagaatatttatgcctgattcatggctgaaatttcaggatgacagctatgaaatctctatttgtgtttgtatatctattaatgtatgttatgtatatgtgatattttcttaactccagagagcattgcaaaattcatttatgaaatcctctaaaagtgctctattctaacttggcttggaaaaaaataagcatttataaataaatattcaccaaactcctagaaatataggaactgatcaaatgtttcttaagttaacatgatttggataaaacttagttaaataagattaatatagtatttttggtgtaataaaacaactatatcttcaaaattatcattattgaatataaaacaagcataaattcctattctgcttgagttctagtcaaataagctaatattatacttactagaaacgtaaaatcttaaagcttatagatttgattctaattaagttgtcattcttatgaaaaacattatttttttatgctgaaaagatacacatatatttagagttagccagctggactcagtttaggtgatcccaattttgttacaacatcgaaagcatcataatcaggagcaagtcgaacatatgccttgttctctttatcaggacaaatcagggtggtgaccttggccacatcactgtcatagagcttcttcacagcctgtctgatctggtgcttgttggctttaacatccacagtgaacacaagcgtgttgttttcttctatcttcttcacggccgactcagtggtcagcggaaacttgatgatagcatagtggccaagcttgtttctcctgggggtgctcttccgaggatatctgggctgcctccggagtcgcagtgtcttgggccgcctgaaggtgagtgacatgcggatcttcttttttgcgtgtggctgcggacacctttcaacactgccttcttggcctttaaagccttcgctttggcttcggctttaggaggagcaggagcttccttcgctttcggtgccatcttgtgaaaagcgaaaaacattatttcaaaaataatttgtttacagtaaatctgcctatgaatagtttccaaagtacttttggtaatttttaaccttaaagttaagctaagtaaaagatttgcattaaatatctagaccatttataaataagatacaatactaaaacattaattactgaacataaataattcaagtttatatacttttggctcctatttttacagagagactaaagatattttggcccgttaataaacatgtttttttctgccacactgaggaattgtattatgaggaaacacatccctctagatgttgggagatggtatattcatacattttctaacctactatagaatgctaatatatgacagtttataactgtctacttcctagttttctctggaaaataaaagattactaagtattaaaattataatcaatatatgtaaataaaactactagaaataatagaataactagaaacaactctatgcaaagcatgcaagaaaagtagggcatgtttcgcaagtaaagtaggttgcattttttataaggaaaaccatacagaagatacaaataaaaagagatacctaaccttccctgtgttatatttgtatgggtaaaatgttatgttttcagaaattatataaaattcctggaagtttgtcaatgtcctccttatccatgctatgtgccactatagagtaatgagtcataattccaattattactttaaatgttgtgccaggcacagtggctcatgcctataatcccagcactttaggaggctgaggcgggtggatcacaaggtcaggagatccagaccatcctggctaacccggtgaatctccatctctattaaaaatataaaaaattagccgggcgtgatggcaggcacctgtagtcccagctactcgggaggctgaggcaggagaatggcgtgaacccaggagacagagcttgcagtgagccgagatcgcaccgctgcactccagcctgggcgacagagcaagactctgtctctaaataaataaataaataaatgttgtctgccacagaaaaaatcgaatat";

  char       *a1 = new char [10240];
  char       *a2 = new char [10240];

  halign(s1, s2,
         strlen(s1), strlen(s2),
         a1, a2);
  
  int  match = 0;
  int  mismatch = 0;
  int  gap = 0;

  for (int i=0; a1[i]; i++) {
    if ((a1[i] == '-') || (a2[i] == '-')) {
      gap++;
      a1[i] = toupper(a1[i]);
      a2[i] = toupper(a2[i]);
    } else if (a1[i] != a2[i]) {
      mismatch++;
      a1[i] = toupper(a1[i]);
      a2[i] = toupper(a2[i]);
    } else {
      match++;
      a1[i] = tolower(a1[i]);
      a2[i] = tolower(a2[i]);
    }
  }

  fprintf(stdout, "a1 = %s\n", a1);
  fprintf(stdout, "a2 = %s\n", a2);

  fprintf(stdout, "mismatch=%d gap=%d match=%d\n", mismatch, gap, match);
}


