/* LekhoneeDialogs.c generated by valac, the Vala compiler
 * generated from LekhoneeDialogs.vala, do not modify */

/* LekhoneeDialogs.vala
 *
 * Copyright (C) 2010  Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define TYPE_GENERIC_DIALOG (generic_dialog_get_type ())
#define GENERIC_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GENERIC_DIALOG, GenericDialog))
#define GENERIC_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GENERIC_DIALOG, GenericDialogClass))
#define IS_GENERIC_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GENERIC_DIALOG))
#define IS_GENERIC_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GENERIC_DIALOG))
#define GENERIC_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GENERIC_DIALOG, GenericDialogClass))

typedef struct _GenericDialog GenericDialog;
typedef struct _GenericDialogClass GenericDialogClass;
typedef struct _GenericDialogPrivate GenericDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CONFIG_DIALOG (config_dialog_get_type ())
#define CONFIG_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIG_DIALOG, ConfigDialog))
#define CONFIG_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIG_DIALOG, ConfigDialogClass))
#define IS_CONFIG_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIG_DIALOG))
#define IS_CONFIG_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIG_DIALOG))
#define CONFIG_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIG_DIALOG, ConfigDialogClass))

typedef struct _ConfigDialog ConfigDialog;
typedef struct _ConfigDialogClass ConfigDialogClass;
typedef struct _ConfigDialogPrivate ConfigDialogPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GenericDialog {
	GtkDialog parent_instance;
	GenericDialogPrivate * priv;
};

struct _GenericDialogClass {
	GtkDialogClass parent_class;
};

struct _GenericDialogPrivate {
	GtkEntry* link_entry;
	GtkWidget* apply_bttn;
};

struct _ConfigDialog {
	GtkDialog parent_instance;
	ConfigDialogPrivate * priv;
	GtkEntry* user_entry;
	GtkEntry* server_entry;
	GtkEntry* pass_entry;
	GtkCheckButton* advert;
	char* filename;
	char* server;
	char* username;
	gboolean ad;
	GKeyFile* keyf;
};

struct _ConfigDialogClass {
	GtkDialogClass parent_class;
};

struct _ConfigDialogPrivate {
	GtkWidget* apply_bttn;
};


static gpointer generic_dialog_parent_class = NULL;
static gpointer config_dialog_parent_class = NULL;

GType generic_dialog_get_type (void);
#define GENERIC_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GENERIC_DIALOG, GenericDialogPrivate))
enum  {
	GENERIC_DIALOG_DUMMY_PROPERTY
};
static void generic_dialog_create_widgets (GenericDialog* self, const char* text);
GenericDialog* generic_dialog_new (const char* text);
GenericDialog* generic_dialog_construct (GType object_type, const char* text);
static void generic_dialog_on_response (GenericDialog* self, GtkDialog* source, gint response_id);
static void _generic_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void generic_dialog_finalize (GObject* obj);
GType config_dialog_get_type (void);
#define CONFIG_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIG_DIALOG, ConfigDialogPrivate))
enum  {
	CONFIG_DIALOG_DUMMY_PROPERTY
};
static void config_dialog_create_widgets (ConfigDialog* self, const char* s, const char* u);
ConfigDialog* config_dialog_new (void);
ConfigDialog* config_dialog_construct (GType object_type);
static void config_dialog_on_response (ConfigDialog* self, GtkDialog* source, gint response_id);
static void _config_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void config_dialog_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GenericDialog* generic_dialog_construct (GType object_type, const char* text) {
	GenericDialog * self;
	g_return_val_if_fail (text != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtk_window_set_title ((GtkWindow*) self, text);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	gtk_window_set_default_size ((GtkWindow*) self, 350, 100);
	generic_dialog_create_widgets (self, text);
	return self;
}


GenericDialog* generic_dialog_new (const char* text) {
	return generic_dialog_construct (TYPE_GENERIC_DIALOG, text);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _generic_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	generic_dialog_on_response (self, _sender, response_id);
}


static void generic_dialog_create_widgets (GenericDialog* self, const char* text) {
	GtkEntry* _tmp0_;
	GtkLabel* link_label;
	GtkHBox* hbox;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	self->priv->link_entry = (_tmp0_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->link_entry), _tmp0_);
	link_label = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (text));
	gtk_label_set_mnemonic_widget (link_label, (GtkWidget*) self->priv->link_entry);
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 20));
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) link_label, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->link_entry, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) hbox, FALSE, TRUE, (guint) 0);
	gtk_box_set_spacing ((GtkBox*) ((GtkDialog*) self)->vbox, 10);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	self->priv->apply_bttn = (_tmp1_ = _g_object_ref0 (gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_APPLY, (gint) GTK_RESPONSE_APPLY)), _g_object_unref0 (self->priv->apply_bttn), _tmp1_);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _generic_dialog_on_response_gtk_dialog_response, self, 0);
	_g_object_unref0 (link_label);
	_g_object_unref0 (hbox);
}


static void generic_dialog_on_response (GenericDialog* self, GtkDialog* source, gint response_id) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	switch (response_id) {
		case GTK_RESPONSE_APPLY:
		{
			g_signal_emit_by_name (self, "send-link", gtk_entry_get_text (self->priv->link_entry));
			gtk_object_destroy ((GtkObject*) self);
			break;
		}
		case GTK_RESPONSE_CLOSE:
		{
			gtk_object_destroy ((GtkObject*) self);
			break;
		}
	}
}


static void generic_dialog_class_init (GenericDialogClass * klass) {
	generic_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GenericDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = generic_dialog_finalize;
	g_signal_new ("send_link", TYPE_GENERIC_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void generic_dialog_instance_init (GenericDialog * self) {
	self->priv = GENERIC_DIALOG_GET_PRIVATE (self);
}


static void generic_dialog_finalize (GObject* obj) {
	GenericDialog * self;
	self = GENERIC_DIALOG (obj);
	_g_object_unref0 (self->priv->link_entry);
	_g_object_unref0 (self->priv->apply_bttn);
	G_OBJECT_CLASS (generic_dialog_parent_class)->finalize (obj);
}


GType generic_dialog_get_type (void) {
	static volatile gsize generic_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&generic_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GenericDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) generic_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GenericDialog), 0, (GInstanceInitFunc) generic_dialog_instance_init, NULL };
		GType generic_dialog_type_id;
		generic_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "GenericDialog", &g_define_type_info, 0);
		g_once_init_leave (&generic_dialog_type_id__volatile, generic_dialog_type_id);
	}
	return generic_dialog_type_id__volatile;
}


ConfigDialog* config_dialog_construct (GType object_type) {
	GError * _inner_error_;
	ConfigDialog * self;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	GKeyFile* _tmp3_;
	_inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	gtk_window_set_title ((GtkWindow*) self, _ ("Preferences"));
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	gtk_window_set_default_size ((GtkWindow*) self, 350, 150);
	self->server = (_tmp0_ = g_strdup (""), _g_free0 (self->server), _tmp0_);
	self->username = (_tmp1_ = g_strdup (""), _g_free0 (self->username), _tmp1_);
	self->filename = (_tmp2_ = g_strconcat (g_get_home_dir (), "/.lekhonee.config", NULL), _g_free0 (self->filename), _tmp2_);
	self->keyf = (_tmp3_ = g_key_file_new (), _g_key_file_free0 (self->keyf), _tmp3_);
	{
		char* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		char* _tmp7_;
		g_key_file_load_from_file (self->keyf, self->filename, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp4_ = g_key_file_get_string (self->keyf, "details", "server", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		self->server = (_tmp5_ = _tmp4_, _g_free0 (self->server), _tmp5_);
		_tmp6_ = g_key_file_get_string (self->keyf, "details", "username", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		self->username = (_tmp7_ = _tmp6_, _g_free0 (self->username), _tmp7_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_debug ("LekhoneeDialogs.vala:102: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	config_dialog_create_widgets (self, self->server, self->username);
	return self;
}


ConfigDialog* config_dialog_new (void) {
	return config_dialog_construct (TYPE_CONFIG_DIALOG);
}


static void _config_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	config_dialog_on_response (self, _sender, response_id);
}


static void config_dialog_create_widgets (ConfigDialog* self, const char* s, const char* u) {
	GtkHBox* box;
	GtkLabel* link_label;
	GtkEntry* _tmp0_;
	GtkTable* table;
	GtkLabel* user_label;
	GtkEntry* _tmp1_;
	GtkHBox* _tmp2_;
	GtkLabel* pass_label;
	GtkEntry* _tmp3_;
	GtkHBox* _tmp4_;
	GtkHBox* _tmp5_;
	GtkCheckButton* _tmp6_;
	GtkWidget* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (u != NULL);
	box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
	link_label = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic ("Server: "));
	self->server_entry = (_tmp0_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->server_entry), _tmp0_);
	if (_vala_strcmp0 (s, "") != 0) {
		gtk_entry_set_text (self->server_entry, s);
	} else {
		gtk_entry_set_text (self->server_entry, "http://userserver.org/xmlrpc.php");
	}
	gtk_label_set_mnemonic_widget (link_label, (GtkWidget*) self->server_entry);
	table = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 3, (guint) 2, FALSE));
	gtk_table_set_row_spacings (table, (guint) 5);
	gtk_table_set_col_spacings (table, (guint) 5);
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) link_label, FALSE, FALSE, (guint) 5);
	gtk_table_attach (table, (GtkWidget*) box, (guint) 0, (guint) 1, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (table, (GtkWidget*) self->server_entry, (guint) 1, (guint) 2, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	user_label = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic ("Username: "));
	self->user_entry = (_tmp1_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->user_entry), _tmp1_);
	gtk_entry_set_text (self->user_entry, u);
	gtk_label_set_mnemonic_widget (user_label, (GtkWidget*) self->user_entry);
	box = (_tmp2_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (box), _tmp2_);
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) user_label, FALSE, FALSE, (guint) 5);
	gtk_table_attach (table, (GtkWidget*) box, (guint) 0, (guint) 1, (guint) 1, (guint) 2, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (table, (GtkWidget*) self->user_entry, (guint) 1, (guint) 2, (guint) 1, (guint) 2, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	pass_label = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic ("Password: "));
	self->pass_entry = (_tmp3_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->pass_entry), _tmp3_);
	gtk_entry_set_invisible_char (self->pass_entry, (gunichar) '*');
	gtk_entry_set_visibility (self->pass_entry, FALSE);
	gtk_label_set_mnemonic_widget (pass_label, (GtkWidget*) self->pass_entry);
	box = (_tmp4_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (box), _tmp4_);
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) pass_label, FALSE, FALSE, (guint) 5);
	gtk_table_attach (table, (GtkWidget*) box, (guint) 0, (guint) 1, (guint) 2, (guint) 3, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (table, (GtkWidget*) self->pass_entry, (guint) 1, (guint) 2, (guint) 2, (guint) 3, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	box = (_tmp5_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (box), _tmp5_);
	gtk_table_attach (table, (GtkWidget*) box, (guint) 1, (guint) 2, (guint) 3, (guint) 4, GTK_EXPAND, GTK_EXPAND, (guint) 0, (guint) 0);
	self->advert = (_tmp6_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new ()), _g_object_unref0 (self->advert), _tmp6_);
	gtk_button_set_label ((GtkButton*) self->advert, "Show the lekhonee message in the posts");
	gtk_toggle_button_set_active ((GtkToggleButton*) self->advert, TRUE);
	gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) table, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) self->advert, FALSE, TRUE, (guint) 0);
	gtk_box_set_spacing ((GtkBox*) ((GtkDialog*) self)->vbox, 10);
	self->priv->apply_bttn = (_tmp7_ = _g_object_ref0 (gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_OK)), _g_object_unref0 (self->priv->apply_bttn), _tmp7_);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _config_dialog_on_response_gtk_dialog_response, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (link_label);
	_g_object_unref0 (table);
	_g_object_unref0 (user_label);
	_g_object_unref0 (pass_label);
}


static void config_dialog_on_response (ConfigDialog* self, GtkDialog* source, gint response_id) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_inner_error_ = NULL;
	switch (response_id) {
		case GTK_RESPONSE_OK:
		{
			char* _tmp0_;
			char* _tmp1_;
			gsize length = 0UL;
			GError* e;
			GError* _tmp4_;
			char* _tmp3_;
			GError* _tmp2_ = NULL;
			char* data;
			GFile* fcon;
			GFileOutputStream* file_stream;
			GDataOutputStream* data_stream;
			char* password;
			self->server = (_tmp0_ = g_strdup (gtk_entry_get_text (self->server_entry)), _g_free0 (self->server), _tmp0_);
			self->username = (_tmp1_ = g_strdup (gtk_entry_get_text (self->user_entry)), _g_free0 (self->username), _tmp1_);
			if ((_vala_strcmp0 (self->server, "") == 0) | (_vala_strcmp0 (self->username, "") == 0)) {
				return;
			}
			self->ad = gtk_toggle_button_get_active ((GtkToggleButton*) self->advert);
			g_key_file_set_string (self->keyf, "details", "server", self->server);
			g_key_file_set_string (self->keyf, "details", "username", self->username);
			e = NULL;
			data = (_tmp3_ = g_key_file_to_data (self->keyf, &length, &_tmp2_), e = (_tmp4_ = _tmp2_, _g_error_free0 (e), _tmp4_), _tmp3_);
			fcon = g_file_new_for_path (self->filename);
			if (g_file_query_exists (fcon, NULL)) {
				g_file_delete (fcon, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_error_free0 (e);
					_g_free0 (data);
					_g_object_unref0 (fcon);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			file_stream = g_file_create (fcon, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_error_free0 (e);
				_g_free0 (data);
				_g_object_unref0 (fcon);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			data_stream = g_data_output_stream_new ((GOutputStream*) file_stream);
			g_data_output_stream_put_string (data_stream, data, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_error_free0 (e);
				_g_free0 (data);
				_g_object_unref0 (fcon);
				_g_object_unref0 (file_stream);
				_g_object_unref0 (data_stream);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			gtk_widget_hide_all ((GtkWidget*) self);
			password = g_strdup (gtk_entry_get_text (self->pass_entry));
			g_signal_emit_by_name (self, "config-done", self->server, self->username, password, self->ad);
			_g_error_free0 (e);
			_g_free0 (data);
			_g_object_unref0 (fcon);
			_g_object_unref0 (file_stream);
			_g_object_unref0 (data_stream);
			_g_free0 (password);
			break;
		}
	}
}


static void config_dialog_class_init (ConfigDialogClass * klass) {
	config_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ConfigDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = config_dialog_finalize;
	g_signal_new ("config_done", TYPE_CONFIG_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
}


static void config_dialog_instance_init (ConfigDialog * self) {
	self->priv = CONFIG_DIALOG_GET_PRIVATE (self);
}


static void config_dialog_finalize (GObject* obj) {
	ConfigDialog * self;
	self = CONFIG_DIALOG (obj);
	_g_object_unref0 (self->priv->apply_bttn);
	_g_object_unref0 (self->user_entry);
	_g_object_unref0 (self->server_entry);
	_g_object_unref0 (self->pass_entry);
	_g_object_unref0 (self->advert);
	_g_free0 (self->filename);
	_g_free0 (self->server);
	_g_free0 (self->username);
	_g_key_file_free0 (self->keyf);
	G_OBJECT_CLASS (config_dialog_parent_class)->finalize (obj);
}


GType config_dialog_get_type (void) {
	static volatile gsize config_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&config_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigDialog), 0, (GInstanceInitFunc) config_dialog_instance_init, NULL };
		GType config_dialog_type_id;
		config_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ConfigDialog", &g_define_type_info, 0);
		g_once_init_leave (&config_dialog_type_id__volatile, config_dialog_type_id);
	}
	return config_dialog_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_BOOLEAN) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gboolean arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_boolean (param_values + 4), data2);
}



