<?php
//    MyDMS. Document Management System
//    Copyright (C) 2010 Matteo Lucarelli
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.DBInit.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

if (!$user->isAdmin()) {
	UI::exitError(getMLText("admin_tools"),getMLText("access_denied"));
}

if (!isset($_GET["arkname"]) || !file_exists($settings->_contentDir.$_GET["arkname"]) ) {
	UI::exitError(getMLText("admin_tools"),getMLText("unknown_id"));
}

$arkname = $_GET["arkname"];

UI::htmlStartPage(getMLText("backup_tools"));
UI::globalNavigation();
UI::pageNavigation(getMLText("admin_tools"), "admin_tools");
UI::contentHeading(getMLText("backup_remove"));
UI::contentContainerStart();

?>
<form action="../op/op.RemoveArchive.php" name="form1" method="POST">
	<input type="Hidden" name="arkname" value="<?php echo sanitizeString($arkname); ?>">
  <?php echo createHiddenFieldWithKey('removearchive'); ?>
	<p><?php printMLText("confirm_rm_backup", array ("arkname" => sanitizeString($arkname)));?></p>
	<input type="Submit" value="<?php printMLText("backup_remove");?>">
</form>
<?php
UI::contentContainerEnd();
UI::htmlEndPage();
?>
