; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumbv6m-none-eabi | FileCheck %s --check-prefix=CHECKV6M
; RUN: llc < %s -mtriple=thumbv7m-none-eabi | FileCheck %s --check-prefix=CHECKV7M
; RUN: llc < %s -mtriple=thumbv7a-none-eabi | FileCheck %s --check-prefix=CHECKV7A

define i32 @icmp64_sge_0(i64 %x, i64 %y, i32 %a, i32 %b, i1 %c) {
; CHECKV6M-LABEL: icmp64_sge_0:
; CHECKV6M:       @ %bb.0:
; CHECKV6M-NEXT:    ldr r0, [sp, #8]
; CHECKV6M-NEXT:    lsls r0, r0, #31
; CHECKV6M-NEXT:    ldr r2, [sp, #4]
; CHECKV6M-NEXT:    ldr r0, [sp]
; CHECKV6M-NEXT:    beq .LBB0_4
; CHECKV6M-NEXT:  @ %bb.1: @ %then
; CHECKV6M-NEXT:    cmp r3, #0
; CHECKV6M-NEXT:    mov r3, r0
; CHECKV6M-NEXT:    blt .LBB0_7
; CHECKV6M-NEXT:  @ %bb.2: @ %then
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    blt .LBB0_8
; CHECKV6M-NEXT:  .LBB0_3: @ %then
; CHECKV6M-NEXT:    adds r0, r0, r3
; CHECKV6M-NEXT:    bx lr
; CHECKV6M-NEXT:  .LBB0_4: @ %else
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    bge .LBB0_6
; CHECKV6M-NEXT:  @ %bb.5: @ %else
; CHECKV6M-NEXT:    mov r0, r2
; CHECKV6M-NEXT:  .LBB0_6: @ %else
; CHECKV6M-NEXT:    bx lr
; CHECKV6M-NEXT:  .LBB0_7: @ %then
; CHECKV6M-NEXT:    mov r3, r2
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    bge .LBB0_3
; CHECKV6M-NEXT:  .LBB0_8: @ %then
; CHECKV6M-NEXT:    mov r0, r2
; CHECKV6M-NEXT:    adds r0, r0, r3
; CHECKV6M-NEXT:    bx lr
;
; CHECKV7M-LABEL: icmp64_sge_0:
; CHECKV7M:       @ %bb.0:
; CHECKV7M-NEXT:    ldr r0, [sp, #8]
; CHECKV7M-NEXT:    lsls r0, r0, #31
; CHECKV7M-NEXT:    ldrd r2, r0, [sp]
; CHECKV7M-NEXT:    beq .LBB0_2
; CHECKV7M-NEXT:  @ %bb.1: @ %then
; CHECKV7M-NEXT:    cmp.w r3, #-1
; CHECKV7M-NEXT:    mov r3, r0
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r3, r2
; CHECKV7M-NEXT:    cmp.w r1, #-1
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r0, r2
; CHECKV7M-NEXT:    add r0, r3
; CHECKV7M-NEXT:    bx lr
; CHECKV7M-NEXT:  .LBB0_2: @ %else
; CHECKV7M-NEXT:    cmp.w r1, #-1
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r0, r2
; CHECKV7M-NEXT:    bx lr
;
; CHECKV7A-LABEL: icmp64_sge_0:
; CHECKV7A:       @ %bb.0:
; CHECKV7A-NEXT:    ldr r2, [sp, #8]
; CHECKV7A-NEXT:    ldrd r12, r0, [sp]
; CHECKV7A-NEXT:    lsls r2, r2, #31
; CHECKV7A-NEXT:    beq .LBB0_2
; CHECKV7A-NEXT:  @ %bb.1: @ %then
; CHECKV7A-NEXT:    cmp.w r3, #-1
; CHECKV7A-NEXT:    mov r2, r0
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r2, r12
; CHECKV7A-NEXT:    cmp.w r1, #-1
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r0, r12
; CHECKV7A-NEXT:    add r0, r2
; CHECKV7A-NEXT:    bx lr
; CHECKV7A-NEXT:  .LBB0_2: @ %else
; CHECKV7A-NEXT:    cmp.w r1, #-1
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r0, r12
; CHECKV7A-NEXT:    bx lr
  br i1 %c, label %then, label %else
then:
  %c1 = icmp sge i64 %x, 0
  %c2 = icmp sge i64 %y, 0
  %s1 = select i1 %c1, i32 %a, i32 %b
  %s2 = select i1 %c2, i32 %a, i32 %b
  %r = add i32 %s1, %s2
  ret i32 %r
else:
  %c3 = icmp sge i64 %x, 0
  %s3 = select i1 %c3, i32 %a, i32 %b
  ret i32 %s3
}

define i32 @icmp64_sgt_m1(i64 %x, i64 %y, i32 %a, i32 %b, i1 %c) {
; CHECKV6M-LABEL: icmp64_sgt_m1:
; CHECKV6M:       @ %bb.0:
; CHECKV6M-NEXT:    ldr r0, [sp, #8]
; CHECKV6M-NEXT:    lsls r0, r0, #31
; CHECKV6M-NEXT:    ldr r2, [sp, #4]
; CHECKV6M-NEXT:    ldr r0, [sp]
; CHECKV6M-NEXT:    beq .LBB1_4
; CHECKV6M-NEXT:  @ %bb.1: @ %then
; CHECKV6M-NEXT:    cmp r3, #0
; CHECKV6M-NEXT:    mov r3, r0
; CHECKV6M-NEXT:    blt .LBB1_7
; CHECKV6M-NEXT:  @ %bb.2: @ %then
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    blt .LBB1_8
; CHECKV6M-NEXT:  .LBB1_3: @ %then
; CHECKV6M-NEXT:    adds r0, r0, r3
; CHECKV6M-NEXT:    bx lr
; CHECKV6M-NEXT:  .LBB1_4: @ %else
; CHECKV6M-NEXT:    cmp r3, #0
; CHECKV6M-NEXT:    bge .LBB1_6
; CHECKV6M-NEXT:  @ %bb.5: @ %else
; CHECKV6M-NEXT:    mov r0, r2
; CHECKV6M-NEXT:  .LBB1_6: @ %else
; CHECKV6M-NEXT:    bx lr
; CHECKV6M-NEXT:  .LBB1_7: @ %then
; CHECKV6M-NEXT:    mov r3, r2
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    bge .LBB1_3
; CHECKV6M-NEXT:  .LBB1_8: @ %then
; CHECKV6M-NEXT:    mov r0, r2
; CHECKV6M-NEXT:    adds r0, r0, r3
; CHECKV6M-NEXT:    bx lr
;
; CHECKV7M-LABEL: icmp64_sgt_m1:
; CHECKV7M:       @ %bb.0:
; CHECKV7M-NEXT:    ldr r0, [sp, #8]
; CHECKV7M-NEXT:    lsls r0, r0, #31
; CHECKV7M-NEXT:    ldrd r2, r0, [sp]
; CHECKV7M-NEXT:    beq .LBB1_2
; CHECKV7M-NEXT:  @ %bb.1: @ %then
; CHECKV7M-NEXT:    cmp.w r3, #-1
; CHECKV7M-NEXT:    mov r3, r0
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r3, r2
; CHECKV7M-NEXT:    cmp.w r1, #-1
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r0, r2
; CHECKV7M-NEXT:    add r0, r3
; CHECKV7M-NEXT:    bx lr
; CHECKV7M-NEXT:  .LBB1_2: @ %else
; CHECKV7M-NEXT:    cmp.w r3, #-1
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r0, r2
; CHECKV7M-NEXT:    bx lr
;
; CHECKV7A-LABEL: icmp64_sgt_m1:
; CHECKV7A:       @ %bb.0:
; CHECKV7A-NEXT:    ldr r2, [sp, #8]
; CHECKV7A-NEXT:    ldrd r12, r0, [sp]
; CHECKV7A-NEXT:    lsls r2, r2, #31
; CHECKV7A-NEXT:    beq .LBB1_2
; CHECKV7A-NEXT:  @ %bb.1: @ %then
; CHECKV7A-NEXT:    cmp.w r3, #-1
; CHECKV7A-NEXT:    mov r2, r0
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r2, r12
; CHECKV7A-NEXT:    cmp.w r1, #-1
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r0, r12
; CHECKV7A-NEXT:    add r0, r2
; CHECKV7A-NEXT:    bx lr
; CHECKV7A-NEXT:  .LBB1_2: @ %else
; CHECKV7A-NEXT:    cmp.w r3, #-1
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r0, r12
; CHECKV7A-NEXT:    bx lr
  br i1 %c, label %then, label %else
then:
  %c1 = icmp sgt i64 %x, -1
  %c2 = icmp sgt i64 %y, -1
  %s1 = select i1 %c1, i32 %a, i32 %b
  %s2 = select i1 %c2, i32 %a, i32 %b
  %r = add i32 %s1, %s2
  ret i32 %r
else:
  %c3 = icmp sgt i64 %y, -1
  %s3 = select i1 %c3, i32 %a, i32 %b
  ret i32 %s3
}

define i32 @icmp32_sge_0(i32 %x, i32 %y, i32 %a, i32 %b, i1 %c) {
; CHECKV6M-LABEL: icmp32_sge_0:
; CHECKV6M:       @ %bb.0:
; CHECKV6M-NEXT:    .save {r4, lr}
; CHECKV6M-NEXT:    push {r4, lr}
; CHECKV6M-NEXT:    ldr r4, [sp, #8]
; CHECKV6M-NEXT:    lsls r4, r4, #31
; CHECKV6M-NEXT:    beq .LBB2_4
; CHECKV6M-NEXT:  @ %bb.1: @ %then
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    mov r1, r2
; CHECKV6M-NEXT:    blt .LBB2_7
; CHECKV6M-NEXT:  @ %bb.2: @ %then
; CHECKV6M-NEXT:    cmp r0, #0
; CHECKV6M-NEXT:    blt .LBB2_8
; CHECKV6M-NEXT:  .LBB2_3: @ %then
; CHECKV6M-NEXT:    adds r0, r2, r1
; CHECKV6M-NEXT:    pop {r4, pc}
; CHECKV6M-NEXT:  .LBB2_4: @ %else
; CHECKV6M-NEXT:    cmp r0, #0
; CHECKV6M-NEXT:    bge .LBB2_6
; CHECKV6M-NEXT:  @ %bb.5: @ %else
; CHECKV6M-NEXT:    mov r2, r3
; CHECKV6M-NEXT:  .LBB2_6: @ %else
; CHECKV6M-NEXT:    mov r0, r2
; CHECKV6M-NEXT:    pop {r4, pc}
; CHECKV6M-NEXT:  .LBB2_7: @ %then
; CHECKV6M-NEXT:    mov r1, r3
; CHECKV6M-NEXT:    cmp r0, #0
; CHECKV6M-NEXT:    bge .LBB2_3
; CHECKV6M-NEXT:  .LBB2_8: @ %then
; CHECKV6M-NEXT:    mov r2, r3
; CHECKV6M-NEXT:    adds r0, r2, r1
; CHECKV6M-NEXT:    pop {r4, pc}
;
; CHECKV7M-LABEL: icmp32_sge_0:
; CHECKV7M:       @ %bb.0:
; CHECKV7M-NEXT:    mov r12, r3
; CHECKV7M-NEXT:    ldr r3, [sp]
; CHECKV7M-NEXT:    lsls r3, r3, #31
; CHECKV7M-NEXT:    beq .LBB2_2
; CHECKV7M-NEXT:  @ %bb.1: @ %then
; CHECKV7M-NEXT:    cmp.w r1, #-1
; CHECKV7M-NEXT:    mov r1, r12
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r1, r2
; CHECKV7M-NEXT:    cmp.w r0, #-1
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r12, r2
; CHECKV7M-NEXT:    add.w r0, r12, r1
; CHECKV7M-NEXT:    bx lr
; CHECKV7M-NEXT:  .LBB2_2: @ %else
; CHECKV7M-NEXT:    cmp.w r0, #-1
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r12, r2
; CHECKV7M-NEXT:    mov r0, r12
; CHECKV7M-NEXT:    bx lr
;
; CHECKV7A-LABEL: icmp32_sge_0:
; CHECKV7A:       @ %bb.0:
; CHECKV7A-NEXT:    mov r12, r3
; CHECKV7A-NEXT:    ldr r3, [sp]
; CHECKV7A-NEXT:    lsls r3, r3, #31
; CHECKV7A-NEXT:    beq .LBB2_2
; CHECKV7A-NEXT:  @ %bb.1: @ %then
; CHECKV7A-NEXT:    cmp.w r1, #-1
; CHECKV7A-NEXT:    mov r1, r12
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r1, r2
; CHECKV7A-NEXT:    cmp.w r0, #-1
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r12, r2
; CHECKV7A-NEXT:    add.w r0, r12, r1
; CHECKV7A-NEXT:    bx lr
; CHECKV7A-NEXT:  .LBB2_2: @ %else
; CHECKV7A-NEXT:    cmp.w r0, #-1
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r12, r2
; CHECKV7A-NEXT:    mov r0, r12
; CHECKV7A-NEXT:    bx lr
  br i1 %c, label %then, label %else
then:
  %c1 = icmp sge i32 %x, 0
  %c2 = icmp sge i32 %y, 0
  %s1 = select i1 %c1, i32 %a, i32 %b
  %s2 = select i1 %c2, i32 %a, i32 %b
  %r = add i32 %s1, %s2
  ret i32 %r
else:
  %c3 = icmp sge i32 %x, 0
  %s3 = select i1 %c3, i32 %a, i32 %b
  ret i32 %s3
}

define i32 @icmp32_sgt_m1(i32 %x, i32 %y, i32 %a, i32 %b, i1 %c) {
; CHECKV6M-LABEL: icmp32_sgt_m1:
; CHECKV6M:       @ %bb.0:
; CHECKV6M-NEXT:    .save {r4, lr}
; CHECKV6M-NEXT:    push {r4, lr}
; CHECKV6M-NEXT:    ldr r4, [sp, #8]
; CHECKV6M-NEXT:    lsls r4, r4, #31
; CHECKV6M-NEXT:    beq .LBB3_4
; CHECKV6M-NEXT:  @ %bb.1: @ %then
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    mov r1, r2
; CHECKV6M-NEXT:    blt .LBB3_7
; CHECKV6M-NEXT:  @ %bb.2: @ %then
; CHECKV6M-NEXT:    cmp r0, #0
; CHECKV6M-NEXT:    blt .LBB3_8
; CHECKV6M-NEXT:  .LBB3_3: @ %then
; CHECKV6M-NEXT:    adds r0, r2, r1
; CHECKV6M-NEXT:    pop {r4, pc}
; CHECKV6M-NEXT:  .LBB3_4: @ %else
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    bge .LBB3_6
; CHECKV6M-NEXT:  @ %bb.5: @ %else
; CHECKV6M-NEXT:    mov r2, r3
; CHECKV6M-NEXT:  .LBB3_6: @ %else
; CHECKV6M-NEXT:    mov r0, r2
; CHECKV6M-NEXT:    pop {r4, pc}
; CHECKV6M-NEXT:  .LBB3_7: @ %then
; CHECKV6M-NEXT:    mov r1, r3
; CHECKV6M-NEXT:    cmp r0, #0
; CHECKV6M-NEXT:    bge .LBB3_3
; CHECKV6M-NEXT:  .LBB3_8: @ %then
; CHECKV6M-NEXT:    mov r2, r3
; CHECKV6M-NEXT:    adds r0, r2, r1
; CHECKV6M-NEXT:    pop {r4, pc}
;
; CHECKV7M-LABEL: icmp32_sgt_m1:
; CHECKV7M:       @ %bb.0:
; CHECKV7M-NEXT:    mov r12, r3
; CHECKV7M-NEXT:    ldr r3, [sp]
; CHECKV7M-NEXT:    lsls r3, r3, #31
; CHECKV7M-NEXT:    beq .LBB3_2
; CHECKV7M-NEXT:  @ %bb.1: @ %then
; CHECKV7M-NEXT:    cmp.w r1, #-1
; CHECKV7M-NEXT:    mov r1, r12
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r1, r2
; CHECKV7M-NEXT:    cmp.w r0, #-1
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r12, r2
; CHECKV7M-NEXT:    add.w r0, r12, r1
; CHECKV7M-NEXT:    bx lr
; CHECKV7M-NEXT:  .LBB3_2: @ %else
; CHECKV7M-NEXT:    cmp.w r1, #-1
; CHECKV7M-NEXT:    it gt
; CHECKV7M-NEXT:    movgt r12, r2
; CHECKV7M-NEXT:    mov r0, r12
; CHECKV7M-NEXT:    bx lr
;
; CHECKV7A-LABEL: icmp32_sgt_m1:
; CHECKV7A:       @ %bb.0:
; CHECKV7A-NEXT:    mov r12, r3
; CHECKV7A-NEXT:    ldr r3, [sp]
; CHECKV7A-NEXT:    lsls r3, r3, #31
; CHECKV7A-NEXT:    beq .LBB3_2
; CHECKV7A-NEXT:  @ %bb.1: @ %then
; CHECKV7A-NEXT:    cmp.w r1, #-1
; CHECKV7A-NEXT:    mov r1, r12
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r1, r2
; CHECKV7A-NEXT:    cmp.w r0, #-1
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r12, r2
; CHECKV7A-NEXT:    add.w r0, r12, r1
; CHECKV7A-NEXT:    bx lr
; CHECKV7A-NEXT:  .LBB3_2: @ %else
; CHECKV7A-NEXT:    cmp.w r1, #-1
; CHECKV7A-NEXT:    it gt
; CHECKV7A-NEXT:    movgt r12, r2
; CHECKV7A-NEXT:    mov r0, r12
; CHECKV7A-NEXT:    bx lr
  br i1 %c, label %then, label %else
then:
  %c1 = icmp sgt i32 %x, -1
  %c2 = icmp sgt i32 %y, -1
  %s1 = select i1 %c1, i32 %a, i32 %b
  %s2 = select i1 %c2, i32 %a, i32 %b
  %r = add i32 %s1, %s2
  ret i32 %r
else:
  %c3 = icmp sgt i32 %y, -1
  %s3 = select i1 %c3, i32 %a, i32 %b
  ret i32 %s3
}

define i32 @icmp64_sle_m1(i64 %x, i64 %y, i32 %a, i32 %b, i1 %c) {
; CHECKV6M-LABEL: icmp64_sle_m1:
; CHECKV6M:       @ %bb.0:
; CHECKV6M-NEXT:    ldr r0, [sp, #8]
; CHECKV6M-NEXT:    lsls r0, r0, #31
; CHECKV6M-NEXT:    ldr r2, [sp, #4]
; CHECKV6M-NEXT:    ldr r0, [sp]
; CHECKV6M-NEXT:    beq .LBB4_4
; CHECKV6M-NEXT:  @ %bb.1: @ %then
; CHECKV6M-NEXT:    cmp r3, #0
; CHECKV6M-NEXT:    mov r3, r0
; CHECKV6M-NEXT:    bpl .LBB4_7
; CHECKV6M-NEXT:  @ %bb.2: @ %then
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    bpl .LBB4_8
; CHECKV6M-NEXT:  .LBB4_3: @ %then
; CHECKV6M-NEXT:    adds r0, r0, r3
; CHECKV6M-NEXT:    bx lr
; CHECKV6M-NEXT:  .LBB4_4: @ %else
; CHECKV6M-NEXT:    cmp r3, #0
; CHECKV6M-NEXT:    bmi .LBB4_6
; CHECKV6M-NEXT:  @ %bb.5: @ %else
; CHECKV6M-NEXT:    mov r0, r2
; CHECKV6M-NEXT:  .LBB4_6: @ %else
; CHECKV6M-NEXT:    bx lr
; CHECKV6M-NEXT:  .LBB4_7: @ %then
; CHECKV6M-NEXT:    mov r3, r2
; CHECKV6M-NEXT:    cmp r1, #0
; CHECKV6M-NEXT:    bmi .LBB4_3
; CHECKV6M-NEXT:  .LBB4_8: @ %then
; CHECKV6M-NEXT:    mov r0, r2
; CHECKV6M-NEXT:    adds r0, r0, r3
; CHECKV6M-NEXT:    bx lr
;
; CHECKV7M-LABEL: icmp64_sle_m1:
; CHECKV7M:       @ %bb.0:
; CHECKV7M-NEXT:    ldr r0, [sp, #8]
; CHECKV7M-NEXT:    lsls r0, r0, #31
; CHECKV7M-NEXT:    ldrd r2, r0, [sp]
; CHECKV7M-NEXT:    beq .LBB4_2
; CHECKV7M-NEXT:  @ %bb.1: @ %then
; CHECKV7M-NEXT:    cmp r3, #0
; CHECKV7M-NEXT:    mov r3, r0
; CHECKV7M-NEXT:    it mi
; CHECKV7M-NEXT:    movmi r3, r2
; CHECKV7M-NEXT:    cmp r1, #0
; CHECKV7M-NEXT:    it mi
; CHECKV7M-NEXT:    movmi r0, r2
; CHECKV7M-NEXT:    add r0, r3
; CHECKV7M-NEXT:    bx lr
; CHECKV7M-NEXT:  .LBB4_2: @ %else
; CHECKV7M-NEXT:    cmp r3, #0
; CHECKV7M-NEXT:    it mi
; CHECKV7M-NEXT:    movmi r0, r2
; CHECKV7M-NEXT:    bx lr
;
; CHECKV7A-LABEL: icmp64_sle_m1:
; CHECKV7A:       @ %bb.0:
; CHECKV7A-NEXT:    ldr r2, [sp, #8]
; CHECKV7A-NEXT:    ldrd r12, r0, [sp]
; CHECKV7A-NEXT:    lsls r2, r2, #31
; CHECKV7A-NEXT:    beq .LBB4_2
; CHECKV7A-NEXT:  @ %bb.1: @ %then
; CHECKV7A-NEXT:    cmp r3, #0
; CHECKV7A-NEXT:    mov r2, r0
; CHECKV7A-NEXT:    it mi
; CHECKV7A-NEXT:    movmi r2, r12
; CHECKV7A-NEXT:    cmp r1, #0
; CHECKV7A-NEXT:    it mi
; CHECKV7A-NEXT:    movmi r0, r12
; CHECKV7A-NEXT:    add r0, r2
; CHECKV7A-NEXT:    bx lr
; CHECKV7A-NEXT:  .LBB4_2: @ %else
; CHECKV7A-NEXT:    cmp r3, #0
; CHECKV7A-NEXT:    it mi
; CHECKV7A-NEXT:    movmi r0, r12
; CHECKV7A-NEXT:    bx lr
  br i1 %c, label %then, label %else
then:
  %c1 = icmp sle i64 %x, -1
  %c2 = icmp sle i64 %y, -1
  %s1 = select i1 %c1, i32 %a, i32 %b
  %s2 = select i1 %c2, i32 %a, i32 %b
  %r = add i32 %s1, %s2
  ret i32 %r
else:
  %c3 = icmp sle i64 %y, -1
  %s3 = select i1 %c3, i32 %a, i32 %b
  ret i32 %s3
}

define i32 @icmp64_ule_m1(i64 %x, i64 %y, i32 %a, i32 %b, i1 %c) {
; CHECKV6M-LABEL: icmp64_ule_m1:
; CHECKV6M:       @ %bb.0:
; CHECKV6M-NEXT:    .save {r4, r5, r6, r7, lr}
; CHECKV6M-NEXT:    push {r4, r5, r6, r7, lr}
; CHECKV6M-NEXT:    mov r4, r0
; CHECKV6M-NEXT:    ldr r0, [sp, #28]
; CHECKV6M-NEXT:    lsls r0, r0, #31
; CHECKV6M-NEXT:    ldr r6, .LCPI5_0
; CHECKV6M-NEXT:    ldr r5, [sp, #24]
; CHECKV6M-NEXT:    ldr r0, [sp, #20]
; CHECKV6M-NEXT:    beq .LBB5_6
; CHECKV6M-NEXT:  @ %bb.1: @ %then
; CHECKV6M-NEXT:    movs r7, #0
; CHECKV6M-NEXT:    subs r2, r2, r6
; CHECKV6M-NEXT:    sbcs r3, r7
; CHECKV6M-NEXT:    mov r2, r0
; CHECKV6M-NEXT:    blo .LBB5_3
; CHECKV6M-NEXT:  @ %bb.2: @ %then
; CHECKV6M-NEXT:    mov r2, r5
; CHECKV6M-NEXT:  .LBB5_3: @ %then
; CHECKV6M-NEXT:    subs r3, r4, r6
; CHECKV6M-NEXT:    sbcs r1, r7
; CHECKV6M-NEXT:    blo .LBB5_5
; CHECKV6M-NEXT:  @ %bb.4: @ %then
; CHECKV6M-NEXT:    mov r0, r5
; CHECKV6M-NEXT:  .LBB5_5: @ %then
; CHECKV6M-NEXT:    adds r0, r0, r2
; CHECKV6M-NEXT:    pop {r4, r5, r6, r7, pc}
; CHECKV6M-NEXT:  .LBB5_6: @ %else
; CHECKV6M-NEXT:    movs r1, #0
; CHECKV6M-NEXT:    subs r2, r2, r6
; CHECKV6M-NEXT:    sbcs r3, r1
; CHECKV6M-NEXT:    blo .LBB5_8
; CHECKV6M-NEXT:  @ %bb.7: @ %else
; CHECKV6M-NEXT:    mov r0, r5
; CHECKV6M-NEXT:  .LBB5_8: @ %else
; CHECKV6M-NEXT:    pop {r4, r5, r6, r7, pc}
; CHECKV6M-NEXT:    .p2align 2
; CHECKV6M-NEXT:  @ %bb.9:
; CHECKV6M-NEXT:  .LCPI5_0:
; CHECKV6M-NEXT:    .long 131073 @ 0x20001
;
; CHECKV7M-LABEL: icmp64_ule_m1:
; CHECKV7M:       @ %bb.0:
; CHECKV7M-NEXT:    .save {r4, lr}
; CHECKV7M-NEXT:    push {r4, lr}
; CHECKV7M-NEXT:    mov r12, r0
; CHECKV7M-NEXT:    ldr r0, [sp, #16]
; CHECKV7M-NEXT:    movs r4, #1
; CHECKV7M-NEXT:    movt r4, #2
; CHECKV7M-NEXT:    lsls r0, r0, #31
; CHECKV7M-NEXT:    ldrd lr, r0, [sp, #8]
; CHECKV7M-NEXT:    beq .LBB5_2
; CHECKV7M-NEXT:  @ %bb.1: @ %then
; CHECKV7M-NEXT:    subs r2, r2, r4
; CHECKV7M-NEXT:    sbcs r2, r3, #0
; CHECKV7M-NEXT:    mov r2, r0
; CHECKV7M-NEXT:    it lo
; CHECKV7M-NEXT:    movlo r2, lr
; CHECKV7M-NEXT:    subs.w r3, r12, r4
; CHECKV7M-NEXT:    sbcs r1, r1, #0
; CHECKV7M-NEXT:    it lo
; CHECKV7M-NEXT:    movlo r0, lr
; CHECKV7M-NEXT:    add r0, r2
; CHECKV7M-NEXT:    pop {r4, pc}
; CHECKV7M-NEXT:  .LBB5_2: @ %else
; CHECKV7M-NEXT:    subs r1, r2, r4
; CHECKV7M-NEXT:    sbcs r1, r3, #0
; CHECKV7M-NEXT:    it lo
; CHECKV7M-NEXT:    movlo r0, lr
; CHECKV7M-NEXT:    pop {r4, pc}
;
; CHECKV7A-LABEL: icmp64_ule_m1:
; CHECKV7A:       @ %bb.0:
; CHECKV7A-NEXT:    .save {r4, lr}
; CHECKV7A-NEXT:    push {r4, lr}
; CHECKV7A-NEXT:    ldr r4, [sp, #16]
; CHECKV7A-NEXT:    mov r12, r0
; CHECKV7A-NEXT:    ldrd lr, r0, [sp, #8]
; CHECKV7A-NEXT:    lsls r4, r4, #31
; CHECKV7A-NEXT:    movw r4, #1
; CHECKV7A-NEXT:    movt r4, #2
; CHECKV7A-NEXT:    beq .LBB5_2
; CHECKV7A-NEXT:  @ %bb.1: @ %then
; CHECKV7A-NEXT:    subs r2, r2, r4
; CHECKV7A-NEXT:    sbcs r2, r3, #0
; CHECKV7A-NEXT:    mov r2, r0
; CHECKV7A-NEXT:    it lo
; CHECKV7A-NEXT:    movlo r2, lr
; CHECKV7A-NEXT:    subs.w r3, r12, r4
; CHECKV7A-NEXT:    sbcs r1, r1, #0
; CHECKV7A-NEXT:    it lo
; CHECKV7A-NEXT:    movlo r0, lr
; CHECKV7A-NEXT:    add r0, r2
; CHECKV7A-NEXT:    pop {r4, pc}
; CHECKV7A-NEXT:  .LBB5_2: @ %else
; CHECKV7A-NEXT:    subs r1, r2, r4
; CHECKV7A-NEXT:    sbcs r1, r3, #0
; CHECKV7A-NEXT:    it lo
; CHECKV7A-NEXT:    movlo r0, lr
; CHECKV7A-NEXT:    pop {r4, pc}
  br i1 %c, label %then, label %else
then:
  %c1 = icmp ult i64 %x, 131073
  %c2 = icmp ult i64 %y, 131073
  %s1 = select i1 %c1, i32 %a, i32 %b
  %s2 = select i1 %c2, i32 %a, i32 %b
  %r = add i32 %s1, %s2
  ret i32 %r
else:
  %c3 = icmp ult i64 %y, 131073
  %s3 = select i1 %c3, i32 %a, i32 %b
  ret i32 %s3
}

define i32 @icmp64_uge_m2(i64 %x, i64 %y, i32 %a, i32 %b, i1 %c) {
; CHECKV6M-LABEL: icmp64_uge_m2:
; CHECKV6M:       @ %bb.0:
; CHECKV6M-NEXT:    .save {r4, r5, r6, r7, lr}
; CHECKV6M-NEXT:    push {r4, r5, r6, r7, lr}
; CHECKV6M-NEXT:    mov r4, r0
; CHECKV6M-NEXT:    movs r0, #1
; CHECKV6M-NEXT:    lsls r6, r0, #17
; CHECKV6M-NEXT:    ldr r0, [sp, #28]
; CHECKV6M-NEXT:    lsls r0, r0, #31
; CHECKV6M-NEXT:    ldr r5, [sp, #24]
; CHECKV6M-NEXT:    ldr r0, [sp, #20]
; CHECKV6M-NEXT:    beq .LBB6_6
; CHECKV6M-NEXT:  @ %bb.1: @ %then
; CHECKV6M-NEXT:    movs r7, #0
; CHECKV6M-NEXT:    subs r2, r2, r6
; CHECKV6M-NEXT:    sbcs r3, r7
; CHECKV6M-NEXT:    mov r2, r0
; CHECKV6M-NEXT:    bhs .LBB6_3
; CHECKV6M-NEXT:  @ %bb.2: @ %then
; CHECKV6M-NEXT:    mov r2, r5
; CHECKV6M-NEXT:  .LBB6_3: @ %then
; CHECKV6M-NEXT:    subs r3, r4, r6
; CHECKV6M-NEXT:    sbcs r1, r7
; CHECKV6M-NEXT:    bhs .LBB6_5
; CHECKV6M-NEXT:  @ %bb.4: @ %then
; CHECKV6M-NEXT:    mov r0, r5
; CHECKV6M-NEXT:  .LBB6_5: @ %then
; CHECKV6M-NEXT:    adds r0, r0, r2
; CHECKV6M-NEXT:    pop {r4, r5, r6, r7, pc}
; CHECKV6M-NEXT:  .LBB6_6: @ %else
; CHECKV6M-NEXT:    movs r1, #0
; CHECKV6M-NEXT:    subs r2, r2, r6
; CHECKV6M-NEXT:    sbcs r3, r1
; CHECKV6M-NEXT:    bhs .LBB6_8
; CHECKV6M-NEXT:  @ %bb.7: @ %else
; CHECKV6M-NEXT:    mov r0, r5
; CHECKV6M-NEXT:  .LBB6_8: @ %else
; CHECKV6M-NEXT:    pop {r4, r5, r6, r7, pc}
;
; CHECKV7M-LABEL: icmp64_uge_m2:
; CHECKV7M:       @ %bb.0:
; CHECKV7M-NEXT:    .save {r7, lr}
; CHECKV7M-NEXT:    push {r7, lr}
; CHECKV7M-NEXT:    mov r12, r0
; CHECKV7M-NEXT:    ldr r0, [sp, #16]
; CHECKV7M-NEXT:    lsls r0, r0, #31
; CHECKV7M-NEXT:    ldrd lr, r0, [sp, #8]
; CHECKV7M-NEXT:    beq .LBB6_2
; CHECKV7M-NEXT:  @ %bb.1: @ %then
; CHECKV7M-NEXT:    lsrs r2, r2, #17
; CHECKV7M-NEXT:    orr.w r2, r2, r3, lsl #15
; CHECKV7M-NEXT:    orr.w r2, r2, r3, lsr #17
; CHECKV7M-NEXT:    lsr.w r3, r12, #17
; CHECKV7M-NEXT:    orr.w r3, r3, r1, lsl #15
; CHECKV7M-NEXT:    cmp r2, #0
; CHECKV7M-NEXT:    mov r2, r0
; CHECKV7M-NEXT:    orr.w r1, r3, r1, lsr #17
; CHECKV7M-NEXT:    it ne
; CHECKV7M-NEXT:    movne r2, lr
; CHECKV7M-NEXT:    cmp r1, #0
; CHECKV7M-NEXT:    it ne
; CHECKV7M-NEXT:    movne r0, lr
; CHECKV7M-NEXT:    add r0, r2
; CHECKV7M-NEXT:    pop {r7, pc}
; CHECKV7M-NEXT:  .LBB6_2: @ %else
; CHECKV7M-NEXT:    lsrs r1, r2, #17
; CHECKV7M-NEXT:    orr.w r1, r1, r3, lsl #15
; CHECKV7M-NEXT:    orr.w r1, r1, r3, lsr #17
; CHECKV7M-NEXT:    cmp r1, #0
; CHECKV7M-NEXT:    it ne
; CHECKV7M-NEXT:    movne r0, lr
; CHECKV7M-NEXT:    pop {r7, pc}
;
; CHECKV7A-LABEL: icmp64_uge_m2:
; CHECKV7A:       @ %bb.0:
; CHECKV7A-NEXT:    .save {r4, lr}
; CHECKV7A-NEXT:    push {r4, lr}
; CHECKV7A-NEXT:    ldr r4, [sp, #16]
; CHECKV7A-NEXT:    mov r12, r0
; CHECKV7A-NEXT:    ldrd lr, r0, [sp, #8]
; CHECKV7A-NEXT:    lsls r4, r4, #31
; CHECKV7A-NEXT:    beq .LBB6_2
; CHECKV7A-NEXT:  @ %bb.1: @ %then
; CHECKV7A-NEXT:    lsrs r2, r2, #17
; CHECKV7A-NEXT:    orr.w r2, r2, r3, lsl #15
; CHECKV7A-NEXT:    orr.w r2, r2, r3, lsr #17
; CHECKV7A-NEXT:    lsr.w r3, r12, #17
; CHECKV7A-NEXT:    orr.w r3, r3, r1, lsl #15
; CHECKV7A-NEXT:    cmp r2, #0
; CHECKV7A-NEXT:    mov r2, r0
; CHECKV7A-NEXT:    orr.w r1, r3, r1, lsr #17
; CHECKV7A-NEXT:    it ne
; CHECKV7A-NEXT:    movne r2, lr
; CHECKV7A-NEXT:    cmp r1, #0
; CHECKV7A-NEXT:    it ne
; CHECKV7A-NEXT:    movne r0, lr
; CHECKV7A-NEXT:    add r0, r2
; CHECKV7A-NEXT:    pop {r4, pc}
; CHECKV7A-NEXT:  .LBB6_2: @ %else
; CHECKV7A-NEXT:    lsrs r1, r2, #17
; CHECKV7A-NEXT:    orr.w r1, r1, r3, lsl #15
; CHECKV7A-NEXT:    orr.w r1, r1, r3, lsr #17
; CHECKV7A-NEXT:    cmp r1, #0
; CHECKV7A-NEXT:    it ne
; CHECKV7A-NEXT:    movne r0, lr
; CHECKV7A-NEXT:    pop {r4, pc}
  br i1 %c, label %then, label %else
then:
  %c1 = icmp uge i64 %x, 131072
  %c2 = icmp uge i64 %y, 131072
  %s1 = select i1 %c1, i32 %a, i32 %b
  %s2 = select i1 %c2, i32 %a, i32 %b
  %r = add i32 %s1, %s2
  ret i32 %r
else:
  %c3 = icmp uge i64 %y, 131072
  %s3 = select i1 %c3, i32 %a, i32 %b
  ret i32 %s3
}

define i32 @icmp64_ugt_m1(i64 %x, i64 %y, i32 %a, i32 %b, i1 %c) {
; CHECKV6M-LABEL: icmp64_ugt_m1:
; CHECKV6M:       @ %bb.0:
; CHECKV6M-NEXT:    .save {r4, r5, r6, r7, lr}
; CHECKV6M-NEXT:    push {r4, r5, r6, r7, lr}
; CHECKV6M-NEXT:    mov r4, r0
; CHECKV6M-NEXT:    ldr r0, [sp, #28]
; CHECKV6M-NEXT:    lsls r0, r0, #31
; CHECKV6M-NEXT:    ldr r6, .LCPI7_0
; CHECKV6M-NEXT:    ldr r5, [sp, #24]
; CHECKV6M-NEXT:    ldr r0, [sp, #20]
; CHECKV6M-NEXT:    beq .LBB7_6
; CHECKV6M-NEXT:  @ %bb.1: @ %then
; CHECKV6M-NEXT:    movs r7, #0
; CHECKV6M-NEXT:    subs r2, r6, r2
; CHECKV6M-NEXT:    mov r2, r7
; CHECKV6M-NEXT:    sbcs r2, r3
; CHECKV6M-NEXT:    mov r2, r0
; CHECKV6M-NEXT:    blo .LBB7_3
; CHECKV6M-NEXT:  @ %bb.2: @ %then
; CHECKV6M-NEXT:    mov r2, r5
; CHECKV6M-NEXT:  .LBB7_3: @ %then
; CHECKV6M-NEXT:    subs r3, r6, r4
; CHECKV6M-NEXT:    sbcs r7, r1
; CHECKV6M-NEXT:    blo .LBB7_5
; CHECKV6M-NEXT:  @ %bb.4: @ %then
; CHECKV6M-NEXT:    mov r0, r5
; CHECKV6M-NEXT:  .LBB7_5: @ %then
; CHECKV6M-NEXT:    adds r0, r0, r2
; CHECKV6M-NEXT:    pop {r4, r5, r6, r7, pc}
; CHECKV6M-NEXT:  .LBB7_6: @ %else
; CHECKV6M-NEXT:    movs r1, #0
; CHECKV6M-NEXT:    subs r2, r6, r2
; CHECKV6M-NEXT:    sbcs r1, r3
; CHECKV6M-NEXT:    blo .LBB7_8
; CHECKV6M-NEXT:  @ %bb.7: @ %else
; CHECKV6M-NEXT:    mov r0, r5
; CHECKV6M-NEXT:  .LBB7_8: @ %else
; CHECKV6M-NEXT:    pop {r4, r5, r6, r7, pc}
; CHECKV6M-NEXT:    .p2align 2
; CHECKV6M-NEXT:  @ %bb.9:
; CHECKV6M-NEXT:  .LCPI7_0:
; CHECKV6M-NEXT:    .long 131073 @ 0x20001
;
; CHECKV7M-LABEL: icmp64_ugt_m1:
; CHECKV7M:       @ %bb.0:
; CHECKV7M-NEXT:    .save {r4, r5, r7, lr}
; CHECKV7M-NEXT:    push {r4, r5, r7, lr}
; CHECKV7M-NEXT:    mov r12, r0
; CHECKV7M-NEXT:    ldr r0, [sp, #24]
; CHECKV7M-NEXT:    movs r4, #1
; CHECKV7M-NEXT:    movt r4, #2
; CHECKV7M-NEXT:    lsls r0, r0, #31
; CHECKV7M-NEXT:    ldrd lr, r0, [sp, #16]
; CHECKV7M-NEXT:    beq .LBB7_2
; CHECKV7M-NEXT:  @ %bb.1: @ %then
; CHECKV7M-NEXT:    subs r2, r4, r2
; CHECKV7M-NEXT:    mov.w r5, #0
; CHECKV7M-NEXT:    sbcs.w r2, r5, r3
; CHECKV7M-NEXT:    mov r2, r0
; CHECKV7M-NEXT:    it lo
; CHECKV7M-NEXT:    movlo r2, lr
; CHECKV7M-NEXT:    subs.w r3, r4, r12
; CHECKV7M-NEXT:    sbcs.w r1, r5, r1
; CHECKV7M-NEXT:    it lo
; CHECKV7M-NEXT:    movlo r0, lr
; CHECKV7M-NEXT:    add r0, r2
; CHECKV7M-NEXT:    pop {r4, r5, r7, pc}
; CHECKV7M-NEXT:  .LBB7_2: @ %else
; CHECKV7M-NEXT:    movs r1, #0
; CHECKV7M-NEXT:    subs r2, r4, r2
; CHECKV7M-NEXT:    sbcs r1, r3
; CHECKV7M-NEXT:    it lo
; CHECKV7M-NEXT:    movlo r0, lr
; CHECKV7M-NEXT:    pop {r4, r5, r7, pc}
;
; CHECKV7A-LABEL: icmp64_ugt_m1:
; CHECKV7A:       @ %bb.0:
; CHECKV7A-NEXT:    .save {r4, r5, r7, lr}
; CHECKV7A-NEXT:    push {r4, r5, r7, lr}
; CHECKV7A-NEXT:    ldr r4, [sp, #24]
; CHECKV7A-NEXT:    mov r12, r0
; CHECKV7A-NEXT:    ldrd lr, r0, [sp, #16]
; CHECKV7A-NEXT:    lsls r4, r4, #31
; CHECKV7A-NEXT:    movw r4, #1
; CHECKV7A-NEXT:    movt r4, #2
; CHECKV7A-NEXT:    beq .LBB7_2
; CHECKV7A-NEXT:  @ %bb.1: @ %then
; CHECKV7A-NEXT:    subs r2, r4, r2
; CHECKV7A-NEXT:    mov.w r5, #0
; CHECKV7A-NEXT:    sbcs.w r2, r5, r3
; CHECKV7A-NEXT:    mov r2, r0
; CHECKV7A-NEXT:    it lo
; CHECKV7A-NEXT:    movlo r2, lr
; CHECKV7A-NEXT:    subs.w r3, r4, r12
; CHECKV7A-NEXT:    sbcs.w r1, r5, r1
; CHECKV7A-NEXT:    it lo
; CHECKV7A-NEXT:    movlo r0, lr
; CHECKV7A-NEXT:    add r0, r2
; CHECKV7A-NEXT:    pop {r4, r5, r7, pc}
; CHECKV7A-NEXT:  .LBB7_2: @ %else
; CHECKV7A-NEXT:    movs r1, #0
; CHECKV7A-NEXT:    subs r2, r4, r2
; CHECKV7A-NEXT:    sbcs r1, r3
; CHECKV7A-NEXT:    it lo
; CHECKV7A-NEXT:    movlo r0, lr
; CHECKV7A-NEXT:    pop {r4, r5, r7, pc}
  br i1 %c, label %then, label %else
then:
  %c1 = icmp ugt i64 %x, 131073
  %c2 = icmp ugt i64 %y, 131073
  %s1 = select i1 %c1, i32 %a, i32 %b
  %s2 = select i1 %c2, i32 %a, i32 %b
  %r = add i32 %s1, %s2
  ret i32 %r
else:
  %c3 = icmp ugt i64 %y, 131073
  %s3 = select i1 %c3, i32 %a, i32 %b
  ret i32 %s3
}
