/* ----- encode/1013x2393round, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1013x2393round_checksums[] = {
  "f75c0afa30054add70fba4f12d5da9eea18fbd3a1331033a378bb4c618de81a5",
  "daab9407d45841416f8d74109a9ac3e9979213074e580c1779fdb76239959dd2",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1013x2393round_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1013x2393round_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1013x2393round_ITEMBYTES

static void *storage_encode_1013x2393round_s;
static unsigned char *test_encode_1013x2393round_s;
static void *storage_encode_1013x2393round_x;
static unsigned char *test_encode_1013x2393round_x;
static void *storage_encode_1013x2393round_s2;
static unsigned char *test_encode_1013x2393round_s2;
static void *storage_encode_1013x2393round_x2;
static unsigned char *test_encode_1013x2393round_x2;

#define precomputed_encode_1013x2393round_NUM 4

static const unsigned char precomputed_encode_1013x2393round_s[precomputed_encode_1013x2393round_NUM][crypto_encode_STRBYTES] = {
  {80,171,95,96,95,247,94,195,139,53,189,34,213,197,147,90,252,178,13,20,218,114,168,147,212,203,125,37,240,170,208,232,74,55,96,197,173,209,87,64,81,13,194,133,39,123,131,15,107,44,4,106,85,12,165,240,12,42,190,132,76,74,204,76,225,37,142,85,106,129,154,177,247,110,223,174,113,243,100,100,165,52,197,46,161,217,110,198,171,125,39,149,227,27,212,1,71,139,191,48,196,182,101,182,133,230,32,180,124,145,113,155,221,178,53,150,245,247,143,176,128,149,97,0,128,14,176,5,28,245,204,195,254,16,185,216,16,153,237,254,220,91,34,210,218,237,166,230,140,160,253,18,188,49,249,143,134,171,159,195,148,84,205,228,146,113,232,136,212,78,68,196,103,112,196,249,133,212,199,2,126,142,226,46,46,149,48,1,75,35,1,180,186,7,156,132,41,241,9,46,254,209,90,79,229,77,99,164,5,98,26,163,65,26,51,202,226,117,31,62,176,170,247,194,115,165,12,170,131,125,42,226,161,185,88,17,88,216,37,14,49,174,159,33,144,122,99,246,215,45,224,70,56,231,223,220,102,182,164,144,96,200,110,137,228,153,189,118,129,229,147,216,205,200,208,181,22,139,61,240,24,203,134,230,38,175,169,170,187,241,159,84,83,167,164,202,29,55,118,175,1,24,64,165,60,53,163,66,155,56,105,114,160,99,62,168,76,249,113,81,90,142,79,124,136,187,247,186,44,28,94,232,111,240,2,105,81,148,17,64,137,58,91,248,144,25,175,254,138,229,216,93,166,67,109,73,115,63,105,7,131,228,103,111,129,54,54,237,218,31,232,154,48,77,22,68,66,52,2,105,38,135,113,131,187,250,100,200,58,163,141,215,20,93,177,183,240,255,40,140,66,158,179,117,245,79,170,109,65,58,197,40,84,90,224,203,180,157,247,138,59,99,107,207,1,29,43,3,55,237,110,178,95,127,139,242,202,82,38,233,24,210,115,193,4,57,57,223,167,157,162,196,22,41,59,6,18,195,207,212,189,66,154,136,171,236,210,253,194,182,236,169,188,166,64,26,212,46,243,32,247,82,65,144,22,109,207,236,234,111,217,27,209,26,204,255,54,62,114,89,69,49,218,153,46,8,252,3,116,78,36,44,63,7,58,127,118,83,148,4,143,107,188,252,95,237,147,0,245,109,145,211,123,200,136,163,218,119,168,176,22,191,30,120,141,189,186,190,12,140,123,79,204,189,221,224,251,7,156,157,8,18,0,168,203,163,10,159,148,204,5,76,228,239,77,29,198,134,191,60,90,179,158,174,65,178,38,251,97,65,197,172,247,255,103,134,176,106,199,42,79,163,161,23,74,155,185,3,185,13,116,197,103,214,102,151,99,143,28,203,221,29,87,192,169,102,81,45,164,46,250,136,40,220,145,226,55,211,159,48,186,13,84,122,1,53,81,187,18,248,71,168,75,38,44,165,85,93,191,39,4,252,89,113,225,170,227,61,161,251,250,239,62,130,79,170,209,249,71,70,36,33,131,68,113,210,155,140,199,85,101,165,175,162,80,74,208,89,230,53,219,98,81,175,61,188,176,129,114,238,203,92,117,160,213,4,199,173,134,1,205,68,117,154,192,215,200,167,104,246,244,7,175,157,45,199,239,161,240,53,143,234,37,125,141,12,65,98,188,166,163,233,252,13,207,51,94,20,142,35,160,218,145,5,51,104,125,209,41,100,169,41,21,132,6,8,252,166,45,99,246,129,130,30,48,131,70,227,227,71,192,139,139,128,132,57,111,215,241,107,201,214,243,114,29,20,165,254,47,177,235,208,85,221,197,113,79,183,238,112,171,168,246,129,20,130,123,62,33,229,230,91,36,238,46,167,65,31,122,104,67,129,124,200,144,153,64,180,2,64,160,24,140,159,158,152,199,100,70,174,249,94,74,192,72,242,11,51,181,190,153,85,247,145,26,39,47,123,215,224,46,134,50,89,39,204,181,236,130,227,40,198,228,101,230,2,21,254,136,8,18,161,56,167,22,127,120,117,238,197,179,146,47,95,226,251,177,31,41,156,59,2,165,92,133,88,208,98,234,164,99,187,208,8,136,3,27,150,147,107,103,92,240,129,196,104,178,193,155,186,119,136,24,70,35,59,230,10,3,143,119,253,47,253,124,177,212,196,71,61,47,158,5,206,193,141,124,40,224,35,21,112,177,104,120,59,18,152,3,90,221,240,160,148,219,98,42,85,76,120,120,219,15,173,87,139,155,145,219,233,102,46,208,211,220,176,219,220,124,81,131,238,255,62,96,114,171,8,17,209,219,192,2,97,118,57,82,100,194,169,192,58,107,192,173,223,95,109,151,211,63,221,120,255,177,207,162,163,62,30,166,83,188,93,78,156,31,67,78,91,59,59,158,166,54,23,44,111,8,228,33,235,46,90,119,30,84,22,21,161,90,12,124,87,2,207,77,9,179,28,213,117,218,37,163,207,230,114,39,227,81,193,194,176,78,169,115,234,226,174,84,35,228,224,224,115,194,179,57,60,207,124,114,37,61,139,242,132,23,3,134,186,243,228,145,17,174,90,224,235,196,114,165,169,176,227,179,183,166,75,215,61,0,149,180,32,81,140,35,93,166,237,224,110,16,56,251,144,68,60,162,210,199,106,38,151,254,153,20,253,234,94,126,75,25,11,111,238,221,179,229,14,105,210,9,242,13,45,115,98,80,188,90,216,242,128,238,218,138,166,239,97,85,180,114,106,162,14,111,46,168,220,226,114,239,171,240,32,114,49,147,35,111,68,93,218,81,162,28,234,180,159,137,14,200,96,244,143,90,122,189,147,175,171,178,99,163,30,99,230,126,69,235,226,137,224,217,225,139,211,243,32,164,17,227,12,21,129,16,47,17,31,147,132,29,135,226,167,65,26,248,59,191,12,61,79,193,141,184,145,220,146,246,157,230,214,40,140,165,103,104,186,94,201,162,160,29,132,155,83,87,115,222,236,12,179,72,16,238,184,214,68,102,187,71,70,88,182,182,247,227,15,187,143,196,212,6,108,24,145,78,23,254,5,107,221,72,89,23,137,162,182,218,235,199,76,164,96,140,162,166,215,227,79,187,237,21,58,102,9,13,39,167,102,8,228,8,106,66,99,190,166,122,20,228,132,93,174,222,58,251,49,138,204,149,29,147,164,117,194,121,107,2},
  {139,234,192,162,85,14,68,82,250,177,234,200,221,212,45,2,139,25,128,108,23,21,115,2,129,212,14,58,94,84,35,188,190,229,130,94,39,11,75,103,5,45,83,242,134,103,215,194,243,15,215,185,180,13,103,86,222,184,119,97,195,82,234,210,224,237,15,212,216,221,20,2,241,3,206,247,249,120,235,205,32,140,107,217,223,140,141,61,166,155,151,186,222,21,160,107,35,93,163,114,25,4,171,100,159,8,59,149,130,40,177,86,63,167,194,3,79,171,23,160,77,173,134,219,195,212,177,69,131,6,172,158,165,200,72,138,125,223,184,108,196,238,129,196,10,140,156,195,102,220,35,95,84,129,210,235,32,150,238,14,144,94,63,149,235,216,127,151,196,77,221,13,74,164,133,9,123,127,91,28,87,246,108,169,233,41,7,172,227,210,62,83,204,174,221,117,125,10,128,156,50,177,180,112,14,255,42,35,217,27,158,92,248,239,146,167,237,34,100,237,179,250,177,40,44,164,24,172,85,198,222,127,163,45,0,99,141,20,101,205,65,14,55,98,39,155,26,149,69,233,138,85,240,235,112,128,196,209,18,93,23,44,19,18,48,175,156,64,163,162,229,162,189,196,129,74,66,47,10,152,87,124,128,36,9,44,26,62,133,168,76,2,111,10,154,33,100,103,113,217,214,118,151,135,86,140,204,235,214,130,63,103,34,138,86,197,208,105,248,129,164,93,94,206,49,56,219,111,84,233,141,142,17,174,199,2,130,93,203,252,197,240,54,219,235,131,80,56,122,72,250,149,144,219,87,150,75,96,32,202,159,36,114,176,57,96,19,97,228,8,94,91,19,119,57,125,10,38,216,55,207,249,137,228,238,146,107,187,127,238,173,21,59,109,215,89,101,255,164,176,143,0,132,110,22,104,203,28,77,163,153,68,227,248,232,47,66,101,115,184,140,104,173,96,90,100,221,61,48,168,194,124,177,114,122,23,32,145,150,154,192,99,101,63,213,10,104,182,212,59,5,114,226,15,59,95,140,151,86,228,150,104,70,66,254,213,238,228,59,144,32,53,84,231,141,69,174,125,121,183,214,123,8,83,136,103,166,224,141,196,117,24,246,229,206,113,200,1,129,197,240,234,90,70,243,214,207,118,252,34,3,33,77,121,78,169,214,79,228,141,112,240,44,194,49,65,127,167,12,110,188,46,165,191,29,57,254,170,215,0,47,237,182,239,99,94,72,65,22,93,188,97,102,240,221,205,75,95,137,89,182,75,10,19,56,221,128,168,7,209,225,116,126,11,73,194,77,196,205,78,107,165,66,121,89,234,254,211,77,72,83,54,181,216,204,146,14,92,205,44,174,113,192,220,83,156,69,88,136,113,234,115,128,103,161,136,16,92,242,153,214,107,155,109,239,114,169,64,39,114,63,164,199,76,128,182,135,193,166,107,188,131,202,222,213,55,183,154,176,67,136,66,135,205,180,76,150,197,86,41,8,127,109,51,214,184,189,22,3,69,45,21,35,60,228,181,169,19,91,147,170,254,26,230,160,29,246,178,47,234,218,76,4,52,170,100,221,104,33,110,98,214,235,242,150,173,178,65,218,182,79,224,242,223,164,100,58,141,192,205,55,10,231,213,56,111,108,192,137,34,156,98,171,222,92,202,211,14,97,250,36,80,143,226,146,112,184,135,27,74,13,133,8,143,159,179,243,47,240,233,101,152,144,220,30,185,156,169,206,49,214,152,194,91,89,161,125,5,45,87,226,101,105,154,210,125,40,104,10,150,140,172,187,148,152,190,46,2,193,112,191,196,159,41,72,235,10,7,120,13,208,171,100,18,47,163,189,240,232,180,170,32,225,192,86,166,156,56,179,144,99,200,147,160,95,86,27,176,175,152,235,166,111,199,78,64,188,134,88,210,115,142,197,121,190,220,50,106,238,248,140,46,65,40,149,107,111,250,106,225,120,71,85,59,165,143,92,48,179,254,191,221,124,87,182,212,91,123,93,24,214,241,12,106,169,159,139,15,95,0,131,159,125,49,95,229,252,173,42,92,5,215,93,138,119,230,40,188,78,254,225,196,52,19,13,236,186,179,194,238,100,169,14,241,32,78,79,135,7,16,58,92,92,190,253,196,124,12,230,29,40,32,149,23,143,176,154,176,21,90,68,250,227,129,140,56,54,171,77,40,121,81,194,134,150,157,3,7,25,97,64,226,192,191,156,142,221,192,188,34,36,191,36,37,195,50,125,213,132,84,108,12,234,160,220,44,84,102,33,31,8,55,118,173,6,55,13,140,23,61,98,154,254,228,136,156,190,141,213,96,4,177,190,255,17,212,100,32,140,223,233,66,146,106,97,212,179,81,170,164,89,63,81,12,99,189,8,35,158,126,58,80,243,195,201,209,236,231,4,11,5,152,61,105,35,120,187,25,25,144,187,192,42,79,103,254,11,43,214,211,35,160,211,193,171,236,101,172,123,155,180,188,34,70,82,181,140,138,102,69,196,192,134,111,59,173,135,86,82,101,21,137,246,146,233,134,170,91,54,25,161,112,14,251,88,106,186,249,147,37,174,105,11,21,184,178,225,7,248,26,45,245,190,39,188,91,110,121,30,38,255,243,72,154,203,10,191,101,164,246,27,212,152,164,181,220,33,89,40,71,198,148,246,173,100,113,242,207,3,236,25,198,158,91,240,241,54,1,34,170,196,170,168,229,60,20,221,157,33,150,139,251,203,136,93,201,67,8,208,11,210,128,157,180,30,122,236,166,171,12,197,148,95,30,26,161,154,82,238,137,131,57,145,240,139,161,152,0,248,34,219,20,252,138,64,35,78,101,146,90,234,120,133,6,190,254,191,12,63,199,73,167,33,13,169,105,244,15,53,1,146,195,46,88,224,225,121,157,236,148,208,69,217,217,217,228,84,55,10,49,73,224,230,156,31,89,75,4,227,25,130,60,138,92,201,209,61,73,143,153,145,26,45,1,118,66,32,141,229,111,162,236,13,10,58,44,116,0,70,242,5,149,83,8,57,31,128,184,186,37,151,3,171,219,57,171,238,146,252,198,20,208,93,195,191,59,136,185,180,250,178,159,242,207,170,247,121,217,24,255,86,15,129,131,19,86,159,113,252,248,109,194,251,61,80,101,29,177,204,56,193,96,94,215,179,22,1,74,248,38,73,57,85,75,41,52,89,106,83,238,150,75,0},
  {132,181,3,175,2,120,220,214,162,96,106,19,27,61,222,24,3,213,200,71,159,138,94,239,152,143,223,242,149,35,228,96,172,10,140,5,219,21,20,116,93,142,176,195,79,76,220,219,27,1,26,227,152,189,28,95,32,197,19,225,183,178,34,101,41,130,91,44,217,60,139,3,211,164,41,153,92,52,203,147,176,128,159,188,88,210,223,235,173,201,250,239,112,95,161,51,191,186,127,86,89,212,132,143,27,6,83,148,37,177,122,7,19,247,95,49,186,199,119,217,230,117,15,79,96,245,174,46,32,61,229,201,240,137,1,60,209,166,143,11,149,176,66,62,248,215,77,64,54,101,225,28,222,173,236,150,85,142,138,51,201,166,225,146,87,169,62,65,37,228,153,212,202,196,152,9,63,248,1,252,109,224,157,43,242,188,79,122,40,225,202,173,208,8,97,168,24,49,209,115,76,182,23,229,172,117,237,103,11,43,150,111,59,170,227,113,211,58,220,76,236,221,34,155,207,9,127,208,116,195,155,8,226,163,108,104,14,5,43,99,14,202,213,102,189,1,14,9,100,81,176,195,179,146,137,67,172,56,126,203,227,22,88,88,135,158,62,129,14,143,72,81,79,181,178,215,188,174,73,177,164,12,158,46,181,79,238,182,82,171,145,221,69,14,135,204,13,249,71,211,177,158,213,44,92,118,200,13,136,112,60,187,228,33,122,128,53,233,7,152,60,202,178,116,89,191,86,96,77,10,118,200,253,133,94,144,173,180,236,153,40,228,155,204,178,228,173,218,91,57,182,113,37,157,27,139,145,207,140,58,87,133,160,111,179,255,216,127,251,89,255,223,111,170,0,27,135,197,225,30,210,178,194,54,202,23,42,113,221,24,238,48,93,46,226,80,41,114,106,171,43,103,124,143,44,9,85,16,252,188,119,194,143,25,79,35,71,82,164,68,0,16,175,184,105,48,249,202,73,55,188,145,185,244,19,235,255,0,143,218,3,245,87,62,205,125,98,183,120,235,17,112,136,143,69,170,137,141,180,156,192,78,212,168,178,122,37,16,203,190,138,28,54,142,6,204,51,163,61,220,224,194,195,188,202,99,114,56,237,216,233,210,46,129,146,99,80,247,3,52,173,250,131,232,191,187,226,28,179,40,178,47,5,9,168,204,215,230,87,249,141,220,202,226,185,191,71,7,193,227,139,35,70,172,7,20,118,37,123,250,75,198,35,153,78,33,95,166,205,132,190,175,193,71,23,242,239,41,251,107,75,77,94,90,245,91,21,108,192,239,155,161,74,39,120,224,63,54,132,87,252,61,42,171,149,184,255,19,58,0,109,83,134,60,7,76,152,110,188,78,35,39,189,201,159,37,76,61,108,21,187,222,76,97,53,226,109,168,127,193,97,120,207,116,155,65,7,192,104,55,86,70,237,175,5,16,255,176,100,86,28,215,197,24,78,1,54,5,244,22,100,176,15,201,165,179,99,196,86,43,238,74,244,223,167,18,162,243,248,18,112,89,85,198,12,30,50,65,226,60,201,33,156,155,107,248,103,89,165,242,157,160,202,105,188,90,180,115,20,220,190,98,248,36,46,18,131,131,105,228,48,252,219,193,80,112,129,99,56,144,69,184,137,90,19,202,198,66,36,16,178,89,3,59,48,228,29,130,58,69,186,6,169,200,187,162,169,155,226,94,192,114,47,35,65,129,247,124,101,107,239,109,151,122,155,232,38,240,180,239,192,154,106,28,234,13,2,12,191,7,77,77,92,195,183,133,248,194,59,152,225,34,194,174,47,53,159,211,51,86,171,29,30,81,179,0,40,228,102,171,181,52,174,64,211,227,125,152,155,155,54,59,172,11,75,51,50,48,126,210,93,132,30,114,89,153,99,122,255,66,37,4,28,217,245,11,82,150,186,234,54,35,57,226,85,18,6,233,132,46,249,126,62,114,17,186,78,173,155,40,153,181,3,131,9,206,209,97,135,201,220,251,13,204,193,192,156,95,15,82,217,19,189,27,241,247,188,234,197,129,171,131,241,105,62,137,160,113,136,190,107,15,131,236,49,65,61,53,69,230,218,178,224,151,209,176,53,188,141,240,19,84,251,57,134,91,200,134,90,9,1,75,15,180,86,114,64,135,155,65,48,26,114,243,254,79,254,35,43,195,186,3,147,46,254,178,21,33,215,149,61,150,171,200,238,152,74,228,249,141,101,197,234,6,228,229,12,234,244,185,120,57,186,13,77,80,172,244,95,131,238,237,168,5,27,106,202,89,104,253,220,175,150,107,206,247,248,42,110,154,136,249,76,131,51,82,113,116,172,230,98,219,122,174,237,25,134,160,142,171,72,215,208,231,98,82,112,0,61,252,64,171,6,85,114,190,122,142,228,227,11,80,64,64,193,244,29,100,99,14,136,244,47,228,43,206,153,49,192,226,143,33,78,192,158,190,92,79,4,42,48,122,92,170,220,68,69,28,44,113,85,168,18,13,59,16,136,127,152,9,108,182,203,165,189,31,227,5,119,43,48,119,53,73,66,13,172,26,9,115,165,102,186,215,92,203,14,139,51,153,120,36,252,16,233,170,104,110,230,37,62,219,86,224,241,162,162,142,142,194,113,7,110,227,219,187,5,0,90,162,40,199,177,14,74,197,65,67,199,114,13,249,233,165,243,255,60,183,38,133,185,190,21,126,90,94,228,191,37,27,180,130,43,24,122,16,31,160,183,145,229,218,72,180,108,32,132,107,103,222,200,135,34,111,144,179,252,235,234,105,231,249,114,21,43,67,162,218,155,128,219,28,72,40,212,8,3,131,131,163,131,114,67,109,92,244,26,141,124,68,201,86,47,56,120,33,135,5,6,203,17,81,7,22,169,26,170,25,152,68,249,159,26,57,73,204,56,75,52,182,84,88,30,16,82,6,165,64,1,129,101,192,134,109,247,190,244,238,63,24,220,247,73,15,163,88,185,107,96,126,35,22,238,81,106,163,52,127,209,28,40,196,14,93,35,16,182,164,134,149,182,37,26,210,178,44,246,65,156,103,13,175,196,112,79,84,250,38,165,167,113,196,226,147,46,238,192,3,89,4,247,235,80,102,58,196,122,19,148,20,245,208,164,151,119,17,202,100,179,250,45,198,144,100,40,87,94,108,145,137,167,148,1,2,95,165,65,12,214,65,98,63,131,160,140,22,18,65,112,33,216,221,1},
  {129,180,66,155,157,153,182,28,207,225,130,18,10,221,220,199,48,223,107,207,235,36,121,177,1,227,54,85,5,99,106,235,201,236,235,72,152,211,38,170,228,57,18,229,24,133,158,254,148,89,216,225,24,205,55,79,228,20,130,226,187,87,108,77,154,234,239,67,66,147,186,116,170,224,95,28,0,103,153,164,168,160,188,133,37,201,4,33,241,138,77,69,11,237,105,163,108,66,127,71,208,143,148,162,159,106,141,115,171,22,218,113,41,21,1,85,82,124,32,255,178,47,232,158,171,194,239,174,231,1,255,76,188,202,45,234,147,74,230,19,199,199,59,60,255,244,31,176,201,177,82,170,75,218,223,118,92,17,227,228,242,115,20,209,139,134,10,149,24,249,40,29,229,70,56,136,178,54,163,94,183,113,234,141,57,209,73,75,45,240,224,14,151,176,189,230,233,84,252,215,174,202,248,33,78,233,141,132,21,213,246,190,17,230,106,133,233,0,31,29,216,189,37,170,45,73,80,180,176,57,59,5,65,215,253,192,41,75,191,142,149,126,146,89,128,32,132,222,24,63,178,220,18,56,219,15,173,56,55,201,17,142,156,209,188,35,50,55,68,21,132,125,176,81,50,208,7,51,95,74,22,217,66,61,161,29,209,117,38,190,162,114,222,71,116,243,155,109,99,93,41,121,207,144,221,98,164,99,56,128,164,216,82,200,22,214,128,243,15,132,149,193,237,4,218,147,237,54,192,172,175,131,65,140,99,197,144,192,254,232,96,153,30,250,173,19,230,176,4,131,119,170,230,227,98,74,52,143,41,213,14,228,123,202,253,130,179,150,254,206,73,100,164,46,155,233,4,234,91,30,57,249,165,3,204,48,170,49,140,136,114,138,27,115,73,115,188,150,144,179,74,60,141,206,3,68,233,76,201,81,218,202,103,12,59,14,237,147,112,86,146,60,113,216,59,178,255,136,245,24,225,226,253,153,134,89,232,5,139,49,250,81,255,129,198,171,233,175,21,242,45,210,15,55,200,77,113,36,228,12,64,221,10,221,148,252,232,133,71,69,146,64,184,42,26,65,74,164,232,227,189,37,220,213,32,65,105,20,181,116,216,204,243,154,48,125,161,143,244,13,194,79,229,214,176,63,31,115,162,30,111,199,140,108,152,227,187,106,68,191,87,217,5,245,48,60,218,3,56,177,153,97,70,39,74,45,140,8,95,51,99,1,22,69,212,31,242,123,205,86,198,148,253,29,64,216,103,99,205,52,214,63,170,212,117,98,23,70,130,23,38,206,32,133,45,113,51,157,217,118,250,159,245,78,219,150,186,255,242,68,247,161,231,34,33,108,62,197,176,60,212,37,30,57,175,197,252,218,3,59,76,5,214,131,70,13,109,39,192,81,238,60,84,251,45,230,39,15,220,167,127,81,95,100,191,126,197,142,177,175,152,82,33,111,95,26,72,4,19,163,189,123,110,245,228,216,52,121,152,239,94,201,254,170,93,50,39,118,150,139,118,55,167,28,41,83,176,43,234,216,106,13,96,252,48,127,224,12,72,149,140,0,186,61,252,88,31,152,142,6,220,13,202,116,136,40,68,24,65,30,110,78,6,57,14,162,146,5,205,227,115,250,124,35,184,222,204,251,131,220,186,106,170,192,1,254,216,222,40,202,177,219,181,109,59,28,10,233,116,63,224,241,32,145,194,93,186,71,57,223,81,214,77,107,184,220,26,87,31,30,83,69,74,255,235,171,134,101,161,168,76,236,204,63,5,222,250,98,202,215,192,188,237,206,157,168,40,34,77,52,44,2,67,214,150,179,255,117,193,216,173,19,71,127,176,246,210,173,197,117,69,146,36,200,200,232,212,40,59,15,13,32,202,87,85,218,226,152,29,107,48,173,183,89,207,253,99,188,49,4,164,103,14,230,160,201,133,126,81,5,1,174,147,88,122,231,113,155,59,234,95,63,189,128,6,21,123,15,23,84,32,152,93,20,135,2,66,211,146,10,80,176,225,149,199,88,223,217,99,189,151,166,242,230,185,196,183,132,175,88,114,232,135,37,210,216,143,115,30,207,91,183,167,214,97,71,204,183,247,105,142,96,110,55,185,137,49,111,37,134,11,130,25,86,173,98,135,89,205,37,204,70,50,29,181,228,100,212,113,217,247,11,92,116,50,166,16,0,171,133,138,182,236,64,194,199,0,129,130,132,254,36,191,223,132,181,239,3,186,184,47,238,114,141,27,162,75,50,254,39,36,92,144,94,100,157,229,23,190,219,126,71,98,193,191,166,19,14,90,18,237,200,248,107,148,240,27,57,28,229,36,177,36,150,130,158,74,105,49,100,89,194,49,238,204,104,75,42,151,99,206,149,21,132,49,15,133,177,164,113,94,31,17,13,113,90,79,88,224,188,173,69,117,130,5,217,206,134,238,49,158,253,67,55,126,12,100,8,102,31,49,52,154,116,192,220,243,167,179,6,67,147,237,83,67,12,139,105,181,89,170,148,235,223,17,152,27,68,45,19,110,187,94,151,237,103,197,207,15,208,16,132,92,43,127,198,139,90,117,232,49,175,244,135,97,163,6,233,199,66,255,194,209,234,41,26,63,145,224,243,141,101,206,215,252,230,157,152,89,16,29,242,136,236,166,179,44,55,244,215,249,66,168,229,71,192,142,136,72,255,127,48,211,226,68,168,178,128,59,86,212,136,253,247,77,72,249,240,25,247,36,226,41,186,38,122,91,3,159,33,228,72,180,252,225,144,147,175,87,236,248,99,10,160,128,193,32,123,251,244,105,156,155,191,22,141,13,29,9,112,163,201,162,254,157,39,149,2,158,210,75,238,111,74,48,116,219,247,46,11,157,83,66,33,65,43,49,192,13,116,109,53,47,251,231,190,1,147,71,108,82,148,139,40,131,13,188,178,35,75,229,15,241,46,182,236,55,90,240,51,197,186,6,93,27,163,117,93,6,57,102,205,214,233,254,61,77,108,196,105,11,24,14,22,248,172,78,140,182,121,22,57,12,10,237,50,88,195,216,5,76,115,119,33,196,38,151,245,130,91,71,83,181,27,176,26,84,130,127,28,213,210,150,255,208,1,60,250,108,244,77,10,199,189,32,172,136,50,108,237,225,240,114,110,221,17,119,63,232,95,109,214,94,238,0,232,237,132,91,169,4,117,89,71,145,14,70,75,121,180,52,89,0},
} ;

static const int16_t precomputed_encode_1013x2393round_x[precomputed_encode_1013x2393round_NUM][crypto_encode_ITEMS] = {
  {-10995,19420,7918,-27125,8302,-31350,2561,24112,16867,-10426,-25367,21265,-11558,86,1239,31753,-7273,-32767,5106,-10603,-8992,-29256,-16982,-6615,31703,13191,-32669,-8375,-15204,-30056,-15218,-805,-14019,9163,1092,19348,3418,6583,9372,-19989,11934,-4938,-657,-5881,7799,13984,25071,-1453,7227,8909,-15484,-20956,25336,-11592,26510,-6262,-14358,-4595,23880,7789,-26535,17582,4656,29613,-24035,14859,-21931,3418,8868,14724,2623,-2712,14343,30775,-8329,-23568,-25019,-20012,3399,-6713,-7234,-782,24699,-11745,22472,5843,-17984,-24378,-8526,19241,30732,-15404,-11898,8988,12771,-29541,-13587,28778,-30530,15276,28760,2134,24800,29480,-3711,-30207,-8689,-494,-8035,-22263,-25152,-26119,-10935,11583,30273,3278,9887,11440,-3255,-9892,-12130,-22258,5872,-18001,21150,22494,4882,30575,29190,26431,-30839,8550,-28132,522,21170,-23964,23203,16048,19682,-6992,3854,15206,17557,23954,4789,-12092,-30440,-3714,27616,24509,-28116,24302,-20252,-19993,-16243,14568,3854,25748,-1401,-13665,-30703,-14689,7856,14592,16638,-26458,9545,23926,-7343,-22449,13918,13106,-8524,-8767,19648,32708,-12894,7159,-20353,-9788,31403,-10559,-21885,-19962,-14545,7466,11977,4704,-27300,-5833,-23296,4024,-20834,20515,-328,-28179,3218,-20093,14125,-15437,-857,-16946,-13022,-19207,-8714,-16500,15545,-8911,19904,-1751,32144,-5050,343,18061,-29540,-26020,5865,-2980,-16972,6373,-28218,901,-26050,27644,640,-8253,-16494,5666,12748,-187,-1831,-17762,24082,-32107,-26414,-712,29724,-9713,-25433,16412,-11568,12731,-1606,22090,9091,-11721,11645,-29953,-27345,27762,-8500,3661,22293,-27655,-10041,-7415,-22785,2708,-4808,30206,22491,25593,16615,-4237,27940,-31709,12953,-19439,23152,31140,-32499,8885,-3209,14258,-14997,-12849,3917,-6290,-10851,24045,-7157,18608,-17886,3633,-7935,-22499,-16318,13754,11081,7576,17513,2516,-25439,-22995,-8473,-13337,6329,10558,24287,-4227,-28961,32472,3811,-31128,-32395,-29355,11693,29195,-32157,15690,15589,-20131,944,-27615,18449,20243,-10582,-18907,3564,-20966,-14843,10586,2400,-20048,-4023,-3289,29908,17130,-3829,-16516,-11470,26754,-9555,7906,16635,9261,12646,-32615,-20999,-30752,8778,-23275,2656,-7076,7588,-7890,21247,23064,-28081,15332,-16912,-19858,11987,29606,-11541,-19457,-17638,-13460,-19988,-15620,1413,7163,-13694,7701,-10341,-21140,30662,-20586,8987,-18404,-21887,12065,2362,30599,23036,-777,6257,-32562,-14800,17183,-22760,-7939,27823,10907,-19377,17395,-26223,5180,14599,-28908,7028,-15141,20022,-24412,1976,-4797,13403,-25920,-18395,6069,-4977,-26285,-30299,-19030,-19384,-7292,-27244,-29831,1261,-4344,-11770,202,-17151,-8523,-18205,8471,-15111,-31458,-12682,-3745,-24831,-4005,-26612,-16046,-29401,13627,-13987,4381,28951,17303,-19640,14333,415,6638,133,30652,9798,49,1289,-21245,17594,1407,17664,-17363,-7986,7599,-10036,-18094,-5026,12230,2691,-10379,-6460,-15608,-26207,21667,-17904,17624,3719,-19002,-24867,9493,5145,12309,-12806,-10615,13169,1999,-32461,-30133,-15984,2708,12944,23942,15220,32063,-26102,-5417,-247,-15935,-32131,-5979,-26801,18345,-7992,22603,-18058,-19485,-20025,15868,5666,-29694,-7472,-5755,-17834,29671,-24110,-17820,-3832,5718,459,5627,-25168,10505,-26764,25859,-29136,-31343,24654,-5654,-10514,8663,17454,-15534,25554,10087,7900,2104,3234,9474,6498,-30817,24694,26182,21534,15171,28440,14518,2241,24743,27286,-26432,-12791,26580,3088,-7927,2841,9430,3280,2216,-13482,-16624,9751,-32705,15455,29897,-7118,12936,-9303,31027,-11239,624,1419,-22820,-11009,17794,-1682,-2436,-17304,28045,19761,-28053,21880,5663,-7004,-4560,-5522,6234,18606,19432,2839,28922,-8580,-13325,-2926,14287,31450,18343,16187,5140,14972,-8411,-26108,5337,92,-20688,-16951,-22553,23118,-20727,-24089,-10307,3128,-6171,24490,-25633,-20428,-5320,31498,-11085,18828,-17290,-13472,2661,7374,-7192,22048,-18082,12313,5282,-1442,-12433,16490,-5116,-13447,10425,-21861,5737,-17998,13190,18648,26113,-26012,-9316,-28588,-22273,-26656,-24759,-12752,-29111,-1975,-2148,-21479,21899,-22533,-7005,-10875,2145,-16535,-1603,9607,15426,-9518,31845,18148,32400,24838,30222,32495,19449,-17188,-10060,23017,-32236,19284,26075,-4464,-12470,11972,15763,-10737,26760,-18044,-17140,-26991,-25458,1529,13473,-18391,-7074,-6649,23959,-6169,-20377,4560,-579,30160,14027,29217,-31975,-13526,17981,19074,6536,29347,-21086,-17379,-3050,632,30356,-11439,20815,-19070,20655,-6163,-27627,-28369,-18138,5880,26531,22042,10406,-4179,2295,-1104,25015,-13585,-29084,6817,-15873,4145,19231,-24861,-24310,32580,-8714,9337,15230,-12238,25530,-27384,-8287,17693,-26282,31257,-7742,31883,-11537,13,-23705,7162,17397,-10124,24427,9958,1482,3367,27224,-23530,3653,22498,27164,-16410,-12045,6894,14523,-24245,3916,25796,-27597,-13203,4126,19304,23726,-11929,11213,19196,10382,-5821,16664,-24823,2476,-10221,-3869,168,28849,5630,-15471,21367,29948,23482,27266,-10002,10747,-19310,-23122,-19877,-3732,-26853,17014,-1583,12473,-1582,20037,1896,7872,-4698,4942,1727,-1430,26494,14315,-7285,3677,-32424,-16256,10140,-2702,-11219,-30654,-28200,-9881,-73,-31387,31890,6029,-18670,-22469,-13190,-20359,-5280,-13173,-26846,-15303,-4034,24739,547,1563,-11851,14968,-30309,14082,25607,4500,-29968,5159,-16992,-18307,-12688,8067,16350,14879,-27205,-18666,17879,-17619,29346,5706,-2802,-19526,-1327,-31958,-2742,11921,5867,8123,3443,-13178,16703,-13214,18186,-24845,4857,-28417,31459,2622,12912,-16488,-9090,27063,6786,2025,25391,-8823,17396,4294,4113,22504,18864,28467,23575,14382,-19417,32514,18865,-8131,-23084,11892,-26386,-28562,17028,-95,20183,-15592,-12140,-9229,10301,6176,-9823,16070,14820,-13089,19439,30278,-29250,22080,31373,27994,-17764,-32654,-3207,24927,18448,-30798,613,-20374,31184,-22349,4530,-25037,-3710,-2152,-21298,-23595,-5157,-1787,-27045,-27228,17381,13256,6621,7500,30522,24574,2257,-2000,-12142,5477,19029,6076,-24322,3615,-1234,22657,-19501,-23454,-2270,18186,10308,21207,-7708,15123,-209,-25139,7242,-7126,15553,8303,23800,24026,27828,4419,25051,-7793,-17456,7274,-27442,-383,26340,-27687,-4547,17556,16364,-2357,-31501,-16794,-24317,26166,10894,16098,-30337,-16963,-3652,9698,1753,1467,-11572,-26812,-1322,6940,-7141,23838,9960,9338,14545,-11900,-23639,8039,22923,217,-9281,4289,5703,153,-13984,-5647,10780,-18060,-4448,5647,-6713,-7501,-13510,-19835,2191,18343,-26132,-23165,6179,-24945,21696,-8210,-20202},
  {31691,-5602,-17637,25584,7950,9393,532,-3400,18688,-32520,25858,-22408,27439,20992,-7929,-30524,-26272,-30681,-31282,-5888,25849,3972,216,4544,-6209,-25198,-13400,-9602,21001,-1838,11368,7722,-13475,16975,-12304,14304,-21707,25940,8952,3178,25041,8089,8591,-19732,1467,-12791,-29158,22880,-19428,-17337,-31913,-21259,-24634,10049,27804,25965,18791,18605,23883,-18218,29109,-21791,-23993,-9885,-21027,-23384,-1571,8720,31844,-18914,30162,25533,27151,-5186,-2826,31725,2074,-23172,-1211,32285,1949,16618,-2524,24532,-28623,26230,-20524,-6648,27539,3769,26508,-28659,27593,4219,-19607,2937,30302,17755,5476,-10161,-4046,-6421,-18253,-13039,29343,687,29276,24758,26764,-26650,10673,26786,8905,-16553,-30151,-16685,-6414,4019,-5796,-174,14494,-29562,3318,23380,-2965,-6019,-14474,-13297,5515,-2193,-4052,-29244,-15490,-3279,-17665,-23658,-19481,29499,-23623,15622,973,-2857,21990,10767,30846,23521,-11458,989,18017,-3718,-31887,-14108,-26917,13576,3106,23222,-7055,-14669,3220,27753,135,20137,-13519,13253,28982,8387,19093,-4479,14360,1940,-14456,18386,-13973,17365,12578,26022,24667,20063,4854,31980,-19139,12593,-25448,16544,21874,-32565,14728,13673,-22443,-30046,20849,-20556,7097,-28908,-17417,-11061,3188,-24274,-22047,-9245,-28778,10515,14580,11155,12695,-967,-16016,20201,-4199,2412,-10801,-17315,-29182,-15789,25595,3443,6511,28251,-4401,-3355,26219,-1376,26243,5456,-31477,-24799,6830,-11622,-27075,-324,17598,-20375,-14006,-12317,6385,-18709,-3827,-1452,28514,-4136,1687,-1203,-2316,-20877,22091,-13189,-569,-13023,-4128,-2616,13456,-32299,-31019,24455,16530,-22758,32391,26255,28407,-30333,11388,31816,25523,22329,30762,-19176,-11133,29689,-12467,-15322,15424,-6117,32764,-10461,27539,3249,-26796,-8212,11090,-22753,-18656,4504,4716,-2677,-1079,-2590,482,3002,-31635,-12770,3235,-26003,-12025,-30191,-10939,-17908,24210,15703,-4522,-1636,-17218,11896,31406,-5303,-12945,1549,-5748,31961,-28847,24750,-32476,-11971,-3149,28206,-10681,-25202,26854,-2573,-8605,5734,-21272,-13128,13350,12863,23902,-20073,-3472,31352,-2607,20349,-20448,-14837,-23994,17120,-24340,28814,593,-31314,-19781,-961,-18096,-18087,21394,5352,-20476,-5885,-29246,1522,3015,10070,-7663,11901,-9113,23709,-5755,-4648,23817,-6718,10953,20168,936,26773,21916,162,19660,-24494,-21835,-25566,22089,-8634,-30745,26216,7614,24908,-6454,-15581,27825,-9121,-22247,2586,9142,8401,-19771,17883,-28904,29717,-409,9944,3475,19771,22492,10874,6143,-20876,14579,7202,220,25036,20799,-13919,-6092,-31921,24312,16606,16721,-18787,24701,27591,-26530,1964,4325,-13625,26154,32705,-1554,22836,-7375,-3594,10837,31205,-19441,-24654,1872,-21782,9895,32000,23446,-19133,25218,-21269,-14350,31437,-25732,15212,6344,27013,6568,-8263,26838,-21768,16705,17264,-23560,12813,-11054,19615,20101,-18107,25738,3738,8855,-20054,-3984,25449,30640,20056,-23975,-30888,19056,18701,1801,4003,15735,-19458,-9717,-3638,-18511,-5930,-6278,-25797,19871,32233,-1736,28070,-14280,-14776,1170,-13935,-30645,16715,-10483,-23336,-28995,-17152,867,-9834,-26165,12947,19071,9619,27234,-32653,11456,-28316,-11122,-30570,-11064,31313,-29520,-1226,-31419,16813,9110,19880,25179,-24868,29685,21627,-26922,-18567,-6030,23728,-5250,-23340,-22649,-25296,-27225,14463,3847,-29326,16586,-15047,-22436,10108,-22967,14704,-21385,10097,-9783,1044,-16543,6941,14336,-5944,-26945,-27794,-5265,31940,-15347,-16028,-18321,-29293,16020,-21654,-22507,-14032,-20311,-25659,27632,-28442,-22466,-19206,-24506,13280,-15287,-29142,32196,6053,-18602,-26631,15805,29696,8126,25041,-17370,-29547,-3683,-12858,-10140,16476,-21942,14637,-1712,27260,2100,86,-16124,29127,28244,20620,-24061,-12693,-25577,15709,30214,-6916,-13659,-11362,10844,-8204,-20336,-15194,-10162,23954,-4906,-32614,19776,27941,350,15522,2873,18088,29555,31468,-18708,5909,25136,8184,4684,-22929,24166,23922,-31315,-12793,-25544,24504,-13225,6873,26657,32509,18390,3511,-18333,-24735,3118,-18949,-5194,25383,16307,-17962,-10095,27469,17031,-20308,-7356,26077,-19447,31872,13057,-27281,22195,-4158,28186,3133,31088,-10752,-19516,-14498,-10218,14541,-30036,-3848,13113,28391,23194,-12884,-29275,32610,-8256,-1197,28794,13819,29448,12697,-22180,-27754,8250,-4194,1633,14380,-10536,24714,-31498,3494,-1697,11094,3299,-12984,-23764,-20373,26669,32378,-21135,-1714,1957,-4108,9329,-28085,21738,17797,6384,294,-17850,14457,15534,6137,13626,-4655,4969,23756,18047,-8895,-11085,7168,-25035,9855,26751,-615,-11130,11913,-15962,-28724,-14188,16235,-12006,-24987,12569,32012,-6813,24934,23712,-11593,-5495,21816,-23399,-27204,26223,2055,30303,16096,30405,32743,485,-11028,-20543,-15969,17419,-14216,14381,8486,-1527,626,15333,24371,-27068,23511,-7019,-14345,-26803,3743,-18661,20481,-22861,-5141,-9386,-5621,14743,-7385,-12726,15418,-8629,-1573,-3310,-4290,-17279,14252,-9167,-11130,-30077,13139,-1330,27717,-10134,16765,11856,14734,5562,-23456,16691,-4171,-9357,-14932,-7393,-23081,-710,-15907,15622,-9259,28363,-18203,31555,-5703,4760,30127,-678,-12680,-18664,20438,3490,3017,-25696,31456,-16362,31329,3476,4946,-5529,-22060,17468,-1203,468,-18603,-7183,-11507,32633,-25456,-27144,-640,12035,31532,31878,-28291,953,22634,23254,24676,13200,29197,-399,-5055,-12799,-12352,-12914,11084,14692,-25480,-8705,7885,19523,12314,-13414,-4392,16585,17790,11523,-26727,4931,-3385,-32331,-30536,-23792,-21113,21182,-7364,6253,-17192,-26529,-16325,386,-13320,-9330,8006,14930,-30178,-1,2606,-8818,-20175,16330,19113,-29436,-26062,3841,9327,-14144,18673,-10343,-32479,17405,-16193,-9719,29823,22241,24077,29707,-9633,-28549,-18043,16186,-19142,20247,-6257,-24596,22027,23678,-7930,6948,27423,-13065,12760,-28181,-6942,-25252,13714,-6525,4203,-17144,-16138,-19111,959,25724,30475,-12290,-11796,-17635,-4452,7640,-7920,25597,27662,-3606,-30300,30281,-5916,1293,21252,-30688,-12356,-12831,-10449,24948,30626,-31729,3471,27961,-23847,-15233,14153,-512,-32158,24927,15124,-31634,-10711,-31071,8305,3339,19946,29055,-26983,4024,-6655,19800,22251,-22922,31777,25599,31121,2357,27530,-9838,30241,28203,23513,-8110,12281,-8534,-1567,-9779,20694,-16101,15124,-28545,2120,15579,15722,-2862,27751,-18279,16197,-30438,9793,4670,-9149,-4511,-4651,-5479,-19832,-1895,-27304,26497,9532,8515,26772,-26084,-3575,-18125,-21742,-7561,9334,-23867,-9044,-3148,25994,-19254,-23521,-8419,-8113,-25610,26442,-13250,24725,-18071},
  {23509,-23319,-28335,-32603,-5580,-6300,9085,-6351,-32735,26465,19742,14690,-30330,32237,22954,-7478,-21415,-10707,7738,18320,-12158,-5635,19675,-21327,200,10096,859,7252,4124,4554,3667,-5565,7373,-10113,20126,-27975,-24759,14771,15799,12835,29560,15144,22632,24850,-22640,5303,-11301,-23386,15020,27502,6371,-19245,25802,-656,13750,30690,17097,-4711,-10061,-16861,8592,11252,26567,26872,25456,22365,27494,32227,7666,2179,-30678,30330,8492,-1405,17596,28208,7415,6612,15720,-17460,23418,-5966,-31454,31045,-5747,29981,-18608,-8641,7237,-19500,22255,27247,26663,-12141,-22350,-11579,29553,-23313,27089,27854,-8139,23049,-9055,16701,-22194,13287,14319,14405,13827,1397,-3518,-17585,25842,-10037,-16205,-29274,-20283,-5699,1017,19110,-32503,3020,11518,1031,-19152,23475,3235,-25086,30872,19552,-11280,22553,-6169,26474,24008,31989,28699,-17294,5705,-30602,14901,3780,27008,-3081,-26143,-26018,-11559,22017,24885,19809,2120,13380,15232,-14659,-5666,9599,19063,-31708,13522,-11327,13523,-22003,16939,-25708,-25577,6321,18380,-18718,-12601,26176,-3724,5511,-24706,-25121,-16778,-21808,-25364,-27570,13699,-6253,-15324,-2532,3057,-15442,11809,-26112,28963,16692,28851,-20103,-2068,26163,11732,-5269,18431,22790,4728,21930,28137,5317,6096,9612,12712,12583,-7554,-7367,5820,1370,-19143,-4758,-32229,7210,27515,22376,-3698,3262,-14922,23740,-29879,-10666,-27900,15085,-16544,4513,-26782,28160,1129,-31112,7581,-15313,-29867,31727,4324,-25129,31184,-12051,23251,-633,15890,-7862,-20236,-29147,17682,5727,-26343,24954,20529,-28466,26860,30104,-30138,-26105,18195,18593,-1131,30925,1190,28671,17344,23459,-22279,-14546,-17888,-26794,-17612,31859,9580,-32702,30565,24510,24115,4486,24136,-8826,28404,26909,-2903,3780,-18407,-19011,-13597,-20084,22468,21600,-22918,-2008,-2889,-7261,28599,896,1999,-16696,23151,-17012,27733,-11368,-4141,-28722,-7691,-12021,-3529,27307,13142,13717,2546,-15007,6929,2573,-7211,1702,14568,-4138,5544,-31745,-31379,4092,-9187,16810,-5414,-29984,362,32202,-31809,-20132,7325,31373,-32300,-5646,-21870,15753,15074,27073,-7563,-16235,10928,-5141,30505,-12929,-22701,-24313,-25592,23301,-12211,-31362,30819,12588,3755,-29138,19435,20206,-29203,2362,23554,-23408,-11475,-16888,-23003,21074,10548,29767,21022,4502,20580,32005,17502,-7074,-19819,-18368,-13669,-19040,-18552,32702,14347,15398,9364,-627,-11735,-29064,-28512,-28952,-28666,491,-17551,13555,30667,-24514,8813,-16405,-9031,23399,16168,-16505,17757,-18315,28329,11630,-12656,1293,-3521,2135,18962,8519,-29570,-7686,-17452,31812,6295,3562,-4421,4106,1574,32197,29317,2006,-8548,21265,-18919,14384,9010,13965,-3761,29508,-7299,80,-31878,-30507,1462,-20350,-18898,16265,4449,-670,1021,32543,30289,9880,-2653,23642,-30065,-28315,-568,-17511,-2298,-4753,26218,-18784,2659,-19010,-25345,-8563,27481,-20794,-14232,2288,-4559,6648,15195,-14997,8224,4508,-5170,-25570,5101,-20118,-23506,-1499,-2421,24796,-29607,-17035,-29048,-5093,-10302,5410,13170,6089,-25216,-19264,16747,12420,8159,20249,14357,-9067,-14347,20714,-7392,-32151,-24207,-22156,-29185,24857,12486,-31554,6689,9995,27540,15336,16545,30675,-20837,14434,30501,3140,6123,-28163,-8301,-20082,1653,-20320,7518,-30509,29819,27918,1732,26005,18497,-5851,1970,-32002,32176,31550,-14721,-12999,-4489,-31696,-4862,26679,-19104,15583,13187,13714,-27245,-10389,1234,15679,20029,-3580,8635,-10775,7462,26741,-21788,17440,12026,22495,2616,-10554,25675,21462,-7356,-8665,5112,-20065,-30820,10701,-21536,-5175,-29086,9507,-3117,23831,31737,-16819,-10047,6542,-19920,-14102,1302,-15214,21562,-19512,-25557,9237,1084,23631,-27462,-7963,24984,4157,16108,-20643,27871,20241,-8228,-24632,19878,25946,-9246,-13075,4670,22432,-12897,11629,31095,5392,-31968,-6381,-2493,-24909,-7170,31652,1668,19268,10208,-21064,26260,-9687,-8113,-27561,-21549,16314,-32036,17757,4711,24122,-20796,29031,-14169,4360,12119,-13283,-3532,18258,15279,541,12668,-28493,-12896,2177,-25598,-27626,-17169,24026,-17212,11861,-3280,20740,14716,-2493,12421,-13910,-20539,-6250,26454,-3872,12595,3144,-24882,-793,-11195,-14742,-30842,10769,-10999,27310,692,5101,-2762,-19218,31159,17339,2194,-6757,28989,17316,22174,19937,-14400,-27476,19346,-18384,6656,-17528,-28372,-4683,-7614,-11083,-8095,-23768,-21874,20115,18520,2868,18075,-3265,8303,29861,-16363,6595,-4560,11329,23873,-10329,567,10652,-23754,-13694,32232,-11849,-20971,1450,-4611,-18650,15357,13954,-11282,-23745,19595,-30859,-1222,-21321,15020,30638,12743,-15423,-30520,302,-29784,17194,-10695,1478,-27217,-27700,11218,18689,5634,9000,-12955,-9289,11419,-11979,-6207,2504,20570,-30615,-30907,-26784,1673,16924,-30950,17480,6986,9864,11461,-23408,19289,-2638,-10337,-5238,-31058,-268,-28710,25622,-26748,11650,17244,-9252,24387,18166,2468,-13120,-30105,-841,-15803,-29542,-11224,9138,4156,-24283,6903,5577,-4124,-16106,-19852,9068,-18485,12766,-9808,-27729,28834,27686,-24422,-20191,-13814,26558,-18700,13354,16230,1389,14242,3325,15545,-7016,-28703,12446,19005,-10294,8800,14628,2965,18062,-22933,-5245,-30815,-13235,-16692,-7987,984,25668,-8340,-7635,-11809,-13957,-6444,-14481,-11152,-584,26664,18427,7318,30509,32406,-11423,-14607,944,543,-31573,-5519,-11940,-9786,27132,-23038,-31722,14248,-25294,31589,-12867,-23883,23986,-17639,4465,14422,-19902,4202,17645,16269,20157,5940,-20508,21486,12030,-15572,14019,17584,-19390,23611,27655,17864,-24919,21266,31682,-23492,-8767,7910,19590,29314,-19176,18392,-7965,8334,9694,-172,25902,-2693,-13086,1782,-4578,-19516,31052,19496,-3954,736,29407,32538,-23147,-11456,-2081,19532,29451,14885,-16105,30993,-30759,-22765,25277,-3788,-17109,14721,-10072,-13208,-29330,-6847,20796,-8511,25571,14691,20720,-19817,30228,-18205,31650,18875,22976,8880,28915,4891,26942,-5238,-5362,-3994,-2879,-30485,-8751,31757,-20688,-8825,-21755,-4814,19112,-6933,-24255,13155,9576,17558,-5729,14526,-24232,2194,27422,-30699,-13623,5172,-18438,15719,3925,4411,-21936,-8739,29525,8428,10629,-17073,5281,28855,5715,-24765,-13639,23680,-9151,14269,-31504,31092,28175,-10582,29480,27095,5865,1438,-4479,-26608,2044,12371,31949,16397,-7354,28785,-21662,-8135,-23249,23346,1648,-30625,-30602,24407,-9056,29862,12014,8734,31536,4408,17906,-25461,-24439,19319,-26059,-8043,-31924,-14773,28284,-26592,21990,3409,-17342,31635,-13776,-23935,27939,24851,-25103,29525,-82,-23986},
  {-6777,-23649,19643,30788,25313,19496,15471,-23527,17890,10204,5010,-13972,22021,-2535,-145,10523,11691,-2619,-12712,-7829,1106,23160,1557,-18273,4783,-28232,6041,6047,-4681,-29837,-5086,-8235,-19290,-29952,16612,30846,8149,-26513,-21273,18349,26780,-7471,-16284,-16283,463,26723,-8787,-19399,-24931,-32713,-7007,-21907,-15633,31299,18855,31833,12505,9803,9411,-14893,18632,4817,23566,2430,20069,-16939,14463,-21460,15488,32759,31400,24912,20393,23712,13108,37,-10252,4164,7534,-15897,24140,9933,-30723,6970,30001,31709,6377,-12981,-13296,-10562,-26449,17908,20496,-32091,-10729,-15075,5487,6453,-17436,-25978,-30635,-2393,-17464,-25047,10722,-27699,-14242,15052,-17656,-4683,-26559,-18624,21556,-8712,-6398,-8940,24107,-8186,-19562,19205,11743,-31660,-2748,-18195,-22651,-13094,-5620,18434,-17674,-8469,-20843,3003,-4717,31457,26790,11763,-30610,8510,-23428,-30684,-24951,-4138,30422,-24915,-7435,-13406,-20664,-18360,-31641,7229,-11273,-30139,27565,6828,-26927,-1089,83,-28132,-31662,344,24495,-10326,-21293,-18265,-10036,2613,-3912,22039,-26277,-800,25776,15924,29624,-9431,7636,-13769,-5060,-10348,-7621,15287,-18850,18996,22599,-8839,22892,-25444,-7822,13804,30468,27004,-22399,-14797,21052,-22004,-6194,-16451,30131,24737,-16379,-32587,8842,-7998,23430,-23201,-19737,25854,20482,-18040,-19877,-30286,-31408,989,-19923,-32581,6561,-7362,-30588,29752,6227,30089,29999,-5287,30553,28791,-11922,-10748,10670,3200,-8672,-29027,10619,-31592,-12300,4776,-7447,26903,6894,1196,15404,13500,24934,-3749,11445,1858,18379,-23527,28214,7815,-13745,14542,14998,3220,-20085,-11827,75,21262,4574,9407,-780,-19084,10799,-15084,26988,-6188,5937,30995,-835,-2833,6825,-28875,7616,-27362,-27202,29087,9099,20829,15959,8751,27550,-22286,24281,28884,22186,-23849,-27055,-31007,-10028,225,18320,4850,12233,469,9604,29000,-16470,-20665,23367,5317,-1375,6712,-29392,-32701,4458,3604,19889,30359,6572,31920,-12061,-26457,-17808,1821,-3614,-163,5479,5268,-27748,-20092,-20245,24334,22339,-6602,-8830,30246,-7059,-23988,-10016,-4758,-24946,20735,-29703,5981,893,26151,9843,-23806,5296,-25533,-5014,-9879,-24503,-12860,12912,-5594,-27046,27505,-3239,11587,-14619,24256,-31351,-23238,-6812,-26837,16111,14627,4969,-5715,-4494,1650,8609,15905,-23168,-28817,13366,22204,9579,-5961,-25555,21649,-20393,4408,7969,9732,-32319,14267,-31644,-32747,19271,4635,3206,2077,23070,4708,2266,-24098,23720,8584,-6089,26719,22226,24422,7645,7126,30236,21295,27988,-13767,11477,-24635,14633,-15106,4759,-26923,2729,-13872,29365,30438,-31286,7691,-11029,6578,15325,30252,-28756,12682,32385,32758,-25051,544,10947,22917,9220,-12760,17550,8710,-21579,-12621,32114,1678,27643,-25277,-18805,32352,14999,-8522,2804,-22059,-2401,-2751,-16680,32327,-3413,-18203,28642,-14008,-7284,-28660,6466,24455,13679,-2534,8400,26367,15518,-14196,20205,5376,-25552,-14632,31617,11928,3090,-20920,6267,-31100,-22445,22529,20685,-7053,14663,-31157,-24855,-5503,-29372,-32721,4096,-28335,-10539,-19489,-18321,1352,15296,-29384,6358,10972,-22912,15920,-5453,19318,-18788,7159,18014,19253,-15346,13739,14806,9191,308,14937,12773,-27462,-20568,15244,30008,15859,10915,23179,19369,13792,192,27565,5571,31265,-1404,-8643,11894,-14685,-13343,-16626,31151,-25438,-15439,-31510,-28807,6124,5157,1256,-17377,20164,5479,-7867,4298,-4681,-27397,-12649,-3707,11361,26055,11376,-21487,12756,-28121,31909,-27052,31077,31403,-1413,9612,26539,628,18513,-4129,-10192,-18959,-6509,-9871,12990,8656,-20813,23627,-10672,-7896,-9719,30893,-2983,5767,-5328,21258,-17912,-798,-28564,-15595,25244,-31120,-16402,394,-4888,-20798,-10490,-30723,-20857,-8438,29448,20968,12842,-18012,-16931,-18182,17256,29076,483,21561,17159,-32705,-15913,15321,23540,8623,-7798,23929,14612,1476,-24095,-18433,22225,-30165,-24290,-31283,-6481,-19416,11613,15578,-20947,-12021,-7072,13879,-3166,24353,-25734,1695,2426,28143,7166,20051,-3436,-881,-17256,2678,-16960,-31329,-24004,6529,-30655,4755,28690,17829,4835,-11675,-11128,9820,10892,-6839,-15916,-2711,25623,-9031,5775,16412,2214,18535,4008,26879,29829,-15863,15495,29072,-7121,700,-14801,-3266,24446,9062,3362,30696,-17653,21055,11647,-2509,-13930,-8026,14453,-23279,-17255,7176,28676,12919,24149,-8620,-20267,-7018,31807,-21406,-29460,30502,-5143,8819,27749,-30176,31114,3822,5119,14584,27195,-9982,-22115,-17588,2211,-14340,-13152,1742,-31832,2306,-15827,-9053,30502,25097,30908,-32665,14777,12881,-16411,-32326,25877,-19260,-3816,-17092,11037,15871,2236,-21559,-11762,-8707,29352,16068,3629,29382,-9455,17089,-16287,-18726,-844,-29929,-4549,-9030,-4940,-288,26177,-27576,-1063,19046,25272,3318,-10326,18066,-32156,-16011,-32748,30492,-32636,-25303,31307,19392,-22835,-29811,-28275,-3620,18893,23150,20423,-13796,-3112,-17563,-12955,-30035,21000,-2574,-1259,9460,-7726,12064,19140,-25875,12675,-32642,-30959,19328,-8028,30006,32437,8302,2727,-3463,1363,-13677,1821,-27913,-27699,6787,21653,28714,13921,21678,-15636,19510,-21019,-21051,-9451,32059,-15108,29060,1088,4164,6501,-1291,20740,-25855,22360,13901,-14809,10965,12762,-26210,7458,20354,24704,28160,6568,-27905,27619,-6096,-30725,8225,-79,6860,-6180,7738,31571,16824,6603,-31835,-11418,720,-24168,13240,-9549,344,1388,-18978,22114,-10276,31533,-14668,-7374,-29181,-6747,13350,19431,-29695,-19231,-23005,-10001,-2223,1498,12256,23618,-24187,13079,-12270,14603,-3038,-16628,9837,-16250,7848,12173,3154,-29652,-32083,19362,5861,-13464,-32570,-7442,-29317,14445,-6283,7091,-25776,-25814,24294,563,24922,27997,4556,-25756,-7773,-5860,13736,29184,17109,18111,-10028,-4973,-13759,-23920,-2591,-13986,21532,-8658,29217,-25207,8054,15826,-24938,-26188,13668,-13357,-29482,-29425,-7970,27491,-8586,14203,9206,5104,-15144,3103,14826,-30947,7277,-30795,-4864,25430,12885,-20310,26285,12240,7745,-12876,-16282,30523,-2473,22427,-7773,-31220,10198,-2491,-408,-2889,18918,478,-10390,11554,-22841,-6060,-26961,14465,-20542,-9943,-5727,-9027,-23052,-24929,13185,-11272,25211,16475,-16171,-11769,-16824,-9945,7347,32417,-22320,-12448,-19258,-2932,-10461,-18863,-11786,-10222,28922,25629,-8147,31212,11620,-26047,26115,-27031,-31724,25707,-12842,28395,-9371,2218,-20727,15504,32169,21071,-2553,14929,12425,26886,-13482,-12363,-32182,-27795,-31835,27760,1115,-18709,18216,30195,26888,18183,20710,13131,1611,-20511,-17380,-5983,-17654},
} ;

static void test_encode_1013x2393round_impl(long long impl)
{
  unsigned char *s = test_encode_1013x2393round_s;
  unsigned char *x = test_encode_1013x2393round_x;
  unsigned char *s2 = test_encode_1013x2393round_s2;
  unsigned char *x2 = test_encode_1013x2393round_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1013x2393round_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1013x2393round(impl);
    printf("encode_1013x2393round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013x2393round_implementation(impl),ntruprime_dispatch_encode_1013x2393round_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1013x2393round;
    printf("encode_1013x2393round selected implementation %s compiler %s\n",ntruprime_encode_1013x2393round_implementation(),ntruprime_encode_1013x2393round_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1013x2393round_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1013x2393round_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1013x2393round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1013x2393round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1013x2393round_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1013x2393round_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1013x2393round(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013x2393round")) return;
  storage_encode_1013x2393round_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1013x2393round_s = aligned(storage_encode_1013x2393round_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1013x2393round_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1013x2393round_x = aligned(storage_encode_1013x2393round_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1013x2393round_s2 = callocplus(maxalloc);
  test_encode_1013x2393round_s2 = aligned(storage_encode_1013x2393round_s2,crypto_encode_STRBYTES);
  storage_encode_1013x2393round_x2 = callocplus(maxalloc);
  test_encode_1013x2393round_x2 = aligned(storage_encode_1013x2393round_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1013x2393round offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1013x2393round();++impl)
      forked(test_encode_1013x2393round_impl,impl);
    ++test_encode_1013x2393round_s;
    ++test_encode_1013x2393round_x;
    ++test_encode_1013x2393round_s2;
    ++test_encode_1013x2393round_x2;
  }
  free(storage_encode_1013x2393round_x2);
  free(storage_encode_1013x2393round_s2);
  free(storage_encode_1013x2393round_x);
  free(storage_encode_1013x2393round_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

