/* ----- encode/1277x2627, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1277x2627_checksums[] = {
  "5b26afe7bb755c250ae9d208a9d8552b0ee95f0d2cfac20ed44a8f918524eb04",
  "b482d6dc7d917bb111a4d164ac216f755fadf3e8571f3d00009473d3f346f43b",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1277x2627_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1277x2627_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1277x2627_ITEMBYTES

static void *storage_encode_1277x2627_s;
static unsigned char *test_encode_1277x2627_s;
static void *storage_encode_1277x2627_x;
static unsigned char *test_encode_1277x2627_x;
static void *storage_encode_1277x2627_s2;
static unsigned char *test_encode_1277x2627_s2;
static void *storage_encode_1277x2627_x2;
static unsigned char *test_encode_1277x2627_x2;

#define precomputed_encode_1277x2627_NUM 4

static const unsigned char precomputed_encode_1277x2627_s[precomputed_encode_1277x2627_NUM][crypto_encode_STRBYTES] = {
  {146,126,107,43,156,102,147,200,169,112,16,229,244,236,192,222,55,216,214,48,164,85,177,47,2,176,85,137,223,155,216,171,236,194,248,224,200,69,143,211,32,32,86,113,26,154,32,171,7,62,85,149,135,99,177,21,192,246,92,105,83,128,7,242,207,201,164,239,114,64,160,248,140,191,35,123,236,179,149,126,193,183,2,99,239,75,89,130,167,236,32,58,216,119,3,133,90,133,198,161,35,210,125,176,122,169,112,3,139,136,66,116,251,143,164,119,243,54,78,16,15,139,94,150,67,27,158,23,22,19,13,225,151,77,11,13,62,78,172,19,101,143,135,69,225,226,93,95,6,167,109,214,26,173,215,52,89,67,174,186,76,201,131,68,150,17,220,112,161,198,210,127,170,218,3,76,234,125,12,62,8,229,51,154,231,114,99,64,199,118,184,142,131,168,23,182,87,89,147,14,72,117,53,177,232,10,174,106,35,193,112,219,88,25,68,214,117,82,229,128,50,28,1,49,241,215,13,110,112,77,62,96,200,1,23,1,169,167,236,242,120,63,84,22,215,72,182,80,35,122,139,144,205,0,161,88,196,116,105,24,18,149,120,173,66,21,184,2,161,57,231,202,254,176,78,80,226,36,59,4,203,61,175,203,119,140,188,94,163,249,26,37,45,33,240,58,64,15,62,98,3,151,213,69,113,22,34,184,151,16,172,22,151,165,219,168,152,81,147,142,76,14,43,20,176,33,87,135,182,230,238,21,33,244,236,127,213,250,107,189,244,7,187,3,19,2,106,171,88,115,192,40,143,100,73,236,235,7,133,0,118,205,60,160,192,22,190,65,246,82,37,200,67,98,127,98,30,88,23,18,34,37,18,136,19,225,76,78,135,142,106,231,193,77,72,195,10,123,242,240,249,217,49,99,216,86,143,239,140,53,17,166,215,144,215,120,182,8,38,154,182,8,216,255,250,55,114,122,92,23,88,204,244,81,222,213,205,63,52,18,25,103,240,165,201,206,129,70,4,81,91,61,99,241,221,59,247,73,134,24,79,244,190,13,113,72,132,79,120,39,64,113,110,88,42,102,165,32,130,165,242,115,90,92,189,104,210,42,85,90,159,124,79,92,220,3,198,109,69,9,87,233,180,121,168,200,16,50,208,203,141,113,123,71,7,223,82,83,233,232,178,150,66,128,156,245,202,167,164,208,22,82,104,134,38,49,162,203,67,234,160,105,92,169,208,121,91,129,204,232,169,216,149,115,196,50,248,114,218,122,252,80,208,186,62,107,43,94,171,42,249,63,148,200,72,120,15,222,27,18,123,32,241,69,165,184,251,213,158,204,88,187,129,196,64,221,201,32,125,156,25,105,24,203,64,88,216,102,64,160,248,76,7,3,13,69,13,45,64,245,231,199,96,176,49,34,68,92,32,40,5,209,188,117,192,178,167,134,5,143,77,106,58,109,166,167,72,118,208,135,234,19,99,255,98,5,115,5,169,83,75,103,154,22,162,159,220,226,242,24,18,251,174,196,128,103,50,242,223,44,151,220,75,25,129,252,236,67,185,189,94,165,94,36,143,98,171,44,75,200,129,132,19,38,214,14,252,221,29,119,172,168,151,30,179,242,141,115,62,38,140,8,88,215,202,203,173,248,220,214,161,219,253,233,29,143,251,152,96,39,18,218,224,152,16,251,178,206,54,152,110,153,220,35,18,111,236,162,206,102,219,235,181,122,223,61,252,124,91,238,189,178,209,59,137,251,70,43,212,187,151,62,163,101,0,4,252,236,151,11,220,245,253,199,217,130,212,110,87,68,245,178,240,7,223,43,159,85,191,61,140,25,147,65,152,73,19,1,118,211,214,164,186,9,148,144,2,197,196,221,143,88,171,94,24,156,25,191,98,179,83,163,219,8,237,108,103,87,235,101,59,188,9,123,106,123,146,166,88,241,101,61,135,114,106,124,227,251,56,254,88,249,238,193,241,207,187,7,58,166,25,191,104,162,161,112,28,110,207,244,196,22,42,4,69,3,139,210,18,144,166,254,188,162,51,222,177,244,147,59,35,34,66,54,133,190,17,167,236,115,73,176,35,38,64,21,157,181,40,248,108,228,223,123,69,84,151,71,94,101,5,27,62,124,93,132,40,20,252,64,152,26,120,80,114,9,208,162,169,83,159,211,26,92,73,3,2,207,234,182,59,12,93,103,12,176,219,158,76,201,7,35,29,80,126,239,227,228,224,181,52,102,49,113,12,149,210,103,126,33,194,74,75,43,74,160,183,135,226,50,151,69,186,124,200,36,67,41,191,243,124,111,220,246,158,191,67,64,81,163,225,45,250,211,189,11,138,107,187,69,20,185,193,161,58,126,101,54,51,194,13,232,45,221,51,19,151,218,99,171,84,23,18,88,158,8,62,33,4,212,154,205,64,16,74,164,162,70,45,2,182,229,227,203,235,59,111,181,46,50,179,148,91,208,58,112,44,48,157,135,249,219,171,38,199,213,58,25,183,85,46,254,138,36,178,120,124,83,127,110,136,141,70,202,95,119,55,131,180,69,207,245,160,61,9,232,19,131,38,126,69,27,160,216,227,107,90,79,205,219,72,54,246,199,83,142,73,72,207,175,110,218,155,48,179,216,77,77,7,224,238,86,67,97,240,43,193,105,129,66,221,73,222,195,228,100,254,170,28,56,116,150,58,40,239,204,83,14,85,192,177,116,158,53,53,223,197,235,236,171,154,249,38,10,144,142,150,236,180,152,78,24,121,237,183,31,253,226,148,153,187,245,79,14,236,146,174,123,27,227,171,87,61,71,141,182,115,50,66,250,125,109,167,192,85,131,22,85,105,198,220,61,149,124,42,192,189,204,227,178,1,148,104,103,26,29,172,53,172,143,117,150,170,26,205,192,152,9,109,138,10,133,84,211,176,45,220,166,57,227,160,164,57,222,161,219,179,117,254,182,126,36,65,116,164,184,172,32,167,185,247,18,9,246,114,254,5,241,73,49,182,43,173,85,185,107,175,250,246,65,73,5,102,7,157,111,126,50,57,68,115,116,60,72,133,210,120,167,122,234,141,28,204,26,188,242,173,150,196,169,125,228,255,229,248,4,172,134,4,25,87,65,41,180,142,110,122,131,112,185,198,247,9,2,10,231,97,189,81,155,98,91,103,250,78,33,84,235,14,102,91,157,139,100,44,194,234,221,90,136,176,63,129,166,80,15,241,28,228,255,132,186,168,122,247,155,38,12,61,225,132,212,174,196,239,151,180,155,78,149,121,88,27,233,128,251,102,104,177,199,251,131,237,254,250,206,249,60,243,242,176,232,132,64,161,84,181,88,125,6,195,56,175,11,141,211,148,73,153,121,73,37,152,252,117,208,137,47,147,60,155,140,225,140,34,126,176,29,52,228,151,138,175,61,208,245,170,209,39,145,216,147,121,19,250,65,104,167,53,179,97,197,18,173,135,206,154,199,22,209,196,6,168,131,255,148,252,153,149,48,97,86,99,120,50,45,60,189,98,244,178,69,11,71,155,230,72,45,199,141,245,243,132,30,120,37,125,10,210,159,118,54,104,59,0,156,36,138,208,43,22,199,224,133,165,120,41,253,190,229,35,65,176,199,210,113,247,66,193,223,143,240,18,120,227,202,61,181,30,130,181,118,8,139,226,128,84,86,125,62,116,188,154,229,159,47,246,251,71,167,140,237,213,91,62,200,118,96,214,65,108,151,181,137,150,142,108,250,105,26,254,185,188,117,153,231,88,135,88,41,197,99,240,223,221,222,47,94,28,227,59,196,189,68,57,252,57,135,149,36,20,160,72,48,17,114,24,82,186,135,197,146,212,32,163,187,20,100,205,132,198,247,34,14,28,112,41,41,101,171,108,64,61,92,182,195,64,139,58,142,239,219,136,177,248,9,128,234,7,236,52,214,156,6,52,126,118,203,43,173,207,7,236,99,137,12,153,167,69,142,165,4,117,184,28,82,246,111,34,159,8,250,8,8,212,70,168,84,201,207,22,77,227,53,0,37,5,53,11,96,78,124,23,225,254,147,135,221,214,214,226,65,71,208,0,252,245,134,98,133,30,142,2,174,0},
  {29,12,139,7,51,22,98,36,99,237,247,67,38,141,7,144,16,113,161,61,92,146,215,190,23,42,203,186,251,141,176,250,133,76,100,105,157,245,181,10,26,220,183,192,174,121,255,206,186,69,154,200,45,96,124,124,128,57,38,227,114,58,142,33,138,150,119,75,96,33,156,190,1,162,170,139,158,91,87,49,96,1,12,72,96,233,79,84,255,92,38,242,133,136,174,136,119,8,143,95,11,151,221,231,244,26,154,154,162,9,162,0,135,6,97,52,223,23,10,21,20,71,89,40,151,65,54,205,155,114,108,110,167,38,47,113,111,159,163,7,73,146,88,193,190,183,195,156,103,68,93,0,107,172,125,149,107,121,182,185,65,164,185,119,4,17,231,56,225,213,222,111,231,255,165,83,130,142,205,113,186,105,162,166,112,27,79,173,34,56,250,85,79,157,177,176,151,168,140,239,57,88,252,3,80,4,36,146,169,202,178,152,30,107,19,165,123,69,202,194,222,26,166,226,50,103,205,116,78,22,14,29,5,118,27,232,129,33,13,182,234,143,129,189,116,74,70,160,227,60,231,155,103,179,87,207,203,29,240,169,15,74,239,93,80,162,34,215,18,194,199,125,168,196,57,229,132,238,184,241,81,120,149,180,32,58,71,113,218,52,150,119,20,59,32,254,61,103,232,252,250,15,168,142,254,224,72,147,255,160,207,187,54,66,231,13,11,200,229,222,88,252,69,74,255,192,226,193,70,58,46,43,173,98,156,235,21,241,63,68,207,149,62,227,100,193,156,100,2,145,5,91,47,134,80,223,49,106,9,199,86,247,225,238,168,108,89,56,36,140,201,0,91,92,96,102,255,193,32,122,193,60,64,204,152,0,124,212,37,129,61,179,123,238,53,147,8,14,56,92,101,242,93,76,162,38,3,121,239,88,35,73,204,59,63,72,64,240,249,246,227,199,95,81,230,191,63,160,41,141,237,135,165,113,67,60,127,100,139,138,163,75,120,72,183,14,111,206,55,247,220,11,61,197,88,38,200,90,80,46,197,78,197,194,16,4,33,27,197,245,106,174,208,252,109,11,109,109,227,45,179,152,172,122,135,56,179,168,184,58,44,128,96,247,50,98,64,73,114,211,35,111,70,190,13,190,229,181,160,197,189,220,75,51,181,106,153,222,59,114,149,251,78,254,216,218,59,157,217,240,210,55,83,153,1,205,158,13,191,215,72,131,32,41,86,126,55,243,242,62,178,179,228,170,25,75,56,38,86,162,234,124,92,82,190,13,96,53,161,181,247,187,21,204,47,137,173,143,105,36,69,60,31,72,137,243,235,181,17,48,190,26,4,54,128,30,143,141,251,34,148,204,14,187,246,91,40,17,73,238,181,181,41,101,142,222,168,114,152,234,157,66,214,163,130,69,152,248,249,40,138,97,159,218,31,102,166,66,98,52,50,216,215,168,56,241,169,185,255,186,255,81,10,50,125,36,21,247,13,143,7,72,47,159,97,182,253,187,35,133,134,90,222,241,155,203,44,34,175,143,215,59,147,72,37,92,244,185,12,137,140,227,135,143,114,154,55,94,239,254,175,37,83,251,22,169,129,99,166,40,52,125,220,84,214,86,45,60,231,10,234,137,215,67,39,25,147,111,156,149,54,109,98,190,44,181,57,176,173,186,174,213,179,208,71,86,246,78,164,93,255,49,211,63,133,194,130,69,229,26,98,184,22,195,183,33,128,32,74,182,146,42,45,108,19,114,32,93,73,99,70,178,93,73,235,13,173,126,191,181,115,169,225,208,173,24,9,130,193,240,78,158,177,253,138,63,244,160,163,83,26,4,4,52,77,235,58,35,36,22,200,99,189,123,176,139,199,109,168,18,111,137,129,7,35,223,99,134,227,254,161,153,202,180,40,34,86,68,106,108,123,62,0,227,91,85,175,245,52,208,34,168,139,64,253,70,14,12,249,149,167,117,93,137,151,127,7,215,188,142,106,56,132,14,208,139,80,128,95,36,126,134,108,255,52,43,128,10,192,74,238,5,132,229,122,197,239,246,169,165,96,236,133,2,184,107,71,32,3,42,132,134,95,158,55,109,5,31,96,244,58,247,87,7,160,41,19,56,12,48,146,92,101,136,212,199,28,226,218,132,163,232,122,155,130,169,140,146,224,27,84,204,211,55,27,121,244,74,12,251,171,194,134,70,117,137,13,254,44,228,3,7,192,53,8,184,90,92,23,151,33,7,125,131,114,135,203,102,250,95,135,13,109,142,66,140,234,171,87,158,80,200,152,247,144,79,214,213,75,196,76,79,149,93,107,156,144,118,53,198,7,46,76,245,183,139,254,82,57,30,12,128,89,191,139,177,240,75,119,250,110,117,246,152,254,199,216,13,117,246,138,68,224,64,68,180,246,3,108,80,150,227,219,194,176,233,174,232,162,193,3,132,81,204,48,70,86,179,218,11,50,222,212,155,185,103,74,87,187,30,106,90,108,240,141,212,140,44,37,76,116,25,9,230,221,160,152,206,13,11,224,195,161,228,204,221,49,143,89,107,175,119,223,115,237,237,197,105,177,204,50,133,177,167,74,4,10,151,36,61,98,185,24,18,101,249,90,136,234,225,103,53,18,189,59,109,77,198,79,233,175,57,72,4,241,216,11,143,141,25,29,41,167,228,111,137,203,139,251,97,45,75,121,38,175,230,192,167,122,196,168,95,21,75,52,104,108,25,27,34,27,221,211,202,16,16,124,127,142,195,127,224,202,117,227,235,174,14,120,137,37,250,182,37,127,19,33,26,121,62,211,191,147,146,179,135,93,105,129,225,203,166,174,230,132,150,138,59,208,20,197,61,209,211,0,55,42,128,70,149,227,218,31,234,44,232,94,85,145,108,240,90,73,166,107,149,232,127,200,132,121,192,70,147,214,35,111,155,254,141,159,161,195,131,93,166,90,137,170,214,71,240,193,136,241,8,0,249,132,152,103,212,170,164,5,35,213,150,78,93,9,2,16,217,51,12,136,226,221,79,188,48,150,246,94,172,45,5,198,158,135,243,202,100,162,107,149,172,122,159,72,63,203,155,14,185,106,225,97,74,205,85,10,126,143,113,148,17,239,239,182,32,0,43,5,216,187,247,30,149,73,214,15,94,249,216,100,129,201,223,113,96,190,98,36,229,60,212,12,157,54,161,255,249,172,197,12,48,40,216,97,202,40,35,136,163,225,191,251,183,226,97,63,44,237,195,33,48,85,74,160,64,166,168,71,244,249,241,238,241,113,93,241,39,201,30,96,17,114,210,41,226,119,216,237,75,116,122,237,39,21,5,220,185,168,198,42,172,185,240,4,221,241,175,187,105,254,42,6,76,151,161,74,248,13,175,45,157,150,186,1,146,132,61,1,69,194,140,148,22,77,167,74,120,142,41,229,58,222,53,97,109,222,68,72,166,94,247,22,53,3,247,172,177,12,97,90,195,107,10,14,54,155,196,206,34,7,202,124,141,115,125,174,11,104,153,227,102,182,24,230,145,173,143,239,95,85,100,227,198,37,199,187,102,81,184,62,40,200,170,100,93,241,8,163,85,89,240,196,205,61,220,107,149,92,241,150,119,142,70,138,166,54,78,140,182,193,21,22,182,179,157,39,186,165,30,15,121,131,107,201,109,216,202,159,188,248,76,38,196,47,5,97,130,69,42,185,124,33,138,119,28,51,105,157,86,115,124,115,210,14,224,230,94,39,139,83,82,118,147,171,218,171,164,161,236,160,193,79,170,215,197,49,83,135,227,107,219,83,135,7,233,181,18,27,131,40,114,110,132,210,171,156,166,179,240,153,234,118,175,156,220,164,57,32,174,208,18,237,106,241,6,142,252,168,106,222,101,2,217,203,168,236,38,150,11,167,95,139,143,252,158,149,210,150,88,27,46,95,136,76,63,129,212,131,127,86,63,244,95,170,84,77,69,100,101,24,250,41,139,128,129,45,225,229,121,170,21,136,186,175,133,149,135,94,137,62,39,113,81,105,21,192,119,66,160,94,47,93,58,143,124,118,168,155,140,14,7,86,92,50,64,158,102,28,132,243,118,163,112,233,177,162,35,0},
  {88,27,165,127,96,55,131,144,188,221,136,92,4,201,235,76,148,125,2,114,110,98,163,10,5,35,198,4,246,205,73,168,203,135,182,91,216,173,216,194,102,49,179,193,163,76,252,165,53,139,190,8,230,224,237,87,232,245,19,108,141,170,113,136,185,248,0,254,175,192,236,38,169,60,205,80,43,17,150,236,104,207,223,253,55,238,94,48,117,168,140,252,234,4,236,106,252,0,166,164,25,96,47,170,41,50,13,208,196,212,133,255,36,151,228,252,65,131,106,184,126,168,177,73,143,124,242,235,47,19,63,123,144,236,33,234,14,103,25,252,131,167,49,53,230,129,84,90,121,224,17,135,148,49,137,160,118,111,158,116,221,127,139,1,240,78,189,98,241,232,6,61,234,201,206,125,66,161,237,226,50,56,106,83,25,186,11,243,199,236,168,56,89,111,24,20,246,176,33,222,46,24,204,40,245,210,149,201,74,75,6,40,189,112,101,179,212,100,90,148,116,169,68,13,70,42,176,221,70,43,208,83,109,246,86,18,33,192,27,77,59,171,33,249,88,151,91,254,114,93,37,106,167,214,239,227,36,123,158,141,212,196,168,216,8,63,216,177,165,117,117,174,138,212,224,4,239,115,72,125,151,255,161,180,46,55,150,57,67,192,233,9,120,202,36,72,133,6,196,96,225,78,116,20,177,195,175,192,78,255,7,160,122,113,200,183,153,69,14,128,4,32,188,197,239,169,3,63,222,158,88,66,146,97,232,168,24,65,150,251,67,69,226,61,91,20,104,111,21,107,119,230,74,93,2,75,214,241,57,141,211,59,145,138,231,19,168,173,98,6,187,35,229,238,130,200,181,131,167,123,213,67,217,177,163,89,185,16,170,188,27,55,81,159,248,106,160,177,171,154,97,106,100,144,227,99,98,181,21,214,84,119,156,221,70,163,125,119,241,88,146,192,26,193,189,98,51,213,88,209,161,155,106,56,148,173,249,29,251,20,116,150,81,242,86,78,193,47,199,50,18,51,200,36,135,116,109,174,183,154,136,13,75,242,149,39,33,25,69,39,3,170,53,74,203,89,182,24,132,102,205,24,41,213,112,29,86,169,239,220,71,156,81,88,8,5,195,143,186,51,10,249,149,97,76,97,93,50,70,155,235,75,235,126,185,215,195,166,80,0,176,164,67,45,238,197,52,97,202,241,91,146,22,150,213,223,152,116,202,252,182,139,81,203,145,67,30,139,78,97,96,102,253,152,226,53,192,147,9,247,68,246,71,213,71,142,115,141,126,104,123,197,139,47,132,74,42,158,250,253,62,44,44,72,29,250,38,222,68,190,114,191,155,51,8,6,213,119,126,110,27,44,92,173,28,213,55,170,132,71,220,158,217,17,99,228,169,235,36,253,33,85,200,177,11,221,194,210,38,97,185,63,249,150,113,157,213,201,62,202,13,85,59,55,142,83,116,202,115,168,71,180,200,249,120,191,197,204,54,24,124,165,155,183,184,138,99,108,75,240,38,14,91,192,82,101,105,231,224,176,14,1,175,104,63,232,66,157,194,197,147,200,176,134,109,165,144,192,107,10,170,162,147,8,187,38,171,233,163,196,92,101,165,184,233,85,251,185,116,78,6,95,103,48,176,86,162,51,67,105,8,192,15,143,92,41,31,216,153,34,100,218,70,113,89,189,74,215,188,235,111,233,248,155,73,231,242,31,186,105,79,153,100,55,119,2,189,213,138,244,63,122,122,87,207,90,94,130,186,181,125,93,81,107,168,114,83,88,65,128,210,252,159,11,147,64,123,110,194,166,0,58,168,5,141,163,252,114,49,0,72,9,232,76,76,203,162,255,126,251,110,49,253,29,238,46,27,171,47,13,218,107,143,217,8,193,60,219,104,96,105,133,94,126,90,7,31,199,39,166,34,88,237,27,232,12,90,211,103,255,97,34,111,212,231,113,204,155,180,93,20,49,210,242,240,166,176,219,200,255,1,157,129,134,89,91,30,6,60,250,122,215,98,149,188,236,40,72,196,99,192,246,108,10,2,28,226,1,194,203,197,196,222,25,112,170,35,51,162,112,234,183,88,51,83,158,119,211,71,44,238,47,29,79,53,159,229,24,206,102,28,110,203,185,13,204,129,32,96,133,105,89,42,233,28,29,226,202,23,231,199,240,50,208,52,139,122,180,101,160,137,111,150,246,4,107,54,98,90,218,153,6,235,48,243,92,7,164,14,49,145,217,45,241,230,216,79,109,40,130,131,60,187,14,125,90,215,32,248,163,249,15,212,124,47,200,21,85,142,239,232,209,65,93,17,26,38,209,29,98,141,240,150,240,172,195,168,3,3,26,237,252,121,144,44,82,169,8,239,251,217,113,125,209,189,47,81,175,29,149,215,110,143,56,196,229,6,75,146,85,220,218,143,172,82,89,175,192,239,60,237,207,75,243,22,247,18,161,85,122,217,237,132,190,174,118,26,116,108,104,168,250,2,183,168,55,114,13,82,54,135,200,238,227,171,17,98,188,212,43,71,242,82,51,114,243,204,102,197,40,242,28,6,17,70,18,3,210,142,237,111,250,77,229,33,138,125,251,92,127,169,21,121,202,21,186,152,234,229,180,50,120,174,101,66,150,28,98,51,61,216,232,128,215,71,198,193,6,76,180,209,43,171,52,19,207,134,146,18,221,178,178,217,2,103,99,208,198,91,131,211,166,98,204,158,36,18,25,150,72,138,148,89,152,112,49,168,119,177,222,104,47,232,10,155,42,159,70,135,112,35,160,228,141,178,224,89,173,171,238,157,139,41,76,92,225,91,92,254,229,79,71,151,57,92,123,180,254,198,83,101,200,206,249,111,151,120,173,155,41,208,166,219,246,227,206,247,67,173,86,208,230,138,216,224,167,158,43,99,214,79,11,160,112,9,191,100,3,70,199,104,114,104,6,47,135,104,71,101,158,250,36,55,156,126,202,121,84,46,211,18,195,109,198,64,32,165,117,131,45,85,217,102,173,123,60,33,16,255,209,138,89,148,129,134,80,179,95,15,44,131,171,67,11,152,26,18,242,246,120,122,190,103,89,17,176,66,251,58,231,130,9,132,71,217,234,188,57,20,86,65,222,34,164,63,235,192,186,80,192,220,83,53,38,43,50,236,210,226,216,62,181,83,55,84,242,151,191,247,75,237,160,91,203,62,101,50,86,119,223,10,93,33,91,252,144,149,232,53,236,223,170,209,174,105,51,108,106,155,72,24,104,67,152,75,126,171,72,203,0,229,15,135,8,250,67,185,124,30,72,239,155,143,215,161,54,19,114,200,105,204,84,55,225,103,161,1,206,111,27,5,66,102,255,158,10,169,73,139,59,31,210,240,79,226,190,72,132,197,40,88,53,48,59,220,137,6,21,146,80,62,255,43,141,246,27,185,43,101,8,80,219,3,133,182,0,172,192,116,226,180,242,236,222,98,5,225,208,142,10,203,56,11,110,135,192,126,35,130,41,24,194,6,143,3,113,186,116,201,167,188,45,68,189,192,156,1,147,248,181,246,109,198,76,16,161,103,31,142,32,148,55,21,143,73,141,2,92,146,154,22,156,38,241,182,56,91,139,232,167,87,70,207,140,62,185,96,78,217,10,166,108,226,162,34,219,64,89,234,221,99,122,145,71,121,229,61,105,6,167,191,228,48,35,253,81,183,170,185,74,142,92,10,222,192,204,225,36,122,241,140,192,143,158,59,27,241,107,191,175,196,207,218,207,47,91,22,51,15,250,171,29,200,237,128,16,134,61,149,70,247,238,136,60,83,243,222,159,77,216,69,204,186,228,51,38,198,213,2,97,213,21,20,159,178,189,51,63,119,159,245,55,11,209,91,196,190,129,92,214,180,74,94,149,168,101,73,248,205,195,97,129,110,101,229,123,59,32,181,22,251,202,212,78,46,218,155,249,105,91,252,200,240,39,91,185,155,112,154,245,93,54,87,179,159,90,65,144,152,128,43,170,99,209,230,17,252,184,128,197,99,35,128,232,123,149,199,4,10,59,121,174,1,186,194,230,184,93,158,121,205,210,78,126,44,161,69,94,187,9,112,23,126,79,1},
  {76,194,198,167,58,242,188,207,1,73,228,47,116,142,133,18,76,226,18,121,180,99,242,35,128,155,0,227,2,126,187,126,140,11,132,216,119,252,19,87,112,147,6,199,219,81,253,231,75,243,16,155,75,51,70,39,233,28,167,179,135,212,55,189,132,242,101,83,209,146,57,130,173,115,127,90,134,62,241,245,244,209,79,180,252,61,203,139,204,32,19,96,103,218,191,79,151,104,239,192,150,204,50,157,232,75,234,6,116,60,84,27,26,55,92,215,233,211,6,146,55,52,75,29,8,15,109,100,188,39,171,134,245,53,24,51,77,161,68,3,238,213,100,35,199,226,111,105,179,158,209,161,144,51,39,0,35,235,9,198,30,95,128,38,219,123,25,46,116,236,252,239,133,149,61,144,102,83,42,41,123,206,203,6,189,48,13,164,21,135,232,157,162,250,221,209,127,77,226,82,250,112,231,71,40,99,216,228,227,178,93,147,133,170,137,118,126,22,39,23,7,219,191,149,22,179,119,241,200,39,189,249,221,38,235,122,205,135,205,168,55,51,83,176,63,116,214,200,94,108,123,207,244,36,27,51,141,252,241,16,207,110,233,155,133,205,69,221,212,165,33,122,87,51,97,110,158,36,85,165,46,248,65,155,33,77,142,222,66,55,135,145,31,92,2,48,20,125,170,34,131,137,214,134,154,218,222,93,154,121,218,86,63,8,17,171,18,44,112,1,224,229,236,29,91,172,134,38,122,239,207,169,206,196,64,110,212,27,132,95,43,255,176,69,193,71,125,130,93,98,23,54,192,191,172,121,53,74,176,215,156,65,247,187,150,180,244,207,150,25,44,41,68,59,165,248,74,53,120,117,249,108,52,24,69,198,89,220,185,105,133,66,80,206,188,133,171,229,237,236,187,7,224,151,57,81,39,10,245,26,34,38,67,255,246,44,152,15,168,53,34,216,253,245,203,208,227,98,74,1,248,110,28,226,1,39,150,45,188,252,243,33,161,71,173,14,142,8,30,61,80,108,89,161,121,49,161,169,63,246,157,17,11,234,140,246,225,193,135,135,251,87,20,21,115,255,69,167,214,90,113,218,49,241,10,40,98,77,220,220,212,115,106,133,141,223,207,117,220,206,113,66,105,223,130,251,130,142,0,15,160,67,5,179,122,210,140,62,199,28,32,82,101,211,2,92,83,3,252,73,223,149,141,152,234,9,216,110,1,193,16,193,127,6,71,10,200,239,197,191,129,240,248,237,39,42,173,124,175,20,37,132,235,190,159,182,182,115,60,108,169,35,80,190,215,56,13,172,162,131,210,247,56,157,105,50,164,198,148,180,219,91,81,168,80,62,125,38,244,137,149,140,80,141,64,247,155,123,212,72,46,176,2,79,33,6,83,74,58,107,52,250,66,224,234,212,195,213,48,156,254,93,96,193,254,63,28,240,219,50,234,254,19,42,186,131,173,241,141,238,86,158,11,252,83,126,21,138,105,84,250,68,213,49,5,229,91,24,104,156,206,119,124,159,208,89,248,161,186,28,39,194,250,207,174,105,52,170,85,29,90,214,196,153,169,6,208,65,141,181,66,90,6,225,7,96,138,48,111,84,221,113,185,134,75,196,46,225,157,66,91,62,241,6,195,167,40,55,38,2,222,100,249,57,105,16,212,219,67,199,88,164,242,227,81,182,193,67,229,109,253,41,210,181,153,221,65,2,58,181,135,42,85,192,144,212,92,13,146,101,253,47,243,226,198,145,201,30,14,118,80,135,175,61,1,48,102,226,28,87,79,109,21,245,36,90,134,20,135,176,49,179,12,251,218,109,183,175,46,153,193,92,25,138,233,175,87,141,153,244,22,71,179,221,79,31,105,98,190,115,204,165,30,13,112,102,37,81,241,101,91,96,42,116,128,135,185,140,57,137,146,242,236,217,246,172,225,253,15,217,95,47,247,48,152,98,93,126,26,112,5,187,144,168,173,233,129,22,37,137,36,173,108,224,207,47,156,230,244,118,5,89,201,171,216,15,34,207,157,196,57,111,42,79,31,124,103,17,101,15,105,100,67,217,167,5,237,255,56,218,222,199,24,169,22,132,1,64,37,21,6,167,34,52,175,87,250,151,105,141,226,244,177,110,164,50,55,21,40,35,244,13,237,252,78,129,74,144,146,116,6,13,242,174,63,69,52,214,160,171,163,155,45,127,51,244,212,94,68,190,185,56,194,98,97,111,90,212,179,180,245,147,58,58,170,124,177,254,96,130,122,215,157,243,111,74,18,233,215,2,16,227,230,147,86,175,29,174,168,7,39,158,79,213,102,39,114,201,135,64,189,38,132,220,55,152,174,253,42,64,204,56,16,216,172,174,174,61,0,104,147,36,222,114,64,50,65,225,132,158,141,86,242,18,148,139,251,105,73,240,130,119,135,145,158,245,64,219,32,253,227,241,222,85,132,225,248,225,250,102,52,166,140,108,101,161,231,68,239,221,231,194,187,100,106,136,31,186,69,84,227,237,121,3,199,250,18,50,144,39,244,234,150,53,156,26,9,235,10,188,114,225,106,14,92,41,36,77,163,227,54,169,182,40,235,171,73,10,124,79,147,230,124,79,50,223,235,192,180,73,170,162,34,58,37,217,73,170,180,218,226,222,180,116,33,108,209,208,154,206,211,143,133,154,252,59,113,28,162,2,45,220,176,68,63,121,169,235,51,124,123,100,78,208,102,194,162,196,92,60,39,195,76,247,29,184,15,148,6,204,46,170,82,27,225,91,67,182,251,96,16,24,77,244,90,180,72,65,167,12,220,54,23,67,167,86,7,245,60,196,62,145,244,179,43,60,53,74,5,73,17,209,110,137,236,49,75,183,218,137,81,164,169,85,63,69,145,186,150,136,108,6,33,49,179,182,54,215,203,83,76,188,197,93,31,84,249,230,133,253,178,175,206,101,48,156,27,216,16,251,27,79,217,159,43,192,103,91,156,45,224,158,85,43,226,80,185,98,242,220,206,23,74,180,94,219,38,25,174,64,143,15,61,53,220,152,196,244,252,13,122,109,192,116,39,93,128,232,244,140,55,63,182,37,52,40,153,45,225,85,42,79,110,56,210,150,39,20,76,79,230,199,131,190,134,86,160,89,21,61,75,254,148,104,193,144,32,33,113,112,105,4,62,66,234,16,119,71,182,150,185,165,97,245,238,232,184,211,64,238,122,202,186,242,185,70,170,119,204,52,251,46,65,174,231,188,30,191,242,159,168,2,166,154,119,198,72,236,189,227,16,244,169,89,195,141,129,33,185,125,166,184,189,56,196,240,226,100,239,250,89,29,26,40,58,102,25,84,50,185,172,203,162,242,242,247,191,0,103,62,5,237,215,100,86,145,123,130,63,148,234,53,109,165,204,139,147,19,8,247,214,203,130,83,134,46,43,53,186,21,154,238,150,238,160,169,114,141,167,241,122,187,29,232,99,214,12,154,24,176,100,68,136,247,203,247,190,91,69,120,51,120,88,48,127,179,219,243,196,138,0,95,22,208,130,223,254,226,46,156,217,15,42,57,172,120,53,39,80,68,97,2,165,24,251,133,124,182,135,121,105,90,111,102,206,226,201,78,40,131,95,242,158,83,67,74,184,19,43,46,83,147,229,136,90,196,27,163,16,108,177,187,23,55,165,128,197,229,30,91,182,192,253,48,32,237,102,7,71,225,87,126,229,176,2,123,217,227,145,4,156,114,114,222,137,161,39,139,80,232,171,206,142,247,177,237,220,229,129,219,118,211,88,82,121,165,138,24,201,142,229,150,82,27,170,15,67,175,202,199,193,46,56,33,18,185,70,218,97,3,192,126,164,88,95,239,198,65,250,162,239,39,56,0,82,6,210,39,125,95,67,139,111,198,103,119,109,54,110,196,61,223,4,169,188,46,238,115,179,3,191,215,174,142,13,23,177,59,66,238,11,146,2,237,6,246,73,232,20,154,71,163,84,36,122,245,175,67,1,182,11,65,92,116,2,78,80,200,45,154,231,23,247,108,139,250,91,131,90,105,136,126,103,59,166,207,94,26,157,126,16,36,208,134,122,110,106,18,68,227,116,63,81,139,1},
} ;

static const int16_t precomputed_encode_1277x2627_x[precomputed_encode_1277x2627_NUM][crypto_encode_ITEMS] = {
  {9453,-19393,26149,-15375,16233,-24628,3574,32553,28622,-11912,8815,1363,12204,7502,3256,-4991,2824,10568,-18388,-26064,3248,15910,15630,-11479,-22334,-16982,-88,-22672,-13494,28504,-9356,22894,14034,-2760,31183,8326,656,11946,-13130,-15025,31359,1458,23134,11208,-32527,16006,32070,-22138,24929,-9757,-9550,3437,24875,-32266,7549,-30119,23855,-15164,12053,3496,21095,6573,6511,9227,18486,-4847,6806,-25339,32369,-9227,-31653,-18005,22906,-14132,-148,24530,-27961,27238,23843,-24099,-23515,2099,23684,15613,920,8505,18357,-18938,-9204,1290,1505,3111,-24562,21158,6018,-16471,-20402,4476,30435,21773,29382,6602,-8582,2769,-32188,8759,-30607,21726,516,13532,25632,-30092,-27291,-24169,-24759,22581,-25406,19417,11874,11028,11413,2608,-23930,21016,24706,25322,16281,-13505,-15755,707,-28160,30091,12445,-27403,-8261,13493,-32700,-17307,-31151,10511,2316,-30755,-15962,31991,-13084,-27886,997,-10866,-5719,-3296,-7219,-30660,18290,-14435,4075,-13051,-16845,-15889,16499,8388,15215,10639,32742,18377,-12199,-6623,32401,1108,-20141,-31933,23209,-26643,-32525,23509,5900,26834,-3518,-2180,-27502,-26961,-10511,-14496,3775,8903,-32318,-17970,9607,-12449,23395,-29340,7927,21538,24897,-22742,25567,3296,29429,-6674,-28100,32124,611,15098,-20167,22752,2517,4895,-9281,8813,-13686,20957,297,-2678,18024,19186,31595,13257,-5825,22643,-23406,-28366,12001,-25777,26017,26676,27505,3380,23825,-32038,17500,31546,-26382,-15957,13230,-14559,-16608,-19426,-14445,-16609,7783,19848,-6022,29368,15875,-19270,-8999,4088,-19508,19204,24309,3727,-26903,10020,-31589,14466,-3174,-16705,-18756,-14377,13386,-23603,-13127,21843,19782,3146,-20801,26666,1777,32422,20843,2513,21787,31132,-16827,78,21493,8357,17543,26526,-19453,22775,9784,17100,10587,28066,-27533,9570,-20579,-29351,-21746,-1849,22176,15820,10656,32202,24515,-22248,5437,-27800,-711,-18648,-28607,27605,-28902,19273,-6590,18735,-29315,28063,-29428,-1540,1962,23003,29530,-23859,-20989,6659,-17913,-16556,11486,-25445,-12762,-494,12964,-2659,26475,3851,-24169,-31581,15913,-25265,-5609,-4379,32557,12964,24707,-16172,13436,-5655,-9496,4719,-14216,-22562,2635,10953,10914,-19879,-28695,-19303,-11843,28269,-17256,-3103,11492,-22762,15692,21869,-30794,-14634,19557,-25182,-31615,-4174,1700,-19004,22370,-17550,12730,-3394,23618,-27256,-29859,-5222,-1487,29232,568,-13185,-24241,-2494,-28945,23449,-15658,3181,-17149,143,23388,17522,-6604,8652,-4226,27825,-16188,19621,-475,-28004,30193,-32609,8993,5075,7140,1890,6887,19392,-14696,-2565,-16340,15240,9243,-25790,21794,-11778,5176,-13167,14263,7256,-18755,9643,-24848,-29148,-27739,-9130,23971,-15533,-9061,3916,-480,-16040,18874,15472,-4133,31975,28355,26495,13961,-21416,-647,-21900,-27279,18150,-30652,11633,-24330,10907,-7180,-12495,-15254,-11057,-28847,-11998,-27694,-16411,-31493,-3474,26156,24936,10051,-21051,-14185,28631,-27005,-20094,-24296,2116,22290,22474,28260,12536,-28179,-27256,5565,-1611,30614,17866,5512,25789,3052,16813,18585,-27644,20798,16831,-15928,-5098,3355,1849,-18611,23778,5846,-26892,23650,-16931,5829,-17595,-21855,-2345,13280,12004,-4986,-16404,-5824,15361,-6496,6004,-13923,-7491,-6036,-5075,63,27127,-862,-6868,32096,1258,11303,4608,9015,-26616,28729,-22468,6893,-2003,-12673,-28583,11415,18915,25186,-5661,12918,-29173,-4615,-30514,29864,-29798,6716,14951,-32030,-10132,29600,14975,28606,-9257,27179,10830,-8304,-11820,503,-24922,13130,24533,8932,28968,-18387,-13374,1138,-25897,3105,-22475,-24594,-10862,14600,16298,-5665,-28157,-10703,22375,26964,-28747,-12719,-22237,-28206,19640,18420,29520,-6803,7192,28347,-31437,29364,-8134,17341,6170,-31738,-20382,-23022,19646,1180,20057,-25443,29488,24770,12207,-18553,21031,-8387,13396,-21612,-136,-4279,10435,-11017,-32322,-7785,17635,-7872,12800,-10510,-9897,-25693,-24482,-28138,13239,-8914,-3846,-10452,-25332,-9075,-26361,-12746,28622,29745,24942,16983,-17572,-14176,-9794,22690,20984,-30313,1998,7902,22930,14519,12657,-21304,8141,17290,-16304,-16488,27526,25710,7773,-32002,19211,-11703,-30242,25902,26110,-9710,-14378,-11924,31934,20985,107,-5033,-6182,-14981,11405,14710,4895,-2402,-17528,-14259,4996,-27566,7441,-17316,16981,-5593,-12851,-4709,-28997,-25815,21121,16050,-29988,-7136,-24780,-31671,-16062,-15134,-12229,-24706,19542,-17787,22557,-16920,17009,30664,-15512,27551,-24531,27485,25512,-8239,-17471,-7679,26615,-3663,-22100,7819,19609,25431,-5768,-967,-31980,-32568,-29742,8425,15425,7476,26847,-28009,-31944,-5544,-3784,10905,-12100,31881,-28366,2998,-2731,13211,-22932,-3684,-4767,18421,8991,20373,-32070,2411,3383,1280,-19213,-31680,-20847,16648,-8382,-31139,-25063,32505,-22028,25596,11090,27772,27978,17118,-28328,13649,23808,16462,28505,-31209,24164,-3920,1012,-18336,-24550,-5075,-24017,8464,-30394,-16487,-13894,5652,29910,-10502,-7885,-31080,24454,-17613,23666,11197,-13915,21439,13433,21108,24415,18907,3707,31304,7418,-27670,27954,-29995,-20219,7764,-1248,7852,-15167,-19010,16641,-3555,249,28884,-20407,-32455,-3603,12495,11362,-10998,-21871,-5393,1122,1696,-4679,-2104,23833,-28246,-4360,281,28703,-27263,3550,-19293,-23589,-14882,-18208,31319,26292,24233,14075,1518,-21991,-14645,-15757,-30208,12861,-31060,12359,6004,21488,14865,-4281,963,-13786,-31748,13313,-10291,-11289,-27458,24246,-15192,-5758,2363,-17402,-4470,2598,-16038,3120,5990,23323,-11490,15642,18742,-11532,24661,-5471,-30792,12348,-13316,-6633,31568,11121,-8092,20407,28475,-10264,-762,-10145,25127,28307,21134,22695,8312,3673,12275,25522,18463,7364,-28136,-2321,5302,3823,-30488,-26706,6209,-5174,23537,14344,31574,-27429,-16181,31230,-1825,21127,-27817,21201,10688,-12257,30351,13684,-29322,5864,-32361,-24911,-17679,-22047,21857,-15090,-27523,14781,-4533,-4301,-717,-10579,-2230,-27670,-3396,29179,-17572,-22604,15441,-1344,-17387,-12753,22550,26293,-32165,530,-6455,13113,-30993,28826,-11298,-11908,19454,-18428,-29222,19573,30410,8366,-12416,-6697,-10429,31481,12025,-11981,-27232,-29967,-1357,-18882,9272,-31165,27373,10150,18990,6092,24774,6432,31449,4319,-12709,2706,-23561,-8549,-22384,-28926,30981,-4845,-3316,-1416,9123,-18153,-30505,-30617,-5920,32170,-18915,6436,-30767,-14803,-27820,-30637,5337,-6681,22953,-18834,-20089,-17036,13146,-19372,-19849,-19020,-8575,-16700,10369,-30006,9825,-5627,-6903,-27420,-10615,10300,22132,-25396,-13978,-29851,-31512,-9583,32632,29518,-23584,-17312,8371,-16623,-294,487,24660,25849,17044,-17184,9877,-2339,-23544,17302,-20643,13395,-18632,-23891,13361,-1346,-13696,-23073,16413,-7313,28006,-17256,20771,-19696,-30775,-8928,27488,-14435,-12227,26261,-27751,11886,6520,19492,-24000,-23481,-31332,-10451,2589,23435,7303,-30417,31620,10195,23018,-8451,32191,-4974,-29992,8434,-27464,-27277,-19396,486,-18913,12363,6264,27694,-17770,-7222,29489,-28277,-10570,-16564,-28198,19702,28199,914,8663,14296,7551,15826,20187,16313,-30651,490,-28128,5159,14423,10341,3776,-17524,24924,-18740,-17291,-9206,-29391,-27438,-14018,18068,-6381,-961,18477,14846,27649,-5559,9134,-2297,-1606,-5792,14655,-18191,10512,6410,8074,21305,7433,-11303,24220,-4402,-31847,-32408,-2032,1113,12356,-25764,28220,13859,17281,-14095,5634,-29009,27378,-10559,13004,-757,-24519,14020,6435,-19141,30456,24227,-16967,-24935,-9803,4728,29860,-5936,1893,14973,-25311,-21926,6915,5509,9447,-16834,-5642,-3282,-12809,8496,18081,5179,30904,14264,2862,-14646,21454,15762,-25725,-28075,-27105,-17394,21234,21230,22486,9101,20843,-29429,-9297,27617,321,3575,-14056,-29772,5916,-20827,29749,17504,-15825,-11331,-31604,12135,-2695,-12909,32179,-5673,25380,-24328,26476,-14025,9030,29041,-2925,11472,-6586,15335,-8765,-16213,-15074,-20688,13977,-16464,-21428,31888,-23179,-20874,3344,18736,4601,14009,23122,26221,2592,-12773,-26675,-17887,-6776,695,18180,5493,-28285,6356,-2315,-19090,-20784,14077,20437,13216,-23193,17028,3869,-17728,13660,-29957,-6679,-13669,25183,26693,2493,15270,14564,-21775,-21110,25636,16628,-32682,-19308,-2649,-3084,21014,22714,13098,12816,31583,-1990,-12937,24742,17948,-5625,-5853,-25618,-4151,-31507},
  {1403,3847,-30916,26592,-14991,-416,1652,8570,8203,-16589,9435,4459,-25379,-19837,24106,-12426,-29854,24001,17743,-15592,-32387,-12199,4481,-3137,-25563,-2958,19380,-20639,20075,2985,-1556,-30797,-9801,16879,-26740,-21111,-23753,3614,-23648,-15535,11192,13253,11381,8610,22083,-3008,-22929,10861,31714,12246,28483,-9642,6498,-7501,-18001,-7787,-5684,31311,10680,762,-29936,24958,22952,-25474,20145,-17885,23657,-26883,8183,20534,-29800,32701,3599,-9201,22172,-20578,-3422,1552,-2493,-8108,4581,28903,-16825,26012,-25856,-7012,15436,24969,-19831,12473,16651,31818,14878,8824,-13681,27302,16984,6315,21077,14192,19361,-6360,-2130,25761,2289,8567,-793,-27232,24970,-27727,16644,-3192,32340,-11565,1844,-5639,25149,-28622,-32645,-4003,-1265,-1673,12411,-32659,9197,-9382,-5707,-10163,27445,-22159,-697,-27694,-15534,26824,21102,-10487,-10379,32091,13055,-10891,13541,-17285,-604,-6944,-5599,-10321,-22064,9424,-23746,1766,25568,-19804,12303,-21469,19960,-27310,-24771,-22082,-14761,-14059,-31695,10777,-14651,26548,-19806,16117,3067,-30106,-511,6601,17714,2081,-30610,-18604,24810,-21717,-23167,-832,-10819,-9140,10374,-396,-19447,-14437,17795,25176,-16990,-24683,27491,-27415,15804,-18952,29381,-23564,1829,32398,12245,-18333,30243,-4460,-15741,352,-25727,-23986,10922,12374,-5037,22811,-15711,-18617,29591,24913,-31707,-32710,3411,25438,-3703,11274,-11667,-9116,-22953,-12013,21800,-21225,21812,-29793,-5969,-11013,-28877,-30789,-432,-15526,26652,-93,6815,7801,22705,-16125,27707,77,-16044,14581,14124,7791,14539,7383,11316,-22970,1708,14182,-31772,6809,31380,-22284,9854,5249,-31506,-11485,-19912,5317,20661,16956,-6228,-7052,-795,-23338,-14555,2109,28431,-9120,4217,-17145,26082,-16827,28742,14302,23950,8550,7904,-3796,25744,22431,6816,-14285,-26344,-27712,29591,8743,4211,31837,23349,28418,-514,-18435,-17468,-11193,26601,-3539,18616,-14787,22965,15590,-24303,15777,19112,3310,22642,-4642,6329,-31872,-31451,29782,30100,-12818,3819,29356,-29101,29634,-1386,-29007,-17002,31970,29157,-26507,-5623,-24007,27160,-29544,7540,-17167,-27524,7447,28557,-24559,5254,30017,9041,13710,-24784,21143,-24441,-8908,-29146,-29308,30656,-10911,16992,-15730,-29922,-20726,-23679,30573,15586,8375,28869,-31327,11606,28563,27408,2477,-28100,-1024,-26797,1815,32339,-10188,-23081,-29959,26792,8595,-5920,-26459,22577,4167,-11671,5819,-22569,-18698,-22642,-914,-18408,24736,-25536,-365,1476,-22038,-13547,-4919,-26843,810,-17229,-14507,23132,-9104,-2468,-20054,4875,22700,11049,-11695,21175,6758,-15843,20773,-19259,-23074,-1071,-18267,271,19730,31122,8581,-13137,1616,32148,-9524,15236,-18757,2681,-15688,-5293,-24529,4386,20774,-8549,25520,9169,-4789,23489,6503,12923,3435,29959,-26870,-20407,40,12524,-7869,-16415,-2476,11201,-28982,-27089,26383,21161,15741,-12606,-11582,-11807,31744,4291,-4606,-12664,22755,30964,24431,27622,-13340,7567,-6092,-2490,1023,-18437,-5073,-11199,-29298,-5660,-24281,14930,-2970,-16431,-12489,16335,-10147,4085,23898,11130,32748,-22066,21809,-22054,18173,-18974,-24248,15616,26756,-15356,-14886,878,-18735,-15127,-25595,27462,24114,6423,-8622,23248,-28532,-26557,-19815,-13488,-16102,-10130,-10018,-15012,13697,32043,10709,1016,9739,-11960,-12553,25235,-1981,29427,30731,-1445,30840,8314,26021,10349,-15016,6307,-4012,17057,-5067,-7110,-16540,8609,-10528,-4015,-19789,13732,-9277,24943,2330,6061,30328,32729,11018,2103,-13176,-10423,16346,22195,1858,9090,-23841,-23603,-6912,-16045,1726,5128,3891,17580,21897,-15447,28989,16235,2245,-2162,-6216,13982,-9222,-32534,-14932,-27073,20915,-16436,25520,-31249,-8071,5558,9814,-24130,5678,-27526,-7784,-2122,10667,-10690,1239,27555,-18736,8921,9000,-14755,-30966,-28442,11115,-29511,-17923,-3404,-10129,-31170,-18518,115,17127,8454,24949,17778,25602,30421,-29541,-5992,-10198,11779,-8049,-14789,-8205,-9203,-27750,-15607,-23582,24498,29116,-32715,-10861,-12662,8700,6145,10521,-12214,-25434,-16647,7830,-13461,-26233,15515,-30183,10132,-27178,22976,-14650,10230,-23735,23684,16803,13979,16576,6146,26351,-30425,-30073,-20455,-30354,17257,12354,32585,-17800,-21815,8954,31357,20317,17076,-14700,-5574,9151,-27003,2762,7094,23241,31740,-26556,-11316,9732,25721,13394,20039,-17441,-14935,21153,7932,-17338,15282,-18168,22009,15445,9587,-14224,-25652,30863,-21042,-28085,-12395,-29646,-4481,-2319,20164,-18338,11943,-22275,28060,-2480,5715,5758,23420,26315,-673,12300,-23779,20985,-19830,28685,-25647,18253,-21543,-27103,-3871,11565,-14486,-26118,-32459,-24333,-26353,23993,16794,-23518,19151,12747,13615,-29183,-13884,-5038,-16810,30259,2731,3202,-1875,-19830,24014,-32189,-16175,-13158,-6447,26489,11889,-20868,30,-19295,-22841,-17345,21109,-12856,5859,11876,-23519,-14616,-27841,-6152,-3028,-14994,20386,-5861,29232,31582,14789,29523,28510,-21735,20283,-13237,18705,30605,-31664,-188,27440,-19943,17171,-4478,-12858,24056,-11136,12181,10240,12923,13201,-28222,-24796,30500,10797,20277,-8681,-9452,24551,4294,25541,-22978,-12383,17736,-777,28212,24917,22082,-22177,-27423,27205,31408,3657,-30277,-9124,28054,9967,15284,-7096,-9681,-22180,-6360,-25142,26163,-3955,-18457,-17321,27578,-10283,19097,21152,-637,-15621,5348,12104,11202,-9774,21982,5600,-27614,23616,729,-20714,-6476,-11429,12856,323,4820,-16499,-23545,-1850,-25590,-25889,24491,-31890,7930,9477,1649,-13858,5276,-24049,-6086,14059,-24849,-30047,21292,24155,-5218,-27195,30423,32248,-27429,21313,14150,-25130,-31122,31485,11573,-12047,-29802,28708,30400,-2472,-18259,24200,-13257,-27577,17048,18740,-3006,10086,-32159,4602,5754,-25865,491,-10760,7664,6239,-15571,12042,29535,14273,25628,3653,-26567,-13637,7511,16644,8348,4833,179,13268,1996,7245,-20099,-22148,24556,-18276,-26769,14195,26437,-6141,20048,-1540,24862,10504,7956,-5190,-6751,16469,29735,31654,26229,-6544,24304,-30875,31270,-24051,22426,-15389,3703,-3528,2869,25014,-30278,1241,13942,-21752,12676,-26462,-4518,-26996,3782,-10902,5739,23751,-32628,-628,26722,-14258,27030,-28001,-6365,-5910,-6339,-5748,22813,4900,-29025,-11062,29019,-7423,3251,15044,13329,24709,23609,-32101,28346,-3878,4989,25113,-32595,-7631,7940,-4022,44,21355,-3528,23581,3690,-9545,-29758,-10810,29502,187,-28609,-832,32476,25119,18680,-13661,-10550,2452,-25554,-1696,13233,30480,-25366,-32278,-27546,-9621,-23959,-20523,-22188,17164,17125,19503,22063,14041,2547,8581,10023,203,25226,-30572,-11271,7835,-7206,-29100,20812,-5926,22825,-12798,-10722,-17674,-7873,-20406,592,-28798,-30239,-16172,9965,8434,17994,10441,-13072,19169,19219,25141,10901,-14626,-17173,-5965,19063,4576,23200,-30537,24546,19391,-8253,-2228,-11493,3058,-12432,-5342,-18862,-14591,-13529,11905,2196,-15060,21497,-15724,23914,6479,-22545,10449,27687,-12818,-496,6075,-25983,-2951,12586,-13450,31878,-3813,1444,19011,-22719,26342,-22359,6918,32381,21206,15048,16980,-3545,-4103,-23339,-21642,-27876,-25559,-12852,13946,8829,-27227,15166,-9701,29075,22451,-9390,-16016,12845,27042,-6712,-6700,-10385,-14798,-1608,16672,-25535,26655,-24431,970,-4988,-29043,1346,8906,20284,20307,-13138,21186,4573,30741,-10303,-25821,-14274,11003,-2404,7951,-18947,31969,10615,-17150,8668,-6517,-430,-21736,22950,-9066,-24600,-15812,6576,-27387,26862,-20362,20001,29782,-15190,-23110,-30706,-17556,20581,-29692,4373,-5588,-427,29843,-20057,-4442,-6117,-13461,791,15041,-8817,-27498,13148,-11181,28292,-25155,-4317,-9338,-32128,-9822,-11717,6093,19391,25395,5004,14635,-5872,-3431,-24047,24050,17896,-32151,2911,-25753,18470,3091,-13710,14847,1771,-14918,31757,-18585,-7157,21391,26936,-3616,-20114,-3031,-23655,-3194,-17157,-5970,803,14455,-17171,-8391,-31313,-922,14157,29354,16323,-17453,7666,-7690,4326,5848,-29843,-21124,-21228,-23470,-1363,19264,544,19341,3922,-9903,-14523,-8390,17977,-26846,-21954,12487,-22704,12082,-26077,-31510,14483,27456,-22811,-8582,27751,1454,16075,-8957,-10640,26301,-4394,-2817,11828,18350,-24293,22251,-21922,10429,-11853,-4046,-32515,-2578,11422,-29526,24854,-23529,29815,-1332,12707,22423,-32027,-541,13782,-4769,10045,5033,-16741,-2873},
  {-11499,1080,-2941,9271,-12321,-16941,-16961,-30080,9650,-9112,20585,5965,-16139,-18768,-1701,12768,-8404,23405,-9075,-6596,-18411,21456,14942,-10816,-1604,-935,-15029,13568,25680,2328,5546,22670,-20775,29162,-31034,11954,10148,25438,-21669,3299,-24957,-4297,-6372,-20122,31683,10378,-20070,6214,30323,12192,4735,16337,654,-15542,17716,-19025,3529,-32371,9592,2899,1241,-32466,-27993,-11529,-6021,29497,20792,14913,23528,10783,26574,-22556,-11974,15079,-19651,-22838,-7553,28904,8797,-31776,-21822,-4250,-24874,3542,-14719,20297,26447,23680,19475,-6804,-9507,19925,26103,14911,23212,26693,-28406,7435,-18760,30075,-7234,17709,-460,6215,-2487,-31454,-14657,3978,23442,-30511,-26444,1223,19103,-9128,2681,16483,23344,-26193,20930,26493,-15890,-32617,-2973,28109,14950,-12053,-2578,-12022,-23308,15516,32080,-31581,-1144,-52,529,-26385,-21609,-30845,1486,22248,-14141,16084,-20295,-14393,7715,2009,-24336,-14314,9460,613,-2580,-25367,11620,-32657,-27919,29622,-8530,9337,32284,-11906,-5771,5449,-9548,8481,5063,2519,-31349,25120,-7719,-7387,-24703,-21948,21695,20286,-15484,-16546,-22154,-13396,28812,6075,29954,-31974,-23851,18828,12467,3376,-32688,-32146,-29202,-15840,28563,13129,6769,-15353,3947,31603,-177,-12113,-3890,-17938,-28728,20009,30720,9843,-32188,-10382,-9828,-7095,3220,30870,-23734,-8641,-11218,23552,10160,31273,-9732,12328,-10469,-23644,144,25216,-17683,-1165,-30806,10741,3774,-24445,-25908,-4971,31399,10005,10264,26957,17397,-3711,-30094,-25501,-29614,21820,31527,20053,11173,-8430,-43,-24988,8141,24192,-31825,-16778,12407,-18501,-6837,-23625,14908,13784,9238,-613,12791,17800,28255,16988,-5798,-20706,12774,-7430,-27846,25517,9351,7093,12951,-25430,-19301,-21675,-21412,-1771,-20229,-14227,-15843,-1583,-2631,-5054,-24539,13990,910,2812,28442,-19487,17868,8913,25392,12076,30371,-20332,-26046,8352,13991,929,-7014,27661,16148,14189,17186,18662,-30066,17065,-23829,22602,10706,-30948,10337,24911,-19112,31557,-20785,-24085,6104,5285,2335,9794,4928,8792,6103,25222,21193,-28950,3839,9024,-9272,19673,29324,-27631,-3730,-20437,-24033,15109,20822,17103,-21498,-18009,28276,-2877,-31548,12168,6105,-30043,-16743,21533,20584,5146,13222,-8430,31463,-31365,-7963,11272,-24736,-7457,-25321,29317,4185,-1378,-29489,-1655,2216,12673,-4836,-17507,25436,-29674,-8727,31680,26162,16102,-24161,26570,28528,-21407,-21886,-17222,19632,-16487,11763,-14138,19113,8660,-27243,-4156,32407,22304,-21410,-4147,30924,9204,21998,-5849,-28849,25667,29982,4490,2663,-19544,20133,-8832,-31550,-29495,-27673,-5380,-9816,13254,-17499,28420,-10959,6601,-16315,-27603,22315,-14078,4279,8284,-20454,17735,-20756,-19149,25436,-13262,-24002,30533,-28422,5102,-23848,-1727,-16067,15229,-3317,-24157,23120,23153,-29310,-22407,27501,32761,7945,12661,-14078,26388,-14504,-31157,25422,-9983,-5786,-13052,-30934,31459,23045,-17447,6550,-27228,-9083,-31502,-26233,-9020,27310,-25713,-18238,-261,31365,-14479,-9306,-4148,15209,30600,-25458,16429,-23498,-30922,8785,-19196,-10769,7089,-17206,18141,16988,6301,-23982,-25027,-20164,-18177,12036,3905,14418,-11819,-29135,-16558,-31177,-22861,5892,19220,-5242,-30859,-1819,-3866,13204,-8395,24954,-6302,-14252,21140,12026,-20132,-14141,21820,-20628,32154,32462,21787,28641,-26486,-10157,-19278,27174,2016,-28091,29289,-19303,29113,11417,25939,31175,-19878,28482,664,-19812,21770,17929,31887,-4878,21531,265,-23762,7659,22585,-3620,-27067,19427,-16489,-25523,21163,-28987,-28898,13468,-19096,32318,-8304,414,-107,-26399,22513,18362,14388,-20459,-9030,-6890,19689,-5919,-10332,-4886,5752,18765,-16926,654,-12258,-18880,20168,9922,-12521,-8062,-32624,-28002,32644,-28749,22785,24173,-15290,-10457,-32220,-10419,-30432,29968,-29017,26287,-21238,24014,-27416,-31867,3096,-27659,-21782,31914,-4201,24592,-14999,6231,-30147,16199,-29160,-28492,-31645,9497,12836,9983,-28582,-10411,-18226,11714,12065,26889,-12998,-25726,-649,-21160,28482,-17391,27988,6158,9221,-11745,-12555,14877,-20069,12017,19792,5550,5307,27944,12192,-298,25526,2144,-25422,-17179,-24108,-28650,7900,12734,-3763,21856,-20335,-24178,-27007,27263,29849,22181,-20103,21178,2551,-2252,-2832,27954,18660,-32416,-3068,-28050,-5004,-5776,-25820,2786,2752,-30631,-129,27897,-23387,-23791,10407,-24320,6414,22082,-16966,-26421,5914,-11633,26589,6614,-14833,10383,2934,-5754,-19609,12291,-5825,-1513,-12854,26690,10690,-29250,16981,31398,17365,10400,6237,31827,-6879,-11155,-9471,14085,6775,-27547,20443,-16921,-7916,15858,-30391,4557,-31118,-4007,-9975,17212,24547,19823,19126,-431,2898,-18388,25857,13847,14266,7069,-19413,7596,-21411,-31461,25297,-9406,20341,-3699,-20309,22432,13627,-5510,1007,-28021,18419,3825,-22455,11296,8160,-15395,6525,4849,-32600,-23516,-30880,-5870,-7034,-16246,-14568,-25057,29734,10001,-18126,16476,30895,4867,-15669,-9259,-24212,17807,-25119,11694,-19059,18553,-11606,23085,16958,9719,15462,-6309,-28292,-15443,-26625,25698,28634,-16758,-4725,18813,9339,636,3195,11582,-19542,32641,25465,-8354,21799,5788,28104,-11573,-30092,-25061,22069,-19478,17477,-16815,10357,14834,29776,31277,10089,-26929,7059,24325,3695,-22885,-2874,18087,-8814,25256,-30575,-19991,8109,7501,25702,25508,-5799,28135,-5345,-21220,2768,-11908,30553,18299,4249,17406,8247,3034,4498,23448,1736,14095,-12961,8199,-9735,-22597,-6820,1705,-22560,21967,-10089,30212,16761,21709,-24785,-18351,25850,28487,31971,17768,19467,-15112,-15684,-20855,18588,17597,25304,-30962,-5621,19553,-32022,2889,26989,-6943,4679,-23480,6006,17224,4116,-10018,25378,-1647,13419,-3494,-27829,-8261,9643,668,29304,-14082,29,-22663,-30127,3342,-30883,-6844,-21324,27170,-8659,-26158,-1525,26806,11503,27692,-18685,-9360,24643,9729,25172,32315,-5131,-8279,15795,-19527,1881,-24345,30180,2611,-25656,-16745,-5415,-22761,-23657,-32275,-8446,-4409,-10433,26621,26108,-6572,-14801,-28097,31982,17565,-14621,-14775,11650,-25772,1942,-14921,-2886,-19220,22205,25243,-5999,-31958,20283,-5930,11757,2466,-26297,-21383,-20213,12144,23317,25219,-23769,32544,-7069,-27004,32478,14997,-26462,-15041,13638,11218,25748,-23037,-9209,-10772,30824,-28529,16156,-13640,-30987,28399,-18833,-27536,26993,29447,-31739,15096,25156,-8042,4665,-11402,11115,12693,3200,-28197,-1199,-30934,-23897,32755,-31404,4023,-31698,-21411,6299,4328,18986,12205,-21631,-31475,-14319,15336,16791,-28176,9857,-30044,6472,18866,30523,28046,-23160,31294,-1283,31286,-10085,-20114,-22161,-22441,-1703,31959,14002,-12210,30350,611,-32510,21205,-18468,-18070,15692,-2627,-650,-30659,24787,3643,10410,-7842,22021,14700,-10061,6541,27111,23989,5454,-11551,-6306,11550,5787,-8145,28081,-17745,20636,-25561,26647,-10933,-26144,3480,6213,-13512,5534,166,17118,1718,-5041,29863,-23541,9936,2515,9905,-21717,-29165,-5593,-5762,-14665,2401,-21265,640,6296,-17437,24587,29520,614,24325,-8655,21316,11623,-17922,18703,13992,-25745,30440,-13217,26533,23497,-20952,6794,19963,24302,-18977,13899,6465,-22342,-18629,-9491,-19654,-30553,20270,-3489,-28263,-17167,7374,29034,-24321,-17940,-26059,10733,-5951,-1719,8661,-25846,-27148,20148,-19646,1616,9479,-30953,19212,26844,14357,-24346,-22233,5945,32727,28241,-5039,9983,-1148,-4546,15665,27707,-4374,-16888,23671,-29684,9616,13530,-11528,18727,-5450,-23203,-23991,18808,20914,2703,-25730,-19225,25443,-22198,10641,7110,32570,3504,9143,-26428,27851,-19311,856,-18947,-30822,28328,-1916,-16813,-9646,32630,5937,16842,-21387,4141,-32051,20955,7318,9992,2940,25557,-12657,-23626,6056,-1055,-12081,18869,16790,-31193,27558,24267,18481,-29719,-16165,30084,-21726,-21257,12346,-11522,-20393,-4925,21302,2356,28985,29435,-14157,-12819,-864,4710,26326,-11677,6257,9545,-569,18468,31855,29344,15661,-20011,19572,12671,20940,-14551,-3910,-10573,11636,23774,-17722,-675,-21683,-13326,10963,11690,-29589,23795,-32507,-25710,-46,28203,9516,20547,16893,3759,10155,-20001,-25074,-9033,-10135,2665,-27462,17325,29453,25129,-13899,-21066,-17407,29976,-11200,27169,9648,-25861,-3144,-30075,-189,14516,29260,-3925,14586,-10396,5256,8703,10548,14371,-10274},
  {17677,-4326,29747,-14287,-14640,23667,-21278,18564,29730,12468,-3520,21816,-16290,-19757,-14817,-6025,-29246,-20108,-23868,15546,-15598,-916,19783,8194,-1063,9953,3269,-7235,-3822,29241,-3435,-30608,-16378,-24505,25862,-12629,-6899,30172,-4782,-26060,-167,-24090,10723,31053,-29762,-25235,-22835,27852,-27535,1143,22448,26408,12435,-29736,3996,-12080,-5044,5795,25238,-9123,15461,-16968,-24574,30153,1843,13786,-3191,-11767,-13440,-16840,16382,21238,14176,-3831,-864,-1892,3758,-17312,-22085,-20922,-25579,-23852,20532,17510,-743,-3022,-13165,-28584,-16738,-5122,-1751,4697,27813,-31934,26404,28848,7332,-13559,-10549,5395,19285,16843,23545,219,-7605,24888,-7091,8783,-24681,9321,7456,28316,29615,-18510,-15385,24333,3688,26200,-22552,15926,3764,30413,3590,-2661,12937,21506,-5076,15088,10563,-28167,-25269,23332,7603,13581,26164,-29287,13354,2620,5908,-15985,5993,-1633,7185,-10363,-31757,-23244,10647,10831,-14157,9803,-25392,-15564,-5869,-27940,54,-27501,27821,-32451,15590,13774,13147,18387,12119,-28617,1532,-18341,-15902,5877,-11067,3012,11197,-24668,-4401,18920,-20921,-20210,-25030,16208,12786,-14698,32704,-23026,-25110,4816,-30719,7374,-15509,-4184,2189,17272,-14888,-76,-20814,6608,-9470,1881,-8843,7532,-12254,-6080,3976,13899,-24351,-31826,-10473,-8398,-8111,-16367,22190,6289,-29906,2465,8805,28876,25210,5896,-30275,14395,-15427,-19418,-27410,28299,-22569,31414,-19682,10784,-32733,19625,-32636,24281,-4074,15731,14979,8048,-25326,-1735,-10641,-2480,8442,5835,29798,19345,32729,29854,-19366,-23649,32621,-26620,30783,9265,19715,-11358,1671,-24123,-11597,-28386,29348,-15235,-5728,-1394,-15952,-27844,11636,-20801,-3263,-7613,-22890,17895,-3890,9057,-2672,13530,21973,-21427,13693,1182,7712,-10288,-30908,-18331,-11818,12665,-10965,-24015,129,-20301,20908,21864,-13998,27429,24007,20568,24397,-9746,-17856,-7061,-27299,8818,9715,-16575,-14498,4107,27848,-12954,-3642,27030,-17327,-28523,5803,-10935,-15754,-9146,21279,26140,23232,22821,11226,-19791,-22219,-10000,-17955,25384,19620,-4750,-19094,14816,19387,20761,-16045,11398,-3124,-13986,-6489,13096,5841,-28895,-14089,-13357,24381,29976,-2955,-21439,25432,22565,-22380,16953,-8675,-12878,-8871,-13039,12535,9175,13054,4052,-9065,14497,-13955,-5559,-31223,-18391,31722,19575,-20697,-30596,-4100,32470,21123,-2235,-2970,29361,-14889,14327,-18381,-19558,-13881,8033,-22385,-18365,-1959,-26493,22079,20107,-946,-11860,-24794,17889,32346,19620,9954,16063,-7973,-14769,-30085,27022,-21148,30360,-25448,-2529,9140,-20475,22428,32347,30882,32465,31412,-1669,-16319,-1842,26142,8638,9587,28835,-502,17383,-11562,-2131,10953,-6702,-2595,-18809,31026,24931,18349,15660,9175,26199,-5465,-23,-13788,-11417,-11448,13448,19763,12658,2037,-8936,4259,5127,-24704,12665,18961,-1835,4577,11497,1243,5643,-12584,-17702,-30882,14184,-4565,3945,7512,-4339,27756,5799,-16354,-29548,9503,3613,-29228,-12161,-3123,-15016,-29163,-15913,27243,379,30295,1788,31598,-17153,-4052,7362,9313,-22192,17062,-28576,6488,-19551,782,-21527,19377,8330,-6794,3403,-8721,-15964,3599,6826,20087,-22080,-4011,5899,26134,8921,2682,-17969,30328,18119,-22876,-27187,8935,4803,11790,6758,-6826,-15795,-7011,-10743,-10710,-19783,24627,-21241,11512,-13830,-26283,-10727,5401,-25925,-9375,5437,-4753,24700,-27426,-6452,14957,-18901,-11246,30345,14876,21396,-16377,25737,-24924,-6928,-27638,17638,-20748,-24233,-14366,30382,1843,30101,-9387,21800,-21560,2414,7196,15715,-4996,-31703,-106,-15014,-9548,-19265,16001,32682,14904,-31461,2933,11666,-30608,23575,27102,-25433,-4470,29231,24388,-11762,-31128,20611,-10268,12054,32118,-32274,13062,27614,-752,-19686,786,-30200,-22628,14658,23931,5203,-3209,-5746,18779,30003,10898,-15961,-22238,23191,10225,-17090,27409,-1313,-22078,-1658,-16728,4932,32402,-19833,17316,10950,32646,21761,31178,-17757,4059,-23711,-15148,23842,-4860,-21666,-17785,-13340,18361,-16475,28882,-18304,453,-11353,-19846,13482,-7728,2107,10098,966,-14022,24296,587,-4327,31482,30121,-21935,-6786,14475,-108,-23112,31893,4522,3181,17663,588,-7891,3163,20145,-18460,-11558,27083,-12688,-201,-6703,-3082,26836,9718,-14375,-6903,-3670,-19329,-19955,1465,29667,29197,4800,29208,9935,-18187,-28219,-15200,15588,22596,25627,19651,4489,-28580,7197,-31913,8523,2252,11217,-29093,12297,19879,10022,-29851,14832,-28841,-19410,5704,-30619,-5836,-31674,-17477,25085,-31303,-15412,453,18215,-17379,41,-5513,-32260,13594,-22699,-21205,26918,-30476,14659,2905,-12472,19741,-18515,-18993,-14972,27030,-7319,26380,1169,-1901,22488,-27651,18775,-15260,-23330,-24420,-10709,-25408,-22751,11727,-26669,30789,-2344,3699,23319,-25271,9613,-16452,4269,-13242,-20514,-20038,32452,-8519,-9902,-15666,29956,23179,22676,13576,13977,-6799,16338,-7386,-13547,24268,30531,18784,827,-335,-338,-14205,-23241,11685,-9896,-11866,-23917,-695,5892,12237,-24616,-3053,-14741,18848,-1270,4077,-3801,-16770,-12726,32009,-11689,-31153,1153,-11778,-15705,10946,25009,26462,-512,-4424,-9444,-12471,27589,-14839,2314,-7295,-16184,8387,8124,5915,-16873,-29524,-11973,16218,20004,11901,-14765,-752,-29062,16811,15007,-29408,-6360,-21991,-4179,7023,14486,26064,1075,-12819,-26108,-7164,24815,-18222,-16173,-17376,3013,-29040,-7872,-23115,25061,-8050,-22793,-18576,-6667,16954,1088,4995,4847,-17080,-2500,-11608,7763,-10783,-17203,-19832,20717,14354,-11163,29570,-30677,-23249,26312,-25210,10776,4438,26490,-19739,-16009,415,13396,-15144,27701,6938,10837,958,-12331,209,-22967,14591,31855,-8897,2224,-25338,-24136,17536,-24869,-31206,-5024,-26857,27390,19540,22181,27200,-19850,-24738,23199,-32109,14677,-30470,19072,30150,-18497,25621,-3982,28218,614,-21681,-4331,-14908,-31829,-25233,-10399,8592,13090,-10961,19138,17612,29009,2828,-4832,-7241,-24027,-7678,7176,-5359,735,-25793,-17692,-26544,-13264,27462,-29671,20938,-24120,-17988,14423,-14927,-6720,18925,-26442,-25693,3939,17484,28212,-31279,-27974,23337,-16686,-11196,32276,21459,-29300,8796,-29586,-18671,26436,-31537,11028,6612,15337,774,-8502,8968,11134,24008,2106,-239,-23371,-6778,4489,-11816,24634,-8707,13994,-7987,-30327,-14736,-7416,-3150,2120,-8088,9139,21193,23350,127,2745,-17873,24444,-18888,-3940,-31669,10128,16814,-3935,-1481,4532,31049,25457,4258,-14634,13809,20247,29088,-9777,-1773,22088,14576,-23796,7944,28325,-25713,7151,-2723,-26713,-13970,24547,11251,-6770,22984,29080,-528,-21724,3442,27491,-2397,-8607,9157,-26037,30370,-20664,-32758,11349,30108,-18686,13102,-17428,-13344,-21925,-19044,22596,-25046,28395,17874,20668,24790,-18164,4536,11701,2510,-20887,25301,-31782,-29024,21078,18000,4754,-11762,19015,-7964,-11582,-28069,-32519,-7062,-14496,29193,24602,31567,15785,31698,8945,12745,21313,27301,14152,-18721,-23674,-29906,-28405,32529,-12221,-23720,12312,20820,-27318,-15772,-29700,7135,-16236,-6032,-28430,-19852,29642,20820,-28206,8773,7552,26019,32712,1348,-17897,-20733,17386,-23789,-22280,-9157,-8625,-10157,-992,-9489,-27606,4096,-8170,-16395,-31958,28815,26460,32291,31056,13787,11487,15808,28200,995,22834,5353,-17585,5279,-17434,-21746,-7316,8197,7737,11783,-8693,-18238,25341,-5153,17458,17224,23889,-21215,-30714,-20755,-32131,7310,-118,-16439,-29514,-23113,4683,-28391,-8218,-20793,-25014,-8273,10112,272,31861,-11649,29995,-31593,-5237,-7764,-30403,28885,31894,13588,15944,-9797,-2533,32364,15836,-24296,30800,-29097,-2271,8998,-8729,-26391,3293,5225,-16547,-18794,-30370,-31634,-10935,-7616,-25661,-27313,-28953,18251,-28084,-16415,-6777,28907,-3129,9010,-14062,4133,20620,19050,-21734,18013,3873,3164,3795,16895,5971,14642,210,22084,20467,4497,-25051,9811,18977,26682,-12597,6070,-2866,16709,30911,-7995,-29622,10997,-32384,-15550,4249,-15262,24418,-10215,23629,31023,-6066,-18928,-222,-11839,-29235,3701,1920,31819,10266,-10694,-25144,-6313,-16025,-19348,30386,23988,20271,-31675,32580,1699,30366,-6555,-17728,13625,30792,31565,19588,26117,-27862,-21499,9353,-31674,-20700,-11700,2463,-10983,23792,-4793,-17052,-28985,-9031,12276,-18160,-22298,11086,26784,12683,29303,-21972,5807,-8500},
} ;

static void test_encode_1277x2627_impl(long long impl)
{
  unsigned char *s = test_encode_1277x2627_s;
  unsigned char *x = test_encode_1277x2627_x;
  unsigned char *s2 = test_encode_1277x2627_s2;
  unsigned char *x2 = test_encode_1277x2627_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1277x2627_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1277x2627(impl);
    printf("encode_1277x2627 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277x2627_implementation(impl),ntruprime_dispatch_encode_1277x2627_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1277x2627;
    printf("encode_1277x2627 selected implementation %s compiler %s\n",ntruprime_encode_1277x2627_implementation(),ntruprime_encode_1277x2627_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1277x2627_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1277x2627_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1277x2627_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1277x2627_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1277x2627_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1277x2627_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1277x2627(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277x2627")) return;
  storage_encode_1277x2627_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1277x2627_s = aligned(storage_encode_1277x2627_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1277x2627_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1277x2627_x = aligned(storage_encode_1277x2627_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1277x2627_s2 = callocplus(maxalloc);
  test_encode_1277x2627_s2 = aligned(storage_encode_1277x2627_s2,crypto_encode_STRBYTES);
  storage_encode_1277x2627_x2 = callocplus(maxalloc);
  test_encode_1277x2627_x2 = aligned(storage_encode_1277x2627_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1277x2627 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1277x2627();++impl)
      forked(test_encode_1277x2627_impl,impl);
    ++test_encode_1277x2627_s;
    ++test_encode_1277x2627_x;
    ++test_encode_1277x2627_s2;
    ++test_encode_1277x2627_x2;
  }
  free(storage_encode_1277x2627_x2);
  free(storage_encode_1277x2627_s2);
  free(storage_encode_1277x2627_x);
  free(storage_encode_1277x2627_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

