/******************************************************************************
 * THIS FILE IS GENERATED - ANY EDITS WILL BE OVERWRITTEN
 */

#pragma once

#include <Quotient/converters.h>

namespace Quotient {

struct RequestMsisdnValidation {
    /// A unique string generated by the client, and used to identify the
    /// validation attempt. It must be a string consisting of the characters
    /// `[0-9a-zA-Z.=_-]`. Its length must not exceed 255 characters and it
    /// must not be empty.
    QString clientSecret;

    /// The two-letter uppercase ISO-3166-1 alpha-2 country code that the
    /// number in `phone_number` should be parsed as if it were dialled from.
    QString country;

    /// The phone number to validate.
    QString phoneNumber;

    /// The server will only send an SMS if the `send_attempt` is a
    /// number greater than the most recent one which it has seen,
    /// scoped to that `country` + `phone_number` + `client_secret`
    /// triple. This is to avoid repeatedly sending the same SMS in
    /// the case of request retries between the POSTing user and the
    /// identity server. The client should increment this value if
    /// they desire a new SMS (e.g. a reminder) to be sent.
    int sendAttempt;

    /// Optional. When the validation is completed, the identity server will
    /// redirect the user to this URL. This option is ignored when submitting
    /// 3PID validation information through a POST request.
    QString nextLink;
};

template <>
struct JsonObjectConverter<RequestMsisdnValidation> {
    static void dumpTo(QJsonObject& jo, const RequestMsisdnValidation& pod)
    {
        addParam<>(jo, QStringLiteral("client_secret"), pod.clientSecret);
        addParam<>(jo, QStringLiteral("country"), pod.country);
        addParam<>(jo, QStringLiteral("phone_number"), pod.phoneNumber);
        addParam<>(jo, QStringLiteral("send_attempt"), pod.sendAttempt);
        addParam<IfNotEmpty>(jo, QStringLiteral("next_link"), pod.nextLink);
    }
    static void fillFrom(const QJsonObject& jo, RequestMsisdnValidation& pod)
    {
        fromJson(jo.value("client_secret"_ls), pod.clientSecret);
        fromJson(jo.value("country"_ls), pod.country);
        fromJson(jo.value("phone_number"_ls), pod.phoneNumber);
        fromJson(jo.value("send_attempt"_ls), pod.sendAttempt);
        fromJson(jo.value("next_link"_ls), pod.nextLink);
    }
};

} // namespace Quotient
