/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQFEATUREFACTORY_H
#define MVQFEATUREFACTORY_H

#include <string>

class MvQFeatureType;
class MvQFeatureItem;
class MvQPlotView;
class QGraphicsItem;

class MvQFeatureFactory
{
public:
    MvQFeatureFactory(const std::string&);
    virtual ~MvQFeatureFactory() {}

    virtual MvQFeatureItem* make(MvQFeatureType*, MvQPlotView* v) = 0;
    static MvQFeatureItem* create(MvQFeatureType*, MvQPlotView*);

private:
    // No copy allowed
    MvQFeatureFactory(const MvQFeatureFactory&);
    MvQFeatureFactory& operator=(const MvQFeatureFactory&);
};

template <class T>
class MvQFeatureMaker : public MvQFeatureFactory
{
public:
    MvQFeatureMaker(const std::string& name) :
        MvQFeatureFactory(name) {}
private:
    MvQFeatureItem* make(MvQFeatureType* f, MvQPlotView* v)
    {
        return new T(f, v);
    }
};

#endif // MVQFEATUREFACTORY_H
