/*
 * Copyright © INRIA 2009
 * Brice Goglin <Brice.Goglin@inria.fr>
 *
 * This software is a computer program whose purpose is to provide
 * a fast inter-process communication subsystem.
 *
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-B license and that you accept its terms.
 */

#ifndef __knem_h__
#define __knem_h__ 1

#ifdef __KERNEL__
#include <linux/ioctl.h>
#include <linux/types.h>
#else
#include <sys/ioctl.h>
#include <stdint.h>
#endif

#define KNEM_DEVICE_NAME	"knem"
#define KNEM_DEVICE_FILENAME	("/dev/" KNEM_DEVICE_NAME)

#define KNEM_ABI_VERSION	0x0000000b

#define KNEM_CMD_MAGIC	'K'
#define KNEM_CMD_INDEX	__IOC_NR(x)

#define KNEM_FEATURE_DMA		(1<<0)

#define KNEM_STATUS_ARRAY_FILE_OFFSET	0
typedef uint8_t knem_status_t;
enum knem_status_e {
	KNEM_STATUS_PENDING,
	KNEM_STATUS_SUCCESS,
	KNEM_STATUS_FAILED,
};

typedef uint32_t knem_flags;
#define KNEM_FLAG_DMA			(1<<0)	/* Offload copies onto DMA engine */
#define KNEM_FLAG_ASYNCDMACOMPLETE	(1<<1)	/* Report DMA completion asynchronously */
#define KNEM_FLAG_DMATHREAD		(1<<2)	/* Offload DMA management to a thread */
#define KNEM_FLAG_MEMCPYTHREAD		(1<<3)	/* Offload memcpy processing to a thread */
#define KNEM_FLAG_PINRECV		(1<<4)	/* Always pin on receive side, even in synchronous mode */
#define KNEM_FLAG_ANY_THREAD_MASK	(KNEM_FLAG_DMATHREAD|KNEM_FLAG_MEMCPYTHREAD)
#define KNEM_FLAG_ANY_ASYNC_MASK	(KNEM_FLAG_ASYNCDMACOMPLETE|KNEM_FLAG_ANY_THREAD_MASK)

struct knem_cmd_info {
	uint32_t abi;
	uint32_t features;
	uint32_t ignored_flags;
	uint32_t forced_flags;
};
#define KNEM_CMD_GET_INFO	_IOW(KNEM_CMD_MAGIC, 0x10, struct knem_cmd_info)

typedef uint32_t knem_bind_flags;
#define KNEM_BIND_FLAG_CUSTOM (1<<0)		/* Bind using given custom mask */
#define KNEM_BIND_FLAG_CURRENT (1<<1)		/* Bind using current process mask */
#define KNEM_BIND_FLAG_CURRENT_REVERSED (1<<2)	/* Bind using current process reversed mask */

struct knem_cmd_bind_offload {
	uint32_t flags;
	uint32_t mask_len;
	uint64_t mask_ptr;
};
#define KNEM_CMD_BIND_OFFLOAD	_IOR(KNEM_CMD_MAGIC, 0x11, struct knem_cmd_bind_offload)

struct knem_cmd_param_iovec {
	uint64_t base; /* pointer */
	uint64_t len;
};

struct knem_cmd_init_send_param {
	uint64_t send_iovec_array; /* input pointer */
	uint32_t send_iovec_nr; /* input */
	uint32_t flags; /* input, unused yet */
	uint64_t send_cookie; /* output */
};
#define KNEM_CMD_INIT_SEND	_IOWR(KNEM_CMD_MAGIC, 0x20, struct knem_cmd_init_send_param)

struct knem_cmd_init_async_recv_param {
	uint64_t recv_iovec_array; /* input pointer */
	uint32_t recv_iovec_nr; /* input */
	uint32_t status_index; /* input */
	uint64_t send_cookie; /* input */
	uint32_t flags; /* input */
	uint32_t pad;
};
#define KNEM_CMD_INIT_ASYNC_RECV	_IOR(KNEM_CMD_MAGIC, 0x30, struct knem_cmd_init_async_recv_param)

struct knem_cmd_sync_recv_param {
	uint64_t recv_iovec_array; /* input pointer */
	uint32_t recv_iovec_nr; /* input */
	uint32_t status; /* output */
	uint64_t send_cookie; /* input */
	uint32_t flags; /* input */
	uint32_t pad;
};
#define KNEM_CMD_SYNC_RECV	_IOR(KNEM_CMD_MAGIC, 0x31, struct knem_cmd_sync_recv_param)

typedef uint64_t knem_cookie_t;

#endif /* __knem_h__ */
