/// DicomDictionary.h
/**
  DICOM attributes from 2011 standard as obtained from:
  http://www.dclunie.com/dicom-status/status.html#BaseStandard2011
  Data from PS 3.6  Data Dictionary.
  Attributes with short description ending in "-RET" are retired as
  of the 2011 standard.
  20130221cdt
*/

/** These from http://www.sno.phy.queensu.ca/~phil/exiftool/TagNames/DICOM.html
have already entries below.
0002,0000 	FileMetaInfoGroupLength 	N 	 
0002,0001 	FileMetaInfoVersion 	N 	 
0002,0002 	MediaStorageSOPClassUID 	N 	 
0002,0003 	MediaStorageSOPInstanceUID 	N 	 
0002,0010 	TransferSyntaxUID 	N 	 
0002,0012 	ImplementationClassUID 	N 	 
0002,0013 	ImplementationVersionName 	N 	 
0002,0016 	SourceApplicationEntityTitle 	N 	 
0002,0100 	PrivateInformationCreatorUID 	N 	 
0002,0102 	PrivateInformation
*/


// RETIRED ELEMENTS
mAddEntry (DicomElement ( DicomTag ( 0x0004, 0x1504 ), "MRDRDirectoryRecordOffset-RET", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0004, 0x1600 ), "NumberOfReferences-RET", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x0001 ), "LengthToEnd-RET", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x0010 ), "RecognitionCode-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x0024 ), "OverlayDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x0025 ), "CurveDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x0034 ), "OverlayTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x0035 ), "CurveTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x0040 ), "DataSetType-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x0041 ), "DataSetSubtype-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x0042 ), "NuclearMedicineSeriesType-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x1000 ), "NetworkID-RET", "AE" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x1100 ), "ReferencedResultsSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x1130 ), "ReferencedOverlaySequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x1145 ), "ReferencedCurveSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2110 ), "LossyImageCompressionRetired-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2200 ), "TransducerPosition-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2204 ), "TransducerOrientation-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2208 ), "AnatomicStructure-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2240 ), "TransducerPositionSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2242 ), "TransducerPositionModifierSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2244 ), "TransducerOrientationSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2246 ), "TransducerOrientationModifierSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2251 ), "AnatomicStructureSpaceOrRegionCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2253 ), "AnatomicPortalOfEntranceCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2255 ), "AnatomicApproachDirectionCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2256 ), "AnatomicPerspectiveDescriptionTrial-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2257 ), "AnatomicPerspectiveCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2258 ), "AnatomicLocationOfExaminingInstrumentDescriptionTrial-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x2259 ), "AnatomicLocationOfExaminingInstrumentCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x225A ), "AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x225C ), "OnAxisBackgroundAnatomicStructureCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0008, 0x4000 ), "IdentifyingComments-RET", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0010, 0x1050 ), "InsurancePlanIdentification-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x0030 ), "Radionuclide-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x0032 ), "EnergyWindowCenterline-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x0033 ), "EnergyWindowTotalWidth-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x0037 ), "TherapyType-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x0039 ), "TherapyDescription-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x1011 ), "HardcopyCreationDeviceID-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x1017 ), "HardcopyDeviceManufacturer-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x101A ), "HardcopyDeviceSoftwareVersion-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x101B ), "HardcopyDeviceManufacturerModelName-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x1141 ), "AngularPosition-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x1146 ), "RotationOffset-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x1240 ), "UpperLowerPixelValues-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x4000 ), "AcquisitionComments-RET", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x5021 ), "PostprocessingFunction-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x5030 ), "DynamicRange-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x5040 ), "TotalGain-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x5210 ), "ImageTransformationMatrix-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x5212 ), "ImageTranslationVector-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x6038 ), "DopplerSampleVolumeXPositionRetired-RET", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x603A ), "DopplerSampleVolumeYPositionRetired-RET", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x603C ), "TMLinePositionX0Retired-RET", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x603E ), "TMLinePositionY0Retired-RET", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x6040 ), "TMLinePositionX1Retired-RET", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x6042 ), "TMLinePositionY1Retired-RET", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x9096 ), "ParallelReductionFactorInPlaneRetired-RET", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x9166 ), "BulkMotionStatus-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x9195 ), "ChemicalShiftMinimumIntegrationLimitInHz-RET", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x9196 ), "ChemicalShiftMaximumIntegrationLimitInHz-RET", "FD" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0018, 0x9445 ),				RET
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0014 ), "IsotopeNumber-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0015 ), "PhaseNumber-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0016 ), "IntervalNumber-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0017 ), "TimeSlotNumber-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0018 ), "AngleNumber-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0022 ), "OverlayNumber-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0024 ), "CurveNumber-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0026 ), "LUTNumber-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0030 ), "ImagePosition-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0035 ), "ImageOrientation-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0050 ), "Location-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0070 ), "ImageGeometryType-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x0080 ), "MaskingImage-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x00AA ), "ReportNumber-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x1000 ), "SeriesInStudy-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x1001 ), "AcquisitionsInSeries-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x1003 ), "ImagesInSeries-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x1004 ), "AcquisitionsInStudy-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x1005 ), "ImagesInStudy-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x1020 ), "Reference-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x1070 ), "OtherStudyNumbers-RET", "IS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0020,3100 to 31FF)" "SourceImageIDs-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x3401 ), "ModifyingDeviceID-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x3402 ), "ModifiedImageID-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x3403 ), "ModifiedImageDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x3404 ), "ModifyingDeviceManufacturer-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x3405 ), "ModifiedImageTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x3406 ), "ModifiedImageDescription-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x5000 ), "OriginalImageIdentification-RET", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0020, 0x5002 ), "OriginalImageIdentificationNomenclature-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0005 ), "ImageDimensions-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0012 ), "Planes-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0020 ),				RET
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0040 ), "ImageFormat-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0050 ), "ManipulatedImage-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x005F ), "CompressionRecognitionCode-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0060 ), "CompressionCode-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0061 ), "CompressionOriginator-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0062 ), "CompressionLabel-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0063 ), "CompressionDescription-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0065 ), "CompressionSequence-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0066 ), "CompressionStepPointers-RET", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0068 ), "RepeatInterval-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0069 ), "BitsGrouped-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0070 ), "PerimeterTable-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0071 ), "PerimeterValue-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0080 ), "PredictorRows-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0081 ), "PredictorColumns-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0082 ), "PredictorConstants-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0090 ), "BlockedPixels-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0091 ), "BlockRows-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0092 ), "BlockColumns-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0093 ), "RowOverlap-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0094 ), "ColumnOverlap-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0104 ), "SmallestValidPixelValue-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0105 ), "LargestValidPixelValue-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0110 ), "SmallestImagePixelValueInPlane-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0111 ), "LargestImagePixelValueInPlane-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0200 ), "ImageLocation-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0400 ), "TransformLabel-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0401 ), "TransformVersionNumber-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0402 ), "NumberOfTransformSteps-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0403 ), "SequenceOfCompressedData-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0404 ), "DetailsOfCoefficients-RET", "AT" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x04x0 ), "RowsForNthOrderCoefficients-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x04x1 ), "ColumnsForNthOrderCoefficients-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x04x2 ), "CoefficientCoding-RET", "LO" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x04x3 ), "CoefficientCodingPointers-RET", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0700 ), "DCTLabel-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0701 ), "DataBlockDescription-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0702 ), "DataBlock-RET", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0710 ), "NormalizationFactorFormat-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0720 ), "ZonalMapNumberFormat-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0721 ), "ZonalMapLocation-RET", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0722 ), "ZonalMapFormat-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0730 ), "AdaptiveMapFormat-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0740 ), "CodeNumberFormat-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x08x0 ), "CodeLabel-RET", "CS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x08x2 ), "NumberOfTables-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x08x3 ), "CodeTableLocation-RET", "AT" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x08x4 ), "BitsForCodeWord-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x08x8 ), "ImageDataLocation-RET", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1080 ), "GrayScale-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1100 ), "GrayLookupTableDescriptor-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1111 ), "LargeRedPaletteColorLookupTableDescriptor-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1112 ), "LargeGreenPaletteColorLookupTableDescriptor-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1113 ), "LargeBluePaletteColorLookupTableDescriptor-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1200 ), "GrayLookupTableData-RET", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1211 ), "LargeRedPaletteColorLookupTableData-RET", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1212 ), "LargeGreenPaletteColorLookupTableData-RET", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1213 ), "LargeBluePaletteColorLookupTableData-RET", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1214 ), "LargePaletteColorLookupTableUID-RET", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x4000 ), "ImagePresentationComments-RET", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x5000 ), "BiPlaneAcquisitionSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6030 ), "MaskPointers-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9099 ), "LargestMonochromePixelValue-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x000A ), "StudyStatusID-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x000C ), "StudyPriorityID-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x0012 ), "StudyIDIssuer-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x0032 ), "StudyVerifiedDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x0033 ), "StudyVerifiedTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x0034 ), "StudyReadDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x0035 ), "StudyReadTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1000 ), "ScheduledStudyStartDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1001 ), "ScheduledStudyStartTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1010 ), "ScheduledStudyStopDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1011 ), "ScheduledStudyStopTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1020 ), "ScheduledStudyLocation-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1021 ), "ScheduledStudyLocationAETitle-RET", "AE" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1030 ), "ReasonForStudy-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1040 ), "StudyArrivalDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1041 ), "StudyArrivalTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1050 ), "StudyCompletionDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1051 ), "StudyCompletionTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1055 ), "StudyComponentStatusID-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x4000 ), "StudyComments-RET", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0011 ), "IssuerOfAdmissionID-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x001A ), "ScheduledAdmissionDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x001B ), "ScheduledAdmissionTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x001C ), "ScheduledDischargeDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x001D ), "ScheduledDischargeTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x001E ), "ScheduledPatientInstitutionResidence-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0030 ), "DischargeDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0032 ), "DischargeTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0040 ), "DischargeDiagnosisDescription-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0044 ), "DischargeDiagnosisCodeSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0061 ), "IssuerOfServiceEpisodeID-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0307 ), "DistanceSourceToSupport-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0330 ), "ReferencedProcedureStepSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x050A ), "SpecimenAccessionNumber-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0550 ), "SpecimenSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0552 ), "SpecimenDescriptionSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0553 ), "SpecimenDescriptionTrial-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x06FA ), "SlideIdentifier-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x08D8 ), "PixelSpacingSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x08DA ), "CoordinateSystemAxisCodeSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x09F8 ), "VitalStainCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1006 ), "PlacerOrderNumberProcedure-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1007 ), "FillerOrderNumberProcedure-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1060 ), "RequestedProcedureDescriptionTrial-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2001 ), "ReasonForTheImagingServiceRequest-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2006 ), "PlacerOrderNumberImagingServiceRequestRetired-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2007 ), "FillerOrderNumberImagingServiceRequestRetired-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA007 ), "FindingsFlagTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA020 ), "FindingsSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA021 ), "FindingsGroupUIDTrial-RET", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA022 ), "ReferencedFindingsGroupUIDTrial-RET", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA023 ), "FindingsGroupRecordingDateTrial-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA024 ), "FindingsGroupRecordingTimeTrial-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA026 ), "FindingsSourceCategoryCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA028 ), "DocumentingOrganizationIdentifierCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA047 ), "MeasurementPrecisionDescriptionTrial-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA057 ), "UrgencyOrPriorityAlertsTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA060 ), "SequencingIndicatorTrial-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA066 ), "DocumentIdentifierCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA067 ), "DocumentAuthorTrial-RET", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA068 ), "DocumentAuthorIdentifierCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA070 ), "IdentifierCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA074 ), "ObjectBinaryIdentifierTrial-RET", "OB" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA076 ), "DocumentingObserverIdentifierCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA085 ), "ProcedureIdentifierCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA089 ), "ObjectDirectoryBinaryIdentifierTrial-RET", "OB" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA090 ), "EquivalentCDADocumentSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA110 ), "DateOfDocumentOrVerbalTransactionTrial-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA112 ), "TimeOfDocumentCreationOrVerbalTransactionTrial-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA125 ), "ReportStatusIDTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA167 ), "ObservationCategoryCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA16A ), "BibliographicCitationTrial-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA171 ), "ObservationUIDTrial-RET", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA172 ), "ReferencedObservationUIDTrial-RET", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA173 ), "ReferencedObservationClassTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA174 ), "ReferencedObjectObservationClassTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA192 ), "ObservationDateTrial-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA193 ), "ObservationTimeTrial-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA194 ), "MeasurementAutomationTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA224 ), "IdentificationDescriptionTrial-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA290 ), "CoordinatesSetGeometricTypeTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA296 ), "AlgorithmCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA297 ), "AlgorithmDescriptionTrial-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA29A ), "PixelCoordinatesSetTrial-RET", "SL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA307 ), "CurrentObserverTrial-RET", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA313 ), "ReferencedAccessionSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA33A ), "ReportStatusCommentTrial-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA340 ), "ProcedureContextSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA352 ), "VerbalSourceTrial-RET", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA353 ), "AddressTrial-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA354 ), "TelephoneNumberTrial-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA358 ), "VerbalSourceIdentifierCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA380 ), "ReportDetailSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA402 ), "ObservationSubjectUIDTrial-RET", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA403 ), "ObservationSubjectClassTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA404 ), "ObservationSubjectTypeCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA600 ), "ObservationSubjectContextFlagTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA601 ), "ObserverContextFlagTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA603 ), "ProcedureContextFlagTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA731 ), "RelationshipSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA732 ), "RelationshipTypeCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA744 ), "LanguageCodeSequenceTrial-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA992 ), "UniformResourceLocatorTrial-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xDB06 ), "TemplateVersion-RET", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xDB07 ), "TemplateLocalVersion-RET", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xDB0B ), "TemplateExtensionFlag-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xDB0C ), "TemplateExtensionOrganizationUID-RET", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xDB0D ), "TemplateExtensionCreatorUID-RET", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1400 ), "CountsIncluded-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1401 ), "DeadTimeCorrectionFlag-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0040 ), "ImageRotationRetired-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0050 ), "DisplayedAreaTopLeftHandCornerTrial-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0051 ), "DisplayedAreaBottomRightHandCornerTrial-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0067 ), "GraphicLayerRecommendedDisplayRGBValue-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1024 ), "BeamOrderIndexTrial-RET", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1038 ), "DoubleExposureMetersetTrial-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x103A ), "DoubleExposureFieldDeltaTrial-RET", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1220 ), "RelatedProcedureStepSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1222 ), "ProcedureStepRelationshipType-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0088, 0x0904 ), "TopicTitle-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0088, 0x0906 ), "TopicSubject-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0088, 0x0910 ), "TopicAuthor-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0088, 0x0912 ), "TopicKeywords-RET", "LO" ));
//mAddEntry (DicomElement ( DicomTag ( 0x1000, 0xxxx0 ), "EscapeTriplet-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x1000, 0xxxx1 ), "RunLengthTriplet-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x1000, 0xxxx2 ), "HuffmanTableSize-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x1000, 0xxxx3 ), "HuffmanTableTriplet-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x1000, 0xxxx4 ), "ShiftTableSize-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x1000, 0xxxx5 ), "ShiftTableTriplet-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x1010, 0xxxxx ), "ZonalMap-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0062 ), "ColorImagePrintingFlag-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0063 ), "CollationFlag-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0065 ), "AnnotationFlag-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0067 ), "ImageOverlayFlag-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0069 ), "PresentationLUTFlag-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x006A ), "ImageBoxPresentationLUTFlag-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0510 ), "ReferencedStoredPrintSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x0130 ), "ReferencedImageOverlayBoxSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x0140 ), "ReferencedVOILUTBoxSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0010 ), "ReferencedOverlayPlaneSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0011 ), "ReferencedOverlayPlaneGroups-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0020 ), "OverlayPixelDataSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0060 ), "OverlayMagnificationType-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0070 ), "OverlaySmoothingType-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0072 ), "OverlayOrImageMagnification-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0074 ), "MagnifyToNumberOfColumns-RET", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0080 ), "OverlayForegroundDensity-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0082 ), "OverlayBackgroundDensity-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0090 ), "OverlayMode-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0100 ), "ThresholdDensity-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2040, 0x0500 ), "ReferencedImageBoxSequenceRetired-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0010 ), "PrintJobID-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0140 ), "DestinationAE-RET", "AE" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0500 ), "ReferencedPrintJobSequencePullStoredPrint-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2110, 0x0099 ), "PrintQueueID-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x2120, 0x0010 ), "QueueStatus-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2120, 0x0050 ), "PrintJobDescriptionSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2120, 0x0070 ), "ReferencedPrintJobSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2130, 0x0010 ), "PrintManagementCapabilitiesSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2130, 0x0015 ), "PrinterCharacteristicsSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2130, 0x0030 ), "FilmBoxContentSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2130, 0x0040 ), "ImageBoxContentSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2130, 0x0050 ), "AnnotationContentSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2130, 0x0060 ), "ImageOverlayBoxContentSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2130, 0x0080 ), "PresentationLUTContentSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2130, 0x00A0 ), "ProposedStudySequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2130, 0x00C0 ), "OriginalImageSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4000, 0x0010 ), "Arbitrary-RET", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x4000, 0x4000 ), "TextComments-RET", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0040 ), "ResultsID-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0042 ), "ResultsIDIssuer-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0050 ), "ReferencedInterpretationSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x00FF ), "ReportProductionStatusTrial-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0100 ), "InterpretationRecordedDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0101 ), "InterpretationRecordedTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0102 ), "InterpretationRecorder-RET", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0103 ), "ReferenceToRecordedSound-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0108 ), "InterpretationTranscriptionDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0109 ), "InterpretationTranscriptionTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x010A ), "InterpretationTranscriber-RET", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x010B ), "InterpretationText-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x010C ), "InterpretationAuthor-RET", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0111 ), "InterpretationApproverSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0112 ), "InterpretationApprovalDate-RET", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0113 ), "InterpretationApprovalTime-RET", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0114 ), "PhysicianApprovingInterpretation-RET", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0115 ), "InterpretationDiagnosisDescription-RET", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0117 ), "InterpretationDiagnosisCodeSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0118 ), "ResultsDistributionListSequence-RET", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0119 ), "DistributionName-RET", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x011A ), "DistributionAddress-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0200 ), "InterpretationID-RET", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0202 ), "InterpretationIDIssuer-RET", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0210 ), "InterpretationTypeID-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0212 ), "InterpretationStatusID-RET", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x0300 ), "Impressions-RET", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x4008, 0x4000 ), "ResultsComments-RET", "ST" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0005 ), "CurveDimensions-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0010 ), "NumberOfPoints-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0020 ), "TypeOfData-RET", "CS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0022 ), "CurveDescription-RET", "LO" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0030 ), "AxisUnits-RET", "SH" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0040 ), "AxisLabels-RET", "SH" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0103 ), "DataValueRepresentation-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0104 ), "MinimumCoordinateValue-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0105 ), "MaximumCoordinateValue-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0106 ), "CurveRange-RET", "SH" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0110 ), "CurveDataDescriptor-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0112 ), "CoordinateStartValue-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x0114 ), "CoordinateStepValue-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x1001 ), "CurveActivationLayer-RET", "CS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x2000 ), "AudioType-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x2002 ), "AudioSampleFormat-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x2004 ), "NumberOfChannels-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x2006 ), "NumberOfSamples-RET", "UL" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x2008 ), "SampleRate-RET", "UL" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x200A ), "TotalTime-RET", "UL" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x200C ), "AudioSampleData-RET", "OW or OB" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x200E ), "AudioComments-RET", "LT" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x2500 ), "CurveLabel-RET", "LO" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x2600 ), "CurveReferencedOverlaySequence-RET", "SQ" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x2610 ), "CurveReferencedOverlayGroup-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x50xx, 0x3000 ), "CurveData-RET", "OW or OB" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0012 ), "OverlayPlanes-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0052 ), "OverlayPlaneOrigin-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0060 ), "OverlayCompressionCode-RET", "CS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0061 ), "OverlayCompressionOriginator-RET", "SH" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0062 ), "OverlayCompressionLabel-RET", "SH" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0063 ), "OverlayCompressionDescription-RET", "CS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0066 ), "OverlayCompressionStepPointers-RET", "AT" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0068 ), "OverlayRepeatInterval-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0069 ), "OverlayBitsGrouped-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0110 ), "OverlayFormat-RET", "CS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0200 ), "OverlayLocation-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0800 ), "OverlayCodeLabel-RET", "CS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0802 ), "OverlayNumberOfTables-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0803 ), "OverlayCodeTableLocation-RET", "AT" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0804 ), "OverlayBitsForCodeWord-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1100 ), "OverlayDescriptorGray-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1101 ), "OverlayDescriptorRed-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1102 ), "OverlayDescriptorGreen-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1103 ), "OverlayDescriptorBlue-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1200 ), "OverlaysGray-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1201 ), "OverlaysRed-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1202 ), "OverlaysGreen-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1203 ), "OverlaysBlue-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x4000 ), "OverlayComments-RET", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x7FE0, 0x0020 ), "CoefficientsSDVN-RET", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x7FE0, 0x0030 ), "CoefficientsSDHN-RET", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x7FE0, 0x0040 ), "CoefficientsSDDN-RET", "OW" ));
//mAddEntry (DicomElement ( DicomTag ( 0x7Fxx, 0x0010 ), "VariablePixelData-RET", "OW or OB" ));
//mAddEntry (DicomElement ( DicomTag ( 0x7Fxx, 0x0011 ), "VariableNextDataGroup-RET", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x7Fxx, 0x0020 ), "VariableCoefficientsSDVN-RET", "OW" ));
//mAddEntry (DicomElement ( DicomTag ( 0x7Fxx, 0x0030 ), "VariableCoefficientsSDHN-RET", "OW" ));
//mAddEntry (DicomElement ( DicomTag ( 0x7Fxx, 0x0040 ), "VariableCoefficientsSDDN-RET", "OW" ));


// group 0x0000

mAddEntry(DicomElement(DicomTag(0x0000, 0x0000), "CommandGroupLength", "UL"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0002), "AffectedSOPClassUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0003), "RequestedSOPClassUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0100), "CommandField", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0110), "MessageID", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0120), "MessageIDBeingRespondedTo", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0600), "MoveDestination", "AE"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0700), "Priority", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0800), "DataSetType", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0900), "Status", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0901), "OffendingElement", "AT"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0902), "ErrorComment", "LO"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x0903), "ErrorID", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1000), "AffectedSOPInstanceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1001), "RequestedSOPInstanceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1002), "EventTypeID", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1005), "AttributeIdentifierList", "AT"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1008), "ActionTypeID", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1020), "NumberOfRemainingSubOperations", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1021), "NumberOfCompletedSubOperations", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1022), "NumberOfFailedSubOperations", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1023), "NumberOfWarningSubOperations", "US"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1030), "MoveOriginatorApplicationEntityTitle", "AE"));
mAddEntry(DicomElement(DicomTag(0x0000, 0x1031), "MoveOriginatorMessageID", "US"));

// group 0x0002
mAddEntry(DicomElement(DicomTag(0x0002, 0x0000), "FileMetaInformationGroupLength", "UL"));
mAddEntry(DicomElement(DicomTag(0x0002, 0x0001), "FileMetaInformationVersion", "OB"));
mAddEntry(DicomElement(DicomTag(0x0002, 0x0002), "MediaStorageSOPClassUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0002, 0x0003), "MediaStorageSOPInstanceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0002, 0x0010), "TransferSyntaxUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0002, 0x0012), "ImplementationClassUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0002, 0x0013), "ImplementationVersionName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0002, 0x0016), "SourceApplicationEntityTitle", "AE"));
mAddEntry(DicomElement(DicomTag(0x0002, 0x0100), "PrivateInformationCreatorUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0002, 0x0102), "PrivateInformation", "OB"));

// group 0x0004

mAddEntry(DicomElement(DicomTag(0x0004, 0x1130), "FileSetID", "CS"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1141), "FileSetDescriptorFileID", "CS"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1142), "SpecificCharacterSetOfFileSetDescriptorFile", "CS"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1200), "OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity", "UL"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1202), "OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity", "UL"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1212), "FileSetConsistencyFlag", "US"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1220), "DirectoryRecordSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1400), "OffsetOfTheNextDirectoryRecord", "UL"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1410), "RecordInUseFlag", "US"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1420), "OffsetOfReferencedLowerLevelDirectoryEntity", "UL"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1430), "DirectoryRecordType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1432), "PrivateRecordUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1500), "ReferencedFileID", "CS"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1510), "ReferencedSOPClassUIDInFile", "UI"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1511), "ReferencedSOPInstanceUIDInFile", "UI"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x1512), "ReferencedTransferSyntaxUIDInFile", "UI"));
mAddEntry(DicomElement(DicomTag(0x0004, 0x151A), "ReferencedRelatedGeneralSOPClassUIDInFile", "UI"));

// group 0x0008
mAddEntry(DicomElement(DicomTag(0x0008, 0x0005), "SpecificCharacterSet", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0006), "LanguageCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0008), "ImageType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0012), "InstanceCreationDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0013), "InstanceCreationTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0014), "InstanceCreatorUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0016), "SOPClassUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0018), "SOPInstanceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x001A), "RelatedGeneralSOPClassUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x001B), "OriginalSpecializedSOPClassUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0020), "StudyDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0021), "SeriesDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0022), "AcquisitionDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0023), "ContentDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x002A), "AcquisitionDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0030), "StudyTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0031), "SeriesTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0032), "AcquisitionTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0033), "ContentTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0050), "AccessionNumber", "SH"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0051), "IssuerOfAccessionNumberSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0052), "QueryRetrieveLevel", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0054), "RetrieveAETitle", "AE"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0056), "InstanceAvailability", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0058), "FailedSOPInstanceUIDList", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0060), "Modality", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0061), "ModalitiesInStudy", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0062), "SOPClassesInStudy", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0064), "ConversionType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0068), "PresentationIntentType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0070), "Manufacturer", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0080), "InstitutionName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0081), "InstitutionAddress", "ST"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0082), "InstitutionCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0090), "ReferringPhysicianName", "PN"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0092), "ReferringPhysicianAddress", "ST"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0094), "ReferringPhysicianTelephoneNumbers", "SH"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0096), "ReferringPhysicianIdentificationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0100), "CodeValue", "SH"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0102), "CodingSchemeDesignator", "SH"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0103), "CodingSchemeVersion", "SH"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0104), "CodeMeaning", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0105), "MappingResource", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0106), "ContextGroupVersion", "DT"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0107), "ContextGroupLocalVersion", "DT"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x010B), "ContextGroupExtensionFlag", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x010C), "CodingSchemeUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x010D), "ContextGroupExtensionCreatorUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x010F), "ContextIdentifier", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0110), "CodingSchemeIdentificationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0112), "CodingSchemeRegistry", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0114), "CodingSchemeExternalID", "ST"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0115), "CodingSchemeName", "ST"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0116), "CodingSchemeResponsibleOrganization", "ST"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0117), "ContextUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x0201), "TimezoneOffsetFromUTC", "SH"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1010), "StationName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1030), "StudyDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1032), "ProcedureCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x103E), "SeriesDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x103F), "SeriesDescriptionCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1040), "InstitutionalDepartmentName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1048), "PhysiciansOfRecord", "PN"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1049), "PhysiciansOfRecordIdentificationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1050), "PerformingPhysicianName", "PN"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1052), "PerformingPhysicianIdentificationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1060), "NameOfPhysiciansReadingStudy", "PN"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1062), "PhysiciansReadingStudyIdentificationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1070), "OperatorsName", "PN"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1072), "OperatorIdentificationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1080), "AdmittingDiagnosesDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1084), "AdmittingDiagnosesCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1090), "ManufacturerModelName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1110), "ReferencedStudySequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1111), "ReferencedPerformedProcedureStepSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1115), "ReferencedSeriesSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1120), "ReferencedPatientSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1125), "ReferencedVisitSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1134), "ReferencedStereometricInstanceSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x113A), "ReferencedWaveformSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1140), "ReferencedImageSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x114A), "ReferencedInstanceSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x114B), "ReferencedRealWorldValueMappingInstanceSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1150), "ReferencedSOPClassUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1155), "ReferencedSOPInstanceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x115A), "SOPClassesSupported", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1160), "ReferencedFrameNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1161), "SimpleFrameList", "UL"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1162), "CalculatedFrameList", "UL"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1163), "TimeRange", "FD"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1164), "FrameExtractionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1167), "MultiFrameSourceSOPInstanceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1195), "TransactionUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1197), "FailureReason", "US"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1198), "FailedSOPSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1199), "ReferencedSOPSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1200), "StudiesContainingOtherReferencedInstancesSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x1250), "RelatedSeriesSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2111), "DerivationDescription", "ST"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2112), "SourceImageSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2120), "StageName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2122), "StageNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2124), "NumberOfStages", "IS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2127), "ViewName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2128), "ViewNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2129), "NumberOfEventTimers", "IS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x212A), "NumberOfViewsInStage", "IS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2130), "EventElapsedTimes", "DS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2132), "EventTimerNames", "LO"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2133), "EventTimerSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2134), "EventTimeOffset", "FD"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2135), "EventCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2142), "StartTrim", "IS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2143), "StopTrim", "IS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2144), "RecommendedDisplayFrameRate", "IS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2218), "AnatomicRegionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2220), "AnatomicRegionModifierSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2228), "PrimaryAnatomicStructureSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2229), "AnatomicStructureSpaceOrRegionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x2230), "PrimaryAnatomicStructureModifierSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x3001), "AlternateRepresentationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x3010), "IrradiationEventUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9007), "FrameType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9092), "ReferencedImageEvidenceSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9121), "ReferencedRawDataSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9123), "CreatorVersionUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9124), "DerivationImageSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9154), "SourceImageEvidenceSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9205), "PixelPresentation", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9206), "VolumetricProperties", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9207), "VolumeBasedCalculationTechnique", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9208), "ComplexImageComponent", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9209), "AcquisitionContrast", "CS"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9215), "DerivationCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9237), "ReferencedPresentationStateSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9410), "ReferencedOtherPlaneSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9458), "FrameDisplaySequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9459), "RecommendedDisplayFrameRateInFloat", "FL"));
mAddEntry(DicomElement(DicomTag(0x0008, 0x9460), "SkipFrameRangeFlag", "CS"));

// group 0x0010
mAddEntry(DicomElement(DicomTag(0x0010, 0x0010), "PatientName", "PN"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0020), "PatientID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0021), "IssuerOfPatientID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0022), "TypeOfPatientID", "CS"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0024), "IssuerOfPatientIDQualifiersSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0030), "PatientBirthDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0032), "PatientBirthTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0040), "PatientSex", "CS"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0050), "PatientInsurancePlanCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0101), "PatientPrimaryLanguageCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x0102), "PatientPrimaryLanguageModifierCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1000), "OtherPatientIDs", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1001), "OtherPatientNames", "PN"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1002), "OtherPatientIDsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1005), "PatientBirthName", "PN"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1010), "PatientAge", "AS"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1020), "PatientSize", "DS"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1021), "PatientSizeCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1030), "PatientWeight", "DS"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1040), "PatientAddress", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1060), "PatientMotherBirthName", "PN"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1080), "MilitaryRank", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1081), "BranchOfService", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x1090), "MedicalRecordLocator", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2000), "MedicalAlerts", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2110), "Allergies", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2150), "CountryOfResidence", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2152), "RegionOfResidence", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2154), "PatientTelephoneNumbers", "SH"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2160), "EthnicGroup", "SH"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2180), "Occupation", "SH"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x21A0), "SmokingStatus", "CS"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x21B0), "AdditionalPatientHistory", "LT"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x21C0), "PregnancyStatus", "US"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x21D0), "LastMenstrualDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x21F0), "PatientReligiousPreference", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2201), "PatientSpeciesDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2202), "PatientSpeciesCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2203), "PatientSexNeutered", "CS"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2210), "AnatomicalOrientationType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2292), "PatientBreedDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2293), "PatientBreedCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2294), "BreedRegistrationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2295), "BreedRegistrationNumber", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2296), "BreedRegistryCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2297), "ResponsiblePerson", "PN"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2298), "ResponsiblePersonRole", "CS"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x2299), "ResponsibleOrganization", "LO"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x4000), "PatientComments", "LT"));
mAddEntry(DicomElement(DicomTag(0x0010, 0x9431), "ExaminedBodyThickness", "FL"));

//group 0x0012
mAddEntry(DicomElement(DicomTag(0x0012, 0x0010), "ClinicalTrialSponsorName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0020), "ClinicalTrialProtocolID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0021), "ClinicalTrialProtocolName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0030), "ClinicalTrialSiteID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0031), "ClinicalTrialSiteName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0040), "ClinicalTrialSubjectID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0042), "ClinicalTrialSubjectReadingID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0050), "ClinicalTrialTimePointID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0051), "ClinicalTrialTimePointDescription", "ST"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0060), "ClinicalTrialCoordinatingCenterName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0062), "PatientIdentityRemoved", "CS"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0063), "DeidentificationMethod", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0064), "DeidentificationMethodCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0071), "ClinicalTrialSeriesID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0072), "ClinicalTrialSeriesDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0081), "ClinicalTrialProtocolEthicsCommitteeName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0082), "ClinicalTrialProtocolEthicsCommitteeApprovalNumber", "LO"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0083), "ConsentForClinicalTrialUseSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0084), "DistributionType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0012, 0x0085), "ConsentForDistributionFlag", "CS"));

// group 0x0014
mAddEntry(DicomElement(DicomTag(0x0014, 0x0023), "CADFileFormat", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0024), "ComponentReferenceSystem", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0025), "ComponentManufacturingProcedure", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0028), "ComponentManufacturer", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0030), "MaterialThickness", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0032), "MaterialPipeDiameter", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0034), "MaterialIsolationDiameter", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0042), "MaterialGrade", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0044), "MaterialPropertiesFileID", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0045), "MaterialPropertiesFileFormat", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0046), "MaterialNotes", "LT"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0050), "ComponentShape", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0052), "CurvatureType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0054), "OuterDiameter", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x0056), "InnerDiameter", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x1010), "ActualEnvironmentalConditions", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x1020), "ExpiryDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x1040), "EnvironmentalConditions", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2002), "EvaluatorSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2004), "EvaluatorNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2006), "EvaluatorName", "PN"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2008), "EvaluationAttempt", "IS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2012), "IndicationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2014), "IndicationNumber ", "IS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2016), "IndicationLabel", "SH"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2018), "IndicationDescription", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x201A), "IndicationType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x201C), "IndicationDisposition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x201E), "IndicationROISequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2030), "IndicationPhysicalPropertySequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2032), "PropertyLabel", "SH"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2202), "CoordinateSystemNumberOfAxes ", "IS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2204), "CoordinateSystemAxesSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2206), "CoordinateSystemAxisDescription", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2208), "CoordinateSystemDataSetMapping", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x220A), "CoordinateSystemAxisNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x220C), "CoordinateSystemAxisType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x220E), "CoordinateSystemAxisUnits", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2210), "CoordinateSystemAxisValues", "OB"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2220), "CoordinateSystemTransformSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2222), "TransformDescription", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2224), "TransformNumberOfAxes", "IS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2226), "TransformOrderOfAxes", "IS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x2228), "TransformedAxisUnits", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x222A), "CoordinateSystemTransformRotationAndScaleMatrix", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x222C), "CoordinateSystemTransformTranslationMatrix", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3011), "InternalDetectorFrameTime", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3012), "NumberOfFramesIntegrated", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3020), "DetectorTemperatureSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3022), "SensorName", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3024), "HorizontalOffsetOfSensor", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3026), "VerticalOffsetOfSensor", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3028), "SensorTemperature", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3040), "DarkCurrentSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3050), "DarkCurrentCounts", "OB or OW"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3060), "GainCorrectionReferenceSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3070), "AirCounts", "OB or OW"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3071), "KVUsedInGainCalibration", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3072), "MAUsedInGainCalibration", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3073), "NumberOfFramesUsedForIntegration", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3074), "FilterMaterialUsedInGainCalibration", "LO"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3075), "FilterThicknessUsedInGainCalibration", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3076), "DateOfGainCalibration", "DA"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3077), "TimeOfGainCalibration", "TM"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3080), "BadPixelImage", "OB"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x3099), "CalibrationNotes", "LT"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4002), "PulserEquipmentSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4004), "PulserType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4006), "PulserNotes", "LT"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4008), "ReceiverEquipmentSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x400A), "AmplifierType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x400C), "ReceiverNotes", "LT"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x400E), "PreAmplifierEquipmentSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x400F), "PreAmplifierNotes", "LT"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4010), "TransmitTransducerSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4011), "ReceiveTransducerSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4012), "NumberOfElements", "US"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4013), "ElementShape", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4014), "ElementDimensionA", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4015), "ElementDimensionB", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4016), "ElementPitch", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4017), "MeasuredBeamDimensionA", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4018), "MeasuredBeamDimensionB", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4019), "LocationOfMeasuredBeamDiameter", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x401A), "NominalFrequency", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x401B), "MeasuredCenterFrequency", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x401C), "MeasuredBandwidth", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4020), "PulserSettingsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4022), "PulseWidth", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4024), "ExcitationFrequency", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4026), "ModulationType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4028), "Damping", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4030), "ReceiverSettingsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4031), "AcquiredSoundpathLength", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4032), "AcquisitionCompressionType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4033), "AcquisitionSampleSize", "IS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4034), "RectifierSmoothing", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4035), "DACSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4036), "DACType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4038), "DACGainPoints", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x403A), "DACTimePoints", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x403C), "DACAmplitude", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4040), "PreAmplifierSettingsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4050), "TransmitTransducerSettingsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4051), "ReceiveTransducerSettingsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4052), "IncidentAngle", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4054), "CouplingTechnique", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4056), "CouplingMedium", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4057), "CouplingVelocity", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4058), "CrystalCenterLocationX", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4059), "CrystalCenterLocationZ", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x405A), "SoundPathLength", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x405C), "DelayLawIdentifier", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4060), "GateSettingsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4062), "GateThreshold", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4064), "VelocityOfSound", "DS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4070), "CalibrationSettingsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4072), "CalibrationProcedure", "ST"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4074), "ProcedureVersion", "SH"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4076), "ProcedureCreationDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x4078), "ProcedureExpirationDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x407A), "ProcedureLastModifiedDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x407C), "CalibrationTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x407E), "CalibrationDate", "DA"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x5002), "LINACEnergy", "IS"));
mAddEntry(DicomElement(DicomTag(0x0014, 0x5004), "LINACOutput", "IS"));

// group 0x0018
mAddEntry(DicomElement(DicomTag(0x0018, 0x0010), "ContrastBolusAgent", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0012), "ContrastBolusAgentSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0014), "ContrastBolusAdministrationRouteSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0015), "BodyPartExamined", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0020), "ScanningSequence", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0021), "SequenceVariant", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0022), "ScanOptions", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0023), "MRAcquisitionType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0024), "SequenceName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0025), "AngioFlag", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0026), "InterventionDrugInformationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0027), "InterventionDrugStopTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0028), "InterventionDrugDose", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0029), "InterventionDrugCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x002A), "AdditionalDrugSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0031), "Radiopharmaceutical", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0034), "InterventionDrugName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0035), "InterventionDrugStartTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0036), "InterventionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0038), "InterventionStatus", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x003A), "InterventionDescription", "ST"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0040), "CineRate", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0042), "InitialCineRunState", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0050), "SliceThickness", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0060), "KVP", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0070), "CountsAccumulated", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0071), "AcquisitionTerminationCondition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0072), "EffectiveDuration", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0073), "AcquisitionStartCondition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0074), "AcquisitionStartConditionData", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0075), "AcquisitionTerminationConditionData", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0080), "RepetitionTime", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0081), "EchoTime", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0082), "InversionTime", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0083), "NumberOfAverages", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0084), "ImagingFrequency", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0085), "ImagedNucleus", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0086), "EchoNumbers", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0087), "MagneticFieldStrength", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0088), "SpacingBetweenSlices", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0089), "NumberOfPhaseEncodingSteps", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0090), "DataCollectionDiameter", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0091), "EchoTrainLength", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0093), "PercentSampling", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0094), "PercentPhaseFieldOfView", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x0095), "PixelBandwidth", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1000), "DeviceSerialNumber", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1002), "DeviceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1003), "DeviceID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1004), "PlateID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1005), "GeneratorID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1006), "GridID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1007), "CassetteID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1008), "GantryID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1010), "SecondaryCaptureDeviceID", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1012), "DateOfSecondaryCapture", "DA"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1014), "TimeOfSecondaryCapture", "TM"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1016), "SecondaryCaptureDeviceManufacturer", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1018), "SecondaryCaptureDeviceManufacturerModelName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1019), "SecondaryCaptureDeviceSoftwareVersions", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1020), "SoftwareVersions", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1022), "VideoImageFormatAcquired", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1023), "DigitalImageFormatAcquired", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1030), "ProtocolName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1040), "ContrastBolusRoute", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1041), "ContrastBolusVolume", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1042), "ContrastBolusStartTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1043), "ContrastBolusStopTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1044), "ContrastBolusTotalDose", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1045), "SyringeCounts", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1046), "ContrastFlowRate", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1047), "ContrastFlowDuration", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1048), "ContrastBolusIngredient", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1049), "ContrastBolusIngredientConcentration", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1050), "SpatialResolution", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1060), "TriggerTime", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1061), "TriggerSourceOrType", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1062), "NominalInterval", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1063), "FrameTime", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1064), "CardiacFramingType", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1065), "FrameTimeVector", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1066), "FrameDelay", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1067), "ImageTriggerDelay", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1068), "MultiplexGroupTimeOffset", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1069), "TriggerTimeOffset", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x106A), "SynchronizationTrigger", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x106C), "SynchronizationChannel", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x106E), "TriggerSamplePosition", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1070), "RadiopharmaceuticalRoute", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1071), "RadiopharmaceuticalVolume", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1072), "RadiopharmaceuticalStartTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1073), "RadiopharmaceuticalStopTime", "TM"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1074), "RadionuclideTotalDose", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1075), "RadionuclideHalfLife", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1076), "RadionuclidePositronFraction", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1077), "RadiopharmaceuticalSpecificActivity", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1078), "RadiopharmaceuticalStartDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1079), "RadiopharmaceuticalStopDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1080), "BeatRejectionFlag", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1081), "LowRRValue", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1082), "HighRRValue", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1083), "IntervalsAcquired", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1084), "IntervalsRejected", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1085), "PVCRejection", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1086), "SkipBeats", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1088), "HeartRate", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1090), "CardiacNumberOfImages", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1094), "TriggerWindow", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1100), "ReconstructionDiameter", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1110), "DistanceSourceToDetector", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1111), "DistanceSourceToPatient", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1114), "EstimatedRadiographicMagnificationFactor", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1120), "GantryDetectorTilt", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1121), "GantryDetectorSlew", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1130), "TableHeight", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1131), "TableTraverse", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1134), "TableMotion", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1135), "TableVerticalIncrement", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1136), "TableLateralIncrement", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1137), "TableLongitudinalIncrement", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1138), "TableAngle", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x113A), "TableType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1140), "RotationDirection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1142), "RadialPosition", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1143), "ScanArc", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1144), "AngularStep", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1145), "CenterOfRotationOffset", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1147), "FieldOfViewShape", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1149), "FieldOfViewDimensions", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1150), "ExposureTime", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1151), "XRayTubeCurrent", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1152), "Exposure", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1153), "ExposureInuAs", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1154), "AveragePulseWidth", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1155), "RadiationSetting", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1156), "RectificationType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x115A), "RadiationMode", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x115E), "ImageAndFluoroscopyAreaDoseProduct", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1160), "FilterType", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1161), "TypeOfFilters", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1162), "IntensifierSize", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1164), "ImagerPixelSpacing", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1166), "Grid", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1170), "GeneratorPower", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1180), "CollimatorGridName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1181), "CollimatorType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1182), "FocalDistance", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1183), "XFocusCenter", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1184), "YFocusCenter", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1190), "FocalSpots", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1191), "AnodeTargetMaterial", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x11A0), "BodyPartThickness", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x11A2), "CompressionForce", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1200), "DateOfLastCalibration", "DA"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1201), "TimeOfLastCalibration", "TM"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1210), "ConvolutionKernel", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1242), "ActualFrameDuration", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1243), "CountRate", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1244), "PreferredPlaybackSequencing", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1250), "ReceiveCoilName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1251), "TransmitCoilName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1260), "PlateType", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1261), "PhosphorType", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1300), "ScanVelocity", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1301), "WholeBodyTechnique", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1302), "ScanLength", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1310), "AcquisitionMatrix", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1312), "InPlanePhaseEncodingDirection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1314), "FlipAngle", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1315), "VariableFlipAngleFlag", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1316), "SAR", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1318), "dBdt", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1400), "AcquisitionDeviceProcessingDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1401), "AcquisitionDeviceProcessingCode", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1402), "CassetteOrientation", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1403), "CassetteSize", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1404), "ExposuresOnPlate", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1405), "RelativeXRayExposure", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1411), "ExposureIndex", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1412), "TargetExposureIndex", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1413), "DeviationIndex", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1450), "ColumnAngulation", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1460), "TomoLayerHeight", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1470), "TomoAngle", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1480), "TomoTime", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1490), "TomoType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1491), "TomoClass", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1495), "NumberOfTomosynthesisSourceImages", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1500), "PositionerMotion", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1508), "PositionerType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1510), "PositionerPrimaryAngle", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1511), "PositionerSecondaryAngle", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1520), "PositionerPrimaryAngleIncrement", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1521), "PositionerSecondaryAngleIncrement", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1530), "DetectorPrimaryAngle", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1531), "DetectorSecondaryAngle", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1600), "ShutterShape", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1602), "ShutterLeftVerticalEdge", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1604), "ShutterRightVerticalEdge", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1606), "ShutterUpperHorizontalEdge", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1608), "ShutterLowerHorizontalEdge", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1610), "CenterOfCircularShutter", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1612), "RadiusOfCircularShutter", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1620), "VerticesOfThePolygonalShutter", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1622), "ShutterPresentationValue", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1623), "ShutterOverlayGroup", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1624), "ShutterPresentationColorCIELabValue", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1700), "CollimatorShape", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1702), "CollimatorLeftVerticalEdge", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1704), "CollimatorRightVerticalEdge", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1706), "CollimatorUpperHorizontalEdge", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1708), "CollimatorLowerHorizontalEdge", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1710), "CenterOfCircularCollimator", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1712), "RadiusOfCircularCollimator", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1720), "VerticesOfThePolygonalCollimator", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1800), "AcquisitionTimeSynchronized", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1801), "TimeSource", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1802), "TimeDistributionProtocol", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x1803), "NTPSourceAddress", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x2001), "PageNumberVector", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x2002), "FrameLabelVector", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x2003), "FramePrimaryAngleVector", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x2004), "FrameSecondaryAngleVector", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x2005), "SliceLocationVector", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x2006), "DisplayWindowLabelVector", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x2010), "NominalScannedPixelSpacing", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x2020), "DigitizingDeviceTransportDirection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x2030), "RotationOfScannedFilm", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x3100), "IVUSAcquisition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x3101), "IVUSPullbackRate", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x3102), "IVUSGatedRate", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x3103), "IVUSPullbackStartFrameNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x3104), "IVUSPullbackStopFrameNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x3105), "LesionNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5000), "OutputPower", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5010), "TransducerData", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5012), "FocusDepth", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5020), "ProcessingFunction", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5022), "MechanicalIndex", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5024), "BoneThermalIndex", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5026), "CranialThermalIndex", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5027), "SoftTissueThermalIndex", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5028), "SoftTissueFocusThermalIndex", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5029), "SoftTissueSurfaceThermalIndex", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5050), "DepthOfScanField", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5100), "PatientPosition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5101), "ViewPosition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x5104), "ProjectionEponymousNameCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6000), "Sensitivity", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6011), "SequenceOfUltrasoundRegions", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6012), "RegionSpatialFormat", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6014), "RegionDataType", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6016), "RegionFlags", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6018), "RegionLocationMinX0", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x601A), "RegionLocationMinY0", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x601C), "RegionLocationMaxX1", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x601E), "RegionLocationMaxY1", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6020), "ReferencePixelX0", "SL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6022), "ReferencePixelY0", "SL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6024), "PhysicalUnitsXDirection", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6026), "PhysicalUnitsYDirection", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6028), "ReferencePixelPhysicalValueX", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x602A), "ReferencePixelPhysicalValueY", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x602C), "PhysicalDeltaX", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x602E), "PhysicalDeltaY", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6030), "TransducerFrequency", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6031), "TransducerType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6032), "PulseRepetitionFrequency", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6034), "DopplerCorrectionAngle", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6036), "SteeringAngle", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6039), "DopplerSampleVolumeXPosition", "SL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x603B), "DopplerSampleVolumeYPosition", "SL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x603D), "TMLinePositionX0", "SL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x603F), "TMLinePositionY0", "SL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6041), "TMLinePositionX1", "SL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6043), "TMLinePositionY1", "SL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6044), "PixelComponentOrganization", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6046), "PixelComponentMask", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6048), "PixelComponentRangeStart", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x604A), "PixelComponentRangeStop", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x604C), "PixelComponentPhysicalUnits", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x604E), "PixelComponentDataType", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6050), "NumberOfTableBreakPoints", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6052), "TableOfXBreakPoints", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6054), "TableOfYBreakPoints", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6056), "NumberOfTableEntries", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6058), "TableOfPixelValues", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x605A), "TableOfParameterValues", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x6060), "RWaveTimeVector", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7000), "DetectorConditionsNominalFlag", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7001), "DetectorTemperature", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7004), "DetectorType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7005), "DetectorConfiguration", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7006), "DetectorDescription", "LT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7008), "DetectorMode", "LT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x700A), "DetectorID", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x700C), "DateOfLastDetectorCalibration", "DA"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x700E), "TimeOfLastDetectorCalibration", "TM"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7010), "ExposuresOnDetectorSinceLastCalibration", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7011), "ExposuresOnDetectorSinceManufactured", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7012), "DetectorTimeSinceLastExposure", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7014), "DetectorActiveTime", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7016), "DetectorActivationOffsetFromExposure", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x701A), "DetectorBinning", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7020), "DetectorElementPhysicalSize", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7022), "DetectorElementSpacing", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7024), "DetectorActiveShape", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7026), "DetectorActiveDimensions", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7028), "DetectorActiveOrigin", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x702A), "DetectorManufacturerName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x702B), "DetectorManufacturerModelName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7030), "FieldOfViewOrigin", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7032), "FieldOfViewRotation", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7034), "FieldOfViewHorizontalFlip", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7036), "PixelDataAreaOriginRelativeToFOV", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7038), "PixelDataAreaRotationAngleRelativeToFOV", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7040), "GridAbsorbingMaterial", "LT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7041), "GridSpacingMaterial", "LT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7042), "GridThickness", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7044), "GridPitch", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7046), "GridAspectRatio", "IS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7048), "GridPeriod", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x704C), "GridFocalDistance", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7050), "FilterMaterial", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7052), "FilterThicknessMinimum", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7054), "FilterThicknessMaximum", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7056), "FilterBeamPathLengthMinimum", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7058), "FilterBeamPathLengthMaximum", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7060), "ExposureControlMode", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7062), "ExposureControlModeDescription", "LT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7064), "ExposureStatus", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x7065), "PhototimerSetting", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x8150), "ExposureTimeInuS", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x8151), "XRayTubeCurrentInuA", "DS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9004), "ContentQualification", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9005), "PulseSequenceName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9006), "MRImagingModifierSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9008), "EchoPulseSequence", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9009), "InversionRecovery", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9010), "FlowCompensation", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9011), "MultipleSpinEcho", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9012), "MultiPlanarExcitation", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9014), "PhaseContrast", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9015), "TimeOfFlightContrast", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9016), "Spoiling", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9017), "SteadyStatePulseSequence", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9018), "EchoPlanarPulseSequence", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9019), "TagAngleFirstAxis", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9020), "MagnetizationTransfer", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9021), "T2Preparation", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9022), "BloodSignalNulling", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9024), "SaturationRecovery", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9025), "SpectrallySelectedSuppression", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9026), "SpectrallySelectedExcitation", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9027), "SpatialPresaturation", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9028), "Tagging", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9029), "OversamplingPhase", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9030), "TagSpacingFirstDimension", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9032), "GeometryOfKSpaceTraversal", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9033), "SegmentedKSpaceTraversal", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9034), "RectilinearPhaseEncodeReordering", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9035), "TagThickness", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9036), "PartialFourierDirection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9037), "CardiacSynchronizationTechnique", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9041), "ReceiveCoilManufacturerName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9042), "MRReceiveCoilSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9043), "ReceiveCoilType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9044), "QuadratureReceiveCoil", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9045), "MultiCoilDefinitionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9046), "MultiCoilConfiguration", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9047), "MultiCoilElementName", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9048), "MultiCoilElementUsed", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9049), "MRTransmitCoilSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9050), "TransmitCoilManufacturerName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9051), "TransmitCoilType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9052), "SpectralWidth", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9053), "ChemicalShiftReference", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9054), "VolumeLocalizationTechnique", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9058), "MRAcquisitionFrequencyEncodingSteps", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9059), "Decoupling", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9060), "DecoupledNucleus", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9061), "DecouplingFrequency", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9062), "DecouplingMethod", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9063), "DecouplingChemicalShiftReference", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9064), "KSpaceFiltering", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9065), "TimeDomainFiltering", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9066), "NumberOfZeroFills", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9067), "BaselineCorrection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9069), "ParallelReductionFactorInPlane", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9070), "CardiacRRIntervalSpecified", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9073), "AcquisitionDuration", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9074), "FrameAcquisitionDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9075), "DiffusionDirectionality", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9076), "DiffusionGradientDirectionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9077), "ParallelAcquisition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9078), "ParallelAcquisitionTechnique", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9079), "InversionTimes", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9080), "MetaboliteMapDescription", "ST"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9081), "PartialFourier", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9082), "EffectiveEchoTime", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9083), "MetaboliteMapCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9084), "ChemicalShiftSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9085), "CardiacSignalSource", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9087), "DiffusionBValue", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9089), "DiffusionGradientOrientation", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9090), "VelocityEncodingDirection", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9091), "VelocityEncodingMinimumValue", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9092), "VelocityEncodingAcquisitionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9093), "NumberOfKSpaceTrajectories", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9094), "CoverageOfKSpace", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9095), "SpectroscopyAcquisitionPhaseRows", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9098), "TransmitterFrequency", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9100), "ResonantNucleus", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9101), "FrequencyCorrection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9103), "MRSpectroscopyFOVGeometrySequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9104), "SlabThickness", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9105), "SlabOrientation", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9106), "MidSlabPosition", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9107), "MRSpatialSaturationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9112), "MRTimingAndRelatedParametersSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9114), "MREchoSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9115), "MRModifierSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9117), "MRDiffusionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9118), "CardiacSynchronizationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9119), "MRAveragesSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9125), "MRFOVGeometrySequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9126), "VolumeLocalizationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9127), "SpectroscopyAcquisitionDataColumns", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9147), "DiffusionAnisotropyType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9151), "FrameReferenceDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9152), "MRMetaboliteMapSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9155), "ParallelReductionFactorOutOfPlane", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9159), "SpectroscopyAcquisitionOutOfPlanePhaseSteps", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9168), "ParallelReductionFactorSecondInPlane", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9169), "CardiacBeatRejectionTechnique", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9170), "RespiratoryMotionCompensationTechnique", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9171), "RespiratorySignalSource", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9172), "BulkMotionCompensationTechnique", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9173), "BulkMotionSignalSource", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9174), "ApplicableSafetyStandardAgency", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9175), "ApplicableSafetyStandardDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9176), "OperatingModeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9177), "OperatingModeType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9178), "OperatingMode", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9179), "SpecificAbsorptionRateDefinition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9180), "GradientOutputType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9181), "SpecificAbsorptionRateValue", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9182), "GradientOutput", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9183), "FlowCompensationDirection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9184), "TaggingDelay", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9185), "RespiratoryMotionCompensationTechniqueDescription", "ST"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9186), "RespiratorySignalSourceID", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9197), "MRVelocityEncodingSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9198), "FirstOrderPhaseCorrection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9199), "WaterReferencedPhaseCorrection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9200), "MRSpectroscopyAcquisitionType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9214), "RespiratoryCyclePosition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9217), "VelocityEncodingMaximumValue", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9218), "TagSpacingSecondDimension", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9219), "TagAngleSecondAxis", "SS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9220), "FrameAcquisitionDuration", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9226), "MRImageFrameTypeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9227), "MRSpectroscopyFrameTypeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9231), "MRAcquisitionPhaseEncodingStepsInPlane", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9232), "MRAcquisitionPhaseEncodingStepsOutOfPlane", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9234), "SpectroscopyAcquisitionPhaseColumns", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9236), "CardiacCyclePosition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9239), "SpecificAbsorptionRateSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9240), "RFEchoTrainLength", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9241), "GradientEchoTrainLength", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9250), "ArterialSpinLabelingContrast", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9251), "MRArterialSpinLabelingSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9252), "ASLTechniqueDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9253), "ASLSlabNumber", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9254), "ASLSlabThickness", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9255), "ASLSlabOrientation", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9256), "ASLMidSlabPosition", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9257), "ASLContext", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9258), "ASLPulseTrainDuration", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9259), "ASLCrusherFlag", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x925A), "ASLCrusherFlow", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x925B), "ASLCrusherDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x925C), "ASLBolusCutoffFlag", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x925D), "ASLBolusCutoffTimingSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x925E), "ASLBolusCutoffTechnique", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x925F), "ASLBolusCutoffDelayTime", "UL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9260), "ASLSlabSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9295), "ChemicalShiftMinimumIntegrationLimitInppm", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9296), "ChemicalShiftMaximumIntegrationLimitInppm", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9301), "CTAcquisitionTypeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9302), "AcquisitionType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9303), "TubeAngle", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9304), "CTAcquisitionDetailsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9305), "RevolutionTime", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9306), "SingleCollimationWidth", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9307), "TotalCollimationWidth", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9308), "CTTableDynamicsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9309), "TableSpeed", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9310), "TableFeedPerRotation", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9311), "SpiralPitchFactor", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9312), "CTGeometrySequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9313), "DataCollectionCenterPatient", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9314), "CTReconstructionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9315), "ReconstructionAlgorithm", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9316), "ConvolutionKernelGroup", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9317), "ReconstructionFieldOfView", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9318), "ReconstructionTargetCenterPatient", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9319), "ReconstructionAngle", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9320), "ImageFilter", "SH"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9321), "CTExposureSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9322), "ReconstructionPixelSpacing", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9323), "ExposureModulationType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9324), "EstimatedDoseSaving", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9325), "CTXRayDetailsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9326), "CTPositionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9327), "TablePosition", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9328), "ExposureTimeInms", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9329), "CTImageFrameTypeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9330), "XRayTubeCurrentInmA", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9332), "ExposureInmAs", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9333), "ConstantVolumeFlag", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9334), "FluoroscopyFlag", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9335), "DistanceSourceToDataCollectionCenter", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9337), "ContrastBolusAgentNumber", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9338), "ContrastBolusIngredientCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9340), "ContrastAdministrationProfileSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9341), "ContrastBolusUsageSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9342), "ContrastBolusAgentAdministered", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9343), "ContrastBolusAgentDetected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9344), "ContrastBolusAgentPhase", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9345), "CTDIvol", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9346), "CTDIPhantomTypeCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9351), "CalciumScoringMassFactorPatient", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9352), "CalciumScoringMassFactorDevice", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9353), "EnergyWeightingFactor", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9360), "CTAdditionalXRaySourceSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9401), "ProjectionPixelCalibrationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9402), "DistanceSourceToIsocenter", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9403), "DistanceObjectToTableTop", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9404), "ObjectPixelSpacingInCenterOfBeam", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9405), "PositionerPositionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9406), "TablePositionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9407), "CollimatorShapeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9410), "PlanesInAcquisition", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9412), "XAXRFFrameCharacteristicsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9417), "FrameAcquisitionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9420), "XRayReceptorType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9423), "AcquisitionProtocolName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9424), "AcquisitionProtocolDescription", "LT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9425), "ContrastBolusIngredientOpaque", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9426), "DistanceReceptorPlaneToDetectorHousing", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9427), "IntensifierActiveShape", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9428), "IntensifierActiveDimensions", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9429), "PhysicalDetectorSize", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9430), "PositionOfIsocenterProjection", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9432), "FieldOfViewSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9433), "FieldOfViewDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9434), "ExposureControlSensingRegionsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9435), "ExposureControlSensingRegionShape", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9436), "ExposureControlSensingRegionLeftVerticalEdge", "SS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9437), "ExposureControlSensingRegionRightVerticalEdge", "SS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9438), "ExposureControlSensingRegionUpperHorizontalEdge", "SS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9439), "ExposureControlSensingRegionLowerHorizontalEdge", "SS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9440), "CenterOfCircularExposureControlSensingRegion", "SS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9441), "RadiusOfCircularExposureControlSensingRegion", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9442), "VerticesOfThePolygonalExposureControlSensingRegion", "SS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9447), "ColumnAngulationPatient", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9449), "BeamAngle", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9451), "FrameDetectorParametersSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9452), "CalculatedAnatomyThickness", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9455), "CalibrationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9456), "ObjectThicknessSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9457), "PlaneIdentification", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9461), "FieldOfViewDimensionsInFloat", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9462), "IsocenterReferenceSystemSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9463), "PositionerIsocenterPrimaryAngle", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9464), "PositionerIsocenterSecondaryAngle", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9465), "PositionerIsocenterDetectorRotationAngle", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9466), "TableXPositionToIsocenter", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9467), "TableYPositionToIsocenter", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9468), "TableZPositionToIsocenter", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9469), "TableHorizontalRotationAngle", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9470), "TableHeadTiltAngle", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9471), "TableCradleTiltAngle", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9472), "FrameDisplayShutterSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9473), "AcquiredImageAreaDoseProduct", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9474), "CArmPositionerTabletopRelationship", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9476), "XRayGeometrySequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9477), "IrradiationEventIdentificationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9504), "XRay3DFrameTypeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9506), "ContributingSourcesSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9507), "XRay3DAcquisitionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9508), "PrimaryPositionerScanArc", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9509), "SecondaryPositionerScanArc", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9510), "PrimaryPositionerScanStartAngle", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9511), "SecondaryPositionerScanStartAngle", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9514), "PrimaryPositionerIncrement", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9515), "SecondaryPositionerIncrement", "FL"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9516), "StartAcquisitionDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9517), "EndAcquisitionDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9524), "ApplicationName", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9525), "ApplicationVersion", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9526), "ApplicationManufacturer", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9527), "AlgorithmType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9528), "AlgorithmDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9530), "XRay3DReconstructionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9531), "ReconstructionDescription", "LO"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9538), "PerProjectionAcquisitionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9601), "DiffusionBMatrixSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9602), "DiffusionBValueXX", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9603), "DiffusionBValueXY", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9604), "DiffusionBValueXZ", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9605), "DiffusionBValueYY", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9606), "DiffusionBValueYZ", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9607), "DiffusionBValueZZ", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9701), "DecayCorrectionDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9715), "StartDensityThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9716), "StartRelativeDensityDifferenceThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9717), "StartCardiacTriggerCountThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9718), "StartRespiratoryTriggerCountThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9719), "TerminationCountsThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9720), "TerminationDensityThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9721), "TerminationRelativeDensityThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9722), "TerminationTimeThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9723), "TerminationCardiacTriggerCountThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9724), "TerminationRespiratoryTriggerCountThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9725), "DetectorGeometry", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9726), "TransverseDetectorSeparation", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9727), "AxialDetectorDimension", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9729), "RadiopharmaceuticalAgentNumber", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9732), "PETFrameAcquisitionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9733), "PETDetectorMotionDetailsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9734), "PETTableDynamicsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9735), "PETPositionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9736), "PETFrameCorrectionFactorsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9737), "RadiopharmaceuticalUsageSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9738), "AttenuationCorrectionSource", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9739), "NumberOfIterations", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9740), "NumberOfSubsets", "US"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9749), "PETReconstructionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9751), "PETFrameTypeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9755), "TimeOfFlightInformationUsed", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9756), "ReconstructionType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9758), "DecayCorrected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9759), "AttenuationCorrected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9760), "ScatterCorrected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9761), "DeadTimeCorrected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9762), "GantryMotionCorrected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9763), "PatientMotionCorrected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9764), "CountLossNormalizationCorrected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9765), "RandomsCorrected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9766), "NonUniformRadialSamplingCorrected", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9767), "SensitivityCalibrated", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9768), "DetectorNormalizationCorrection", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9769), "IterativeReconstructionMethod", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9770), "AttenuationCorrectionTemporalRelationship", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9771), "PatientPhysiologicalStateSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9772), "PatientPhysiologicalStateCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9801), "DepthsOfFocus", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9803), "ExcludedIntervalsSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9804), "ExclusionStartDatetime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9805), "ExclusionDuration", "FD"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9806), "USImageDescriptionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9807), "ImageDataTypeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9808), "DataType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x9809), "TransducerScanPatternCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x980B), "AliasedDataType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x980C), "PositionMeasuringDeviceUsed", "CS"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x980D), "TransducerGeometryCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x980E), "TransducerBeamSteeringCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0x980F), "TransducerApplicationCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0xA001), "ContributingEquipmentSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0018, 0xA002), "ContributionDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0018, 0xA003), "ContributionDescription", "ST"));

// group 0x0020
mAddEntry(DicomElement(DicomTag(0x0020, 0x000D), "StudyInstanceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x000E), "SeriesInstanceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0010), "StudyID", "SH"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0011), "SeriesNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0012), "AcquisitionNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0013), "InstanceNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0019), "ItemNumber", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0020), "PatientOrientation", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0032), "ImagePositionPatient", "DS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0037), "ImageOrientationPatient", "DS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0052), "FrameOfReferenceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0060), "Laterality", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0062), "ImageLaterality", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0100), "TemporalPositionIdentifier", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0105), "NumberOfTemporalPositions", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0110), "TemporalResolution", "DS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0200), "SynchronizationFrameOfReferenceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x0242), "SOPInstanceUIDOfConcatenationSource", "UI"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x1002), "ImagesInAcquisition", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x1040), "PositionReferenceIndicator", "LO"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x1041), "SliceLocation", "DS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x1200), "NumberOfPatientRelatedStudies", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x1202), "NumberOfPatientRelatedSeries", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x1204), "NumberOfPatientRelatedInstances", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x1206), "NumberOfStudyRelatedSeries", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x1208), "NumberOfStudyRelatedInstances", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x1209), "NumberOfSeriesRelatedInstances", "IS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x4000), "ImageComments", "LT"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9056), "StackID", "SH"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9057), "InStackPositionNumber", "UL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9071), "FrameAnatomySequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9072), "FrameLaterality", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9111), "FrameContentSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9113), "PlanePositionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9116), "PlaneOrientationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9128), "TemporalPositionIndex", "UL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9153), "NominalCardiacTriggerDelayTime", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9154), "NominalCardiacTriggerTimePriorToRPeak", "FL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9155), "ActualCardiacTriggerTimePriorToRPeak", "FL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9156), "FrameAcquisitionNumber", "US"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9157), "DimensionIndexValues", "UL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9158), "FrameComments", "LT"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9161), "ConcatenationUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9162), "InConcatenationNumber", "US"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9163), "InConcatenationTotalNumber", "US"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9164), "DimensionOrganizationUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9165), "DimensionIndexPointer", "AT"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9167), "FunctionalGroupPointer", "AT"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9213), "DimensionIndexPrivateCreator", "LO"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9221), "DimensionOrganizationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9222), "DimensionIndexSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9228), "ConcatenationFrameOffsetNumber", "UL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9238), "FunctionalGroupPrivateCreator", "LO"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9241), "NominalPercentageOfCardiacPhase", "FL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9245), "NominalPercentageOfRespiratoryPhase", "FL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9246), "StartingRespiratoryAmplitude", "FL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9247), "StartingRespiratoryPhase", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9248), "EndingRespiratoryAmplitude", "FL"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9249), "EndingRespiratoryPhase", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9250), "RespiratoryTriggerType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9251), "RRIntervalTimeNominal", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9252), "ActualCardiacTriggerDelayTime", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9253), "RespiratorySynchronizationSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9254), "RespiratoryIntervalTime", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9255), "NominalRespiratoryTriggerDelayTime", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9256), "RespiratoryTriggerDelayThreshold", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9257), "ActualRespiratoryTriggerDelayTime", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9301), "ImagePositionVolume", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9302), "ImageOrientationVolume", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9307), "UltrasoundAcquisitionGeometry", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9308), "ApexPosition", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9309), "VolumeToTransducerMappingMatrix", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x930A), "VolumeToTableMappingMatrix", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x930C), "PatientFrameOfReferenceSource", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x930D), "TemporalPositionTimeOffset", "FD"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x930E), "PlanePositionVolumeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x930F), "PlaneOrientationVolumeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9310), "TemporalPositionSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9311), "DimensionOrganizationType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9312), "VolumeFrameOfReferenceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9313), "TableFrameOfReferenceUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9421), "DimensionDescriptionLabel", "LO"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9450), "PatientOrientationInFrameSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9453), "FrameLabel", "LO"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9518), "AcquisitionIndex", "US"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9529), "ContributingSOPInstancesReferenceSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0020, 0x9536), "ReconstructionIndex", "US"));

// group 0x0022, etc
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0001 ), "LightPathFilterPassThroughWavelength", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0002 ), "LightPathFilterPassBand", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0003 ), "ImagePathFilterPassThroughWavelength", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0004 ), "ImagePathFilterPassBand", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0005 ), "PatientEyeMovementCommanded", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0006 ), "PatientEyeMovementCommandCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0007 ), "SphericalLensPower", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0008 ), "CylinderLensPower", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0009 ), "CylinderAxis", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x000A ), "EmmetropicMagnification", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x000B ), "IntraOcularPressure", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x000C ), "HorizontalFieldOfView", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x000D ), "PupilDilated", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x000E ), "DegreeOfDilation", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0010 ), "StereoBaselineAngle", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0011 ), "StereoBaselineDisplacement", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0012 ), "StereoHorizontalPixelOffset", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0013 ), "StereoVerticalPixelOffset", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0014 ), "StereoRotation", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0015 ), "AcquisitionDeviceTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0016 ), "IlluminationTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0017 ), "LightPathFilterTypeStackCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0018 ), "ImagePathFilterTypeStackCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0019 ), "LensesCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x001A ), "ChannelDescriptionCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x001B ), "RefractiveStateSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x001C ), "MydriaticAgentCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x001D ), "RelativeImagePositionCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x001E ), "CameraAngleOfView", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0020 ), "StereoPairsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0021 ), "LeftImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0022 ), "RightImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0030 ), "AxialLengthOfTheEye", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0031 ), "OphthalmicFrameLocationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0032 ), "ReferenceCoordinates", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0035 ), "DepthSpatialResolution", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0036 ), "MaximumDepthDistortion", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0037 ), "AlongScanSpatialResolution", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0038 ), "MaximumAlongScanDistortion", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0039 ), "OphthalmicImageOrientation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0041 ), "DepthOfTransverseImage", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0042 ), "MydriaticAgentConcentrationUnitsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0048 ), "AcrossScanSpatialResolution", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0049 ), "MaximumAcrossScanDistortion", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x004E ), "MydriaticAgentConcentration", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0055 ), "IlluminationWaveLength", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0056 ), "IlluminationPower", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0057 ), "IlluminationBandwidth", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x0058 ), "MydriaticAgentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1007 ), "OphthalmicAxialMeasurementsRightEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1008 ), "OphthalmicAxialMeasurementsLeftEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1010 ), "OphthalmicAxialLengthMeasurementsType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1019 ), "OphthalmicAxialLength", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1024 ), "LensStatusCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1025 ), "VitreousStatusCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1028 ), "IOLFormulaCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1029 ), "IOLFormulaDetail", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1033 ), "KeratometerIndex", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1035 ), "SourceOfOphthalmicAxialLengthCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1037 ), "TargetRefraction", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1039 ), "RefractiveProcedureOccurred", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1040 ), "RefractiveSurgeryTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1044 ), "OphthalmicUltrasoundAxialMeasurementsTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1050 ), "OphthalmicAxialLengthMeasurementsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1053 ), "IOLPower", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1054 ), "PredictedRefractiveError", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1059 ), "OphthalmicAxialLengthVelocity", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1065 ), "LensStatusDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1066 ), "VitreousStatusDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1090 ), "IOLPowerSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1092 ), "LensConstantSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1093 ), "IOLManufacturer", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1094 ), "LensConstantDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1096 ), "KeratometryMeasurementTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1100 ), "ReferencedOphthalmicAxialMeasurementsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1101 ), "OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1103 ), "RefractiveErrorBeforeRefractiveSurgeryCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1121 ), "IOLPowerForExactEmmetropia", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1122 ), "IOLPowerForExactTargetRefraction", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1125 ), "AnteriorChamberDepthDefinitionCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1130 ), "LensThickness", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1131 ), "AnteriorChamberDepth", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1132 ), "SourceOfLensThicknessDataCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1133 ), "SourceOfAnteriorChamberDepthDataCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1135 ), "SourceOfRefractiveErrorDataCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1140 ), "OphthalmicAxialLengthMeasurementModified", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1150 ), "OphthalmicAxialLengthDataSourceCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1153 ), "OphthalmicAxialLengthAcquisitionMethodCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1155 ), "SignalToNoiseRatio", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1159 ), "OphthalmicAxialLengthDataSourceDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1210 ), "OphthalmicAxialLengthMeasurementsTotalLengthSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1211 ), "OphthalmicAxialLengthMeasurementsSegmentalLengthSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1212 ), "OphthalmicAxialLengthMeasurementsLengthSummationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1220 ), "UltrasoundOphthalmicAxialLengthMeasurementsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1225 ), "OpticalOphthalmicAxialLengthMeasurementsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1230 ), "UltrasoundSelectedOphthalmicAxialLengthSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1250 ), "OphthalmicAxialLengthSelectionMethodCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1255 ), "OpticalSelectedOphthalmicAxialLengthSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1257 ), "SelectedSegmentalOphthalmicAxialLengthSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1260 ), "SelectedTotalOphthalmicAxialLengthSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1262 ), "OphthalmicAxialLengthQualityMetricSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1273 ), "OphthalmicAxialLengthQualityMetricTypeDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1300 ), "IntraocularLensCalculationsRightEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1310 ), "IntraocularLensCalculationsLeftEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0022, 0x1330 ), "ReferencedOphthalmicAxialLengthMeasurementQCImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0010 ), "VisualFieldHorizontalExtent", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0011 ), "VisualFieldVerticalExtent", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0012 ), "VisualFieldShape", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0016 ), "ScreeningTestModeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0018 ), "MaximumStimulusLuminance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0020 ), "BackgroundLuminance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0021 ), "StimulusColorCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0024 ), "BackgroundIlluminationColorCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0025 ), "StimulusArea", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0028 ), "StimulusPresentationTime", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0032 ), "FixationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0033 ), "FixationMonitoringCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0034 ), "VisualFieldCatchTrialSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0035 ), "FixationCheckedQuantity", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0036 ), "PatientNotProperlyFixatedQuantity", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0037 ), "PresentedVisualStimuliDataFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0038 ), "NumberOfVisualStimuli", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0039 ), "ExcessiveFixationLossesDataFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0040 ), "ExcessiveFixationLosses", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0042 ), "StimuliRetestingQuantity", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0044 ), "CommentsOnPatientPerformanceOfVisualField", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0045 ), "FalseNegativesEstimateFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0046 ), "FalseNegativesEstimate", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0048 ), "NegativeCatchTrialsQuantity", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0050 ), "FalseNegativesQuantity", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0051 ), "ExcessiveFalseNegativesDataFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0052 ), "ExcessiveFalseNegatives", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0053 ), "FalsePositivesEstimateFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0054 ), "FalsePositivesEstimate", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0055 ), "CatchTrialsDataFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0056 ), "PositiveCatchTrialsQuantity", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0057 ), "TestPointNormalsDataFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0058 ), "TestPointNormalsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0059 ), "GlobalDeviationProbabilityNormalsFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0060 ), "FalsePositivesQuantity", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0061 ), "ExcessiveFalsePositivesDataFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0062 ), "ExcessiveFalsePositives", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0063 ), "VisualFieldTestNormalsFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0064 ), "ResultsNormalsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0065 ), "AgeCorrectedSensitivityDeviationAlgorithmSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0066 ), "GlobalDeviationFromNormal", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0067 ), "GeneralizedDefectSensitivityDeviationAlgorithmSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0068 ), "LocalizedDeviationfromNormal", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0069 ), "PatientReliabilityIndicator", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0070 ), "VisualFieldMeanSensitivity", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0071 ), "GlobalDeviationProbability", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0072 ), "LocalDeviationProbabilityNormalsFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0073 ), "LocalizedDeviationProbability", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0074 ), "ShortTermFluctuationCalculated", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0075 ), "ShortTermFluctuation", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0076 ), "ShortTermFluctuationProbabilityCalculated", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0077 ), "ShortTermFluctuationProbability", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0078 ), "CorrectedLocalizedDeviationFromNormalCalculated", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0079 ), "CorrectedLocalizedDeviationFromNormal", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0080 ), "CorrectedLocalizedDeviationFromNormalProbabilityCalculated", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0081 ), "CorrectedLocalizedDeviationFromNormalProbability", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0083 ), "GlobalDeviationProbabilitySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0085 ), "LocalizedDeviationProbabilitySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0086 ), "FovealSensitivityMeasured", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0087 ), "FovealSensitivity", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0088 ), "VisualFieldTestDuration", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0089 ), "VisualFieldTestPointSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0090 ), "VisualFieldTestPointXCoordinate", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0091 ), "VisualFieldTestPointYCoordinate", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0092 ), "AgeCorrectedSensitivityDeviationValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0093 ), "StimulusResults", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0094 ), "SensitivityValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0095 ), "RetestStimulusSeen", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0096 ), "RetestSensitivityValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0097 ), "VisualFieldTestPointNormalsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0098 ), "QuantifiedDefect", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0100 ), "AgeCorrectedSensitivityDeviationProbabilityValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0102 ), "GeneralizedDefectCorrectedSensitivityDeviationFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0103 ), "GeneralizedDefectCorrectedSensitivityDeviationValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0104 ), "GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0105 ), "MinimumSensitivityValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0106 ), "BlindSpotLocalized", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0107 ), "BlindSpotXCoordinate", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0108 ), "BlindSpotYCoordinate", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0110 ), "VisualAcuityMeasurementSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0112 ), "RefractiveParametersUsedOnPatientSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0113 ), "MeasurementLaterality", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0114 ), "OphthalmicPatientClinicalInformationLeftEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0115 ), "OphthalmicPatientClinicalInformationRightEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0117 ), "FovealPointNormativeDataFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0118 ), "FovealPointProbabilityValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0120 ), "ScreeningBaselineMeasured", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0122 ), "ScreeningBaselineMeasuredSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0124 ), "ScreeningBaselineType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0126 ), "ScreeningBaselineValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0202 ), "AlgorithmSource", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0306 ), "DataSetName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0307 ), "DataSetVersion", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0308 ), "DataSetSource", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0309 ), "DataSetDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0317 ), "VisualFieldTestReliabilityGlobalIndexSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0320 ), "VisualFieldGlobalResultsIndexSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0325 ), "DataObservationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0338 ), "IndexNormalsFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0341 ), "IndexProbability", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0024, 0x0344 ), "IndexProbabilitySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0002 ), "SamplesPerPixel", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0003 ), "SamplesPerPixelUsed", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0004 ), "PhotometricInterpretation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0006 ), "PlanarConfiguration", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0008 ), "NumberOfFrames", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0009 ), "FrameIncrementPointer", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x000A ), "FrameDimensionPointer", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0010 ), "Rows", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0011 ), "Columns", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0014 ), "UltrasoundColorDataPresent", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0030 ), "PixelSpacing", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0031 ), "ZoomFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0032 ), "ZoomCenter", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0034 ), "PixelAspectRatio", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0051 ), "CorrectedImage", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0100 ), "BitsAllocated", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0101 ), "BitsStored", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0102 ), "HighBit", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0103 ), "PixelRepresentation", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0106 ), "SmallestImagePixelValue", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0107 ), "LargestImagePixelValue", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0108 ), "SmallestPixelValueInSeries", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0109 ), "LargestPixelValueInSeries", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0120 ), "PixelPaddingValue", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0121 ), "PixelPaddingRangeLimit", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0300 ), "QualityControlImage", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0301 ), "BurnedInAnnotation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0302 ), "RecognizableVisualFeatures", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0303 ), "LongitudinalTemporalInformationModified", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0A02 ), "PixelSpacingCalibrationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x0A04 ), "PixelSpacingCalibrationDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1040 ), "PixelIntensityRelationship", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1041 ), "PixelIntensityRelationshipSign", "SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1050 ), "WindowCenter", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1051 ), "WindowWidth", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1052 ), "RescaleIntercept", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1053 ), "RescaleSlope", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1054 ), "RescaleType", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1055 ), "WindowCenterWidthExplanation", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1056 ), "VOILUTFunction", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1090 ), "RecommendedViewingMode", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1101 ), "RedPaletteColorLookupTableDescriptor", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1102 ), "GreenPaletteColorLookupTableDescriptor", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1103 ), "BluePaletteColorLookupTableDescriptor", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1104 ), "AlphaPaletteColorLookupTableDescriptor", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1199 ), "PaletteColorLookupTableUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1201 ), "RedPaletteColorLookupTableData", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1202 ), "GreenPaletteColorLookupTableData", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1203 ), "BluePaletteColorLookupTableData", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1204 ), "AlphaPaletteColorLookupTableData", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1221 ), "SegmentedRedPaletteColorLookupTableData", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1222 ), "SegmentedGreenPaletteColorLookupTableData", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1223 ), "SegmentedBluePaletteColorLookupTableData", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1300 ), "BreastImplantPresent", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1350 ), "PartialView", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1351 ), "PartialViewDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1352 ), "PartialViewCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x135A ), "SpatialLocationsPreserved", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1401 ), "DataFrameAssignmentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1402 ), "DataPathAssignment", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1403 ), "BitsMappedToColorLookupTable", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1404 ), "BlendingLUT1Sequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1405 ), "BlendingLUT1TransferFunction", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1406 ), "BlendingWeightConstant", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1407 ), "BlendingLookupTableDescriptor", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1408 ), "BlendingLookupTableData", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x140B ), "EnhancedPaletteColorLookupTableSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x140C ), "BlendingLUT2Sequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x140D ), "BlendingLUT2TransferFunction", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x140E ), "DataPathID", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x140F ), "RGBLUTTransferFunction", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x1410 ), "AlphaLUTTransferFunction", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x2000 ), "ICCProfile", "OB" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x2110 ), "LossyImageCompression", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x2112 ), "LossyImageCompressionRatio", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x2114 ), "LossyImageCompressionMethod", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x3000 ), "ModalityLUTSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x3002 ), "LUTDescriptor", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x3003 ), "LUTExplanation", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x3004 ), "ModalityLUTType", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x3006 ), "LUTData", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x3010 ), "VOILUTSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x3110 ), "SoftcopyVOILUTSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6010 ), "RepresentativeFrameNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6020 ), "FrameNumbersOfInterest", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6022 ), "FrameOfInterestDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6023 ), "FrameOfInterestType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6040 ), "RWavePointer", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6100 ), "MaskSubtractionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6101 ), "MaskOperation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6102 ), "ApplicableFrameRange", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6110 ), "MaskFrameNumbers", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6112 ), "ContrastFrameAveraging", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6114 ), "MaskSubPixelShift", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6120 ), "TIDOffset", "SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x6190 ), "MaskOperationExplanation", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x7FE0 ), "PixelDataProviderURL", "UT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9001 ), "DataPointRows", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9002 ), "DataPointColumns", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9003 ), "SignalDomainColumns", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9108 ), "DataRepresentation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9110 ), "PixelMeasuresSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9132 ), "FrameVOILUTSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9145 ), "PixelValueTransformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9235 ), "SignalDomainRows", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9411 ), "DisplayFilterPercentage", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9415 ), "FramePixelShiftSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9416 ), "SubtractionItemID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9422 ), "PixelIntensityRelationshipLUTSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9443 ), "FramePixelDataPropertiesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9444 ), "GeometricalProperties", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9445 ), "GeometricMaximumDistortion", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9446 ), "ImageProcessingApplied", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9454 ), "MaskSelectionMode", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9474 ), "LUTFunction", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9478 ), "MaskVisibilityPercentage", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9501 ), "PixelShiftSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9502 ), "RegionPixelShiftSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9503 ), "VerticesOfTheRegion", "SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9505 ), "MultiFramePresentationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9506 ), "PixelShiftFrameRange", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9507 ), "LUTFrameRange", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9520 ), "ImageToEquipmentMappingMatrix", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0028, 0x9537 ), "EquipmentCoordinateSystemIdentification", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1031 ), "RequestingPhysicianIdentificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1032 ), "RequestingPhysician", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1033 ), "RequestingService", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1034 ), "RequestingServiceCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1060 ), "RequestedProcedureDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1064 ), "RequestedProcedureCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0032, 0x1070 ), "RequestedContrastAgent", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0004 ), "ReferencedPatientAliasSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0008 ), "VisitStatusID", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0010 ), "AdmissionID", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0014 ), "IssuerOfAdmissionIDSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0016 ), "RouteOfAdmissions", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0020 ), "AdmittingDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0021 ), "AdmittingTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0050 ), "SpecialNeeds", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0060 ), "ServiceEpisodeID", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0062 ), "ServiceEpisodeDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0064 ), "IssuerOfServiceEpisodeIDSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0100 ), "PertinentDocumentsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0300 ), "CurrentPatientLocation", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0400 ), "PatientInstitutionResidence", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0500 ), "PatientState", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x0502 ), "PatientClinicalTrialParticipationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0038, 0x4000 ), "VisitComments", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0004 ), "WaveformOriginality", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0005 ), "NumberOfWaveformChannels", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0010 ), "NumberOfWaveformSamples", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x001A ), "SamplingFrequency", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0020 ), "MultiplexGroupLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0200 ), "ChannelDefinitionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0202 ), "WaveformChannelNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0203 ), "ChannelLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0205 ), "ChannelStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0208 ), "ChannelSourceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0209 ), "ChannelSourceModifiersSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x020A ), "SourceWaveformSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x020C ), "ChannelDerivationDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0210 ), "ChannelSensitivity", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0211 ), "ChannelSensitivityUnitsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0212 ), "ChannelSensitivityCorrectionFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0213 ), "ChannelBaseline", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0214 ), "ChannelTimeSkew", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0215 ), "ChannelSampleSkew", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0218 ), "ChannelOffset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x021A ), "WaveformBitsStored", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0220 ), "FilterLowFrequency", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0221 ), "FilterHighFrequency", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0222 ), "NotchFilterFrequency", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0223 ), "NotchFilterBandwidth", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0230 ), "WaveformDataDisplayScale", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0231 ), "WaveformDisplayBackgroundCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0240 ), "WaveformPresentationGroupSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0241 ), "PresentationGroupNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0242 ), "ChannelDisplaySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0244 ), "ChannelRecommendedDisplayCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0245 ), "ChannelPosition", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0246 ), "DisplayShadingFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0247 ), "FractionalChannelDisplayScale", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0248 ), "AbsoluteChannelDisplayScale", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0300 ), "MultiplexedAudioChannelsDescriptionCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0301 ), "ChannelIdentificationCode", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x003A, 0x0302 ), "ChannelMode", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0001 ), "ScheduledStationAETitle", "AE" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0002 ), "ScheduledProcedureStepStartDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0003 ), "ScheduledProcedureStepStartTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0004 ), "ScheduledProcedureStepEndDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0005 ), "ScheduledProcedureStepEndTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0006 ), "ScheduledPerformingPhysicianName", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0007 ), "ScheduledProcedureStepDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0008 ), "ScheduledProtocolCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0009 ), "ScheduledProcedureStepID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x000A ), "StageCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x000B ), "ScheduledPerformingPhysicianIdentificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0010 ), "ScheduledStationName", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0011 ), "ScheduledProcedureStepLocation", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0012 ), "PreMedication", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0020 ), "ScheduledProcedureStepStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0026 ), "OrderPlacerIdentifierSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0027 ), "OrderFillerIdentifierSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0031 ), "LocalNamespaceEntityID", "UT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0032 ), "UniversalEntityID", "UT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0033 ), "UniversalEntityIDType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0035 ), "IdentifierTypeCode", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0036 ), "AssigningFacilitySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0039 ), "AssigningJurisdictionCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x003A ), "AssigningAgencyOrDepartmentCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0100 ), "ScheduledProcedureStepSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0220 ), "ReferencedNonImageCompositeSOPInstanceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0241 ), "PerformedStationAETitle", "AE" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0242 ), "PerformedStationName", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0243 ), "PerformedLocation", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0244 ), "PerformedProcedureStepStartDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0245 ), "PerformedProcedureStepStartTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0250 ), "PerformedProcedureStepEndDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0251 ), "PerformedProcedureStepEndTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0252 ), "PerformedProcedureStepStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0253 ), "PerformedProcedureStepID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0254 ), "PerformedProcedureStepDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0255 ), "PerformedProcedureTypeDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0260 ), "PerformedProtocolCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0261 ), "PerformedProtocolType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0270 ), "ScheduledStepAttributesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0275 ), "RequestAttributesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0280 ), "CommentsOnThePerformedProcedureStep", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0281 ), "PerformedProcedureStepDiscontinuationReasonCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0293 ), "QuantitySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0294 ), "Quantity", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0295 ), "MeasuringUnitsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0296 ), "BillingItemSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0300 ), "TotalTimeOfFluoroscopy", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0301 ), "TotalNumberOfExposures", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0302 ), "EntranceDose", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0303 ), "ExposedArea", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0306 ), "DistanceSourceToEntrance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x030E ), "ExposureDoseSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0310 ), "CommentsOnRadiationDose", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0312 ), "XRayOutput", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0314 ), "HalfValueLayer", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0316 ), "OrganDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0318 ), "OrganExposed", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0320 ), "BillingProcedureStepSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0321 ), "FilmConsumptionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0324 ), "BillingSuppliesAndDevicesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0340 ), "PerformedSeriesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0400 ), "CommentsOnTheScheduledProcedureStep", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0440 ), "ProtocolContextSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0441 ), "ContentItemModifierSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0500 ), "ScheduledSpecimenSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0512 ), "ContainerIdentifier", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0513 ), "IssuerOfTheContainerIdentifierSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0515 ), "AlternateContainerIdentifierSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0518 ), "ContainerTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x051A ), "ContainerDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0520 ), "ContainerComponentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0551 ), "SpecimenIdentifier", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0554 ), "SpecimenUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0555 ), "AcquisitionContextSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0556 ), "AcquisitionContextDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0560 ), "SpecimenDescriptionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0562 ), "IssuerOfTheSpecimenIdentifierSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x059A ), "SpecimenTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0600 ), "SpecimenShortDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0602 ), "SpecimenDetailedDescription", "UT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0610 ), "SpecimenPreparationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0612 ), "SpecimenPreparationStepContentItemSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x0620 ), "SpecimenLocalizationContentItemSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x071A ), "ImageCenterPointCoordinatesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x072A ), "XOffsetInSlideCoordinateSystem", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x073A ), "YOffsetInSlideCoordinateSystem", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x074A ), "ZOffsetInSlideCoordinateSystem", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x08EA ), "MeasurementUnitsCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1001 ), "RequestedProcedureID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1002 ), "ReasonForTheRequestedProcedure", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1003 ), "RequestedProcedurePriority", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1004 ), "PatientTransportArrangements", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1005 ), "RequestedProcedureLocation", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1008 ), "ConfidentialityCode", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1009 ), "ReportingPriority", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x100A ), "ReasonForRequestedProcedureCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1010 ), "NamesOfIntendedRecipientsOfResults", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1011 ), "IntendedRecipientsOfResultsIdentificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1012 ), "ReasonForPerformedProcedureCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1101 ), "PersonIdentificationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1102 ), "PersonAddress", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1103 ), "PersonTelephoneNumbers", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x1400 ), "RequestedProcedureComments", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2004 ), "IssueDateOfImagingServiceRequest", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2005 ), "IssueTimeOfImagingServiceRequest", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2008 ), "OrderEnteredBy", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2009 ), "OrderEntererLocation", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2010 ), "OrderCallbackPhoneNumber", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2016 ), "PlacerOrderNumberImagingServiceRequest", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2017 ), "FillerOrderNumberImagingServiceRequest", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x2400 ), "ImagingServiceRequestComments", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x3001 ), "ConfidentialityConstraintOnPatientDataDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4001 ), "GeneralPurposeScheduledProcedureStepStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4002 ), "GeneralPurposePerformedProcedureStepStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4003 ), "GeneralPurposeScheduledProcedureStepPriority", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4004 ), "ScheduledProcessingApplicationsCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4005 ), "ScheduledProcedureStepStartDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4006 ), "MultipleCopiesFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4007 ), "PerformedProcessingApplicationsCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4009 ), "HumanPerformerCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4010 ), "ScheduledProcedureStepModificationDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4011 ), "ExpectedCompletionDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4015 ), "ResultingGeneralPurposePerformedProcedureStepsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4016 ), "ReferencedGeneralPurposeScheduledProcedureStepSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4018 ), "ScheduledWorkitemCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4019 ), "PerformedWorkitemCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4020 ), "InputAvailabilityFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4021 ), "InputInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4022 ), "RelevantInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4023 ), "ReferencedGeneralPurposeScheduledProcedureStepTransactionUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4025 ), "ScheduledStationNameCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4026 ), "ScheduledStationClassCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4027 ), "ScheduledStationGeographicLocationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4028 ), "PerformedStationNameCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4029 ), "PerformedStationClassCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4030 ), "PerformedStationGeographicLocationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4031 ), "RequestedSubsequentWorkitemCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4032 ), "NonDICOMOutputCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4033 ), "OutputInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4034 ), "ScheduledHumanPerformersSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4035 ), "ActualHumanPerformersSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4036 ), "HumanPerformerOrganization", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4037 ), "HumanPerformerName", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4040 ), "RawDataHandling", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4041 ), "InputReadinessState", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4050 ), "PerformedProcedureStepStartDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4051 ), "PerformedProcedureStepEndDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x4052 ), "ProcedureStepCancellationDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x8302 ), "EntranceDoseInmGy", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x9094 ), "ReferencedImageRealWorldValueMappingSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x9096 ), "RealWorldValueMappingSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x9098 ), "PixelValueMappingCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x9210 ), "LUTLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x9211 ), "RealWorldValueLastValueMapped", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x9212 ), "RealWorldValueLUTData", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x9216 ), "RealWorldValueFirstValueMapped", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x9224 ), "RealWorldValueIntercept", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0x9225 ), "RealWorldValueSlope", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA010 ), "RelationshipType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA027 ), "VerifyingOrganization", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA030 ), "VerificationDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA032 ), "ObservationDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA040 ), "ValueType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA043 ), "ConceptNameCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA050 ), "ContinuityOfContent", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA073 ), "VerifyingObserverSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA075 ), "VerifyingObserverName", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA078 ), "AuthorObserverSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA07A ), "ParticipantSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA07C ), "CustodialOrganizationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA080 ), "ParticipationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA082 ), "ParticipationDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA084 ), "ObserverType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA088 ), "VerifyingObserverIdentificationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA0B0 ), "ReferencedWaveformChannels", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA120 ), "DateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA121 ), "Date", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA122 ), "Time", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA123 ), "PersonName", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA124 ), "UID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA130 ), "TemporalRangeType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA132 ), "ReferencedSamplePositions", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA136 ), "ReferencedFrameNumbers", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA138 ), "ReferencedTimeOffsets", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA13A ), "ReferencedDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA160 ), "TextValue", "UT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA168 ), "ConceptCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA170 ), "PurposeOfReferenceCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA180 ), "AnnotationGroupNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA195 ), "ModifierCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA300 ), "MeasuredValueSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA301 ), "NumericValueQualifierCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA30A ), "NumericValue", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA360 ), "PredecessorDocumentsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA370 ), "ReferencedRequestSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA372 ), "PerformedProcedureCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA375 ), "CurrentRequestedProcedureEvidenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA385 ), "PertinentOtherEvidenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA390 ), "HL7StructuredDocumentReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA491 ), "CompletionFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA492 ), "CompletionFlagDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA493 ), "VerificationFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA494 ), "ArchiveRequested", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA496 ), "PreliminaryFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA504 ), "ContentTemplateSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA525 ), "IdenticalDocumentsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xA730 ), "ContentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xB020 ), "WaveformAnnotationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xDB00 ), "TemplateIdentifier", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xDB73 ), "ReferencedContentItemIdentifier", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE001 ), "HL7InstanceIdentifier", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE004 ), "HL7DocumentEffectiveTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE006 ), "HL7DocumentTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE008 ), "DocumentClassCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE010 ), "RetrieveURI", "UT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE011 ), "RetrieveLocationUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE020 ), "TypeOfInstances", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE021 ), "DICOMRetrievalSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE022 ), "DICOMMediaRetrievalSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE023 ), "WADORetrievalSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE024 ), "XDSRetrievalSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE030 ), "RepositoryUniqueID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0040, 0xE031 ), "HomeCommunityID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0042, 0x0010 ), "DocumentTitle", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0042, 0x0011 ), "EncapsulatedDocument", "OB" ));
mAddEntry (DicomElement ( DicomTag ( 0x0042, 0x0012 ), "MIMETypeOfEncapsulatedDocument", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0042, 0x0013 ), "SourceInstanceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0042, 0x0014 ), "ListOfMIMETypes", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0001 ), "ProductPackageIdentifier", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0002 ), "SubstanceAdministrationApproval", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0003 ), "ApprovalStatusFurtherDescription", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0004 ), "ApprovalStatusDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0007 ), "ProductTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0008 ), "ProductName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0009 ), "ProductDescription", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x000A ), "ProductLotIdentifier", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x000B ), "ProductExpirationDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0010 ), "SubstanceAdministrationDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0011 ), "SubstanceAdministrationNotes", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0012 ), "SubstanceAdministrationDeviceID", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0013 ), "ProductParameterSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0044, 0x0019 ), "SubstanceAdministrationParameterSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0012 ), "LensDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0014 ), "RightLensSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0015 ), "LeftLensSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0016 ), "UnspecifiedLateralityLensSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0018 ), "CylinderSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0028 ), "PrismSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0030 ), "HorizontalPrismPower", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0032 ), "HorizontalPrismBase", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0034 ), "VerticalPrismPower", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0036 ), "VerticalPrismBase", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0038 ), "LensSegmentType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0040 ), "OpticalTransmittance", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0042 ), "ChannelWidth", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0044 ), "PupilSize", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0046 ), "CornealSize", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0050 ), "AutorefractionRightEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0052 ), "AutorefractionLeftEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0060 ), "DistancePupillaryDistance", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0062 ), "NearPupillaryDistance", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0063 ), "IntermediatePupillaryDistance", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0064 ), "OtherPupillaryDistance", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0070 ), "KeratometryRightEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0071 ), "KeratometryLeftEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0074 ), "SteepKeratometricAxisSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0075 ), "RadiusOfCurvature", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0076 ), "KeratometricPower", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0077 ), "KeratometricAxis", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0080 ), "FlatKeratometricAxisSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0092 ), "BackgroundColor", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0094 ), "Optotype", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0095 ), "OptotypePresentation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0097 ), "SubjectiveRefractionRightEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0098 ), "SubjectiveRefractionLeftEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0100 ), "AddNearSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0101 ), "AddIntermediateSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0102 ), "AddOtherSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0104 ), "AddPower", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0106 ), "ViewingDistance", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0121 ), "VisualAcuityTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0122 ), "VisualAcuityRightEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0123 ), "VisualAcuityLeftEyeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0124 ), "VisualAcuityBothEyesOpenSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0125 ), "ViewingDistanceType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0135 ), "VisualAcuityModifiers", "SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0137 ), "DecimalVisualAcuity", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0139 ), "OptotypeDetailedDefinition", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0145 ), "ReferencedRefractiveMeasurementsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0146 ), "SpherePower", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0046, 0x0147 ), "CylinderPower", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0001 ), "ImagedVolumeWidth", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0002 ), "ImagedVolumeHeight", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0003 ), "ImagedVolumeDepth", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0006 ), "TotalPixelMatrixColumns", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0007 ), "TotalPixelMatrixRows", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0008 ), "TotalPixelMatrixOriginSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0010 ), "SpecimenLabelInImage", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0011 ), "FocusMethod", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0012 ), "ExtendedDepthOfField", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0013 ), "NumberOfFocalPlanes", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0014 ), "DistanceBetweenFocalPlanes", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0015 ), "RecommendedAbsentPixelCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0100 ), "IlluminatorTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0102 ), "ImageOrientationSlide", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0105 ), "OpticalPathSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0106 ), "OpticalPathIdentifier", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0107 ), "OpticalPathDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0108 ), "IlluminationColorCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0110 ), "SpecimenReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0111 ), "CondenserLensPower", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0112 ), "ObjectiveLensPower", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0113 ), "ObjectiveLensNumericalAperture", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0120 ), "PaletteColorLookupTableSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0200 ), "ReferencedImageNavigationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0201 ), "TopLeftHandCornerOfLocalizerArea", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0202 ), "BottomRightHandCornerOfLocalizerArea", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0207 ), "OpticalPathIdentificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x021A ), "PlanePositionSlideSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x021E ), "RowPositionInTotalImagePixelMatrix", "SL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x021F ), "ColumnPositionInTotalImagePixelMatrix", "SL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0048, 0x0301 ), "PixelOriginInterpretation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0004 ), "CalibrationImage", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0010 ), "DeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0012 ), "ContainerComponentTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0013 ), "ContainerComponentThickness", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0014 ), "DeviceLength", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0015 ), "ContainerComponentWidth", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0016 ), "DeviceDiameter", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0017 ), "DeviceDiameterUnits", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0018 ), "DeviceVolume", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0019 ), "InterMarkerDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x001A ), "ContainerComponentMaterial", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x001B ), "ContainerComponentID", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x001C ), "ContainerComponentLength", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x001D ), "ContainerComponentDiameter", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x001E ), "ContainerComponentDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0050, 0x0020 ), "DeviceDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0001 ), "ContrastBolusIngredientPercentByVolume", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0002 ), "OCTFocalDistance", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0003 ), "BeamSpotSize", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0004 ), "EffectiveRefractiveIndex", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0006 ), "OCTAcquisitionDomain", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0007 ), "OCTOpticalCenterWavelength", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0008 ), "AxialResolution", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0009 ), "RangingDepth", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0011 ), "ALineRate", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0012 ), "ALinesPerFrame", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0013 ), "CatheterRotationalRate", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0014 ), "ALinePixelSpacing", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0016 ), "ModeOfPercutaneousAccessSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0025 ), "IntravascularOCTFrameTypeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0026 ), "OCTZOffsetApplied", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0027 ), "IntravascularFrameContentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0028 ), "IntravascularLongitudinalDistance", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0029 ), "IntravascularOCTFrameContentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0030 ), "OCTZOffsetCorrection", "SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0031 ), "CatheterDirectionOfRotation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0033 ), "SeamLineLocation", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0034 ), "FirstALineLocation", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0036 ), "SeamLineIndex", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0038 ), "NumberOfPaddedAlines", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x0039 ), "InterpolationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0052, 0x003A ), "RefractiveIndexApplied", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0010 ), "EnergyWindowVector", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0011 ), "NumberOfEnergyWindows", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0012 ), "EnergyWindowInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0013 ), "EnergyWindowRangeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0014 ), "EnergyWindowLowerLimit", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0015 ), "EnergyWindowUpperLimit", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0016 ), "RadiopharmaceuticalInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0017 ), "ResidualSyringeCounts", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0018 ), "EnergyWindowName", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0020 ), "DetectorVector", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0021 ), "NumberOfDetectors", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0022 ), "DetectorInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0030 ), "PhaseVector", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0031 ), "NumberOfPhases", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0032 ), "PhaseInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0033 ), "NumberOfFramesInPhase", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0036 ), "PhaseDelay", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0038 ), "PauseBetweenFrames", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0039 ), "PhaseDescription", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0050 ), "RotationVector", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0051 ), "NumberOfRotations", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0052 ), "RotationInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0053 ), "NumberOfFramesInRotation", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0060 ), "RRIntervalVector", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0061 ), "NumberOfRRIntervals", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0062 ), "GatedInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0063 ), "DataInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0070 ), "TimeSlotVector", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0071 ), "NumberOfTimeSlots", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0072 ), "TimeSlotInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0073 ), "TimeSlotTime", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0080 ), "SliceVector", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0081 ), "NumberOfSlices", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0090 ), "AngularViewVector", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0100 ), "TimeSliceVector", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0101 ), "NumberOfTimeSlices", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0200 ), "StartAngle", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0202 ), "TypeOfDetectorMotion", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0210 ), "TriggerVector", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0211 ), "NumberOfTriggersInPhase", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0220 ), "ViewCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0222 ), "ViewModifierCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0300 ), "RadionuclideCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0302 ), "AdministrationRouteCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0304 ), "RadiopharmaceuticalCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0306 ), "CalibrationDataSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0308 ), "EnergyWindowNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0400 ), "ImageID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0410 ), "PatientOrientationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0412 ), "PatientOrientationModifierCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0414 ), "PatientGantryRelationshipCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x0500 ), "SliceProgressionDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1000 ), "SeriesType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1001 ), "Units", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1002 ), "CountsSource", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1004 ), "ReprojectionMethod", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1006 ), "SUVType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1100 ), "RandomsCorrectionMethod", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1101 ), "AttenuationCorrectionMethod", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1102 ), "DecayCorrection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1103 ), "ReconstructionMethod", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1104 ), "DetectorLinesOfResponseUsed", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1105 ), "ScatterCorrectionMethod", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1200 ), "AxialAcceptance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1201 ), "AxialMash", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1202 ), "TransverseMash", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1203 ), "DetectorElementSize", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1210 ), "CoincidenceWindowWidth", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1220 ), "SecondaryCountsType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1300 ), "FrameReferenceTime", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1310 ), "PrimaryPromptsCountsAccumulated", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1311 ), "SecondaryCountsAccumulated", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1320 ), "SliceSensitivityFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1321 ), "DecayFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1322 ), "DoseCalibrationFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1323 ), "ScatterFractionFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1324 ), "DeadTimeFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0054, 0x1330 ), "ImageIndex", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0060, 0x3000 ), "HistogramSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0060, 0x3002 ), "HistogramNumberOfBins", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0060, 0x3004 ), "HistogramFirstBinValue", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0060, 0x3006 ), "HistogramLastBinValue", "US or SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0060, 0x3008 ), "HistogramBinWidth", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0060, 0x3010 ), "HistogramExplanation", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0060, 0x3020 ), "HistogramData", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x0001 ), "SegmentationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x0002 ), "SegmentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x0003 ), "SegmentedPropertyCategoryCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x0004 ), "SegmentNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x0005 ), "SegmentLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x0006 ), "SegmentDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x0008 ), "SegmentAlgorithmType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x0009 ), "SegmentAlgorithmName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x000A ), "SegmentIdentificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x000B ), "ReferencedSegmentNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x000C ), "RecommendedDisplayGrayscaleValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x000D ), "RecommendedDisplayCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x000E ), "MaximumFractionalValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x000F ), "SegmentedPropertyTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0062, 0x0010 ), "SegmentationFractionalType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0064, 0x0002 ), "DeformableRegistrationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0064, 0x0003 ), "SourceFrameOfReferenceUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0064, 0x0005 ), "DeformableRegistrationGridSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0064, 0x0007 ), "GridDimensions", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0064, 0x0008 ), "GridResolution", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0064, 0x0009 ), "VectorGridData", "OF" ));
mAddEntry (DicomElement ( DicomTag ( 0x0064, 0x000F ), "PreDeformationMatrixRegistrationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0064, 0x0010 ), "PostDeformationMatrixRegistrationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0001 ), "NumberOfSurfaces", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0002 ), "SurfaceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0003 ), "SurfaceNumber", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0004 ), "SurfaceComments", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0009 ), "SurfaceProcessing", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x000A ), "SurfaceProcessingRatio", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x000B ), "SurfaceProcessingDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x000C ), "RecommendedPresentationOpacity", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x000D ), "RecommendedPresentationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x000E ), "FiniteVolume", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0010 ), "Manifold", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0011 ), "SurfacePointsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0012 ), "SurfacePointsNormalsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0013 ), "SurfaceMeshPrimitivesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0015 ), "NumberOfSurfacePoints", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0016 ), "PointCoordinatesData", "OF" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0017 ), "PointPositionAccuracy", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0018 ), "MeanPointDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0019 ), "MaximumPointDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x001A ), "PointsBoundingBoxCoordinates", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x001B ), "AxisOfRotation", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x001C ), "CenterOfRotation", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x001E ), "NumberOfVectors", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x001F ), "VectorDimensionality", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0020 ), "VectorAccuracy", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0021 ), "VectorCoordinateData", "OF" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0023 ), "TrianglePointIndexList", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0024 ), "EdgePointIndexList", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0025 ), "VertexPointIndexList", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0026 ), "TriangleStripSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0027 ), "TriangleFanSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0028 ), "LineSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0029 ), "PrimitivePointIndexList", "OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x002A ), "SurfaceCount", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x002B ), "ReferencedSurfaceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x002C ), "ReferencedSurfaceNumber", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x002D ), "SegmentSurfaceGenerationAlgorithmIdentificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x002E ), "SegmentSurfaceSourceInstanceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x002F ), "AlgorithmFamilyCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0030 ), "AlgorithmNameCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0031 ), "AlgorithmVersion", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0032 ), "AlgorithmParameters", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0034 ), "FacetSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0035 ), "SurfaceProcessingAlgorithmIdentificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0066, 0x0036 ), "AlgorithmName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6210 ), "ImplantSize", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6221 ), "ImplantTemplateVersion", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6222 ), "ReplacedImplantTemplateSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6223 ), "ImplantType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6224 ), "DerivationImplantTemplateSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6225 ), "OriginalImplantTemplateSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6226 ), "EffectiveDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6230 ), "ImplantTargetAnatomySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6260 ), "InformationFromManufacturerSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6265 ), "NotificationFromManufacturerSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6270 ), "InformationIssueDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6280 ), "InformationSummary", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x62A0 ), "ImplantRegulatoryDisapprovalCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x62A5 ), "OverallTemplateSpatialTolerance", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x62C0 ), "HPGLDocumentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x62D0 ), "HPGLDocumentID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x62D5 ), "HPGLDocumentLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x62E0 ), "ViewOrientationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x62F0 ), "ViewOrientationModifier", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x62F2 ), "HPGLDocumentScaling", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6300 ), "HPGLDocument", "OB" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6310 ), "HPGLContourPenNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6320 ), "HPGLPenSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6330 ), "HPGLPenNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6340 ), "HPGLPenLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6345 ), "HPGLPenDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6346 ), "RecommendedRotationPoint", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6347 ), "BoundingRectangle", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6350 ), "ImplantTemplate3DModelSurfaceNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6360 ), "SurfaceModelDescriptionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6380 ), "SurfaceModelLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6390 ), "SurfaceModelScalingFactor", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x63A0 ), "MaterialsCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x63A4 ), "CoatingMaterialsCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x63A8 ), "ImplantTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x63AC ), "FixationMethodCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x63B0 ), "MatingFeatureSetsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x63C0 ), "MatingFeatureSetID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x63D0 ), "MatingFeatureSetLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x63E0 ), "MatingFeatureSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x63F0 ), "MatingFeatureID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6400 ), "MatingFeatureDegreeOfFreedomSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6410 ), "DegreeOfFreedomID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6420 ), "DegreeOfFreedomType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6430 ), "TwoDMatingFeatureCoordinatesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6440 ), "ReferencedHPGLDocumentID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6450 ), "TwoDMatingPoint", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6460 ), "TwoDMatingAxes", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6470 ), "TwoDDegreeOfFreedomSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6490 ), "ThreeDDegreeOfFreedomAxis", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x64A0 ), "RangeOfFreedom", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x64C0 ), "ThreeDMatingPoint", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x64D0 ), "ThreeDMatingAxes", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x64F0 ), "TwoDDegreeOfFreedomAxis", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6500 ), "PlanningLandmarkPointSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6510 ), "PlanningLandmarkLineSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6520 ), "PlanningLandmarkPlaneSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6530 ), "PlanningLandmarkID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6540 ), "PlanningLandmarkDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6545 ), "PlanningLandmarkIdentificationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6550 ), "TwoDPointCoordinatesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6560 ), "TwoDPointCoordinates", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6590 ), "ThreeDPointCoordinates", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x65A0 ), "TwoDLineCoordinatesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x65B0 ), "TwoDLineCoordinates", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x65D0 ), "ThreeDLineCoordinates", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x65E0 ), "TwoDPlaneCoordinatesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x65F0 ), "TwoDPlaneIntersection", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6610 ), "ThreeDPlaneOrigin", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0068, 0x6620 ), "ThreeDPlaneNormal", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0001 ), "GraphicAnnotationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0002 ), "GraphicLayer", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0003 ), "BoundingBoxAnnotationUnits", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0004 ), "AnchorPointAnnotationUnits", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0005 ), "GraphicAnnotationUnits", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0006 ), "UnformattedTextValue", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0008 ), "TextObjectSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0009 ), "GraphicObjectSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0010 ), "BoundingBoxTopLeftHandCorner", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0011 ), "BoundingBoxBottomRightHandCorner", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0012 ), "BoundingBoxTextHorizontalJustification", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0014 ), "AnchorPoint", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0015 ), "AnchorPointVisibility", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0020 ), "GraphicDimensions", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0021 ), "NumberOfGraphicPoints", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0022 ), "GraphicData", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0023 ), "GraphicType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0024 ), "GraphicFilled", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0041 ), "ImageHorizontalFlip", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0042 ), "ImageRotation", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0052 ), "DisplayedAreaTopLeftHandCorner", "SL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0053 ), "DisplayedAreaBottomRightHandCorner", "SL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x005A ), "DisplayedAreaSelectionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0060 ), "GraphicLayerSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0062 ), "GraphicLayerOrder", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0066 ), "GraphicLayerRecommendedDisplayGrayscaleValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0068 ), "GraphicLayerDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0080 ), "ContentLabel", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0081 ), "ContentDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0082 ), "PresentationCreationDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0083 ), "PresentationCreationTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0084 ), "ContentCreatorName", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0086 ), "ContentCreatorIdentificationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0087 ), "AlternateContentDescriptionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0100 ), "PresentationSizeMode", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0101 ), "PresentationPixelSpacing", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0102 ), "PresentationPixelAspectRatio", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0103 ), "PresentationPixelMagnificationRatio", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0207 ), "GraphicGroupLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0208 ), "GraphicGroupDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0209 ), "CompoundGraphicSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0226 ), "CompoundGraphicInstanceID", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0227 ), "FontName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0228 ), "FontNameType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0229 ), "CSSFontName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0230 ), "RotationAngle", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0231 ), "TextStyleSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0232 ), "LineStyleSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0233 ), "FillStyleSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0234 ), "GraphicGroupSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0241 ), "TextColorCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0242 ), "HorizontalAlignment", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0243 ), "VerticalAlignment", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0244 ), "ShadowStyle", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0245 ), "ShadowOffsetX", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0246 ), "ShadowOffsetY", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0247 ), "ShadowColorCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0248 ), "Underlined", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0249 ), "Bold", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0250 ), "Italic", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0251 ), "PatternOnColorCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0252 ), "PatternOffColorCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0253 ), "LineThickness", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0254 ), "LineDashingStyle", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0255 ), "LinePattern", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0256 ), "FillPattern", "OB" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0257 ), "FillMode", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0258 ), "ShadowOpacity", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0261 ), "GapLength", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0262 ), "DiameterOfVisibility", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0273 ), "RotationPoint", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0274 ), "TickAlignment", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0278 ), "ShowTickLabel", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0279 ), "TickLabelAlignment", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0282 ), "CompoundGraphicUnits", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0284 ), "PatternOnOpacity", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0285 ), "PatternOffOpacity", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0287 ), "MajorTicksSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0288 ), "TickPosition", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0289 ), "TickLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0294 ), "CompoundGraphicType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0295 ), "GraphicGroupID", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0306 ), "ShapeType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0308 ), "RegistrationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0309 ), "MatrixRegistrationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x030A ), "MatrixSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x030C ), "FrameOfReferenceTransformationMatrixType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x030D ), "RegistrationTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x030F ), "FiducialDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0310 ), "FiducialIdentifier", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0311 ), "FiducialIdentifierCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0312 ), "ContourUncertaintyRadius", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0314 ), "UsedFiducialsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0318 ), "GraphicCoordinatesDataSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x031A ), "FiducialUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x031C ), "FiducialSetSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x031E ), "FiducialSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0401 ), "GraphicLayerRecommendedDisplayCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0402 ), "BlendingSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0403 ), "RelativeOpacity", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0404 ), "ReferencedSpatialRegistrationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0070, 0x0405 ), "BlendingPosition", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0002 ), "HangingProtocolName", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0004 ), "HangingProtocolDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0006 ), "HangingProtocolLevel", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0008 ), "HangingProtocolCreator", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x000A ), "HangingProtocolCreationDateTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x000C ), "HangingProtocolDefinitionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x000E ), "HangingProtocolUserIdentificationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0010 ), "HangingProtocolUserGroupName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0012 ), "SourceHangingProtocolSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0014 ), "NumberOfPriorsReferenced", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0020 ), "ImageSetsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0022 ), "ImageSetSelectorSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0024 ), "ImageSetSelectorUsageFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0026 ), "SelectorAttribute", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0028 ), "SelectorValueNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0030 ), "TimeBasedImageSetsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0032 ), "ImageSetNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0034 ), "ImageSetSelectorCategory", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0038 ), "RelativeTime", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x003A ), "RelativeTimeUnits", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x003C ), "AbstractPriorValue", "SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x003E ), "AbstractPriorCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0040 ), "ImageSetLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0050 ), "SelectorAttributeVR", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0052 ), "SelectorSequencePointer", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0054 ), "SelectorSequencePointerPrivateCreator", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0056 ), "SelectorAttributePrivateCreator", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0060 ), "SelectorATValue", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0062 ), "SelectorCSValue", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0064 ), "SelectorISValue", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0066 ), "SelectorLOValue", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0068 ), "SelectorLTValue", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x006A ), "SelectorPNValue", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x006C ), "SelectorSHValue", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x006E ), "SelectorSTValue", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0070 ), "SelectorUTValue", "UT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0072 ), "SelectorDSValue", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0074 ), "SelectorFDValue", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0076 ), "SelectorFLValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0078 ), "SelectorULValue", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x007A ), "SelectorUSValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x007C ), "SelectorSLValue", "SL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x007E ), "SelectorSSValue", "SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0080 ), "SelectorCodeSequenceValue", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0100 ), "NumberOfScreens", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0102 ), "NominalScreenDefinitionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0104 ), "NumberOfVerticalPixels", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0106 ), "NumberOfHorizontalPixels", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0108 ), "DisplayEnvironmentSpatialPosition", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x010A ), "ScreenMinimumGrayscaleBitDepth", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x010C ), "ScreenMinimumColorBitDepth", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x010E ), "ApplicationMaximumRepaintTime", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0200 ), "DisplaySetsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0202 ), "DisplaySetNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0203 ), "DisplaySetLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0204 ), "DisplaySetPresentationGroup", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0206 ), "DisplaySetPresentationGroupDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0208 ), "PartialDataDisplayHandling", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0210 ), "SynchronizedScrollingSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0212 ), "DisplaySetScrollingGroup", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0214 ), "NavigationIndicatorSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0216 ), "NavigationDisplaySet", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0218 ), "ReferenceDisplaySets", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0300 ), "ImageBoxesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0302 ), "ImageBoxNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0304 ), "ImageBoxLayoutType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0306 ), "ImageBoxTileHorizontalDimension", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0308 ), "ImageBoxTileVerticalDimension", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0310 ), "ImageBoxScrollDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0312 ), "ImageBoxSmallScrollType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0314 ), "ImageBoxSmallScrollAmount", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0316 ), "ImageBoxLargeScrollType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0318 ), "ImageBoxLargeScrollAmount", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0320 ), "ImageBoxOverlapPriority", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0330 ), "CineRelativeToRealTime", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0400 ), "FilterOperationsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0402 ), "FilterByCategory", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0404 ), "FilterByAttributePresence", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0406 ), "FilterByOperator", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0420 ), "StructuredDisplayBackgroundCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0421 ), "EmptyImageBoxCIELabValue", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0422 ), "StructuredDisplayImageBoxSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0424 ), "StructuredDisplayTextBoxSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0427 ), "ReferencedFirstFrameSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0430 ), "ImageBoxSynchronizationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0432 ), "SynchronizedImageBoxList", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0434 ), "TypeOfSynchronization", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0500 ), "BlendingOperationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0510 ), "ReformattingOperationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0512 ), "ReformattingThickness", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0514 ), "ReformattingInterval", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0516 ), "ReformattingOperationInitialViewDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0520 ), "ThreeDRenderingType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0600 ), "SortingOperationsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0602 ), "SortByCategory", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0604 ), "SortingDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0700 ), "DisplaySetPatientOrientation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0702 ), "VOIType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0704 ), "PseudoColorType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0705 ), "PseudoColorPaletteInstanceReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0706 ), "ShowGrayscaleInverted", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0710 ), "ShowImageTrueSizeFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0712 ), "ShowGraphicAnnotationFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0714 ), "ShowPatientDemographicsFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0716 ), "ShowAcquisitionTechniquesFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0717 ), "DisplaySetHorizontalJustification", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0072, 0x0718 ), "DisplaySetVerticalJustification", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x0120 ), "ContinuationStartMeterset", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x0121 ), "ContinuationEndMeterset", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1000 ), "ProcedureStepState", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1002 ), "ProcedureStepProgressInformationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1004 ), "ProcedureStepProgress", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1006 ), "ProcedureStepProgressDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1008 ), "ProcedureStepCommunicationsURISequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x100a ), "ContactURI", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x100c ), "ContactDisplayName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x100e ), "ProcedureStepDiscontinuationReasonCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1020 ), "BeamTaskSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1022 ), "BeamTaskType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1026 ), "TableTopVerticalAdjustedPosition", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1027 ), "TableTopLongitudinalAdjustedPosition", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1028 ), "TableTopLateralAdjustedPosition", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x102A ), "PatientSupportAdjustedAngle", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x102B ), "TableTopEccentricAdjustedAngle", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x102C ), "TableTopPitchAdjustedAngle", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x102D ), "TableTopRollAdjustedAngle", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1030 ), "DeliveryVerificationImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1032 ), "VerificationImageTiming", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1034 ), "DoubleExposureFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1036 ), "DoubleExposureOrdering", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1040 ), "RelatedReferenceRTImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1042 ), "GeneralMachineVerificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1044 ), "ConventionalMachineVerificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1046 ), "IonMachineVerificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1048 ), "FailedAttributesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x104A ), "OverriddenAttributesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x104C ), "ConventionalControlPointVerificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x104E ), "IonControlPointVerificationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1050 ), "AttributeOccurrenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1052 ), "AttributeOccurrencePointer", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1054 ), "AttributeItemSelector", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1056 ), "AttributeOccurrencePrivateCreator", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1057 ), "SelectorSequencePointerItems", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1200 ), "ScheduledProcedureStepPriority", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1202 ), "WorklistLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1204 ), "ProcedureStepLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1210 ), "ScheduledProcessingParametersSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1212 ), "PerformedProcessingParametersSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1216 ), "UnifiedProcedureStepPerformedProcedureSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1224 ), "ReplacedProcedureStepSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1230 ), "DeletionLock", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1234 ), "ReceivingAE", "AE" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1236 ), "RequestingAE", "AE" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1238 ), "ReasonForCancellation", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1242 ), "SCPStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1244 ), "SubscriptionListStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1246 ), "UnifiedProcedureStepListStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1324 ), "BeamOrderIndex", "UL" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x1338 ), "DoubleExposureMeterset", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0074, 0x133A ), "DoubleExposureFieldDelta", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0001 ), "ImplantAssemblyTemplateName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0003 ), "ImplantAssemblyTemplateIssuer", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0006 ), "ImplantAssemblyTemplateVersion", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0008 ), "ReplacedImplantAssemblyTemplateSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x000A ), "ImplantAssemblyTemplateType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x000C ), "OriginalImplantAssemblyTemplateSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x000E ), "DerivationImplantAssemblyTemplateSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0010 ), "ImplantAssemblyTemplateTargetAnatomySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0020 ), "ProcedureTypeCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0030 ), "SurgicalTechnique", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0032 ), "ComponentTypesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0034 ), "ComponentTypeCodeSequence", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0036 ), "ExclusiveComponentType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0038 ), "MandatoryComponentType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0040 ), "ComponentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0055 ), "ComponentID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0060 ), "ComponentAssemblySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0070 ), "Component1ReferencedID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0080 ), "Component1ReferencedMatingFeatureSetID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x0090 ), "Component1ReferencedMatingFeatureID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x00A0 ), "Component2ReferencedID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x00B0 ), "Component2ReferencedMatingFeatureSetID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0076, 0x00C0 ), "Component2ReferencedMatingFeatureID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0001 ), "ImplantTemplateGroupName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0010 ), "ImplantTemplateGroupDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0020 ), "ImplantTemplateGroupIssuer", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0024 ), "ImplantTemplateGroupVersion", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0026 ), "ReplacedImplantTemplateGroupSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0028 ), "ImplantTemplateGroupTargetAnatomySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x002A ), "ImplantTemplateGroupMembersSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x002E ), "ImplantTemplateGroupMemberID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0050 ), "ThreeDImplantTemplateGroupMemberMatchingPoint", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0060 ), "ThreeDImplantTemplateGroupMemberMatchingAxes", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0070 ), "ImplantTemplateGroupMemberMatching2DCoordinatesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x0090 ), "TwoDImplantTemplateGroupMemberMatchingPoint", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x00A0 ), "TwoDImplantTemplateGroupMemberMatchingAxes", "FD" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x00B0 ), "ImplantTemplateGroupVariationDimensionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x00B2 ), "ImplantTemplateGroupVariationDimensionName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x00B4 ), "ImplantTemplateGroupVariationDimensionRankSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x00B6 ), "ReferencedImplantTemplateGroupMemberID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0078, 0x00B8 ), "ImplantTemplateGroupVariationDimensionRank", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x0088, 0x0130 ), "StorageMediaFileSetID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x0088, 0x0140 ), "StorageMediaFileSetUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x0088, 0x0200 ), "IconImageSequence", "SQ" ));

mAddEntry(DicomElement(DicomTag(0x0100, 0x0410), "SOPInstanceStatus", "CS"));
mAddEntry(DicomElement(DicomTag(0x0100, 0x0420), "SOPAuthorizationDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0100, 0x0424), "SOPAuthorizationComment", "LT"));
mAddEntry(DicomElement(DicomTag(0x0100, 0x0426), "AuthorizationEquipmentCertificationNumber", "LO"));

mAddEntry(DicomElement(DicomTag(0x0400, 0x0005), "MACIDNumber", "US"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0010), "MACCalculationTransferSyntaxUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0015), "MACAlgorithm", "CS"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0020), "DataElementsSigned", "AT"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0100), "DigitalSignatureUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0105), "DigitalSignatureDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0110), "CertificateType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0115), "CertificateOfSigner", "OB"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0120), "Signature", "OB"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0305), "CertifiedTimestampType", "CS"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0310), "CertifiedTimestamp", "OB"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0401), "DigitalSignaturePurposeCodeSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0402), "ReferencedDigitalSignatureSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0403), "ReferencedSOPInstanceMACSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0404), "MAC", "OB"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0500), "EncryptedAttributesSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0510), "EncryptedContentTransferSyntaxUID", "UI"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0520), "EncryptedContent", "OB"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0550), "ModifiedAttributesSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0561), "OriginalAttributesSequence", "SQ"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0562), "AttributeModificationDateTime", "DT"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0563), "ModifyingSystem", "LO"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0564), "SourceOfPreviousValues", "LO"));
mAddEntry(DicomElement(DicomTag(0x0400, 0x0565), "ReasonForTheAttributeModification", "CS"));

mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0010 ), "NumberOfCopies", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x001E ), "PrinterConfigurationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0020 ), "PrintPriority", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0030 ), "MediumType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0040 ), "FilmDestination", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0050 ), "FilmSessionLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0060 ), "MemoryAllocation", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0061 ), "MaximumMemoryAllocation", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x00A0 ), "MemoryBitDepth", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x00A1 ), "PrintingBitDepth", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x00A2 ), "MediaInstalledSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x00A4 ), "OtherMediaAvailableSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x00A8 ), "SupportedImageDisplayFormatsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2000, 0x0500 ), "ReferencedFilmBoxSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0010 ), "ImageDisplayFormat", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0030 ), "AnnotationDisplayFormatID", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0040 ), "FilmOrientation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0050 ), "FilmSizeID", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0052 ), "PrinterResolutionID", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0054 ), "DefaultPrinterResolutionID", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0060 ), "MagnificationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0080 ), "SmoothingType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x00A6 ), "DefaultMagnificationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x00A7 ), "OtherMagnificationTypesAvailable", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x00A8 ), "DefaultSmoothingType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x00A9 ), "OtherSmoothingTypesAvailable", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0100 ), "BorderDensity", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0110 ), "EmptyImageDensity", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0120 ), "MinDensity", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0130 ), "MaxDensity", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0140 ), "Trim", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0150 ), "ConfigurationInformation", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0152 ), "ConfigurationInformationDescription", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0154 ), "MaximumCollatedFilms", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x015E ), "Illumination", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0160 ), "ReflectedAmbientLight", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0376 ), "PrinterPixelSpacing", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0500 ), "ReferencedFilmSessionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0510 ), "ReferencedImageBoxSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2010, 0x0520 ), "ReferencedBasicAnnotationBoxSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x0010 ), "ImageBoxPosition", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x0020 ), "Polarity", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x0030 ), "RequestedImageSize", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x0040 ), "RequestedDecimateCropBehavior", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x0050 ), "RequestedResolutionID", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x00A0 ), "RequestedImageSizeFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x00A2 ), "DecimateCropResult", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x0110 ), "BasicGrayscaleImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2020, 0x0111 ), "BasicColorImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2030, 0x0010 ), "AnnotationPosition", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2030, 0x0020 ), "TextString", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x2050, 0x0010 ), "PresentationLUTSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2050, 0x0020 ), "PresentationLUTShape", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2050, 0x0500 ), "ReferencedPresentationLUTSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0020 ), "ExecutionStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0030 ), "ExecutionStatusInfo", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0040 ), "CreationDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0050 ), "CreationTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0070 ), "Originator", "AE" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0160 ), "OwnerID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x2100, 0x0170 ), "NumberOfFilms", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2110, 0x0010 ), "PrinterStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2110, 0x0020 ), "PrinterStatusInfo", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2110, 0x0030 ), "PrinterName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0001 ), "LabelUsingInformationExtractedFromInstances", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0002 ), "LabelText", "UT" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0003 ), "LabelStyleSelection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0004 ), "MediaDisposition", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0005 ), "BarcodeValue", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0006 ), "BarcodeSymbology", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0007 ), "AllowMediaSplitting", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0008 ), "IncludeNonDICOMObjects", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0009 ), "IncludeDisplayApplication", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x000A ), "PreserveCompositeInstancesAfterMediaCreation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x000B ), "TotalNumberOfPiecesOfMediaCreated", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x000C ), "RequestedMediaApplicationProfile", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x000D ), "ReferencedStorageMediaSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x000E ), "FailureAttributes", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x000F ), "AllowLossyCompression", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x2200, 0x0020 ), "RequestPriority", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0002 ), "RTImageLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0003 ), "RTImageName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0004 ), "RTImageDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x000A ), "ReportedValuesOrigin", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x000C ), "RTImagePlane", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x000D ), "XRayImageReceptorTranslation", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x000E ), "XRayImageReceptorAngle", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0010 ), "RTImageOrientation", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0011 ), "ImagePlanePixelSpacing", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0012 ), "RTImagePosition", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0020 ), "RadiationMachineName", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0022 ), "RadiationMachineSAD", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0024 ), "RadiationMachineSSD", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0026 ), "RTImageSID", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0028 ), "SourceToReferenceObjectDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0029 ), "FractionNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0030 ), "ExposureSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0032 ), "MetersetExposure", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0034 ), "DiaphragmPosition", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0040 ), "FluenceMapSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0041 ), "FluenceDataSource", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0042 ), "FluenceDataScale", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0050 ), "PrimaryFluenceModeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0051 ), "FluenceMode", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3002, 0x0052 ), "FluenceModeID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0001 ), "DVHType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0002 ), "DoseUnits", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0004 ), "DoseType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0006 ), "DoseComment", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0008 ), "NormalizationPoint", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x000A ), "DoseSummationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x000C ), "GridFrameOffsetVector", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x000E ), "DoseGridScaling", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0010 ), "RTDoseROISequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0012 ), "DoseValue", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0014 ), "TissueHeterogeneityCorrection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0040 ), "DVHNormalizationPoint", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0042 ), "DVHNormalizationDoseValue", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0050 ), "DVHSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0052 ), "DVHDoseScaling", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0054 ), "DVHVolumeUnits", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0056 ), "DVHNumberOfBins", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0058 ), "DVHData", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0060 ), "DVHReferencedROISequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0062 ), "DVHROIContributionType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0070 ), "DVHMinimumDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0072 ), "DVHMaximumDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3004, 0x0074 ), "DVHMeanDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0002 ), "StructureSetLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0004 ), "StructureSetName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0006 ), "StructureSetDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0008 ), "StructureSetDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0009 ), "StructureSetTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0010 ), "ReferencedFrameOfReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0012 ), "RTReferencedStudySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0014 ), "RTReferencedSeriesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0016 ), "ContourImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0020 ), "StructureSetROISequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0022 ), "ROINumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0024 ), "ReferencedFrameOfReferenceUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0026 ), "ROIName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0028 ), "ROIDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x002A ), "ROIDisplayColor", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x002C ), "ROIVolume", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0030 ), "RTRelatedROISequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0033 ), "RTROIRelationship", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0036 ), "ROIGenerationAlgorithm", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0038 ), "ROIGenerationDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0039 ), "ROIContourSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0040 ), "ContourSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0042 ), "ContourGeometricType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0044 ), "ContourSlabThickness", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0045 ), "ContourOffsetVector", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0046 ), "NumberOfContourPoints", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0048 ), "ContourNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0049 ), "AttachedContours", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0050 ), "ContourData", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0080 ), "RTROIObservationsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0082 ), "ObservationNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0084 ), "ReferencedROINumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0085 ), "ROIObservationLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0086 ), "RTROIIdentificationCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x0088 ), "ROIObservationDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00A0 ), "RelatedRTROIObservationsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00A4 ), "RTROIInterpretedType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00A6 ), "ROIInterpreter", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00B0 ), "ROIPhysicalPropertiesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00B2 ), "ROIPhysicalProperty", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00B4 ), "ROIPhysicalPropertyValue", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00B6 ), "ROIElementalCompositionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00B7 ), "ROIElementalCompositionAtomicNumber", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00B8 ), "ROIElementalCompositionAtomicMassFraction", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00C0 ), "FrameOfReferenceRelationshipSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00C2 ), "RelatedFrameOfReferenceUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00C4 ), "FrameOfReferenceTransformationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00C6 ), "FrameOfReferenceTransformationMatrix", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3006, 0x00C8 ), "FrameOfReferenceTransformationComment", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0010 ), "MeasuredDoseReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0012 ), "MeasuredDoseDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0014 ), "MeasuredDoseType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0016 ), "MeasuredDoseValue", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0020 ), "TreatmentSessionBeamSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0021 ), "TreatmentSessionIonBeamSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0022 ), "CurrentFractionNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0024 ), "TreatmentControlPointDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0025 ), "TreatmentControlPointTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x002A ), "TreatmentTerminationStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x002B ), "TreatmentTerminationCode", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x002C ), "TreatmentVerificationStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0030 ), "ReferencedTreatmentRecordSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0032 ), "SpecifiedPrimaryMeterset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0033 ), "SpecifiedSecondaryMeterset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0036 ), "DeliveredPrimaryMeterset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0037 ), "DeliveredSecondaryMeterset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x003A ), "SpecifiedTreatmentTime", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x003B ), "DeliveredTreatmentTime", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0040 ), "ControlPointDeliverySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0041 ), "IonControlPointDeliverySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0042 ), "SpecifiedMeterset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0044 ), "DeliveredMeterset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0045 ), "MetersetRateSet", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0046 ), "MetersetRateDelivered", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0047 ), "ScanSpotMetersetsDelivered", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0048 ), "DoseRateDelivered", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0050 ), "TreatmentSummaryCalculatedDoseReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0052 ), "CumulativeDoseToDoseReference", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0054 ), "FirstTreatmentDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0056 ), "MostRecentTreatmentDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x005A ), "NumberOfFractionsDelivered", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0060 ), "OverrideSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0061 ), "ParameterSequencePointer", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0062 ), "OverrideParameterPointer", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0063 ), "ParameterItemIndex", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0064 ), "MeasuredDoseReferenceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0065 ), "ParameterPointer", "AT" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0066 ), "OverrideReason", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0068 ), "CorrectedParameterSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x006A ), "CorrectionValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0070 ), "CalculatedDoseReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0072 ), "CalculatedDoseReferenceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0074 ), "CalculatedDoseReferenceDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0076 ), "CalculatedDoseReferenceDoseValue", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0078 ), "StartMeterset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x007A ), "EndMeterset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0080 ), "ReferencedMeasuredDoseReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0082 ), "ReferencedMeasuredDoseReferenceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0090 ), "ReferencedCalculatedDoseReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0092 ), "ReferencedCalculatedDoseReferenceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x00A0 ), "BeamLimitingDeviceLeafPairsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x00B0 ), "RecordedWedgeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x00C0 ), "RecordedCompensatorSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x00D0 ), "RecordedBlockSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x00E0 ), "TreatmentSummaryMeasuredDoseReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x00F0 ), "RecordedSnoutSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x00F2 ), "RecordedRangeShifterSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x00F4 ), "RecordedLateralSpreadingDeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x00F6 ), "RecordedRangeModulatorSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0100 ), "RecordedSourceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0105 ), "SourceSerialNumber", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0110 ), "TreatmentSessionApplicationSetupSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0116 ), "ApplicationSetupCheck", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0120 ), "RecordedBrachyAccessoryDeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0122 ), "ReferencedBrachyAccessoryDeviceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0130 ), "RecordedChannelSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0132 ), "SpecifiedChannelTotalTime", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0134 ), "DeliveredChannelTotalTime", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0136 ), "SpecifiedNumberOfPulses", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0138 ), "DeliveredNumberOfPulses", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x013A ), "SpecifiedPulseRepetitionInterval", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x013C ), "DeliveredPulseRepetitionInterval", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0140 ), "RecordedSourceApplicatorSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0142 ), "ReferencedSourceApplicatorNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0150 ), "RecordedChannelShieldSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0152 ), "ReferencedChannelShieldNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0160 ), "BrachyControlPointDeliveredSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0162 ), "SafePositionExitDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0164 ), "SafePositionExitTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0166 ), "SafePositionReturnDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0168 ), "SafePositionReturnTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0200 ), "CurrentTreatmentStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0202 ), "TreatmentStatusComment", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0220 ), "FractionGroupSummarySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0223 ), "ReferencedFractionNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0224 ), "FractionGroupType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0230 ), "BeamStopperPosition", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0240 ), "FractionStatusSummarySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0250 ), "TreatmentDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x3008, 0x0251 ), "TreatmentTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0002 ), "RTPlanLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0003 ), "RTPlanName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0004 ), "RTPlanDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0006 ), "RTPlanDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0007 ), "RTPlanTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0009 ), "TreatmentProtocols", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x000A ), "PlanIntent", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x000B ), "TreatmentSites", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x000C ), "RTPlanGeometry", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x000E ), "PrescriptionDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0010 ), "DoseReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0012 ), "DoseReferenceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0013 ), "DoseReferenceUID", "UI" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0014 ), "DoseReferenceStructureType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0015 ), "NominalBeamEnergyUnit", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0016 ), "DoseReferenceDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0018 ), "DoseReferencePointCoordinates", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x001A ), "NominalPriorDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0020 ), "DoseReferenceType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0021 ), "ConstraintWeight", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0022 ), "DeliveryWarningDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0023 ), "DeliveryMaximumDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0025 ), "TargetMinimumDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0026 ), "TargetPrescriptionDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0027 ), "TargetMaximumDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0028 ), "TargetUnderdoseVolumeFraction", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x002A ), "OrganAtRiskFullVolumeDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x002B ), "OrganAtRiskLimitDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x002C ), "OrganAtRiskMaximumDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x002D ), "OrganAtRiskOverdoseVolumeFraction", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0040 ), "ToleranceTableSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0042 ), "ToleranceTableNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0043 ), "ToleranceTableLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0044 ), "GantryAngleTolerance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0046 ), "BeamLimitingDeviceAngleTolerance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0048 ), "BeamLimitingDeviceToleranceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x004A ), "BeamLimitingDevicePositionTolerance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x004B ), "SnoutPositionTolerance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x004C ), "PatientSupportAngleTolerance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x004E ), "TableTopEccentricAngleTolerance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x004F ), "TableTopPitchAngleTolerance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0050 ), "TableTopRollAngleTolerance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0051 ), "TableTopVerticalPositionTolerance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0052 ), "TableTopLongitudinalPositionTolerance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0053 ), "TableTopLateralPositionTolerance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0055 ), "RTPlanRelationship", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0070 ), "FractionGroupSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0071 ), "FractionGroupNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0072 ), "FractionGroupDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0078 ), "NumberOfFractionsPlanned", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0079 ), "NumberOfFractionPatternDigitsPerDay", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x007A ), "RepeatFractionCycleLength", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x007B ), "FractionPattern", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0080 ), "NumberOfBeams", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0082 ), "BeamDoseSpecificationPoint", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0084 ), "BeamDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0086 ), "BeamMeterset", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0088 ), "BeamDosePointDepth", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0089 ), "BeamDosePointEquivalentDepth", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x008A ), "BeamDosePointSSD", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00A0 ), "NumberOfBrachyApplicationSetups", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00A2 ), "BrachyApplicationSetupDoseSpecificationPoint", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00A4 ), "BrachyApplicationSetupDose", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00B0 ), "BeamSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00B2 ), "TreatmentMachineName", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00B3 ), "PrimaryDosimeterUnit", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00B4 ), "SourceAxisDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00B6 ), "BeamLimitingDeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00B8 ), "RTBeamLimitingDeviceType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00BA ), "SourceToBeamLimitingDeviceDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00BB ), "IsocenterToBeamLimitingDeviceDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00BC ), "NumberOfLeafJawPairs", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00BE ), "LeafPositionBoundaries", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00C0 ), "BeamNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00C2 ), "BeamName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00C3 ), "BeamDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00C4 ), "BeamType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00C6 ), "RadiationType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00C7 ), "HighDoseTechniqueType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00C8 ), "ReferenceImageNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00CA ), "PlannedVerificationImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00CC ), "ImagingDeviceSpecificAcquisitionParameters", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00CE ), "TreatmentDeliveryType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D0 ), "NumberOfWedges", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D1 ), "WedgeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D2 ), "WedgeNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D3 ), "WedgeType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D4 ), "WedgeID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D5 ), "WedgeAngle", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D6 ), "WedgeFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D7 ), "TotalWedgeTrayWaterEquivalentThickness", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D8 ), "WedgeOrientation", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00D9 ), "IsocenterToWedgeTrayDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00DA ), "SourceToWedgeTrayDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00DB ), "WedgeThinEdgePosition", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00DC ), "BolusID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00DD ), "BolusDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E0 ), "NumberOfCompensators", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E1 ), "MaterialID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E2 ), "TotalCompensatorTrayFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E3 ), "CompensatorSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E4 ), "CompensatorNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E5 ), "CompensatorID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E6 ), "SourceToCompensatorTrayDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E7 ), "CompensatorRows", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E8 ), "CompensatorColumns", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00E9 ), "CompensatorPixelSpacing", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00EA ), "CompensatorPosition", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00EB ), "CompensatorTransmissionData", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00EC ), "CompensatorThicknessData", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00ED ), "NumberOfBoli", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00EE ), "CompensatorType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00F0 ), "NumberOfBlocks", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00F2 ), "TotalBlockTrayFactor", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00F3 ), "TotalBlockTrayWaterEquivalentThickness", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00F4 ), "BlockSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00F5 ), "BlockTrayID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00F6 ), "SourceToBlockTrayDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00F7 ), "IsocenterToBlockTrayDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00F8 ), "BlockType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00F9 ), "AccessoryCode", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00FA ), "BlockDivergence", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00FB ), "BlockMountingPosition", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00FC ), "BlockNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x00FE ), "BlockName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0100 ), "BlockThickness", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0102 ), "BlockTransmission", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0104 ), "BlockNumberOfPoints", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0106 ), "BlockData", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0107 ), "ApplicatorSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0108 ), "ApplicatorID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0109 ), "ApplicatorType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x010A ), "ApplicatorDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x010C ), "CumulativeDoseReferenceCoefficient", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x010E ), "FinalCumulativeMetersetWeight", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0110 ), "NumberOfControlPoints", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0111 ), "ControlPointSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0112 ), "ControlPointIndex", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0114 ), "NominalBeamEnergy", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0115 ), "DoseRateSet", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0116 ), "WedgePositionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0118 ), "WedgePosition", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x011A ), "BeamLimitingDevicePositionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x011C ), "LeafJawPositions", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x011E ), "GantryAngle", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x011F ), "GantryRotationDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0120 ), "BeamLimitingDeviceAngle", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0121 ), "BeamLimitingDeviceRotationDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0122 ), "PatientSupportAngle", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0123 ), "PatientSupportRotationDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0124 ), "TableTopEccentricAxisDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0125 ), "TableTopEccentricAngle", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0126 ), "TableTopEccentricRotationDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0128 ), "TableTopVerticalPosition", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0129 ), "TableTopLongitudinalPosition", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x012A ), "TableTopLateralPosition", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x012C ), "IsocenterPosition", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x012E ), "SurfaceEntryPoint", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0130 ), "SourceToSurfaceDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0134 ), "CumulativeMetersetWeight", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0140 ), "TableTopPitchAngle", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0142 ), "TableTopPitchRotationDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0144 ), "TableTopRollAngle", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0146 ), "TableTopRollRotationDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0148 ), "HeadFixationAngle", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x014A ), "GantryPitchAngle", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x014C ), "GantryPitchRotationDirection", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x014E ), "GantryPitchAngleTolerance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0180 ), "PatientSetupSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0182 ), "PatientSetupNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0183 ), "PatientSetupLabel", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0184 ), "PatientAdditionalPosition", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0190 ), "FixationDeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0192 ), "FixationDeviceType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0194 ), "FixationDeviceLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0196 ), "FixationDeviceDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0198 ), "FixationDevicePosition", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0199 ), "FixationDevicePitchAngle", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x019A ), "FixationDeviceRollAngle", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01A0 ), "ShieldingDeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01A2 ), "ShieldingDeviceType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01A4 ), "ShieldingDeviceLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01A6 ), "ShieldingDeviceDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01A8 ), "ShieldingDevicePosition", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01B0 ), "SetupTechnique", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01B2 ), "SetupTechniqueDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01B4 ), "SetupDeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01B6 ), "SetupDeviceType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01B8 ), "SetupDeviceLabel", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01BA ), "SetupDeviceDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01BC ), "SetupDeviceParameter", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01D0 ), "SetupReferenceDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01D2 ), "TableTopVerticalSetupDisplacement", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01D4 ), "TableTopLongitudinalSetupDisplacement", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x01D6 ), "TableTopLateralSetupDisplacement", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0200 ), "BrachyTreatmentTechnique", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0202 ), "BrachyTreatmentType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0206 ), "TreatmentMachineSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0210 ), "SourceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0212 ), "SourceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0214 ), "SourceType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0216 ), "SourceManufacturer", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0218 ), "ActiveSourceDiameter", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x021A ), "ActiveSourceLength", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0222 ), "SourceEncapsulationNominalThickness", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0224 ), "SourceEncapsulationNominalTransmission", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0226 ), "SourceIsotopeName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0228 ), "SourceIsotopeHalfLife", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0229 ), "SourceStrengthUnits", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x022A ), "ReferenceAirKermaRate", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x022B ), "SourceStrength", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x022C ), "SourceStrengthReferenceDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x022E ), "SourceStrengthReferenceTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0230 ), "ApplicationSetupSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0232 ), "ApplicationSetupType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0234 ), "ApplicationSetupNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0236 ), "ApplicationSetupName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0238 ), "ApplicationSetupManufacturer", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0240 ), "TemplateNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0242 ), "TemplateType", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0244 ), "TemplateName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0250 ), "TotalReferenceAirKerma", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0260 ), "BrachyAccessoryDeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0262 ), "BrachyAccessoryDeviceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0263 ), "BrachyAccessoryDeviceID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0264 ), "BrachyAccessoryDeviceType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0266 ), "BrachyAccessoryDeviceName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x026A ), "BrachyAccessoryDeviceNominalThickness", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x026C ), "BrachyAccessoryDeviceNominalTransmission", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0280 ), "ChannelSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0282 ), "ChannelNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0284 ), "ChannelLength", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0286 ), "ChannelTotalTime", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0288 ), "SourceMovementType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x028A ), "NumberOfPulses", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x028C ), "PulseRepetitionInterval", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0290 ), "SourceApplicatorNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0291 ), "SourceApplicatorID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0292 ), "SourceApplicatorType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0294 ), "SourceApplicatorName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0296 ), "SourceApplicatorLength", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0298 ), "SourceApplicatorManufacturer", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x029C ), "SourceApplicatorWallNominalThickness", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x029E ), "SourceApplicatorWallNominalTransmission", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02A0 ), "SourceApplicatorStepSize", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02A2 ), "TransferTubeNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02A4 ), "TransferTubeLength", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02B0 ), "ChannelShieldSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02B2 ), "ChannelShieldNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02B3 ), "ChannelShieldID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02B4 ), "ChannelShieldName", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02B8 ), "ChannelShieldNominalThickness", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02BA ), "ChannelShieldNominalTransmission", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02C8 ), "FinalCumulativeTimeWeight", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02D0 ), "BrachyControlPointSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02D2 ), "ControlPointRelativePosition", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02D4 ), "ControlPoint3DPosition", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02D6 ), "CumulativeTimeWeight", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02E0 ), "CompensatorDivergence", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02E1 ), "CompensatorMountingPosition", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02E2 ), "SourceToCompensatorDistance", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02E3 ), "TotalCompensatorTrayWaterEquivalentThickness", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02E4 ), "IsocenterToCompensatorTrayDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02E5 ), "CompensatorColumnOffset", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02E6 ), "IsocenterToCompensatorDistances", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02E7 ), "CompensatorRelativeStoppingPowerRatio", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02E8 ), "CompensatorMillingToolDiameter", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02EA ), "IonRangeCompensatorSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x02EB ), "CompensatorDescription", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0302 ), "RadiationMassNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0304 ), "RadiationAtomicNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0306 ), "RadiationChargeState", "SS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0308 ), "ScanMode", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x030A ), "VirtualSourceAxisDistances", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x030C ), "SnoutSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x030D ), "SnoutPosition", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x030F ), "SnoutID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0312 ), "NumberOfRangeShifters", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0314 ), "RangeShifterSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0316 ), "RangeShifterNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0318 ), "RangeShifterID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0320 ), "RangeShifterType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0322 ), "RangeShifterDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0330 ), "NumberOfLateralSpreadingDevices", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0332 ), "LateralSpreadingDeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0334 ), "LateralSpreadingDeviceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0336 ), "LateralSpreadingDeviceID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0338 ), "LateralSpreadingDeviceType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x033A ), "LateralSpreadingDeviceDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x033C ), "LateralSpreadingDeviceWaterEquivalentThickness", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0340 ), "NumberOfRangeModulators", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0342 ), "RangeModulatorSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0344 ), "RangeModulatorNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0346 ), "RangeModulatorID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0348 ), "RangeModulatorType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x034A ), "RangeModulatorDescription", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x034C ), "BeamCurrentModulationID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0350 ), "PatientSupportType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0352 ), "PatientSupportID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0354 ), "PatientSupportAccessoryCode", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0356 ), "FixationLightAzimuthalAngle", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0358 ), "FixationLightPolarAngle", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x035A ), "MetersetRate", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0360 ), "RangeShifterSettingsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0362 ), "RangeShifterSetting", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0364 ), "IsocenterToRangeShifterDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0366 ), "RangeShifterWaterEquivalentThickness", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0370 ), "LateralSpreadingDeviceSettingsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0372 ), "LateralSpreadingDeviceSetting", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0374 ), "IsocenterToLateralSpreadingDeviceDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0380 ), "RangeModulatorSettingsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0382 ), "RangeModulatorGatingStartValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0384 ), "RangeModulatorGatingStopValue", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0386 ), "RangeModulatorGatingStartWaterEquivalentThickness", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0388 ), "RangeModulatorGatingStopWaterEquivalentThickness", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x038A ), "IsocenterToRangeModulatorDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0390 ), "ScanSpotTuneID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0392 ), "NumberOfScanSpotPositions", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0394 ), "ScanSpotPositionMap", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0396 ), "ScanSpotMetersetWeights", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0398 ), "ScanningSpotSize", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x039A ), "NumberOfPaintings", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x03A0 ), "IonToleranceTableSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x03A2 ), "IonBeamSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x03A4 ), "IonBeamLimitingDeviceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x03A6 ), "IonBlockSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x03A8 ), "IonControlPointSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x03AA ), "IonWedgeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x03AC ), "IonWedgePositionSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0401 ), "ReferencedSetupImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0402 ), "SetupImageComment", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0410 ), "MotionSynchronizationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0412 ), "ControlPointOrientation", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0420 ), "GeneralAccessorySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0421 ), "GeneralAccessoryID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0422 ), "GeneralAccessoryDescription", "ST" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0423 ), "GeneralAccessoryType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0424 ), "GeneralAccessoryNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0431 ), "ApplicatorGeometrySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0432 ), "ApplicatorApertureShape", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0433 ), "ApplicatorOpening", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0434 ), "ApplicatorOpeningX", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0435 ), "ApplicatorOpeningY", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300A, 0x0436 ), "SourceToApplicatorMountingPositionDistance", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0002 ), "ReferencedRTPlanSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0004 ), "ReferencedBeamSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0006 ), "ReferencedBeamNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0007 ), "ReferencedReferenceImageNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0008 ), "StartCumulativeMetersetWeight", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0009 ), "EndCumulativeMetersetWeight", "DS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x000A ), "ReferencedBrachyApplicationSetupSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x000C ), "ReferencedBrachyApplicationSetupNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x000E ), "ReferencedSourceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0020 ), "ReferencedFractionGroupSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0022 ), "ReferencedFractionGroupNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0040 ), "ReferencedVerificationImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0042 ), "ReferencedReferenceImageSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0050 ), "ReferencedDoseReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0051 ), "ReferencedDoseReferenceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0055 ), "BrachyReferencedDoseReferenceSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0060 ), "ReferencedStructureSetSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x006A ), "ReferencedPatientSetupNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0080 ), "ReferencedDoseSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x00A0 ), "ReferencedToleranceTableNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x00B0 ), "ReferencedBolusSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x00C0 ), "ReferencedWedgeNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x00D0 ), "ReferencedCompensatorNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x00E0 ), "ReferencedBlockNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x00F0 ), "ReferencedControlPointIndex", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x00F2 ), "ReferencedControlPointSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x00F4 ), "ReferencedStartControlPointIndex", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x00F6 ), "ReferencedStopControlPointIndex", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0100 ), "ReferencedRangeShifterNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0102 ), "ReferencedLateralSpreadingDeviceNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300C, 0x0104 ), "ReferencedRangeModulatorNumber", "IS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300E, 0x0002 ), "ApprovalStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x300E, 0x0004 ), "ReviewDate", "DA" ));
mAddEntry (DicomElement ( DicomTag ( 0x300E, 0x0005 ), "ReviewTime", "TM" ));
mAddEntry (DicomElement ( DicomTag ( 0x300E, 0x0008 ), "ReviewerName", "PN" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x0001 ), "LowEnergyDetectors", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x0002 ), "HighEnergyDetectors", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x0004 ), "DetectorGeometrySequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1001 ), "ThreatROIVoxelSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1004 ), "ThreatROIBase", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1005 ), "ThreatROIExtents", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1006 ), "ThreatROIBitmap", "OB" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1007 ), "RouteSegmentID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1008 ), "GantryType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1009 ), "OOIOwnerType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x100A ), "RouteSegmentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1010 ), "PotentialThreatObjectID", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1011 ), "ThreatSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1012 ), "ThreatCategory", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1013 ), "ThreatCategoryDescription", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1014 ), "ATDAbilityAssessment", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1015 ), "ATDAssessmentFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1016 ), "ATDAssessmentProbability", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1017 ), "Mass", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1018 ), "Density", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1019 ), "ZEffective", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x101A ), "BoardingPassID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x101B ), "CenterOfMass", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x101C ), "CenterOfPTO", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x101D ), "BoundingPolygon", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x101E ), "RouteSegmentStartLocationID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x101F ), "RouteSegmentEndLocationID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1020 ), "RouteSegmentLocationIDType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1021 ), "AbortReason", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1023 ), "VolumeOfPTO", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1024 ), "AbortFlag", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1025 ), "RouteSegmentStartTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1026 ), "RouteSegmentEndTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1027 ), "TDRType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1028 ), "InternationalRouteSegment", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1029 ), "ThreatDetectionAlgorithmandVersion", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x102A ), "AssignedLocation", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x102B ), "AlarmDecisionTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1031 ), "AlarmDecision", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1033 ), "NumberOfTotalObjects", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1034 ), "NumberOfAlarmObjects", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1037 ), "PTORepresentationSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1038 ), "ATDAssessmentSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1039 ), "TIPType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x103A ), "DICOSVersion", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1041 ), "OOIOwnerCreationTime", "DT" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1042 ), "OOIType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1043 ), "OOISize", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1044 ), "AcquisitionStatus", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1045 ), "BasisMaterialsCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1046 ), "PhantomType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1047 ), "OOIOwnerSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1048 ), "ScanType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1051 ), "ItineraryID", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1052 ), "ItineraryIDType", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1053 ), "ItineraryIDAssigningAuthority", "LO" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1054 ), "RouteID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1055 ), "RouteIDAssigningAuthority", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1056 ), "InboundArrivalType", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1058 ), "CarrierID", "SH" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1059 ), "CarrierIDAssigningAuthority", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1060 ), "SourceOrientation", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1061 ), "SourcePosition", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1062 ), "BeltHeight", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1064 ), "AlgorithmRoutingCodeSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1067 ), "TransportClassification", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1068 ), "OOITypeDescriptor", "LT" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x1069 ), "TotalProcessingTime", "FL" ));
mAddEntry (DicomElement ( DicomTag ( 0x4010, 0x106C ), "DetectorCalibrationData", "OB" ));
mAddEntry (DicomElement ( DicomTag ( 0x4FFE, 0x0001 ), "MACParametersSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x5200, 0x9229 ), "SharedFunctionalGroupsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x5200, 0x9230 ), "PerFrameFunctionalGroupsSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x5400, 0x0100 ), "WaveformSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0x5400, 0x0110 ), "ChannelMinimumValue", "OB or OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x5400, 0x0112 ), "ChannelMaximumValue", "OB or OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x5400, 0x1004 ), "WaveformBitsAllocated", "US" ));
mAddEntry (DicomElement ( DicomTag ( 0x5400, 0x1006 ), "WaveformSampleInterpretation", "CS" ));
mAddEntry (DicomElement ( DicomTag ( 0x5400, 0x100A ), "WaveformPaddingValue", "OB or OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x5400, 0x1010 ), "WaveformData", "OB or OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x5600, 0x0010 ), "FirstOrderPhaseCorrectionAngle", "OF" ));
mAddEntry (DicomElement ( DicomTag ( 0x5600, 0x0020 ), "SpectroscopyData", "OF" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0010 ), "OverlayRows", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0011 ), "OverlayColumns", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0015 ), "NumberOfFramesInOverlay", "IS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0022 ), "OverlayDescription", "LO" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0040 ), "OverlayType", "CS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0045 ), "OverlaySubtype", "LO" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0050 ), "OverlayOrigin", "SS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0051 ), "ImageFrameOrigin", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0100 ), "OverlayBitsAllocated", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x0102 ), "OverlayBitPosition", "US" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1001 ), "OverlayActivationLayer", "CS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1301 ), "ROIArea", "IS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1302 ), "ROIMean", "DS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1303 ), "ROIStandardDeviation", "DS" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x1500 ), "OverlayLabel", "LO" ));
//mAddEntry (DicomElement ( DicomTag ( 0x60xx, 0x3000 ), "OverlayData", "OB or OW" ));
mAddEntry (DicomElement ( DicomTag ( 0x7FE0, 0x0010 ), "PixelData", "OW or OB" ));
mAddEntry (DicomElement ( DicomTag ( 0xFFFA, 0xFFFA ), "DigitalSignaturesSequence", "SQ" ));
mAddEntry (DicomElement ( DicomTag ( 0xFFFC, 0xFFFC ), "DataSetTrailingPadding", "OB" ));
mAddEntry (DicomElement ( DicomTag ( 0xFFFE, 0xE000 ), "Item", "" ));
mAddEntry (DicomElement ( DicomTag ( 0xFFFE, 0xE00D ), "ItemDelimitationItem", "" ));
mAddEntry (DicomElement ( DicomTag ( 0xFFFE, 0xE0DD ), "SequenceDelimitationItem", "" ));
