from _typeshed import WriteableBuffer
from io import BufferedIOBase, RawIOBase
from typing import Any, Callable, Protocol, Type

BUFFER_SIZE: Any

class _Reader(Protocol):
    def read(self, __n: int) -> bytes: ...
    def seekable(self) -> bool: ...
    def seek(self, __n: int) -> Any: ...

class BaseStream(BufferedIOBase): ...

class DecompressReader(RawIOBase):
    def __init__(
        self,
        fp: _Reader,
        decomp_factory: Callable[..., object],
        trailing_error: Type[Exception] | tuple[Type[Exception], ...] = ...,
        **decomp_args: Any,
    ) -> None: ...
    def readable(self) -> bool: ...
    def close(self) -> None: ...
    def seekable(self) -> bool: ...
    def readinto(self, b: WriteableBuffer) -> int: ...
    def read(self, size: int = ...) -> bytes: ...
    def seek(self, offset: int, whence: int = ...) -> int: ...
    def tell(self) -> int: ...
