/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.CallTemplate;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLCallTemplate
extends StyleElement {
    private StructuredQName calledTemplateName;
    private XSLTemplate template = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private boolean gettingReturnedItemType = false;

    protected boolean allowAVT() {
        return false;
    }

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.template == null || this.gettingReturnedItemType) {
            return AnyItemType.getInstance();
        }
        this.gettingReturnedItemType = true;
        ItemType result = this.template.getReturnedItemType();
        this.gettingReturnedItemType = false;
        return result;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAttribute = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                nameAttribute = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (nameAttribute == null) {
            this.calledTemplateName = new StructuredQName("saxon", "http://saxon.sf.net/", "error-template");
            this.reportAbsence("name");
            return;
        }
        if (this.allowAVT() && nameAttribute.indexOf(123) >= 0) {
            this.calledTemplateExpression = this.makeAttributeValueTemplate(nameAttribute);
        } else {
            try {
                this.calledTemplateName = this.makeQName(nameAttribute);
            }
            catch (NamespaceException err) {
                this.calledTemplateName = new StructuredQName("saxon", "http://saxon.sf.net/", "error-template");
                this.compileError(err.getMessage(), "XTSE0280");
            }
            catch (XPathException err) {
                this.calledTemplateName = new StructuredQName("saxon", "http://saxon.sf.net/", "error-template");
                this.compileError(err.getMessage(), err.getErrorCodeQName());
            }
        }
    }

    public void validate() throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLWithParam || child instanceof XSLFallback && this.mayContainFallback()) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:call-template", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed within xsl:call-template", "XTSE0010");
        }
        if (!(this.calledTemplateExpression != null || this.calledTemplateName.getNamespaceURI().equals("http://saxon.sf.net/") && this.calledTemplateName.getLocalName().equals("error-template"))) {
            this.template = this.findTemplate(this.calledTemplateName);
            if (this.template == null) {
                return;
            }
        }
        this.calledTemplateExpression = this.typeCheck("name", this.calledTemplateExpression);
    }

    public void postValidate() throws XPathException {
        if (this.template != null) {
            NodeInfo w;
            NodeInfo param;
            AxisIterator declaredParams = this.template.iterateAxis((byte)3);
            while ((param = (NodeInfo)declaredParams.next()) != null) {
                NodeInfo withParam;
                if (!(param instanceof XSLParam) || !((XSLParam)param).isRequiredParam() || ((XSLParam)param).isTunnelParam()) continue;
                AxisIterator actualParams = this.iterateAxis((byte)3);
                boolean ok = false;
                while ((withParam = (NodeInfo)actualParams.next()) != null) {
                    if (!(withParam instanceof XSLWithParam) || !((XSLWithParam)withParam).getVariableQName().equals(((XSLParam)param).getVariableQName())) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                this.compileError("No value supplied for required parameter " + Err.wrap(((XSLParam)param).getVariableDisplayName(), 5), "XTSE0690");
            }
            AxisIterator actualParams = this.iterateAxis((byte)3);
            while ((w = (NodeInfo)actualParams.next()) != null) {
                NodeInfo param2;
                if (!(w instanceof XSLWithParam) || ((XSLWithParam)w).isTunnelParam()) continue;
                XSLWithParam withParam = (XSLWithParam)w;
                AxisIterator formalParams = this.template.iterateAxis((byte)3);
                boolean ok = false;
                while ((param2 = (NodeInfo)formalParams.next()) != null) {
                    if (!(param2 instanceof XSLParam) || !((XSLParam)param2).getVariableQName().equals(withParam.getVariableQName())) continue;
                    ok = true;
                    SequenceType required = ((XSLParam)param2).getRequiredType();
                    withParam.checkAgainstRequiredType(required);
                    break;
                }
                if (ok || this.backwardsCompatibleModeIsEnabled()) continue;
                this.compileError("Parameter " + withParam.getVariableDisplayName() + " is not declared in the called template", "XTSE0680");
            }
        }
    }

    private XSLTemplate findTemplate(StructuredQName templateName) throws XPathException {
        XSLStylesheet stylesheet = this.getPrincipalStylesheet();
        List toplevel = stylesheet.getTopLevel();
        for (int i = toplevel.size() - 1; i >= 0; --i) {
            XSLTemplate t;
            if (!(toplevel.get(i) instanceof XSLTemplate) || !templateName.equals((t = (XSLTemplate)toplevel.get(i)).getTemplateName())) continue;
            return t;
        }
        this.compileError("No template exists named " + this.calledTemplateName, "XTSE0650");
        return null;
    }

    public boolean markTailCalls() {
        this.useTailRecursion = true;
        return true;
    }

    public Expression compile(Executable exec) throws XPathException {
        Template target = null;
        SavedNamespaceContext nsContext = null;
        if (this.calledTemplateExpression == null) {
            if (this.template == null) {
                return null;
            }
            target = this.template.getCompiledTemplate();
        } else {
            nsContext = this.makeNamespaceContext();
        }
        CallTemplate call = new CallTemplate(target, this.useTailRecursion, this.calledTemplateExpression, nsContext);
        call.setActualParameters(this.getWithParamInstructions(exec, false, call), this.getWithParamInstructions(exec, true, call));
        return call;
    }
}

