/* NeXus - Neutron & X-ray Common Data Format
 *
 * NeXus file validation GUI tool.
 *
 * Copyright (C) 2010 Stephen Rankin
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information, see <http://www.nexusformat.org/>
 *
 * BulkLoadFilesFrame.java
 *
 * Created on 10-Aug-2010, 15:32:56
 */

package org.nexusformat.nxvalidate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author Stephen Rankin
 */
public class BulkLoadFilesFrame extends javax.swing.JFrame {

    private File nxdlFile = null;
    private ArrayList<String> dataFileList = null;
    private FileActions fileLoadingActions = null;
    private boolean badFiles = false;
    private ResourceBundle bundle = null;
    private ArrayList<String> dataFileSelectedList = null;
    private CheckNexusFileType check = null;

    /** Creates new form BulkLoadFilesFrame */
    public BulkLoadFilesFrame(FileActions fileLoadingActions) {
        initComponents();
        this.fileLoadingActions = fileLoadingActions;
        bundle = ResourceBundle.getBundle(
                "org/nexusformat/nxvalidate/resources/nxvalidate");
        check = new CheckNexusFileType();

    }

    public BulkLoadFilesFrame() {
        initComponents();
        bundle = ResourceBundle.getBundle(
                "org/nexusformat/nxvalidate/resources/nxvalidate");
        check = new CheckNexusFileType();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jFileChooser1 = new javax.swing.JFileChooser();
        problemOptionPane = new javax.swing.JOptionPane();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel1 = new javax.swing.JPanel();
        loadNXDCButton = new javax.swing.JButton();
        loadDataFilesButton = new javax.swing.JButton();
        nxdcFileNameTextField = new javax.swing.JTextField();
        validateButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jCheckBox1 = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jPanel1.setVerifyInputWhenFocusTarget(false);

        loadNXDCButton.setText("Load NXDL");
        loadNXDCButton.setActionCommand("Load NXDL");
        loadNXDCButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadNXDCButtonActionPerformed(evt);
            }
        });

        loadDataFilesButton.setText("Load Data Files");
        loadDataFilesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadDataFilesButtonActionPerformed(evt);
            }
        });

        validateButton.setLabel("Validate");
        validateButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                validateButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jCheckBox1.setText("Load files only.");
        jCheckBox1.setToolTipText("Load files only, do not validate.");
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(loadNXDCButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(nxdcFileNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 549, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(loadDataFilesButton)
                        .addGap(92, 92, 92)
                        .addComponent(jCheckBox1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(cancelButton)
                        .addGap(33, 33, 33)
                        .addComponent(validateButton)))
                .addContainerGap(17, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadNXDCButton)
                    .addComponent(nxdcFileNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadDataFilesButton)
                    .addComponent(validateButton)
                    .addComponent(cancelButton)
                    .addComponent(jCheckBox1))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jSplitPane1.setTopComponent(jPanel1);

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null}
            },
            new String [] {
                "Include", "File Name"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Boolean.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        jScrollPane1.setViewportView(jTable1);
        jTable1.getColumnModel().getColumn(0).setMinWidth(60);
        jTable1.getColumnModel().getColumn(0).setPreferredWidth(60);
        jTable1.getColumnModel().getColumn(0).setMaxWidth(60);

        jSplitPane1.setRightComponent(jScrollPane1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 672, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSplitPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 534, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void loadNXDCButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadNXDCButtonActionPerformed
        if (evt.getSource() == loadNXDCButton) {

            jFileChooser1.setMultiSelectionEnabled(false);
            jFileChooser1.setFileSelectionMode(jFileChooser1.FILES_ONLY);
            int returnVal = jFileChooser1.showOpenDialog(this);

            if (returnVal == jFileChooser1.APPROVE_OPTION) {
                nxdlFile = jFileChooser1.getSelectedFile();

                if(check.checkNXDLFile(nxdlFile)){

                    nxdcFileNameTextField.setText(nxdlFile.getAbsolutePath());
                    nxdcFileNameTextField.setToolTipText(nxdlFile.getAbsolutePath());

                } else{
                    nxdlFile = null;
                    problemOptionPane.showMessageDialog(this,
                        bundle.getString("notNXDLFileMessage"));
                }

               
            } else {
                nxdlFile = null;
            }

        }
    }//GEN-LAST:event_loadNXDCButtonActionPerformed

    private void loadDataFilesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadDataFilesButtonActionPerformed
        if (evt.getSource() == loadDataFilesButton) {

            dataFileList = new ArrayList<String>();

            File[] dataFiles = null;
            jFileChooser1.setMultiSelectionEnabled(true);
            jFileChooser1.setFileSelectionMode(jFileChooser1.FILES_AND_DIRECTORIES);
            int returnVal = jFileChooser1.showOpenDialog(this);

            if (returnVal == jFileChooser1.APPROVE_OPTION) {
                try {
                    dataFiles = jFileChooser1.getSelectedFiles();
                    fileLoadingActions.setDataFiles(dataFiles);
                    fileLoadingActions.setWhich(3);
                    fileLoadingActions.bulkCheck();
                    dataFileList = fileLoadingActions.getDataFileList();
                    updateTable();
                } catch (FileNotFoundException ex) {
                    Logger.getLogger(BulkLoadFilesFrame.class.getName()).log(Level.SEVERE, null, ex);
                } catch (IOException ex) {
                    Logger.getLogger(BulkLoadFilesFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                dataFiles = null;
            }

        }
    }//GEN-LAST:event_loadDataFilesButtonActionPerformed

    private void updateTable() throws FileNotFoundException, IOException {

        DefaultTableModel tableModel = new DefaultTableModel(new Object[][]{
                    {null, null}
                },
                new String[]{
                    "Include", "File Name"
                }) {

            Class[] types = new Class[]{
                java.lang.Boolean.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types[columnIndex];
            }
        };

        tableModel.removeRow(0);

        Boolean useIt = new Boolean(true);
        Object[] row = new Object[2];
        for (int i = 0; i < dataFileList.size(); ++i) {
            row[1] = dataFileList.get(i);
            if (check.checkNexusFile(new File(dataFileList.get(i)))) {
                row[0] = new Boolean(true);
            } else {
                row[0] = new Boolean(false);
                badFiles = true;
            }

            tableModel.addRow(row);
        }

        jTable1.setModel(tableModel);
        jTable1.getColumnModel().getColumn(0).setMinWidth(60);
        jTable1.getColumnModel().getColumn(0).setPreferredWidth(60);
        jTable1.getColumnModel().getColumn(0).setMaxWidth(60);

        if (badFiles) {
            problemOptionPane.showMessageDialog(this,
                    bundle.getString("filesNotNexusError"));
        }

    }

    private void validateButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_validateButtonActionPerformed

        if (evt.getSource() == validateButton) {

            if (nxdlFile == null) {
                problemOptionPane.showMessageDialog(this,
                        bundle.getString("openSchemaFileMessage"));
                return;
            }

            if (fileLoadingActions.getNXConvertFile() == null) {
                problemOptionPane.showMessageDialog(this,
                        bundle.getString("noConvertCommandFound"));
                return;
            }


            Boolean checked = null;
            dataFileSelectedList = new ArrayList<String>();

            int rows = jTable1.getModel().getRowCount();

            for (int i = 0; i < rows; ++i) {
                checked = (Boolean) jTable1.getModel().getValueAt(i, 0);

                if (checked) {
                    dataFileSelectedList.add((String) jTable1.getModel().getValueAt(i, 1));
                }

            }

            if (jCheckBox1.isSelected()) {

                fileLoadingActions.setWhich(4);
                fileLoadingActions.setNXDLFile(nxdlFile);
                fileLoadingActions.setDataFileList(dataFileSelectedList);

                (new Thread(fileLoadingActions)).start();

            } else {

                fileLoadingActions.setWhich(5);
                fileLoadingActions.setNXDLFile(nxdlFile);
                fileLoadingActions.setDataFileList(dataFileSelectedList);

                (new Thread(fileLoadingActions)).start();

            }
        }
    }//GEN-LAST:event_validateButtonActionPerformed

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed

        if (evt.getSource() == jCheckBox1) {

            if (jCheckBox1.isSelected()) {
                validateButton.setText("Load");
            } else {
                validateButton.setText("Validate");
            }
        }

    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        if (evt.getSource() == cancelButton) {
            this.setVisible(false);
        }
    }//GEN-LAST:event_cancelButtonActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new BulkLoadFilesFrame().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JFileChooser jFileChooser1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JButton loadDataFilesButton;
    private javax.swing.JButton loadNXDCButton;
    private javax.swing.JTextField nxdcFileNameTextField;
    private javax.swing.JOptionPane problemOptionPane;
    private javax.swing.JButton validateButton;
    // End of variables declaration//GEN-END:variables
}
