/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.dsm.util.PedigreeUtils;
import com.sourceforge.knecs.util.NSProperty;
import com.sourceforge.knecs.util.converters.FormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.net.PasswordAuthentication;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.BasisSetDescriptor;
import org.scidac.cmcs.tools.bse.NWChemInputToBasisXml;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BasisSetCurate {
    protected BSEProperties mProperties;
    protected DSI dsi = null;
    protected PasswordAuthentication bsePA;

    public String saveCuration(String url, Hashtable params, PasswordAuthentication pa, DSI portalUserDSI) {
        String errorMessage;
        block10: {
            errorMessage = "";
            this.bsePA = pa;
            String contribURL = (String)params.get("contrib_url");
            try {
                DSI dsiForCurHistory = this.dsi = this.getDownloadDSI(url);
                try {
                    this.saveMetadata(params);
                }
                catch (Exception e) {
                    errorMessage = "Error occurred while saving metadata - " + e.getLocalizedMessage();
                    throw e;
                }
                try {
                    this.saveUserAnnotations(params);
                }
                catch (Exception e) {
                    errorMessage = "Error occurred while saving user annotations - " + e.getLocalizedMessage();
                    throw e;
                }
                try {
                    this.saveReferences(params);
                }
                catch (Exception e) {
                    errorMessage = "Error occurred while saving references - " + e.getLocalizedMessage();
                    throw e;
                }
                errorMessage = this.saveBSData(params, url, portalUserDSI);
                if (!"".equals(errorMessage)) break block10;
                try {
                    this.saveCurationAnnotations(params, portalUserDSI, dsiForCurHistory, errorMessage);
                }
                catch (Exception e) {
                    errorMessage = "Error occurred while saving curation annotations - " + e.getLocalizedMessage();
                    throw e;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return errorMessage;
    }

    public Hashtable getCurationData(String url, HashMap bsdata, PasswordAuthentication userPA) throws StatusException, ParserConfigurationException, IOException, SAXException {
        Hashtable<String, Object> context = new Hashtable<String, Object>();
        DSI portalUserDSI = this.getDSI(url, userPA);
        Vector<NSProperty> selectProperties = new Vector<NSProperty>();
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:curationStatus"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributionPIEmail"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:basisSetType"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:hasElements"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributorName"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributorId"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributionPI"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributionNotes"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:creator"));
        selectProperties.add(new NSProperty("http://purl.org/dc/elements/1.1/:title"));
        selectProperties.add(new NSProperty("DAV::creationdate"));
        selectProperties.add(new NSProperty("DAV::modificationdate"));
        selectProperties.add(new NSProperty("http://purl.org/dc/elements/1.1/:description"));
        selectProperties.add(new NSProperty("http://purl.org/dc/terms/:abstract"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:referencesLink"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:userAnnotations"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:basisSetLink"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:primaryBasisSetLink"));
        selectProperties.add(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:effectivePotentialsLink"));
        if (url.indexOf("_addElements") >= 0) {
            selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributionURL"));
        }
        String resourceUrl2 = null;
        Hashtable propcoll = null;
        Iterator dsiPropIt = null;
        Iterator propit = null;
        DSIProperty dsiProp = null;
        String propVal = null;
        Hashtable properties = portalUserDSI.getMetaData(selectProperties, 0);
        String references = null;
        Object primaryBasisSet = null;
        HashMap<String, String> basisSetLinks = new HashMap<String, String>();
        if (properties != null) {
            for (String resourceUrl2 : properties.keySet()) {
                propcoll = (Hashtable)properties.get(resourceUrl2);
                dsiPropIt = propcoll.values().iterator();
                while (dsiPropIt.hasNext()) {
                    Node hrefAttribute;
                    NodeList referenceList;
                    org.w3c.dom.Document elementDoc;
                    String parentPath;
                    int index;
                    DocumentBuilder db;
                    DocumentBuilderFactory dbf;
                    dsiProp = (DSIProperty)dsiPropIt.next();
                    dsiPropIt.remove();
                    propVal = dsiProp.getPropertyAsString().trim();
                    if (propVal.length() == 0) {
                        propVal = dsiProp.getPropertyAsXMLString(true).trim();
                    }
                    if (propVal == null || "".equals(propVal)) continue;
                    if ("primaryBasisSetLink".equals(dsiProp.getLocalName())) {
                        dbf = DocumentBuilderFactory.newInstance();
                        db = dbf.newDocumentBuilder();
                        org.w3c.dom.Document primaryBasisSetDoc = db.parse(new ByteArrayInputStream(propVal.getBytes()));
                        NodeList primaryBasisSetNodes = primaryBasisSetDoc.getElementsByTagName("href");
                        int size = primaryBasisSetNodes.getLength();
                        for (int i = 0; i < size; ++i) {
                            Node primaryBasisSetNode = primaryBasisSetNodes.item(i);
                            if (primaryBasisSetNode == null) continue;
                            NamedNodeMap attributes = primaryBasisSetNode.getAttributes();
                            Node primaryBSNode = attributes.getNamedItem("xlink:href");
                            index = portalUserDSI.getPath().lastIndexOf("/") + 1;
                            parentPath = portalUserDSI.getServer() + portalUserDSI.getPath().substring(0, index);
                            DSI basisSetLinkDSI = this.getDSI(parentPath + primaryBSNode.getNodeValue(), userPA);
                            selectProperties = new Vector();
                            selectProperties.add(new NSProperty("http://purl.org/dc/elements/1.1/:title"));
                            selectProperties.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:hasElements"));
                            Hashtable basisSetLinkProperties = basisSetLinkDSI.getMetaData(selectProperties);
                            if (basisSetLinkProperties == null) continue;
                            Iterator basisSetLinkIt = basisSetLinkProperties.keySet().iterator();
                            while (basisSetLinkIt.hasNext()) {
                                NSProperty basisSetLinkProp = (NSProperty)basisSetLinkIt.next();
                                DSIProperty basisSetLinkDsiProp = (DSIProperty)basisSetLinkProperties.get(basisSetLinkProp);
                                basisSetLinkIt.remove();
                                String basisSetLinkVal = basisSetLinkDsiProp.getPropertyAsString().trim();
                                if (basisSetLinkVal.length() == 0) {
                                    basisSetLinkVal = basisSetLinkDsiProp.getPropertyAsXMLString(true).trim();
                                }
                                if ("title".equals(basisSetLinkProp.getLocalName())) {
                                    HashMap<String, String> primaryBasisSetMap = new HashMap<String, String>();
                                    primaryBasisSetMap.put(basisSetLinkVal, basisSetLinkDSI.getURL());
                                    context.put("primaryBasisSet", primaryBasisSetMap);
                                }
                                if (!"hasElements".equals(basisSetLinkProp.getLocalName())) continue;
                                String elementList = new String();
                                dbf = DocumentBuilderFactory.newInstance();
                                db = dbf.newDocumentBuilder();
                                org.w3c.dom.Document elementDoc2 = db.parse(new ByteArrayInputStream(basisSetLinkVal.getBytes()));
                                NodeList elementNodes = elementDoc2.getElementsByTagName("li");
                                int elemListSize = elementNodes.getLength();
                                for (i = 0; i < elemListSize; ++i) {
                                    Node elementNode = elementNodes.item(i);
                                    if (elementNode == null) continue;
                                    elementList = elementList.concat(elementNode.getFirstChild().getNodeValue() + " ");
                                }
                                context.put("hasElements", elementList);
                            }
                        }
                    } else if ("basisSetLink".equals(dsiProp.getLocalName()) || "effectivePotentialsLink".equals(dsiProp.getLocalName())) {
                        dbf = DocumentBuilderFactory.newInstance();
                        db = dbf.newDocumentBuilder();
                        elementDoc = db.parse(new ByteArrayInputStream(propVal.getBytes()));
                        referenceList = elementDoc.getElementsByTagName("href");
                        int referenceListSize = referenceList.getLength();
                        for (int i = 0; i < referenceListSize; ++i) {
                            DSI basisSetLinkDSI;
                            Node referenceNode = referenceList.item(i);
                            if (referenceNode == null) continue;
                            NamedNodeMap attributes = referenceNode.getAttributes();
                            hrefAttribute = attributes.getNamedItem("xlink:href");
                            index = portalUserDSI.getPath().lastIndexOf("/") + 1;
                            parentPath = portalUserDSI.getServer() + portalUserDSI.getPath().substring(0, index);
                            String hrefValue = hrefAttribute.getNodeValue();
                            if (hrefValue.indexOf("/") > -1) {
                                parentPath = portalUserDSI.getServer();
                            }
                            if ((basisSetLinkDSI = this.getDSI(parentPath + hrefAttribute.getNodeValue(), userPA)).exists()) {
                                DSIProperty titleProp = basisSetLinkDSI.getMetaData(new NSProperty("http://purl.org/dc/elements/1.1/:title"));
                                String title = titleProp.getPropertyAsString().trim();
                                basisSetLinks.put(title, basisSetLinkDSI.getURL());
                                continue;
                            }
                            throw new StatusException(404, "Could not find basis set link DSI " + basisSetLinkDSI.getURL());
                        }
                        context.put("basisSetLinks", basisSetLinks);
                    } else if ("referencesLink".equals(dsiProp.getLocalName())) {
                        references = new String();
                        dbf = DocumentBuilderFactory.newInstance();
                        db = dbf.newDocumentBuilder();
                        elementDoc = db.parse(new ByteArrayInputStream(propVal.getBytes()));
                        referenceList = elementDoc.getElementsByTagName("href");
                        int size = referenceList.getLength();
                        for (int i = 0; i < size; ++i) {
                            Node referenceNode = referenceList.item(i);
                            if (referenceNode == null) continue;
                            NamedNodeMap attributes = referenceNode.getAttributes();
                            hrefAttribute = attributes.getNamedItem("xlink:href");
                            references = references.concat(hrefAttribute.getNodeValue());
                        }
                        context.put("referencesLink", references);
                    } else if ("description".equals(dsiProp.getLocalName()) || "abstract".equals(dsiProp.getLocalName()) || "contributionNotes".equals(dsiProp.getLocalName())) {
                        String newVal = BasisSetCurate.handleMultiLineValue(propVal);
                        String newValEnc = BasisSetCurate.handleMultiLineValueEncoded(propVal);
                        context.put(dsiProp.getLocalName(), newVal);
                        context.put(dsiProp.getLocalName() + "_encoded", newValEnc);
                    } else if ("userAnnotations".equals(dsiProp.getLocalName())) {
                        if (propVal != null && !"".equals(propVal)) {
                            String annotations = new String();
                            StringBuffer annotations_encoded = new StringBuffer();
                            DocumentBuilderFactory dbf2 = DocumentBuilderFactory.newInstance();
                            DocumentBuilder db2 = dbf2.newDocumentBuilder();
                            org.w3c.dom.Document elementDoc3 = db2.parse(new ByteArrayInputStream(propVal.getBytes()));
                            NodeList annotationList = elementDoc3.getElementsByTagName("li");
                            int size = annotationList.getLength();
                            for (int i = 0; i < size; ++i) {
                                Node annotationNode = annotationList.item(i);
                                if (annotationNode == null) continue;
                                annotations = annotations.concat(annotationNode.getFirstChild().getNodeValue());
                                annotations = annotations.concat("\n\n");
                                String[] lines = annotationNode.getFirstChild().getNodeValue().split("[\\n\\r]");
                                StringBuffer buf = new StringBuffer();
                                for (int j = 0; j < lines.length; ++j) {
                                    if (lines[j] == null || "".equals(lines[j])) continue;
                                    buf.append(lines[j].replaceAll("\"", "\\\\\""));
                                    buf.append('\\');
                                    buf.append('n');
                                    buf.append('\\');
                                    buf.append('n');
                                }
                                annotations_encoded.append(buf);
                            }
                            context.put(dsiProp.getLocalName() + "_encoded", annotations_encoded.toString());
                            context.put(dsiProp.getLocalName(), annotations.toString());
                        }
                    } else if ("hasElements".equals(dsiProp.getLocalName())) {
                        String elementList = new String();
                        DocumentBuilderFactory dbf3 = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db3 = dbf3.newDocumentBuilder();
                        org.w3c.dom.Document elementDoc4 = db3.parse(new ByteArrayInputStream(propVal.getBytes()));
                        NodeList elementNodes = elementDoc4.getElementsByTagName("li");
                        int size = elementNodes.getLength();
                        for (int i = 0; i < size; ++i) {
                            Node elementNode = elementNodes.item(i);
                            if (elementNode == null) continue;
                            elementList = elementList.concat(elementNode.getFirstChild().getNodeValue() + " ");
                        }
                        context.put(dsiProp.getLocalName(), elementList);
                    } else {
                        propVal = BasisSetDescriptor.getWebSafeString(propVal);
                        context.put(dsiProp.getLocalName(), propVal);
                    }
                    this.getLogger().finest("getLocalName: " + dsiProp.getLocalName() + " " + propVal);
                }
            }
        } else {
            System.out.println("result set is null.");
        }
        System.out.println("references: " + references);
        for (String key : bsdata.keySet()) {
            String basisdata = (String)bsdata.get(key);
            String[] lines = basisdata.split("[\\n\\r]");
            StringBuffer buf = new StringBuffer();
            StringBuffer enc_buf = new StringBuffer();
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i] == null || "".equals(lines[i])) continue;
                buf.append(lines[i].replaceAll("&#xD;", ""));
                buf.append('\n');
                enc_buf.append(lines[i].replaceAll("&#xD;", "").replaceAll("\"", "\\\\\""));
                enc_buf.append('\\');
                enc_buf.append('n');
            }
            basisdata = buf.toString();
            basisdata = basisdata.replaceAll("\"", "\\\\\"");
            bsdata.put(key, enc_buf);
            if (!key.equals("references") && !key.equals("header")) continue;
            context.put(key + "_unencoded", buf);
        }
        context.put("basis_contents", bsdata);
        return context;
    }

    public static String handleMultiLineValue(String val) {
        String[] lines = val.split("[\\n\\r]");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null || "".equals(lines[i])) continue;
            buf.append(lines[i].replaceAll("&#xD;", ""));
            buf.append('\n');
        }
        return buf.toString();
    }

    public static String handleMultiLineValueEncoded(String val) {
        String[] lines = val.split("[\\n\\r]");
        StringBuffer enc_buf = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null || "".equals(lines[i])) continue;
            enc_buf.append(lines[i].replaceAll("&#xD;", "").replaceAll("\"", "\\\\\""));
            enc_buf.append('\\');
            enc_buf.append('n');
        }
        return enc_buf.toString();
    }

    protected void saveUserAnnotations(Hashtable params) throws StatusException {
        if (!"".equals(params.get("user_annotations")) && null != params.get("user_annotations")) {
            Vector userAnnotations = new Vector();
            userAnnotations.add(params.get("user_annotations"));
            String bagString = PedigreeUtils.makeRDFBag(userAnnotations);
            this.dsi.putMetaData(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:userAnnotations"), bagString);
        }
    }

    protected void saveMetadata(Hashtable params) throws StatusException {
        this.dsi.putMetaData(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:curationStatus"), this.null2Empty((String)params.get("curationStatus")));
        this.dsi.putMetaData(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributionPI"), StringEscapeUtils.escapeXml((String)this.null2Empty((String)params.get("contributionPI"))));
        this.dsi.putMetaData(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributionNotes"), StringEscapeUtils.escapeXml((String)this.null2Empty((String)params.get("contributionNotes"))));
        this.dsi.putMetaData(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributionPIEmail"), StringEscapeUtils.escapeXml((String)this.null2Empty((String)params.get("contributionPIEmail"))));
        this.dsi.putMetaData(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:creator"), StringEscapeUtils.escapeXml((String)this.null2Empty((String)params.get("creator"))));
        this.dsi.putMetaData(new NSProperty("http://purl.org/dc/elements/1.1/:title"), StringEscapeUtils.escapeXml((String)this.null2Empty((String)params.get("title"))));
        this.dsi.putMetaData(new NSProperty("http://purl.org/dc/elements/1.1/:description"), StringEscapeUtils.escapeXml((String)this.null2Empty((String)params.get("description_text"))));
        this.dsi.putMetaData(new NSProperty("http://purl.org/dc/terms/:abstract"), StringEscapeUtils.escapeXml((String)this.null2Empty((String)params.get("abstract"))));
        String basisSetLink = this.null2Empty((String)params.get("basisSetLink"));
        String primaryBasisSetLink = this.null2Empty((String)params.get("primaryBasisSetLink"));
        if (primaryBasisSetLink != null && !"".equals(primaryBasisSetLink)) {
            this.dsi.putMetaData(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:basisSetLink"), basisSetLink);
            this.dsi.putMetaData(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:primaryBasisSetLink"), primaryBasisSetLink);
        }
        if (params.containsKey("contributionURL")) {
            this.dsi.putMetaData(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:contributionURL"), StringEscapeUtils.escapeXml((String)this.null2Empty((String)params.get("contributionURL"))));
        }
    }

    protected void saveCurationAnnotations(Hashtable params, DSI portalUserDSI, DSI dsiToUse, String errorMessage) throws StatusException, Exception {
        DSIProperty prop = dsiToUse.getMetaData(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:curationAnnotations"));
        String bagString = prop.getPropertyAsXMLString();
        Vector<String> curationAnnotations = new Vector<String>();
        PedigreeUtils.parseBag(bagString, curationAnnotations);
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, MMM d, ''yy", Locale.US);
        String curationString = portalUserDSI.getUser() + " (" + formatter.format(new Date()) + ") : " + params.get("new_curation_annotation");
        if (errorMessage != null && errorMessage.length() > 0) {
            curationString = curationString + "    Error: " + errorMessage;
        }
        curationAnnotations.add(0, curationString);
        bagString = PedigreeUtils.makeRDFBag(curationAnnotations);
        dsiToUse.putMetaData(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:curationAnnotations"), bagString);
    }

    protected void saveReferences(Hashtable params) throws StatusException, IOException {
        Element referenceDocument = new Element("reference", "http://purl.oclc.org/NET/EMSL/BSE");
        Element element = new Element("format", "http://purl.org/dc/elements/1.1/");
        element.addContent("chemical/x-cmcs-reference");
        referenceDocument.addContent(element);
        element = new Element("author", "http://purl.oclc.org/NET/EMSL/BSE");
        referenceDocument.addContent(element);
        element = new Element("title", "http://purl.oclc.org/NET/EMSL/BSE");
        referenceDocument.addContent(element);
        element = new Element("journal", "http://purl.oclc.org/NET/EMSL/BSE");
        referenceDocument.addContent(element);
        element = new Element("year", "http://purl.oclc.org/NET/EMSL/BSE");
        referenceDocument.addContent(element);
        element = new Element("volume", "http://purl.oclc.org/NET/EMSL/BSE");
        referenceDocument.addContent(element);
        element = new Element("pages", "http://purl.oclc.org/NET/EMSL/BSE");
        referenceDocument.addContent(element);
        String references = this.null2Empty((String)params.get("references"));
        StringBuffer referenceNoPounds = new StringBuffer();
        String[] lines = references.split("#");
        String lastLine = null;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null || "".equals(lines[i])) continue;
            referenceNoPounds.append(lines[i].trim() + "\n");
            lastLine = lines[i];
        }
        referenceNoPounds.append("\n");
        if (referenceNoPounds.length() == 0) {
            referenceNoPounds = new StringBuffer(references);
        }
        element = new Element("notes", "http://purl.oclc.org/NET/EMSL/BSE");
        element.addContent(referenceNoPounds.toString());
        referenceDocument.addContent(element);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLOutputter serializer = new XMLOutputter();
        serializer.output(referenceDocument, (OutputStream)os);
        String bsString = os.toString();
        String path = this.dsi.getPath();
        int index = path.lastIndexOf(47);
        String collection = path.substring(0, index);
        collection = collection.replaceFirst("/sam", "");
        String gbsFileName = path.substring(index + 1);
        gbsFileName = gbsFileName.replaceAll("\\.xml", "");
        this.loadProperties();
        String serverURL = this.mProperties.getProperty("BseDataServer");
        this.dsi = gbsFileName.endsWith("-ECP") ? this.getDownloadDSI(serverURL + collection + "/" + gbsFileName + "-REF.xml") : this.getDownloadDSI(serverURL + collection + "/" + gbsFileName + "-BS-REF.xml");
        this.dsi.putDataSet(bsString);
    }

    protected String saveBSData(Hashtable params, String url, DSI portalUserDSI) {
        String msg;
        String msg2;
        String errorMSG = "";
        String basisSetType = null;
        String effectivePotentialsLink = null;
        String ecpType = null;
        try {
            String folderURL = DSI.splitUrl(url)[0];
            this.dsi = this.getDownloadDSI(folderURL);
            Vector<NSProperty> propsToSearch = new Vector<NSProperty>();
            propsToSearch.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:basisSetType"));
            propsToSearch.add(new NSProperty("http://purl.oclc.org/NET/EMSL/BSE:ecpType"));
            propsToSearch.add(new NSProperty("http://purl.oclc.org/NET/cmcs/schema/:effectivePotentialsLink"));
            String resourceUrl2 = null;
            Hashtable propcoll = null;
            Iterator dsiPropIt = null;
            Iterator propit = null;
            DSIProperty dsiProp = null;
            String propVal = null;
            DSI resourceDSI = this.getDownloadDSI(url);
            Hashtable properties = resourceDSI.searchMetaData(propsToSearch, propsToSearch, 1, "*");
            if (properties != null) {
                for (String resourceUrl2 : properties.keySet()) {
                    propcoll = (Hashtable)properties.get(resourceUrl2);
                    dsiPropIt = propcoll.values().iterator();
                    while (dsiPropIt.hasNext()) {
                        dsiProp = (DSIProperty)dsiPropIt.next();
                        dsiPropIt.remove();
                        propVal = dsiProp.getPropertyAsString().trim();
                        if (propVal.length() == 0) {
                            propVal = dsiProp.getPropertyAsXMLString(true).trim();
                        }
                        if (propVal == null || "".equals(propVal)) continue;
                        if ("basisSetType".equals(dsiProp.getLocalName()) || "ecpType".equals(dsiProp.getLocalName())) {
                            basisSetType = propVal;
                        }
                        if (!"effectivePotentialsLink".equals(dsiProp.getLocalName())) continue;
                        effectivePotentialsLink = propVal;
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        org.w3c.dom.Document elementDoc = db.parse(new ByteArrayInputStream(propVal.getBytes()));
                        NodeList referenceList = elementDoc.getElementsByTagName("href");
                        int size = referenceList.getLength();
                        for (int i = 0; i < size; ++i) {
                            Node referenceNode = referenceList.item(i);
                            if (referenceNode == null) continue;
                            NamedNodeMap attributes = referenceNode.getAttributes();
                            Node hrefAttribute = attributes.getNamedItem("xlink:href");
                            effectivePotentialsLink = hrefAttribute.getNodeValue();
                            hrefAttribute = attributes.getNamedItem("xlink:type");
                            ecpType = hrefAttribute.getNodeValue();
                        }
                    }
                }
            }
        }
        catch (StatusException statusExc) {
            statusExc.printStackTrace();
            errorMSG = msg2 = statusExc.getImprovedMessage();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            errorMSG = msg2 = exc.getLocalizedMessage();
        }
        String basisSetData = null;
        try {
            if ("orbital".equals(basisSetType) || "polarization".equals(basisSetType) || "diffuse".equals(basisSetType) || "rydberg".equals(basisSetType) || "tight".equals(basisSetType) || "ecporb".equals(basisSetType) || "dftcfit".equals(basisSetType) || "dftorb".equals(basisSetType) || "dftxfit".equals(basisSetType)) {
                basisSetData = (String)params.get(basisSetType);
            } else if ("ecpType".equals(basisSetType) || "scalar".equals(basisSetType)) {
                basisSetData = (String)params.get("ecps");
            } else {
                errorMSG = "Could not recognize basis set data of type: " + basisSetType;
            }
            if (basisSetData != null) {
                XMLOutputter outputter;
                String title = (String)params.get("title");
                String description = (String)params.get("description_text");
                String filename = url.substring(url.lastIndexOf(47) + 1, url.lastIndexOf(".xml"));
                Vector xmlBasisSetData = this.nwchem2Xml(title, filename, basisSetData, description);
                Document doc = (Document)xmlBasisSetData.get(0);
                Element root = doc.getRootElement();
                Element element = root.getChild("basisSetType", Namespace.getNamespace("http://purl.oclc.org/NET/EMSL/BSE"));
                if (element != null) {
                    ArrayList<Text> content = new ArrayList<Text>();
                    content.add(new Text(basisSetType));
                    element.setContent(content);
                }
                if (ecpType != null && effectivePotentialsLink != null) {
                    element = new Element("effectivePotentialsLink", "http://purl.oclc.org/NET/EMSL/BSE");
                    element.setAttribute("type", ecpType, Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink"));
                    element.setAttribute("href", effectivePotentialsLink, Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink"));
                    root.addContent(element);
                }
                if ((basisSetData = (outputter = new XMLOutputter()).outputString(doc)) != null) {
                    portalUserDSI.putDataSet(basisSetData);
                }
            }
        }
        catch (StatusException statusExc) {
            statusExc.printStackTrace();
            errorMSG = msg = statusExc.getImprovedMessage();
        }
        catch (FormatException fExc) {
            fExc.printStackTrace();
            errorMSG = msg = "Basis Set Format Exception : " + fExc.getLocalizedMessage();
        }
        catch (IOException ioExc) {
            ioExc.printStackTrace();
            errorMSG = msg = "IO Exception : " + ioExc.getLocalizedMessage();
        }
        return errorMSG;
    }

    protected String null2Empty(String s) {
        if (null == s) {
            return "";
        }
        return s;
    }

    private DSI getDownloadDSI(String url) {
        DSI dsi = new DSI(url, "bsecontrib", new String(this.bsePA.getPassword()));
        return dsi;
    }

    private DSI getDSI(String url, PasswordAuthentication pa) {
        DSI dsi = new DSI(url, pa.getUserName(), new String(pa.getPassword()));
        return dsi;
    }

    protected void loadProperties() {
        if (this.mProperties == null) {
            try {
                this.mProperties = BSEProperties.getBSEProperties();
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("BseServiceConfig.properties");
                if (inputStream == null) {
                    this.mProperties = null;
                    this.getLogger().severe("Unable to load properties");
                } else {
                    this.mProperties.load(inputStream);
                }
            }
            catch (IOException iox) {
                this.mProperties = null;
                this.getLogger().severe("Unable to load properties");
            }
        }
    }

    protected Vector nwchem2Xml(String bsName, String xmlFileName, String fileContents, String description) throws FormatException, IOException {
        xmlFileName = xmlFileName.toUpperCase();
        xmlFileName = xmlFileName.replaceAll("[\\s,\\(\\)\\/\\\\]", "");
        xmlFileName = xmlFileName.replaceAll("\\*", "S");
        xmlFileName = xmlFileName.replaceAll("\\+", "P");
        if (fileContents != null) {
            StringBufferInputStream fileStream = new StringBufferInputStream(fileContents);
            NWChemInputToBasisXml converter = new NWChemInputToBasisXml();
            return converter.convert(bsName, xmlFileName, "Spherical", description, fileStream);
        }
        return null;
    }

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass().getPackage().getName());
    }
}

