/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.Callable;
import org.apache.ivy.plugins.namespace.NamespaceRule;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import xsbt.boot.AppID;
import xsbt.boot.Application$;
import xsbt.boot.BootConfiguration$;
import xsbt.boot.BootFilteredLoader;
import xsbt.boot.ComponentProvider;
import xsbt.boot.IvyOptions;
import xsbt.boot.Launch$$anon$2;
import xsbt.boot.Launch$$anon$3;
import xsbt.boot.Launch$$anon$4;
import xsbt.boot.Launch$$anon$6;
import xsbt.boot.Launch$$anonfun$1;
import xsbt.boot.Launch$$anonfun$5;
import xsbt.boot.Launch$$anonfun$jnaLoader$1;
import xsbt.boot.Locks$;
import xsbt.boot.ModuleDefinition;
import xsbt.boot.Pre$;
import xsbt.boot.Pre$JarFilter$;
import xsbt.boot.RetrievedModule;
import xsbt.boot.Update;
import xsbt.boot.UpdateApp;
import xsbt.boot.UpdateConfiguration;
import xsbt.boot.UpdateResult;
import xsbt.boot.UpdateScala;
import xsbt.boot.Value$;
import xsbti.AppProvider;
import xsbti.ApplicationID;
import xsbti.GlobalLock;
import xsbti.Launcher;
import xsbti.Repository;
import xsbti.ScalaProvider;

public final class Launch
implements Launcher {
    private final File bootDirectory;
    private final boolean lockBoot;
    private final IvyOptions ivyOptions;
    private final NamespaceRule scalaProviders$757a20a0;
    private final BootFilteredLoader bootLoader;
    private final ClassLoader topLoader;
    private final Option updateLockFile;

    public final File bootDirectory() {
        return this.bootDirectory;
    }

    public final ScalaProvider getScala(String string) {
        return this.getScala(string, "");
    }

    public final ScalaProvider getScala(String string, String string2) {
        return this.getScala(string, string2, BootConfiguration$.MODULE$.ScalaOrg());
    }

    public final ScalaProvider getScala(String string, String string2, String string3) {
        return (ScalaProvider)this.scalaProviders$757a20a0.apply(new Tuple2(string3, string), string2);
    }

    public final AppProvider app(ApplicationID applicationID, String string) {
        return this.app(applicationID, Option$.apply(string));
    }

    public final AppProvider app(ApplicationID applicationID, Option option) {
        Option option2 = option;
        ApplicationID applicationID2 = applicationID;
        Launch launch = this;
        return (AppProvider)launch.locked(new Launch$$anon$2(launch, applicationID2, option2, false));
    }

    public final ClassLoader topLoader() {
        return this.topLoader;
    }

    public final GlobalLock globalLock() {
        return Locks$.MODULE$;
    }

    public final File ivyHome() {
        return (File)Pre$.orNull(this.ivyOptions.ivyHome());
    }

    public final Repository[] ivyRepositories() {
        return (Repository[])this.ivyOptions.repositories().toArray(ClassManifest$.classType(Repository.class));
    }

    public final boolean isOverrideRepositories() {
        return this.ivyOptions.isOverrideRepositories();
    }

    public final String[] checksums() {
        return (String[])this.ivyOptions.checksums().toArray(ClassManifest$.classType(String.class));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClassLoader jnaLoader$2f324eef() {
        Option option;
        None$ none$;
        AppID appID = new AppID("net.java.dev.jna", "jna", "3.2.3", "", (String[])Pre$.toArray(Nil$.MODULE$, ClassManifest$.classType(String.class)), false, Pre$.MODULE$.array(Nil$.MODULE$));
        this.makeConfiguration(BootConfiguration$.MODULE$.ScalaOrg(), None$.MODULE$);
        File file2 = Launch.appDirectory(new File(this.bootDirectory(), BootConfiguration$.MODULE$.baseDirectoryName(BootConfiguration$.MODULE$.ScalaOrg(), None$.MODULE$)), appID);
        ModuleDefinition moduleDefinition = this.appModule(appID, None$.MODULE$, false, "jna");
        if (!file2.exists()) {
            none$ = None$.MODULE$;
            return (ClassLoader)none$.getOrElse(new Launch$$anonfun$jnaLoader$1(this, file2, moduleDefinition));
        }
        try {
            option = new Some(this.makeLoader$1(file2, moduleDefinition));
        }
        catch (Exception exception) {
            option = None$.MODULE$;
        }
        none$ = option;
        return (ClassLoader)none$.getOrElse(new Launch$$anonfun$jnaLoader$1(this, file2, moduleDefinition));
    }

    private static Object checkLoader(ClassLoader classLoader, ModuleDefinition moduleDefinition, Seq seq, Object object) {
        Iterable iterable = Pre$.getMissing(classLoader, seq);
        if (iterable.isEmpty()) {
            return object;
        }
        throw moduleDefinition.retrieveCorrupt(iterable);
    }

    private UpdateConfiguration makeConfiguration(String string, Option option) {
        return new UpdateConfiguration(this.bootDirectory(), this.ivyOptions.ivyHome(), string, option, this.ivyOptions.repositories(), this.ivyOptions.checksums());
    }

    public final File scalaHome(String string, Option option) {
        return new File(this.bootDirectory(), BootConfiguration$.MODULE$.baseDirectoryName(string, option));
    }

    private Object locked(Callable callable) {
        return Locks$.MODULE$.apply((File)Pre$.orNull(this.updateLockFile), callable);
    }

    public final ScalaProvider getScalaProvider(String string, String string2, String string3) {
        return (ScalaProvider)this.locked(new Launch$$anon$3(this, string, string2, string3));
    }

    public final Option existing(ModuleDefinition moduleDefinition, String string, Option option, Function1 function1) {
        Launch$$anon$4 launch$$anon$4 = new Launch$$anon$4(string, option);
        return Predef$.refArrayOps((RetrievedModule[])Predef$.refArrayOps(Pre$.wrapNull(this.bootDirectory().listFiles(launch$$anon$4))).flatMap(new Launch$$anonfun$5(this, moduleDefinition, function1), Array$.canBuildFrom(ClassManifest$.classType(RetrievedModule.class)))).headOption();
    }

    public static File appDirectory(File file2, ApplicationID applicationID) {
        return new File(file2, BootConfiguration$.appDirectoryName(applicationID, File.separator));
    }

    public final ComponentProvider componentProvider(File file2) {
        return new ComponentProvider(file2, this.lockBoot);
    }

    public final ModuleDefinition appModule(ApplicationID applicationID, Option option, boolean bl, String string) {
        UpdateConfiguration updateConfiguration = this.makeConfiguration(BootConfiguration$.MODULE$.ScalaOrg(), option);
        UpdateApp updateApp = new UpdateApp(Application$.apply(applicationID), bl ? (List)Value$.get$3652317c$286a377a(this.ivyOptions.classifiers().app$33e6f9b0$5e1c4a78()) : Nil$.MODULE$, string);
        String string2 = new StringBuilder().append((Object)applicationID.name()).append((Object)" ").append((Object)applicationID.version()).toString();
        File[] fileArray = applicationID.classpathExtra();
        return new ModuleDefinition(updateConfiguration, fileArray, updateApp, string2);
    }

    public final ModuleDefinition scalaModule(String string, String string2) {
        UpdateConfiguration updateConfiguration = this.makeConfiguration(string, new Some(string2));
        UpdateScala updateScala = new UpdateScala((List)Value$.get$3652317c$286a377a(this.ivyOptions.classifiers().forScala$33e6f9b0$5e1c4a78()));
        String string3 = new StringBuilder().append((Object)"Scala ").append((Object)string2).toString();
        File[] fileArray = Pre$.MODULE$.array(Nil$.MODULE$);
        return new ModuleDefinition(updateConfiguration, fileArray, updateScala, string3);
    }

    public static Option update(ModuleDefinition moduleDefinition, String string) {
        UpdateResult updateResult = new Update(moduleDefinition.configuration()).apply(moduleDefinition.target(), string);
        if (updateResult.success()) {
            return updateResult.scalaVersion();
        }
        throw moduleDefinition.retrieveFailed();
    }

    public final ClassLoader makeLoader$1(File file2, ModuleDefinition moduleDefinition) {
        URL[] uRLArray = Pre$.toURLs(Pre$.wrapNull(file2.listFiles(Pre$JarFilter$.MODULE$)));
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, (ClassLoader)this.bootLoader);
        String string = "com.sun.jna.Function";
        return (ClassLoader)Launch.checkLoader(uRLClassLoader, moduleDefinition, Nil$.MODULE$.$colon$colon(string), uRLClassLoader);
    }

    public final RetrievedModule retrieve$1(Option option, ModuleDefinition moduleDefinition, Function1 function1) {
        Option option2 = Launch.update(moduleDefinition, "");
        Option option3 = Pre$.strictOr(option, option2);
        return new RetrievedModule(true, moduleDefinition, option2, (List)function1.apply(this.scalaHome(BootConfiguration$.MODULE$.ScalaOrg(), option3)));
    }

    public final ScalaProvider provider$1(RetrievedModule retrievedModule, String string, File file2) {
        File file3 = file2;
        ClassLoader classLoader = this.topLoader();
        RetrievedModule retrievedModule2 = retrievedModule;
        String string2 = string;
        Launch launch = this;
        Launch$$anon$6 launch$$anon$6 = new Launch$$anon$6(launch, string2, retrievedModule2, classLoader, file3);
        return (ScalaProvider)Launch.checkLoader(launch$$anon$6.loader(), retrievedModule.definition(), BootConfiguration$.MODULE$.TestLoadScalaClasses(), launch$$anon$6);
    }

    public Launch(File file2, boolean bl, IvyOptions ivyOptions) {
        this.bootDirectory = file2;
        this.lockBoot = bl;
        this.ivyOptions = ivyOptions;
        file2.mkdirs();
        this.scalaProviders$757a20a0 = new NamespaceRule(new Launch$$anonfun$1(this));
        this.bootLoader = new BootFilteredLoader(this.getClass().getClassLoader());
        this.topLoader = this.jnaLoader$2f324eef();
        this.updateLockFile = bl ? new Some(new File(file2, "sbt.boot.lock")) : None$.MODULE$;
    }
}

