/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "cmpiOpenDRIM_SSHSettingData.h"

CMPIObjectPath* SSH_OpenDRIM_SSHSettingData_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_SSHSettingData& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_SSHSettingData_classnames[0], OpenDRIM_SSHSettingData_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* SSH_OpenDRIM_SSHSettingData_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_SSHSettingData& instance) {
	_E_;
	Objectpath op(broker, SSH_OpenDRIM_SSHSettingData_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.Generation_isNULL)
		ci.setProperty("Generation", instance.Generation);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.ConfigurationName_isNULL)
		ci.setProperty("ConfigurationName", instance.ConfigurationName);

	if (!instance.ChangeableType_isNULL)
		ci.setProperty("ChangeableType", instance.ChangeableType);

	if (!instance.EnabledSSHVersions_isNULL)
		ci.setProperty("EnabledSSHVersions", instance.EnabledSSHVersions);

	if (!instance.OtherEnabledSSHVersion_isNULL)
		ci.setProperty("OtherEnabledSSHVersion", instance.OtherEnabledSSHVersion);

	if (!instance.SSHVersion_isNULL)
		ci.setProperty("SSHVersion", instance.SSHVersion);

	if (!instance.OtherSSHVersion_isNULL)
		ci.setProperty("OtherSSHVersion", instance.OtherSSHVersion);

	if (!instance.EnabledEncryptionAlgorithms_isNULL)
		ci.setProperty("EnabledEncryptionAlgorithms", instance.EnabledEncryptionAlgorithms);

	if (!instance.OtherEnabledEncryptionAlgorithm_isNULL)
		ci.setProperty("OtherEnabledEncryptionAlgorithm", instance.OtherEnabledEncryptionAlgorithm);

	if (!instance.EncryptionAlgorithm_isNULL)
		ci.setProperty("EncryptionAlgorithm", instance.EncryptionAlgorithm);

	if (!instance.OtherEncryptionAlgorithm_isNULL)
		ci.setProperty("OtherEncryptionAlgorithm", instance.OtherEncryptionAlgorithm);

	if (!instance.IdleTimeout_isNULL)
		ci.setProperty("IdleTimeout", instance.IdleTimeout);

	if (!instance.KeepAlive_isNULL)
		ci.setProperty("KeepAlive", instance.KeepAlive);

	if (!instance.ForwardX11_isNULL)
		ci.setProperty("ForwardX11", instance.ForwardX11);

	if (!instance.Compression_isNULL)
		ci.setProperty("Compression", instance.Compression);

	_L_;
	return ci.getHdl();
}

void SSH_OpenDRIM_SSHSettingData_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_SSHSettingData& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void SSH_OpenDRIM_SSHSettingData_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_SSHSettingData& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("Generation", instance.Generation) == OK)
		instance.Generation_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("ConfigurationName", instance.ConfigurationName) == OK)
		instance.ConfigurationName_isNULL = false;

	if (inst.getProperty("ChangeableType", instance.ChangeableType) == OK)
		instance.ChangeableType_isNULL = false;

	if (inst.getProperty("EnabledSSHVersions", instance.EnabledSSHVersions) == OK)
		instance.EnabledSSHVersions_isNULL = false;

	if (inst.getProperty("OtherEnabledSSHVersion", instance.OtherEnabledSSHVersion) == OK)
		instance.OtherEnabledSSHVersion_isNULL = false;

	if (inst.getProperty("SSHVersion", instance.SSHVersion) == OK)
		instance.SSHVersion_isNULL = false;

	if (inst.getProperty("OtherSSHVersion", instance.OtherSSHVersion) == OK)
		instance.OtherSSHVersion_isNULL = false;

	if (inst.getProperty("EnabledEncryptionAlgorithms", instance.EnabledEncryptionAlgorithms) == OK)
		instance.EnabledEncryptionAlgorithms_isNULL = false;

	if (inst.getProperty("OtherEnabledEncryptionAlgorithm", instance.OtherEnabledEncryptionAlgorithm) == OK)
		instance.OtherEnabledEncryptionAlgorithm_isNULL = false;

	if (inst.getProperty("EncryptionAlgorithm", instance.EncryptionAlgorithm) == OK)
		instance.EncryptionAlgorithm_isNULL = false;

	if (inst.getProperty("OtherEncryptionAlgorithm", instance.OtherEncryptionAlgorithm) == OK)
		instance.OtherEncryptionAlgorithm_isNULL = false;

	if (inst.getProperty("IdleTimeout", instance.IdleTimeout) == OK)
		instance.IdleTimeout_isNULL = false;

	if (inst.getProperty("KeepAlive", instance.KeepAlive) == OK)
		instance.KeepAlive_isNULL = false;

	if (inst.getProperty("ForwardX11", instance.ForwardX11) == OK)
		instance.ForwardX11_isNULL = false;

	if (inst.getProperty("Compression", instance.Compression) == OK)
		instance.Compression_isNULL = false;

	_L_;
}

