#!/usr/bin/perl
# openvas find duplicate script_id
# (C) 2008 Vlatko Kosturjak <kost@linux.hr>. GPL v2+

use strict;

my %ids={};

foreach my $file (<*.nasl>) {
	open (FILE,"<$file") or die "cannot open file for reading: $!";
	my $i=0;
	while (<FILE>) {
		next if (/^\w*#/);
		if (/script_id/) {
			if (/script_id\ *\(\ *(\d+)\ *\)/) {
				if (defined($ids{$1})) {
					print "Duplicate $file with $ids{$1}\n";
				} else {
					$ids{$1}="$file";
					$i++;
				}
				
			} else {
			 	print "$file: probably syntax error in script_id def\n";
			}

		}
	}
	print "$file: double script_id definition\n" if ($i>1); 
	print "$file: no valid script_id definition\n" if ($i==0);
	close (FILE);
}
