# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 179-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53734);
 script_cve_id("CVE-2002-0838");
 script_bugtraq_id(5808);
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 179-1 (gnome-gv)";
 script_name(name);

 desc = "The remote host is missing an update to gnome-gv
announced via advisory DSA 179-1.

Zen-parse discovered a buffer overflow in gv, a PostScript and PDF
viewer for X11.  The same code is present in gnome-gv.  This problem
is triggered by scanning the PostScript file and can be exploited by
an attacker sending a malformed PostScript or PDF file.  The attacker
is able to cause arbitrary code to be run with the privileges of the
victim.

This problem has been fixed in version 1.1.96-3.1 for the current
stable distribution (woody), in version 0.82-2.1 for the old stable
distribution (potato) and version 1.99.7-9 for the unstable
distribution (sid).

We recommend that you upgrade your gnome-gv package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20179-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 179-1 (gnome-gv)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnome-gv", ver:"0.82-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnome-gv", ver:"1.1.96-3.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
